/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.TextureBuffer;
import ru.m210projects.Build.Types.Tile;

public class IndexedTileData
extends TileData {
    public final TextureBuffer data;
    public final boolean hasalpha;
    public final int width;
    public final int height;
    public final boolean clamped;

    public IndexedTileData(Tile tile, boolean clamped, boolean alpha, int expflag) {
        byte[] data = tile.data;
        int tsizx = tile.getWidth();
        int tsizy = tile.getHeight();
        if (data != null && (data.length == 0 || tile.getSize() > data.length)) {
            data = null;
        }
        int xsiz = tsizx;
        int ysiz = tsizy;
        if ((expflag & 1) != 0) {
            xsiz = this.calcSize(tsizx);
        }
        if ((expflag & 2) != 0) {
            ysiz = this.calcSize(tsizy);
        }
        TextureBuffer buffer = IndexedTileData.getTmpBuffer(xsiz * ysiz);
        buffer.clear();
        boolean hasalpha = false;
        if (data == null) {
            buffer.put(0, (byte)0);
            tsizy = 1;
            tsizx = 1;
            hasalpha = true;
        } else {
            int dptr = 0;
            int sptr = 0;
            int xoffs = xsiz;
            if (clamped) {
                int y = ysiz - 1;
                while (y >= 0) {
                    sptr = y >= tsizy ? 0 : tsizx;
                    dptr = xsiz * y + (sptr - 1);
                    int x = sptr;
                    while (x < xsiz) {
                        buffer.put(dptr++, (byte)0);
                        ++x;
                    }
                    --y;
                }
                sptr = 0;
                int i = 0;
                while (i < tsizx) {
                    dptr = i;
                    int j = 0;
                    while (j < tsizy) {
                        buffer.put(dptr, data[sptr++]);
                        dptr += xoffs;
                        ++j;
                    }
                    ++i;
                }
                hasalpha = true;
            } else {
                int len = data.length;
                int i = 0;
                while (i < xoffs) {
                    int p = 0;
                    dptr = i;
                    int j = 0;
                    while (j < ysiz) {
                        buffer.put(dptr, data[sptr + p++]);
                        dptr += xoffs;
                        if (p >= tsizy) {
                            p = 0;
                        }
                        ++j;
                    }
                    if ((sptr += tsizy) >= len) {
                        sptr = 0;
                    }
                    ++i;
                }
            }
        }
        this.width = xsiz;
        this.height = ysiz;
        this.hasalpha = hasalpha;
        this.data = buffer;
        this.clamped = clamped;
    }

    @Override
    public int getGLType() {
        return 5121;
    }

    @Override
    public ByteBuffer getPixels() {
        return this.data.getBuffer();
    }

    @Override
    public int getGLInternalFormat() {
        return this.hasalpha ? 6408 : 6407;
    }

    @Override
    public int getGLFormat() {
        return 6409;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public TileData.PixelFormat getPixelFormat() {
        return TileData.PixelFormat.Pal8;
    }

    @Override
    public boolean hasAlpha() {
        return this.hasalpha;
    }

    @Override
    public boolean isClamped() {
        return this.clamped;
    }

    @Override
    public boolean isHighTile() {
        return false;
    }
}

