/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.AWT;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.Pool;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import ru.m210projects.Build.desktop.AWT.JCanvas;
import ru.m210projects.Build.desktop.AWT.JDisplay;
import ru.m210projects.Build.desktop.AWT.MouseInterface;

public class AWTMouse
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
MouseInterface {
    Pool<TouchEvent> usedTouchEvents = new Pool<TouchEvent>(16, 1000){

        @Override
        protected TouchEvent newObject() {
            return new TouchEvent();
        }
    };
    List<TouchEvent> touchEvents = new ArrayList<TouchEvent>();
    int x = 0;
    int y = 0;
    int deltaX = 0;
    int deltaY = 0;
    int wheel = 0;
    boolean touchDown = false;
    boolean justTouched = false;
    boolean catched = false;
    Cursor noCursor;
    Cursor defCursor = Cursor.getDefaultCursor();
    boolean mouseInside;
    boolean[] justPressedButtons = new boolean[5];
    IntSet pressedButtons = new IntSet();
    protected Robot robot;
    protected JDisplay display;

    public AWTMouse(JDisplay display) {
        try {
            this.robot = new Robot(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.display = display;
        JCanvas canvas = display.getCanvas();
        if (canvas != null) {
            canvas.removeMouseListener(this);
            canvas.removeMouseMotionListener(this);
            canvas.removeMouseWheelListener(this);
        }
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        canvas.addMouseWheelListener(this);
    }

    @Override
    public void setWindowHandle() {
    }

    private void setMousePosition(int x, int y) {
        if (this.robot != null) {
            this.robot.mouseMove(x, y);
        }
    }

    @Override
    public void setCursorPosition(int x, int y) {
        this.x = x;
        this.y = y;
        JCanvas canvas = this.display.getCanvas();
        this.setMousePosition(x += canvas.getLocationOnScreen().x, y += canvas.getLocationOnScreen().y);
    }

    @Override
    public void reset() {
        JCanvas canvas = this.display.getCanvas();
        this.touchDown = false;
        this.x = ((Component)canvas).getWidth() / 2;
        this.y = ((Component)canvas).getHeight() / 2;
        this.wheel = 0;
        this.justTouched = false;
        this.pressedButtons.clear();
        Arrays.fill(this.justPressedButtons, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long processEvents(InputProcessor processor) {
        AWTMouse aWTMouse = this;
        synchronized (aWTMouse) {
            if (this.justTouched) {
                this.justTouched = false;
                Arrays.fill(this.justPressedButtons, false);
            }
            long currentEventTimeStamp = -1L;
            if (processor != null) {
                int len = this.touchEvents.size();
                int i = 0;
                while (i < len) {
                    TouchEvent e = this.touchEvents.get(i);
                    currentEventTimeStamp = e.timeStamp;
                    switch (e.type) {
                        case 0: {
                            processor.touchDown(e.x, e.y, e.pointer, e.button);
                            this.justPressedButtons[e.button] = true;
                            this.justTouched = true;
                            break;
                        }
                        case 1: {
                            processor.touchUp(e.x, e.y, e.pointer, e.button);
                            break;
                        }
                        case 2: {
                            processor.touchDragged(e.x, e.y, e.pointer);
                            break;
                        }
                        case 3: {
                            processor.mouseMoved(e.x, e.y);
                            break;
                        }
                        case 4: {
                            processor.scrolled(e.scrollAmount);
                        }
                    }
                    this.usedTouchEvents.free(e);
                    ++i;
                }
            } else {
                int len = this.touchEvents.size();
                int i = 0;
                while (i < len) {
                    TouchEvent event = this.touchEvents.get(i);
                    if (event.type == 0 && event.button != -1) {
                        this.justPressedButtons[event.button] = true;
                        this.justTouched = true;
                    }
                    this.usedTouchEvents.free(event);
                    ++i;
                }
            }
            if (this.touchEvents.isEmpty()) {
                this.wheel = 0;
            }
            this.touchEvents.clear();
            return currentEventTimeStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        AWTMouse aWTMouse = this;
        synchronized (aWTMouse) {
            TouchEvent event = this.usedTouchEvents.obtain();
            event.pointer = 0;
            event.x = e.getX();
            event.y = e.getY();
            event.type = 2;
            event.timeStamp = System.nanoTime();
            this.touchEvents.add(event);
            this.deltaX += event.x - this.x;
            this.deltaY += event.y - this.y;
            this.x = event.x;
            this.y = event.y;
            this.checkCatched(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent e) {
        AWTMouse aWTMouse = this;
        synchronized (aWTMouse) {
            TouchEvent event = this.usedTouchEvents.obtain();
            event.pointer = 0;
            event.x = e.getX();
            event.y = e.getY();
            event.type = 3;
            event.timeStamp = System.nanoTime();
            this.touchEvents.add(event);
            this.deltaX += event.x - this.x;
            this.deltaY += event.y - this.y;
            this.x = event.x;
            this.y = event.y;
            this.checkCatched(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.mouseInside = true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        this.mouseInside = true;
        this.checkCatched(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseInside = false;
        this.checkCatched(e);
    }

    private void checkCatched(MouseEvent e) {
        if (!this.display.isActive()) {
            return;
        }
        JCanvas canvas = this.display.getCanvas();
        if (this.catched && canvas.isShowing() && (e.getX() < 0 || e.getX() >= ((Component)canvas).getWidth() || e.getY() < 0 || e.getY() >= ((Component)canvas).getHeight())) {
            this.setCursorPosition(((Component)canvas).getWidth() / 2, ((Component)canvas).getHeight() / 2);
            this.showCursor(false);
        }
    }

    @Override
    public void showCursor(boolean visible) {
        if (this.display == null) {
            return;
        }
        if (!visible) {
            if (this.noCursor == null) {
                Toolkit t = Toolkit.getDefaultToolkit();
                BufferedImage i = new BufferedImage(16, 16, 2);
                this.noCursor = t.createCustomCursor(i, new Point(0, 0), "none");
            }
            if (this.display.m_frame.getContentPane().getCursor() != this.noCursor) {
                this.display.m_frame.getContentPane().getInputContext().selectInputMethod(Locale.US);
                this.display.m_frame.getContentPane().setCursor(this.noCursor);
            }
        } else if (this.display.m_frame.getContentPane().getCursor() != this.defCursor) {
            this.display.m_frame.getContentPane().setCursor(this.defCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        AWTMouse aWTMouse = this;
        synchronized (aWTMouse) {
            TouchEvent event = this.usedTouchEvents.obtain();
            event.pointer = 0;
            event.x = e.getX();
            event.y = e.getY();
            event.type = 0;
            event.button = this.toGdxButton(e.getButton());
            event.timeStamp = System.nanoTime();
            this.touchEvents.add(event);
            this.deltaX += event.x - this.x;
            this.deltaY += event.y - this.y;
            this.x = event.x;
            this.y = event.y;
            this.touchDown = true;
            this.pressedButtons.add(event.button);
        }
    }

    private int toGdxButton(int button) {
        if (button == 1) {
            return 0;
        }
        if (button == 2) {
            return 2;
        }
        if (button == 3) {
            return 1;
        }
        if (button == 4) {
            return 3;
        }
        if (button == 5) {
            return 4;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        AWTMouse aWTMouse = this;
        synchronized (aWTMouse) {
            TouchEvent event = this.usedTouchEvents.obtain();
            event.pointer = 0;
            event.x = e.getX();
            event.y = e.getY();
            event.button = this.toGdxButton(e.getButton());
            event.type = 1;
            event.timeStamp = System.nanoTime();
            this.touchEvents.add(event);
            this.deltaX += event.x - this.x;
            this.deltaY += event.y - this.y;
            this.x = event.x;
            this.y = event.y;
            this.pressedButtons.remove(event.button);
            if (this.pressedButtons.size == 0) {
                this.touchDown = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        AWTMouse aWTMouse = this;
        synchronized (aWTMouse) {
            TouchEvent event = this.usedTouchEvents.obtain();
            event.pointer = 0;
            event.type = 4;
            event.scrollAmount = e.getWheelRotation();
            event.timeStamp = System.nanoTime();
            this.touchEvents.add(event);
            this.wheel = -event.scrollAmount;
        }
    }

    @Override
    public void setCursorCatched(boolean catched) {
        this.catched = catched;
        this.showCursor(!catched);
        JCanvas canvas = this.display.getCanvas();
        if (catched) {
            this.setCursorPosition(((Component)canvas).getWidth() / 2, ((Component)canvas).getHeight() / 2);
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getDeltaX() {
        int out = this.deltaX;
        this.deltaX = 0;
        return out;
    }

    @Override
    public int getDeltaY() {
        int out = this.deltaY;
        this.deltaY = 0;
        return out;
    }

    @Override
    public boolean isTouched() {
        return this.touchDown;
    }

    @Override
    public boolean justTouched() {
        return this.justTouched;
    }

    @Override
    public boolean isButtonPressed(int button) {
        return this.pressedButtons.contains(button);
    }

    @Override
    public boolean isButtonJustPressed(int button) {
        if (button < 0 || button >= this.justPressedButtons.length) {
            return false;
        }
        return this.justPressedButtons[button];
    }

    @Override
    public int getDWheel() {
        return this.wheel;
    }

    @Override
    public boolean isCursorCatched() {
        return this.catched;
    }

    @Override
    public boolean isInsideWindow() {
        return this.mouseInside;
    }

    class TouchEvent {
        static final int TOUCH_DOWN = 0;
        static final int TOUCH_UP = 1;
        static final int TOUCH_DRAGGED = 2;
        static final int TOUCH_MOVED = 3;
        static final int TOUCH_SCROLLED = 4;
        long timeStamp;
        int type;
        int x;
        int y;
        int pointer;
        int button;
        int scrollAmount;

        TouchEvent() {
        }
    }
}

