/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop;

import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildMessage;

public class DesktopMessage
implements BuildMessage {
    private JOptionPane panel;
    private BuildFrame frame;
    private boolean update;

    public DesktopMessage(boolean update) {
        this.update = update;
    }

    @Override
    public void setFrame(BuildFrame frame) {
        this.frame = frame;
    }

    @Override
    public boolean show(String header, String message, BuildMessage.MessageType type) {
        if (this.panel == null && (this.panel = this.InitPanel()) == null) {
            return false;
        }
        if (message.length() >= 384) {
            message = message.substring(0, 384);
            message = String.valueOf(message) + "...";
        }
        if (this.update) {
            message = "You are using the old version of BuildGdx and have to update it! \r\n \r\n \r\n" + message;
            type = BuildMessage.MessageType.Info;
        }
        switch (type) {
            case Question: 
            case Crash: {
                if (type == BuildMessage.MessageType.Crash) {
                    this.ShowPanel(0, 0, header, String.valueOf(message) + "\r\n \r\n      Do you want to send a crash report?");
                } else {
                    this.ShowPanel(1, 0, header, message);
                }
                Object selectedValue = this.panel.getValue();
                return selectedValue instanceof Integer && (Integer)selectedValue == 0;
            }
            case Info: {
                this.ShowPanel(1, -1, header, message);
                return false;
            }
        }
        return false;
    }

    protected JDialog ShowPanel(int messageType, int optionType, String header, String message) {
        this.panel.setMessageType(messageType);
        this.panel.setMessage(message);
        this.panel.setOptionType(optionType);
        JDialog dialog = this.panel.createDialog(header);
        if (this.frame.icon != null) {
            dialog.setIconImage(Toolkit.getDefaultToolkit().getImage(this.frame.icon));
        }
        this.panel.setBackground(dialog.getBackground());
        dialog.setLocation(this.frame.getX() + (BuildGdx.graphics.getWidth() - dialog.getWidth()) / 2, this.frame.getY() + (BuildGdx.graphics.getHeight() - dialog.getHeight()) / 2);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        dialog.dispose();
        return dialog;
    }

    protected JOptionPane InitPanel() {
        JOptionPane frame = null;
        try {
            frame = new JOptionPane();
            frame.setMessageType(1);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return frame;
    }

    @Override
    public void dispose() {
        this.panel = null;
    }
}

