/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.audio;

import com.badlogic.gdx.backends.lwjgl.LwjglNativesLoader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.EFX10;
import ru.m210projects.Build.desktop.audio.ALAudio;

public class LwjglAL
implements ALAudio {
    private String name;
    private String version;
    private boolean alEfxSupport;
    private int alEffectSlot = -1;
    private int alEffect = -1;

    public LwjglAL() throws Throwable {
        LwjglNativesLoader.load();
        AL.create();
        ALCdevice device = AL.getDevice();
        this.name = ALC10.alcGetString(device, 4101);
        this.version = AL10.alGetString(45058);
        this.alEfxSupport = ALC10.alcIsExtensionPresent(AL.getDevice(), "ALC_EXT_EFX");
        if (this.alEfxSupport) {
            this.alEffectSlot = EFX10.alGenAuxiliaryEffectSlots();
            this.alEffect = EFX10.alGenEffects();
            EFX10.alEffecti(this.alEffect, 32769, 1);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean alIsEFXSupport() {
        return this.alEfxSupport && this.alEffect != -1;
    }

    @Override
    public boolean alIsSoftResamplerSupport() {
        return false;
    }

    @Override
    public String alGetSoftResamplerName(int num) {
        return "Not supported";
    }

    @Override
    public void dispose() {
        if (this.alIsEFXSupport()) {
            EFX10.alDeleteEffects(this.alEffect);
            EFX10.alDeleteAuxiliaryEffectSlots(this.alEffectSlot);
        }
        AL.destroy();
        while (AL.isCreated()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public int alGetError() {
        return AL10.alGetError();
    }

    @Override
    public int alGenBuffers() {
        return AL10.alGenBuffers();
    }

    @Override
    public void setSourceSoftResampler(int sourceId, int value) {
    }

    @Override
    public void setSourceReverb(int sourceId, boolean enable, float delay) {
        if (!this.alIsEFXSupport()) {
            return;
        }
        if (enable) {
            EFX10.alEffectf(this.alEffect, 5, delay);
            EFX10.alAuxiliaryEffectSloti(this.alEffectSlot, 1, this.alEffect);
            this.alSource3i(sourceId, 131078, this.alEffectSlot, 0, 0);
        } else {
            EFX10.alAuxiliaryEffectSloti(this.alEffectSlot, 1, 0);
            this.alSource3i(sourceId, 131078, 0, 0, 0);
        }
    }

    @Override
    public void alDistanceModel(int modelName) {
        AL10.alDistanceModel(modelName);
    }

    @Override
    public int alGetSourcei(int source, int param) {
        return AL10.alGetSourcei(source, param);
    }

    @Override
    public void alSourcei(int source, int param, int value) {
        AL10.alSourcei(source, param, value);
    }

    @Override
    public void alSourcef(int source, int param, float value) {
        AL10.alSourcef(source, param, value);
    }

    @Override
    public void alSource3i(int source, int paramName, int value1, int value2, int value3) {
        AL11.alSource3i(source, paramName, value1, value2, value3);
    }

    @Override
    public void alSource3f(int source, int param, float v1, float v2, float v3) {
        AL10.alSource3f(source, param, v1, v2, v3);
    }

    @Override
    public void alSourceQueueBuffers(int sourceName, int bufferName) {
        AL10.alSourceQueueBuffers(sourceName, bufferName);
    }

    @Override
    public void alSourcePlay(int source) {
        AL10.alSourcePlay(source);
    }

    @Override
    public void alSourcePause(int source) {
        AL10.alSourcePause(source);
    }

    @Override
    public void alSourceStop(int source) {
        AL10.alSourceStop(source);
    }

    @Override
    public void alDeleteBuffers(IntBuffer bufferNames) {
        AL10.alDeleteBuffers(bufferNames);
    }

    @Override
    public void alGenBuffers(IntBuffer bufferNames) {
        AL10.alGenBuffers(bufferNames);
    }

    @Override
    public float alGetSourcef(int source, int param) {
        return AL10.alGetSourcef(source, param);
    }

    @Override
    public int alSourceUnqueueBuffers(int sourceName) {
        return AL10.alSourceUnqueueBuffers(sourceName);
    }

    @Override
    public void alBufferData(int bufferName, int format, ByteBuffer data, int frequency) {
        AL10.alBufferData(bufferName, format, data, frequency);
    }

    @Override
    public void alListener(int paramName, FloatBuffer value) {
        AL10.alListener(paramName, value);
    }

    @Override
    public void alListener3f(int paramName, float v1, float v2, float v3) {
        AL10.alListener3f(paramName, v1, v2, v3);
    }

    @Override
    public int alGenSources() {
        return AL10.alGenSources();
    }

    @Override
    public void alSource(int source, int param, FloatBuffer values) {
        AL10.alSource(source, param, values);
    }

    @Override
    public void alDeleteSources(int sourceId) {
        AL10.alDeleteSources(sourceId);
    }

    @Override
    public int alGetNumResamplers() {
        return 1;
    }

    @Override
    public void alGetSourcefv(int source, int param, FloatBuffer values) {
        AL10.alGetSource(source, param, values);
    }

    @Override
    public float alGetListenerf(int paramName) {
        return AL10.alGetListenerf(paramName);
    }

    @Override
    public int alGetListeneri(int paramName) {
        return AL10.alGetListeneri(paramName);
    }

    @Override
    public void alGetListenerfv(int param, FloatBuffer values) {
        AL10.alGetListener(param, values);
    }
}

