/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.OnSceenDisplay.OSDFunc;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Duke3D.Factory.DukeEngine;
import ru.m210projects.Duke3D.Factory.DukeInput;
import ru.m210projects.Duke3D.Factory.DukeMenuHandler;
import ru.m210projects.Duke3D.Factory.DukeNetwork;
import ru.m210projects.Duke3D.Factory.DukeOSDFunc;
import ru.m210projects.Duke3D.Factory.DukePolymost;
import ru.m210projects.Duke3D.Factory.DukeSliderDrawable;
import ru.m210projects.Duke3D.Factory.DukeSoftware;
import ru.m210projects.Duke3D.Fonts.GameFont;
import ru.m210projects.Duke3D.Fonts.MenuFont;
import ru.m210projects.Duke3D.Fonts.MiniFont;
import ru.m210projects.Duke3D.Fonts.StandartFont;
import ru.m210projects.Duke3D.Main;

public class DukeFactory
extends BuildFactory {
    private Main app;

    public DukeFactory(Main app) {
        super(app.mainGrp);
        this.app = app;
    }

    @Override
    public BuildEngine engine() throws Exception {
        Engine.MAXSECTORS = 4096;
        Engine.MAXWALLS = 16384;
        Engine.MAXSPRITES = 16384;
        Main.engine = new DukeEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new DukeSoftware(this.app.pEngine);
        }
        return new DukePolymost(this.app.pEngine);
    }

    @Override
    public DefScript getBaseDef(BuildEngine engine) {
        return new DefScript(engine, false);
    }

    @Override
    public BuildControls input(BuildControllers gpmanager) {
        return new DukeInput(this.app.pCfg, gpmanager);
    }

    @Override
    public OSDFunc console() {
        return new DukeOSDFunc(this.app.pEngine);
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = new DukeMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(5){

            @Override
            protected BuildFont init(int i) {
                if (i == 0) {
                    return new MiniFont(((DukeFactory)DukeFactory.this).app.pEngine);
                }
                if (i == 1) {
                    return new GameFont(((DukeFactory)DukeFactory.this).app.pEngine);
                }
                if (i == 2) {
                    return new MenuFont(((DukeFactory)DukeFactory.this).app.pEngine);
                }
                return new StandartFont(((DukeFactory)DukeFactory.this).app.pEngine);
            }
        };
    }

    @Override
    public BuildNet net() {
        return new DukeNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new DukeSliderDrawable();
    }

    @Override
    public void drawInitScreen() {
        Main.engine.rotatesprite(0xA00000, 0x640000, 65536, 0, 3281, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }
}

