/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Duke3D.Animate;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Menus.MenuCorruptGame;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.ResourceHandler;
import ru.m210projects.Duke3D.Screen;
import ru.m210projects.Duke3D.Sector;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Types.ANIMATION;
import ru.m210projects.Duke3D.Types.GameInfo;
import ru.m210projects.Duke3D.Types.LSInfo;
import ru.m210projects.Duke3D.Types.SafeLoader;
import ru.m210projects.Duke3D.View;

public class LoadSave {
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static LSInfo lsInf;
    public static SafeLoader loader;
    public static final String savsign = "DUKE";
    public static final int gdxSave = 100;
    public static final int currentGdxSave = 100;
    public static final int SAVEVERSION;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVELEVELINFO = 16;
    public static final int SAVEHEADER;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final int SAVEGDXDATA = 16128;
    public static String lastload;
    public static int quickslot;
    public static final char[] filenum;

    static {
        lsInf = new LSInfo();
        loader = new SafeLoader();
        SAVEVERSION = savsign.length() + 2;
        SAVEHEADER = SAVEVERSION + 8 + 32 + 16;
        quickslot = 0;
        filenum = new char[4];
    }

    public static void FindSaves() {
        FileResource fil = null;
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.User).getFiles().values()) {
            short nVersion;
            if (!file.getExtension().equals("sav") || (fil = BuildGdx.compat.open(file)) == null) continue;
            String signature = fil.readString(4);
            if (signature == null) {
                fil.close();
                continue;
            }
            if (signature.equals(savsign) && (nVersion = fil.readShort().shortValue()) == 100) {
                long time = fil.readLong();
                String savname = fil.readString(32).trim();
                Main.game.pSavemgr.add(savname, time, file.getName());
            }
            fil.close();
        }
        Main.game.pSavemgr.sort();
    }

    public static int lsReadLoadData(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            Tile pic = Main.engine.getTile(SaveManager.Screenshot);
            if (pic.data == null) {
                Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            int nVersion = LoadSave.checkSave(fil) & 0xFFFF;
            lsInf.clear();
            if (nVersion == 100) {
                fil.seek(SAVEVERSION, Resource.Whence.Set);
                LoadSave.lsInf.date = Main.game.date.getDate(fil.readLong());
                fil.seek(SAVEVERSION + 8 + 32, Resource.Whence.Set);
                lsInf.read(fil);
                if (fil.remaining() <= 16000) {
                    fil.close();
                    return -1;
                }
                fil.read(pic.data, 0, 16000);
                LoadSave.lsInf.addonfile = null;
                if (fil.readBoolean().booleanValue()) {
                    String fullname = fil.readString(144).trim();
                    int filenameIndex = -1;
                    filenameIndex = fullname.indexOf(":");
                    String ininame = filenameIndex != -1 ? FileUtils.getFullName(fullname.substring(0, filenameIndex)) : FileUtils.getFullName(fullname);
                    if (!ininame.isEmpty()) {
                        LoadSave.lsInf.addonfile = "File: " + ininame;
                    }
                }
                Main.engine.invalidatetile(SaveManager.Screenshot, 0, -1);
                fil.close();
                return 1;
            }
            if (!fil.isClosed()) {
                fil.close();
            }
        } else {
            lsInf.clear();
        }
        return -1;
    }

    public static String makeNum(int num) {
        LoadSave.filenum[3] = (char)(num % 10 + 48);
        LoadSave.filenum[2] = (char)(num / 10 % 10 + 48);
        LoadSave.filenum[1] = (char)(num / 100 % 10 + 48);
        LoadSave.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static int checkSave(Resource bb) {
        String signature = bb.readString(4);
        if (signature == null || !signature.equals(savsign)) {
            return 0;
        }
        return bb.readShort().shortValue();
    }

    public static int savegame(String savename, String filename) {
        FileResource fil;
        File file = BuildGdx.compat.checkFile(filename, Compat.Path.User);
        if (file != null) {
            file.delete();
        }
        if ((fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Write)) != null) {
            long time = Main.game.date.getCurrentDate();
            LoadSave.save(fil, savename, time);
            Main.game.pSavemgr.add(savename, time, filename);
            lastload = filename;
            View.addmessage("GAME SAVED");
            return 0;
        }
        View.addmessage("Game not saved. Access denied!");
        return -1;
    }

    public static void MapSave(FileResource fil) {
        if (Globals.boardfilename != null) {
            fil.writeBytes(Globals.boardfilename.toCharArray(), 144);
        } else {
            fil.writeBytes(new byte[144], 144);
        }
        int bufsize = 2 + Engine.numsectors * 40 + 2 + Engine.numwalls * 32 + Engine.MAXSPRITES * 44 + (Engine.MAXSECTORS + 1) * 2 + 2050 + Engine.MAXSPRITES * 8;
        ByteBuffer bb = ByteBuffer.allocate(bufsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort(Engine.numwalls);
        int w = 0;
        while (w < Engine.numwalls) {
            bb.put(Engine.wall[w].getBytes());
            ++w;
        }
        bb.putShort(Engine.numsectors);
        int s = 0;
        while (s < Engine.numsectors) {
            bb.put(Engine.sector[s].getBytes());
            ++s;
        }
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            bb.put(Engine.sprite[i].getBytes());
            ++i;
        }
        i = 0;
        while (i <= Engine.MAXSECTORS) {
            bb.putShort(Engine.headspritesect[i]);
            ++i;
        }
        i = 0;
        while (i <= 1024) {
            bb.putShort(Engine.headspritestat[i]);
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            bb.putShort(Engine.prevspritesect[i]);
            bb.putShort(Engine.prevspritestat[i]);
            bb.putShort(Engine.nextspritesect[i]);
            bb.putShort(Engine.nextspritestat[i]);
            ++i;
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void StuffSave(FileResource fil) {
        int bufsize = 43162 + Engine.show2dsector.length + 2 + 768;
        ByteBuffer bb = ByteBuffer.allocate(bufsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort(Globals.numcyclers);
        int i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 6) {
                bb.putShort(Globals.cyclers[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            bb.put(Globals.ps[i].getBytes());
            ++i;
        }
        i = 0;
        while (i < 16) {
            bb.put(Globals.po[i].getBytes());
            ++i;
        }
        bb.putShort(Globals.numanimwalls);
        i = 0;
        while (i < 512) {
            bb.putShort(Globals.animwall[i].wallnum);
            bb.putInt(Globals.animwall[i].tag);
            ++i;
        }
        i = 0;
        while (i < 2048) {
            bb.putInt(Globals.msx[i]);
            ++i;
        }
        i = 0;
        while (i < 2048) {
            bb.putInt(Globals.msy[i]);
            ++i;
        }
        bb.putShort(Globals.spriteqloc);
        bb.putShort(Globals.currentGame.getCON().spriteqamount);
        i = 0;
        while (i < 1024) {
            bb.putShort(Globals.spriteq[i]);
            ++i;
        }
        bb.putShort(Globals.mirrorcnt);
        i = 0;
        while (i < 64) {
            bb.putShort(Globals.mirrorwall[i]);
            ++i;
        }
        i = 0;
        while (i < 64) {
            bb.putShort(Globals.mirrorsector[i]);
            ++i;
        }
        bb.put(Engine.show2dsector);
        bb.putShort(Globals.numclouds);
        i = 0;
        while (i < 128) {
            bb.putShort(Globals.clouds[i]);
            ++i;
        }
        i = 0;
        while (i < 128) {
            bb.putShort(Globals.cloudx[i]);
            ++i;
        }
        i = 0;
        while (i < 128) {
            bb.putShort(Globals.cloudy[i]);
            ++i;
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void ConSave(FileResource fil) {
        int bufsiz = Engine.MAXTILES + 81840 + 4 * Engine.MAXTILES + Engine.MAXSPRITES * 78;
        ByteBuffer bb = ByteBuffer.allocate(bufsiz);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < Engine.MAXTILES) {
            bb.put((byte)Globals.currentGame.getCON().actortype[i]);
            ++i;
        }
        i = 0;
        while (i < 20460) {
            bb.putInt(Globals.currentGame.getCON().script[i]);
            ++i;
        }
        i = 0;
        while (i < Engine.MAXTILES) {
            bb.putInt(Globals.currentGame.getCON().actorscrptr[i]);
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            bb.put(Globals.hittype[i].getBytes());
            ++i;
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void Stuff2Save(FileResource fil) {
        ByteBuffer bb = ByteBuffer.allocate(1113);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort(Engine.pskybits);
        bb.putInt(Engine.parallaxyscale);
        int i = 0;
        while (i < 256) {
            bb.putShort(Engine.pskyoff[i]);
            ++i;
        }
        bb.putShort(Globals.earthquaketime);
        bb.putShort((short)Globals.ud.from_bonus);
        bb.putShort((short)Globals.ud.secretlevel);
        bb.put(Globals.ud.respawn_monsters ? (byte)1 : 0);
        bb.put(Globals.ud.respawn_items ? (byte)1 : 0);
        bb.put(Globals.ud.respawn_inventory ? (byte)1 : 0);
        bb.put(Globals.ud.god ? (byte)1 : 0);
        bb.putInt(Globals.ud.auto_run);
        bb.putInt(Globals.ud.crosshair);
        bb.put(Globals.ud.monsters_off ? (byte)1 : 0);
        bb.putInt(Globals.ud.last_level);
        bb.putInt(Globals.ud.eog);
        bb.putInt(Globals.ud.coop);
        bb.putInt(Globals.ud.marker);
        bb.putInt(Globals.ud.ffire);
        bb.putShort(Globals.camsprite);
        bb.putShort(Mmulti.connecthead);
        i = 0;
        while (i < 16) {
            bb.putShort(Mmulti.connectpoint2[i]);
            ++i;
        }
        bb.putShort(Globals.numplayersprites);
        i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                bb.putShort(Globals.frags[i][j]);
                ++j;
            }
            ++i;
        }
        bb.putInt(Main.engine.getrand());
        bb.putShort(Globals.global_random);
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void AnimationSave(FileResource fil) {
        int i = 0;
        while (i < 512) {
            fil.writeShort(Animate.gAnimationData[i].id);
            fil.writeByte(Animate.gAnimationData[i].type);
            fil.writeInt(Animate.gAnimationData[i].goal);
            fil.writeInt(Animate.gAnimationData[i].vel);
            fil.writeShort(Animate.gAnimationData[i].sect);
            ++i;
        }
        fil.writeInt(Animate.gAnimationCount);
    }

    public static void SaveVersion(FileResource fil, int nVersion) {
        fil.writeBytes(savsign.toCharArray(), 4);
        fil.writeShort(nVersion);
    }

    public static void SaveHeader(FileResource fil, String savename, long time) {
        LoadSave.SaveVersion(fil, 100);
        byte[] buf = new byte[8];
        LittleEndian.putLong(buf, 0, time);
        fil.writeBytes(buf, 8);
        fil.writeBytes(savename.toCharArray(), 32);
        fil.writeInt(Globals.ud.multimode);
        fil.writeInt(Globals.ud.volume_number);
        fil.writeInt(Globals.ud.level_number);
        fil.writeInt(Globals.ud.player_skill);
    }

    public static void SaveScreenshot(FileResource fil) {
        if (Main.gGameScreen.captBuffer != null) {
            fil.writeBytes(Main.gGameScreen.captBuffer, 16000);
        } else {
            fil.writeBytes(new byte[16000], 16000);
        }
        Main.gGameScreen.captBuffer = null;
    }

    public static void SaveGDXBlock(FileResource fil) {
        LoadSave.SaveScreenshot(fil);
        ByteBuffer bb = ByteBuffer.allocate(16128);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        byte warp_on = 0;
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            warp_on = 1;
        }
        if (Main.mUserFlag == Main.UserFlag.UserMap) {
            warp_on = 2;
        }
        bb.put(warp_on);
        if (warp_on == 1) {
            byte[] name = new byte[144];
            if (Globals.currentGame != null) {
                FileEntry addon = Globals.currentGame.getFile();
                if (addon != null && Globals.currentGame.isPackage()) {
                    String path = addon.getPath();
                    path = String.valueOf(path) + ":" + Globals.currentGame.ConName;
                    System.arraycopy(path.getBytes(), 0, name, 0, Math.min(path.length(), 144));
                } else {
                    String path = Globals.currentGame.getDirectory().checkFile(Globals.currentGame.ConName).getPath();
                    System.arraycopy(path.getBytes(), 0, name, 0, Math.min(path.length(), 144));
                }
            }
            bb.put(name);
        }
        fil.writeBytes(bb.array(), 16128);
    }

    public static void save(FileResource fil, String savename, long time) {
        LoadSave.SaveHeader(fil, savename, time);
        LoadSave.SaveGDXBlock(fil);
        LoadSave.MapSave(fil);
        LoadSave.StuffSave(fil);
        LoadSave.ConSave(fil);
        LoadSave.AnimationSave(fil);
        LoadSave.Stuff2Save(fil);
        fil.close();
        System.gc();
    }

    public static void quicksave() {
        if (Mmulti.numplayers > 1 || Globals.mFakeMultiplayer) {
            return;
        }
        if (Engine.sprite[Globals.ps[Mmulti.myconnectindex].i].extra > 0) {
            gQuickSaving = true;
        }
    }

    public static boolean canLoad(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            int nVersion = LoadSave.checkSave(fil) & 0xFFFF;
            if (nVersion != 100 && nVersion >= 100) {
                final GameInfo addon = loader.LoadGDXHeader(fil);
                if (LoadSave.loader.level_number <= 11 && LoadSave.loader.volume_number < 5 && LoadSave.loader.player_skill >= 0 && LoadSave.loader.player_skill < 5 && LoadSave.loader.warp_on != 2) {
                    MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[17];
                    menu.setRunnable(new Runnable(){

                        @Override
                        public void run() {
                            GameInfo game = addon != null ? addon : Globals.defGame;
                            int nEpisode = LoadSave.loader.volume_number;
                            int nLevel = LoadSave.loader.level_number;
                            int nSkill = LoadSave.loader.player_skill - 1;
                            Main.gGameScreen.newgame(false, game, nEpisode, nLevel, nSkill);
                        }
                    });
                    Main.game.menu.mOpen(menu, -1);
                }
            }
            fil.close();
            return nVersion == 100;
        }
        return false;
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        final String loadname = Main.game.pSavemgr.getLast();
        if (loadname != null && LoadSave.canLoad(loadname)) {
            Main.game.changeScreen(Main.gLoadingScreen.setTitle(loadname));
            Main.gLoadingScreen.init(new Runnable(){

                @Override
                public void run() {
                    if (!LoadSave.loadgame(loadname)) {
                        Main.game.setPrevScreen();
                    }
                }
            });
        }
    }

    public static void AnimationLoad() {
        int i = 0;
        while (i < 512) {
            Animate.gAnimationData[i].id = LoadSave.loader.gAnimationData[i].id;
            Animate.gAnimationData[i].type = LoadSave.loader.gAnimationData[i].type;
            Animate.gAnimationData[i].ptr = LoadSave.loader.gAnimationData[i].ptr;
            Animate.gAnimationData[i].goal = LoadSave.loader.gAnimationData[i].goal;
            Animate.gAnimationData[i].vel = LoadSave.loader.gAnimationData[i].vel;
            Animate.gAnimationData[i].sect = LoadSave.loader.gAnimationData[i].sect;
            ++i;
        }
        Animate.gAnimationCount = LoadSave.loader.gAnimationCount;
        i = Animate.gAnimationCount - 1;
        while (i >= 0) {
            ANIMATION gAnm = Animate.gAnimationData[i];
            Object object = gAnm.ptr = Animate.getobject(gAnm.id, gAnm.type);
            switch (gAnm.type) {
                case 1: 
                case 2: {
                    Main.game.pInt.setwallinterpolate(gAnm.id, (WALL)object);
                    break;
                }
                case 4: {
                    Main.game.pInt.setfloorinterpolate(gAnm.id, (SECTOR)object);
                    break;
                }
                case 8: {
                    Main.game.pInt.setceilinterpolate(gAnm.id, (SECTOR)object);
                }
            }
            --i;
        }
    }

    public static void ConLoad() {
        System.arraycopy(LoadSave.loader.actortype, 0, Globals.currentGame.getCON().actortype, 0, Engine.MAXTILES);
        System.arraycopy(LoadSave.loader.script, 0, Globals.currentGame.getCON().script, 0, 20460);
        System.arraycopy(LoadSave.loader.actorscrptr, 0, Globals.currentGame.getCON().actorscrptr, 0, Engine.MAXTILES);
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            Globals.hittype[i].set(LoadSave.loader.hittype[i]);
            ++i;
        }
    }

    public static void Stuff2Load() {
        Engine.pskybits = LoadSave.loader.pskybits;
        Engine.parallaxyscale = LoadSave.loader.parallaxyscale;
        System.arraycopy(LoadSave.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        Globals.earthquaketime = LoadSave.loader.earthquaketime;
        Globals.ud.from_bonus = LoadSave.loader.from_bonus;
        Globals.ud.secretlevel = LoadSave.loader.secretlevel;
        Globals.ud.respawn_monsters = LoadSave.loader.respawn_monsters;
        Globals.ud.respawn_items = LoadSave.loader.respawn_items;
        Globals.ud.respawn_inventory = LoadSave.loader.respawn_inventory;
        Globals.ud.god = LoadSave.loader.god;
        Globals.ud.auto_run = LoadSave.loader.auto_run;
        Globals.ud.crosshair = LoadSave.loader.crosshair;
        Globals.ud.monsters_off = LoadSave.loader.monsters_off;
        Globals.ud.last_level = LoadSave.loader.last_level;
        Globals.ud.eog = LoadSave.loader.eog;
        Globals.ud.coop = LoadSave.loader.coop;
        Globals.ud.marker = LoadSave.loader.marker;
        Globals.ud.ffire = LoadSave.loader.ffire;
        Globals.camsprite = LoadSave.loader.camsprite;
        Mmulti.connecthead = LoadSave.loader.connecthead;
        System.arraycopy(LoadSave.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 16);
        Globals.numplayersprites = LoadSave.loader.numplayersprites;
        int i = 0;
        while (i < 16) {
            System.arraycopy(LoadSave.loader.frags[i], 0, Globals.frags[i], 0, 16);
            ++i;
        }
        Main.engine.srand(LoadSave.loader.randomseed);
        Globals.global_random = LoadSave.loader.global_random;
    }

    public static void StuffLoad() {
        Globals.numcyclers = LoadSave.loader.numcyclers;
        int i = 0;
        while (i < 256) {
            System.arraycopy(LoadSave.loader.cyclers[i], 0, Globals.cyclers[i], 0, 6);
            ++i;
        }
        i = 0;
        while (i < 16) {
            Globals.ps[i].copy(LoadSave.loader.ps[i]);
            ++i;
        }
        i = 0;
        while (i < 16) {
            Globals.po[i].copy(LoadSave.loader.po[i]);
            ++i;
        }
        Globals.numanimwalls = LoadSave.loader.numanimwalls;
        i = 0;
        while (i < 512) {
            Globals.animwall[i].wallnum = LoadSave.loader.animwall[i].wallnum;
            Globals.animwall[i].tag = LoadSave.loader.animwall[i].tag;
            ++i;
        }
        System.arraycopy(LoadSave.loader.msx, 0, Globals.msx, 0, 2048);
        System.arraycopy(LoadSave.loader.msy, 0, Globals.msy, 0, 2048);
        Globals.spriteqloc = LoadSave.loader.spriteqloc;
        Globals.currentGame.getCON().spriteqamount = LoadSave.loader.spriteqamount;
        System.arraycopy(LoadSave.loader.spriteq, 0, Globals.spriteq, 0, 1024);
        Globals.mirrorcnt = LoadSave.loader.mirrorcnt;
        System.arraycopy(LoadSave.loader.mirrorwall, 0, Globals.mirrorwall, 0, 64);
        System.arraycopy(LoadSave.loader.mirrorsector, 0, Globals.mirrorsector, 0, 64);
        System.arraycopy(LoadSave.loader.show2dsector, 0, Engine.show2dsector, 0, Engine.MAXSECTORS + 7 >> 3);
        Globals.numclouds = LoadSave.loader.numclouds;
        System.arraycopy(LoadSave.loader.clouds, 0, Globals.clouds, 0, 128);
        System.arraycopy(LoadSave.loader.cloudx, 0, Globals.cloudx, 0, 128);
        System.arraycopy(LoadSave.loader.cloudy, 0, Globals.cloudy, 0, 128);
    }

    public static void MapLoad() {
        Globals.boardfilename = LoadSave.loader.boardfilename;
        Engine.numwalls = LoadSave.loader.numwalls;
        int w = 0;
        while (w < Engine.numwalls) {
            if (Engine.wall[w] == null) {
                Engine.wall[w] = new WALL();
            }
            Engine.wall[w].set(LoadSave.loader.wall[w]);
            ++w;
        }
        Engine.numsectors = LoadSave.loader.numsectors;
        int s = 0;
        while (s < Engine.numsectors) {
            if (Engine.sector[s] == null) {
                Engine.sector[s] = new SECTOR();
            }
            Engine.sector[s].set(LoadSave.loader.sector[s]);
            ++s;
        }
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            if (Engine.sprite[i] == null) {
                Engine.sprite[i] = new SPRITE();
            }
            Engine.sprite[i].set(LoadSave.loader.sprite[i]);
            ++i;
        }
        System.arraycopy(LoadSave.loader.headspritesect, 0, Engine.headspritesect, 0, Engine.MAXSECTORS + 1);
        System.arraycopy(LoadSave.loader.headspritestat, 0, Engine.headspritestat, 0, 1025);
        System.arraycopy(LoadSave.loader.prevspritesect, 0, Engine.prevspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.prevspritestat, 0, Engine.prevspritestat, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.nextspritesect, 0, Engine.nextspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.nextspritestat, 0, Engine.nextspritestat, 0, Engine.MAXSPRITES);
    }

    public static void LoadGDXBlock() {
        if (LoadSave.loader.warp_on == 0) {
            Main.mUserFlag = Main.UserFlag.None;
        }
        if (LoadSave.loader.warp_on == 1) {
            Main.mUserFlag = Main.UserFlag.Addon;
        }
        if (LoadSave.loader.warp_on == 2) {
            Main.mUserFlag = Main.UserFlag.UserMap;
        }
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            GameInfo ini = LoadSave.loader.addon;
            ResourceHandler.checkEpisodeResources(ini);
        } else {
            ResourceHandler.resetEpisodeResources();
        }
    }

    public static boolean load() {
        int x;
        Globals.ud.multimode = LoadSave.loader.multimode;
        Globals.ud.volume_number = LoadSave.loader.volume_number;
        Globals.ud.level_number = LoadSave.loader.level_number;
        Globals.ud.player_skill = LoadSave.loader.player_skill;
        LoadSave.LoadGDXBlock();
        LoadSave.MapLoad();
        LoadSave.StuffLoad();
        LoadSave.ConLoad();
        LoadSave.AnimationLoad();
        LoadSave.Stuff2Load();
        if (View.over_shoulder_on != 0) {
            View.cameradist = 0;
            View.cameraclock = 0;
            View.over_shoulder_on = 1;
        }
        Globals.screenpeek = Mmulti.myconnectindex;
        if (Globals.ud.rec != null) {
            Globals.ud.rec.close();
        }
        Globals.ud.recstat = 0;
        if (Globals.ud.lockout == 0) {
            x = 0;
            while (x < Globals.numanimwalls) {
                if (Engine.wall[Globals.animwall[x].wallnum].extra >= 0) {
                    Engine.wall[Globals.animwall[x].wallnum].picnum = Engine.wall[Globals.animwall[x].wallnum].extra;
                }
                ++x;
            }
        } else {
            x = 0;
            while (x < Globals.numanimwalls) {
                switch (Engine.wall[Globals.animwall[x].wallnum].picnum) {
                    case 1280: {
                        Engine.wall[Globals.animwall[x].wallnum].picnum = (short)1293;
                        break;
                    }
                    case 1289: 
                    case 1298: {
                        Engine.wall[Globals.animwall[x].wallnum].picnum = (short)268;
                    }
                }
                ++x;
            }
        }
        Globals.startofdynamicinterpolations = 0;
        short k = Engine.headspritestat[3];
        while (k >= 0) {
            switch (Engine.sprite[k].lotag) {
                case 17: 
                case 25: 
                case 31: 
                case 32: {
                    Main.game.pInt.setfheinuminterpolate(Engine.sprite[k].sectnum, Engine.sector[Engine.sprite[k].sectnum]);
                    break;
                }
                case 0: 
                case 5: 
                case 6: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 26: 
                case 30: {
                    Sector.setsectinterpolate(k);
                }
            }
            k = Engine.nextspritestat[k];
        }
        View.fta = 0;
        Globals.everyothertime = '\u0000';
        Main.gPrecacheScreen.init(false, new Runnable(){

            @Override
            public void run() {
                FileEntry file;
                ResourceHandler.InitSpecialTextures();
                Sounds.clearsoundlocks();
                Sounds.userMusic = null;
                if (Globals.boardfilename != null && (file = BuildGdx.compat.checkFile(Globals.boardfilename)) != null) {
                    Sounds.sndCheckMusic(file);
                }
                Globals.musicvolume = Globals.ud.volume_number;
                Globals.musiclevel = Globals.ud.level_number;
                Sounds.sndPlayMusic(Globals.currentGame.getCON().music_fn[Globals.ud.volume_number][Globals.ud.level_number]);
                if (Globals.ps[Mmulti.myconnectindex].jetpack_on != 0) {
                    Sounds.spritesound(50, Globals.ps[Mmulti.myconnectindex].i);
                }
                Player.setpal(Globals.ps[Mmulti.myconnectindex]);
                Screen.vscrn(Globals.ud.screen_size);
                BuildGdx.audio.getSound().setReverb(false, 0.0f);
                Main.game.pInput.resetMousePos();
                Main.game.net.predict.reset();
                Main.game.gPaused = false;
                Main.game.nNetMode = BuildGame.NetMode.Single;
                Main.game.changeScreen(Main.gGameScreen);
                Main.game.pNet.ResetTimers();
                Main.game.pNet.WaitForAllPlayers(0);
                Main.game.pNet.ready2send = true;
                Sounds.StopAllSounds();
                System.gc();
            }
        });
        Main.game.changeScreen(Main.gPrecacheScreen);
        return true;
    }

    public static boolean checkfile(Resource bb) {
        int nVersion = LoadSave.checkSave(bb);
        if (nVersion != 100) {
            return false;
        }
        return loader.load(bb);
    }

    public static boolean loadgame(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            boolean status = LoadSave.checkfile(fil);
            fil.close();
            if (status) {
                LoadSave.load();
                if (lastload == null || lastload.isEmpty()) {
                    lastload = filename;
                }
                if (loader.getMessage() != null) {
                    View.addmessage(loader.getMessage());
                }
                return true;
            }
            View.addmessage("Incompatible version of saved game found!");
            return false;
        }
        View.addmessage("Can't access to file or file not found!");
        return false;
    }
}

