/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D;

import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.utils.ByteArray;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildMessage;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.OnSceenDisplay.OSDCOMMAND;
import ru.m210projects.Build.OnSceenDisplay.OSDCVARFUNC;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Duke3D.Animate;
import ru.m210projects.Duke3D.Config;
import ru.m210projects.Duke3D.Factory.DukeEngine;
import ru.m210projects.Duke3D.Factory.DukeFactory;
import ru.m210projects.Duke3D.Factory.DukeMenuHandler;
import ru.m210projects.Duke3D.Factory.DukeNetwork;
import ru.m210projects.Duke3D.Fonts.GameFont;
import ru.m210projects.Duke3D.Fonts.MenuFont;
import ru.m210projects.Duke3D.Gamedef;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.LoadSave;
import ru.m210projects.Duke3D.Menus.GameMenu;
import ru.m210projects.Duke3D.Menus.MainMenu;
import ru.m210projects.Duke3D.Menus.MenuCorruptGame;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.Premap;
import ru.m210projects.Duke3D.ResourceHandler;
import ru.m210projects.Duke3D.Screens.AnmScreen;
import ru.m210projects.Duke3D.Screens.DemoScreen;
import ru.m210projects.Duke3D.Screens.DisconnectScreen;
import ru.m210projects.Duke3D.Screens.EndScreen;
import ru.m210projects.Duke3D.Screens.GameScreen;
import ru.m210projects.Duke3D.Screens.LoadingScreen;
import ru.m210projects.Duke3D.Screens.LogoAScreen;
import ru.m210projects.Duke3D.Screens.LogoBScreen;
import ru.m210projects.Duke3D.Screens.MenuScreen;
import ru.m210projects.Duke3D.Screens.NetScreen;
import ru.m210projects.Duke3D.Screens.PrecacheScreen;
import ru.m210projects.Duke3D.Screens.StatisticScreen;
import ru.m210projects.Duke3D.SoundDefs;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Types.Animwalltype;
import ru.m210projects.Duke3D.Types.DevCommScript;
import ru.m210projects.Duke3D.Types.PlayerOrig;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.Types.RTS;
import ru.m210projects.Duke3D.Types.Weaponhit;

public class Main
extends BuildGame {
    public static final String dukeappdef = "dukegdx.def";
    public static final String namappdef = "namgdx.def";
    public static String appdef;
    public static AnmScreen gAnmScreen;
    public static LogoAScreen gLogoScreen;
    public static LogoBScreen gALogoScreen;
    public static MenuScreen gMenuScreen;
    public static LoadingScreen gLoadingScreen;
    public static GameScreen gGameScreen;
    public static DemoScreen gDemoScreen;
    public static StatisticScreen gStatisticScreen;
    public static EndScreen gEndScreen;
    public static NetScreen gNetScreen;
    public static DisconnectScreen gDisconnectScreen;
    public static PrecacheScreen gPrecacheScreen;
    public static UserFlag mUserFlag;
    public static Main game;
    public static DukeEngine engine;
    public static Config cfg;
    public DukeMenuHandler menu;
    public DukeNetwork net;
    public final String mainGrp;
    public int gameParam;
    private Runnable rMenu = new Runnable(){

        @Override
        public void run() {
            Sounds.StopAllSounds();
            Globals.ud.level_number = 0;
            Globals.ud.multimode = 1;
            Globals.mFakeMultiplayer = false;
            if (!Main.this.menu.gShowMenu) {
                Main.this.menu.mOpen(Main.this.menu.mMenus[0], -1);
            }
            if (Mmulti.numplayers > 1 || Main.gDemoScreen.demofiles.size() == 0 || Main.cfg.gDemoSeq == 0 || !gDemoScreen.showDemo()) {
                Main.this.changeScreen(gMenuScreen);
            }
        }
    };
    private Runnable nextLogo = new Runnable(){

        @Override
        public void run() {
            Main.this.changeScreen(gALogoScreen.setCallback(Main.this.rMenu));
        }
    };

    static {
        mUserFlag = UserFlag.None;
    }

    public Main(BuildConfig dcfg, String appname, String sversion, int gameParam, boolean isDemo, boolean isRelease) {
        super(dcfg, appname, sversion, isRelease);
        game = this;
        cfg = (Config)dcfg;
        this.gameParam = gameParam;
        appdef = gameParam == 1 ? namappdef : dukeappdef;
        this.mainGrp = gameParam == 1 ? "nam.grp" : "duke3d.grp";
    }

    public Main(BuildConfig dcfg, String appname, String sversion, int gameParam, boolean isDemo) {
        this(dcfg, appname, sversion, gameParam, isDemo, true);
    }

    @Override
    public BuildFactory getFactory() {
        return new DukeFactory(this);
    }

    @Override
    public boolean init() throws Exception {
        FileEntry filgdx;
        this.net = (DukeNetwork)this.pNet;
        this.ConsoleInit();
        Premap.genspriteremaps();
        Gamedef.compilecons();
        engine.inittimer(120);
        ResourceHandler.InitSpecialTextures();
        this.InitUserDefs();
        RTS.RTS_Init(Globals.ud.rtsname);
        if (RTS.numlumps != 0) {
            Console.Println("Using .RTS file:" + Globals.ud.rtsname);
        }
        Sounds.SoundStartup();
        Sounds.MusicStartup();
        Animate.initanimations();
        LoadSave.FindSaves();
        int i = 0;
        while (i < 16) {
            Globals.ps[i] = new PlayerStruct();
            Globals.po[i] = new PlayerOrig();
            ++i;
        }
        Player.InitPlayers();
        i = 0;
        while (i < 512) {
            Globals.animwall[i] = new Animwalltype();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            Globals.hittype[i] = new Weaponhit();
            ++i;
        }
        Console.Println("Initializing def-scripts...");
        Gameutils.loadGdxDef(this.baseDef, appdef, "dukegdx.dat");
        if (Main.cfg.autoloadFolder) {
            Console.Println("Initializing autoload folder");
            DirectoryEntry autoload = BuildGdx.compat.checkDirectory("autoload");
            if (autoload != null) {
                for (FileEntry file : autoload.getFiles().values()) {
                    if (file.getExtension().equals("zip")) {
                        GroupResource def;
                        Group group = BuildGdx.cache.add(file.getPath());
                        if (group == null || (def = group.open(appdef)) == null) continue;
                        this.baseDef.loadScript(file.getName(), def.getBytes());
                        def.close();
                        continue;
                    }
                    if (!file.getExtension().equals("def")) continue;
                    this.baseDef.loadScript(file);
                }
            }
        }
        if ((filgdx = BuildGdx.compat.checkFile(appdef)) != null) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        if (Globals.currentGame.getCON().type == 20) {
            FileEntry def;
            DirectoryEntry defdir = BuildGdx.compat.checkDirectory("def");
            if (defdir != null && (def = defdir.checkFile("developer_commentary.def")) != null) {
                DevCommScript scr = new DevCommScript(def);
                SoundDefs.commentaries = scr.getCommentaries();
            }
            Sounds.pCommentary = new Sounds.Commentary();
        }
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[1] = new GameMenu(this);
        this.menu.mMenus[17] = new MenuCorruptGame(this);
        gAnmScreen = new AnmScreen(this);
        gLogoScreen = new LogoAScreen(this, 5.0f);
        gALogoScreen = new LogoBScreen(this);
        gMenuScreen = new MenuScreen(this);
        gLoadingScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gDemoScreen = new DemoScreen(this);
        gStatisticScreen = new StatisticScreen(this);
        gEndScreen = new EndScreen(this);
        gNetScreen = new NetScreen(this);
        gDisconnectScreen = new DisconnectScreen(this);
        gPrecacheScreen = new PrecacheScreen(this);
        gALogoScreen.setCallback(this.rMenu);
        gDemoScreen.demoscan();
        return true;
    }

    public static boolean IsOriginalDemo() {
        ScreenAdapter screen = (ScreenAdapter)game.getScreen();
        if (screen instanceof DemoScreen) {
            return ((DemoScreen)screen).IsOriginalGame();
        }
        if (screen instanceof GameScreen) {
            return ((GameScreen)screen).IsOriginalGame();
        }
        return false;
    }

    @Override
    public boolean setDefs(DefScript script) {
        if (super.setDefs(script)) {
            ((GameFont)this.getFont(1)).update();
            ((MenuFont)this.getFont(2)).update();
            return true;
        }
        return false;
    }

    @Override
    public void show() {
        Globals.uGameFlags = 0;
        Globals.kGameCrash = false;
        if (ResourceHandler.usecustomarts) {
            ResourceHandler.resetEpisodeResources();
        }
        if (Globals.ud.recstat == 1 && Globals.ud.rec != null) {
            Globals.ud.rec.close();
        }
        if (gAnmScreen.init("logo.anm", 5)) {
            gAnmScreen.setCallback(new Runnable(){

                @Override
                public void run() {
                    Main.this.changeScreen(gLogoScreen.setCallback(Main.this.nextLogo).setSkipping(Main.this.rMenu));
                }
            });
            this.setScreen(gAnmScreen.escSkipping(false));
        } else {
            this.setScreen(gLogoScreen.setCallback(this.nextLogo).setSkipping(this.rMenu));
        }
    }

    public void InitUserDefs() {
        Globals.ud.setDefaults(cfg);
        Globals.ud.god = false;
        Globals.ud.cashman = 0;
        Globals.ud.player_skill = 2;
    }

    public void ConsoleInit() {
        Console.Println("Initializing on-screen display system");
        Console.setVersion(String.valueOf(this.appname) + " " + this.sversion, 10, Console.OSDTEXT_GOLD);
        Console.RegisterCvar(new OSDCOMMAND("restart", "restart", new OSDCVARFUNC(){

            @Override
            public void execute() {
                Premap.LeaveMap();
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("findexit", "mem usage / total", new OSDCVARFUNC(){

            @Override
            public void execute() {
                int i = 0;
                while (i < Engine.MAXSPRITES) {
                    if (Engine.sprite[i].statnum != 1024 && Engine.sprite[i].picnum == 142) {
                        Console.Println("Exit at: " + Engine.sprite[i].x + " " + Engine.sprite[i].y + " " + Engine.sprite[i].z);
                    }
                    ++i;
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("net_player", "net_player", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("net_player: num");
                    return;
                }
                try {
                    String num = Console.osd_argv[1];
                    int pnum = Integer.parseInt(num);
                    int p = Main.game.net.PutPacketByte(Premap.packbuf, 0, 10);
                    p = Main.game.net.PutPacketByte(Premap.packbuf, p, pnum);
                    int trail = Main.game.net.gNetFifoTail;
                    if (Mmulti.myconnectindex == Mmulti.connecthead) {
                        ++trail;
                    }
                    LittleEndian.putInt(Premap.packbuf, p, trail);
                    Main.game.net.PlayerSyncRequest = pnum;
                    Main.game.net.sendtoall(Premap.packbuf, p += 4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("quicksave", "quicksave: performs a quick save", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Globals.ud.multimode != 1 || Mmulti.numplayers > 1) {
                    Console.Println("quicksave: Single player only");
                    return;
                }
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    LoadSave.quicksave();
                } else {
                    Console.Println("quicksave: not in a game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("quickload", "quickload: performs a quick load", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Globals.ud.multimode != 1 || Mmulti.numplayers > 1) {
                    Console.Println("quickload: Single player only");
                    return;
                }
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    LoadSave.quickload();
                } else {
                    Console.Println("quickload: not in a game");
                }
            }
        }));
    }

    public void dassert(String msg) {
        if (Globals.kGameCrash) {
            return;
        }
        this.ThrowError(msg);
        System.exit(0);
    }

    public boolean GameMessage(String text, boolean question) {
        if (!question) {
            BuildGdx.message.show("Warning: ", text, BuildMessage.MessageType.Info);
            Console.Println("Warning: " + text, Console.OSDTEXT_YELLOW);
            return true;
        }
        Console.Println("Warning: " + text, Console.OSDTEXT_YELLOW);
        return BuildGdx.message.show("Warning: ", text, BuildMessage.MessageType.Question);
    }

    public void GameCrash(String errorText) {
        BuildGdx.message.show("Error: ", errorText, BuildMessage.MessageType.Info);
        Console.Println("Game error: " + errorText, Console.OSDTEXT_RED);
        Globals.kGameCrash = true;
    }

    public void Disconnect() {
        if (Globals.ud.recstat == 1 && Globals.ud.rec != null) {
            Globals.ud.rec.close();
        }
        if (gDisconnectScreen != null) {
            this.changeScreen(gDisconnectScreen);
        }
    }

    @Override
    public void dispose() {
        if (Globals.ud.rec != null) {
            Globals.ud.rec.close();
        }
        super.dispose();
    }

    @Override
    protected byte[] reportData() {
        byte[] out = null;
        String text = "Mapname: " + Globals.boardfilename;
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "UserFlag: " + (Object)((Object)mUserFlag);
        text = String.valueOf(text) + "\r\n";
        if (mUserFlag == UserFlag.Addon && Globals.currentGame != null) {
            try {
                FileEntry addon = Globals.currentGame.getFile();
                text = addon != null && Globals.currentGame.isPackage() ? String.valueOf(text) + "Episode filename: " + addon.getPath() + ":" + Globals.currentGame.ConName : String.valueOf(text) + "Episode filename: " + Globals.currentGame.getDirectory().checkFile(Globals.currentGame.ConName).getPath();
                text = String.valueOf(text) + "\r\n";
            }
            catch (Exception e) {
                text = String.valueOf(text) + "Episode filename get error \r\n";
            }
        }
        text = String.valueOf(text) + "volume " + (Globals.ud.volume_number + 1);
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "level " + (Globals.ud.level_number + 1);
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "nDifficulty: " + Globals.ud.player_skill;
        text = String.valueOf(text) + "\r\n";
        if (Globals.ps != null) {
            text = String.valueOf(text) + "PlayerX: " + Globals.ps[Mmulti.myconnectindex].posx;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerY: " + Globals.ps[Mmulti.myconnectindex].posy;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerZ: " + Globals.ps[Mmulti.myconnectindex].posz;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerAng: " + Globals.ps[Mmulti.myconnectindex].ang;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerSect: " + Globals.ps[Mmulti.myconnectindex].cursectnum;
            text = String.valueOf(text) + "\r\n";
        }
        if (mUserFlag == UserFlag.UserMap && Globals.boardfilename != null) {
            ByteArray array = new ByteArray();
            byte[] data = BuildGdx.cache.getBytes(Globals.boardfilename, 0);
            if (data != null) {
                text = String.valueOf(text) + "\r\n<------Start Map data------->\r\n";
                array.addAll(text.getBytes());
                array.addAll(data);
                array.addAll("\r\n<------End Map data------->\r\n".getBytes());
                out = Arrays.copyOf(array.items, array.size);
            }
        } else {
            out = text.getBytes();
        }
        return out;
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;

    }
}

