/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Menus;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuLoadSave;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuPicnum;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlotList;
import ru.m210projects.Build.Pattern.MenuItems.MenuText;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Duke3D.LoadSave;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Menus.DukeTitle;

public class DMenuSave
extends MenuLoadSave {
    public DMenuSave(BuildGame app) {
        super(app, app.getFont(0), 75, 50, 185, 240, 12, 12, 2, 3281, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                String filename;
                MenuSlotList item = (MenuSlotList)pItem;
                if (item.l_nFocus == 0) {
                    int num = 0;
                    while (true) {
                        if (num > 9999) {
                            return;
                        }
                        filename = "game" + LoadSave.makeNum(num) + ".sav";
                        if (BuildGdx.compat.checkFile(filename, Compat.Path.User) != null) {
                            ++num;
                            continue;
                        }
                        break;
                    }
                } else {
                    filename = item.FileName();
                }
                if (item.typed == null || item.typed.isEmpty()) {
                    item.typed = filename;
                }
                LoadSave.savegame(item.typed, filename);
                handler.mClose();
            }
        }, true);
        this.list.questionFont = app.getFont(1);
        this.list.nListOffset = 15;
        this.list.backgroundPal = 4;
    }

    @Override
    public boolean loadData(String filename) {
        return LoadSave.lsReadLoadData(filename) != -1;
    }

    @Override
    public MenuTitle getTitle(BuildGame app, String text) {
        return new DukeTitle(text);
    }

    @Override
    public MenuPicnum getPicnum(Engine draw, int x, int y) {
        return new MenuPicnum(draw, x - 70, y - 3, 3281, 3281, 75776){

            @Override
            public void draw(MenuHandler handler) {
                if (this.nTile != this.defTile) {
                    this.draw.rotatesprite(this.x + 3 << 16, this.y << 16, 74752, 0, this.nTile, 0, 0, 26, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else {
                    this.draw.rotatesprite(this.x + 94 << 16, this.y + 57 << 16, 37376, 0, this.nTile, 0, 0, 10, Gameutils.coordsConvertXScaled(this.x, Gameutils.ConvertType.Normal), 0, Gameutils.coordsConvertXScaled(this.x + 186, Gameutils.ConvertType.Normal), Engine.ydim - 1);
                }
            }

            @Override
            public void close() {
                Main.gGameScreen.captBuffer = null;
            }
        };
    }

    @Override
    public MenuText getInfo(BuildGame app, int x, int y) {
        return new MenuText(LoadSave.lsInf.info, app.getFont(0), x - 58, y + 100, 0){

            @Override
            public void draw(MenuHandler handler) {
                int ty = this.y;
                if (LoadSave.lsInf.addonfile != null && !LoadSave.lsInf.addonfile.isEmpty()) {
                    this.font.drawText(this.x, ty, LoadSave.lsInf.addonfile, -128, 12, BuildFont.TextAlign.Left, 2, true);
                    ty -= 10;
                }
                if (LoadSave.lsInf.date != null && !LoadSave.lsInf.date.isEmpty()) {
                    this.font.drawText(this.x, ty, LoadSave.lsInf.date, -128, 12, BuildFont.TextAlign.Left, 2, true);
                    ty -= 10;
                }
                if (LoadSave.lsInf.info != null) {
                    this.font.drawText(this.x, ty, LoadSave.lsInf.info, -128, 12, BuildFont.TextAlign.Left, 2, true);
                }
            }
        };
    }
}

