/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.PrecacheAdapter;

public class PrecacheScreen
extends PrecacheAdapter {
    public PrecacheScreen(BuildGame game) {
        super(game);
        this.addQueue("Preload floor and ceiling tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numsectors) {
                    PrecacheScreen.this.addTile(Engine.sector[i].floorpicnum);
                    PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum);
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload wall tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numwalls) {
                    PrecacheScreen.this.addTile(Engine.wall[i].picnum);
                    if (Engine.wall[i].overpicnum >= 0) {
                        PrecacheScreen.this.addTile(Engine.wall[i].overpicnum);
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload sprite tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.MAXSPRITES) {
                    if (Engine.sprite[i].statnum < 1024) {
                        PrecacheScreen.this.cachespritenum(i);
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
    }

    @Override
    protected void draw(String title, int index) {
        this.engine.rotatesprite(0xA00000, 0x640000, 65536, 0, 770, -128, 0, 74, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        this.game.getFont(2).drawText(160, 80, "Loading", 0, 0, BuildFont.TextAlign.Center, 2, true);
        this.game.getFont(2).drawText(160, 114, "please wait...", 0, 0, BuildFont.TextAlign.Center, 2, true);
        this.game.getFont(2).drawText(160, 130, title, 0, 0, BuildFont.TextAlign.Center, 0, false);
    }

    private void cachespritenum(int i) {
        int maxc = 1;
        switch (Engine.sprite[i].picnum) {
            case 1536: 
            case 1792: 
            case 2048: 
            case 2304: 
            case 2560: {
                maxc = 40;
            }
        }
        int j = Engine.sprite[i].picnum;
        while (j < Engine.sprite[i].picnum + maxc) {
            this.addTile(j);
            ++j;
        }
    }
}

