/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Audio.MusicSource;
import ru.m210projects.Build.Audio.Sound;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.Audio.SourceCallback;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Types.VOC;

public class Sounds {
    private static SourceCallback<Integer> callback = new SourceCallback<Integer>(){

        @Override
        public void run(Integer ch) {
            sActiveSound[ch].stop();
        }
    };
    public static SoundResource[] SoundBufs = new SoundResource[100];
    public static int currChannel;
    public static ActiveSound[] sActiveSound;
    public static int currTrack;
    public static MusicSource currMusic;
    public static int currSong;

    static {
        currTrack = -1;
        currMusic = null;
        currSong = -1;
    }

    public static void sndInit() {
        Console.Println("Initializing sound system");
        if (Main.cfg.maxvoices < 8) {
            Main.cfg.maxvoices = 8;
        }
        if (BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, Main.cfg.maxvoices, Main.cfg.resampler_num)) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.cfg.soundVolume);
        } else {
            Console.Println(String.valueOf(BuildGdx.audio.getName(BuildAudio.Driver.Sound)) + " initialization failed", Console.OSDTEXT_RED);
        }
        if (!BuildGdx.audio.getMusic().init()) {
            Console.Println(String.valueOf(BuildGdx.audio.getName(BuildAudio.Driver.Music)) + " initialization failed", Console.OSDTEXT_RED);
        }
        if (!Main.cfg.muteMusic) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, Main.cfg.musicVolume);
        } else {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, 0.0f);
        }
        sActiveSound = new ActiveSound[Main.cfg.maxvoices];
        int i = 0;
        while (i < sActiveSound.length) {
            Sounds.sActiveSound[i] = new ActiveSound();
            ++i;
        }
        currChannel = 0;
    }

    public static boolean midRestart() {
        Sounds.stopmusic();
        if (!BuildGdx.audio.getMusic().init()) {
            Console.Println(String.valueOf(BuildGdx.audio.getName(BuildAudio.Driver.Music)) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        return true;
    }

    public static boolean sndRestart(int nvoices, int resampler) {
        BuildGdx.audio.getSound().stopAllSounds();
        BuildGdx.audio.getSound().uninit();
        Main.cfg.maxvoices = nvoices;
        Console.Println("Sound restarting...");
        if (!BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, nvoices, resampler)) {
            Console.Println(String.valueOf(BuildGdx.audio.getName(BuildAudio.Driver.Sound)) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.cfg.soundVolume);
        sActiveSound = new ActiveSound[Main.cfg.maxvoices];
        int i = 0;
        while (i < sActiveSound.length) {
            Sounds.sActiveSound[i] = new ActiveSound();
            ++i;
        }
        currChannel = 0;
        return true;
    }

    public static void stopallsounds() {
        currChannel = 0;
        BuildGdx.audio.getSound().stopAllSounds();
        int i = 0;
        while (i < sActiveSound.length) {
            sActiveSound[i].stop();
            ++i;
        }
    }

    public static void stopmusic() {
        if (currMusic != null) {
            currMusic.stop();
        }
        currTrack = -1;
        currMusic = null;
    }

    public static void startmusic(int num) {
        byte[] data;
        String himus;
        if (!Main.cfg.muteMusic) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, Main.cfg.musicVolume);
        } else {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, 0.0f);
        }
        if (Main.cfg.muteMusic || currMusic != null && currMusic.isPlaying() && currSong != -1 && currSong == num) {
            return;
        }
        if (Main.cfg.musicType == 1 && Main.game.currentDef != null && (himus = Main.game.currentDef.audInfo.getDigitalInfo(Integer.toString(num))) != null) {
            Sounds.stopmusic();
            currMusic = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, himus);
            if (currMusic != null) {
                currSong = num;
                System.err.println("Play ogg music " + num);
                currMusic.play(true);
                return;
            }
        }
        if ((data = BuildGdx.cache.getBytes(num + 103, "")) == null || data.length <= 0) {
            return;
        }
        Sounds.stopmusic();
        currMusic = BuildGdx.audio.newMusic(BuildAudio.MusicType.Midi, data);
        if (currMusic != null) {
            System.err.println("Play midi music " + num);
            currSong = num;
            currMusic.play(true);
        }
    }

    private static boolean loadsound(int num) {
        byte[] data = BuildGdx.cache.getBytes(num + 3, "");
        if (data == null) {
            Console.Println("Sound " + num + " not found.", Console.OSDTEXT_RED);
            return false;
        }
        Sounds.SoundBufs[num] = new SoundResource(data, num);
        return true;
    }

    private static ActiveSound preparesound(int num, int priority) {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || num < 0 || num >= SoundBufs.length) {
            return null;
        }
        if (SoundBufs[num] == null && !Sounds.loadsound(num)) {
            return null;
        }
        int channel = currChannel++ & sActiveSound.length - 1;
        ActiveSound pSound = sActiveSound[channel];
        SoundResource res = SoundBufs[num];
        Source hVoice = BuildGdx.audio.newSound(res.ptr, res.rate, res.bits, priority);
        if (hVoice != null) {
            hVoice.setCallback(callback, channel);
            pSound.pHandle = hVoice;
            pSound.soundnum = channel;
            return pSound;
        }
        return null;
    }

    public static ActiveSound playsound(int num) {
        ActiveSound pSound = Sounds.preparesound(num, 256);
        if (pSound != null) {
            pSound.spr = -1;
            pSound.pHandle.setGlobal(1);
            pSound.pHandle.play(1.0f);
        }
        return pSound;
    }

    public static ActiveSound playsound(int num, int spriteid) {
        int vol = Sounds.calcvolume(spriteid);
        if (vol == 0) {
            return null;
        }
        ActiveSound pSound = Sounds.preparesound(num, vol);
        if (pSound != null) {
            pSound.spr = spriteid;
            pSound.pHandle.play((float)vol / 255.0f);
        }
        return pSound;
    }

    public static int calcvolume(int spr) {
        SPRITE pSprite = Engine.sprite[spr];
        int dist = Pragmas.klabs(Globals.gPlayer[Globals.screenpeek].x - pSprite.x) + Pragmas.klabs(Globals.gPlayer[Globals.screenpeek].y - pSprite.y);
        int vol = Gameutils.BClipLow(65536 - (dist << 2), 0);
        if (dist < 1500) {
            vol = 65536;
        }
        return Gameutils.BClipRange((int)((float)vol / 65536.0f * 255.0f), 0, 255);
    }

    public static void updatesounds() {
        if (Main.cfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        BuildGdx.audio.getSound().setListener(Globals.gPlayer[Globals.screenpeek].x, Globals.gPlayer[Globals.screenpeek].z >> 4, Globals.gPlayer[Globals.screenpeek].y, (int)Globals.gPlayer[Globals.screenpeek].ang);
        int i = 0;
        while (i < sActiveSound.length) {
            if (Sounds.sActiveSound[i].pHandle != null) {
                if (!Sounds.sActiveSound[i].pHandle.isActive()) {
                    Sounds.sActiveSound[i].pHandle.callback.run(i);
                } else {
                    ActiveSound pSound = sActiveSound[i];
                    int spr = pSound.spr;
                    if (spr != -1) {
                        SPRITE pSprite = Engine.sprite[spr];
                        pSound.pHandle.setPosition(pSprite.x, pSprite.z >> 4, pSprite.y);
                        pSound.pHandle.setVolume((float)Sounds.calcvolume(spr) / 255.0f);
                    }
                }
            }
            ++i;
        }
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (currMusic != null) {
                currMusic.pause();
            }
            BuildGdx.audio.getSound().stopAllSounds();
        } else if (!Main.cfg.muteMusic && currMusic != null) {
            currMusic.resume();
        }
    }

    public static class ActiveSound {
        public Source pHandle;
        public int spr;
        public int soundnum;

        public void stop() {
            if (this.pHandle != null) {
                this.pHandle.dispose();
            }
            this.pHandle = null;
            this.soundnum = -1;
            this.spr = -1;
        }
    }

    public static class SoundResource {
        public ByteBuffer ptr;
        public int num;
        public int bits;
        public int rate;

        public SoundResource(byte[] data, int num) {
            VOC voc = new VOC(data);
            this.bits = voc.samplesize;
            this.rate = voc.samplerate;
            this.ptr = voc.sampledata;
            this.num = num;
        }
    }
}

