/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.Components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;

public class DirectoryBrowser
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTree tree;
    private File selected;
    private JScrollPane scroll;

    public void pathList(String path, List<String> list) {
        int pos = 0;
        while (pos < path.length() && path.charAt(pos) != '/' && path.charAt(pos) != File.separatorChar) {
            ++pos;
        }
        String out = path.substring(0, pos);
        if (!out.isEmpty()) {
            list.add(out);
        }
        if (pos < path.length()) {
            this.pathList(path.substring(pos + 1), list);
        }
    }

    public int expandTree(JTree tree, DefaultTreeModel model, Object parent, List<String> pathtree, int pos) {
        if (parent instanceof FileTreeNode) {
            this.scanChildren(model, (FileTreeNode)parent);
        }
        int i = 0;
        while (i < model.getChildCount(parent)) {
            Object node = model.getChild(parent, i);
            if (node.toString().equals(File.separator)) {
                tree.expandRow(++pos);
                pos = this.expandTree(tree, model, node, pathtree, pos);
            } else if (node.toString().contains(pathtree.get(0))) {
                while (pathtree.size() != 0) {
                    int index = model.getIndexOfChild(parent, node);
                    ++pos;
                    tree.expandRow(pos += index);
                    pathtree.remove(0);
                    if (pathtree.size() <= 0) continue;
                    pos = this.expandTree(tree, model, node, pathtree, pos);
                }
                break;
            }
            ++i;
        }
        tree.setSelectionRow(pos);
        return pos;
    }

    public DirectoryBrowser(Frame f, boolean modal, String path, String name, Image icon) {
        super(f, modal);
        File[] ff;
        this.setLayout(new MigLayout("", "[grow]", "[grow][]"));
        this.setTitle("Select " + name + " folder");
        this.setIconImage(icon);
        this.setResizable(true);
        ArrayList<String> pathtree = new ArrayList<String>();
        this.pathList(path, pathtree);
        int rowHeight = 20;
        this.tree = new JTree();
        this.tree.setRowHeight(rowHeight);
        this.tree.setVisibleRowCount(15);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Desktop");
        File[] fileArray = ff = File.listRoots();
        int n = ff.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            FileTreeNode dn = new FileTreeNode(dir);
            dn.setUserObject(dir.getAbsoluteFile());
            root.add(dn);
            ++n2;
        }
        final DefaultTreeModel model = new DefaultTreeModel(root);
        this.tree.setModel(model);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath tp = event.getPath();
                Object o = tp.getLastPathComponent();
                if (o instanceof FileTreeNode) {
                    FileTreeNode dn = (FileTreeNode)o;
                    DirectoryBrowser.this.scanChildren(model, dn);
                    DirectoryBrowser.this.selected = dn.file;
                } else {
                    DirectoryBrowser.this.selected = null;
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath tp = e.getPath();
                Object o = tp.getLastPathComponent();
                if (o instanceof FileTreeNode) {
                    FileTreeNode dn = (FileTreeNode)o;
                    DirectoryBrowser.this.scanChildren(model, dn);
                    DirectoryBrowser.this.selected = dn.file;
                } else {
                    DirectoryBrowser.this.selected = null;
                }
            }
        });
        int pos = this.expandTree(this.tree, model, model.getRoot(), pathtree, 0);
        this.scroll = new JScrollPane(this.tree);
        this.scroll.setViewportView(this.tree);
        this.scroll.getViewport().scrollRectToVisible(new Rectangle(0, pos * rowHeight, 0, 0));
        this.add((Component)this.scroll, "cell 0 0,grow");
        JButton bt1 = new JButton("OK");
        bt1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DirectoryBrowser.this.setVisible(false);
            }
        });
        this.add((Component)bt1, "flowx,cell 0 1,alignx right");
        JButton bt2 = new JButton("Cancel");
        bt2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DirectoryBrowser.this.selected = null;
                DirectoryBrowser.this.setVisible(false);
            }
        });
        this.add((Component)bt2, "cell 0 1,alignx right");
        this.setMinimumSize(new Dimension(300, 300));
        this.pack();
        Point p = f.getLocation();
        this.setLocation(p.x + (f.getWidth() - this.getWidth()) / 2, p.y + (f.getHeight() - this.getHeight()) / 2);
    }

    public File getSelected() {
        return this.selected;
    }

    public static File showDirectoryChooser(Frame f, String path, String name, URL icon) {
        DirectoryBrowser dc = new DirectoryBrowser(f, true, path, name, Toolkit.getDefaultToolkit().getImage(icon));
        dc.setVisible(true);
        return dc.selected;
    }

    private void scanChildren(DefaultTreeModel model, FileTreeNode n) {
        if (n.isScan) {
            return;
        }
        File[] fs = n.file.listFiles();
        if (fs == null) {
            return;
        }
        File[] fileArray = fs;
        int n2 = fs.length;
        int n3 = 0;
        while (n3 < n2) {
            File ff = fileArray[n3];
            if (ff.isDirectory()) {
                model.insertNodeInto(new FileTreeNode(ff), n, n.getChildCount());
            }
            ++n3;
        }
        n.isScan = true;
    }

    private class FileTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private File file;
        private boolean isScan;

        public FileTreeNode(File f) {
            super(f.getName());
            this.isScan = false;
            this.file = f;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }
}

