/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.GameEntries;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import ru.m210projects.Blood.Config;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Launcher.desktop.CheckFiles;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GameEntries.ResFile;
import ru.m210projects.Launcher.desktop.Main;

public abstract class BloodEntry
extends GameEntry {
    public boolean isDemo = false;

    public BloodEntry() {
        super("BloodGDX", Main.appversion);
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headerblood.png");
    }

    @Override
    public URL getIcon16() {
        return this.getClass().getResource("/Games/Blood/blood16.png");
    }

    @Override
    public String[] getIcons() {
        String[] icons = new String[]{"Games/Blood/blood16.png", "Games/Blood/blood32.png", "Games/Blood/blood128.png"};
        return icons;
    }

    @Override
    public String getResourceName() {
        return "Blood";
    }

    @Override
    public ResFile[] getResourceFiles() {
        ResFile[] resources = new ResFile[]{new ResFile("blood.ini"), new ResFile("blood.rff"), new ResFile("sounds.rff"), new ResFile("tiles000.art"), new ResFile("tables.dat"), new ResFile("surface.dat")};
        return resources;
    }

    public ResFile[] getDemoResource() {
        ResFile[] resources = new ResFile[]{new ResFile("blood.ini"), new ResFile("blood.rff"), new ResFile("sounds.rff"), new ResFile("share000.art"), new ResFile("tables.dat"), new ResFile("surface.dat")};
        return resources;
    }

    @Override
    public CheckFiles checkResources(String path, boolean errorMessage) {
        File directory = new File(path);
        File[] fList = directory.listFiles();
        if (fList == null) {
            return new CheckFiles(false, null);
        }
        HashMap<String, File> filesMap = new HashMap<String, File>();
        File[] fileArray = fList;
        int n = fList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            filesMap.put(Strhandler.toLowerCase(file.getName()), file);
            ++n2;
        }
        String missingFiles = "<html>";
        this.isDemo = false;
        boolean found = true;
        ResFile[] resources = this.getResourceFiles();
        int i = 0;
        while (i < resources.length) {
            if (filesMap.get(resources[i].name) == null) {
                found = false;
                if (errorMessage) {
                    Console.Println(String.valueOf(this.appname) + " error: " + resources[i].name + " is missing!");
                }
                missingFiles = String.valueOf(missingFiles) + resources[i].name.toUpperCase() + " is missing<br>";
            }
            ++i;
        }
        if (found) {
            return new CheckFiles(true, null);
        }
        if (errorMessage) {
            Console.Println(String.valueOf(this.appname) + ": trying to find demo version");
        }
        found = true;
        this.isDemo = true;
        resources = this.getDemoResource();
        i = 0;
        while (i < resources.length) {
            if (filesMap.get(resources[i].name) == null) {
                found = false;
                if (errorMessage) {
                    Console.Println(String.valueOf(this.appname) + " error: " + resources[i].name + " is missing!");
                }
            }
            ++i;
        }
        if (found) {
            return new CheckFiles(true, null);
        }
        return new CheckFiles(false, String.valueOf(missingFiles) + "</html>");
    }

    @Override
    public BuildConfig buildConfig(String path) {
        this.currentConfig = new Config(path, String.valueOf(this.appname) + ".ini");
        return this.currentConfig;
    }

    @Override
    public BuildGame getGame(String[] args) {
        if (this.isDemo) {
            Console.Println("Demo version detected");
        }
        return new ru.m210projects.Blood.Main(this.getConfig(), this.appname, this.sversion, this.isDemo);
    }
}

