/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.GameEntries;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Launcher.desktop.CheckFiles;
import ru.m210projects.Launcher.desktop.GameEntries.ResFile;

public abstract class GameEntry {
    public final String appname;
    public final String sversion;
    protected BuildConfig currentConfig;
    protected String homePath;
    protected static String currentPath;

    public GameEntry(String appname, String sversion) {
        this.appname = appname;
        this.sversion = sversion;
    }

    public abstract URL getLogo();

    public abstract URL getIcon16();

    public abstract String getResourceName();

    public abstract ResFile[] getResourceFiles();

    public abstract String[] getIcons();

    public static String getDirPath() {
        String parent;
        if (currentPath != null) {
            return currentPath;
        }
        currentPath = String.valueOf(System.getProperty("user.dir")) + File.separator;
        String OS = System.getProperty("os.name");
        if ((OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0) && (parent = System.getProperty("java.class.path")) != null) {
            currentPath = String.valueOf(new File(parent).getAbsolutePath()) + File.separator;
        }
        return currentPath;
    }

    public String getHomePath() {
        if (this.homePath != null) {
            return this.homePath;
        }
        this.homePath = String.valueOf(System.getProperty("user.home")) + File.separator + "M210Projects" + File.separator + this.appname + File.separator;
        File f = new File(this.homePath);
        if (!(f.exists() || f.mkdirs() || f.isDirectory())) {
            Console.Println("Can't create path \"" + this.homePath + '\"', Console.OSDTEXT_RED);
        }
        return this.homePath;
    }

    public CheckFiles checkResources(String path, boolean errorMessage) {
        File directory = new File(path);
        File[] fList = directory.listFiles();
        if (fList == null) {
            return new CheckFiles(false, null);
        }
        HashMap<String, File> filesMap = new HashMap<String, File>();
        File[] fileArray = fList;
        int n = fList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            filesMap.put(Strhandler.toLowerCase(file.getName()), file);
            ++n2;
        }
        String missingFiles = "<html>";
        boolean filesFound = true;
        ResFile[] resources = this.getResourceFiles();
        int i = 0;
        while (i < resources.length) {
            if (filesMap.get(resources[i].name) == null) {
                if (errorMessage) {
                    Console.Println(String.valueOf(this.appname) + " error: " + resources[i].name + " is missing!");
                }
                missingFiles = String.valueOf(missingFiles) + resources[i].name.toUpperCase() + " is missing<br>";
                filesFound = false;
            }
            ++i;
        }
        if (!filesFound) {
            return new CheckFiles(false, String.valueOf(missingFiles) + "</html>");
        }
        return new CheckFiles(true, null);
    }

    public BuildConfig getConfig() {
        if (this.currentConfig == null) {
            this.buildConfig(this.getHomePath());
        }
        return this.currentConfig;
    }

    public void setConfig(BuildConfig cfg) {
        this.currentConfig = cfg;
    }

    public String getName() {
        return this.getResourceName();
    }

    public abstract BuildConfig buildConfig(String var1);

    public abstract BuildGame getGame(String[] var1);

    public abstract void startGame(String var1);
}

