/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.FishChunk;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Fish {
    public static final int MAX_FISHS = 128;
    private static int FishCount;
    private static int nChunksFree;
    private static int[] nFreeChunk;
    private static FishChunk[] FishChunk;
    private static Enemy.EnemyStruct[] FishList;
    private static final short[][] ActionSeq_X_5;

    static {
        nFreeChunk = new int[128];
        FishChunk = new FishChunk[128];
        FishList = new Enemy.EnemyStruct[128];
        short[][] sArrayArray = new short[10][];
        short[] sArray = new short[2];
        sArray[0] = 8;
        sArrayArray[0] = sArray;
        short[] sArray2 = new short[2];
        sArray2[0] = 8;
        sArrayArray[1] = sArray2;
        sArrayArray[2] = new short[2];
        short[] sArray3 = new short[2];
        sArray3[0] = 24;
        sArrayArray[3] = sArray3;
        short[] sArray4 = new short[2];
        sArray4[0] = 8;
        sArrayArray[4] = sArray4;
        sArrayArray[5] = new short[]{32, 1};
        sArrayArray[6] = new short[]{33, 1};
        sArrayArray[7] = new short[]{34, 1};
        sArrayArray[8] = new short[]{35, 1};
        sArrayArray[9] = new short[]{39, 1};
        ActionSeq_X_5 = sArrayArray;
    }

    public static void InitFishes() {
        FishCount = 0;
        nChunksFree = 128;
        int i = 0;
        while (i < 128) {
            Fish.nFreeChunk[i] = i;
            ++i;
        }
        i = 0;
        while (i < 128) {
            if (FishChunk[i] == null) {
                Fish.FishChunk[i] = new FishChunk();
            }
            ++i;
        }
    }

    public static ByteBuffer saveFish() {
        ByteBuffer bb = ByteBuffer.allocate(FishCount * 16 + 3 + 1024);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)FishCount);
        bb.put((byte)nChunksFree);
        int i = 0;
        while (i < 128) {
            bb.putShort((short)nFreeChunk[i]);
            FishChunk[i].save(bb);
            ++i;
        }
        i = 0;
        while (i < FishCount) {
            FishList[i].save(bb);
            ++i;
        }
        return bb;
    }

    public static void loadFish(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.FishCount = bb.readShort().shortValue();
            loader.nChunksFree = bb.readByte() & 0xFF;
            int i = 0;
            while (i < 128) {
                loader.nFreeChunk[i] = bb.readShort().shortValue();
                if (loader.FishChunk[i] == null) {
                    loader.FishChunk[i] = new FishChunk();
                }
                loader.FishChunk[i].load(bb);
                ++i;
            }
            i = 0;
            while (i < loader.FishCount) {
                if (loader.FishList[i] == null) {
                    loader.FishList[i] = new Enemy.EnemyStruct();
                }
                loader.FishList[i].load(bb);
                ++i;
            }
        } else {
            FishCount = loader.FishCount;
            nChunksFree = loader.nChunksFree;
            int i = 0;
            while (i < 128) {
                Fish.nFreeChunk[i] = loader.nFreeChunk[i];
                if (FishChunk[i] == null) {
                    Fish.FishChunk[i] = new FishChunk();
                }
                FishChunk[i].copy(loader.FishChunk[i]);
                ++i;
            }
            i = 0;
            while (i < loader.FishCount) {
                if (FishList[i] == null) {
                    Fish.FishList[i] = new Enemy.EnemyStruct();
                }
                FishList[i].copy(loader.FishList[i]);
                ++i;
            }
        }
    }

    public static void BuildBlood(int a1, int a2, int a3, int a4) {
        Anim.BuildAnim(-1, 19, 36, a1, a2, a3, a4, 75, -128);
    }

    public static void BuildFishLimb(int a1, int a2) {
        if (nChunksFree > 0) {
            short nSprite = Fish.FishList[a1].nSprite;
            int nChunk = nFreeChunk[nChunksFree-- - 1];
            FishChunk pChunk = FishChunk[nChunk];
            short spr = Main.engine.insertsprite(Engine.sprite[nSprite].sectnum, (short)99);
            if (spr < 0 || spr >= Engine.MAXSPRITES) {
                Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
                return;
            }
            pChunk.nSprite = spr;
            pChunk.ActionSeq = (short)(a2 + 40);
            pChunk.nSeq = (short)(Random.RandomSize(3) % Seq.SeqSize[Seq.SeqOffsets[19] + pChunk.ActionSeq]);
            SPRITE pSprite = Engine.sprite[spr];
            pSprite.x = Engine.sprite[nSprite].x;
            pSprite.y = Engine.sprite[nSprite].y;
            pSprite.z = Engine.sprite[nSprite].z;
            pSprite.cstat = 0;
            pSprite.shade = (byte)-12;
            pSprite.pal = 0;
            pSprite.xvel = (short)((Random.RandomSize(5) & 0xFFFF) - 16 << 8);
            pSprite.yvel = (short)((Random.RandomSize(5) & 0xFFFF) - 16 << 8);
            pSprite.xrepeat = (short)64;
            pSprite.yrepeat = (short)64;
            pSprite.xoffset = 0;
            pSprite.yoffset = 0;
            pSprite.zvel = (short)(-2 * (Random.RandomByte() + 512));
            Seq.GetSeqPicnum(19, pChunk.ActionSeq, 0);
            pSprite.picnum = (short)a2;
            pSprite.lotag = (short)(RunList.HeadRun() + 1);
            pSprite.clipdist = 0;
            pSprite.extra = (short)-1;
            pSprite.owner = (short)RunList.AddRunRec(pSprite.lotag - 1, 0x200000 | nChunk);
            pSprite.hitag = (short)RunList.AddRunRec(RunList.NewRun, 0x200000 | nChunk);
        }
    }

    public static void BuildFish(int spr, int x, int y, int z, int sectnum, int ang) {
        int count;
        if ((count = FishCount++) >= 128) {
            return;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, (short)103);
        } else {
            x = Engine.sprite[spr].x;
            y = Engine.sprite[spr].y;
            z = Engine.sprite[spr].z;
            ang = Engine.sprite[spr].ang;
            Main.engine.changespritestat((short)spr, 103);
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = z;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].clipdist = 80;
        Engine.sprite[spr].xrepeat = (short)40;
        Engine.sprite[spr].yrepeat = (short)40;
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].picnum = Seq.GetSeqPicnum(19, ActionSeq_X_5[0][0], 0);
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        if (FishList[count] == null) {
            Fish.FishList[count] = new Enemy.EnemyStruct();
        }
        Fish.FishList[count].nState = 0;
        Fish.FishList[count].nHealth = (short)200;
        Fish.FishList[count].nSprite = (short)spr;
        Fish.FishList[count].nTarget = (short)-1;
        Fish.FishList[count].field_C = (short)60;
        Fish.FishList[count].nSeq = 0;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x120000 | count);
        Fish.FishList[count].nFunc = (short)RunList.AddRunRec(RunList.NewRun, 0x120000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void IdleFish(int nFish, int a2) {
        short nSprite = Fish.FishList[nFish].nSprite;
        Engine.sprite[nSprite].ang = (short)(Engine.sprite[nSprite].ang + (256 - Random.RandomSize(9) + 1024));
        Engine.sprite[nSprite].ang = (short)(Engine.sprite[nSprite].ang & 0x7FF);
        Engine.sprite[nSprite].xvel = (short)(Engine.sintable[Engine.sprite[nSprite].ang + 512 & 0x7FF] >> 8);
        Engine.sprite[nSprite].yvel = (short)(Engine.sintable[Engine.sprite[nSprite].ang & 0x7FF] >> 8);
        Fish.FishList[nFish].nState = 0;
        Fish.FishList[nFish].nSeq = 0;
        Engine.sprite[nSprite].zvel = (short)Random.RandomSize(9);
        if (a2 > 0) {
            return;
        }
        if (a2 == 0 && Random.RandomBit() == 0) {
            return;
        }
        Engine.sprite[nSprite].zvel = -Engine.sprite[nSprite].zvel;
    }

    private static short DestroyFish(int nFish) {
        RunList.DoSubRunRec(Engine.sprite[Fish.FishList[nFish].nSprite].owner);
        RunList.FreeRun(Engine.sprite[Fish.FishList[nFish].nSprite].lotag - 1);
        RunList.SubRunRec(Fish.FishList[nFish].nFunc);
        return Main.engine.mydeletesprite(Fish.FishList[nFish].nSprite);
    }

    public static void FuncFishLimb(int a1, int a2, int RunPtr) {
        short nChunk = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        short spr = Fish.FishChunk[nChunk].nSprite;
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        SPRITE pSprite = Engine.sprite[spr];
        int v6 = Seq.SeqOffsets[19] + Fish.FishChunk[nChunk].ActionSeq;
        switch (a1 & 0x7F0000) {
            case 131072: {
                pSprite.picnum = (short)Seq.GetSeqPicnum2(v6, Fish.FishChunk[nChunk].nSeq);
                Sprites.Gravity(spr);
                Fish.FishChunk[nChunk].nSeq = (short)(Fish.FishChunk[nChunk].nSeq + 1);
                if (Fish.FishChunk[nChunk].nSeq >= Seq.SeqSize[v6]) {
                    Fish.FishChunk[nChunk].nSeq = 0;
                    if (Random.RandomBit() != 0) {
                        Fish.BuildBlood(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum);
                    }
                }
                if (Engine.sector[pSprite.sectnum].floorz > pSprite.z) {
                    if (Main.engine.movesprite(spr, pSprite.xvel << 8, pSprite.yvel << 8, pSprite.zvel, 2560, -2560, 1) != 0) {
                        pSprite.yvel = 0;
                        pSprite.xvel = 0;
                    }
                } else {
                    pSprite.z += 256;
                    int dz = pSprite.z - Engine.sector[pSprite.sectnum].floorz;
                    if (dz <= 25600) {
                        if (dz > 0) {
                            pSprite.zvel = (short)1024;
                        }
                    } else {
                        pSprite.zvel = 0;
                        RunList.DoSubRunRec(pSprite.owner);
                        RunList.FreeRun(pSprite.lotag - 1);
                        RunList.SubRunRec(pSprite.hitag);
                        Main.engine.mydeletesprite(spr);
                    }
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence(a1 & 0xFFFF, v6, Fish.FishChunk[nChunk].nSeq, 1);
                return;
            }
        }
    }

    public static void FuncFish(int a1, int a2, int RunPtr) {
        short nFish = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nFish < 0 || nFish >= 128) {
            Main.game.ThrowError("Fish>=0 && Fish<MAX_FISHS");
            return;
        }
        short nSprite = Fish.FishList[nFish].nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = Fish.FishList[nFish].nState;
        short plr = (short)(a1 & 0xFFFF);
        int damage = a2;
        switch (a1 & 0x7F0000) {
            case 131072: {
                int v18;
                if ((Globals.SectFlag[Engine.sprite[nSprite].sectnum] & 0x2000) == 0) {
                    Sprites.Gravity(nSprite);
                }
                int v10 = ActionSeq_X_5[nState][0] + Seq.SeqOffsets[19];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(v10, Fish.FishList[nFish].nSeq);
                Seq.MoveSequence(nSprite, v10, Fish.FishList[nFish].nSeq);
                Fish.FishList[nFish].nSeq = (short)(Fish.FishList[nFish].nSeq + 1);
                if (Fish.FishList[nFish].nSeq >= Seq.SeqSize[v10]) {
                    Fish.FishList[nFish].nSeq = 0;
                }
                int nTarget = Fish.FishList[nFish].nTarget;
                switch (nState) {
                    default: {
                        return;
                    }
                    case 4: {
                        if (Fish.FishList[nFish].nSeq == 0) {
                            Fish.IdleFish(nFish, 0);
                        }
                        return;
                    }
                    case 9: {
                        if (Fish.FishList[nFish].nSeq == 0) {
                            Fish.DestroyFish(nFish);
                        }
                        return;
                    }
                    case 2: 
                    case 3: {
                        Fish.FishList[nFish].field_C = (short)(Fish.FishList[nFish].field_C - 1);
                        if (Fish.FishList[nFish].field_C <= 0) {
                            Fish.IdleFish(nFish, 0);
                            return;
                        }
                        if (nTarget == -1) break;
                        Enemy.PlotCourseToSprite(nSprite, nTarget);
                        int dz = Engine.sprite[nTarget].z - Engine.sprite[nSprite].z;
                        if (Pragmas.klabs(dz) <= Sprites.GetSpriteHeight(nSprite) >> 1) {
                            short cos = Engine.sintable[Engine.sprite[nSprite].ang + 512 & 0x7FF];
                            short sin = Engine.sintable[Engine.sprite[nSprite].ang & 0x7FF];
                            Engine.sprite[nSprite].xvel = (short)((cos >> 5) - (cos >> 7));
                            Engine.sprite[nSprite].yvel = (short)((sin >> 5) - (sin >> 7));
                        } else {
                            Engine.sprite[nSprite].xvel = 0;
                            Engine.sprite[nSprite].yvel = 0;
                        }
                        Engine.sprite[nSprite].zvel = (short)(dz >> 3);
                        break;
                    }
                    case 0: {
                        Fish.FishList[nFish].field_C = (short)(Fish.FishList[nFish].field_C - 1);
                        if (Fish.FishList[nFish].field_C > 0) break;
                        nTarget = Enemy.FindPlayer(nSprite, 60);
                        if (nTarget < 0) {
                            Fish.IdleFish(nFish, 0);
                            break;
                        }
                        Fish.FishList[nFish].nTarget = (short)nTarget;
                        Fish.FishList[nFish].nState = (short)2;
                        Fish.FishList[nFish].nSeq = 0;
                        Engine.sprite[nSprite].zvel = (short)(Engine.sintable[Main.engine.GetMyAngle(Engine.sprite[nTarget].x - Engine.sprite[nSprite].x, Engine.sprite[nTarget].z - Engine.sprite[nSprite].z) & 0x7FF] >> 5);
                        Fish.FishList[nFish].field_C = (short)(Random.RandomSize(6) + 90);
                    }
                }
                int ox = Engine.sprite[nSprite].x;
                int oy = Engine.sprite[nSprite].y;
                int oz = Engine.sprite[nSprite].z;
                short osect = Engine.sprite[nSprite].sectnum;
                int hitMove = Main.engine.movesprite(nSprite, Engine.sprite[nSprite].xvel << 13, Engine.sprite[nSprite].yvel << 13, 4 * Engine.sprite[nSprite].zvel, 0, 0, 0);
                if ((Globals.SectFlag[Engine.sprite[nSprite].sectnum] & 0x2000) != 0) {
                    if (nState >= 5) {
                        return;
                    }
                    if (hitMove == 0) {
                        if (nState == 3) {
                            Fish.FishList[nFish].nState = (short)2;
                            Fish.FishList[nFish].nSeq = 0;
                        }
                        return;
                    }
                    if ((hitMove & 0x30000) == 0) {
                        switch (hitMove & 0xC000) {
                            default: {
                                return;
                            }
                            case 49152: {
                                int nHitObject = hitMove & 0x3FFF;
                                if (Gameutils.isValidSprite(nHitObject) && Engine.sprite[nHitObject].statnum == 100) {
                                    Fish.FishList[nFish].nTarget = (short)nHitObject;
                                    nTarget = Fish.FishList[nFish].nTarget;
                                    Engine.sprite[nSprite].ang = Main.engine.GetMyAngle(Engine.sprite[nTarget].x - Engine.sprite[nSprite].x, Engine.sprite[nTarget].y - Engine.sprite[nSprite].y);
                                    if (nState != 3) {
                                        Fish.FishList[nFish].nState = (short)3;
                                        Fish.FishList[nFish].nSeq = 0;
                                    }
                                    if (Fish.FishList[nFish].nSeq == 0) {
                                        Sprites.DamageEnemy(nTarget, nSprite, 2);
                                    }
                                }
                                return;
                            }
                            case 32768: 
                        }
                        Fish.IdleFish(nFish, 0);
                        return;
                    }
                    v18 = (hitMove & 0x20000) != 0 ? -1 : 1;
                } else {
                    Main.engine.mychangespritesect(nSprite, osect);
                    Engine.sprite[nSprite].x = ox;
                    Engine.sprite[nSprite].y = oy;
                    Engine.sprite[nSprite].z = oz;
                    v18 = 0;
                }
                Fish.IdleFish(nFish, v18);
                return;
            }
            case 589824: {
                Seq.PlotSequence(plr, ActionSeq_X_5[Fish.FishList[nFish].nState][0] + Seq.SeqOffsets[19], Fish.FishList[nFish].nSeq, ActionSeq_X_5[Fish.FishList[nFish].nState][1]);
                return;
            }
            case 655360: {
                if (Fish.FishList[nFish].nHealth <= 0) {
                    return;
                }
                damage = Sprites.CheckRadialDamage(nSprite);
                if (damage != 0) {
                    Fish.FishList[nFish].field_C = (short)10;
                }
            }
            case 524288: {
                if (damage != 0 && Fish.FishList[nFish].nHealth > 0) {
                    Fish.FishList[nFish].nHealth = (short)(Fish.FishList[nFish].nHealth - damage);
                    if (Fish.FishList[nFish].nHealth > 0) {
                        if (plr >= 0 && Engine.sprite[plr].statnum < 199) {
                            Fish.FishList[nFish].nTarget = plr;
                        }
                        Fish.FishList[nFish].nSeq = 0;
                        Fish.FishList[nFish].nState = (short)4;
                        Fish.FishList[nFish].field_C = (short)(Fish.FishList[nFish].field_C + 10);
                    } else {
                        Fish.FishList[nFish].nHealth = 0;
                        pSprite.cstat = (short)(pSprite.cstat & 0xFEFE);
                        if ((a1 & 0x7F0000) != 524288) {
                            Fish.FishList[nFish].nState = (short)9;
                            Fish.FishList[nFish].nSeq = 0;
                            return;
                        }
                        int i = 0;
                        while (i < 3) {
                            Fish.BuildFishLimb(nFish, i);
                            ++i;
                        }
                        Sound.PlayFXAtXYZ(Sound.StaticSound[40], Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z, Engine.sprite[nSprite].sectnum);
                        Fish.DestroyFish(nFish);
                        --Globals.nCreaturesLeft;
                    }
                }
                return;
            }
        }
    }
}

