/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Rat {
    public static final int MAX_RAT = 50;
    private static int nRatCount;
    private static int nMinChunk;
    private static int nMaxChunk;
    private static Enemy.EnemyStruct[] RatList;
    private static final short[][] ActionSeq_X_14;

    static {
        RatList = new Enemy.EnemyStruct[50];
        short[][] sArrayArray = new short[5][];
        short[] sArray = new short[2];
        sArray[1] = 1;
        sArrayArray[0] = sArray;
        short[] sArray2 = new short[2];
        sArray2[0] = 1;
        sArrayArray[1] = sArray2;
        short[] sArray3 = new short[2];
        sArray3[0] = 1;
        sArrayArray[2] = sArray3;
        sArrayArray[3] = new short[]{9, 1};
        short[] sArray4 = new short[2];
        sArray4[1] = 1;
        sArrayArray[4] = sArray4;
        ActionSeq_X_14 = sArrayArray;
    }

    public static void InitRats() {
        nRatCount = 0;
        nMinChunk = 9999;
        nMaxChunk = -1;
        int i = 122;
        while (i <= 131) {
            short pic = Seq.GetSeqPicnum(25, i, 0);
            if (pic < nMinChunk) {
                nMinChunk = pic;
            }
            if (pic > nMaxChunk) {
                nMaxChunk = pic;
            }
            ++i;
        }
        Globals.nPlayerPic = Seq.GetSeqPicnum(25, 120, 0);
    }

    public static ByteBuffer saveRat() {
        ByteBuffer bb = ByteBuffer.allocate(nRatCount * 16 + 14);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)nRatCount);
        int i = 0;
        while (i < nRatCount) {
            RatList[i].save(bb);
            ++i;
        }
        bb.putInt(nMinChunk);
        bb.putInt(nMaxChunk);
        bb.putInt(Globals.nPlayerPic);
        return bb;
    }

    public static void loadRat(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.nRatCount = bb.readShort().shortValue();
            int i = 0;
            while (i < loader.nRatCount) {
                if (loader.RatList[i] == null) {
                    loader.RatList[i] = new Enemy.EnemyStruct();
                }
                loader.RatList[i].load(bb);
                ++i;
            }
            loader.nMinChunk = bb.readInt();
            loader.nMaxChunk = bb.readInt();
            loader.nPlayerPic = bb.readInt();
        } else {
            nRatCount = loader.nRatCount;
            int i = 0;
            while (i < loader.nRatCount) {
                if (RatList[i] == null) {
                    Rat.RatList[i] = new Enemy.EnemyStruct();
                }
                RatList[i].copy(loader.RatList[i]);
                ++i;
            }
            nMinChunk = loader.nMinChunk;
            nMaxChunk = loader.nMaxChunk;
            Globals.nPlayerPic = loader.nPlayerPic;
        }
    }

    public static void SetRatVel(int a1) {
        Engine.sprite[a1].xvel = (short)(Engine.sintable[Engine.sprite[a1].ang + 512 & 0x7FF] >> 2);
        Engine.sprite[a1].yvel = (short)(Engine.sintable[Engine.sprite[a1].ang & 0x7FF] >> 2);
    }

    public static int BuildRat(int spr, int x, int y, int z, int sectnum, int ang) {
        if (nRatCount >= 50) {
            return -1;
        }
        int count = nRatCount++;
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, (short)108);
            Engine.sprite[spr].x = x;
            Engine.sprite[spr].y = x;
            Engine.sprite[spr].z = x;
        } else {
            ang = Engine.sprite[spr].ang;
            Main.engine.changespritestat((short)spr, 108);
        }
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].clipdist = 30;
        Engine.sprite[spr].xrepeat = (short)50;
        Engine.sprite[spr].yrepeat = (short)50;
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        if (RatList[count] == null) {
            Rat.RatList[count] = new Enemy.EnemyStruct();
        }
        Rat.RatList[count].nState = ang >= 0 ? (short)2 : (short)4;
        Rat.RatList[count].nSeq = 0;
        Rat.RatList[count].nSprite = (short)spr;
        Rat.RatList[count].nTarget = (short)-1;
        Rat.RatList[count].field_A = (short)Random.RandomSize(5);
        Rat.RatList[count].field_C = (short)Random.RandomSize(3);
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x240000 | count);
        Rat.RatList[count].nFunc = (short)RunList.AddRunRec(RunList.NewRun, 0x240000 | count);
        return spr;
    }

    public static int FindFood(int a1) {
        int v9;
        short v10;
        int v6;
        short v7;
        short sectnum = Engine.sprite[a1].sectnum;
        int sx = Engine.sprite[a1].x;
        int sy = Engine.sprite[a1].y;
        int sz = (Engine.sector[Engine.sprite[a1].sectnum].ceilingz + Engine.sprite[a1].z) / 2;
        if (Sprites.nChunkTotal != 0 && (v7 = Sprites.nChunkSprite[v6 = Random.RandomSize(7) % Sprites.nChunkTotal]) != -1 && Main.engine.cansee(sx, sy, sz, sectnum, Engine.sprite[v7].x, Engine.sprite[v7].y, Engine.sprite[v7].z, Engine.sprite[v7].sectnum)) {
            return Sprites.nChunkSprite[v6];
        }
        if (Sprites.nBodyTotal != 0 && (v10 = Sprites.nBodySprite[v9 = Random.RandomSize(7) % Sprites.nBodyTotal]) != -1 && Globals.nPlayerPic == Engine.sprite[v10].picnum && Main.engine.cansee(sx, sy, Engine.sprite[a1].z, Engine.sprite[a1].sectnum, Engine.sprite[v10].x, Engine.sprite[v10].y, Engine.sprite[v10].z, Engine.sprite[v10].sectnum)) {
            return Sprites.nBodySprite[v9];
        }
        return -1;
    }

    public static void FuncRat(int a1, int a2, int RunPtr) {
        short nRat = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        short nSprite = Rat.RatList[nRat].nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = Rat.RatList[nRat].nState;
        short plr = (short)(a1 & 0xFFFF);
        int damage = a2;
        switch (a1 & 0x7F0000) {
            case 131072: {
                boolean v51 = false;
                int v10 = ActionSeq_X_14[nState][0] + Seq.SeqOffsets[77];
                short v13 = Rat.RatList[nRat].nSeq;
                pSprite.picnum = (short)Seq.GetSeqPicnum2(v10, v13);
                Seq.MoveSequence(nSprite, v10, v13);
                Rat.RatList[nRat].nSeq = (short)(Rat.RatList[nRat].nSeq + 1);
                if (Rat.RatList[nRat].nSeq >= Seq.SeqSize[v10]) {
                    Rat.RatList[nRat].nSeq = 0;
                    v51 = true;
                }
                short nTarget = Rat.RatList[nRat].nTarget;
                Sprites.Gravity(nSprite);
                switch (nState) {
                    case 2: {
                        if ((pSprite.yvel | pSprite.xvel | pSprite.zvel) != 0) {
                            if (Globals.isOriginal()) {
                                Enemy.MoveCreature(nSprite);
                            } else {
                                Enemy.MoveCreatureWithCaution(nSprite);
                            }
                        }
                        Rat.RatList[nRat].field_A = (short)(Rat.RatList[nRat].field_A - 1);
                        if (Rat.RatList[nRat].field_A > 0) break;
                        Rat.RatList[nRat].nTarget = (short)Rat.FindFood(nSprite);
                        if (Rat.RatList[nRat].nTarget > -1) {
                            Enemy.PlotCourseToSprite(nSprite, Rat.RatList[nRat].nTarget);
                            Rat.SetRatVel(nSprite);
                            Rat.RatList[nRat].nState = 1;
                            Rat.RatList[nRat].field_C = (short)900;
                            Rat.RatList[nRat].nSeq = 0;
                            break;
                        }
                        Rat.RatList[nRat].field_A = (short)Random.RandomSize(6);
                        if ((pSprite.xvel | pSprite.yvel) != 0) {
                            pSprite.yvel = 0;
                            pSprite.xvel = 0;
                            break;
                        }
                        pSprite.ang = (short)Random.RandomSize(11);
                        Rat.SetRatVel(nSprite);
                        break;
                    }
                    case 1: {
                        Rat.RatList[nRat].field_C = (short)(Rat.RatList[nRat].field_C - 1);
                        if (Rat.RatList[nRat].field_C <= 0) {
                            Rat.RatList[nRat].nState = (short)2;
                            Rat.RatList[nRat].nSeq = 0;
                            Rat.RatList[nRat].nTarget = (short)-1;
                            pSprite.xvel = 0;
                            pSprite.yvel = 0;
                        }
                        if (Globals.isOriginal()) {
                            Enemy.MoveCreature(nSprite);
                        } else {
                            Enemy.MoveCreatureWithCaution(nSprite);
                        }
                        if (Pragmas.klabs(Engine.sprite[nSprite].x - Engine.sprite[nTarget].x) >= 50 || Pragmas.klabs(Engine.sprite[nSprite].y - Engine.sprite[nTarget].y) >= 50) {
                            Rat.RatList[nRat].field_A = (short)(Rat.RatList[nRat].field_A - 1);
                            if (Rat.RatList[nRat].field_A >= 0) break;
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            Rat.SetRatVel(nSprite);
                            Rat.RatList[nRat].field_A = (short)32;
                            break;
                        }
                        Rat.RatList[nRat].nState = 0;
                        Rat.RatList[nRat].nSeq = 0;
                        Rat.RatList[nRat].field_C = (short)Random.RandomSize(3);
                        pSprite.xvel = 0;
                        pSprite.yvel = 0;
                        break;
                    }
                    case 0: {
                        Rat.RatList[nRat].field_A = (short)(Rat.RatList[nRat].field_A - 1);
                        if (Rat.RatList[nRat].field_A > 0) break;
                        if (Pragmas.klabs(Engine.sprite[nSprite].x - Engine.sprite[nTarget].x) <= 50 && Pragmas.klabs(Engine.sprite[nSprite].y - Engine.sprite[nTarget].y) <= 50) {
                            int v44;
                            Rat.RatList[nRat].nSeq = (short)(Rat.RatList[nRat].nSeq ^ 1);
                            Rat.RatList[nRat].field_A = (short)(Random.RandomSize(5) + 4);
                            Rat.RatList[nRat].field_C = (short)(Rat.RatList[nRat].field_C - 1);
                            if (Rat.RatList[nRat].field_C > 0 || (v44 = Rat.FindFood(nSprite)) == -1) break;
                            Rat.RatList[nRat].nTarget = (short)v44;
                            Enemy.PlotCourseToSprite(nSprite, v44);
                            Rat.SetRatVel(nSprite);
                            Rat.RatList[nRat].nState = 1;
                            Rat.RatList[nRat].field_C = (short)900;
                            Rat.RatList[nRat].nSeq = 0;
                            break;
                        }
                        Rat.RatList[nRat].nState = (short)2;
                        Rat.RatList[nRat].nSeq = 0;
                        Rat.RatList[nRat].nTarget = (short)-1;
                        Engine.sprite[nSprite].xvel = 0;
                        Engine.sprite[nSprite].yvel = 0;
                        break;
                    }
                    case 3: {
                        if (!v51) break;
                        RunList.DoSubRunRec(Engine.sprite[nSprite].owner);
                        RunList.FreeRun(Engine.sprite[nSprite].lotag - 1);
                        RunList.SubRunRec(Rat.RatList[nRat].nFunc);
                        Engine.sprite[nSprite].cstat = Short.MIN_VALUE;
                        Main.engine.mydeletesprite(nSprite);
                    }
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence(plr, ActionSeq_X_14[nState][0] + Seq.SeqOffsets[77], Rat.RatList[nRat].nSeq, ActionSeq_X_14[nState][1]);
                return;
            }
            case 655360: {
                damage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (damage != 0) {
                    Engine.sprite[nSprite].cstat = 0;
                    Engine.sprite[nSprite].xvel = 0;
                    Engine.sprite[nSprite].yvel = 0;
                    Rat.RatList[nRat].nSeq = 0;
                    Rat.RatList[nRat].nState = (short)3;
                }
                return;
            }
        }
    }
}

