/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Menus;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Menus.RRTitle;
import ru.m210projects.Redneck.Sounds;

public class TrackPlayerMenu
extends BuildMenu {
    public TrackPlayerMenu() {
        this.addItem(new RRTitle("8 Track Player"), false);
        this.addItem(new TrackItem(160, 90), true);
        this.addItem(new PowerSwitch(74, 109), false);
        this.addItem(new MenuSlider(Main.game.pSlider, "Music volume", Main.game.getFont(1), 45, 140, 230, (int)(Main.cfg.musicVolume * 256.0f), 0, 256, 8, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                Main.cfg.musicVolume = (float)slider.value / 256.0f;
                BuildGdx.audio.setVolume(BuildAudio.Driver.Music, Main.cfg.musicVolume);
            }
        }, false){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!Main.cfg.muteMusic && BuildGdx.audio.getSound().getDigitalMusic() != null && BuildGdx.audio.getSound().getDigitalMusic().isInited());
                super.draw(handler);
            }
        }, false);
        this.addItem(new MenuSwitch("Shuffle", Main.game.getFont(1), 45, 155, 230, Main.cfg.gShuffleMusic, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                Main.cfg.gShuffleMusic = sw.value;
            }
        }, null, null){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!Main.cfg.muteMusic && BuildGdx.audio.getSound().getDigitalMusic() != null && BuildGdx.audio.getSound().getDigitalMusic().isInited());
                super.draw(handler);
            }
        }, false);
    }

    private class PowerSwitch
    extends MenuSwitch {
        public PowerSwitch(int x, int y) {
            super(null, null, x, y, 320, Main.cfg.muteMusic, null, null, null);
        }

        @Override
        public void draw(MenuHandler handler) {
            if (Main.cfg.muteMusic) {
                Main.engine.rotatesprite(this.x << 16, this.y << 16, 48000, 0, 372, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            } else {
                Main.engine.rotatesprite(this.x << 16, this.y << 16, 48000, 0, 373, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            if (this.isFocused()) {
                Main.engine.rotatesprite(this.x - 50 << 16, this.y + Main.engine.getTile(512).getHeight() - 20 << 16, 8192, 0, 896 + (Engine.totalclock >> 3 & 0xF), 8 - (Engine.totalclock & 0x3F), 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
        }

        @Override
        public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
            switch (opt) {
                case ENTER: 
                case LMB: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    boolean bl = Main.cfg.muteMusic = !Main.cfg.muteMusic;
                    if (Main.cfg.muteMusic) {
                        BuildGdx.audio.setVolume(BuildAudio.Driver.Music, 0.0f);
                    } else {
                        BuildGdx.audio.setVolume(BuildAudio.Driver.Music, Main.cfg.musicVolume);
                    }
                    Sounds.sound(0);
                    break;
                }
                default: {
                    return this.m_pMenu.mNavigation(opt);
                }
            }
            return false;
        }

        @Override
        public boolean mouseAction(int mx, int my) {
            return mx > this.x - 15 && mx < this.x + 15 && my > this.y - 15 && my < this.y + 10;
        }
    }

    private class TrackItem
    extends MenuItem {
        final int x;
        final int y;
        final int[] tx;
        final int[] ty;
        int TrackFocus;

        public TrackItem(int x, int y) {
            super(null, null);
            this.TrackFocus = -1;
            this.x = x;
            this.y = y;
            this.flags = 7;
            this.tx = new int[]{x - 101, x - 70, x - 41, x - 12};
            this.ty = new int[]{y - 33, y - 18};
        }

        @Override
        public void draw(MenuHandler handler) {
            Main.engine.rotatesprite(this.x << 16, this.y << 16, 48000, 0, 370, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            if (!Main.cfg.muteMusic) {
                int num;
                if (Sounds.currMusic != null && Sounds.currMusic.isPlaying() && (num = Sounds.currTrack) >= 0 && num < 8) {
                    Main.engine.rotatesprite(this.tx[num % 4] << 16, this.ty[num / 4 & 1] << 16, 48000, 0, 371, 0, 0, 26, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
                if (this.TrackFocus != -1 && (Engine.totalclock & 0x10) != 0 && this.isFocused()) {
                    Main.engine.rotatesprite(this.tx[this.TrackFocus % 4] << 16, this.ty[this.TrackFocus / 4 & 1] << 16, 48000, 0, 371, 0, 0, 26, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
            }
            if (this.isFocused()) {
                Main.engine.rotatesprite(this.x - 136 << 16, this.y + Main.engine.getTile(512).getHeight() - 40 << 16, 8192, 0, 896 + (Engine.totalclock >> 3 & 0xF), 8 - (Engine.totalclock & 0x3F), 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
        }

        private void changeTrack(int num) {
            if (num != -1 && !Sounds.sndPlayTrack(num)) {
                Console.Println("Music track not found!");
            }
        }

        @Override
        public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
            switch (opt) {
                case ENTER: 
                case LMB: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    Sounds.sound(2);
                    this.changeTrack(this.TrackFocus);
                    break;
                }
                case LEFT: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    Sounds.sound(335);
                    --this.TrackFocus;
                    this.TrackFocus &= 7;
                    break;
                }
                case RIGHT: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    Sounds.sound(335);
                    ++this.TrackFocus;
                    this.TrackFocus &= 7;
                    break;
                }
                case UP: {
                    int line = this.TrackFocus / 4;
                    if (!Main.cfg.muteMusic && line == 1) {
                        this.TrackFocus -= 4;
                        this.TrackFocus &= 7;
                        break;
                    }
                    this.m_pMenu.mNavUp();
                    break;
                }
                case DW: {
                    int line = this.TrackFocus / 4;
                    if (!Main.cfg.muteMusic && line == 0) {
                        this.TrackFocus += 4;
                        this.TrackFocus &= 7;
                        break;
                    }
                    this.m_pMenu.mNavDown();
                    break;
                }
                default: {
                    return this.m_pMenu.mNavigation(opt);
                }
            }
            return false;
        }

        @Override
        public boolean mouseAction(int mx, int my) {
            int i = 0;
            while (i < 4) {
                if (mx > this.tx[i] && mx < this.tx[i] + 10) {
                    int j = 0;
                    while (j < 2) {
                        if (my > this.ty[j] && my < this.ty[j] + 10) {
                            this.TrackFocus = i + 4 * j;
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return false;
        }

        @Override
        public void open() {
            this.TrackFocus = Sounds.currTrack;
        }

        @Override
        public void close() {
        }
    }
}

