/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Screens;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.AnimFile;

public class AnmScreen
extends SkippableAdapter {
    private Runnable callback;
    private int gCutsClock;
    private AnimFile anmfil;
    private int lastanimhack;
    private int frame;
    private long anmtime;
    private long LastMS;
    private String name;

    public AnmScreen(BuildGame game) {
        super(game);
    }

    @Override
    public void show() {
        if (this.game.pMenu.gShowMenu) {
            this.game.pMenu.mClose();
        }
        this.engine.sampletimer();
        this.LastMS = this.engine.getticks();
        Engine.totalclock = 0;
        this.gCutsClock = 0;
        Sounds.StopAllSounds();
        Sounds.sndStopMusic();
    }

    @Override
    public void hide() {
        this.engine.setbrightness(Globals.ud.brightness >> 2, Engine.palette, GLRenderer.GLInvalidateFlag.All);
    }

    @Override
    public void skip() {
        this.anmClose();
        super.skip();
    }

    public AnmScreen setCallback(Runnable callback) {
        this.callback = callback;
        this.setSkipping(callback);
        return this;
    }

    public boolean init(String fn, int t) {
        if (this.anmfil != null) {
            return false;
        }
        byte[] animbuf = BuildGdx.cache.getBytes(fn, 0);
        if (animbuf == null) {
            return false;
        }
        try {
            this.anmfil = new AnimFile(animbuf);
            Tile pic = this.engine.getTile(Globals.TILE_ANIM);
            pic.setWidth(200);
            pic.setHeight(320);
            this.lastanimhack = t;
            this.frame = 1;
            this.anmtime = 0L;
            this.LastMS = -1L;
            this.name = fn;
            pic.data = null;
            byte[] pal = this.anmfil.getPalette();
            this.engine.changepalette(pal);
            int white = -1;
            int k = 0;
            int i = 0;
            while (i < 256) {
                int j = (pal[3 * i] & 0xFF) + (pal[3 * i + 1] & 0xFF) + (pal[3 * i + 2] & 0xFF);
                if (j > k) {
                    k = j;
                    white = i;
                }
                i += 3;
            }
            int palnum = 250;
            byte[] remapbuf = new byte[768];
            int i2 = 0;
            while (i2 < 768) {
                remapbuf[i2] = (byte)white;
                ++i2;
            }
            this.engine.makepalookup(palnum, remapbuf, 0, 1, 0, 1);
            i2 = 0;
            while (i2 < 256) {
                int tile = this.game.getFont(3).getTile(i2);
                if (tile >= 0) {
                    this.engine.invalidatetile(tile, palnum, -1);
                }
                ++i2;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean anmPlay() {
        if (this.anmfil != null) {
            if (this.LastMS == -1L) {
                this.LastMS = this.engine.getticks();
            }
            long ms = this.engine.getticks();
            long dt = ms - this.LastMS;
            this.anmtime += dt;
            float rate = 1000.0f;
            if (this.name.equalsIgnoreCase("redneck.anm")) {
                rate = 700.0f;
            }
            if (this.name.equalsIgnoreCase("rr_outro.anm")) {
                rate = 1200.0f;
            }
            if (this.lastanimhack == -1) {
                rate = 2000.0f;
            }
            float tick = rate / (float)this.anmfil.getRate();
            Tile pic = this.engine.getTile(Globals.TILE_ANIM);
            if ((float)this.anmtime >= tick) {
                if (this.frame < this.anmfil.numFrames()) {
                    pic.data = this.anmfil.draw(this.frame);
                    this.engine.invalidatetile(Globals.TILE_ANIM, 251, -1);
                    AnmScreen.logoanimsounds(this.frame, this.lastanimhack);
                    ++this.frame;
                }
                this.anmtime = (long)((float)this.anmtime - tick);
            }
            this.LastMS = ms;
            if (pic.getWidth() <= 0) {
                return false;
            }
            if (pic.data != null) {
                this.engine.rotatesprite(0, 0, 65536, 512, Globals.TILE_ANIM, 0, 251, 94, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            return this.frame < this.anmfil.numFrames();
        }
        return false;
    }

    @Override
    public void draw(float delta) {
        if (!this.anmPlay() && this.skipCallback != null) {
            this.anmClose();
            if (this.callback != null) {
                BuildGdx.app.postRunnable(this.callback);
                this.callback = null;
            }
        }
        if (this.game.pInput.ctrlKeyStatus(256)) {
            this.gCutsClock = Engine.totalclock;
        }
        int shade = 8 + Pragmas.mulscale(32L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
        if (Engine.totalclock - this.gCutsClock < 200 && this.escSkip) {
            this.game.getFont(3).drawText(160, 5, "Press ESC to skip", shade, 250, BuildFont.TextAlign.Center, 2, true);
        }
    }

    public boolean isInited() {
        return this.anmfil != null;
    }

    public void anmClose() {
        this.anmfil = null;
    }

    public static void logoanimsounds(int fr, int num) {
        switch (num) {
            case 0: {
                if (fr != 1) break;
                Sounds.sound(29);
                break;
            }
            case 1: {
                if (fr != 1) break;
                Sounds.sound(478);
                break;
            }
            case 2: {
                if (fr != 1) break;
                Sounds.sound(479);
                break;
            }
            case 5: {
                if (fr != 1 || Globals.currentGame.getCON().type == 1) break;
                Sounds.sound(35);
                break;
            }
            case 6: {
                if (fr != 1 || Globals.currentGame.getCON().type == 1) break;
                Sounds.sound(82);
            }
        }
    }
}

