/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.PrecacheAdapter;
import ru.m210projects.Build.Types.Tile;

public class PrecacheScreen
extends PrecacheAdapter {
    public PrecacheScreen(BuildGame game) {
        super(game);
        this.addQueue("Preload floor and ceiling tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numsectors) {
                    PrecacheScreen.this.addTile(Engine.sector[i].floorpicnum);
                    PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum);
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload wall tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numwalls) {
                    PrecacheScreen.this.addTile(Engine.wall[i].picnum);
                    if (Engine.wall[i].overpicnum >= 0) {
                        PrecacheScreen.this.addTile(Engine.wall[i].overpicnum);
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload sprite tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.MAXSPRITES) {
                    if (Engine.sprite[i].statnum < 1024) {
                        PrecacheScreen.this.addTile(Engine.sprite[i].picnum);
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
    }

    @Override
    protected void draw(String title, int index) {
        Tile pic = this.engine.getTile(406);
        int frames = Engine.xdim / pic.getWidth();
        int x = 160;
        int i = 0;
        while (i <= frames) {
            this.engine.rotatesprite(x << 16, 0x640000, 65536, 0, 406, 0, 0, 266, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            x += pic.getWidth();
            ++i;
        }
        this.game.getFont(0).drawText(160, 100, "Loading...", 0, 0, BuildFont.TextAlign.Center, 0, false);
        this.game.getFont(0).drawText(160, 120, title, 0, 0, BuildFont.TextAlign.Center, 0, false);
    }
}

