/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Ripper;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Bunny {
    public static int Bunny_Count = 0;
    private static final Decision[] BunnyBattle = new Decision[]{new Decision(748, Ai.InitActorMoveCloser), new Decision(750, Ai.InitActorAlertNoise), new Decision(760, Ai.InitActorAttackNoise), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] BunnyOffense = new Decision[]{new Decision(600, Ai.InitActorMoveCloser), new Decision(700, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] BunnyBroadcast = new Decision[]{new Decision(21, Ai.InitActorAlertNoise), new Decision(51, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] BunnySurprised = new Decision[]{new Decision(500, Ai.InitActorRunAway), new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] BunnyEvasive = new Decision[]{new Decision(500, Ai.InitActorWanderAround), new Decision(1020, Ai.InitActorRunAway), new Decision(1024, Ai.InitActorAmbientNoise)};
    private static final Decision[] BunnyLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] BunnyCloseRange = new Decision[]{new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] BunnyWander = new Decision[]{new Decision(1024, Ai.InitActorReposition)};
    private static final Personality WhiteBunnyPersonality = new Personality(BunnyBattle, BunnyOffense, BunnyBroadcast, BunnySurprised, BunnyEvasive, BunnyLostTarget, BunnyCloseRange, BunnyCloseRange);
    private static final Personality BunnyPersonality = new Personality(BunnyEvasive, BunnyEvasive, BunnyEvasive, BunnyWander, BunnyWander, BunnyWander, BunnyEvasive, BunnyEvasive);
    private static final ATTRIBUTE BunnyAttrib;
    private static final ATTRIBUTE WhiteBunnyAttrib;
    public static final int BUNNY_RUN_RATE = 10;
    public static final Animator DoBunnyMove;
    public static final Animator DoBunnyGrowUp;
    private static final State[][] s_BunnyRun;
    public static final int BUNNY_STAND_RATE = 12;
    public static final Animator DoBunnyEat;
    private static final State[][] s_BunnyStand;
    public static final int BUNNY_SCREW_RATE = 16;
    public static final Animator DoBunnyScrew;
    private static final State[][] s_BunnyScrew;
    public static final int BUNNY_SWIPE_RATE = 8;
    public static final Animator NullBunny;
    public static final Animator InitBunnySlash;
    private static final State[][] s_BunnySwipe;
    public static final int BUNNY_HEART_RATE = 14;
    public static final Animator DoBunnyStandKill;
    private static final State[][] s_BunnyHeart;
    public static final int BUNNY_PAIN_RATE = 38;
    public static final Animator DoBunnyPain;
    private static final State[][] s_BunnyPain;
    public static final int BUNNY_JUMP_RATE = 25;
    public static final Animator DoBunnyMoveJump;
    private static final State[][] s_BunnyJump;
    public static final int BUNNY_FALL_RATE = 25;
    private static final State[][] s_BunnyFall;
    public static final int BUNNY_JUMP_ATTACK_RATE = 35;
    public static final Animator DoBunnyBeginJumpAttack;
    public static final int BUNNY_DIE_RATE = 16;
    public static final Animator BunnySpew;
    private static final State[] s_BunnyDie;
    public static final int BUNNY_DEAD_RATE = 8;
    private static final State[] s_BunnyDead;
    public static final Animator DoActorDeathMove;
    private static final State[] s_BunnyDeathJump;
    private static final State[] s_BunnyDeathFall;
    private static final Actor_Action_Set BunnyActionSet;
    private static final Actor_Action_Set BunnyWhiteActionSet;

    static {
        short[] sArray = new short[4];
        sArray[0] = 5;
        sArray[2] = -2;
        sArray[3] = -4;
        int[] nArray = new int[10];
        nArray[0] = 428;
        nArray[2] = 424;
        nArray[3] = 424;
        nArray[4] = 426;
        BunnyAttrib = new ATTRIBUTE(new short[]{100, 120, 140, 180}, sArray, 3, nArray);
        short[] sArray2 = new short[4];
        sArray2[0] = 5;
        sArray2[2] = -2;
        sArray2[3] = -4;
        int[] nArray2 = new int[10];
        nArray2[0] = 428;
        nArray2[2] = 424;
        nArray2[3] = 424;
        nArray2[4] = 426;
        WhiteBunnyAttrib = new ATTRIBUTE(new short[]{200, 220, 340, 380}, sArray2, 3, nArray2);
        DoBunnyMove = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Bunny.DoBunnyMove(spr) != 0;
            }
        };
        DoBunnyGrowUp = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Bunny.DoBunnyGrowUp(spr) != 0;
            }
        };
        s_BunnyRun = new State[][]{{new State(4550, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4551, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4552, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4553, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4554, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4554, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove)}, {new State(4555, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4556, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4557, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4558, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4559, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4559, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove)}, {new State(4560, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4561, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4562, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4563, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4564, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4564, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove)}, {new State(4565, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4566, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4567, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4568, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4569, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4569, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove)}, {new State(4570, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4571, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4572, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4573, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove), new State(4574, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4574, 0xA | Gameutils.SF_TIC_ADJUST, DoBunnyMove)}};
        DoBunnyEat = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Bunny.DoBunnyEat(spr) != 0;
            }
        };
        s_BunnyStand = new State[][]{{new State(4550, 12, DoBunnyEat), new State(4554, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4554, 12, DoBunnyEat)}, {new State(4555, 12, DoBunnyEat), new State(4559, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4559, 12, DoBunnyEat)}, {new State(4560, 12, DoBunnyEat), new State(4564, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4564, 12, DoBunnyEat)}, {new State(4565, 12, DoBunnyEat), new State(4569, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4569, 12, DoBunnyEat)}, {new State(4570, 12, DoBunnyEat), new State(4574, Gameutils.SF_QUICK_CALL, DoBunnyGrowUp), new State(4574, 12, DoBunnyEat)}};
        DoBunnyScrew = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Bunny.DoBunnyScrew(spr) != 0;
            }
        };
        s_BunnyScrew = new State[][]{{new State(4550, 16, DoBunnyScrew), new State(4552, 16, DoBunnyScrew)}, {new State(4555, 16, DoBunnyScrew), new State(4557, 16, DoBunnyScrew)}, {new State(4560, 16, DoBunnyScrew), new State(4562, 16, DoBunnyScrew)}, {new State(4565, 16, DoBunnyScrew), new State(4567, 16, DoBunnyScrew)}, {new State(4570, 16, DoBunnyScrew), new State(4572, 16, DoBunnyScrew)}};
        NullBunny = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Bunny.NullBunny(spr) != 0;
            }
        };
        InitBunnySlash = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Weapon.InitBunnySlash(spr) != 0;
            }
        };
        s_BunnySwipe = new State[][]{{new State(4575, 8, NullBunny), new State(4576, 8, NullBunny), new State(4576, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4577, 8, NullBunny), new State(4578, 8, NullBunny), new State(4578, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4578, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4578, 8, DoBunnyMove).setNext()}, {new State(4555, 8, NullBunny), new State(4556, 8, NullBunny), new State(4556, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4557, 8, NullBunny), new State(4558, 8, NullBunny), new State(4558, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4558, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4558, 8, DoBunnyMove).setNext()}, {new State(4560, 8, NullBunny), new State(4561, 8, NullBunny), new State(4561, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4562, 8, NullBunny), new State(4563, 8, NullBunny), new State(4563, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4563, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4563, 8, DoBunnyMove).setNext()}, {new State(4565, 8, NullBunny), new State(4566, 8, NullBunny), new State(4566, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4567, 8, NullBunny), new State(4568, 8, NullBunny), new State(4568, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4568, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4568, 8, DoBunnyMove).setNext()}, {new State(4570, 8, NullBunny), new State(4571, 8, NullBunny), new State(4571, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4572, 8, NullBunny), new State(4573, 8, NullBunny), new State(4573, Gameutils.SF_QUICK_CALL, InitBunnySlash), new State(4573, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4573, 8, DoBunnyMove).setNext()}};
        DoBunnyStandKill = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Bunny.DoBunnyStandKill(spr) != 0;
            }
        };
        s_BunnyHeart = new State[][]{{new State(4575, 14, DoBunnyStandKill).setNext()}, {new State(4580, 14, DoBunnyStandKill).setNext()}, {new State(4580, 14, DoBunnyStandKill).setNext()}, {new State(4580, 14, DoBunnyStandKill).setNext()}, {new State(4580, 14, DoBunnyStandKill).setNext()}};
        DoBunnyPain = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Bunny.DoBunnyPain(spr) != 0;
            }
        };
        s_BunnyPain = new State[][]{{new State(4575, 38, DoBunnyPain).setNext()}, {new State(4575, 38, DoBunnyPain).setNext()}, {new State(4575, 38, DoBunnyPain).setNext()}, {new State(4575, 38, DoBunnyPain).setNext()}, {new State(4575, 38, DoBunnyPain).setNext()}};
        DoBunnyMoveJump = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Bunny.DoBunnyMoveJump(spr) != 0;
            }
        };
        s_BunnyJump = new State[][]{{new State(4551, 25, DoBunnyMoveJump), new State(4552, 25, DoBunnyMoveJump).setNext()}, {new State(4556, 25, DoBunnyMoveJump), new State(4557, 25, DoBunnyMoveJump).setNext()}, {new State(4561, 25, DoBunnyMoveJump), new State(4562, 25, DoBunnyMoveJump).setNext()}, {new State(4566, 25, DoBunnyMoveJump), new State(4567, 25, DoBunnyMoveJump).setNext()}, {new State(4571, 25, DoBunnyMoveJump), new State(4572, 25, DoBunnyMoveJump).setNext()}};
        s_BunnyFall = new State[][]{{new State(4553, 25, DoBunnyMoveJump).setNext()}, {new State(4558, 25, DoBunnyMoveJump).setNext()}, {new State(4563, 25, DoBunnyMoveJump).setNext()}, {new State(4568, 25, DoBunnyMoveJump).setNext()}, {new State(4573, 25, DoBunnyMoveJump).setNext()}};
        DoBunnyBeginJumpAttack = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Bunny.DoBunnyBeginJumpAttack(spr) != 0;
            }
        };
        BunnySpew = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Bunny.BunnySpew(spr) != 0;
            }
        };
        s_BunnyDie = new State[]{new State(4580, 16, NullBunny), new State(4580, Gameutils.SF_QUICK_CALL, BunnySpew), new State(4581, 16, NullBunny), new State(4582, 16, NullBunny), new State(4582, 16, NullBunny), new State(4584, 16, Actor.DoActorDebris).setNext()};
        s_BunnyDead = new State[]{new State(4580, 8, null), new State(4580, Gameutils.SF_QUICK_CALL, BunnySpew), new State(4581, 8, null), new State(4582, 8, null), new State(4584, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(4584, 8, Actor.DoActorDebris).setNext()};
        DoActorDeathMove = new Animator(){

            @Override
            public boolean invoke(int spr) {
                return Actor.DoActorDeathMove(spr) != 0;
            }
        };
        s_BunnyDeathJump = new State[]{new State(4580, 16, DoActorDeathMove).setNext()};
        s_BunnyDeathFall = new State[]{new State(4581, 16, DoActorDeathMove).setNext()};
        BunnyActionSet = new Actor_Action_Set(BunnyStateGroup.sg_BunnyStand, BunnyStateGroup.sg_BunnyRun, BunnyStateGroup.sg_BunnyJump, BunnyStateGroup.sg_BunnyFall, null, null, null, null, null, null, null, BunnyStateGroup.sg_BunnyPain, BunnyStateGroup.sg_BunnyDie, null, BunnyStateGroup.sg_BunnyDead, BunnyStateGroup.sg_BunnyDeathJump, BunnyStateGroup.sg_BunnyDeathFall, null, new short[]{1024}, null, new short[]{1024}, new Sprites.StateGroup[]{BunnyStateGroup.sg_BunnyHeart, BunnyStateGroup.sg_BunnyRun}, null, null);
        BunnyWhiteActionSet = new Actor_Action_Set(BunnyStateGroup.sg_BunnyStand, BunnyStateGroup.sg_BunnyRun, BunnyStateGroup.sg_BunnyJump, BunnyStateGroup.sg_BunnyFall, null, null, null, null, null, null, null, BunnyStateGroup.sg_BunnyPain, BunnyStateGroup.sg_BunnyDie, null, BunnyStateGroup.sg_BunnyDead, BunnyStateGroup.sg_BunnyDeathJump, BunnyStateGroup.sg_BunnyDeathFall, new Sprites.StateGroup[]{BunnyStateGroup.sg_BunnySwipe}, new short[]{1024}, new Sprites.StateGroup[]{BunnyStateGroup.sg_BunnySwipe}, new short[]{1024}, new Sprites.StateGroup[]{BunnyStateGroup.sg_BunnyHeart, BunnyStateGroup.sg_BunnySwipe}, null, null);
    }

    public static void InitBunnyStates() {
        BunnyStateGroup[] bunnyStateGroupArray = BunnyStateGroup.values();
        int n = bunnyStateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            BunnyStateGroup sg = bunnyStateGroupArray[n2];
            int rot = 0;
            while (rot < sg.group.length) {
                State.InitState(sg.group[rot]);
                ++rot;
            }
            ++n2;
        }
    }

    public static int SetupBunny(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 4550, s_BunnyRun[0][0]);
            u.Health = (short)10;
        }
        ++Bunny_Count;
        Sprites.ChangeState(SpriteNum, s_BunnyRun[0][0]);
        u.StateEnd = s_BunnyDie[0];
        u.Rot = BunnyStateGroup.sg_BunnyRun;
        u.ShellNum = 0;
        u.FlagOwner = 0;
        sp.clipdist = 37;
        if (sp.pal == 17) {
            Coolie.EnemyDefaults(SpriteNum, BunnyWhiteActionSet, WhiteBunnyPersonality);
            u.Attrib = WhiteBunnyAttrib;
            sp.xrepeat = (short)96;
            sp.yrepeat = (short)90;
            sp.clipdist = 50;
            if (!MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
                u.Health = (short)60;
            }
        } else if (sp.pal == 24) {
            Coolie.EnemyDefaults(SpriteNum, BunnyActionSet, BunnyPersonality);
            u.Attrib = BunnyAttrib;
            if (!MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
                u.Health = (short)20;
            }
            u.Flag1 = 0;
        } else {
            Coolie.EnemyDefaults(SpriteNum, BunnyActionSet, BunnyPersonality);
            u.Attrib = BunnyAttrib;
            sp.pal = (short)16;
            u.spal = (byte)16;
            u.Flag1 = Gameutils.SEC(5);
        }
        Ai.DoActorSetSpeed(SpriteNum, 3);
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        u.zclip = Gameutils.Z(16);
        u.floor_dist = (short)Gameutils.Z(8);
        u.ceiling_dist = (short)Gameutils.Z(8);
        u.lo_step = (short)Gameutils.Z(16);
        return 0;
    }

    private static final int RANDOM_NEG(int x) {
        return Gameutils.RANDOM_P2(x << 1) - x;
    }

    private static int DoBunnyBeginJumpAttack(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE psp = Engine.sprite[Gameutils.pUser[SpriteNum].tgt_sp];
        short tang = Main.engine.getangle(psp.x - sp.x, psp.y - sp.y);
        sp.ang = Sprites.move_sprite(SpriteNum, Engine.sintable[Gameutils.NORM_ANGLE(tang + 512)] >> 7, Engine.sintable[tang] >> 7, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_ACTOR, 6) != 0 ? (short)(Gameutils.NORM_ANGLE(sp.ang + 1024) + (Bunny.RANDOM_NEG(16384) >> 6)) : Gameutils.NORM_ANGLE(tang + (Bunny.RANDOM_NEG(16384) >> 6));
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ripper.PickJumpMaxSpeed(SpriteNum, -400);
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = (short)17;
        Sprites.DoActorZrange(SpriteNum);
        Actor.DoJump(SpriteNum);
        return 0;
    }

    private static int DoBunnyMoveJump(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
            int ny = sp.xvel * Engine.sintable[sp.ang] >> 14;
            Sprites.move_actor(SpriteNum, nx, ny, 0);
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        Sprites.DoActorZrange(SpriteNum);
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Ai.InitActorDecide(SpriteNum);
        }
        return 0;
    }

    private static int DoPickCloseBunny(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Engine.sprite[SpriteNum];
        int near_dist = 1000;
        int look_height = Gameutils.SPRITEp_TOS(sp);
        boolean ICanSee = false;
        int i = Engine.headspritestat[2];
        while (i != -1) {
            int dist;
            int nexti = Engine.nextspritestat[i];
            SPRITE tsp = Engine.sprite[i];
            USER tu = Gameutils.pUser[i];
            if (sp != tsp && tu.ID == 4550 && (dist = Gameutils.DISTANCE(tsp.x, tsp.y, sp.x, sp.y)) <= near_dist && (ICanSee = Rooms.FAFcansee(sp.x, sp.y, look_height, sp.sectnum, tsp.x, tsp.y, Gameutils.SPRITEp_UPPER(tsp), tsp.sectnum)) && dist < near_dist && tu.ID == 4550) {
                near_dist = dist;
                u.tgt_sp = u.lo_sp = i;
                return i;
            }
            i = nexti;
        }
        return -1;
    }

    private static int DoBunnyQuickJump(int SpriteNum) {
        USER tu;
        SPRITE tsp;
        int hitsprite;
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (u.spal != 24) {
            return 0;
        }
        if (u.lo_sp == -1 && u.spal == 24 && Sprites.MoveSkip4 != 0) {
            Bunny.DoPickCloseBunny(SpriteNum);
        }
        if (u.lo_sp != -1) {
            hitsprite = u.lo_sp;
            tsp = Engine.sprite[u.lo_sp];
            tu = Gameutils.pUser[hitsprite];
            if (tu == null || tu.ID != 4550) {
                return 0;
            }
            if (sp.xrepeat != 64 || sp.yrepeat != 64) {
                return 0;
            }
            if (tsp.xrepeat != 64 || tsp.yrepeat != 64) {
                return 0;
            }
            if (tu.spal == sp.pal && Gameutils.RANDOM_RANGE(1000) > 995 && u.spal == 24 && tu.spal == 24) {
                Sound.PlaySound(424, sp, 1);
                Sound.PlaySound(426, tsp, 1);
                tu.Health = 0;
                JWeapon.InitBloodSpray(hitsprite, true, -1);
                if (Shrap.SpawnShrap(hitsprite, SpriteNum)) {
                    Weapon.SetSuicide(hitsprite);
                } else {
                    Actor.DoActorDie(hitsprite, SpriteNum);
                }
                --Bunny_Count;
                u.lo_sp = -1;
                return 1;
            }
        }
        if (u.lo_sp != -1 && u.spal == 24) {
            hitsprite = u.lo_sp;
            tsp = Engine.sprite[u.lo_sp];
            tu = Gameutils.pUser[hitsprite];
            if (tu == null || tu.ID != 4550) {
                return 0;
            }
            if (sp.xrepeat != 64 || sp.yrepeat != 64) {
                return 0;
            }
            if (tsp.xrepeat != 64 || tsp.yrepeat != 64) {
                return 0;
            }
            if (tu.ShellNum <= 0 && tu.WaitTics <= 0 && u.WaitTics <= 0 && MyTypes.TEST(tsp.extra, Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                PlayerStr pp = null;
                if (Gameutils.RANDOM_RANGE(1000) < 995 && tu.spal != 16) {
                    return 0;
                }
                Ai.DoActorPickClosePlayer(SpriteNum);
                if (Gameutils.pUser[u.tgt_sp].PlayerP != -1) {
                    pp = Game.Player[Gameutils.pUser[u.tgt_sp].PlayerP];
                }
                if (tu.spal != 16) {
                    if (tu.Flag1 > 0) {
                        return 0;
                    }
                    tu.FlagOwner = 1;
                    tu.Flag1 = Gameutils.SEC(10);
                    if (pp != null) {
                        int[] fagsnds = new int[]{456, 457, 458};
                        if (pp == Game.Player[Mmulti.myconnectindex]) {
                            short choose_snd = (short)(Gameutils.STD_RANDOM_RANGE(512) >> 8);
                            if (Rooms.FAFcansee(sp.x, sp.y, Gameutils.SPRITEp_TOS(sp), sp.sectnum, pp.posx, pp.posy, pp.posz, pp.cursectnum) && Gameutils.FACING(sp, Engine.sprite[u.tgt_sp])) {
                                Sound.PlayerSound(fagsnds[choose_snd], 13, pp);
                            }
                        }
                    }
                } else if (pp != null && Gameutils.RANDOM_RANGE(1000) > 200) {
                    int[] straightsnds = new int[]{452, 453, 454, 455};
                    if (pp == Game.Player[Mmulti.myconnectindex]) {
                        short choose_snd = (short)(Gameutils.STD_RANDOM_RANGE(768) >> 8);
                        if (Rooms.FAFcansee(sp.x, sp.y, Gameutils.SPRITEp_TOS(sp), sp.sectnum, pp.posx, pp.posy, pp.posz, pp.cursectnum) && Gameutils.FACING(sp, Engine.sprite[u.tgt_sp])) {
                            Sound.PlayerSound(straightsnds[choose_snd], 13, pp);
                        }
                    }
                }
                sp.x = tsp.x;
                sp.y = tsp.y;
                sp.ang = tsp.ang;
                sp.ang = Gameutils.NORM_ANGLE(sp.ang + 1024);
                Weapon.HelpMissileLateral(SpriteNum, 2000);
                u.Vis = sp.ang = tsp.ang;
                tu.Vis = tsp.ang;
                Sprites.NewStateGroup(SpriteNum, BunnyStateGroup.sg_BunnyScrew);
                Sprites.NewStateGroup(hitsprite, BunnyStateGroup.sg_BunnyScrew);
                if (Main.gs.ParentalLock || Game.Global_PLock) {
                    sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_INVISIBLE);
                    tsp.cstat = (short)(tsp.cstat | Gameutils.CSTAT_SPRITE_INVISIBLE);
                }
                u.WaitTics = tu.WaitTics = (short)Gameutils.SEC(10);
                return 1;
            }
        }
        return 0;
    }

    private static int NullBunny(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoBunnyPain(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        Bunny.NullBunny(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
        return 0;
    }

    public static int DoBunnyRipHeart(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE tsp = Engine.sprite[u.tgt_sp];
        Sprites.NewStateGroup(SpriteNum, BunnyStateGroup.sg_BunnyHeart);
        u.WaitTics = (short)720;
        tsp.ang = Main.engine.getangle(sp.x - tsp.x, sp.y - tsp.y);
        return 0;
    }

    private static int DoBunnyStandKill(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        Bunny.NullBunny(SpriteNum);
        if (Gameutils.RANDOM_RANGE(1000) > 800) {
            Sound.PlaySound(424, sp, 0);
        }
        if ((u.WaitTics = (short)(u.WaitTics - 6)) <= 0) {
            Sprites.NewStateGroup(SpriteNum, BunnyStateGroup.sg_BunnyRun);
        }
        return 0;
    }

    private static void BunnyHatch(int Weapon2) {
        SPRITE wp = Engine.sprite[Weapon2];
        USER wu = Gameutils.pUser[Weapon2];
        short rip_ang = (short)Gameutils.RANDOM_P2(2048);
        short newsp = Rooms.COVERinsertsprite(wp.sectnum, 0);
        SPRITE np = Engine.sprite[newsp];
        np.reset();
        np.sectnum = wp.sectnum;
        np.statnum = 0;
        np.x = wp.x;
        np.y = wp.y;
        np.z = wp.z;
        np.owner = (short)-1;
        np.xrepeat = (short)30;
        np.yrepeat = (short)24;
        np.ang = rip_ang;
        np.pal = 0;
        Bunny.SetupBunny(newsp);
        USER nu = Gameutils.pUser[newsp];
        np.shade = wp.shade;
        nu.Flags |= Gameutils.SPR_ACTIVE;
        if (Gameutils.RANDOM_RANGE(1000) > 500) {
            np.pal = (short)16;
            nu.spal = (byte)16;
        } else {
            np.pal = (short)24;
            nu.spal = (byte)24;
            if (Gameutils.RANDOM_RANGE(1000) > 500) {
                wu.Health = 0;
                --Bunny_Count;
                JWeapon.InitBloodSpray(Weapon2, true, -1);
                if (Shrap.SpawnShrap(Weapon2, newsp)) {
                    Weapon.SetSuicide(Weapon2);
                } else {
                    Actor.DoActorDie(Weapon2, newsp);
                }
            }
        }
        nu.ShellNum = 0;
        Sprites.NewStateGroup(newsp, nu.ActorActionSet.Jump);
        nu.ActorActionFunc = Ai.DoActorMoveJump;
        Ai.DoActorSetSpeed(newsp, 3);
        Ripper.PickJumpMaxSpeed(newsp, -600);
        nu.Flags |= Gameutils.SPR_JUMPING;
        nu.Flags &= ~Gameutils.SPR_FALLING;
        nu.jump_grav = (short)8;
        Sprites.DoActorZrange(newsp);
        Actor.DoActorJump(newsp);
    }

    public static int BunnyHatch2(short Weapon2) {
        SPRITE wp = Engine.sprite[Weapon2];
        short newsp = Rooms.COVERinsertsprite(wp.sectnum, 0);
        SPRITE np = Engine.sprite[newsp];
        np.reset();
        np.sectnum = wp.sectnum;
        np.statnum = 0;
        np.x = wp.x;
        np.y = wp.y;
        np.z = wp.z;
        np.owner = (short)-1;
        np.xrepeat = (short)30;
        np.yrepeat = (short)24;
        np.ang = (short)Gameutils.RANDOM_P2(2048);
        np.pal = 0;
        Bunny.SetupBunny(newsp);
        USER nu = Gameutils.pUser[newsp];
        np.shade = wp.shade;
        nu.Flags |= Gameutils.SPR_ACTIVE;
        if (Gameutils.RANDOM_RANGE(1000) > 500) {
            np.pal = (short)16;
            nu.spal = (byte)16;
            nu.Flag1 = Gameutils.SEC(5);
        } else {
            np.pal = (short)24;
            nu.spal = (byte)24;
            nu.Flag1 = 0;
        }
        nu.ShellNum = 0;
        Sprites.NewStateGroup(newsp, nu.ActorActionSet.Jump);
        nu.ActorActionFunc = Ai.DoActorMoveJump;
        Ai.DoActorSetSpeed(newsp, 3);
        if (Gameutils.TEST_BOOL3(wp)) {
            Ripper.PickJumpMaxSpeed(newsp, -600 - Gameutils.RANDOM_RANGE(600));
            np.yrepeat = (short)64;
            np.xrepeat = (short)64;
            np.xvel = (short)(150 + Gameutils.RANDOM_RANGE(1000));
            nu.Health = 1;
            np.ang = (short)(np.ang - Gameutils.RANDOM_RANGE(128));
            np.ang = (short)(np.ang + Gameutils.RANDOM_RANGE(128));
        } else {
            Ripper.PickJumpMaxSpeed(newsp, -600);
        }
        nu.Flags |= Gameutils.SPR_JUMPING;
        nu.Flags &= ~Gameutils.SPR_FALLING;
        nu.jump_grav = (short)8;
        nu.FlagOwner = 0;
        nu.active_range = 75000;
        Sprites.DoActorZrange(newsp);
        Actor.DoActorJump(newsp);
        return newsp;
    }

    private static int DoBunnyMove(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
            sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
        }
        if (u.Health <= 0) {
            Weapon.SetSuicide(SpriteNum);
        }
        if (u.scale_speed != 0) {
            Actor.DoScaleSprite(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Bunny.DoBunnyQuickJump(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        if (Gameutils.RANDOM_RANGE(1000) > 985 && sp.pal != 17 && u.track < 0) {
            switch (Engine.sector[sp.sectnum].floorpicnum) {
                case 153: 
                case 154: 
                case 193: 
                case 219: 
                case 2636: 
                case 2689: 
                case 3561: 
                case 3562: 
                case 3563: 
                case 3564: {
                    Sprites.NewStateGroup(SpriteNum, BunnyStateGroup.sg_BunnyStand);
                    break;
                }
                default: {
                    sp.ang = Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(131072) >> 6);
                    u.jump_speed = (short)-350;
                    Actor.DoActorBeginJump(SpriteNum);
                    u.ActorActionFunc = Ai.DoActorMoveJump;
                }
            }
        }
        return 0;
    }

    private static int BunnySpew(int SpriteNum) {
        JWeapon.InitBloodSpray(SpriteNum, true, -1);
        return 0;
    }

    private static int DoBunnyEat(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Bunny.DoBunnyQuickJump(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        switch (Engine.sector[sp.sectnum].floorpicnum) {
            case 153: 
            case 154: 
            case 193: 
            case 219: 
            case 2636: 
            case 2689: 
            case 3561: 
            case 3562: 
            case 3563: 
            case 3564: {
                if (Gameutils.RANDOM_RANGE(1000) <= 970) break;
                Sprites.NewStateGroup(SpriteNum, BunnyStateGroup.sg_BunnyRun);
                break;
            }
            default: {
                Sprites.NewStateGroup(SpriteNum, BunnyStateGroup.sg_BunnyRun);
            }
        }
        return 0;
    }

    private static int DoBunnyScrew(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        if (Gameutils.RANDOM_RANGE(1000) > 990 && !Main.gs.ParentalLock && !Game.Global_PLock) {
            Sound.PlaySound(424, sp, 1);
        }
        u.WaitTics = (short)(u.WaitTics - 6);
        if ((u.FlagOwner != 0 || u.spal == 16) && u.WaitTics > 0) {
            Sprites.NewStateGroup(SpriteNum, BunnyStateGroup.sg_BunnyScrew);
        }
        if (u.spal == 16 && u.WaitTics <= 0) {
            u.Flag1 = Gameutils.SEC(5);
            u.ShellNum = 1;
        }
        if (u.WaitTics <= 0) {
            sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
            u.FlagOwner = 0;
            Sprites.NewStateGroup(SpriteNum, BunnyStateGroup.sg_BunnyRun);
        }
        return 0;
    }

    private static int DoBunnyGrowUp(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (sp.pal == 17) {
            return 0;
        }
        u.Counter = (short)(u.Counter - 6);
        if (u.Counter <= 0) {
            sp.xrepeat = (short)(sp.xrepeat + 1);
            if (sp.xrepeat > 64) {
                sp.xrepeat = (short)64;
            }
            if ((sp.yrepeat = (short)(sp.yrepeat + 1)) > 64) {
                sp.yrepeat = (short)64;
            }
            u.Counter = (short)60;
        }
        if (sp.pal != 16 && u.Flag1 > 0) {
            u.Flag1 -= 6;
        }
        if (sp.pal == 16 && u.ShellNum > 0 && (u.Flag1 -= 6) <= 0) {
            if (Bunny_Count < 20) {
                Sound.PlaySound(426, sp, 1);
                Bunny.BunnyHatch(SpriteNum);
            }
            u.ShellNum = 0;
        }
        return 0;
    }

    public static void BunnySaveable() {
        Saveable.SaveData(InitBunnySlash);
        Saveable.SaveData(DoActorDeathMove);
        Saveable.SaveData(DoBunnyBeginJumpAttack);
        Saveable.SaveData(DoBunnyMoveJump);
        Saveable.SaveData(NullBunny);
        Saveable.SaveData(DoBunnyPain);
        Saveable.SaveData(DoBunnyStandKill);
        Saveable.SaveData(DoBunnyMove);
        Saveable.SaveData(BunnySpew);
        Saveable.SaveData(DoBunnyEat);
        Saveable.SaveData(DoBunnyScrew);
        Saveable.SaveData(DoBunnyGrowUp);
        Saveable.SaveData(WhiteBunnyPersonality);
        Saveable.SaveData(BunnyPersonality);
        Saveable.SaveData(WhiteBunnyAttrib);
        Saveable.SaveData(BunnyAttrib);
        Saveable.SaveData(s_BunnyRun);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyRun);
        Saveable.SaveData(s_BunnyStand);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyStand);
        Saveable.SaveData(s_BunnyScrew);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyScrew);
        Saveable.SaveData(s_BunnySwipe);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnySwipe);
        Saveable.SaveData(s_BunnyHeart);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyHeart);
        Saveable.SaveData(s_BunnyPain);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyPain);
        Saveable.SaveData(s_BunnyJump);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyJump);
        Saveable.SaveData(s_BunnyFall);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyFall);
        Saveable.SaveData(s_BunnyDie);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyDie);
        Saveable.SaveData(s_BunnyDead);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyDead);
        Saveable.SaveData(s_BunnyDeathJump);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyDeathJump);
        Saveable.SaveData(s_BunnyDeathFall);
        Saveable.SaveGroup(BunnyStateGroup.sg_BunnyDeathFall);
        Saveable.SaveData(BunnyActionSet);
        Saveable.SaveData(BunnyWhiteActionSet);
    }

    static /* synthetic */ State[][] access$10() {
        return s_BunnyStand;
    }

    static /* synthetic */ State[][] access$11() {
        return s_BunnyRun;
    }

    static /* synthetic */ State[][] access$12() {
        return s_BunnyJump;
    }

    static /* synthetic */ State[][] access$13() {
        return s_BunnyFall;
    }

    static /* synthetic */ State[][] access$14() {
        return s_BunnyPain;
    }

    static /* synthetic */ State[] access$15() {
        return s_BunnyDie;
    }

    static /* synthetic */ State[] access$16() {
        return s_BunnyDead;
    }

    static /* synthetic */ State[] access$17() {
        return s_BunnyDeathJump;
    }

    static /* synthetic */ State[] access$18() {
        return s_BunnyDeathFall;
    }

    static /* synthetic */ State[][] access$19() {
        return s_BunnyHeart;
    }

    static /* synthetic */ State[][] access$20() {
        return s_BunnySwipe;
    }

    static /* synthetic */ State[][] access$21() {
        return s_BunnyScrew;
    }

    public static enum BunnyStateGroup implements Sprites.StateGroup
    {
        sg_BunnyStand(Bunny.access$10()[0], Bunny.access$10()[1], Bunny.access$10()[2], Bunny.access$10()[3], Bunny.access$10()[4]),
        sg_BunnyRun(Bunny.access$11()[0], Bunny.access$11()[1], Bunny.access$11()[2], Bunny.access$11()[3], Bunny.access$11()[4]),
        sg_BunnyJump(Bunny.access$12()[0], Bunny.access$12()[1], Bunny.access$12()[2], Bunny.access$12()[3], Bunny.access$12()[4]),
        sg_BunnyFall(Bunny.access$13()[0], Bunny.access$13()[1], Bunny.access$13()[2], Bunny.access$13()[3], Bunny.access$13()[4]),
        sg_BunnyPain(Bunny.access$14()[0], Bunny.access$14()[1], Bunny.access$14()[2], Bunny.access$14()[3], Bunny.access$14()[4]),
        sg_BunnyDie(new State[][]{Bunny.access$15()}),
        sg_BunnyDead(new State[][]{Bunny.access$16()}),
        sg_BunnyDeathJump(new State[][]{Bunny.access$17()}),
        sg_BunnyDeathFall(new State[][]{Bunny.access$18()}),
        sg_BunnyHeart(Bunny.access$19()[0], Bunny.access$19()[1], Bunny.access$19()[2], Bunny.access$19()[3], Bunny.access$19()[4]),
        sg_BunnySwipe(Bunny.access$20()[0], Bunny.access$20()[1], Bunny.access$20()[2], Bunny.access$20()[3], Bunny.access$20()[4]),
        sg_BunnyScrew(Bunny.access$21()[0], Bunny.access$21()[1], Bunny.access$21()[2], Bunny.access$21()[3], Bunny.access$21()[4]);

        private final State[][] group;
        private int index = -1;

        private BunnyStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

