/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Eel {
    private static final Decision[] EelBattle = new Decision[]{new Decision(649, Ai.InitActorMoveCloser), new Decision(650, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] EelOffense = new Decision[]{new Decision(649, Ai.InitActorMoveCloser), new Decision(750, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] EelBroadcast = new Decision[]{new Decision(3, Ai.InitActorAlertNoise), new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] EelSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] EelEvasive = new Decision[]{new Decision(790, Ai.InitActorRunAway), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] EelLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] EelCloseRange = new Decision[]{new Decision(950, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Decision[] EelTouchTarget = new Decision[]{new Decision(1024, Ai.InitActorAttack)};
    private static final Personality EelPersonality = new Personality(EelBattle, EelOffense, EelBroadcast, EelSurprised, EelEvasive, EelLostTarget, EelCloseRange, EelTouchTarget);
    private static final ATTRIBUTE EelAttrib;
    public static final int EEL_RUN_RATE = 20;
    private static final Animator DoEelMove;
    private static final State[][] s_EelRun;
    private static final State[][] s_EelStand;
    public static final int EEL_FIRE_RATE = 12;
    private static final Animator NullEel;
    private static final Animator InitEelFire;
    private static final State[][] s_EelAttack;
    public static final int EEL_DIE_RATE = 20;
    private static final Animator DoEelDeath;
    private static final State[] s_EelDie;
    private static final State[] s_EelDead;
    private static final Actor_Action_Set EelActionSet;
    private static final int EEL_BOB_AMT;

    static {
        short[] sArray = new short[4];
        sArray[0] = 3;
        sArray[2] = -2;
        sArray[3] = -3;
        EelAttrib = new ATTRIBUTE(new short[]{100, 110, 120, 130}, sArray, 3, new int[10]);
        DoEelMove = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Eel.DoEelMove(SpriteNum) != 0;
            }
        };
        s_EelRun = new State[][]{{new State(3780, 20, DoEelMove), new State(3781, 20, DoEelMove), new State(3782, 20, DoEelMove), new State(3781, 20, DoEelMove)}, {new State(3783, 20, DoEelMove), new State(3784, 20, DoEelMove), new State(3785, 20, DoEelMove), new State(3784, 20, DoEelMove)}, {new State(3786, 20, DoEelMove), new State(3787, 20, DoEelMove), new State(3788, 20, DoEelMove), new State(3787, 20, DoEelMove)}, {new State(3789, 20, DoEelMove), new State(3790, 20, DoEelMove), new State(3791, 20, DoEelMove), new State(3790, 20, DoEelMove)}, {new State(3792, 20, DoEelMove), new State(3793, 20, DoEelMove), new State(3794, 20, DoEelMove), new State(3793, 20, DoEelMove)}};
        s_EelStand = new State[][]{{new State(3780, 20, DoEelMove).setNext()}, {new State(3783, 20, DoEelMove).setNext()}, {new State(3786, 20, DoEelMove).setNext()}, {new State(3789, 20, DoEelMove).setNext()}, {new State(3792, 20, DoEelMove).setNext()}};
        NullEel = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Eel.NullEel(SpriteNum) != 0;
            }
        };
        InitEelFire = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Weapon.InitEelFire(SpriteNum) != 0;
            }
        };
        s_EelAttack = new State[][]{{new State(3760, 24, NullEel), new State(3761, 24, NullEel), new State(3762, 24, NullEel), new State(3762, Gameutils.SF_QUICK_CALL, InitEelFire), new State(3762, 12, NullEel), new State(3763, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(3783, 12, DoEelMove).setNext()}, {new State(3763, 24, NullEel), new State(3764, 24, NullEel), new State(3765, 24, NullEel), new State(3765, Gameutils.SF_QUICK_CALL, InitEelFire), new State(3765, 12, NullEel), new State(3766, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(3783, 12, DoEelMove).setNext()}, {new State(3766, 24, NullEel), new State(3767, 24, NullEel), new State(3768, 24, NullEel), new State(3768, Gameutils.SF_QUICK_CALL, InitEelFire), new State(3768, 12, NullEel), new State(3769, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(3783, 12, DoEelMove).setNext()}, {new State(3789, 24, NullEel), new State(3790, 24, NullEel), new State(3791, 24, NullEel), new State(3791, Gameutils.SF_QUICK_CALL, InitEelFire), new State(3791, 12, NullEel), new State(3792, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(3783, 12, DoEelMove).setNext()}, {new State(3792, 24, NullEel), new State(3793, 24, NullEel), new State(3794, 24, NullEel), new State(3794, Gameutils.SF_QUICK_CALL, InitEelFire), new State(3794, 12, NullEel), new State(3795, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(3783, 12, DoEelMove).setNext()}};
        DoEelDeath = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Eel.DoEelDeath(SpriteNum) != 0;
            }
        };
        s_EelDie = new State[]{new State(3795, 20, DoEelDeath), new State(3795, 20, DoEelDeath), new State(3795, 20, DoEelDeath), new State(3795, 20, DoEelDeath), new State(3795, 20, DoEelDeath), new State(3795, 20, DoEelDeath).setNext()};
        s_EelDead = new State[]{new State(3795, 20, Actor.DoActorDebris).setNext()};
        EelActionSet = new Actor_Action_Set(EelStateGroup.sg_EelStand, EelStateGroup.sg_EelRun, null, null, null, EelStateGroup.sg_EelRun, null, null, EelStateGroup.sg_EelStand, null, null, EelStateGroup.sg_EelStand, EelStateGroup.sg_EelDie, null, EelStateGroup.sg_EelDead, null, null, new Sprites.StateGroup[]{EelStateGroup.sg_EelAttack}, new short[]{1024}, new Sprites.StateGroup[]{EelStateGroup.sg_EelAttack}, new short[]{1024}, null, null, null);
        EEL_BOB_AMT = Gameutils.Z(4);
    }

    public static void InitEelStates() {
        EelStateGroup[] eelStateGroupArray = EelStateGroup.values();
        int n = eelStateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            EelStateGroup sg = eelStateGroupArray[n2];
            int rot = 0;
            while (rot < sg.group.length) {
                State.InitState(sg.group[rot]);
                ++rot;
            }
            ++n2;
        }
    }

    private static void EelCommon(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        sp.clipdist = 25;
        u.floor_dist = (short)Gameutils.Z(16);
        u.floor_dist = (short)Gameutils.Z(16);
        u.ceiling_dist = (short)Gameutils.Z(20);
        u.sz = sp.z;
        sp.xrepeat = (short)35;
        sp.yrepeat = (short)27;
        u.Radius = 400;
    }

    public static int SetupEel(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 3780, s_EelRun[0][0]);
            u.Health = (short)40;
        }
        Sprites.ChangeState(SpriteNum, s_EelRun[0][0]);
        u.Attrib = EelAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_EelDie[0];
        u.Rot = EelStateGroup.sg_EelRun;
        Coolie.EnemyDefaults(SpriteNum, EelActionSet, EelPersonality);
        u.Flags |= Gameutils.SPR_NO_SCAREDZ | Gameutils.SPR_XFLIP_TOGGLE;
        Eel.EelCommon(SpriteNum);
        u.Flags &= ~Gameutils.SPR_SHADOW;
        u.zclip = Gameutils.Z(8);
        return 0;
    }

    private static int NullEel(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Eel.DoEelMatchPlayerZ(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoEelMatchPlayerZ(int SpriteNum) {
        int dist;
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE tsp = Engine.sprite[Gameutils.pUser[SpriteNum].tgt_sp];
        if (Gameutils.FAF_ConnectArea(sp.sectnum)) {
            if (u.hi_sectp != -1) {
                u.hiz = Engine.sector[sp.sectnum].ceilingz + Gameutils.Z(16);
                u.hi_sectp = sp.sectnum;
            } else if (u.hiz < Engine.sector[sp.sectnum].ceilingz + Gameutils.Z(16)) {
                u.hiz = Engine.sector[sp.sectnum].ceilingz + Gameutils.Z(16);
            }
        }
        int zdiff = Gameutils.SPRITEp_BOS(tsp) - Gameutils.Z(8) - u.sz;
        int zdist = Gameutils.Z(20 + Gameutils.RANDOM_RANGE(64));
        if (Pragmas.klabs(zdiff) > zdist) {
            u.sz = zdiff > 0 ? (u.sz += 960) : (u.sz -= 960);
        }
        int loz = u.loz;
        int hiz = u.hiz;
        if (u.lo_sectp != -1 && Sector.SectUser[u.lo_sectp] != null && Sector.SectUser[u.lo_sectp].depth != 0) {
            loz -= Gameutils.Z(Sector.SectUser[u.lo_sectp].depth) - Gameutils.Z(8);
        }
        int bound = u.lo_sp != -1 && u.tgt_sp == u.hi_sp ? ((dist = Gameutils.DISTANCE(sp.x, sp.y, Engine.sprite[u.lo_sp].x, Engine.sprite[u.lo_sp].y)) <= 300 ? u.sz : loz - u.floor_dist) : loz - u.floor_dist - EEL_BOB_AMT;
        if (u.sz > bound) {
            u.sz = bound;
        }
        bound = u.hi_sp != -1 && u.tgt_sp == u.hi_sp ? ((dist = Gameutils.DISTANCE(sp.x, sp.y, Engine.sprite[u.hi_sp].x, Engine.sprite[u.hi_sp].y)) <= 300 ? u.sz : hiz + u.ceiling_dist) : hiz + u.ceiling_dist + EEL_BOB_AMT;
        if (u.sz < bound) {
            u.sz = bound;
        }
        u.sz = Math.min(u.sz, loz - u.floor_dist);
        u.sz = Math.max(u.sz, hiz + u.ceiling_dist);
        u.Counter = (short)(u.Counter + 48 + 12 & 0x7FF);
        sp.z = u.sz + (EEL_BOB_AMT * Engine.sintable[u.Counter] >> 14);
        bound = u.hiz + u.ceiling_dist + EEL_BOB_AMT;
        if (sp.z < bound) {
            sp.z = u.sz = bound + EEL_BOB_AMT;
        }
        return 0;
    }

    private static int DoEelDeath(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
            Actor.DoFall(SpriteNum);
        } else {
            Weapon.DoFindGroundPoint(SpriteNum);
            u.floor_dist = 0;
            Actor.DoBeginFall(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
        int ny = sp.xvel * Engine.sintable[sp.ang] >> 14;
        u.ret = Sprites.move_sprite(SpriteNum, nx, ny, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.DoFindGroundPoint(SpriteNum);
        if (sp.z >= u.loz) {
            u.Flags &= ~(Gameutils.SPR_FALLING | Gameutils.SPR_SLIDING);
            if (Gameutils.RANDOM_RANGE(1000) > 500) {
                sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_XFLIP);
            }
            if (Gameutils.RANDOM_RANGE(1000) > 500) {
                sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YFLIP);
            }
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Dead);
            return 0;
        }
        return 0;
    }

    private static int DoEelMove(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (Sprites.SpriteOverlap(SpriteNum, u.tgt_sp)) {
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.CloseAttack[0]);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        Eel.DoEelMatchPlayerZ(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    public static void EelSaveable() {
        Saveable.SaveData(NullEel);
        Saveable.SaveData(InitEelFire);
        Saveable.SaveData(DoEelDeath);
        Saveable.SaveData(DoEelMove);
        Saveable.SaveData(EelPersonality);
        Saveable.SaveData(EelAttrib);
        Saveable.SaveData(s_EelRun);
        Saveable.SaveGroup(EelStateGroup.sg_EelRun);
        Saveable.SaveData(s_EelStand);
        Saveable.SaveGroup(EelStateGroup.sg_EelStand);
        Saveable.SaveData(s_EelAttack);
        Saveable.SaveGroup(EelStateGroup.sg_EelAttack);
        Saveable.SaveData(s_EelDie);
        Saveable.SaveGroup(EelStateGroup.sg_EelDie);
        Saveable.SaveData(s_EelDead);
        Saveable.SaveGroup(EelStateGroup.sg_EelDead);
        Saveable.SaveData(EelActionSet);
    }

    static /* synthetic */ State[][] access$3() {
        return s_EelRun;
    }

    static /* synthetic */ State[][] access$4() {
        return s_EelStand;
    }

    static /* synthetic */ State[] access$5() {
        return s_EelDie;
    }

    static /* synthetic */ State[][] access$6() {
        return s_EelAttack;
    }

    static /* synthetic */ State[] access$7() {
        return s_EelDead;
    }

    public static enum EelStateGroup implements Sprites.StateGroup
    {
        sg_EelRun(Eel.access$3()[0], Eel.access$3()[1], Eel.access$3()[2], Eel.access$3()[3], Eel.access$3()[4]),
        sg_EelStand(Eel.access$4()[0], Eel.access$4()[1], Eel.access$4()[2], Eel.access$4()[3], Eel.access$4()[4]),
        sg_EelDie(new State[][]{Eel.access$5()}),
        sg_EelAttack(Eel.access$6()[0], Eel.access$6()[1], Eel.access$6()[2], Eel.access$6()[3], Eel.access$6()[4]),
        sg_EelDead(new State[][]{Eel.access$7()});

        private final State[][] group;
        private int index = -1;

        private EelStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

