/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.BufferResource;
import ru.m210projects.Build.FileHandle.DataResource;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JPlayer;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.Network.MenuNetwork;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.Input;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Predict;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.USER;

public class WangNetwork
extends BuildNet {
    public PlayerStr ppp = new PlayerStr();
    private USER PredictUser = new USER();
    private SPRITE PredictSprite = new SPRITE(){

        @Override
        public String toString() {
            String out = "Prediction sprite \r\n";
            out = String.valueOf(out) + super.toString();
            return out;
        }
    };
    public Predict[] predictFifo = new Predict[256];
    public static boolean PredictionOn = true;
    public static boolean Prediction = false;
    private static boolean SavePrediction;
    public static int PlayerSyncTrail;
    public static int PlayerSyncIndex;
    public static PlayerStr PlayerSync;
    public static SPRITE PlayerSpriteSync;
    public static final short[] TimeLimitTable;
    public static byte[] netbuf;
    public static final short nNetVersion = 500;
    public static int CommPlayers;
    private Main app;
    public int MoveThingsCount;
    public boolean FakeMultiplayer;
    public int FakeMultiNumPlayers;
    public boolean BotMode = false;
    public int BotSkill = -1;
    public int KillLimit;
    public int TimeLimit;
    public int TimeLimitClock;
    public MultiGameTypes MultiGameType = MultiGameTypes.MULTI_GAME_NONE;
    public boolean TeamPlay;
    public boolean HurtTeammate;
    public boolean SpawnMarkers;
    public boolean NoRespawn;
    public boolean Nuke = true;
    private static final int TypeOffset = 8;
    public byte[] gContentFound = new byte[16];

    static {
        PlayerSyncTrail = -1;
        PlayerSyncIndex = -1;
        PlayerSync = null;
        PlayerSpriteSync = null;
        short[] sArray = new short[9];
        sArray[1] = 3;
        sArray[2] = 5;
        sArray[3] = 10;
        sArray[4] = 15;
        sArray[5] = 20;
        sArray[6] = 30;
        sArray[7] = 45;
        sArray[8] = 60;
        TimeLimitTable = sArray;
        netbuf = new byte[256];
        CommPlayers = 0;
    }

    public WangNetwork(Main game) {
        super(game);
        this.app = game;
        int i = 0;
        while (i < 256) {
            this.predictFifo[i] = new Predict();
            ++i;
        }
    }

    public void PauseMultiPlay() {
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            PlayerStr pp = Game.Player[pnum];
            if (Gameutils.TEST_SYNC_KEY(pp, 9)) {
                if (Gameutils.FLAG_KEY_PRESSED(pp, 9)) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 9);
                    boolean bl = this.game.gPaused = !this.game.gPaused;
                    if (this.game.gPaused) {
                        SavePrediction = PredictionOn;
                        PredictionOn = false;
                    } else {
                        PredictionOn = SavePrediction;
                    }
                }
            } else {
                Gameutils.FLAG_KEY_RESET(pp, 9);
            }
            pnum = Mmulti.connectpoint2[pnum];
        }
    }

    public void InitNetPlayerProfile() {
        if (Main.gs.pName == null) {
            Main.gs.pName = "PLAYER " + (Mmulti.myconnectindex + 1);
        }
        Game.Player[Mmulti.myconnectindex].PlayerName = Main.gs.pName;
        Game.Player[Mmulti.myconnectindex].TeamColor = Main.gs.NetColor;
        Game.Player[Mmulti.myconnectindex].Flags = Main.gs.AutoAim ? (Game.Player[Mmulti.myconnectindex].Flags |= Gameutils.PF_AUTO_AIM) : (Game.Player[Mmulti.myconnectindex].Flags &= ~Gameutils.PF_AUTO_AIM);
        int l = PacketType.Profile.Send(netbuf);
        this.WaitForSend();
        this.sendtoall(netbuf, l);
        this.GetPackets();
    }

    public void InitNetPlayerOptions() {
        PlayerStr pp = Game.Player[Mmulti.myconnectindex];
        pp.TeamColor = Main.gs.NetColor;
        pp.getSprite().pal = (short)(16 + pp.TeamColor);
        Gameutils.pUser[pp.PlayerSprite].spal = (byte)pp.getSprite().pal;
        if (this.game.nNetMode != BuildGame.NetMode.Single) {
            this.InitNetPlayerProfile();
        }
    }

    public void SendMessage(int sendmessagecommand, String message) {
        PacketType.Message.setData(sendmessagecommand, message);
        int l = PacketType.Message.Send(netbuf);
        if (Mmulti.myconnectindex != Mmulti.connecthead) {
            Mmulti.sendpacket(Mmulti.connecthead, netbuf, l);
        } else {
            this.sendtoall(netbuf, l);
        }
    }

    public boolean MyCommPlayerQuit() {
        short i = Mmulti.connecthead;
        while (i != -1) {
            PlayerStr pp = Game.Player[i];
            if (Gameutils.TEST_SYNC_KEY(pp, 28) && i == Mmulti.myconnectindex) {
                Game.QuitFlag = true;
                return true;
            }
            i = Mmulti.connectpoint2[i];
        }
        return false;
    }

    @Override
    public BuildNet.NetInput newInstance() {
        return new Input();
    }

    @Override
    public int GetPackets(byte[] p, int ptr, int len, int nPlayer) {
        PacketType[] types = PacketType.values();
        byte nPacket = p[0];
        if (nPacket == 7) {
            return this.GetDisconnectPacket(p, 1, len, nPlayer, new BuildNet.DisconnectCallback(){

                @Override
                public void invoke(int nDelete) {
                    if (Game.rec != null) {
                        Game.rec.close();
                    }
                    if (WangNetwork.this.game.isCurrentScreen(Main.gGameScreen)) {
                        PlayerStr qpp = Game.Player[nDelete];
                        SPRITE psp = qpp.getSprite();
                        psp.cstat = (short)(psp.cstat | Gameutils.CSTAT_SPRITE_INVISIBLE);
                        psp.cstat = (short)(psp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN | Gameutils.CSTAT_SPRITE_BLOCK_MISSILE));
                        JWeapon.InitBloodSpray(qpp.PlayerSprite, true, -2);
                        JWeapon.InitBloodSpray(qpp.PlayerSprite, false, -2);
                        psp.ang = Gameutils.NORM_ANGLE(psp.ang + 1024);
                        JWeapon.InitBloodSpray(qpp.PlayerSprite, false, -1);
                        JWeapon.InitBloodSpray(qpp.PlayerSprite, true, -1);
                        qpp.input.bits |= 0x10000000;
                        JPlayer.adduserquote(String.valueOf(qpp.getName()) + " has quit the game.");
                    }
                    if (Game.screenpeek == nDelete) {
                        Game.screenpeek = Mmulti.connectpoint2[nDelete];
                        if (Game.screenpeek < 0) {
                            Game.screenpeek = Mmulti.connecthead;
                        }
                        Palette.ResetPalette(Game.Player[Game.screenpeek], 256);
                        Palette.DoPlayerDivePalette(Game.Player[Game.screenpeek]);
                        Palette.DoPlayerNightVisionPalette(Game.Player[Game.screenpeek]);
                    }
                    --CommPlayers;
                }
            });
        }
        if (nPacket >= 8) {
            return types[nPacket - 8].Get(nPlayer, p, len);
        }
        System.err.println("Unsupported packet " + nPacket);
        return 0;
    }

    public boolean WaitForContentCheck(String filepath, long crc32, int timeout) {
        int i;
        Arrays.fill(this.gContentFound, (byte)-1);
        if (Mmulti.numplayers < 2) {
            return true;
        }
        this.WaitForSend();
        PacketType.ContentRequest.setData(filepath, crc32);
        int l = PacketType.ContentRequest.Send(this.packbuf);
        this.sendtoall(this.packbuf, l);
        this.gContentFound[Mmulti.myconnectindex] = 1;
        long starttime = System.currentTimeMillis();
        block0: do {
            long time = System.currentTimeMillis() - starttime;
            if (timeout != 0 && time > (long)timeout) {
                Console.Println("Connection timed out!", Console.OSDTEXT_YELLOW);
                return false;
            }
            this.GetPackets();
            i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.gContentFound[i] == -1) continue block0;
                if (Mmulti.myconnectindex != Mmulti.connecthead) {
                    i = -1;
                    continue block0;
                }
                i = Mmulti.connectpoint2[i];
            }
        } while (i >= 0);
        i = Mmulti.connecthead;
        while (i >= 0) {
            if (this.gContentFound[i] != 1) {
                return false;
            }
            i = Mmulti.connectpoint2[i];
        }
        return true;
    }

    @Override
    public void ComputerInput(int i) {
        if (this.BotMode) {
            JPlayer.computergetinput(i, (Input)this.gFifoInput[this.gNetFifoHead[i] & 0xFF][i]);
        }
    }

    @Override
    public void UpdatePrediction(BuildNet.NetInput input) {
        if (!PredictionOn) {
            ++this.gPredictTail;
            return;
        }
        this.ppp.input.Copy(input);
        this.ppp.input.bits &= ~(MyTypes.BIT(17) | MyTypes.BIT(18) | MyTypes.BIT(26) | MyTypes.BIT(27) | MyTypes.BIT(29) | MyTypes.BIT(30) | MyTypes.BIT(7) | MyTypes.BIT(8) | Gameutils.SK_WEAPON_MASK | Gameutils.SK_INV_HOTKEY_MASK);
        this.ppp.KeyPressFlags |= MyTypes.BIT(17) | MyTypes.BIT(18) | MyTypes.BIT(26) | MyTypes.BIT(27) | MyTypes.BIT(29) | MyTypes.BIT(30) | MyTypes.BIT(7) | MyTypes.BIT(8) | Gameutils.SK_WEAPON_MASK | Gameutils.SK_INV_HOTKEY_MASK;
        int bakrandomseed = Main.engine.getrand();
        SPRITE spr = Engine.sprite[Game.Player[Mmulti.myconnectindex].PlayerSprite];
        USER u = Gameutils.pUser[this.ppp.PlayerSprite];
        Gameutils.pUser[this.ppp.PlayerSprite] = this.PredictUser;
        Engine.sprite[this.ppp.PlayerSprite] = this.PredictSprite;
        Engine.sprite[this.ppp.PlayerSprite].cstat = 0;
        this.ppp.oang = this.ppp.getAnglef();
        this.ppp.oposx = this.ppp.posx;
        this.ppp.oposy = this.ppp.posy;
        this.ppp.oposz = this.ppp.posz;
        this.ppp.ohoriz = this.ppp.getHorizf();
        this.ppp.obob_z = this.ppp.bob_z;
        Prediction = true;
        Player.DoPlayerSectorUpdatePreMove(this.ppp);
        this.ppp.DoPlayerAction.invoke(this.ppp);
        Player.DoPlayerSectorUpdatePostMove(this.ppp);
        Prediction = false;
        Gameutils.pUser[this.ppp.PlayerSprite] = u;
        Engine.sprite[Game.Player[Mmulti.myconnectindex].PlayerSprite] = spr;
        Main.engine.srand(bakrandomseed);
        this.predictFifo[this.gPredictTail & 0xFF].set(this.ppp);
        ++this.gPredictTail;
    }

    public void InitPrediction(PlayerStr pp) {
        if (!PredictionOn) {
            return;
        }
        this.ppp.copy(pp);
        this.PredictUser.copy(Gameutils.pUser[pp.PlayerSprite]);
        this.PredictSprite.set(Engine.sprite[pp.PlayerSprite]);
    }

    @Override
    public void CorrectPrediction() {
        if (Mmulti.numplayers < 2 || !PredictionOn) {
            return;
        }
        Predict predict = this.predictFifo[this.gNetFifoTail - 1 & 0xFF];
        PlayerStr p = Game.Player[Mmulti.myconnectindex];
        if (predict.ang == p.getAnglef() && predict.horiz == p.getHorizf() && predict.x == p.posx && predict.y == p.posy && predict.z == p.posz) {
            return;
        }
        this.InitPrediction(p);
        this.gPredictTail = this.gNetFifoTail;
        while (this.gPredictTail < this.gNetFifoHead[Mmulti.myconnectindex]) {
            this.UpdatePrediction(this.gFifoInput[this.gPredictTail & 0xFF][Mmulti.myconnectindex]);
        }
    }

    private long PlayerSync(PlayerStr pp) {
        long crc = pp.posx;
        crc += (long)pp.posy;
        crc += (long)pp.posz;
        crc += (long)pp.getAnglei();
        crc += (long)pp.getHorizi();
        crc += (long)Gameutils.pUser[pp.PlayerSprite].Health;
        return crc += (long)pp.bcnt;
    }

    private long MissileSync() {
        long crc = 0L;
        short i = Engine.headspritestat[4];
        while (i != -1) {
            short nexti;
            SPRITE spr = Engine.sprite[i];
            crc += (long)spr.x;
            crc += (long)spr.y;
            crc += (long)spr.z;
            crc += (long)spr.ang;
            i = nexti = Engine.nextspritestat[i];
        }
        return crc;
    }

    @Override
    public void CalcChecksum() {
        if ((Mmulti.numplayers >= 2 || Main.gNet.FakeMultiplayer) && (this.gNetFifoTail & 7) == 7) {
            Arrays.fill(this.gChecksum, 0);
            this.gChecksum[0] = Main.engine.getrand();
            int i = Mmulti.connecthead;
            while (i >= 0) {
                PlayerStr pp = Game.Player[i];
                this.gChecksum[1] = (int)((long)this.gChecksum[1] ^ this.PlayerSync(pp));
                this.gChecksum[2] = (int)((long)this.gChecksum[2] ^ this.Checksum(Engine.sprite[pp.PlayerSprite].getBytes(), 44));
                i = Mmulti.connectpoint2[i];
            }
            this.gChecksum[3] = (int)((long)this.gChecksum[3] ^ this.MissileSync());
            i = 0;
            while (i < this.gChecksum.length) {
                LittleEndian.putInt(this.gCheckFifo[Mmulti.myconnectindex], 16 * (this.gCheckHead[Mmulti.myconnectindex] & 0xFF) + 4 * i, this.gChecksum[i]);
                ++i;
            }
            short s = Mmulti.myconnectindex;
            this.gCheckHead[s] = this.gCheckHead[s] + 1;
        }
    }

    @Override
    public void CheckSync() {
        if (PlayerSync != null || PlayerSpriteSync != null) {
            if (this.gNetFifoTail < PlayerSyncTrail) {
                return;
            }
            Console.Println("gNetFifoTail: " + this.gNetFifoTail + ", PlayerSyncTrail: " + PlayerSyncTrail);
            if (PlayerSync != null) {
                PlayerSync.compare(Game.Player[WangNetwork.PlayerSync.pnum]);
            }
            if (PlayerSpriteSync != null) {
                Main.engine.compare(PlayerSpriteSync, Engine.sprite[PlayerSyncIndex]);
            }
            PlayerSyncTrail = -1;
            PlayerSyncIndex = -1;
            PlayerSync = null;
            PlayerSpriteSync = null;
        }
        super.CheckSync();
    }

    @Override
    public void NetDisconnect(int nPlayer) {
        super.NetDisconnect(nPlayer);
        this.app.Disconnect();
    }

    public void save(BufferResource fil) {
        fil.writeInt(this.KillLimit);
        fil.writeInt(this.TimeLimit);
        fil.writeInt(this.TimeLimitClock);
        fil.writeByte(this.MultiGameType != null ? this.MultiGameType.ordinal() : -1);
        fil.writeBoolean(this.TeamPlay);
        fil.writeBoolean(this.HurtTeammate);
        fil.writeBoolean(this.SpawnMarkers);
        fil.writeBoolean(this.NoRespawn);
        fil.writeBoolean(this.Nuke);
    }

    public void load(Resource res) {
        this.KillLimit = res.readInt();
        this.TimeLimit = res.readInt();
        this.TimeLimitClock = res.readInt();
        byte i = res.readByte();
        this.MultiGameType = i != -1 ? MultiGameTypes.values()[i] : null;
        this.TeamPlay = res.readBoolean();
        this.HurtTeammate = res.readBoolean();
        this.SpawnMarkers = res.readBoolean();
        this.NoRespawn = res.readBoolean();
        this.Nuke = res.readBoolean();
    }

    public static enum MultiGameTypes {
        MULTI_GAME_NONE,
        MULTI_GAME_COMMBAT,
        MULTI_GAME_COMMBAT_NO_RESPAWN,
        MULTI_GAME_COOPERATIVE,
        MULTI_GAME_AI_BOTS;

    }

    public static enum PacketType {
        LevelStart{

            @Override
            public int Get(int fromPlayer, byte[] buf, int len) {
                Main.gNet.retransmit(fromPlayer, buf, len);
                ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                bb.get();
                short nCheckVersion = bb.getShort();
                Game.pNetInfo.set(bb);
                if (nCheckVersion != 500) {
                    Main.game.GameMessage("These versions of Shadow Warrior cannot play together.");
                    Main.gNet.NetDisconnect(Mmulti.myconnectindex);
                    return -1;
                }
                if (Main.gNet.WaitForAllPlayers(0)) {
                    Main.gGameScreen.newgame(true, ((MenuNetwork)Main.game.menu.mMenus[11]).getFile(), Game.pNetInfo.nEpisode, Game.pNetInfo.nLevel, Game.pNetInfo.nDifficulty);
                }
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                bb.put((byte)(this.ordinal() + 8));
                bb.putShort((short)500);
                bb.put(Game.pNetInfo.getBytes());
                return bb.position();
            }
        }
        ,
        Profile{

            @Override
            public int Get(int fromPlayer, byte[] buf, int len) {
                Main.gNet.retransmit(fromPlayer, buf, len);
                byte nP = buf[1];
                boolean AutoRun = buf[2] == 1;
                byte NetColor = buf[3];
                boolean AutoAim = buf[4] == 1;
                len = 0;
                int i = 5;
                while (buf[i] != 0) {
                    ++i;
                    ++len;
                }
                PlayerStr pp = Game.Player[nP];
                pp.Flags = AutoRun ? (pp.Flags |= Gameutils.PF_LOCK_RUN) : (pp.Flags &= ~Gameutils.PF_LOCK_RUN);
                pp.Flags = AutoAim ? (pp.Flags |= Gameutils.PF_AUTO_AIM) : (pp.Flags &= ~Gameutils.PF_AUTO_AIM);
                pp.PlayerName = new String(buf, 5, len);
                pp.TeamColor = NetColor;
                if (pp.PlayerSprite != -1 && Gameutils.pUser[pp.PlayerSprite] != null) {
                    Engine.sprite[pp.PlayerSprite].pal = (short)(16 + pp.TeamColor);
                    Gameutils.pUser[pp.PlayerSprite].spal = (byte)Engine.sprite[pp.PlayerSprite].pal;
                }
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                buf[0] = (byte)(this.ordinal() + 8);
                buf[1] = (byte)Mmulti.myconnectindex;
                buf[2] = Main.gs.AutoRun ? (byte)1 : 0;
                buf[3] = Main.gs.NetColor;
                buf[4] = Main.gs.AutoAim ? (byte)1 : 0;
                int l = 5;
                char[] name = Strhandler.toCharArray(Main.gs.pName);
                int i = 0;
                while (i < Main.gs.pName.length() && name[i] != '\u0000') {
                    buf[l++] = (byte)name[i];
                    ++i;
                }
                buf[l++] = 0;
                return l;
            }
        }
        ,
        Message{
            private int sendmessagecommand;
            private String message;

            @Override
            public void setData(Object ... opts) {
                if (opts.length < 2) {
                    return;
                }
                this.sendmessagecommand = (Integer)opts[0];
                this.message = (String)opts[1];
            }

            @Override
            public int Get(int fromMaster, byte[] buf, int len) {
                byte fromPlayer = buf[1];
                byte nPlayer = buf[2];
                Main.gNet.retransmit(fromMaster, buf, len);
                if (nPlayer == -1 || nPlayer == Mmulti.myconnectindex) {
                    if (nPlayer != -1) {
                        JPlayer.adduserquote(String.valueOf(Game.Player[fromPlayer].getName()) + ": " + new String(buf, 3, len - 3));
                    } else {
                        JPlayer.adduserquote(new String(buf, 3, len - 3));
                    }
                    Sound.PlaySound(504, null, 8);
                }
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                bb.put((byte)(this.ordinal() + 8));
                bb.put((byte)Mmulti.myconnectindex);
                bb.put((byte)this.sendmessagecommand);
                bb.put(this.message.getBytes());
                bb.put((byte)0);
                return bb.position();
            }
        }
        ,
        RTS_Sound{
            int num = 0;

            @Override
            public void setData(Object ... opts) {
                this.num = (Integer)opts[0];
            }

            @Override
            public int Get(int fromPlayer, byte[] buf, int len) {
                Main.gNet.retransmit(fromPlayer, buf, len);
                Sound.PlaySoundRTS(buf[1]);
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                Sound.PlaySoundRTS(this.num);
                buf[0] = (byte)(this.ordinal() + 8);
                buf[1] = (byte)this.num;
                return 2;
            }
        }
        ,
        PlayerData{
            int num = 0;

            @Override
            public void setData(Object ... opts) {
                this.num = (Integer)opts[0];
            }

            @Override
            public int Get(int fromPlayer, byte[] buf, int len) {
                Main.gNet.retransmit(fromPlayer, buf, len);
                DataResource res = new DataResource(buf);
                res.readByte();
                PlayerSyncTrail = res.readInt();
                PlayerSyncIndex = res.readInt();
                PlayerSpriteSync = new SPRITE();
                PlayerSpriteSync.buildSprite(res);
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                bb.put((byte)(this.ordinal() + 8));
                int trail = Main.gNet.gNetFifoTail;
                if (Mmulti.myconnectindex == Mmulti.connecthead) {
                    ++trail;
                }
                bb.putInt(trail);
                bb.putInt(Game.Player[this.num].PlayerSprite);
                bb.put(Engine.sprite[Game.Player[this.num].PlayerSprite].getBytes());
                return bb.position();
            }
        }
        ,
        ContentRequest{
            private String filepath;
            private long crc32;

            @Override
            public void setData(Object ... opts) {
                this.filepath = (String)opts[0];
                this.crc32 = (Long)opts[1];
            }

            @Override
            public int Get(int fromPlayer, byte[] p, int len) {
                Main.gNet.retransmit(fromPlayer, p, len);
                ByteBuffer bb = ByteBuffer.wrap(p).order(ByteOrder.LITTLE_ENDIAN);
                bb.position(1);
                int pathlen = bb.getInt();
                if (pathlen >= bb.remaining() - 5) {
                    pathlen = bb.remaining() - 6;
                }
                int ptr = bb.position();
                int nextptr = ptr + pathlen;
                boolean isDirectory = false;
                if (p[ptr] == 60 && p[ptr + 1] == 100 && p[ptr + 2] == 62) {
                    isDirectory = true;
                    ptr += 3;
                    pathlen -= 3;
                }
                String path = FileUtils.getCorrectPath(new String(p, ptr, pathlen));
                bb.position(nextptr);
                long crc32 = (long)bb.getInt() & 0xFFFFFFFFL;
                long mycrc = -1L;
                FileEntry fil = BuildGdx.compat.checkFile(path);
                GameInfo ini = ResourceHandler.GetEpisode(path, !isDirectory);
                int found = 0;
                if (fil != null || ini != null) {
                    MenuNetwork network = (MenuNetwork)Main.game.menu.mMenus[11];
                    if (ini != null) {
                        mycrc = ini.getChecksum();
                        if (mycrc == crc32) {
                            found = 1;
                            network.setEpisode(ini);
                        } else {
                            found = 2;
                            Console.Println("Player" + fromPlayer + " - " + Game.Player[fromPlayer].getName() + " tried to set user content. User content found, but has a different checksum!", Console.OSDTEXT_RED);
                            Console.Println("Make sure that you have the same content: " + File.separator + path, Console.OSDTEXT_RED);
                            if (!Console.IsShown()) {
                                Console.toggle();
                            }
                        }
                    } else if (fil != null && fil.getExtension().equals("map")) {
                        mycrc = fil.getChecksum();
                        if (mycrc == crc32) {
                            found = 1;
                            network.setMap(fil);
                        } else {
                            found = 2;
                            Console.Println("Player" + fromPlayer + " - " + Game.Player[fromPlayer].getName() + " tried to set user content. User content found, but has a different checksum!", Console.OSDTEXT_RED);
                            Console.Println("Make sure that you have the same content: " + File.separator + path, Console.OSDTEXT_RED);
                            if (!Console.IsShown()) {
                                Console.toggle();
                            }
                        }
                    }
                } else {
                    Console.Println("Player" + fromPlayer + " - " + Game.Player[fromPlayer].getName() + " tried to set user content. User content not found!", Console.OSDTEXT_RED);
                    Console.Println("Make sure that you have content at the same path: " + File.separator + path, Console.OSDTEXT_RED);
                    if (!Console.IsShown()) {
                        Console.toggle();
                    }
                }
                ContentAnswer.setData((byte)found);
                int l = ContentAnswer.Send(netbuf);
                Mmulti.sendpacket(fromPlayer, netbuf, l);
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                bb.put((byte)(this.ordinal() + 8));
                int len = Math.min(this.filepath.length(), 246);
                bb.putInt(len);
                bb.put(this.filepath.getBytes());
                bb.putInt((int)this.crc32);
                return bb.position();
            }
        }
        ,
        ContentAnswer{
            private byte found;

            @Override
            public void setData(Object ... opts) {
                this.found = (Byte)opts[0];
            }

            @Override
            public int Get(int fromPlayer, byte[] p, int len) {
                Main.gNet.retransmit(fromPlayer, p, len);
                Main.gNet.gContentFound[fromPlayer] = p[1];
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                bb.put((byte)(this.ordinal() + 8));
                bb.put(this.found);
                return bb.position();
            }
        };


        public abstract int Get(int var1, byte[] var2, int var3);

        public abstract int Send(byte[] var1);

        public void setData(Object ... opts) {
        }
    }
}

