/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.PlayerStr;

public class Quake {
    public static final int QUAKE_Match(SPRITE sp) {
        return Gameutils.SP_TAG2(sp);
    }

    public static final int QUAKE_Zamt(SPRITE sp) {
        return Gameutils.SP_TAG3(sp);
    }

    public static final int QUAKE_Radius(SPRITE sp) {
        return Gameutils.SP_TAG4(sp);
    }

    public static final int QUAKE_Duration(SPRITE sp) {
        return Gameutils.SP_TAG5(sp);
    }

    public static final int QUAKE_WaitSecs(SPRITE sp) {
        return Gameutils.SP_TAG6(sp);
    }

    public static final int QUAKE_AngAmt(SPRITE sp) {
        return Gameutils.SP_TAG7(sp);
    }

    public static final int QUAKE_PosAmt(SPRITE sp) {
        return Gameutils.SP_TAG8(sp);
    }

    public static final int QUAKE_RandomTest(SPRITE sp) {
        return Gameutils.SP_TAG9(sp);
    }

    public static final int QUAKE_WaitTics(SPRITE sp) {
        return Gameutils.SP_TAG13(sp);
    }

    public static final boolean QUAKE_TestDontTaper(SPRITE sp) {
        return Gameutils.TEST_BOOL1(sp);
    }

    public static final boolean QUAKE_KillAfterQuake(SPRITE sp) {
        return Gameutils.TEST_BOOL2(sp);
    }

    public static final boolean QUAKE_WaitForTrigger(SPRITE sp) {
        return Gameutils.TEST_BOOL3(sp);
    }

    public static int CopyQuakeSpotToOn(SPRITE sp) {
        short newsp = Rooms.COVERinsertsprite(sp.sectnum, 91);
        SPRITE np = Engine.sprite[newsp];
        np.set(sp);
        np.cstat = 0;
        np.extra = 0;
        np.owner = (short)-1;
        Sprites.change_sprite_stat(newsp, 92);
        np.xvel = (short)(np.xvel * 120);
        return newsp;
    }

    public static void DoQuakeMatch(int match) {
        short i = Engine.headspritestat[91];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (Quake.QUAKE_Match(sp) == match) {
                if (Quake.QUAKE_WaitTics(sp) > 0) {
                    Gameutils.RESET_BOOL3(sp);
                } else {
                    Quake.CopyQuakeSpotToOn(sp);
                    if (Quake.QUAKE_KillAfterQuake(sp)) {
                        Sprites.KillSprite(i);
                    }
                }
            }
            i = nexti;
        }
    }

    public static void ProcessQuakeOn() {
        short i = Engine.headspritestat[92];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            sp.xvel = (short)(sp.xvel - 12);
            if (Quake.QUAKE_Duration(sp) < 0) {
                Sprites.KillSprite(i);
            }
            i = nexti;
        }
    }

    public static void ProcessQuakeSpot() {
        short i = Engine.headspritestat[91];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (Quake.QUAKE_WaitSecs(sp) != 0 && !Quake.QUAKE_WaitForTrigger(sp)) {
                Gameutils.SET_SP_TAG13(sp, Quake.QUAKE_WaitTics(sp) - 12);
                if (Quake.QUAKE_WaitTics(sp) < 0) {
                    Gameutils.SET_SP_TAG13(sp, (Quake.QUAKE_WaitSecs(sp) * 10 + Quake.QUAKE_Duration(sp)) * 120);
                    long rand_test = Quake.QUAKE_RandomTest(sp);
                    if (rand_test == 0L || rand_test != 0L && (long)Gameutils.RANDOM_RANGE(128) < rand_test) {
                        Quake.CopyQuakeSpotToOn(sp);
                        if (Quake.QUAKE_KillAfterQuake(sp)) {
                            Sound.DeleteNoSoundOwner(i);
                            Sprites.KillSprite(i);
                        }
                    }
                }
            }
            i = nexti;
        }
    }

    public static void QuakeViewChange(PlayerStr pp, LONGp z_diff, LONGp x_diff, LONGp y_diff, LONGp ang_diff) {
        SPRITE sp;
        SPRITE save_sp = null;
        int save_dist = 999999;
        z_diff.value = 0;
        x_diff.value = 0;
        y_diff.value = 0;
        ang_diff.value = 0;
        if (Main.game.gPaused) {
            return;
        }
        short i = Engine.headspritestat[92];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            int dist = Gameutils.FindDistance3D(pp.posx - sp.x, pp.posy - sp.y, pp.posz - sp.z >> 4);
            if (Quake.QUAKE_TestDontTaper(sp)) {
                save_dist = dist;
                save_sp = sp;
                break;
            }
            if (dist < save_dist) {
                save_dist = dist;
                save_sp = sp;
            }
            i = nexti;
        }
        if (save_sp == null) {
            return;
        }
        sp = save_sp;
        int radius = Quake.QUAKE_Radius(sp) * 8;
        if (save_dist > radius) {
            return;
        }
        z_diff.value = Gameutils.Z(Gameutils.STD_RANDOM_RANGE(Quake.QUAKE_Zamt(sp)) - Quake.QUAKE_Zamt(sp) / 2);
        int ang_amt = Quake.QUAKE_AngAmt(sp) * 4;
        ang_diff.value = Gameutils.STD_RANDOM_RANGE(ang_amt) - ang_amt / 2;
        int pos_amt = Quake.QUAKE_PosAmt(sp) * 4;
        x_diff.value = Gameutils.STD_RANDOM_RANGE(pos_amt) - pos_amt / 2;
        y_diff.value = Gameutils.STD_RANDOM_RANGE(pos_amt) - pos_amt / 2;
        if (!Quake.QUAKE_TestDontTaper(sp)) {
            int dist_diff = radius - save_dist;
            int scale_value = Pragmas.divscale(dist_diff, radius, 16);
            z_diff.value = Pragmas.mulscale(z_diff.value, scale_value, 16);
            ang_diff.value = Pragmas.mulscale(ang_diff.value, scale_value, 16);
            x_diff.value = Pragmas.mulscale(x_diff.value, scale_value, 16);
            y_diff.value = Pragmas.mulscale(y_diff.value, scale_value, 16);
        }
    }

    public static int SpawnQuake(short sectnum, int x, int y, int z, int tics, int amt, int radius) {
        short SpriteNum = Rooms.COVERinsertsprite(sectnum, 92);
        SPRITE sp = Engine.sprite[SpriteNum];
        sp.x = x;
        sp.y = y;
        sp.z = z;
        sp.cstat = 0;
        sp.owner = (short)-1;
        sp.extra = 0;
        sp.lotag = (short)-1;
        sp.clipdist = amt;
        sp.ang = (short)(radius / 8);
        sp.xvel = (short)tics;
        sp.zvel = (short)8;
        Sound.Set3DSoundOwner(SpriteNum, Sound.PlaySound(216, sp, 9));
        return SpriteNum;
    }

    public static boolean SetQuake(PlayerStr pp, short tics, short amt) {
        Quake.SpawnQuake(pp.cursectnum, pp.posx, pp.posy, pp.posz, tics, amt, 30000);
        return false;
    }

    public static int SetExpQuake(int Weapon2) {
        SPRITE sp = Engine.sprite[Weapon2];
        Quake.SpawnQuake(sp.sectnum, sp.x, sp.y, sp.z, 40, 4, 20000);
        return 0;
    }

    public static int SetGunQuake(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        Quake.SpawnQuake(sp.sectnum, sp.x, sp.y, sp.z, 40, 8, 40000);
        return 0;
    }

    public static int SetPlayerQuake(PlayerStr pp) {
        Quake.SpawnQuake(pp.cursectnum, pp.posx, pp.posy, pp.posz, 40, 8, 40000);
        return 0;
    }

    public static int SetNuclearQuake(int Weapon2) {
        SPRITE sp = Engine.sprite[Weapon2];
        Quake.SpawnQuake(sp.sectnum, sp.x, sp.y, sp.z, 400, 8, 64000);
        return 0;
    }

    public static int SetSumoQuake(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        Quake.SpawnQuake(sp.sectnum, sp.x, sp.y, sp.z, 120, 4, 20000);
        return 0;
    }

    public static int SetSumoFartQuake(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        Quake.SpawnQuake(sp.sectnum, sp.x, sp.y, sp.z, 60, 4, 4000);
        return 0;
    }
}

