/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Morth;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Vator;

public class Spike {
    public static final Animator DoSpike = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Spike.DoSpike(spr) != 0;
        }
    };
    public static final Animator DoSpikeAuto = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Spike.DoSpikeAuto(spr) != 0;
        }
    };

    public static void ReverseSpike(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        if (u.Tics != 0) {
            u.Tics = 0;
            Spike.SetSpikeActive(SpriteNum);
            return;
        }
        if (u.z_tgt == u.oz) {
            if (sp.z == u.oz) {
                u.z_tgt = u.sz;
            } else if (u.sz == u.oz) {
                u.z_tgt = sp.z;
            }
        } else if (u.z_tgt == u.sz) {
            if (sp.z == u.oz) {
                u.z_tgt = sp.z;
            } else if (u.sz == u.oz) {
                u.z_tgt = u.sz;
            }
        }
        u.vel_rate = -u.vel_rate;
    }

    public static boolean SpikeSwitch(int match, int setting) {
        boolean found = false;
        short i = Engine.headspritestat[0];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (sp.lotag == 206 && sp.hitag == match) {
                found = true;
                Sector.AnimateSwitch(sp, setting);
            }
            i = nexti;
        }
        return found;
    }

    public static void SetSpikeActive(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        Vator.InterpSectorSprites(sp.sectnum, true);
        Sector.DoSoundSpotMatch(Gameutils.SP_TAG2(sp), 1, Sound.SoundType.SOUND_OBJECT_TYPE);
        u.Flags |= Gameutils.SPR_ACTIVE;
        u.Tics = 0;
        if (u.z_tgt == sp.z) {
            Vator.VatorSwitch(Gameutils.SP_TAG2(sp), 1);
        } else if (u.z_tgt == u.sz) {
            Vator.VatorSwitch(Gameutils.SP_TAG2(sp), 0);
        }
    }

    public static void SetSpikeInactive(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        Vator.InterpSectorSprites(sp.sectnum, false);
        Sector.DoSoundSpotMatch(Gameutils.SP_TAG2(sp), 2, Sound.SoundType.SOUND_OBJECT_TYPE);
        u.Flags &= ~Gameutils.SPR_ACTIVE;
    }

    public static short DoSpikeOperate(PlayerStr pp, short sectnum) {
        short i = Engine.headspritesect[sectnum];
        while (i != -1) {
            short nexti = Engine.nextspritesect[i];
            SPRITE fsp = Engine.sprite[i];
            if (fsp.statnum == 82 && Gameutils.SP_TAG1(fsp) == 106 && Gameutils.SP_TAG3(fsp) == 0) {
                sectnum = fsp.sectnum;
                short match = (short)Gameutils.SP_TAG2(fsp);
                if (match > 0) {
                    if (Spike.TestSpikeMatchActive(match)) {
                        return -1;
                    }
                    return Spike.DoSpikeMatch(pp, match);
                }
                Spike.SetSpikeActive(i);
                break;
            }
            i = nexti;
        }
        return i;
    }

    public static short DoSpikeMatch(PlayerStr pp, int match) {
        short first_spike = -1;
        short i = Engine.headspritestat[82];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE fsp = Engine.sprite[i];
            if (Gameutils.SP_TAG1(fsp) == 106 && Gameutils.SP_TAG2(fsp) == match) {
                USER fu = Gameutils.pUser[i];
                if (first_spike == -1) {
                    first_spike = i;
                }
                if (MyTypes.TEST(fu.Flags, Gameutils.SPR_ACTIVE)) {
                    Spike.ReverseSpike(i);
                } else {
                    Spike.SetSpikeActive(i);
                }
            }
            i = nexti;
        }
        return first_spike;
    }

    public static boolean TestSpikeMatchActive(int match) {
        short i = Engine.headspritestat[82];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE fsp = Engine.sprite[i];
            if (Gameutils.SP_TAG1(fsp) == 106 && Gameutils.SP_TAG2(fsp) == match) {
                USER fu = Gameutils.pUser[i];
                if (!Gameutils.TEST_BOOL6(fsp) && (MyTypes.TEST(fu.Flags, Gameutils.SPR_ACTIVE) || fu.Tics != 0)) {
                    return true;
                }
            }
            i = nexti;
        }
        return false;
    }

    public static int DoSpikeMove(int SpriteNum, int lptr) {
        USER u = Gameutils.pUser[SpriteNum];
        int zval = lptr;
        if (zval < u.z_tgt) {
            u.jump_speed = (short)(u.jump_speed + u.vel_rate * 3);
            if ((zval += 3 * u.jump_speed) > u.z_tgt) {
                zval = u.z_tgt;
            }
        }
        if (zval > u.z_tgt) {
            u.jump_speed = (short)(u.jump_speed + u.vel_rate * 3);
            if ((zval -= 3 * u.jump_speed) < u.z_tgt) {
                zval = u.z_tgt;
            }
        }
        return zval;
    }

    public static void SpikeAlign(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        if ((byte)Gameutils.SP_TAG7(sp) < 0) {
            if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_YFLIP)) {
                Main.game.pInt.setcheinuminterpolate(sp.sectnum, Engine.sector[sp.sectnum]);
                Main.engine.alignceilslope(sp.sectnum, sp.x, sp.y, u.zclip);
            } else {
                Main.game.pInt.setfheinuminterpolate(sp.sectnum, Engine.sector[sp.sectnum]);
                Main.engine.alignflorslope(sp.sectnum, sp.x, sp.y, u.zclip);
            }
        } else if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_YFLIP)) {
            Morth.SOBJ_AlignCeilingToPoint(Sprites.SectorObject[Gameutils.SP_TAG7(sp)], sp.x, sp.y, u.zclip);
        } else {
            Morth.SOBJ_AlignFloorToPoint(Sprites.SectorObject[Gameutils.SP_TAG7(sp)], sp.x, sp.y, u.zclip);
        }
    }

    public static void MoveSpritesWithSpike(short sectnum) {
        short i = Engine.headspritesect[sectnum];
        while (i != -1) {
            short nexti = Engine.nextspritesect[i];
            SPRITE sp = Engine.sprite[i];
            if (Gameutils.pUser[i] == null && !MyTypes.TEST(sp.extra, Gameutils.SPRX_STAY_PUT_VATOR)) {
                Main.engine.getzsofslope(sectnum, sp.x, sp.y, Rooms.zofslope);
                Main.game.pInt.setsprinterpolate(i, sp);
                sp.z = Rooms.zofslope[1];
            }
            i = nexti;
        }
    }

    public static int DoSpike(int SpriteNum) {
        int lptr;
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        u.zclip = lptr = Spike.DoSpikeMove(SpriteNum, u.zclip);
        Spike.MoveSpritesWithSpike(sp.sectnum);
        Spike.SpikeAlign(SpriteNum);
        if (lptr == u.z_tgt) {
            if (u.z_tgt == sp.z) {
                u.z_tgt = u.sz;
                u.vel_rate = -u.vel_rate;
                Spike.SetSpikeInactive(SpriteNum);
                if (Gameutils.SP_TAG6(sp) != 0) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            } else if (u.z_tgt == u.sz) {
                int match = Gameutils.SP_TAG2(sp);
                u.jump_speed = (short)u.vel_tgt;
                u.vel_rate = (short)Pragmas.klabs(u.vel_rate);
                u.z_tgt = sp.z;
                Spike.SetSpikeInactive(SpriteNum);
                Spike.TestSpikeMatchActive(match);
                if (Gameutils.SP_TAG6(sp) != 0 && Gameutils.TEST_BOOL5(sp)) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            }
            if (Gameutils.TEST_BOOL2(sp)) {
                Spike.SetSpikeInactive(SpriteNum);
                Sprites.KillSprite(SpriteNum);
                return 0;
            }
            if (lptr != u.oz && u.WaitTics != 0) {
                u.Tics = u.WaitTics;
            }
        } else if (Gameutils.TEST_BOOL3(sp) && u.z_tgt == u.oz) {
            boolean found = false;
            short i = Engine.headspritesect[sp.sectnum];
            while (i != -1) {
                short nexti = Engine.nextspritesect[i];
                SPRITE bsp = Engine.sprite[i];
                USER bu = Gameutils.pUser[i];
                if (bu != null && MyTypes.TEST(bsp.cstat, Gameutils.CSTAT_SPRITE_BLOCK) && MyTypes.TEST(bsp.extra, Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                    Spike.ReverseSpike(SpriteNum);
                    found = true;
                    break;
                }
                i = nexti;
            }
            if (!found) {
                short pnum = Mmulti.connecthead;
                while (pnum != -1) {
                    PlayerStr pp = Game.Player[pnum];
                    if (pp.lo_sectp != -1 && pp.lo_sectp == sp.sectnum || pp.hi_sectp != -1 && pp.hi_sectp == sp.sectnum) {
                        Spike.ReverseSpike(SpriteNum);
                        found = true;
                    }
                    pnum = Mmulti.connectpoint2[pnum];
                }
            }
        }
        return 0;
    }

    public static int DoSpikeAuto(int SpriteNum) {
        int lptr;
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        u.zclip = lptr = Spike.DoSpikeMove(SpriteNum, u.zclip);
        Spike.MoveSpritesWithSpike(sp.sectnum);
        Spike.SpikeAlign(SpriteNum);
        if (lptr == u.z_tgt) {
            if (u.z_tgt == sp.z) {
                u.z_tgt = u.sz;
                u.vel_rate = -u.vel_rate;
                u.Tics = u.WaitTics;
                if (Gameutils.SP_TAG6(sp) != 0) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            } else if (u.z_tgt == u.sz) {
                u.jump_speed = (short)u.vel_tgt;
                u.vel_rate = (short)Pragmas.klabs(u.vel_rate);
                u.z_tgt = sp.z;
                u.Tics = u.WaitTics;
                if (Gameutils.SP_TAG6(sp) != 0 && Gameutils.TEST_BOOL5(sp)) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            }
        }
        return 0;
    }
}

