/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Pattern.BuildNet;

public class Input
implements BuildNet.NetInput {
    private static final int sizeof = 20;
    public float angvel;
    public float horiz;
    public int fvel;
    public int svel;
    public int bits;
    private ByteBuffer InputBuffer;

    public Input() {
    }

    public Input(Object data) {
        this.setBytes(data, new int[0]);
    }

    public int setBytes(Object data, int ... offs) {
        int offset = 0;
        if (offs.length == 1) {
            offset = offs[0];
        }
        ByteBuffer bb = null;
        if (data instanceof byte[]) {
            bb = ByteBuffer.wrap((byte[])data);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.position(offset);
        } else if (data instanceof ByteBuffer) {
            bb = (ByteBuffer)data;
        } else {
            return offset;
        }
        this.angvel = bb.getFloat();
        this.horiz = bb.getFloat();
        this.fvel = bb.getInt();
        this.svel = bb.getInt();
        this.bits = bb.getInt();
        return bb.position();
    }

    public byte[] getBytes() {
        if (this.InputBuffer == null) {
            this.InputBuffer = ByteBuffer.allocate(20);
        } else {
            this.InputBuffer.clear();
        }
        this.InputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.InputBuffer.putFloat(this.angvel);
        this.InputBuffer.putFloat(this.horiz);
        this.InputBuffer.putInt(this.fvel);
        this.InputBuffer.putInt(this.svel);
        this.InputBuffer.putInt(this.bits);
        return this.InputBuffer.array();
    }

    @Override
    public void Reset() {
        this.fvel = 0;
        this.svel = 0;
        this.angvel = 0.0f;
        this.bits = 0;
        this.horiz = 0.0f;
    }

    @Override
    public BuildNet.NetInput Copy(BuildNet.NetInput src) {
        Input input = (Input)src;
        this.fvel = input.fvel;
        this.svel = input.svel;
        this.angvel = input.angvel;
        this.bits = input.bits;
        this.horiz = input.horiz;
        return this;
    }

    @Override
    public int GetInput(byte[] p, int offset, BuildNet.NetInput oldInput) {
        return 0;
    }

    @Override
    public int PutInput(byte[] p, int offset, BuildNet.NetInput oldInput) {
        return 0;
    }
}

