/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Witchaven.Factory.WHSoftware;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Potions;
import ru.m210projects.Witchaven.Spellbooks;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHOBJ;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.Weapons;

public class WHScreen {
    private static int[] zofslope = new int[2];
    public static char[] armorbuf = new char[50];
    public static char[] scorebuf = new char[50];
    public static char[] healthbuf = new char[50];
    private static final char[] buffer = new char[256];
    public static boolean drawfloormirror = false;
    public static int zoom = 256;
    public static final Vector3[] sflag = new Vector3[]{new Vector3(260.0f, 387.0f, 0.0f), new Vector3(286.0f, 387.0f, 10.0f), new Vector3(260.0f, 417.0f, 11.0f), new Vector3(286.0f, 417.0f, 12.0f)};
    public static char[] displaybuf = new char[128];
    public static int redcount;
    public static int whitecount;
    public static int greencount;
    public static int bluecount;
    public static final int NUMWHITESHIFTS = 3;
    public static final int WHITESTEPS = 20;
    public static final int WHITETICS = 6;
    public static final int NUMREDSHIFTS = 4;
    public static final int REDSTEPS = 8;
    public static final int NUMGREENSHIFTS = 4;
    public static final int GREENSTEPS = 8;
    public static final int NUMBLUESHIFTS = 4;
    public static final int BLUESTEPS = 8;
    public static final byte[][] whiteshifts;
    public static final byte[][] redshifts;
    public static final byte[][] greenshifts;
    public static final byte[][] blueshifts;
    public static boolean palshifted;
    public static SPRITE[] tspritelist;
    public static int tspritelistcnt;
    public static int displaytime;
    public static String lastmessage;

    static {
        whiteshifts = new byte[4][768];
        redshifts = new byte[4][768];
        greenshifts = new byte[4][768];
        blueshifts = new byte[4][768];
        tspritelist = new SPRITE[1025];
    }

    public static void initpaletteshifts() {
        int delta;
        int j;
        int baseptr;
        int workptr;
        int i = 1;
        while (i <= 4) {
            workptr = 0;
            baseptr = 0;
            j = 0;
            while (j <= 255) {
                delta = 64 - (Engine.palette[baseptr] & 0xFF);
                WHScreen.redshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 8 << 2);
                delta = -(Engine.palette[baseptr] & 0xFF);
                WHScreen.redshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 8 << 2);
                delta = -(Engine.palette[baseptr] & 0xFF);
                WHScreen.redshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 8 << 2);
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= 3) {
            workptr = 0;
            baseptr = 0;
            j = 0;
            while (j <= 255) {
                delta = 64 - (Engine.palette[baseptr] & 0xFF);
                WHScreen.whiteshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 20 << 2);
                delta = 62 - (Engine.palette[baseptr] & 0xFF);
                WHScreen.whiteshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 20 << 2);
                delta = 0 - (Engine.palette[baseptr] & 0xFF);
                WHScreen.whiteshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 20 << 2);
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= 4) {
            workptr = 0;
            baseptr = 0;
            j = 0;
            while (j <= 255) {
                delta = -(Engine.palette[baseptr] & 0xFF);
                WHScreen.greenshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 8 << 2);
                delta = 64 - (Engine.palette[baseptr] & 0xFF);
                WHScreen.greenshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 8 << 2);
                delta = -(Engine.palette[baseptr] & 0xFF);
                WHScreen.greenshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 8 << 2);
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= 4) {
            workptr = 0;
            baseptr = 0;
            j = 0;
            while (j <= 255) {
                delta = -(Engine.palette[baseptr] & 0xFF);
                WHScreen.blueshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 8 << 2);
                delta = -(Engine.palette[baseptr] & 0xFF);
                WHScreen.blueshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 8 << 2);
                delta = 64 - (Engine.palette[baseptr] & 0xFF);
                WHScreen.blueshifts[i - 1][workptr++] = (byte)((Engine.palette[baseptr++] & 0xFF) + delta * i / 8 << 2);
                ++j;
            }
            ++i;
        }
    }

    public static void updatepaletteshifts() {
        if (Main.engine.glrender() != null) {
            if (whitecount != 0) {
                whitecount = Gameutils.BClipLow(whitecount - 3, 0);
            }
            if (redcount != 0) {
                redcount = Gameutils.BClipLow(redcount - 3, 0);
            }
            if (bluecount != 0) {
                bluecount = Gameutils.BClipLow(bluecount - 3, 0);
            }
            if (greencount != 0) {
                greencount = Gameutils.BClipLow(greencount - 3, 0);
            }
        } else {
            int red = 0;
            int white = 0;
            int green = 0;
            int blue = 0;
            if (whitecount != 0) {
                white = Gameutils.BClipHigh(whitecount / 6 + 1, 3);
                whitecount = Gameutils.BClipLow(whitecount - 3, 0);
            }
            if (redcount != 0) {
                red = Gameutils.BClipHigh(redcount / 10 + 1, 4);
                redcount = Gameutils.BClipLow(redcount - 3, 0);
            }
            if (greencount != 0) {
                green = Gameutils.BClipHigh(greencount / 10 + 1, 4);
                greencount = Gameutils.BClipLow(greencount - 3, 0);
            }
            if (bluecount != 0) {
                blue = Gameutils.BClipHigh(bluecount / 10 + 1, 4);
                bluecount = Gameutils.BClipLow(bluecount - 3, 0);
            }
            if (red != 0) {
                Main.engine.changepalette(redshifts[red - 1]);
                palshifted = true;
            } else if (white != 0) {
                Main.engine.changepalette(whiteshifts[white - 1]);
                palshifted = true;
            } else if (green != 0) {
                Main.engine.changepalette(greenshifts[green - 1]);
                palshifted = true;
            } else if (blue != 0) {
                Main.engine.changepalette(blueshifts[blue - 1]);
                palshifted = true;
            } else if (palshifted) {
                int brightness = BuildSettings.paletteGamma.get();
                Main.engine.setbrightness(brightness, Engine.palette, GLRenderer.GLInvalidateFlag.All);
                palshifted = false;
            }
        }
    }

    public static void startredflash(int damage) {
        redcount = Gameutils.BClipHigh(redcount + 3 * damage, 100);
    }

    public static void startblueflash(int bluetime) {
        bluecount = Gameutils.BClipHigh(bluecount + 3 * bluetime, 100);
    }

    public static void startwhiteflash(int whitetime) {
        whitecount = Gameutils.BClipHigh(whitecount + 3 * whitetime, 100);
    }

    public static void startgreenflash(int greentime) {
        greencount = Gameutils.BClipHigh(greencount + 3 * greentime, 100);
    }

    public static void resetflash() {
        redcount = 0;
        whitecount = 0;
        greencount = 0;
        bluecount = 0;
        Main.engine.updateFade("RED", 0);
        Main.engine.updateFade("WHITE", 0);
        Main.engine.updateFade("GREEN", 0);
        Main.engine.updateFade("BLUE", 0);
    }

    public static void showmessage(String message, int time) {
        Strhandler.buildString(displaybuf, 0, message);
        displaytime = time;
        if (!message.equals(lastmessage)) {
            Console.Println(message);
        }
        lastmessage = message;
    }

    public static void setup3dscreen(int w, int h) {
        if (!Main.engine.setgamemode(Main.whcfg.fullscreen, w, h)) {
            Main.whcfg.fullscreen = 0;
        }
        Engine.fullscreen = Main.whcfg.fullscreen;
        Main.whcfg.ScreenWidth = BuildGdx.graphics.getWidth();
        Main.whcfg.ScreenHeight = BuildGdx.graphics.getHeight();
    }

    public static void spikeanimation(PLAYER plr) {
        if (plr.spiketics < 0) {
            ++plr.currspikeframe;
            if (plr.currspikeframe > 4) {
                plr.currspikeframe = 4;
            }
            plr.spiketics = Weapons.spikeanimtics[plr.currspikeframe].daweapontics;
            plr.spikeframe = Weapons.spikeanimtics[plr.currspikeframe].daweaponframe;
        }
    }

    public static void drawscreen(int num, int dasmoothratio) {
        PLAYER plr = WHPLR.player[num];
        int cposx = plr.x;
        int cposy = plr.y;
        int cposz = plr.z;
        float cang = plr.ang;
        float choriz = plr.horiz + plr.jumphoriz;
        if (!Main.game.menu.gShowMenu && !Console.IsShown()) {
            int ix = WHPLR.gPrevPlayerLoc[num].x;
            int iy = WHPLR.gPrevPlayerLoc[num].y;
            int iz = WHPLR.gPrevPlayerLoc[num].z;
            float iHoriz = WHPLR.gPrevPlayerLoc[num].horiz;
            float inAngle = WHPLR.gPrevPlayerLoc[num].ang;
            ix += Pragmas.mulscale(cposx - WHPLR.gPrevPlayerLoc[num].x, dasmoothratio, 16);
            iy += Pragmas.mulscale(cposy - WHPLR.gPrevPlayerLoc[num].y, dasmoothratio, 16);
            iz += Pragmas.mulscale(cposz - WHPLR.gPrevPlayerLoc[num].z, dasmoothratio, 16);
            iHoriz += (choriz - WHPLR.gPrevPlayerLoc[num].horiz) * (float)dasmoothratio / 65536.0f;
            inAngle += (Gameutils.BClampAngle(cang - WHPLR.gPrevPlayerLoc[num].ang + 1024.0f) - 1024.0f) * (float)dasmoothratio / 65536.0f;
            cposx = ix;
            cposy = iy;
            cposz = iz;
            choriz = iHoriz;
            cang = inAngle;
        }
        if ((Engine.gotpic[22] & 0x40) != 0) {
            int dist = Integer.MAX_VALUE;
            int i = 0;
            int k = Globals.floormirrorcnt - 1;
            while (k >= 0) {
                short sect = Globals.floormirrorsector[k];
                if ((Engine.gotsector[sect >> 3] & 1 << (sect & 7)) != 0) {
                    int j = Pragmas.klabs(Engine.wall[Engine.sector[sect].wallptr].x - plr.x);
                    if ((j += Pragmas.klabs(Engine.wall[Engine.sector[sect].wallptr].y - plr.y)) < dist) {
                        dist = j;
                        i = k;
                    }
                }
                --k;
            }
            if (Main.engine.glrender() != null) {
                Engine.inpreparemirror = true;
                drawfloormirror = true;
                Main.engine.glrender().settiltang(1024);
                Main.engine.drawrooms(plr.x, plr.y, plr.z, plr.ang, 201.0f - plr.horiz, Globals.floormirrorsector[i]);
                WHScreen.analizesprites(plr, dasmoothratio);
                Main.engine.drawmasks();
                Main.engine.glrender().settiltang(0);
                Engine.inpreparemirror = false;
                drawfloormirror = false;
            } else {
                Main.engine.drawrooms(plr.x, plr.y, (Engine.sector[Globals.floormirrorsector[i]].floorz << 1) - plr.z, plr.ang, 201.0f - plr.horiz, Globals.floormirrorsector[i]);
                WHScreen.analizesprites(plr, dasmoothratio);
                Main.engine.drawmasks();
                WHSoftware rend = (WHSoftware)Main.engine.getrender();
                rend.TempHorizon((int)plr.horiz);
            }
            Engine.gotpic[22] = (byte)(Engine.gotpic[22] & 0xFFFFFFBF);
        }
        Main.engine.getzsofslope(plr.sector, cposx, cposy, zofslope);
        int lz = 1024;
        if (cposz < zofslope[0] + lz) {
            cposz = zofslope[0] + lz;
        }
        if (cposz > zofslope[1] - lz) {
            cposz = zofslope[1] - lz;
        }
        Main.engine.drawrooms(cposx, cposy, cposz, cang, choriz, plr.sector);
        WHScreen.analizesprites(plr, dasmoothratio);
        Main.engine.drawmasks();
        if (Globals.dimension == 2) {
            if (Globals.followmode) {
                cposx = Globals.followx;
                cposy = Globals.followy;
                cang = Globals.followa;
                Main.game.getFont(1).drawText(5, 25, Strhandler.toCharArray("follow mode"), 0, 7, BuildFont.TextAlign.Left, 258, false);
            }
            if (Main.mUserFlag == Main.UserFlag.UserMap) {
                Main.game.getFont(1).drawText(5, 15, Strhandler.toCharArray("user map: " + Globals.boardfilename), 0, 7, BuildFont.TextAlign.Left, 258, false);
            } else if (Globals.gCurrentEpisode != null && Globals.gCurrentEpisode.getMap(WHPLR.mapon) != null) {
                Main.game.getFont(1).drawText(5, 15, Globals.gCurrentEpisode.getMap((int)WHPLR.mapon).title, 0, 7, BuildFont.TextAlign.Left, 258, false);
            } else {
                Main.game.getFont(1).drawText(5, 15, "Map " + WHPLR.mapon, 0, 7, BuildFont.TextAlign.Left, 258, false);
            }
            Main.engine.drawoverheadmap(cposx, cposy, zoom, (short)cang);
        }
    }

    public static void drawscary() {
        if (WHFX.scarytime > 140 && WHFX.scarytime < 180) {
            Main.engine.rotatesprite(0xA00000, 0x640000, WHFX.scarysize << 9, 0, Names.SCARY, 0, 0, 3, 0, 0, Engine.xdim, Engine.ydim);
        }
        if (WHFX.scarytime > 120 && WHFX.scarytime < 139) {
            Main.engine.rotatesprite(0xA00000, 0x640000, WHFX.scarysize << 9, 0, Names.SCARY + 1, 0, 0, 3, 0, 0, Engine.xdim, Engine.ydim);
        }
        if (WHFX.scarytime > 100 && WHFX.scarytime < 119) {
            Main.engine.rotatesprite(0xA00000, 0x640000, WHFX.scarysize << 9, 0, Names.SCARY + 2, 0, 0, 3, 0, 0, Engine.xdim, Engine.ydim);
        }
        if (WHFX.scarytime > 0 && WHFX.scarytime < 99) {
            Main.engine.rotatesprite(0xA00000, 0x640000, WHFX.scarysize << 9, 0, Names.SCARY + 3, 0, 0, 3, 0, 0, Engine.xdim, Engine.ydim);
        }
    }

    public static void overwritesprite(int thex, int they, int tilenum, int shade, int stat, int dapalnum) {
        Main.engine.rotatesprite(thex << 16, they << 16, 65536, (stat & 8) << 7, tilenum, shade, dapalnum, ((stat & 1 ^ 1) << 4) + (stat & 2) + ((stat & 4) >> 2) + ((stat & 0x10) >> 2 ^ (stat & 8) >> 1) + 8 + (stat & 0x100) + (stat & 0x200), Engine.windowx1, Engine.windowy1, Engine.windowx2, Engine.windowy2);
    }

    public static void spikeheart(PLAYER plr) {
        int dax = Weapons.spikeanimtics[plr.currspikeframe].currx;
        int day = Weapons.spikeanimtics[plr.currspikeframe].curry;
        WHScreen.overwritesprite(dax, day, plr.spikeframe, Engine.sector[plr.sector].ceilingshade, 2, 0);
        WHScreen.startredflash(10);
    }

    public static void levelpic(PLAYER plr, int x, int y, int scale) {
        if (plr.selectedgun == 6) {
            Strhandler.Bitoa(plr.ammo[6], Globals.tempchar);
            if (Main.game.WH2) {
                int px = x - Pragmas.mulscale(314L, scale, 16);
                int py = y - Pragmas.mulscale(43L, scale, 16);
                Main.engine.rotatesprite(px << 16, py << 16, 2 * scale, 0, 1916, 0, 0, 24, px + Pragmas.mulscale(4L, scale, 16), py + Pragmas.mulscale(4L, scale, 16), Engine.xdim, py + Pragmas.mulscale(20L, scale, 16));
            } else {
                Main.engine.rotatesprite(x - Pragmas.mulscale(313L, scale, 16) << 16, y - Pragmas.mulscale(43L, scale, 16) << 16, scale, 0, Names.SARROWS, 0, 0, 24, 0, 0, Engine.xdim, Engine.ydim - 1);
            }
            Main.game.getFont(4).drawText(x - Pragmas.mulscale(235L, scale, 16), y - Pragmas.mulscale(40L, scale, 16), Globals.tempchar, scale, 0, 0, BuildFont.TextAlign.Left, 0, false);
        } else if (plr.selectedgun == 7 && plr.weapon[7] == 2) {
            Strhandler.Bitoa(plr.ammo[7], Globals.tempchar);
            Main.engine.rotatesprite(x - Pragmas.mulscale(Main.game.WH2 ? 314 : 313, scale, 16) << 16, y - Pragmas.mulscale(46L, scale, 16) << 16, scale, 0, Names.SPIKES, 0, 0, 24, 0, 0, Engine.xdim, Engine.ydim - 1);
            Main.game.getFont(4).drawText(x - Pragmas.mulscale(235L, scale, 16), y - Pragmas.mulscale(40L, scale, 16), Globals.tempchar, scale, 0, 0, BuildFont.TextAlign.Left, 0, false);
        } else if (Main.game.WH2) {
            int tilenum = 1917 + (plr.lvl - 1);
            int px = x - Pragmas.mulscale(314L, scale, 16);
            int py = y - Pragmas.mulscale(43L, scale, 16);
            Main.engine.rotatesprite(px << 16, py << 16, 2 * scale, 0, tilenum, 0, 0, 24, px + Pragmas.mulscale(4L, scale, 16), py + Pragmas.mulscale(4L, scale, 16), Engine.xdim, py + Pragmas.mulscale(20L, scale, 16));
        } else {
            int tilenum = Names.SPLAYERLVL + (plr.lvl - 1);
            Main.engine.rotatesprite(x - Pragmas.mulscale(313L, scale, 16) << 16, y - Pragmas.mulscale(43L, scale, 16) << 16, scale, 0, tilenum, 0, 0, 24, 0, 0, Engine.xdim, Engine.ydim - 1);
        }
    }

    public static void drawscore(PLAYER plr, int x, int y, int scale) {
        Strhandler.Bitoa(plr.score, scorebuf);
        Main.engine.rotatesprite(x - Pragmas.mulscale(Main.game.WH2 ? 314 : 313, scale, 16) << 16, y - Pragmas.mulscale(85L, scale, 16) << 16, scale, 0, Names.SSCOREBACKPIC, 0, 0, 24, 0, 0, Engine.xdim, Engine.ydim - 1);
        Main.game.getFont(4).drawText(x - Pragmas.mulscale(259L, scale, 16), y - Pragmas.mulscale(81L, scale, 16), scorebuf, scale, 0, 0, BuildFont.TextAlign.Left, 0, false);
    }

    public static void updatepics(PLAYER plr, int x, int y, int scale) {
        WHScreen.drawscore(plr, x, y, scale);
        if (Globals.netgame) {
            if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
                WHScreen.captureflagpic(scale);
            } else {
                WHScreen.fragspic(plr, scale);
            }
        } else {
            Potions.potionpic(plr, plr.currentpotion, x, y, scale);
        }
        WHScreen.levelpic(plr, x, y, scale);
        WHScreen.drawhealth(plr, x, y, scale);
        WHScreen.drawarmor(plr, x, y, scale);
        WHScreen.keyspic(plr, x, y, scale);
    }

    public static void captureflagpic(int scale) {
        WHScreen.overwritesprite(520, 387, Names.SPOTIONBACKPIC, 0, 0, 0);
        int i = 0;
        while (i < 4) {
            WHScreen.overwritesprite(((int)WHScreen.sflag[i].x << 1) + 6, (int)WHScreen.sflag[i].y + 8, Names.STHEFLAG, 0, 0, (int)WHScreen.sflag[i].z);
            ++i;
        }
    }

    public static void fragspic(PLAYER plr, int scale) {
        if (Main.whcfg.gViewSize == 320) {
            int x = Engine.windowx2 / 2 + 200;
            int y = Engine.windowy2 - 94;
            WHScreen.overwritesprite(x, y, Names.SPOTIONBACKPIC, 0, 0, 0);
            Main.game.getFont(2).drawText(x + 10, y + 10, Globals.tempchar, 0, 0, BuildFont.TextAlign.Left, 0, false);
        }
    }

    public static void keyspic(PLAYER plr, int x, int y, int scale) {
        y -= Pragmas.mulscale(85L, scale, 16);
        if (plr.treasure[14] == 1) {
            Main.engine.rotatesprite(x + Pragmas.mulscale(180L, scale, 16) << 16, y << 16, scale, 0, Names.SKEYBRASS, 0, 0, 8, 0, 0, Engine.xdim, Engine.ydim - 1);
        } else {
            Main.engine.rotatesprite(x + Pragmas.mulscale(180L, scale, 16) << 16, y << 16, scale, 0, Names.SKEYBLANK, 0, 0, 8, 0, 0, Engine.xdim, Engine.ydim - 1);
        }
        y += Pragmas.mulscale(22L, scale, 16);
        if (plr.treasure[15] == 1) {
            Main.engine.rotatesprite(x + Pragmas.mulscale(180L, scale, 16) << 16, y << 16, scale, 0, Names.SKEYBLACK, 0, 0, 8, 0, 0, Engine.xdim, Engine.ydim - 1);
        } else {
            Main.engine.rotatesprite(x + Pragmas.mulscale(180L, scale, 16) << 16, y << 16, scale, 0, Names.SKEYBLANK, 0, 0, 8, 0, 0, Engine.xdim, Engine.ydim - 1);
        }
        y += Pragmas.mulscale(22L, scale, 16);
        if (plr.treasure[16] == 1) {
            Main.engine.rotatesprite(x + Pragmas.mulscale(180L, scale, 16) << 16, y << 16, scale, 0, Names.SKEYGLASS, 0, 0, 8, 0, 0, Engine.xdim, Engine.ydim - 1);
        } else {
            Main.engine.rotatesprite(x + Pragmas.mulscale(180L, scale, 16) << 16, y << 16, scale, 0, Names.SKEYBLANK, 0, 0, 8, 0, 0, Engine.xdim, Engine.ydim - 1);
        }
        y += Pragmas.mulscale(22L, scale, 16);
        if (plr.treasure[17] == 1) {
            Main.engine.rotatesprite(x + Pragmas.mulscale(180L, scale, 16) << 16, y << 16, scale, 0, Names.SKEYIVORY, 0, 0, 8, 0, 0, Engine.xdim, Engine.ydim - 1);
        } else {
            Main.engine.rotatesprite(x + Pragmas.mulscale(180L, scale, 16) << 16, y << 16, scale, 0, Names.SKEYBLANK, 0, 0, 8, 0, 0, Engine.xdim, Engine.ydim - 1);
        }
    }

    public static void drawhealth(PLAYER plr, int x, int y, int scale) {
        Strhandler.Bitoa(plr.health, healthbuf);
        if (plr.poisoned == 1) {
            int flag = 0;
            switch (Engine.sintable[10 * Engine.totalclock & 0x7FF] / 4096) {
                case 0: {
                    flag = 0;
                    break;
                }
                case -1: 
                case 1: {
                    flag = 1;
                    break;
                }
                case -2: 
                case 2: {
                    flag = 33;
                    break;
                }
                default: {
                    Main.game.getFont(2).drawText(x - Pragmas.mulscale(167L, scale, 16), y - Pragmas.mulscale(70L, scale, 16), healthbuf, scale, 0, 0, BuildFont.TextAlign.Left, 0, false);
                    return;
                }
            }
            Main.engine.rotatesprite(x - Pragmas.mulscale(171L, scale, 16) << 16, y - Pragmas.mulscale(75L, scale, 16) << 16, scale, 0, Names.SHEALTHBACK, 0, 6, 0x18 | flag, Engine.windowx1, Engine.windowy1, Engine.windowx2, Engine.windowy2);
            Main.game.getFont(2).drawText(x - Pragmas.mulscale(167L, scale, 16), y - Pragmas.mulscale(70L, scale, 16), healthbuf, scale, 0, 0, BuildFont.TextAlign.Left, 0, false);
        } else {
            Main.engine.rotatesprite(x - Pragmas.mulscale(171L, scale, 16) << 16, y - Pragmas.mulscale(75L, scale, 16) << 16, scale, 0, Names.SHEALTHBACK, 0, 0, 24, 0, 0, Engine.xdim, Engine.ydim - 1);
            Main.game.getFont(2).drawText(x - Pragmas.mulscale(167L, scale, 16), y - Pragmas.mulscale(70L, scale, 16), healthbuf, scale, 0, 0, BuildFont.TextAlign.Left, 0, false);
        }
    }

    public static void drawarmor(PLAYER plr, int x, int y, int scale) {
        Strhandler.Bitoa(plr.armor, armorbuf);
        Main.engine.rotatesprite(x + Pragmas.mulscale(81L, scale, 16) << 16, y - Pragmas.mulscale(75L, scale, 16) << 16, scale, 0, Names.SHEALTHBACK, 0, 0, 24, 0, 0, Engine.xdim, Engine.ydim - 1);
        Main.game.getFont(2).drawText(x + Pragmas.mulscale(89L, scale, 16), y - Pragmas.mulscale(70L, scale, 16), armorbuf, scale, 0, 0, BuildFont.TextAlign.Left, 0, false);
    }

    public static void drawweapons(int snum) {
        int dapalnum;
        int dashade;
        PLAYER plr = WHPLR.player[snum];
        if (plr.shadowtime > 0 || plr.sector == -1) {
            dashade = 31;
            dapalnum = 0;
        } else {
            dashade = Engine.sector[plr.sector].ceilingshade;
            dapalnum = 0;
        }
        int dabits = plr.invisibletime > 0 ? 6 : 2;
        if (plr.currweaponflip == 1) {
            dabits = (char)(dabits | 8);
        }
        switch (plr.currweapon) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                dabits = (char)(dabits | 0x200);
            }
        }
        switch (plr.currweaponfired) {
            case 6: {
                int day;
                int dax;
                if (Main.game.WH2) {
                    if (plr.weapon[plr.currweapon] == 1 || plr.weapon[7] == 2) {
                        dax = Weapons.lefthandanimtics[plr.currweapon][plr.currweaponanim].currx;
                        day = Weapons.lefthandanimtics[plr.currweapon][plr.currweaponanim].curry + 8;
                    } else {
                        dax = Weapons.zlefthandanimtics[plr.currweapon][plr.currweaponanim].currx;
                        day = Weapons.zlefthandanimtics[plr.currweapon][plr.currweaponanim].curry + 8;
                    }
                } else {
                    dax = Weapons.lefthandanimtics[plr.currweapon][plr.currweaponanim].currx;
                    day = Weapons.lefthandanimtics[plr.currweapon][plr.currweaponanim].curry + 8;
                }
                dabits = (char)(dabits & 0xFFFFFDFF);
                if (plr.currweapon == 0 && plr.currweaponframe != 0) {
                    if (Weapons.dahand == 1) {
                        WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
                        break;
                    }
                    if (Weapons.dahand != 2) break;
                    dax = Weapons.lefthandanimtics[0][plr.currweaponanim].currx;
                    day = Weapons.lefthandanimtics[0][plr.currweaponanim].curry + 8;
                    WHScreen.overwritesprite(dax, day + 5, plr.currweaponframe + 6, dashade, dabits, dapalnum);
                    break;
                }
                if (plr.currweaponframe == 0) break;
                dax = Main.game.WH2 ? (plr.weapon[plr.currweapon] == 1 ? Weapons.lefthandanimtics[plr.currweapon][plr.currweaponanim].currx : Weapons.zlefthandanimtics[plr.currweapon][plr.currweaponanim].currx) : Weapons.lefthandanimtics[plr.currweapon][plr.currweaponanim].currx;
                WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
                break;
            }
            case 1: {
                int day;
                int dax;
                if (plr.currweaponattackstyle == 0) {
                    if (Main.game.WH2) {
                        if (plr.weapon[plr.currweapon] == 1 || plr.weapon[7] == 2) {
                            dax = Weapons.weaponanimtics[plr.currweapon][plr.currweaponanim].currx + 8;
                            day = Weapons.weaponanimtics[plr.currweapon][plr.currweaponanim].curry;
                        } else {
                            dax = Weapons.zweaponanimtics[plr.currweapon][plr.currweaponanim].currx + 8;
                            day = Weapons.zweaponanimtics[plr.currweapon][plr.currweaponanim].curry;
                        }
                    } else {
                        dax = Weapons.weaponanimtics[plr.currweapon][plr.currweaponanim].currx;
                        day = Weapons.weaponanimtics[plr.currweapon][plr.currweaponanim].curry + 4;
                    }
                } else if (Main.game.WH2) {
                    if (plr.weapon[plr.currweapon] == 1 || plr.weapon[7] == 2) {
                        dax = Weapons.weaponanimtics2[plr.currweapon][plr.currweaponanim].currx + 8;
                        day = Weapons.weaponanimtics2[plr.currweapon][plr.currweaponanim].curry;
                    } else {
                        dax = Weapons.zweaponanimtics2[plr.currweapon][plr.currweaponanim].currx + 8;
                        day = Weapons.zweaponanimtics2[plr.currweapon][plr.currweaponanim].curry;
                    }
                } else {
                    dax = Weapons.weaponanimtics2[plr.currweapon][plr.currweaponanim].currx;
                    day = Weapons.weaponanimtics2[plr.currweapon][plr.currweaponanim].curry + 4;
                }
                if (plr.currweapon == 0 && plr.currweaponframe != 0) {
                    if (Weapons.dahand == 1) {
                        WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
                        break;
                    }
                    if (Weapons.dahand != 2) break;
                    dax = Weapons.lefthandanimtics[0][plr.currweaponanim].currx;
                    day = Weapons.lefthandanimtics[0][plr.currweaponanim].curry + 8;
                    WHScreen.overwritesprite(dax, day + 5, plr.currweaponframe + 6, dashade, dabits, dapalnum);
                    break;
                }
                if (plr.currweaponframe == 0) break;
                dax = plr.currweaponattackstyle == 0 ? (Main.game.WH2 ? (plr.weapon[plr.currweapon] == 1 || plr.weapon[7] == 2 ? Weapons.weaponanimtics[plr.currweapon][plr.currweaponanim].currx : Weapons.zweaponanimtics[plr.currweapon][plr.currweaponanim].currx) : Weapons.weaponanimtics[plr.currweapon][plr.currweaponanim].currx) : (Main.game.WH2 ? (plr.weapon[plr.currweapon] == 1 || plr.weapon[7] == 2 ? Weapons.weaponanimtics2[plr.currweapon][plr.currweaponanim].currx : Weapons.zweaponanimtics2[plr.currweapon][plr.currweaponanim].currx) : Weapons.weaponanimtics2[plr.currweapon][plr.currweaponanim].currx);
                WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
                break;
            }
            case 0: {
                int dax;
                int day;
                if ((plr.pInput.fvel | plr.pInput.svel) != 0) {
                    if (plr.currweaponframe == Names.BOWREADYEND) {
                        if (Main.game.WH2) {
                            if (plr.weapon[plr.currweapon] == 1) {
                                day = Weapons.readyanimtics[plr.currweapon][6].curry + Weapons.snakey + 8;
                                dax = Weapons.readyanimtics[plr.currweapon][6].currx + Weapons.snakex + 8;
                            } else {
                                day = Weapons.zreadyanimtics[plr.currweapon][6].curry + Weapons.snakey + 8;
                                dax = Weapons.zreadyanimtics[plr.currweapon][6].currx + Weapons.snakex + 8;
                            }
                        } else {
                            day = Weapons.readyanimtics[plr.currweapon][6].curry + Weapons.snakey + 8;
                            dax = Weapons.readyanimtics[plr.currweapon][6].currx + Weapons.snakex + 8;
                        }
                    } else if (Main.game.WH2) {
                        if (plr.weapon[plr.currweapon] == 1 || plr.weapon[7] == 2) {
                            day = Weapons.weaponanimtics[plr.currweapon][0].curry + Weapons.snakey + 8;
                            dax = Weapons.weaponanimtics[plr.currweapon][0].currx + Weapons.snakex + 8;
                        } else {
                            day = Weapons.zweaponanimtics[plr.currweapon][0].curry + Weapons.snakey + 8;
                            dax = Weapons.zweaponanimtics[plr.currweapon][0].currx + Weapons.snakex + 8;
                        }
                    } else {
                        day = Weapons.weaponanimtics[plr.currweapon][0].curry + Weapons.snakey + 8;
                        dax = Weapons.weaponanimtics[plr.currweapon][0].currx + Weapons.snakex + 8;
                    }
                } else if (Main.game.WH2) {
                    if (plr.currweaponframe == Names.BOWREADYEND) {
                        if (plr.weapon[plr.currweapon] == 1) {
                            day = Weapons.readyanimtics[plr.currweapon][6].curry + 3;
                            dax = Weapons.readyanimtics[plr.currweapon][6].currx + 3;
                        } else {
                            day = Weapons.zreadyanimtics[plr.currweapon][6].curry + 3;
                            dax = Weapons.zreadyanimtics[plr.currweapon][6].currx + 3;
                        }
                    } else if (plr.weapon[plr.currweapon] == 1 || plr.weapon[7] == 2) {
                        dax = Weapons.weaponanimtics[plr.currweapon][0].currx + 3;
                        day = Weapons.weaponanimtics[plr.currweapon][0].curry + 3;
                    } else {
                        dax = Weapons.zweaponanimtics[plr.currweapon][0].currx + 3;
                        day = Weapons.zweaponanimtics[plr.currweapon][0].curry + 3;
                    }
                } else if (plr.currweaponframe == Names.BOWREADYEND) {
                    day = Weapons.readyanimtics[plr.currweapon][6].curry + 3;
                    dax = Weapons.readyanimtics[plr.currweapon][6].currx + 3;
                } else {
                    dax = Weapons.weaponanimtics[plr.currweapon][0].currx + 3;
                    day = Weapons.weaponanimtics[plr.currweapon][0].curry + 3;
                }
                if (plr.currweapon == 0 && plr.currweaponframe != 0) {
                    WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
                    WHScreen.overwritesprite(0, day + 8, plr.currweaponframe + 6, dashade, dabits, dapalnum);
                    break;
                }
                if (plr.currweaponframe == 0) break;
                WHScreen.overwritesprite(dax + Weapons.snakex, day, plr.currweaponframe, dashade, dabits, dapalnum);
                break;
            }
            case 2: {
                int dax;
                int day;
                if (Main.game.WH2) {
                    if (plr.currweaponframe == Names.BOWREADYEND) {
                        day = Weapons.readyanimtics[plr.currweapon][6].curry + Weapons.weapondrop;
                        dax = Weapons.readyanimtics[plr.currweapon][6].currx;
                    } else if (plr.currweaponframe == 3776) {
                        day = Weapons.zreadyanimtics[plr.currweapon][6].curry + Weapons.weapondrop;
                        dax = Weapons.zreadyanimtics[plr.currweapon][6].currx;
                    } else if (plr.weapon[plr.currweapon] == 1 || plr.weapon[7] == 2) {
                        dax = Weapons.weaponanimtics[plr.currweapon][0].currx;
                        day = Weapons.weaponanimtics[plr.currweapon][0].curry + Weapons.weapondrop;
                    } else {
                        dax = Weapons.zweaponanimtics[plr.currweapon][0].currx;
                        day = Weapons.zweaponanimtics[plr.currweapon][0].curry + Weapons.weapondrop;
                    }
                } else if (plr.currweaponframe == Names.BOWREADYEND) {
                    day = Weapons.readyanimtics[plr.currweapon][6].curry + Weapons.weapondrop;
                    dax = Weapons.readyanimtics[plr.currweapon][6].currx;
                } else {
                    dax = Weapons.weaponanimtics[plr.currweapon][0].currx;
                    day = Weapons.weaponanimtics[plr.currweapon][0].curry + Weapons.weapondrop;
                }
                if (plr.currweapon == 0 && plr.currweaponframe != 0) {
                    WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
                    WHScreen.overwritesprite(0, day, plr.currweaponframe + 6, dashade, dabits, dapalnum);
                    break;
                }
                if (plr.currweaponframe == 0) break;
                dax = Weapons.weaponanimtics[plr.currweapon][0].currx;
                WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
                break;
            }
            case 3: {
                int day;
                int dax;
                if (Main.game.WH2) {
                    if (plr.weapon[plr.currweapon] == 1 || plr.weapon[7] == 2) {
                        dax = Weapons.readyanimtics[plr.currweapon][plr.currweaponanim].currx;
                        day = Weapons.readyanimtics[plr.currweapon][plr.currweaponanim].curry + 8;
                    } else {
                        dax = Weapons.zreadyanimtics[plr.currweapon][plr.currweaponanim].currx;
                        day = Weapons.zreadyanimtics[plr.currweapon][plr.currweaponanim].curry + 8;
                    }
                } else {
                    dax = Weapons.readyanimtics[plr.currweapon][plr.currweaponanim].currx;
                    day = Weapons.readyanimtics[plr.currweapon][plr.currweaponanim].curry + 8;
                }
                if (plr.currweapon == 0 && plr.currweaponframe != 0) {
                    WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
                    WHScreen.overwritesprite(0, day, plr.currweaponframe + 6, dashade, dabits, dapalnum);
                    break;
                }
                if (plr.currweaponframe == 0) break;
                WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
                break;
            }
            case 5: {
                int day;
                int dax;
                if (Main.game.WH2) {
                    if (plr.weapon[plr.currweapon] == 1 || plr.weapon[7] == 2) {
                        dax = Weapons.cockanimtics[plr.currweaponanim].currx;
                        day = Weapons.cockanimtics[plr.currweaponanim].curry + 8;
                    } else if (plr.weapon[plr.currweapon] == 3) {
                        dax = Weapons.zcockanimtics[plr.currweaponanim].currx;
                        day = Weapons.zcockanimtics[plr.currweaponanim].curry + 8;
                    } else {
                        dax = Weapons.zcockanimtics[plr.currweaponanim].currx;
                        day = Weapons.zcockanimtics[plr.currweaponanim].curry + 8;
                    }
                } else {
                    dax = Weapons.cockanimtics[plr.currweaponanim].currx;
                    day = Weapons.cockanimtics[plr.currweaponanim].curry + 8;
                }
                if (plr.currweaponframe == 0) break;
                WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
                break;
            }
            case 4: {
                int day;
                int dax;
                if (Main.game.WH2) {
                    dax = Weapons.wh2throwanimtics[plr.currentorb][plr.currweaponanim].currx;
                    day = Weapons.wh2throwanimtics[plr.currentorb][plr.currweaponanim].curry + 8;
                } else {
                    dax = Weapons.throwanimtics[plr.currentorb][plr.currweaponanim].currx;
                    day = Weapons.throwanimtics[plr.currentorb][plr.currweaponanim].curry + 8;
                }
                if (plr.currweaponframe == 0) break;
                WHScreen.overwritesprite(dax, day, plr.currweaponframe, dashade, dabits, dapalnum);
            }
        }
        if (plr.shieldpoints > 0 && (plr.currweaponfired == 0 || plr.currweaponfired == 1) && plr.selectedgun > 0 && plr.selectedgun < 5) {
            if (plr.shieldtype == 1) {
                if (plr.shieldpoints > 75) {
                    WHScreen.overwritesprite(-40 + Weapons.snakex, 100 + Weapons.snakey, Names.GRONSHIELD, dashade, dabits, dapalnum);
                } else if (plr.shieldpoints > 50 && plr.shieldpoints < 76) {
                    WHScreen.overwritesprite(-40 + Weapons.snakex, 100 + Weapons.snakey, Names.GRONSHIELD + 1, dashade, dabits, dapalnum);
                } else if (plr.shieldpoints > 25 && plr.shieldpoints < 51) {
                    WHScreen.overwritesprite(-40 + Weapons.snakex, 100 + Weapons.snakey, Names.GRONSHIELD + 2, dashade, dabits, dapalnum);
                } else {
                    WHScreen.overwritesprite(-40 + Weapons.snakex, 100 + Weapons.snakey, Names.GRONSHIELD + 3, dashade, dabits, dapalnum);
                }
            } else if (plr.shieldpoints > 150) {
                WHScreen.overwritesprite(-40 + Weapons.snakex, 100 + Weapons.snakey, 3961, dashade, dabits, dapalnum);
            } else if (plr.shieldpoints > 100 && plr.shieldpoints < 151) {
                WHScreen.overwritesprite(-40 + Weapons.snakex, 100 + Weapons.snakey, 3962, dashade, dabits, dapalnum);
            } else if (plr.shieldpoints > 50 && plr.shieldpoints < 101) {
                WHScreen.overwritesprite(-40 + Weapons.snakex, 100 + Weapons.snakey, 3963, dashade, dabits, dapalnum);
            } else {
                WHScreen.overwritesprite(-40 + Weapons.snakex, 100 + Weapons.snakey, 3964, dashade, dabits, dapalnum);
            }
        }
    }

    public static void analizesprites(PLAYER plr, int dasmoothratio) {
        tspritelistcnt = Engine.spritesortcnt;
        int i = Engine.spritesortcnt - 1;
        while (i >= 0) {
            Interpolation.ILoc oldLoc;
            SPRITE tspr = Engine.tsprite[i];
            if (tspritelist[i] == null) {
                WHScreen.tspritelist[i] = new SPRITE();
            }
            tspritelist[i].set(tspr);
            if (plr.nightglowtime <= 0 && tspr.detail != 0 && tspr.detail < 23 && (tspr.detail != 8 && tspr.picnum != 3540 || tspr.shade != 31) && tspr.statnum != 161) {
                tspr.shade = Engine.sector[tspr.sectnum].floorshade;
            }
            if ((oldLoc = Main.game.pInt.getsprinterpolate(tspr.owner)) != null && (tspr.hitag & 0x200) == 0) {
                int x = oldLoc.x;
                int y = oldLoc.y;
                int z = oldLoc.z;
                short nAngle = oldLoc.ang;
                nAngle = (short)(nAngle + Pragmas.mulscale((tspr.ang - oldLoc.ang + 1024 & 0x7FF) - 1024, dasmoothratio, 16));
                tspr.x = x += Pragmas.mulscale(tspr.x - oldLoc.x, dasmoothratio, 16);
                tspr.y = y += Pragmas.mulscale(tspr.y - oldLoc.y, dasmoothratio, 16);
                tspr.z = z += Pragmas.mulscale(tspr.z - oldLoc.z, dasmoothratio, 16);
                tspr.ang = nAngle;
            }
            block0 : switch (Engine.sprite[tspr.owner].detail) {
                case 9: {
                    int k;
                    if (tspr.picnum == Names.GRONHAL || tspr.picnum == Names.GRONSW || tspr.picnum == Names.GRONSWATTACK || tspr.picnum == Names.GRONMU) {
                        k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                        if ((k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7) <= 4) {
                            tspr.picnum = (short)(tspr.picnum + (k << 2));
                            tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                            break;
                        }
                        tspr.picnum = (short)(tspr.picnum + (8 - k << 2));
                        tspr.cstat = (short)(tspr.cstat | 4);
                        break;
                    }
                    switch (tspr.picnum) {
                        case 2601: 
                        case 2603: {
                            if (tspr.picnum != Names.GRONMUATTACK) break block0;
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            if ((k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7) <= 4) {
                                tspr.picnum = (short)(tspr.picnum + k * 6);
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k) * 6);
                            tspr.cstat = (short)(tspr.cstat | 4);
                            break;
                        }
                        case 2502: 
                        case 2504: {
                            if (tspr.picnum != Names.GRONHALATTACK) break block0;
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            if ((k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7) <= 4) {
                                tspr.picnum = (short)(tspr.picnum + k * 7);
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k) * 7);
                            tspr.cstat = (short)(tspr.cstat | 4);
                        }
                    }
                    break;
                }
                case 7: {
                    int k;
                    if (Main.game.WH2) break;
                    switch (tspr.picnum) {
                        case 917: 
                        case 922: 
                        case 952: {
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
                            if (k <= 4) {
                                tspr.picnum = (short)(tspr.picnum + (k << 2));
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k << 2));
                            tspr.cstat = (short)(tspr.cstat | 4);
                        }
                    }
                    break;
                }
                case 11: {
                    if (!Main.game.WH2) break;
                    int k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                    k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
                    if (tspr.picnum != 922) break;
                    if (k <= 4) {
                        tspr.picnum = (short)(tspr.picnum + k * 6);
                        tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                        break;
                    }
                    tspr.picnum = (short)(tspr.picnum + (8 - k) * 6);
                    tspr.cstat = (short)(tspr.cstat | 4);
                    break;
                }
                default: {
                    short siz;
                    int fz;
                    int k;
                    switch (tspr.picnum) {
                        case 294: 
                        case 649: 
                        case 656: 
                        case 660: 
                        case 663: 
                        case 664: 
                        case 2426: 
                        case 2427: {
                            if (tspr.picnum == 2427 && Main.game.WH2 || tspr.picnum == 2426 && !Main.game.WH2) break;
                            tspr.shade = (byte)-128;
                            break;
                        }
                        case 772: 
                        case 777: 
                        case 797: 
                        case 821: 
                        case 866: 
                        case 871: 
                        case 891: 
                        case 981: 
                        case 1001: 
                        case 1028: 
                        case 1123: {
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
                            if (k <= 4) {
                                tspr.picnum = (short)(tspr.picnum + (k << 2));
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k << 2));
                            tspr.cstat = (short)(tspr.cstat | 4);
                            break;
                        }
                        case 2155: 
                        case 2180: {
                            if (!Main.game.WH2) break;
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            if ((k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7) <= 4) {
                                tspr.picnum = (short)(tspr.picnum + k * 6);
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k) * 6);
                            tspr.cstat = (short)(tspr.cstat | 4);
                            break;
                        }
                        case 737: 
                        case 2156: 
                        case 2181: 
                        case 3110: {
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
                            if (k <= 4) {
                                tspr.picnum = (short)(tspr.picnum + k * 5);
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k) * 5);
                            tspr.cstat = (short)(tspr.cstat | 4);
                            break;
                        }
                        case 3541: 
                        case 3566: {
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
                            if (k <= 4) {
                                tspr.picnum = (short)(tspr.picnum + k * 5);
                                tspr.cstat = (short)(tspr.cstat | 4);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k) * 5);
                            tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                            break;
                        }
                        case 2750: 
                        case 3017: 
                        case 3047: 
                        case 3170: 
                        case 3200: {
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
                            if (k <= 4) {
                                tspr.picnum = (short)(tspr.picnum + k * 6);
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k) * 6);
                            tspr.cstat = (short)(tspr.cstat | 4);
                            break;
                        }
                        case 3279: 
                        case 3352: {
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
                            if (k <= 4) {
                                tspr.picnum = (short)(tspr.picnum + k * 6);
                                tspr.cstat = (short)(tspr.cstat | 4);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k) * 6);
                            tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                            break;
                        }
                        case 3426: {
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
                            tspr.picnum = (short)(tspr.picnum + k * 6);
                            tspr.cstat = (short)(tspr.cstat | 4);
                            break;
                        }
                        case 2780: 
                        case 3140: 
                        case 3602: {
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
                            if (k <= 4) {
                                tspr.picnum = (short)(tspr.picnum + k * 3);
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k) * 3);
                            tspr.cstat = (short)(tspr.cstat | 4);
                            break;
                        }
                        case 1961: 
                        case 1962: {
                            if (tspr.picnum == 1962 && Main.game.WH2 || tspr.picnum == 1961 && !Main.game.WH2) break;
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            if ((k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7) <= 4) {
                                tspr.picnum = (short)(tspr.picnum + k * 2);
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k) * 2);
                            tspr.cstat = (short)(tspr.cstat | 4);
                            break;
                        }
                        case 1070: {
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
                            if (k <= 4) {
                                tspr.picnum = (short)(tspr.picnum + (k << 3));
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k << 3));
                            tspr.cstat = (short)(tspr.cstat | 4);
                            break;
                        }
                        case 1993: 
                        case 1994: 
                        case 3090: 
                        case 3095: 
                        case 3243: 
                        case 3248: {
                            if (tspr.picnum == 1994 && Main.game.WH2 || tspr.picnum == 1993 && !Main.game.WH2) break;
                            k = Main.engine.getangle(tspr.x - plr.x, tspr.y - plr.y);
                            if ((k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7) <= 4) {
                                tspr.picnum = (short)(tspr.picnum + k);
                                tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                                break;
                            }
                            tspr.picnum = (short)(tspr.picnum + (8 - k));
                            tspr.cstat = (short)(tspr.cstat | 4);
                            break;
                        }
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 260: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 373: 
                        case 548: 
                        case 549: 
                        case 550: 
                        case 551: 
                        case 552: 
                        case 666: 
                        case 670: 
                        case 694: 
                        case 698: 
                        case 706: 
                        case 714: 
                        case 718: 
                        case 722: 
                        case 726: 
                        case 730: 
                        case 2432: 
                        case 2439: 
                        case 2446: {
                            tspr.shade = (byte)(tspr.shade - 16);
                            break;
                        }
                        default: {
                            short p = tspr.picnum;
                            if (p != Names.CRYSTALSTAFF && p != Names.AMULETOFTHEMIST && p != Names.HORNEDSKULL && p != Names.THEHORN && p != Names.HELMET && p != Names.PLATEARMOR && p != Names.CHAINMAIL && p != Names.LEATHERARMOR && p != Names.BRASSKEY && p != Names.BLACKKEY && p != Names.GLASSKEY && p != Names.IVORYKEY && p != Names.SCROLLSCARE && p != Names.SCROLLNIGHT && p != Names.SCROLLFREEZE && p != Names.SCROLLMAGIC && p != Names.SCROLLOPEN && p != Names.SCROLLFLY && p != Names.SCROLLFIREBALL && p != Names.SCROLLNUKE && p != Names.QUIVER && p != Names.BOW && p != Names.WEAPON1 && p != Names.WEAPON1A && p != Names.GOBWEAPON && p != Names.WEAPON2 && p != Names.WEAPON4 && p != Names.THROWHALBERD && p != Names.WEAPON5 && p != Names.SHIELD && p != Names.WEAPON5B && p != Names.THROWPIKE && p != Names.WEAPON6 && p != Names.WEAPON7 && p != Names.PENTAGRAM) break;
                            tspr.shade = (byte)(tspr.shade - 16);
                            if (p != Names.PENTAGRAM || Engine.sector[tspr.sectnum].lotag != 4002 || plr.treasure[8] != 0) break;
                            tspr.cstat = (short)(tspr.cstat | 0x202);
                        }
                    }
                    if (tspr.detail == 0 || tspr.statnum == 99 || (tspr.detail & 0xFF) == 157 || Engine.spritesortcnt >= 1022 || (fz = Main.engine.getflorzofslope(tspr.sectnum, tspr.x, tspr.y)) <= plr.z || (siz = (short)Math.max(tspr.xrepeat - (fz - tspr.z >> 10), 1)) <= 4) break;
                    if (Engine.tsprite[Engine.spritesortcnt] == null) {
                        Engine.tsprite[Engine.spritesortcnt] = new SPRITE();
                    }
                    SPRITE tshadow = Engine.tsprite[Engine.spritesortcnt];
                    tshadow.set(tspr);
                    short camangle = Main.engine.getangle(plr.x - tshadow.x, plr.y - tshadow.y);
                    tshadow.x -= Pragmas.mulscale(Engine.sintable[camangle + 512 & 0x7FF], 100L, 16);
                    tshadow.y += Pragmas.mulscale(Engine.sintable[camangle + 1024 & 0x7FF], 100L, 16);
                    tshadow.z = fz + 1;
                    tshadow.statnum = (short)99;
                    tshadow.xrepeat = siz;
                    tshadow.yrepeat = (short)(tspr.yrepeat >> 3);
                    if (tshadow.yrepeat < 4) {
                        tshadow.yrepeat = (short)4;
                    }
                    tshadow.shade = (byte)127;
                    tshadow.cstat = (short)(tshadow.cstat | 2);
                    ++Engine.spritesortcnt;
                }
            }
            --i;
        }
    }

    public static void drawInterface(PLAYER plr) {
        boolean message;
        int hudscale = Main.whcfg.gHudScale;
        if (Main.whcfg.gViewSize == 1) {
            WHScreen.drawhud(plr, Engine.windowx2 / 2, Engine.windowy2 + 1, hudscale);
        }
        if (plr.potion[0] == 0 && plr.health > 0 && plr.health < 21) {
            Main.game.getFont(1).drawText(160, 5, Strhandler.toCharArray("health critical"), 0, 7, BuildFont.TextAlign.Center, 2, false);
        }
        if (WHFX.justwarpedfx > 0) {
            Main.engine.rotatesprite(0xA00000, 0x640000, WHOBJ.justwarpedcnt << 9, 0, 650, 0, 0, 3, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        int pwpos = 0;
        if (plr.helmettime > 0) {
            Main.engine.rotatesprite(19660800, (pwpos += Main.engine.getTile(Names.HELMET).getHeight() >> 2) << 16, 16384, 0, Names.HELMET, 0, 0, 522, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            pwpos += 10;
        }
        if (plr.vampiretime > 0) {
            Main.engine.rotatesprite(19660800, (pwpos += Main.engine.getTile(Names.THEHORN).getHeight() / 6) << 16, 12000, 0, Names.THEHORN, 0, 0, 522, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            pwpos += 10;
        }
        if (plr.orbactive[5] > 0) {
            Main.engine.rotatesprite(19660800, (pwpos += Main.engine.getTile(Names.SCROLLFLY).getHeight() >> 2) << 16, 16384, 0, Names.SCROLLFLY, 0, 0, 522, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            pwpos += 10;
        }
        if (plr.shadowtime > 0) {
            Main.engine.rotatesprite(19660800, (pwpos += Main.engine.getTile(Names.SCROLLSCARE).getHeight() >> 2) << 16, 16384, 0, Names.SCROLLSCARE, 0, 0, 522, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            pwpos += 10;
        }
        if (plr.nightglowtime > 0) {
            Main.engine.rotatesprite(19660800, (pwpos += Main.engine.getTile(Names.SCROLLNIGHT).getHeight() >> 2) << 16, 16384, 0, Names.SCROLLNIGHT, 0, 0, 522, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            pwpos += 10;
        }
        boolean bl = message = Main.whcfg.MessageState && displaytime > 0;
        if (message) {
            Main.game.getFont(1).drawText(5, 5, displaybuf, 0, 7, BuildFont.TextAlign.Left, 258, false);
        }
        int amposx = 10;
        int amposy = 7;
        if (message) {
            amposy += 15;
            if (Globals.dimension == 2) {
                amposy += 10;
            }
            if (Globals.dimension == 2 && Globals.followmode) {
                amposy += 10;
            }
        }
        if (plr.treasure[7] != 0) {
            Main.engine.rotatesprite(amposx << 16, amposy << 16, 16384, 0, 730, 0, 0, 266, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            amposx += 20;
        }
        if (plr.treasure[10] != 0 && plr.invisibletime > 0) {
            Main.engine.rotatesprite(amposx << 16, amposy << 16, 16384, 0, Names.AMULETOFTHEMIST, 0, 0, 266, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            amposx += 20;
        }
        if (plr.treasure[6] != 0) {
            Main.engine.rotatesprite(amposx << 16, amposy << 16, 16384, 0, 726, 0, 0, 266, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            amposx += 20;
        }
        if (plr.treasure[4] != 0) {
            Main.engine.rotatesprite(amposx << 16, amposy + 9 << 16, 16384, 0, 718, 0, 0, 266, 0, 0, Engine.xdim - 1, Gameutils.coordsConvertYScaled(amposy + 4));
            amposx += 20;
        }
        if (plr.treasure[5] != 0) {
            Main.engine.rotatesprite(amposx << 16, amposy + 9 << 16, 16384, 0, 722, 0, 0, 266, 0, 0, Engine.xdim - 1, Gameutils.coordsConvertYScaled(amposy + 4));
            amposx += 20;
        }
        if (Main.whcfg.gCrosshair) {
            int col = 17;
            Main.engine.getrender().drawline256(Engine.xdim - Pragmas.mulscale(Main.whcfg.gCrossSize, 16L, 16) << 11, Engine.ydim << 11, Engine.xdim - Pragmas.mulscale(Main.whcfg.gCrossSize, 4L, 16) << 11, Engine.ydim << 11, col);
            Main.engine.getrender().drawline256(Engine.xdim + Pragmas.mulscale(Main.whcfg.gCrossSize, 4L, 16) << 11, Engine.ydim << 11, Engine.xdim + Pragmas.mulscale(Main.whcfg.gCrossSize, 16L, 16) << 11, Engine.ydim << 11, col);
            Main.engine.getrender().drawline256(Engine.xdim << 11, Engine.ydim - Pragmas.mulscale(Main.whcfg.gCrossSize, 16L, 16) << 11, Engine.xdim << 11, Engine.ydim - Pragmas.mulscale(Main.whcfg.gCrossSize, 4L, 16) << 11, col);
            Main.engine.getrender().drawline256(Engine.xdim << 11, Engine.ydim + Pragmas.mulscale(Main.whcfg.gCrossSize, 4L, 16) << 11, Engine.xdim << 11, Engine.ydim + Pragmas.mulscale(Main.whcfg.gCrossSize, 16L, 16) << 11, col);
        }
        if (plr.spiked != 0) {
            WHScreen.spikeanimation(plr);
        }
        int y = Engine.windowy2 - 20;
        if (Main.whcfg.gViewSize == 1) {
            y -= Pragmas.mulscale(Main.engine.getTile(Names.SSTATUSBAR).getHeight(), hudscale, 16);
        }
        if (Main.whcfg.gShowStat == 1 || Main.whcfg.gShowStat == 2 && Globals.dimension == 2) {
            WHScreen.drawStatistics(10, y, Main.whcfg.gStatSize);
        }
        if (Main.game.gPaused) {
            Main.game.getFont(0).drawText(160, 5, Strhandler.toCharArray("Pause"), 0, 0, BuildFont.TextAlign.Center, 2, true);
        }
    }

    public static void drawStatistics(int x, int y, int zoom) {
        float viewzoom = (float)zoom / 65536.0f;
        BuildFont font = Main.game.getFont(1);
        Strhandler.buildString(buffer, 0, "kills: ");
        int yoffset = (int)((float)(4 * font.getHeight()) * viewzoom);
        int statx = x;
        int staty = y -= yoffset;
        font.drawText(statx, staty, buffer, zoom, 0, 7, BuildFont.TextAlign.Left, 256, false);
        int alignx = font.getWidth(buffer, zoom);
        int offs = Strhandler.Bitoa(Globals.kills, buffer);
        offs = Strhandler.buildString(buffer, offs, " / ", Globals.killcnt);
        font.drawText(statx += alignx + 2, staty, buffer, zoom, 0, 0, BuildFont.TextAlign.Left, 256, false);
        statx = x;
        staty = y + (int)(15.0f * viewzoom);
        Strhandler.buildString(buffer, 0, "treasures: ");
        font.drawText(statx, staty, buffer, zoom, 0, 7, BuildFont.TextAlign.Left, 256, false);
        alignx = font.getWidth(buffer, zoom);
        offs = Strhandler.Bitoa(Globals.treasuresfound, buffer, 2);
        offs = Strhandler.buildString(buffer, offs, " / ", Globals.treasurescnt, 2);
        font.drawText(statx += alignx + 2, staty, buffer, zoom, 0, 0, BuildFont.TextAlign.Left, 256, false);
        statx = x;
        staty = y + (int)(30.0f * viewzoom);
        Strhandler.buildString(buffer, 0, "time: ");
        font.drawText(statx, staty, buffer, zoom, 0, 7, BuildFont.TextAlign.Left, 256, false);
        alignx = font.getWidth(buffer, zoom);
        offs = Strhandler.Bitoa(Globals.minutes, buffer, 2);
        offs = Strhandler.buildString(buffer, offs, " : ", Globals.seconds, 2);
        font.drawText(statx += alignx + 2, staty, buffer, zoom, 0, 0, BuildFont.TextAlign.Left, 256, false);
    }

    public static void drawhud(PLAYER plr, int x, int y, int scale) {
        Main.engine.rotatesprite(x << 16, (y << 16) - Main.engine.getTile(Names.SSTATUSBAR).getHeight() * scale / 2, scale, 0, Names.SSTATUSBAR, 0, 0, 8, 0, 0, Engine.xdim, Engine.ydim - 1);
        WHScreen.updatepics(plr, x, y, scale);
        int bookpic = plr.spellbook;
        if (plr.spellbookflip == 0) {
            bookpic = 8;
        }
        if (bookpic < Spellbooks.sspellbookanim[plr.currentorb].length && (plr.orbammo[plr.currentorb] > 0 || plr.currweaponfired == 4)) {
            plr.spellbookframe = Spellbooks.sspellbookanim[plr.currentorb][bookpic].daweaponframe;
            int dax = x + Pragmas.mulscale(Spellbooks.sspellbookanim[plr.currentorb][bookpic].currx, scale, 16);
            int day = y + Pragmas.mulscale(Spellbooks.sspellbookanim[plr.currentorb][bookpic].curry, scale, 16);
            Main.engine.rotatesprite(dax << 16, day << 16, scale, 0, plr.spellbookframe, 0, 0, 24, 0, 0, Engine.xdim, Engine.ydim - 1);
            Strhandler.Bitoa(plr.orbammo[plr.currentorb], Globals.tempchar);
            Main.game.getFont(4).drawText(x - Pragmas.mulscale(67L, scale, 16), y - Pragmas.mulscale(39L, scale, 16), Globals.tempchar, scale, 0, 0, BuildFont.TextAlign.Left, 0, false);
        }
    }

    public static int coordsConvertXScaled(int coord, int bits) {
        int oxdim = Engine.xdim;
        int xdim = 4 * Engine.ydim / 3;
        int offset = oxdim - xdim;
        int normxofs = coord - 0xA00000;
        int wx = (xdim << 15) + Pragmas.scale(normxofs, xdim, 320L);
        wx += (oxdim - xdim) / 2;
        if ((bits & 0x100) == 256) {
            return wx - offset / 2 - 1;
        }
        if ((bits & 0x200) == 512) {
            return wx + offset / 2 - 1;
        }
        return wx - 1;
    }

    public static int coordsConvertYScaled(int coord) {
        int ydim = 3 * Engine.xdim / 4;
        int buildim = 200 * ydim / Engine.ydim;
        int normxofs = coord - (buildim << 15);
        int wy = (ydim << 15) + Pragmas.scale(normxofs, ydim, buildim);
        return wy;
    }
}

