/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AIPOD {
    public static final int kSlopeThrow = -14500;
    public static AISTATE podIdle;
    public static AISTATE podSearch;
    public static AISTATE podChase;
    public static AISTATE podRecoil;
    public static AISTATE podGoto;
    public static AISTATE podHack;
    public static AISTATE tentacleIdle;
    public static AISTATE tentacleSearch;
    public static AISTATE tentacleChase;
    public static AISTATE tentacleRecoil;
    public static AISTATE tentacleDown;
    public static AISTATE tentacleHack;

    public static void Init() {
        podIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIPOD.podSearch.next = podSearch = new AISTATE(AISTATEFUNC.Type.search, 0, null, 3600, false, true, true, podSearch){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIPOD.thinkSearch(sprite, xsprite);
            }
        };
        podGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 7, null, 3600, false, true, true, podSearch){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIPOD.thinkGoto(sprite, xsprite);
            }
        };
        podChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIPOD.thinkChase(sprite, xsprite);
            }
        };
        podHack = new AISTATE(AISTATEFUNC.Type.other, 8, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIPOD.pHackCallback(nXSprite);
            }
        }, 600, false, false, false, podChase);
        podRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, podChase);
        tentacleIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        tentacleSearch = new AISTATE(AISTATEFUNC.Type.search, 0, null, 3600, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIPOD.thinkSearch(sprite, xsprite);
            }
        };
        tentacleDown = new AISTATE(AISTATEFUNC.Type.other, 8, null, 3600, false, true, true, tentacleSearch){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIPOD.thinkGoto(sprite, xsprite);
            }
        };
        tentacleChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIPOD.thinkChase(sprite, xsprite);
            }
        };
        tentacleHack = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIPOD.tHackCallback(nXSprite);
            }
        }, 120, false, false, false, tentacleChase);
        tentacleRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, tentacleChase);
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            switch (pSprite.lotag) {
                case 221: 
                case 223: {
                    Ai.aiNewState(pSprite, pXSprite, podSearch);
                    break;
                }
                case 222: 
                case 224: {
                    Ai.aiNewState(pSprite, pXSprite, tentacleSearch);
                }
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        if (pXSprite.target == -1) {
            switch (pSprite.lotag) {
                case 221: 
                case 223: {
                    Ai.aiNewState(pSprite, pXSprite, podGoto);
                    break;
                }
                case 222: 
                case 224: {
                    Ai.aiNewState(pSprite, pXSprite, tentacleDown);
                }
            }
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            switch (pSprite.lotag) {
                case 221: 
                case 223: {
                    Ai.aiNewState(pSprite, pXSprite, podSearch);
                    break;
                }
                case 222: 
                case 224: {
                    Ai.aiNewState(pSprite, pXSprite, tentacleSearch);
                }
            }
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum) && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                if (Pragmas.klabs(losAngle) < 85 && pTarget.lotag != 221 && pTarget.lotag != 223) {
                    switch (pSprite.lotag) {
                        case 221: 
                        case 223: {
                            Ai.aiNewState(pSprite, pXSprite, podHack);
                            break;
                        }
                        case 222: 
                        case 224: {
                            Ai.aiNewState(pSprite, pXSprite, tentacleHack);
                        }
                    }
                }
                return;
            }
        }
        switch (pSprite.lotag) {
            case 221: 
            case 223: {
                Ai.aiNewState(pSprite, pXSprite, podGoto);
                break;
            }
            case 222: 
            case 224: {
                Ai.aiNewState(pSprite, pXSprite, tentacleDown);
            }
        }
        pXSprite.target = -1;
    }

    private static void tHackCallback(int nXSprite) {
        int nBurnTime;
        int nDistance;
        int nDamageType;
        int nSprite = DB.xsprite[nXSprite].reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        SOUND.sfxStart3DSound(pSprite, 2502, -1, 0);
        int nDamageHit = 5 * Globals.pGameInfo.nDifficulty + 5;
        if (pSprite.lotag == 222) {
            nDamageType = 2;
            nDistance = 50;
            nBurnTime = 0;
        } else {
            nDamageType = 3;
            nDistance = 75;
            nBurnTime = 120 * Globals.pGameInfo.nDifficulty;
        }
        Actor.actDistanceDamage(nSprite, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, nDistance, 1, nDamageType, nDamageHit, 2, nBurnTime);
    }

    private static void pHackCallback(int nXSprite) {
        XSPRITE pXSprite = DB.xsprite[nXSprite];
        SPRITE pSprite = Engine.sprite[pXSprite.reference];
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        int nTarget = pXSprite.target;
        SPRITE pTarget = Engine.sprite[nTarget];
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        int dz = pTarget.z - pSprite.z;
        dz += 8000;
        int dist = (int)Main.engine.qdist(dx += Gameutils.BiRandom(1000), dy += Gameutils.BiRandom(1000));
        if (dist > pDudeInfo.seeDist / 10) {
            int nSlope = dz / 128 + -14500;
            SPRITE pThing = null;
            int velocity = Pragmas.divscale(dist / 540, 120L, 23);
            switch (pSprite.lotag) {
                case 221: {
                    if (Gameutils.Chance(16384)) {
                        SOUND.sfxStart3DSound(pSprite, 2474, -1, 0);
                    } else {
                        SOUND.sfxStart3DSound(pSprite, 2475, -1, 0);
                    }
                    pThing = Actor.actFireThing(pSprite.xvel, 0, -8000, nSlope, 430, velocity);
                    if (pThing == null) break;
                    SeqHandling.seqSpawn(68, 3, pThing.extra, null);
                    break;
                }
                case 223: {
                    SOUND.sfxStart3DSound(pSprite, 2454, -1, 0);
                    pThing = Actor.actFireThing(pSprite.xvel, 0, -8000, nSlope, 429, velocity);
                    if (pThing == null) break;
                    SeqHandling.seqSpawn(22, 3, pThing.extra, null);
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            Actor.actSpawnTentacleBlood(pSprite);
        }
    }
}

