/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.GeneticDude;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Gib;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AxeZombie
extends GeneticDude {
    private static final int kAxeZombieMeleeDist = Gameutils.M2X(2.0);
    private final Runnable think = new Runnable(){

        @Override
        public void run() {
            AxeZombie.this.aiThinkTarget();
        }
    };
    private final Runnable move = new Runnable(){

        @Override
        public void run() {
            AxeZombie.this.aiMoveForward();
        }
    };
    private final GeneticDude.AiState zombieAIdle = new GeneticDude.AiState(0, null, 0, new Runnable(){

        @Override
        public void run() {
            AxeZombie.this.pXSprite.target = -1;
        }
    }, null, this.think, null);
    private final GeneticDude.AiState zombieEIdle = new GeneticDude.AiState(12, null, 0, null, null, this.think, null);
    private final GeneticDude.AiState zombieAPonder = new GeneticDude.AiState(0, null, 0, null, new Runnable(){

        @Override
        public void run() {
            AxeZombie.this.aiMoveTurn();
        }
    }, new Runnable(){

        @Override
        public void run() {
            AxeZombie.this.thinkPonder();
        }
    }, null);
    private final GeneticDude.AiState zombieARecoil = new GeneticDude.AiState(5, null, 0, null, null, null, this.zombieAPonder);
    private final GeneticDude.AiState zombieARTesla = new GeneticDude.AiState(4, null, 0, null, null, null, this.zombieAPonder);
    private final GeneticDude.AiState zombieAUp = new GeneticDude.AiState(11, null, 0, null, null, null, this.zombieAPonder);
    private final GeneticDude.AiState zombieAFall = new GeneticDude.AiState(1, null, 360, null, null, null, this.zombieAUp);
    private final GeneticDude.AiState zombieAHack = new GeneticDude.AiState(6, new CALLPROC(){

        @Override
        public void run(int nXSprite) {
            AxeZombie.this.HackCallback();
        }
    }, 80, null, null, null, this.zombieAPonder);
    private final GeneticDude.AiState zombieAChase = new GeneticDude.AiState(8, null, 0, null, this.move, new Runnable(){

        @Override
        public void run() {
            AxeZombie.this.thinkChase();
        }
    }, null);
    private final GeneticDude.AiState zombieAGoto = new GeneticDude.AiState(8, null, 1800, null, this.move, new Runnable(){

        @Override
        public void run() {
            AxeZombie.this.thinkGoto();
        }
    }, this.zombieAIdle);
    private final GeneticDude.AiState zombieASearch = new GeneticDude.AiState(8, null, 1800, null, this.move, new Runnable(){

        @Override
        public void run() {
            AxeZombie.this.thinkSearch();
        }
    }, this.zombieAIdle);
    private final Runnable entryEZombie = new Runnable(){

        @Override
        public void run() {
            AxeZombie.this.pSprite.hitag = (short)(AxeZombie.this.pSprite.hitag | 1);
            AxeZombie.this.pSprite.lotag = (short)203;
        }
    };
    private final GeneticDude.AiState zombieEUp2 = new GeneticDude.AiState(0, null, 1, this.entryEZombie, null, null, this.zombieASearch);
    private final GeneticDude.AiState zombieEUp = new GeneticDude.AiState(9, null, 180, new Runnable(){

        @Override
        public void run() {
            SOUND.sfxStart3DSound(AxeZombie.this.pSprite, 1100, -1, 0);
            AxeZombie.this.pSprite.ang = Main.engine.getangle(AxeZombie.this.pXSprite.targetX - AxeZombie.this.pSprite.x, AxeZombie.this.pXSprite.targetY - AxeZombie.this.pSprite.y);
        }
    }, null, null, this.zombieEUp2);
    private final GeneticDude.AiState zombieSLIdle = new GeneticDude.AiState(10, null, 0, null, null, this.think, null);
    private final GeneticDude.AiState zombieSLUP = new GeneticDude.AiState(11, null, 0, this.entryEZombie, null, null, this.zombieAPonder);

    public AxeZombie(SPRITE pSprite) {
        super(pSprite);
        System.err.println("Zombie " + pSprite.xvel);
        pSprite.hitag = (short)7;
        switch (pSprite.lotag) {
            case 244: {
                this.aiNewState(this.zombieSLIdle);
                break;
            }
            case 205: {
                this.aiNewState(this.zombieEIdle);
                break;
            }
            case 203: {
                this.aiNewState(this.zombieAIdle);
                pSprite.hitag = (short)(pSprite.hitag | 8);
                break;
            }
            case 241: {
                pSprite.hitag = (short)(pSprite.hitag | 8);
                this.pXSprite.burnTime = 1200;
            }
        }
        this.setTarget(0, 0, 0);
        this.pXSprite.stateTimer = 0;
    }

    @Override
    public void activate() {
        if (this.pXSprite.state == 0) {
            this.aiChooseDirection(Main.engine.getangle(this.pXSprite.targetX - this.pSprite.x, this.pXSprite.targetY - this.pSprite.y));
            this.pXSprite.state = 1;
        }
        switch (this.pSprite.lotag) {
            case 244: {
                if (this.aiState != this.zombieSLIdle) break;
                this.aiNewState(this.zombieSLUP);
                break;
            }
            case 205: {
                if (this.aiState != this.zombieEIdle) break;
                this.aiNewState(this.zombieEUp);
                break;
            }
            case 203: {
                if (this.pXSprite.target == -1) {
                    this.aiNewState(this.zombieASearch);
                    break;
                }
                if (!Gameutils.Chance(20480)) {
                    this.aiNewState(this.zombieAChase);
                    break;
                }
                this.aiPlaySound(Gameutils.Random(3) + 1103, 1, -1);
                this.aiNewState(this.zombieAChase);
                break;
            }
        }
    }

    @Override
    public int damage(int nSource, int nDamageType, int nDamage) {
        if (this.pXSprite.health == 0) {
            return 0;
        }
        this.pXSprite.health = Gameutils.ClipLow(this.pXSprite.health - nDamage, 0);
        this.cumulDamage += nDamage;
        if (nSource >= 0) {
            if (nSource == this.pXSprite.reference) {
                return 0;
            }
            if (this.pXSprite.target == -1) {
                this.setTarget(nSource);
                this.activate();
            } else if (nSource != this.pXSprite.target) {
                int nThresh = nDamage;
                nThresh = Engine.sprite[nSource].lotag == this.pSprite.lotag ? (nThresh *= this.pDudeInfo.changeTargetKin) : (nThresh *= this.pDudeInfo.changeTarget);
                if (Gameutils.Chance(nThresh / 2)) {
                    this.setTarget(nSource);
                    this.activate();
                }
            }
            if (nDamageType == 6) {
                this.aiTeslaHit = 1;
            } else if (!DEMO.IsOriginalDemo()) {
                this.aiTeslaHit = 0;
            }
            switch (this.pSprite.lotag) {
                case 203: 
                case 205: {
                    if (nDamageType != 1 || this.pXSprite.health > this.pDudeInfo.fleeHealth) break;
                    this.aiPlaySound(361, 0, -1);
                    this.aiPlaySound(1106, 2, -1);
                    this.pSprite.lotag = (short)241;
                    if (!DEMO.IsOriginalDemo() && this.pXSprite.burnTime == 0) {
                        this.pXSprite.burnTime = 1200;
                    }
                    this.heal(DudeInfo.dudeInfo[41].startHealth, DudeInfo.dudeInfo[41].startHealth);
                    EVENT.checkEventList(this.pXSprite.reference, 3, 0);
                }
            }
        }
        return nDamage;
    }

    @Override
    public void kill(int nSource, int nDamageType, int nDamage) {
        this.pSprite.hitag = (short)(this.pSprite.hitag | 7);
        if (this.pXSprite.key > 0) {
            Actor.DropPickupObject(this.pSprite, 100 + this.pXSprite.key - 1);
        }
        if (this.pXSprite.dropMsg != 0) {
            Actor.DropPickupObject(this.pSprite, this.pXSprite.dropMsg);
            if (!DEMO.IsOriginalDemo()) {
                this.pXSprite.dropMsg = 0;
            }
        }
        int deathType = 1;
        switch (nDamageType) {
            case 1: {
                deathType = 3;
                SOUND.sfxStart3DSound(this.pSprite, 351, -1, 0);
                break;
            }
            case 3: {
                deathType = 2;
                break;
            }
            case 5: {
                switch (this.pSprite.lotag) {
                    case 203: 
                    case 205: {
                        deathType = 14;
                    }
                }
            }
        }
        if (!BuildGdx.cache.contains(this.pDudeInfo.seqStartID + deathType, "SEQ")) {
            LEVELS.levelAddKills(this.pSprite);
            SeqHandling.seqKill(3, this.pSprite.extra);
            Actor.actPostSprite(this.pSprite.xvel, 1024);
            return;
        }
        short nXSprite = this.pSprite.extra;
        switch (this.pSprite.lotag) {
            case 203: {
                SOUND.sfxStart3DSound(this.pSprite, Gameutils.Random(2) + 1107, -1, 0);
                if (deathType == 2) {
                    SeqHandling.seqSpawn(this.pDudeInfo.seqStartID + 2, 3, nXSprite, SeqHandling.callbacks[10]);
                    Gameutils.GetSpriteExtents(this.pSprite);
                    Gib.startPos.set(this.pSprite.x, this.pSprite.y, Gameutils.extents_zTop);
                    Gib.startVel.set(Actor.sprXVel[this.pSprite.xvel] >> 1, Actor.sprYVel[this.pSprite.xvel] >> 1, -838860.0f);
                    Gib.actGenerateGibs(this.pSprite, 27, Gib.startPos, Gib.startVel);
                    break;
                }
                if (deathType != 1 || !Gameutils.Chance(8192)) {
                    if (deathType == 14) {
                        SeqHandling.seqSpawn(this.pDudeInfo.seqStartID + 14, 3, nXSprite, null);
                        break;
                    }
                    if (deathType == 3) {
                        SeqHandling.seqSpawn(this.pDudeInfo.seqStartID + 13, 3, nXSprite, SeqHandling.callbacks[11]);
                        break;
                    }
                    SeqHandling.seqSpawn(deathType + this.pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
                    break;
                }
                SeqHandling.seqSpawn(this.pDudeInfo.seqStartID + 7, 3, nXSprite, SeqHandling.callbacks[10]);
                EVENT.evPostCallback(this.pSprite.xvel, 3, 0L, 5);
                this.pXSprite.data1 = (short)35;
                this.pXSprite.data2 = (short)5;
                Gameutils.GetSpriteExtents(this.pSprite);
                Gib.startPos.set(this.pSprite.x, this.pSprite.y, Gameutils.extents_zTop);
                Gib.startVel.set(Actor.sprXVel[this.pSprite.xvel] >> 1, Actor.sprYVel[this.pSprite.xvel] >> 1, -1118481.0f);
                Gib.actGenerateGibs(this.pSprite, 27, Gib.startPos, Gib.startVel);
                SOUND.sfxStart3DSound(this.pSprite, 362, -1, 0);
                break;
            }
            case 241: {
                if (Gameutils.Chance(16384) && deathType == 3) {
                    SOUND.sfxStart3DSound(this.pSprite, 1109, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(this.pSprite, Gameutils.Random(2) + 1107, -1, 0);
                }
                nDamageType = 3;
                if (Gameutils.Chance(16384)) {
                    SeqHandling.seqSpawn(13 + this.pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
                    Gameutils.GetSpriteExtents(this.pSprite);
                    Gib.startPos.set(this.pSprite.x, this.pSprite.y, Gameutils.extents_zTop);
                    Gib.startVel.set(Actor.sprXVel[this.pSprite.xvel] >> 1, Actor.sprYVel[this.pSprite.xvel] >> 1, -838860.0f);
                    Gib.actGenerateGibs(this.pSprite, 27, Gib.startPos, Gib.startVel);
                    break;
                }
                SeqHandling.seqSpawn(13 + this.pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[11]);
                break;
            }
            default: {
                SeqHandling.seqSpawn(deathType + this.pDudeInfo.seqStartID, 3, nXSprite, null);
            }
        }
        if (nDamageType == 3) {
            for (int i = 0; i < 3; ++i) {
                int nGibType = this.pDudeInfo.nGibType[i];
                if (nGibType <= -1) continue;
                Gib.actGenerateGibs(this.pSprite, nGibType, null, null);
            }
            for (int j = 0; j < 4; ++j) {
                Actor.actSpawnBlood(this.pSprite);
            }
        }
        LEVELS.levelAddKills(this.pSprite);
        Actor.actCheckRespawn(this.pSprite);
        if (!DEMO.IsOriginalDemo() && DB.xsprite[nXSprite].Proximity) {
            DB.xsprite[nXSprite].Proximity = false;
        }
        this.pSprite.lotag = (short)426;
        Actor.actPostSprite(this.pSprite.xvel, 4);
    }

    @Override
    public void warp(int type) {
        switch (type) {
            case 9: 
            case 13: {
                switch (this.pSprite.lotag) {
                    case 203: {
                        this.pXSprite.burnTime = 0;
                        EVENT.evPostCallback(this.pSprite.xvel, 3, 0L, 11);
                        SOUND.sfxStart3DSound(this.pSprite, 720, -1, 0);
                        this.aiNewState(this.zombieAGoto);
                    }
                }
            }
        }
    }

    @Override
    protected void recoil(boolean chance) {
        switch (this.pSprite.lotag) {
            case 203: 
            case 205: {
                this.aiPlaySound(1106, 2, -1);
                if (this.aiTeslaHit != 0 && this.pXSprite.data3 > this.pDudeInfo.startHealth / 3) {
                    this.aiNewState(this.zombieARTesla);
                    break;
                }
                if (this.pXSprite.data3 <= this.pDudeInfo.startHealth / 3) {
                    this.aiNewState(this.zombieARecoil);
                    break;
                }
                this.aiNewState(this.zombieAFall);
                break;
            }
            case 241: {
                this.aiPlaySound(1106, 2, -1);
            }
        }
        this.aiTeslaHit = 0;
    }

    @Override
    public void touch() {
    }

    private void thinkPonder() {
        PLAYER pPlayer;
        if (this.pXSprite.target == -1) {
            this.aiNewState(this.zombieASearch);
            return;
        }
        if (this.pXSprite.target < 0 || this.pXSprite.target >= Globals.kMaxSprites) {
            Main.game.dassert("pXSprite.target >= 0 && pXSprite.target < kMaxSprites");
        }
        SPRITE pTarget = Engine.sprite[this.pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - this.pSprite.x;
        int dy = pTarget.y - this.pSprite.y;
        this.aiChooseDirection(Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            this.aiNewState(this.zombieASearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && (PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0 || PLAYER.powerupCheck(pPlayer, 31) > 0)) {
            this.aiNewState(this.zombieAGoto);
            return;
        }
        long dist = Main.engine.qdist(dx, dy);
        if (dist <= (long)this.pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - this.pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = this.pDudeInfo.eyeHeight * this.pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, this.pSprite.x, this.pSprite.y, this.pSprite.z - eyeAboveZ, this.pSprite.sectnum) && Pragmas.klabs(losAngle) <= this.pDudeInfo.periphery) {
                this.setTarget(this.pXSprite.target);
                if (dist < (long)kAxeZombieMeleeDist) {
                    if (Pragmas.klabs(losAngle) < 85) {
                        this.aiNewState(this.zombieAHack);
                    }
                    return;
                }
            }
        }
        this.aiNewState(this.zombieAChase);
    }

    private void HackCallback() {
        SPRITE pTarget;
        short nAngle = Main.engine.getangle(this.pXSprite.targetX - this.pSprite.x, this.pXSprite.targetY - this.pSprite.y);
        int nZOffset1 = this.pDudeInfo.eyeHeight * this.pSprite.yrepeat << 2;
        int nZOffset2 = 0;
        if (this.pXSprite.target != -1 && Actor.IsDudeSprite(pTarget = Engine.sprite[this.pXSprite.target])) {
            nZOffset2 = DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight * pTarget.yrepeat << 2;
        }
        int dx = Trig.Cos(nAngle) >> 16;
        int dy = Trig.Sin(nAngle) >> 16;
        int dz = nZOffset1 - nZOffset2;
        SOUND.sfxStart3DSound(this.pSprite, 1101, 1, 0);
        Actor.actFireVector(this.pSprite, 0, 0, dx, dy, dz, 10);
    }

    private void thinkSearch() {
        this.aiChooseDirection(this.pXSprite.goalAng);
        if (this.aiThinkTarget()) {
            return;
        }
        if (this.pXSprite.state == 0) {
            return;
        }
        short nSprite = Engine.headspritestat[6];
        while (nSprite >= 0) {
            int dy;
            int dx;
            long dist;
            SPRITE pTarget = Engine.sprite[nSprite];
            if (pTarget.lotag == 245 && ((dist = Main.engine.qdist(dx = pTarget.x - this.pSprite.x, dy = pTarget.y - this.pSprite.y)) <= (long)DudeInfo.dudeInfo[45].seeDist || dist <= (long)DudeInfo.dudeInfo[45].hearDist)) {
                this.setTarget(pTarget.xvel);
                this.activate();
                return;
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
    }

    private void thinkGoto() {
        int dx = this.pXSprite.targetX - this.pSprite.x;
        int dy = this.pXSprite.targetY - this.pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        long dist = Main.engine.qdist(dx, dy);
        this.aiChooseDirection(nAngle);
        if (dist < (long)Gameutils.M2X(1.8) && Pragmas.klabs(this.pSprite.ang - nAngle) < this.pDudeInfo.periphery) {
            this.aiNewState(this.zombieASearch);
        }
        this.aiThinkTarget();
    }

    private void thinkChase() {
        PLAYER pPlayer;
        if (this.pXSprite.target == -1) {
            this.aiNewState(this.zombieASearch);
            return;
        }
        if (this.pXSprite.target < 0 || this.pXSprite.target >= Globals.kMaxSprites) {
            Main.game.dassert("pXSprite.target >= 0 && pXSprite.target < kMaxSprites");
        }
        SPRITE pTarget = Engine.sprite[this.pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - this.pSprite.x;
        int dy = pTarget.y - this.pSprite.y;
        this.aiChooseDirection(Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            this.aiNewState(this.zombieASearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && (PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0 || PLAYER.powerupCheck(pPlayer, 31) > 0)) {
            this.aiNewState(this.zombieAGoto);
            return;
        }
        long dist = Main.engine.qdist(dx, dy);
        if (dist <= (long)this.pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - this.pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = this.pDudeInfo.eyeHeight * this.pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, this.pSprite.x, this.pSprite.y, this.pSprite.z - eyeAboveZ, this.pSprite.sectnum) && Pragmas.klabs(losAngle) <= this.pDudeInfo.periphery) {
                this.setTarget(this.pXSprite.target);
                if (dist < (long)kAxeZombieMeleeDist && Pragmas.klabs(losAngle) < 85) {
                    this.aiNewState(this.zombieAHack);
                }
                return;
            }
        }
        this.aiNewState(this.zombieAGoto);
        this.pXSprite.target = -1;
    }
}

