/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.AI.AIBURN;
import ru.m210projects.Blood.AI.AICULTIST;
import ru.m210projects.Blood.AI.AIGILLBEAST;
import ru.m210projects.Blood.AI.AIUNICULT;
import ru.m210projects.Blood.AI.AIZOMBA;
import ru.m210projects.Blood.AI.AIZOMBF;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Gib;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.AMMOITEMDATA;
import ru.m210projects.Blood.Types.ARMORITEMDATA;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.EFFECT;
import ru.m210projects.Blood.Types.EXPLODE;
import ru.m210projects.Blood.Types.ITEMDATA;
import ru.m210projects.Blood.Types.MissileType;
import ru.m210projects.Blood.Types.POSTPONE;
import ru.m210projects.Blood.Types.POWERUPINFO;
import ru.m210projects.Blood.Types.SPRITEHIT;
import ru.m210projects.Blood.Types.SPRITEMASS;
import ru.m210projects.Blood.Types.SURFACE;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.Seq.SeqType;
import ru.m210projects.Blood.Types.THINGINFO;
import ru.m210projects.Blood.Types.VECTORDATA;
import ru.m210projects.Blood.Types.WEAPONITEMDATA;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Hitscan;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class Actor {
    public static int gTNTCount;
    public static final int kAttrMove = 1;
    public static final int kAttrGravity = 2;
    public static final int kAttrFalling = 4;
    public static final int kAttrAiming = 8;
    public static final int kAttrRespawn = 16;
    public static final int kAttrFree = 32;
    public static final int kAttrSmoke = 256;
    public static final int kAttrFlipX = 1024;
    public static final int kAttrFlipY = 2048;
    public static final int kDamageFall = 0;
    public static final int kDamageBurn = 1;
    public static final int kDamageBullet = 2;
    public static final int kDamageExplode = 3;
    public static final int kDamageDrown = 4;
    public static final int kDamageSpirit = 5;
    public static final int kDamageTesla = 6;
    public static final int kDamageMax = 7;
    public static int gNoEnemies;
    public static SPRITEHIT[] gSpriteHit;
    public static int[] gWallExp;
    public static int[] gSectorExp;
    public static byte[] gSpriteExp;
    public static long[] sprXVel;
    public static long[] sprYVel;
    public static long[] sprZVel;
    public static long[] floorVel;
    public static long[] ceilingVel;
    public static final int[] pSkillShift;
    public static final int[] pPlayerShift;
    public static final int kScreamVel = 0x155555;
    public static final int kGruntVel = 700;
    public static final int kDudeDrag = 10752;
    public static final int kMinDudeVel = 4096;
    public static int gPostCount;
    public static POSTPONE[] gPost;
    public static final int kPowerUpTime = 3600;
    public static final int kMaxPowerUpTime = 432000;
    public static final int kVectorTine = 0;
    public static final int kVectorShell = 1;
    public static final int kVectorBullet = 2;
    public static final int kVectorBatBite = 6;
    public static final int kVectorBoneelBite = 7;
    public static final int kVectorAxe = 10;
    public static final int kVectorCleaver = 11;
    public static final int kVectorGhost = 12;
    public static final int kVectorGargSlash = 13;
    public static final int kVectorCerberusHack = 14;
    public static final int kVectorHoundBite = 15;
    public static final int kVectorRatBite = 16;
    public static final int kVectorSpiderBite = 17;
    public static final int kVectorMax = 23;
    public static SPRITEMASS[] gSpriteMass;
    public static final VECTORDATA[] gVectorData;
    public static final int kExplodeMax = 9;
    public static final EXPLODE[] gExplodeData;
    public static final MissileType[] gMissileData;
    public static final int kFXMax = 57;
    public static final EFFECT[] gEffectInfo;
    public static final THINGINFO[] thingInfo;
    public static final AMMOITEMDATA[] gAmmoItemData;
    public static final WEAPONITEMDATA[] gWeaponItemData;
    public static final ARMORITEMDATA[] gArmorItemData;
    public static final POWERUPINFO[] gPowerUpInfo;
    public static final ITEMDATA[] gItemInfo;
    static int info_nSprite;
    static SPRITE info_pSprite;
    static XSPRITE info_pXSprite;
    static int info_nWall;
    static WALL info_pWall;
    static XWALL info_pXWall;
    static int info_nSector;
    static SECTOR info_pSector;
    static XSECTOR info_pXSector;
    public static final int kGlobalForceShift = 18;
    public static long refl_x;
    public static long refl_y;
    public static long refl_z;
    public static final int[] NapalmAmmo;

    public static void AirDrag(int nSprite, int nDrag) {
        int windX = 0;
        int windY = 0;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nSector = pSprite.sectnum;
        if (nSector < 0 || nSector >= Globals.kMaxSectors) {
            Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
        }
        if (Engine.sector[nSector].extra > 0) {
            short nXSector = Engine.sector[nSector].extra;
            if (nXSector <= 0 || nXSector >= 512) {
                Main.game.dassert("nXSector > 0 && nXSector < kMaxXSectors");
            }
            XSECTOR pXSector = DB.xsector[nXSector];
            if (pXSector.windVel != 0 && (pXSector.windAlways || pXSector.busy != 0)) {
                int windVel = pXSector.windVel << 12;
                if (!pXSector.windAlways && pXSector.busy != 0) {
                    windVel = Pragmas.mulscale(pXSector.busy, windVel, 16);
                }
                windX = Pragmas.mulscale(Trig.Cos(pXSector.windAng), windVel, 30);
                windY = Pragmas.mulscale(Trig.Sin(pXSector.windAng), windVel, 30);
            }
        }
        short s = pSprite.xvel;
        sprXVel[s] = sprXVel[s] + (long)Pragmas.mulscale(nDrag, (long)windX - sprXVel[pSprite.xvel], 16);
        short s2 = pSprite.xvel;
        sprYVel[s2] = sprYVel[s2] + (long)Pragmas.mulscale(nDrag, (long)windY - sprYVel[pSprite.xvel], 16);
        short s3 = pSprite.xvel;
        sprZVel[s3] = sprZVel[s3] - (long)Pragmas.mulscale(nDrag, sprZVel[pSprite.xvel], 16);
    }

    public static boolean IsNormalWall(int nWall) {
        if (nWall < 0 || nWall >= Globals.kMaxWalls) {
            Main.game.dassert("nWall >= 0 && nWall < kMaxWalls");
        }
        WALL pWall = Engine.wall[nWall];
        short cstat = pWall.cstat;
        if ((cstat & 0x4000) != 0) {
            return false;
        }
        if ((cstat & 0x8000) != 0) {
            return false;
        }
        if (pWall.lotag < 500 || pWall.lotag >= 512) {
            if (pWall.nextsector != -1) {
                return Engine.sector[pWall.nextsector].lotag < 600 || Engine.sector[pWall.nextsector].lotag >= 620;
            }
            return true;
        }
        return false;
    }

    public static void actFireVector(SPRITE pActor, int xOffset, int zOffset, int dx, int dy, int dz, int vectorType) {
        if (vectorType < 0 || vectorType >= 23) {
            Main.game.dassert("vectorType >= 0 && vectorType < kVectorMax");
        }
        VECTORDATA pVectorData = gVectorData[vectorType];
        int maxDist = pVectorData.maxDist;
        int hitCode = Gameutils.VectorScan(pActor, xOffset, zOffset, dx, dy, dz, maxDist, 1);
        if (hitCode == 3) {
            SPRITE pSprite;
            if (Engine.pHitInfo.hitsprite < 0 || Engine.pHitInfo.hitsprite >= Globals.kMaxSprites) {
                Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
            }
            if (Gameutils.IsPlayerSprite(pSprite = Engine.sprite[Engine.pHitInfo.hitsprite]) && PLAYER.powerupCheck(Globals.gPlayer[pSprite.lotag - 231], 24) != 0) {
                Engine.pHitInfo.hitsprite = pActor.xvel;
                Engine.pHitInfo.hitx = pActor.x;
                Engine.pHitInfo.hity = pActor.y;
                Engine.pHitInfo.hitz = pActor.z;
            }
        }
        int rx = Engine.pHitInfo.hitx - Pragmas.mulscale(dx, 16L, 14);
        int ry = Engine.pHitInfo.hity - Pragmas.mulscale(dy, 16L, 14);
        int rz = Engine.pHitInfo.hitz - Pragmas.mulscale(dz, 256L, 14);
        int nSurf = Tile.kSurfNone;
        short nSector = Engine.pHitInfo.hitsect;
        byte[] surfType = Main.game.getCurrentDef().surfType;
        if (maxDist == 0 || Main.engine.qdist(Engine.pHitInfo.hitx - pActor.x, Engine.pHitInfo.hity - pActor.y) < (long)maxDist) {
            switch (hitCode) {
                case 1: {
                    if ((Engine.sector[Engine.pHitInfo.hitsect].ceilingstat & 1) != 0) {
                        nSurf = Tile.kSurfNone;
                        break;
                    }
                    nSurf = surfType[Engine.sector[Engine.pHitInfo.hitsect].ceilingpicnum];
                    break;
                }
                case 2: {
                    if ((Engine.sector[Engine.pHitInfo.hitsect].floorstat & 1) != 0) {
                        nSurf = Tile.kSurfNone;
                        break;
                    }
                    nSurf = surfType[Engine.sector[Engine.pHitInfo.hitsect].floorpicnum];
                    break;
                }
                case 0: {
                    SPRITE pSpawn;
                    short nWall = Engine.pHitInfo.hitwall;
                    if (nWall < 0 || nWall >= Globals.kMaxWalls) {
                        Main.game.dassert("nWall >= 0 && nWall < kMaxWalls");
                    }
                    nSurf = surfType[Engine.wall[nWall].picnum];
                    if (!Actor.IsNormalWall(nWall)) break;
                    int wx = Engine.pHitInfo.hitx - Pragmas.mulscale(16L, dx, 14);
                    int wy = Engine.pHitInfo.hity - Pragmas.mulscale(16L, dy, 14);
                    int wz = Engine.pHitInfo.hitz - Pragmas.mulscale(256L, dz, 14);
                    if (nSurf >= Tile.kSurfMax) {
                        Main.game.dassert("nSurf < kSurfMax");
                    }
                    if (pVectorData.impact[nSurf].nEffect1 < 0 || (pSpawn = Actor.actSpawnEffect(pVectorData.impact[nSurf].nEffect1, nSector, wx, wy, wz, 0)) == null) break;
                    pSpawn.cstat = (short)(pSpawn.cstat | 0x10);
                    pSpawn.ang = (short)(Gameutils.GetWallAngle(nWall) + 512 & 0x7FF);
                    break;
                }
                case 4: {
                    short nWall = Engine.pHitInfo.hitwall;
                    if (nWall < 0 || nWall >= Globals.kMaxWalls) {
                        Main.game.dassert("nWall >= 0 && nWall < kMaxWalls");
                    }
                    nSurf = surfType[Engine.wall[nWall].overpicnum];
                    short nXWall = Engine.wall[nWall].extra;
                    if (nXWall <= 0) break;
                    XWALL pXWall = DB.xwall[nXWall];
                    if (!pXWall.triggerVector) break;
                    Trigger.trTriggerWall(nWall, pXWall, 51);
                    break;
                }
                case 3: {
                    short nSprite = Engine.pHitInfo.hitsprite;
                    if (nSprite < 0 || nSprite >= Globals.kMaxSprites) {
                        Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
                    }
                    nSector = Engine.pHitInfo.hitsect;
                    nSurf = surfType[Engine.sprite[nSprite].picnum];
                    rx -= Pragmas.mulscale(dx, 112L, 14);
                    ry -= Pragmas.mulscale(dy, 112L, 14);
                    rz -= Pragmas.mulscale(dz, 1792L, 14);
                    SPRITE pSprite = Engine.sprite[nSprite];
                    int shift = 4;
                    if (vectorType == 0 && !Gameutils.IsPlayerSprite(pSprite)) {
                        shift = 3;
                    }
                    Actor.actDamageSprite(pActor.xvel, pSprite, pVectorData.damageType, pVectorData.damageValue << shift);
                    short nXSprite = Engine.sprite[nSprite].extra;
                    if (nXSprite > 0) {
                        XSPRITE pXSprite = DB.xsprite[nXSprite];
                        if (pXSprite.Vector) {
                            Trigger.trTriggerSprite(nSprite, pXSprite, 31);
                        }
                    }
                    if (pSprite.statnum == 4) {
                        if (pSprite.lotag >= 400 && pSprite.lotag < 436 && Actor.thingInfo[pSprite.lotag - 400].mass > 0 && pVectorData.hitForce != 0) {
                            int impulse = (pVectorData.hitForce << 8) / Actor.thingInfo[pSprite.lotag - 400].mass;
                            short s = nSprite;
                            sprXVel[s] = sprXVel[s] + (long)Pragmas.mulscale(impulse, dx, 16);
                            short s2 = nSprite;
                            sprYVel[s2] = sprYVel[s2] + (long)Pragmas.mulscale(impulse, dy, 16);
                            short s3 = nSprite;
                            sprZVel[s3] = sprZVel[s3] + (long)Pragmas.mulscale(impulse, dz, 16);
                        }
                        if (pVectorData.burn != 0) {
                            XSPRITE pXSprite = DB.xsprite[nXSprite];
                            if (pXSprite.burnTime == 0) {
                                EVENT.evPostCallback(nSprite, 3, 0L, 0);
                            }
                            pXSprite.burnSource = Actor.actSetBurnSource(pActor.xvel);
                            pXSprite.burnTime = Gameutils.ClipHigh(pXSprite.burnTime + pVectorData.burn, 1200);
                        }
                    }
                    if (pSprite.statnum != 6) break;
                    int mass = 0;
                    if (Actor.IsDudeSprite(pSprite)) {
                        switch (pSprite.lotag) {
                            case 254: 
                            case 255: {
                                mass = Actor.getDudeMassBySpriteSize(pSprite);
                                break;
                            }
                            default: {
                                mass = DudeInfo.dudeInfo[pSprite.lotag - 200].mass;
                            }
                        }
                    }
                    if (mass > 0 && pVectorData.hitForce != 0) {
                        long impulse = Pragmas.divscale(pVectorData.hitForce, mass, 8);
                        short s = nSprite;
                        sprXVel[s] = sprXVel[s] + (long)Pragmas.mulscale(impulse, dx, 16);
                        short s4 = nSprite;
                        sprYVel[s4] = sprYVel[s4] + (long)Pragmas.mulscale(impulse, dy, 16);
                        short s5 = nSprite;
                        sprZVel[s5] = sprZVel[s5] + (long)Pragmas.mulscale(impulse, dz, 16);
                    }
                    if (pVectorData.burn != 0) {
                        XSPRITE pXSprite = DB.xsprite[nXSprite];
                        if (pXSprite.burnTime == 0) {
                            EVENT.evPostCallback(nSprite, 3, 0L, 0);
                        }
                        pXSprite.burnSource = Actor.actSetBurnSource(pActor.xvel);
                        pXSprite.burnTime = Gameutils.ClipHigh(pXSprite.burnTime + pVectorData.burn, 2400);
                    }
                    if (Gameutils.Chance(pVectorData.spawnBlood >> 1)) {
                        int hz;
                        int hy;
                        maxDist = Actor.gVectorData[19].maxDist;
                        int hx = Gameutils.BiRandom2(4000) + dx;
                        if (Gameutils.HitScan(pSprite, Engine.pHitInfo.hitz, hx, hy = Gameutils.BiRandom2(4000) + dy, hz = Gameutils.BiRandom2(4000) + dz, Engine.pHitInfo, 0x1000040, maxDist) == 0 && Main.engine.qdist(Engine.pHitInfo.hitx - pSprite.x, Engine.pHitInfo.hity - pSprite.y) <= (long)maxDist && Actor.IsNormalWall(Engine.pHitInfo.hitwall)) {
                            int sx = Engine.pHitInfo.hitx - Pragmas.mulscale(16L, hx, 14);
                            int sy = Engine.pHitInfo.hity - Pragmas.mulscale(16L, hy, 14);
                            int sz = Engine.pHitInfo.hitz - Pragmas.mulscale(256L, hz, 14);
                            int nEffect2 = Actor.gVectorData[19].impact[surfType[Engine.wall[Engine.pHitInfo.hitwall].picnum]].nEffect2;
                            int nEffect3 = Actor.gVectorData[19].impact[surfType[Engine.wall[Engine.pHitInfo.hitwall].picnum]].nEffect3;
                            SPRITE pSpawn = null;
                            if ((nEffect2 != -1 || nEffect3 != -1) && (pSpawn = !Gameutils.Chance(8192) ? Actor.actSpawnEffect(nEffect3, Engine.pHitInfo.hitsect, sx, sy, sz, 0) : Actor.actSpawnEffect(nEffect2, Engine.pHitInfo.hitsect, sx, sy, sz, 0)) != null) {
                                Actor.sprZVel[pSpawn.xvel] = 8738L;
                                pSpawn.ang = (short)(Gameutils.GetWallAngle(Engine.pHitInfo.hitwall) + 512 & 0x7FF);
                                pSpawn.cstat = (short)(pSpawn.cstat | 0x10);
                            }
                        }
                    }
                    for (int i = 0; i < pVectorData.nBloodTrails; ++i) {
                        if (!Gameutils.Chance(pVectorData.nBloodChance >> 1)) continue;
                        Actor.actSpawnBlood(pSprite);
                    }
                    break;
                }
            }
        }
        if (pVectorData.impact[nSurf].nEffect2 >= 0) {
            Actor.actSpawnEffect(pVectorData.impact[nSurf].nEffect2, nSector, rx, ry, rz, 0);
        }
        if (pVectorData.impact[nSurf].nEffect3 >= 0) {
            Actor.actSpawnEffect(pVectorData.impact[nSurf].nEffect3, nSector, rx, ry, rz, 0);
        }
        if (pVectorData.impact[nSurf].nSoundId >= 0) {
            SOUND.sfxCreate3DSound(rx, ry, rz, pVectorData.impact[nSurf].nSoundId, nSector);
        }
    }

    public static SPRITE actFireThing(int nActor, int xOffset, int zOffset, int nSlope, int thingType, int velocity) {
        if (thingType < 400 || thingType >= 436) {
            Main.game.dassert("thingType >= kThingBase && thingType < kThingMax");
        }
        SPRITE pActor = Engine.sprite[nActor];
        int dx = Pragmas.mulscale(pActor.clipdist, Trig.Cos(pActor.ang), 28) + Pragmas.mulscale(Trig.Cos(pActor.ang + 512), xOffset, 30);
        int dy = Pragmas.mulscale(pActor.clipdist, Trig.Sin(pActor.ang), 28) + Pragmas.mulscale(Trig.Sin(pActor.ang + 512), xOffset, 30);
        int x = pActor.x + dx;
        int y = pActor.y + dy;
        int z = pActor.z + zOffset;
        if (Gameutils.HitScan(pActor, z, dx, dy, 0, Engine.pHitInfo, 65537, pActor.clipdist) != -1) {
            x = Engine.pHitInfo.hitx - Pragmas.mulscale(pActor.clipdist << 1, Trig.Cos(pActor.ang), 28);
            y = Engine.pHitInfo.hity - Pragmas.mulscale(pActor.clipdist << 1, Trig.Sin(pActor.ang), 28);
        }
        SPRITE pThing = Actor.actSpawnThing(pActor.sectnum, x, y, z, thingType);
        Actor.actSetOwner(pThing, pActor);
        pThing.ang = pActor.ang;
        Actor.sprXVel[pThing.xvel] = Pragmas.mulscale(velocity, Trig.Cos(pActor.ang), 30);
        Actor.sprYVel[pThing.xvel] = Pragmas.mulscale(velocity, Trig.Sin(pActor.ang), 30);
        Actor.sprZVel[pThing.xvel] = Pragmas.mulscale(velocity, nSlope, 14);
        short s = pThing.xvel;
        sprXVel[s] = sprXVel[s] + sprXVel[pActor.xvel] / 2L;
        short s2 = pThing.xvel;
        sprYVel[s2] = sprYVel[s2] + sprYVel[pActor.xvel] / 2L;
        short s3 = pThing.xvel;
        sprZVel[s3] = sprZVel[s3] + sprZVel[pActor.xvel] / 2L;
        return pThing;
    }

    public static boolean sfxPlayMissileSound(SPRITE pSprite, int missileId) {
        MissileType pMissType = gMissileData[missileId - 300];
        if (Gameutils.Chance(16384)) {
            SOUND.sfxStart3DSound(pSprite, pMissType.fireSound[0], -1, 0);
        } else {
            SOUND.sfxStart3DSound(pSprite, pMissType.fireSound[1], -1, 0);
        }
        return true;
    }

    public static boolean sfxPlayVectorSound(SPRITE pSprite, int vectorId) {
        VECTORDATA pVectorData = gVectorData[vectorId];
        if (Gameutils.Chance(16384)) {
            SOUND.sfxStart3DSound(pSprite, pVectorData.fireSound[0], -1, 0);
        } else {
            SOUND.sfxStart3DSound(pSprite, pVectorData.fireSound[1], -1, 0);
        }
        return true;
    }

    public static SPRITE actFireMissile(SPRITE pActor, int xoffset, int zoffset, int dx, int dy, int dz, int missileType) {
        int sy;
        boolean Impact = false;
        if (missileType < 300 || missileType >= 318) {
            Main.game.dassert("missileType >= kMissileBase && missileType < kMissileMax");
        }
        MissileType pMissType = gMissileData[missileType - 300];
        int sz = pActor.z + zoffset;
        int sx = pActor.x + Pragmas.mulscale(Trig.Cos(pActor.ang), pActor.clipdist + pMissType.clipdist, 28) + Pragmas.mulscale(Trig.Cos(pActor.ang + 512), xoffset, 30);
        int hitInfo = Gameutils.HitScan(pActor, sz, sx - pActor.x, (sy = pActor.y + Pragmas.mulscale(Trig.Sin(pActor.ang), pActor.clipdist + pMissType.clipdist, 28) + Pragmas.mulscale(Trig.Sin(pActor.ang + 512), xoffset, 30)) - pActor.y, 0, Engine.pHitInfo, 65537, pActor.clipdist + pMissType.clipdist);
        if (hitInfo != -1) {
            if (hitInfo != 3 && hitInfo != 0) {
                sx = Engine.pHitInfo.hitx - Pragmas.mulscale(Trig.Cos(pActor.ang), pMissType.clipdist << 1, 28);
                sy = Engine.pHitInfo.hity - Pragmas.mulscale(Trig.Sin(pActor.ang), pMissType.clipdist << 1, 28);
            } else {
                Impact = true;
                sx = Engine.pHitInfo.hitx - Pragmas.mulscale(Trig.Cos(pActor.ang), 16L, 30);
                sy = Engine.pHitInfo.hity - Pragmas.mulscale(Trig.Sin(pActor.ang), 16L, 30);
            }
        }
        int nSprite = Actor.actSpawnSprite(pActor.sectnum, sx, sy, sz, 5, true);
        SPRITE pSprite = Engine.sprite[nSprite];
        int n = nSprite >> 3;
        Engine.show2dsprite[n] = (byte)(Engine.show2dsprite[n] | 1 << (nSprite & 7));
        pSprite.lotag = (short)missileType;
        pSprite.shade = (byte)pMissType.shade;
        pSprite.pal = 0;
        pSprite.clipdist = pMissType.clipdist;
        pSprite.hitag = 1;
        pSprite.xrepeat = (short)pMissType.xrepeat;
        pSprite.yrepeat = (short)pMissType.yrepeat;
        pSprite.picnum = (short)pMissType.picnum;
        pSprite.ang = (short)(pActor.ang + pMissType.angleOfs & 0x7FF);
        Actor.sprXVel[pSprite.xvel] = Pragmas.mulscale(dx, pMissType.velocity, 14);
        Actor.sprYVel[pSprite.xvel] = Pragmas.mulscale(dy, pMissType.velocity, 14);
        Actor.sprZVel[pSprite.xvel] = Pragmas.mulscale(dz, pMissType.velocity, 14);
        Actor.actSetOwner(pSprite, pActor);
        pSprite.cstat = (short)(pSprite.cstat | 1);
        short nXSprite = pSprite.extra;
        if (nXSprite <= 0 || nXSprite >= 2048) {
            Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
        }
        DB.xsprite[nXSprite].target = -1;
        EVENT.evPostCallback(pSprite.xvel, 3, 600L, 1);
        Actor.actBuildMissile(pSprite, nXSprite, pActor);
        if (Impact) {
            Actor.actImpactMissile(pSprite, hitInfo);
            pSprite = null;
        }
        return pSprite;
    }

    public static void actBuildMissile(SPRITE pSprite, int nXSprite, SPRITE pActor) {
        switch (pSprite.lotag) {
            case 315: {
                EVENT.evPostCallback(pSprite.xvel, 3, 0L, 0);
                break;
            }
            case 302: {
                EVENT.evPostCallback(pSprite.xvel, 3, 0L, 15);
                break;
            }
            case 309: {
                SeqHandling.seqSpawn(29, 3, nXSprite, null);
                break;
            }
            case 300: {
                pSprite.cstat = (short)(pSprite.cstat | 0x10);
                break;
            }
            case 306: {
                SOUND.sfxStart3DSound(pSprite, 251, 0, 0);
                break;
            }
            case 307: {
                SeqHandling.seqSpawn(2, 3, nXSprite, null);
                SOUND.sfxStart3DSound(pSprite, 493, 0, 0);
                break;
            }
            case 312: {
                SeqHandling.seqSpawn(VERSION.getSeq(6), 3, nXSprite, SeqHandling.callbacks[6]);
                SOUND.sfxStart3DSound(pSprite, 441, 0, 0);
                break;
            }
            case 305: {
                SeqHandling.seqSpawn(22, 3, nXSprite, SeqHandling.callbacks[7]);
                SOUND.sfxStart3DSound(pSprite, 441, 0, 0);
                break;
            }
            case 308: {
                SeqHandling.seqSpawn(27, 3, nXSprite, null);
                short s = pSprite.xvel;
                sprXVel[s] = sprXVel[s] + (sprXVel[pActor.xvel] / 2L + (long)Gameutils.BiRandom(69905));
                short s2 = pSprite.xvel;
                sprYVel[s2] = sprYVel[s2] + (sprYVel[pActor.xvel] / 2L + (long)Gameutils.BiRandom(69905));
                short s3 = pSprite.xvel;
                sprZVel[s3] = sprZVel[s3] + (sprZVel[pActor.xvel] / 2L + (long)Gameutils.BiRandom(69905));
                break;
            }
            case 313: {
                SeqHandling.seqSpawn(VERSION.getSeq(6), 3, nXSprite, SeqHandling.callbacks[8]);
                SOUND.sfxStart3DSound(pSprite, 441, 0, 0);
                break;
            }
            case 314: {
                SeqHandling.seqSpawn(23, 3, nXSprite, SeqHandling.callbacks[9]);
                short s = pSprite.xvel;
                sprXVel[s] = sprXVel[s] + (sprXVel[pActor.xvel] / 2L + (long)Gameutils.BiRandom(69905));
                short s4 = pSprite.xvel;
                sprYVel[s4] = sprYVel[s4] + (sprYVel[pActor.xvel] / 2L + (long)Gameutils.BiRandom(69905));
                short s5 = pSprite.xvel;
                sprZVel[s5] = sprZVel[s5] + (sprZVel[pActor.xvel] / 2L + (long)Gameutils.BiRandom(69905));
                break;
            }
            case 304: {
                if (Gameutils.Chance(16384)) {
                    SeqHandling.seqSpawn(0, 3, nXSprite, null);
                } else {
                    SeqHandling.seqSpawn(1, 3, nXSprite, null);
                }
                short s = pSprite.xvel;
                sprXVel[s] = sprXVel[s] + (sprXVel[pActor.xvel] + (long)Gameutils.BiRandom(69905));
                short s6 = pSprite.xvel;
                sprYVel[s6] = sprYVel[s6] + (sprYVel[pActor.xvel] + (long)Gameutils.BiRandom(69905));
                short s7 = pSprite.xvel;
                sprZVel[s7] = sprZVel[s7] + (sprZVel[pActor.xvel] + (long)Gameutils.BiRandom(69905));
                break;
            }
            case 303: {
                EVENT.evPostCallback(pSprite.xvel, 3, 30L, 2);
                EVENT.evPostCallback(pSprite.xvel, 3, 0L, 3);
                SOUND.sfxStart3DSound(pSprite, 422, 0, 0);
                break;
            }
            case 301: {
                EVENT.evPostCallback(pSprite.xvel, 3, 0L, 3);
                SOUND.sfxStart3DSound(pSprite, 422, 0, 0);
                break;
            }
            case 311: {
                SOUND.sfxStart3DSound(pSprite, 252, 0, 0);
                break;
            }
            case 317: {
                EVENT.evPostCallback(pSprite.xvel, 3, 0L, 7);
            }
        }
    }

    public static void actTeslaImpact(SPRITE pSprite, int hitInfo) {
        int x = pSprite.x;
        int y = pSprite.y;
        int z = pSprite.z;
        short nSector = pSprite.sectnum;
        int nSource = Actor.actGetOwner(pSprite);
        Actor.gSectorExp[0] = -1;
        Actor.gWallExp[0] = -1;
        Gameutils.NearSectors(nSector, x, y, 300, gSectorExp, gSpriteExp, gWallExp);
        boolean shotDude = false;
        Actor.actHitInfo(hitInfo, Engine.pHitInfo);
        if (hitInfo == 3 && info_nSprite >= 0 && Engine.sprite[Actor.info_nSprite].statnum == 6) {
            shotDude = true;
        }
        short nSprite = Engine.headspritestat[6];
        while (nSprite >= 0) {
            if (nSprite != nSource || !shotDude) {
                SPRITE pDude = Engine.sprite[nSprite];
                if ((pDude.hitag & 0x20) == 0 && (gSpriteExp[pDude.sectnum >> 3] & 1 << (pDude.sectnum & 7)) != 0 && Gameutils.CheckProximity(pDude, x, y, z, nSector, 300)) {
                    int dx = x - pDude.x;
                    int dy = y - pDude.y;
                    int nDamage = 300 - (Main.engine.ksqrt(dx * dx + dy * dy) >> 4) + 20 >> 1;
                    if (nDamage < 0) {
                        nDamage = 10;
                    }
                    if (nSprite == nSource) {
                        nDamage /= 2;
                    }
                    Actor.actDamageSprite(nSource, pDude, 6, nDamage << 4);
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        nSprite = Engine.headspritestat[4];
        while (nSprite >= 0) {
            short nXThing;
            SPRITE pThing = Engine.sprite[nSprite];
            if ((pThing.hitag & 0x20) == 0 && (gSpriteExp[pThing.sectnum >> 3] & 1 << (pThing.sectnum & 7)) != 0 && Gameutils.CheckProximity(pThing, x, y, z, nSector, 300) && (nXThing = pThing.extra) > 0 && DB.xsprite[nXThing].Locked == 0) {
                int dx = x - pThing.x;
                int dy = y - pThing.y;
                int nDamage = 300 - (Main.engine.ksqrt(dx * dx + dy * dy) >> 4) + 20;
                if (nDamage < 0) {
                    nDamage = 20;
                }
                Actor.actDamageSprite(nSource, pThing, 6, nDamage << 4);
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
    }

    public static void actImpactMissile(SPRITE pMissile, int hitInfo) {
        short nXMissile = pMissile.extra;
        if (nXMissile <= 0 || nXMissile >= 2048) {
            Main.game.dassert("nXMissile > 0 && nXMissile < kMaxXSprites");
        }
        XSPRITE pXMissile = DB.xsprite[pMissile.extra];
        Actor.actHitInfo(hitInfo, Engine.pHitInfo);
        SPRITE pSprite = info_pSprite;
        XSPRITE pXSprite = info_pXSprite;
        WALL pWall = info_pWall;
        int nSprite = info_nSprite;
        int nWall = info_nWall;
        DudeInfo pDudeInfo = null;
        THINGINFO pThingInfo = null;
        if (hitInfo == 3 && pSprite != null) {
            if (pSprite.statnum == 4) {
                if (pXSprite == null) {
                    Main.game.dassert("pXSpriteHit != NULL");
                }
                pThingInfo = thingInfo[pSprite.lotag - 400];
            } else if (pSprite.statnum == 6) {
                if (pXSprite == null) {
                    Main.game.dassert("pXSpriteHit != NULL");
                }
                if (Actor.IsDudeSprite(pSprite)) {
                    pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
                } else {
                    pThingInfo = thingInfo[pSprite.lotag - 400];
                }
            }
        }
        switch (pMissile.lotag) {
            case 315: {
                if (hitInfo == 3 && pSprite != null && (pThingInfo != null || pDudeInfo != null)) {
                    int nDamage = 6;
                    if (DEMO.IsOriginalDemo()) {
                        nDamage = 7;
                    }
                    Actor.actDamageSprite(Actor.actGetOwner(pMissile), pSprite, Gameutils.Random(nDamage), 16 * Gameutils.Random(7) + 112);
                    if (pThingInfo != null && pThingInfo.damageShift[1] != 0 || pDudeInfo != null && pDudeInfo.damageShift[1] != 0) {
                        int maxtime = Engine.sprite[pXSprite.reference].statnum == 6 ? 2400 : 1200;
                        pXSprite.burnTime = Gameutils.ClipHigh(pXSprite.burnTime + 360, maxtime);
                        pXSprite.burnSource = pMissile.owner;
                    }
                }
                if (pMissile.extra <= 0) {
                    Actor.actPostSprite(pMissile.xvel, 1024);
                } else {
                    Actor.actPostSprite(pMissile.xvel, 0);
                    if (pMissile.ang == 1024) {
                        SOUND.sfxStart3DSound(pMissile, 307, -1, 0);
                    }
                    pMissile.lotag = 0;
                    SeqHandling.seqSpawn(9, 3, pMissile.extra, null);
                }
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 302: {
                SPRITE pEffect;
                Actor.actTeslaImpact(pMissile, hitInfo);
                if ((hitInfo == 0 || hitInfo == 4) && pWall != null && (pEffect = Actor.actSpawnEffect(52, pMissile.sectnum, pMissile.x, pMissile.y, pMissile.z, 0)) != null) {
                    pEffect.ang = (short)(Gameutils.GetWallAngle(nWall) + 512 & 0x7FF);
                }
                Gib.actGenerateGibs(pMissile, 24, null, null);
                Actor.actPostSprite(pMissile.xvel, 1024);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 309: {
                SeqHandling.seqKill(3, pMissile.extra);
                if (hitInfo == 3 && pSprite != null && (pThingInfo != null || pDudeInfo != null)) {
                    Actor.actDamageSprite(Actor.actGetOwner(pMissile), pSprite, 2, 16 * Gameutils.Random(7) + 240);
                }
                Actor.actPostSprite(pMissile.xvel, 1024);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 311: {
                SOUND.sfxKill3DSound(pMissile, -1, -1);
                SOUND.sfxCreate3DSound(pMissile.x, pMissile.y, pMissile.z, 306, pMissile.sectnum);
                Gib.actGenerateGibs(pMissile, 6, null, null);
                if (hitInfo == 3 && pSprite != null && (pThingInfo != null || pDudeInfo != null)) {
                    Actor.actDamageSprite(Actor.actGetOwner(pMissile), pSprite, 5, 16 * Gameutils.Random(20) + 400);
                }
                Actor.actPostSprite(pMissile.xvel, 1024);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 316: 
            case 317: {
                SOUND.sfxKill3DSound(pMissile, -1, -1);
                SOUND.sfxCreate3DSound(pMissile.x, pMissile.y, pMissile.z, 306, pMissile.sectnum);
                if (hitInfo == 3 && pSprite != null && (pThingInfo != null || pDudeInfo != null)) {
                    int damage = 3;
                    if (pMissile.lotag == 317) {
                        damage = 6;
                    }
                    Actor.actDamageSprite(Actor.actGetOwner(pMissile), pSprite, 5, 16 * (Gameutils.Random(damage) + damage));
                }
                Actor.actPostSprite(pMissile.xvel, 1024);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 305: 
            case 312: {
                if (hitInfo == 3 && pSprite != null && (pThingInfo != null || pDudeInfo != null)) {
                    if (pThingInfo != null && pSprite.lotag == 400 && pXSprite.burnTime == 0) {
                        EVENT.evPostCallback(pSprite.xvel, 3, 0L, 0);
                    }
                    Actor.actDamageSprite(Actor.actGetOwner(pMissile), pSprite, 2, 16 * Gameutils.Random(50) + 800);
                }
                Actor.actExplodeSprite(pMissile.xvel);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 303: {
                SOUND.sfxKill3DSound(pMissile, -1, -1);
                Actor.actExplodeSprite(pMissile.xvel);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 301: {
                SOUND.sfxKill3DSound(pMissile, -1, -1);
                if (hitInfo != 3 || pSprite == null) {
                    Gib.actGenerateGibs(pMissile, 17, null, null);
                    Actor.actPostSprite(pMissile.xvel, 1024);
                    pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                    return;
                }
                if (pThingInfo != null || pDudeInfo != null) {
                    if (pThingInfo != null && pThingInfo.damageShift[1] != 0 || pDudeInfo != null && pDudeInfo.damageShift[1] != 0) {
                        if (pThingInfo != null && pSprite.lotag == 400 && pXSprite.burnTime == 0) {
                            EVENT.evPostCallback(nSprite, 3, 0L, 0);
                        }
                        int maxtime = Engine.sprite[pXSprite.reference].statnum == 6 ? 2400 : 1200;
                        pXSprite.burnTime = Gameutils.ClipHigh(pXSprite.burnTime + 480, maxtime);
                        pXSprite.burnSource = pMissile.owner;
                        Actor.actDistanceDamage(Actor.actGetOwner(pMissile), pMissile.x, pMissile.y, pMissile.z, pMissile.sectnum, 16, 20, 2, 10, 6, 480);
                    } else {
                        Actor.actDamageSprite(Actor.actGetOwner(pMissile), pSprite, 2, 16 * Gameutils.Random(10) + 320);
                    }
                }
                if (Main.game.getCurrentDef().surfType[pSprite.picnum] == 4) {
                    pMissile.picnum = (short)2123;
                    pXMissile.target = nSprite;
                    pXMissile.targetZ = pMissile.z - pSprite.z;
                    short nAngle = Main.engine.getangle(pMissile.x - pSprite.x, pMissile.y - pSprite.y);
                    pXMissile.goalAng = (short)(nAngle - pSprite.ang & 0x7FF);
                    pXMissile.state = 1;
                    Actor.actPostSprite(pMissile.xvel, 14);
                    pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                    break;
                }
                Gib.actGenerateGibs(pMissile, 17, null, null);
                Actor.actPostSprite(pMissile.xvel, 1024);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 304: 
            case 308: {
                if (hitInfo != 3) {
                    pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                    return;
                }
                if (Engine.pHitInfo.hitsprite < 0 || Engine.pHitInfo.hitsprite >= Globals.kMaxSprites) {
                    Main.game.dassert("nObject >= 0 && nObject < kMaxSprites");
                }
                SPRITE pHit = Engine.sprite[Engine.pHitInfo.hitsprite];
                if (pHit.extra <= 0) {
                    pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                    return;
                }
                XSPRITE pXHit = DB.xsprite[pHit.extra];
                if ((pHit.statnum == 4 || pHit.statnum == 6) && pXHit.burnTime == 0) {
                    EVENT.evPostCallback(Engine.pHitInfo.hitsprite, 3, 0L, 0);
                }
                int maxtime = Engine.sprite[pXHit.reference].statnum == 6 ? 2400 : 1200;
                pXHit.burnTime = Gameutils.ClipHigh(pXHit.burnTime + (4 * Globals.pGameInfo.nDifficulty + 16), maxtime);
                pXHit.burnSource = pMissile.owner;
                Actor.actDamageSprite(Actor.actGetOwner(pMissile), pHit, 1, 8);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 313: {
                Actor.actExplodeSprite(pMissile.xvel);
                if (hitInfo == 3) {
                    if (Engine.pHitInfo.hitsprite < 0 || Engine.pHitInfo.hitsprite >= Globals.kMaxSprites) {
                        Main.game.dassert("nObject >= 0 && nObject < kMaxSprites");
                    }
                    SPRITE pHit = Engine.sprite[Engine.pHitInfo.hitsprite];
                    if (pHit.extra > 0) {
                        XSPRITE pXHit = DB.xsprite[pHit.extra];
                        if ((pHit.statnum == 4 || pHit.statnum == 6) && pXHit.burnTime == 0) {
                            EVENT.evPostCallback(Engine.pHitInfo.hitsprite, 3, 0L, 0);
                        }
                        int maxtime = Engine.sprite[pXHit.reference].statnum == 6 ? 2400 : 1200;
                        pXHit.burnTime = Gameutils.ClipHigh(pXHit.burnTime + (4 * Globals.pGameInfo.nDifficulty + 16), maxtime);
                        pXHit.burnSource = pMissile.owner;
                        Actor.actDamageSprite(Actor.actGetOwner(pMissile), pHit, 1, 8);
                        Actor.actDamageSprite(Actor.actGetOwner(pMissile), pHit, 2, 16 * Gameutils.Random(10) + 400);
                    }
                }
                Actor.actExplodeSprite(pMissile.xvel);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 314: {
                Actor.actExplodeSprite(pMissile.xvel);
                if (hitInfo == 3) {
                    if (Engine.pHitInfo.hitsprite < 0 || Engine.pHitInfo.hitsprite >= Globals.kMaxSprites) {
                        Main.game.dassert("nObject >= 0 && nObject < kMaxSprites");
                    }
                    SPRITE pHit = Engine.sprite[Engine.pHitInfo.hitsprite];
                    if (pHit.extra > 0) {
                        XSPRITE pXHit = DB.xsprite[pHit.extra];
                        if ((pHit.statnum == 4 || pHit.statnum == 6) && pXHit.burnTime == 0) {
                            EVENT.evPostCallback(Engine.pHitInfo.hitsprite, 3, 0L, 0);
                        }
                        int maxtime = Engine.sprite[pXHit.reference].statnum == 6 ? 2400 : 1200;
                        pXHit.burnTime = Gameutils.ClipHigh(pXHit.burnTime + 32, maxtime);
                        pXHit.burnSource = pMissile.owner;
                        Actor.actDamageSprite(Actor.actGetOwner(pMissile), pHit, 5, 12);
                        Actor.actDamageSprite(Actor.actGetOwner(pMissile), pHit, 2, 16 * Gameutils.Random(10) + 400);
                    }
                }
                Actor.actExplodeSprite(pMissile.xvel);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 307: {
                SOUND.sfxKill3DSound(pMissile, -1, -1);
                SOUND.sfxCreate3DSound(pMissile.x, pMissile.y, pMissile.z, 522, pMissile.sectnum);
                Actor.actPostSprite(pMissile.xvel, 15);
                SeqHandling.seqSpawn(20, 3, pMissile.extra, null);
                if (hitInfo != 3) {
                    pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                    return;
                }
                if (Engine.pHitInfo.hitsprite < 0 || Engine.pHitInfo.hitsprite >= Globals.kMaxSprites) {
                    Main.game.dassert("nObject >= 0 && nObject < kMaxSprites");
                }
                SPRITE pHit = Engine.sprite[Engine.pHitInfo.hitsprite];
                if (pHit.statnum != 6) {
                    pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                    return;
                }
                Actor.actDamageSprite(Actor.actGetOwner(pMissile), pHit, 5, 16 * Gameutils.Random(10) + 400);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 300: {
                Actor.actPostSprite(pMissile.xvel, 15);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFFEF);
                pMissile.lotag = 0;
                SeqHandling.seqSpawn(20, 3, pMissile.extra, null);
                if (hitInfo != 3) {
                    pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                    return;
                }
                if (Engine.pHitInfo.hitsprite < 0 || Engine.pHitInfo.hitsprite >= Globals.kMaxSprites) {
                    Main.game.dassert("nObject >= 0 && nObject < kMaxSprites");
                }
                SPRITE pHit = Engine.sprite[Engine.pHitInfo.hitsprite];
                if (pHit.statnum != 6) {
                    pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                    return;
                }
                Actor.actDamageSprite(Actor.actGetOwner(pMissile), pHit, 5, 16 * Gameutils.Random(10) + 160);
                int nOwner = Actor.actGetOwner(pMissile);
                if (DEMO.IsOriginalDemo()) {
                    if (nOwner != -1) {
                        pHit = Engine.sprite[nOwner];
                        if (DB.xsprite[pHit.extra].health != 0) {
                            Actor.actHealDude(DB.xsprite[pHit.extra], 10, DudeInfo.dudeInfo[pHit.lotag - 200].startHealth);
                        }
                    }
                } else if (nOwner != -1) {
                    int lotag;
                    pHit = Engine.sprite[nOwner];
                    if (pHit.extra >= 0 && DB.xsprite[pHit.extra].health != 0 && Actor.IsDudeSprite(Engine.sprite[pHit.xvel]) && (lotag = pHit.lotag - 200) >= 200) {
                        Actor.actHealDude(DB.xsprite[pHit.extra], 10, DudeInfo.dudeInfo[lotag].startHealth);
                    }
                }
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            case 306: {
                SOUND.sfxKill3DSound(pMissile, -1, -1);
                SOUND.sfxCreate3DSound(pMissile.x, pMissile.y, pMissile.z, 518, pMissile.sectnum);
                if (hitInfo == 2) {
                    Gib.actGenerateGibs(pMissile, 23, null, null);
                } else {
                    Gib.actGenerateGibs(pMissile, 22, null, null);
                }
                EVENT.checkEventList(pMissile.xvel, 3);
                SeqHandling.seqKill(3, pMissile.extra);
                Actor.actPostSprite(pMissile.xvel, 1024);
                if (hitInfo != 3) {
                    pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                    return;
                }
                if (Engine.pHitInfo.hitsprite < 0 || Engine.pHitInfo.hitsprite >= Globals.kMaxSprites) {
                    Main.game.dassert("nObject >= 0 && nObject < kMaxSprites");
                }
                SPRITE pHit = Engine.sprite[Engine.pHitInfo.hitsprite];
                Actor.actDamageSprite(Actor.actGetOwner(pMissile), pHit, 6, 16 * Gameutils.Random(10) + 240);
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
                break;
            }
            default: {
                SeqHandling.seqKill(3, pMissile.extra);
                Actor.actPostSprite(pMissile.xvel, 1024);
                if (hitInfo == 3) {
                    if (Engine.pHitInfo.hitsprite < 0 || Engine.pHitInfo.hitsprite >= Globals.kMaxSprites) {
                        Main.game.dassert("nObject >= 0 && nObject < kMaxSprites");
                    }
                    Actor.actDamageSprite(Actor.actGetOwner(pMissile), Engine.sprite[Engine.pHitInfo.hitsprite], 0, 16 * Gameutils.Random(10) + 160);
                }
                pMissile.cstat = (short)(pMissile.cstat & 0xFFFFFEFE);
            }
        }
    }

    public static void actHitInfo(int hitType, Hitscan pHitInfo) {
        if (pHitInfo == null) {
            Main.game.dassert("pHitInfo != NULL");
        }
        info_nSprite = -1;
        info_pSprite = null;
        info_pXSprite = null;
        info_nWall = -1;
        info_pWall = null;
        info_pXWall = null;
        info_nSector = -1;
        info_pSector = null;
        info_pXSector = null;
        switch (hitType) {
            case 3: 
            case 5: {
                info_nSprite = pHitInfo.hitsprite;
                if (info_nSprite < 0 || info_nSprite >= Globals.kMaxSprites) {
                    Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
                }
                info_pSprite = Engine.sprite[info_nSprite];
                if (Actor.info_pSprite.extra <= 0) break;
                info_pXSprite = DB.xsprite[Actor.info_pSprite.extra];
                break;
            }
            case 0: 
            case 4: {
                info_nWall = pHitInfo.hitwall;
                if (info_nWall < 0 || info_nWall >= Globals.kMaxWalls) {
                    Main.game.dassert("nWall >= 0 && nWall < kMaxWalls");
                }
                info_pWall = Engine.wall[info_nWall];
                if (Actor.info_pWall.extra <= 0) break;
                info_pXWall = DB.xwall[Actor.info_pWall.extra];
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                info_nSector = pHitInfo.hitsect;
                if (info_nSector < 0 || info_nSector >= Globals.kMaxSectors) {
                    Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                }
                info_pSector = Engine.sector[info_nSector];
                if (Actor.info_pSector.extra <= 0) break;
                info_pXSector = DB.xsector[Actor.info_pSector.extra];
                break;
            }
        }
    }

    public static void MoveThing(int nSprite) {
        int warp;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nXSprite = pSprite.extra;
        if (nXSprite <= 0 || nXSprite >= 2048) {
            Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
        }
        XSPRITE pXSprite = DB.xsprite[nXSprite];
        if (pSprite.lotag < 400 || pSprite.lotag >= 436) {
            Main.game.dassert("pSprite.type >= kThingBase && pSprite.type < kThingMax");
        }
        THINGINFO pThinkInfo = thingInfo[pSprite.lotag - 400];
        short nSector = pSprite.sectnum;
        if (nSector < 0 || nSector >= Globals.kMaxSectors) {
            Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
        }
        Gameutils.GetSpriteExtents(pSprite);
        int zTop = Gameutils.extents_zTop;
        int zBot = Gameutils.extents_zBot;
        int moveHit = 0;
        int floorDist = (zBot - pSprite.z) / 4;
        int ceilDist = (pSprite.z - zTop) / 4;
        int clipDist = pSprite.clipdist << 2;
        if (sprXVel[pSprite.xvel] != 0L || sprYVel[pSprite.xvel] != 0L) {
            int nHitObject;
            short oldcstat = pSprite.cstat;
            pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
            moveHit = Actor.gSpriteHit[nXSprite].moveHit = Gameutils.ClipMove(pSprite.x, pSprite.y, pSprite.z, nSector, sprXVel[pSprite.xvel] >> 12, sprYVel[pSprite.xvel] >> 12, clipDist, ceilDist, floorDist, 65537);
            pSprite.x = Gameutils.clipm_px;
            pSprite.y = Gameutils.clipm_py;
            pSprite.z = Gameutils.clipm_pz;
            nSector = (short)Gameutils.clipm_pnsectnum;
            pSprite.cstat = oldcstat;
            if (nSector < 0) {
                Main.game.dassert("nSector >= 0");
            }
            if (pSprite.sectnum != nSector) {
                if (nSector < 0) {
                    Main.game.dassert("nSector >= 0");
                }
                DB.changespritesect(pSprite.xvel, nSector);
            }
            if ((nHitObject = Actor.gSpriteHit[nXSprite].moveHit & 0xE000) == 32768) {
                int nWall = moveHit & 0x1FFF;
                Actor.ReflectVector(sprXVel[pSprite.xvel], sprYVel[pSprite.xvel], nWall, pThinkInfo.nFraction);
                Actor.sprXVel[pSprite.xvel] = refl_x;
                Actor.sprYVel[pSprite.xvel] = refl_y;
                if (pSprite.lotag == 415) {
                    SOUND.sfxStart3DSound(pSprite, 374, 0, 0);
                } else if (pSprite.lotag == 427) {
                    SOUND.sfxStart3DSound(pSprite, 607, 0, 0);
                    Actor.actDamageSprite(-1, pSprite, 0, 80);
                }
            }
        } else {
            if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
            }
            Gameutils.FindSector(pSprite.x, pSprite.y, pSprite.z, nSector);
            nSector = Gameutils.foundSector;
        }
        if (sprZVel[pSprite.xvel] != 0L) {
            pSprite.z = (int)((long)pSprite.z + (sprZVel[pSprite.xvel] >> 8));
        }
        Gameutils.GetZRange(pSprite, clipDist, 65537);
        int ceilz = Gameutils.gz_ceilZ;
        int ceilhit = Gameutils.gz_ceilHit;
        int floorz = Gameutils.gz_floorZ;
        int floorhit = Gameutils.gz_floorHit;
        Gameutils.GetSpriteExtents(pSprite);
        zTop = Gameutils.extents_zTop;
        zBot = Gameutils.extents_zBot;
        if ((pSprite.hitag & 2) != 0 && zBot < floorz) {
            pSprite.z += 455;
            short s = pSprite.xvel;
            sprZVel[s] = sprZVel[s] + 58254L;
            if (pSprite.lotag == 427) {
                SPRITE pSpawn = null;
                pSpawn = Actor.actSpawnEffect(27, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0);
                if (pSpawn != null) {
                    int xvel = 279620;
                    int yvel = 0;
                    int zvel = 0;
                    Trig.RotateVector(xvel, yvel, 11 * Globals.gFrameClock & 0x7FF);
                    xvel = (int)Trig.rotated.x;
                    yvel = (int)Trig.rotated.y;
                    Trig.RotateVector(xvel, zvel, 5 * Globals.gFrameClock & 0x7FF);
                    xvel = (int)Trig.rotated.x;
                    zvel = (int)Trig.rotated.y;
                    Trig.RotateVector(yvel, zvel, 3 * Globals.gFrameClock & 0x7FF);
                    yvel = (int)Trig.rotated.x;
                    zvel = (int)Trig.rotated.y;
                    Actor.sprXVel[pSpawn.xvel] = (long)xvel + sprXVel[pSprite.xvel];
                    Actor.sprYVel[pSpawn.xvel] = (long)yvel + sprYVel[pSprite.xvel];
                    Actor.sprZVel[pSpawn.xvel] = (long)zvel + sprZVel[pSprite.xvel];
                }
            }
        }
        if ((warp = Warp.checkWarping(pSprite)) != 0) {
            Gameutils.GetZRange(pSprite, clipDist, 65537);
            ceilz = Gameutils.gz_ceilZ;
            ceilhit = Gameutils.gz_ceilHit;
            floorz = Gameutils.gz_floorZ;
            floorhit = Gameutils.gz_floorHit;
        }
        Gameutils.GetSpriteExtents(pSprite);
        zTop = Gameutils.extents_zTop;
        zBot = Gameutils.extents_zBot;
        if (!(DEMO.IsOriginalDemo() || pSprite.lotag != 419 && pSprite.lotag != 420 || (floorhit & 0xE000) != 49152 || (Engine.sprite[floorhit & 0x1FFF].cstat & 0x30) != 32 || Pragmas.klabs(zBot - floorz) >= 1024)) {
            floorz -= 1024;
        }
        if (floorz > zBot) {
            Actor.gSpriteHit[nXSprite].floorHit = 0;
            if ((pSprite.hitag & 2) != 0) {
                pSprite.hitag = (short)(pSprite.hitag | 4);
            }
        } else {
            Actor.processTouchFloor(pSprite, pSprite.sectnum);
            Actor.gSpriteHit[nXSprite].floorHit = floorhit;
            pSprite.z += floorz - zBot;
            int dZvel = (int)(sprZVel[pSprite.xvel] - floorVel[pSprite.sectnum]);
            if (dZvel <= 0) {
                if (sprZVel[pSprite.xvel] == 0L) {
                    pSprite.hitag = (short)(pSprite.hitag & 0xFFFFFFFB);
                }
            } else {
                pSprite.hitag = (short)(pSprite.hitag | 4);
                long gravity = Actor.GravityVector(sprXVel[pSprite.xvel], sprYVel[pSprite.xvel], dZvel, pSprite.sectnum, pThinkInfo.nFraction);
                int fallDamage = Pragmas.mulscale(gravity, gravity, 30) - pThinkInfo.fallDamage;
                Actor.sprXVel[pSprite.xvel] = refl_x;
                Actor.sprYVel[pSprite.xvel] = refl_y;
                dZvel = (int)refl_z;
                if (fallDamage > 0) {
                    Actor.actDamageSprite(pSprite.xvel, pSprite, 0, fallDamage);
                }
                Actor.sprZVel[pSprite.xvel] = dZvel;
                if (floorVel[pSprite.sectnum] == 0L && Pragmas.klabs(dZvel) < 65536) {
                    Actor.sprZVel[pSprite.xvel] = 0L;
                    pSprite.hitag = (short)(pSprite.hitag & 0xFFFFFFFB);
                }
                switch (pSprite.lotag) {
                    case 428: {
                        if (sprZVel[pSprite.xvel] != 0L && !Gameutils.Chance(20480)) break;
                        Actor.actNapalm2Explode(pSprite, pXSprite);
                        break;
                    }
                    case 415: {
                        if (Pragmas.klabs(sprZVel[pSprite.xvel]) <= 524288L) break;
                        SOUND.sfxStart3DSound(pSprite, 374, 0, 0);
                        break;
                    }
                    case 427: {
                        if (Pragmas.klabs(sprZVel[pSprite.xvel]) <= 524288L) break;
                        SOUND.sfxStart3DSound(pSprite, 607, 0, 0);
                        Actor.actDamageSprite(-1, pSprite, 0, 80);
                    }
                }
                moveHit = nSector | 0x4000;
            }
        }
        if (ceilz < zTop) {
            Actor.gSpriteHit[nXSprite].ceilHit = 0;
        } else {
            Actor.gSpriteHit[nXSprite].ceilHit = ceilhit;
            if (ceilz - zTop > 0) {
                pSprite.z += ceilz - zTop;
            }
            if (sprZVel[pSprite.xvel] < 0L) {
                Actor.sprXVel[pSprite.xvel] = Pragmas.mulscale(49152L, sprXVel[pSprite.xvel], 16);
                Actor.sprYVel[pSprite.xvel] = Pragmas.mulscale(49152L, sprYVel[pSprite.xvel], 16);
                Actor.sprZVel[pSprite.xvel] = Pragmas.mulscale(16384L, -sprZVel[pSprite.xvel], 16);
                switch (pSprite.lotag) {
                    case 415: {
                        if (Pragmas.klabs(sprZVel[pSprite.xvel]) <= 524288L) break;
                        SOUND.sfxStart3DSound(pSprite, 374, 0, 0);
                        break;
                    }
                    case 427: {
                        if (Pragmas.klabs(sprZVel[pSprite.xvel]) <= 524288L) break;
                        SOUND.sfxStart3DSound(pSprite, 607, 0, 0);
                        Actor.actDamageSprite(-1, pSprite, 0, 80);
                    }
                }
            }
        }
        if (zBot >= floorz) {
            int moveDist;
            int oldDist = moveDist = (int)Main.engine.qdist(sprXVel[pSprite.xvel], sprYVel[pSprite.xvel]);
            if (moveDist > 69905) {
                moveDist = 69905;
            }
            if ((floorhit & 0xE000) == 49152) {
                int nUnderSprite = floorhit & 0x1FFF;
                if ((Engine.sprite[nUnderSprite].cstat & 0x30) == 0) {
                    short s = pSprite.xvel;
                    sprXVel[s] = sprXVel[s] + (long)Pragmas.mulscale(Globals.kFrameTicks, pSprite.x - Engine.sprite[nUnderSprite].x, 2);
                    short s2 = pSprite.xvel;
                    sprYVel[s2] = sprYVel[s2] + (long)Pragmas.mulscale(Globals.kFrameTicks, pSprite.y - Engine.sprite[nUnderSprite].y, 2);
                    moveHit = Actor.gSpriteHit[nXSprite].moveHit;
                }
            }
            if (moveDist > 0) {
                int kv = Pragmas.divscale(moveDist, oldDist, 16);
                short s = pSprite.xvel;
                sprXVel[s] = sprXVel[s] - (long)Pragmas.mulscale(sprXVel[pSprite.xvel], kv, 16);
                short s3 = pSprite.xvel;
                sprYVel[s3] = sprYVel[s3] - (long)Pragmas.mulscale(sprYVel[pSprite.xvel], kv, 16);
            }
        }
        if (sprXVel[pSprite.xvel] != 0L || sprYVel[pSprite.xvel] != 0L) {
            pSprite.ang = Main.engine.getangle((int)sprXVel[pSprite.xvel], (int)sprYVel[pSprite.xvel]);
        }
        if (moveHit != 0 && pSprite.extra != 0) {
            if (pXSprite.Impact) {
                Trigger.trTriggerSprite(pSprite.xvel, pXSprite, 0);
            }
            switch (pSprite.lotag) {
                case 434: {
                    SeqHandling.seqSpawn(24, 3, nXSprite, null);
                    if ((moveHit & 0xE000) != 49152) break;
                    pSprite.xrepeat = (short)32;
                    pSprite.yrepeat = (short)32;
                    int nObject = moveHit & 0x1FFF;
                    if (nObject < 0 || nObject >= Globals.kMaxSprites) {
                        Main.game.dassert("nObject >= 0 && nObject < kMaxSprites");
                    }
                    Actor.actDamageSprite(Actor.actGetOwner(pSprite), Engine.sprite[nObject], 0, pXSprite.data1);
                    break;
                }
                case 421: {
                    SeqHandling.seqSpawn(24, 3, nXSprite, null);
                    if ((moveHit & 0xE000) != 49152) break;
                    int nObject = moveHit & 0x1FFF;
                    if (nObject < 0 || nObject >= Globals.kMaxSprites) {
                        Main.game.dassert("nObject >= 0 && nObject < kMaxSprites");
                    }
                    Actor.actDamageSprite(Actor.actGetOwner(pSprite), Engine.sprite[nObject], 0, 12);
                    break;
                }
                case 423: 
                case 424: {
                    pSprite.z -= 1024;
                    pSprite.hitag = (short)(pSprite.hitag & 0xFFFFFFFD);
                    byte surfType = Main.game.getCurrentDef().GetSurfType(Actor.gSpriteHit[nXSprite].floorHit);
                    if (pSprite.lotag == 423) {
                        if (surfType == 5) {
                            SeqHandling.seqSpawn(6, 3, nXSprite, null);
                            SOUND.sfxStart3DSound(pSprite, 356, -1, 0);
                        } else {
                            SeqHandling.seqSpawn(7, 3, nXSprite, null);
                            SOUND.sfxStart3DSound(pSprite, 354, -1, 0);
                        }
                    }
                    if (pSprite.lotag != 424) break;
                    SeqHandling.seqSpawn(8, 3, nXSprite, null);
                    SOUND.sfxStart3DSound(pSprite, 354, -1, 0);
                    break;
                }
                case 429: {
                    Actor.actExplodeSprite(pSprite.xvel);
                    break;
                }
                case 430: {
                    int nObject;
                    if ((moveHit & 0xE000) == 16384) {
                        Actor.actDistanceDamage(Actor.actGetOwner(pSprite), pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, 200, 1, 3, 20, 6, 0);
                    } else if ((DEMO.IsOriginalDemo() || (moveHit & 0xE000) == 49152) && (nObject = moveHit & 0x1FFF) >= 0 && nObject < Globals.kMaxSprites) {
                        Actor.actDamageSprite(Actor.actGetOwner(pSprite), Engine.sprite[nObject], 0, 12);
                    }
                    EVENT.evPostCallback(pSprite.xvel, 3, 0L, 19);
                }
            }
        }
    }

    public static int actSetOwner(SPRITE pTarget, SPRITE pSource) {
        if (pTarget == null || pSource == null) {
            Main.game.dassert("pTarget != NULL && pSource != NULL");
        }
        int killerid = Gameutils.IsPlayerSprite(pSource) ? pSource.lotag - 231 | 0x1000 : pSource.xvel;
        pTarget.owner = (short)killerid;
        return killerid;
    }

    public static int actGetOwner(SPRITE pSprite) {
        if (pSprite == null) {
            Main.game.dassert("pSprite != null");
        }
        if (pSprite.owner == -1) {
            return -1;
        }
        int result = pSprite.owner & 0xFFF;
        if ((pSprite.owner & 0x1000) != 0) {
            result = Globals.gPlayer[result].pSprite.xvel;
        }
        return result;
    }

    public static int actDamageSprite(int nSource, SPRITE pSprite, int nDamageType, int nDamage) {
        if (nSource >= Globals.kMaxSprites) {
            Main.game.dassert("nSource < kMaxSprites " + nSource);
        }
        if ((pSprite.hitag & 0x20) != 0) {
            return 0;
        }
        short nXSprite = pSprite.extra;
        if (nXSprite <= 0) {
            return 0;
        }
        if (nXSprite <= 0 || nXSprite >= 2048) {
            Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
        }
        XSPRITE pXSprite = DB.xsprite[nXSprite];
        if (pXSprite.reference != pSprite.xvel) {
            Main.game.dassert("pXSprite.reference == pSprite.index");
        }
        if (pXSprite.health == 0 && pSprite.statnum != 6 || pXSprite.Locked != 0) {
            return 0;
        }
        if (nSource == -1) {
            nSource = pSprite.xvel;
        }
        PLAYER pPlayer = null;
        if (Gameutils.IsPlayerSprite(Engine.sprite[nSource])) {
            pPlayer = Globals.gPlayer[Engine.sprite[nSource].lotag - 231];
        }
        switch (pSprite.statnum) {
            case 4: {
                int nShift;
                if (pSprite.lotag < 400 || pSprite.lotag >= 436) {
                    Main.game.dassert("pSprite.type >= kThingBase && pSprite.type < kThingMax");
                }
                if ((nShift = Actor.thingInfo[pSprite.lotag - 400].damageShift[nDamageType]) == 0) {
                    return 0;
                }
                if (nShift != 256) {
                    nDamage = Pragmas.mulscale(nShift, nDamage, 8);
                }
                pXSprite.health = Gameutils.ClipLow(pXSprite.health - nDamage, 0);
                if (pXSprite.health != 0) {
                    return nDamage >> 4;
                }
                if (pSprite.lotag == 431) {
                    Gib.actGenerateGibs(pSprite, 14, null, null);
                    pXSprite.data1 = 0;
                    pXSprite.data2 = 0;
                    pXSprite.data3 = 0;
                    pXSprite.data4 = 0;
                    pXSprite.stateTimer = 0;
                    pXSprite.isTriggered = false;
                    pXSprite.DudeLockout = false;
                } else if ((pSprite.hitag & 0x10) == 0) {
                    Actor.actSetOwner(pSprite, Engine.sprite[nSource]);
                }
                Trigger.trTriggerSprite(pSprite.xvel, pXSprite, 0);
                switch (pSprite.lotag) {
                    case 407: {
                        SeqHandling.seqSpawn(12, 3, pSprite.extra, null);
                        Gib.actGenerateGibs(pSprite, 6, null, null);
                        break;
                    }
                    case 410: {
                        SeqHandling.seqSpawn(15, 3, pSprite.extra, null);
                        break;
                    }
                    case 411: {
                        SeqHandling.seqSpawn(21, 3, pSprite.extra, null);
                        Gib.actGenerateGibs(pSprite, 4, null, null);
                        break;
                    }
                    case 412: {
                        switch (pXSprite.data1) {
                            case 0: {
                                SeqHandling.seqSpawn(25, 3, pSprite.extra, SeqHandling.callbacks[5]);
                                SOUND.sfxStart3DSound(pSprite, 351, -1, 0);
                                break;
                            }
                            case 1: {
                                SeqHandling.seqSpawn(26, 3, pSprite.extra, SeqHandling.callbacks[5]);
                                SOUND.sfxStart3DSound(pSprite, 351, -1, 0);
                                break;
                            }
                            case -1: {
                                Gib.actGenerateGibs(pSprite, 14, null, null);
                                SOUND.sfxCreate3DSound(pSprite.x, pSprite.y, pSprite.z, 312, pSprite.sectnum);
                                Actor.actPostSprite(pSprite.xvel, 1024);
                            }
                        }
                        break;
                    }
                    case 413: {
                        SeqHandling.seqSpawn(28, 3, pSprite.extra, null);
                        break;
                    }
                    case 422: {
                        if (SeqHandling.seqFrame(3, pSprite.extra) >= 0) break;
                        SeqHandling.seqSpawn(19, 3, pSprite.extra, null);
                        break;
                    }
                    case 416: 
                    case 417: 
                    case 425: 
                    case 426: 
                    case 427: {
                        if (nDamageType != 3 || pPlayer == null || Globals.gFrameClock <= pPlayer.pLaughsCount || !Gameutils.Chance(8192)) break;
                        int sndId = PLAYER.gLaughs[Gameutils.Random(10)];
                        if (Globals.gPlayer[View.gViewIndex] == pPlayer) {
                            SOUND.sndStartSample(sndId, 255, 1, false);
                        } else {
                            SOUND.sfxStart3DSound(pPlayer.pSprite, sndId, 0, 0);
                        }
                        pPlayer.pLaughsCount = Globals.gFrameClock + 3600;
                    }
                }
                return nDamage >> 4;
            }
            case 6: {
                if (!Actor.IsDudeSprite(pSprite)) {
                    return 0;
                }
                int nShift = Gameutils.IsPlayerSprite(pSprite) && (!Actor.IsDudeSprite(Engine.sprite[nSource]) || pSprite.xvel == nSource) ? Pragmas.mulscale(Globals.gPlayer[pSprite.lotag - 231].pDudeInfo.startDamage[nDamageType], pPlayerShift[Globals.pGameInfo.nDifficulty], 8) : DudeInfo.dudeInfo[pSprite.lotag - 200].damageShift[nDamageType];
                if ((Globals.pGameInfo.nGameType == 1 || Globals.pGameInfo.nGameType == 3) && Gameutils.IsPlayerSprite(pSprite) && pPlayer != null && pSprite.xvel != nSource) {
                    if (Globals.pGameInfo.nGameType == 1) {
                        nShift = Globals.pGameInfo.nFriendlyFire;
                    } else if (pPlayer.teamID == Globals.gPlayer[pSprite.lotag - 231].teamID) {
                        nShift = Globals.pGameInfo.nFriendlyFire;
                    }
                }
                if (nShift == 0) {
                    return 0;
                }
                if (nShift != 256) {
                    nDamage = Pragmas.mulscale(nShift, nDamage, 8);
                }
                if (Gameutils.IsPlayerSprite(pSprite)) {
                    pPlayer = Globals.gPlayer[pSprite.lotag - 231];
                    if (pXSprite.health != 0 || PLAYER.checkPlayerSeq(pPlayer, VERSION.getPlayerSeq(12))) {
                        PLAYER.playerDamageSprite(pPlayer, nSource, nDamageType, nDamage);
                        return nDamage >> 4;
                    }
                    return nDamage >> 4;
                }
                if (pXSprite.health == 0) {
                    return 0;
                }
                nDamage = Ai.aiDamageSprite(pSprite, pXSprite, nSource, nDamageType, nDamage);
                if (pXSprite.health != 0) {
                    return nDamage >> 4;
                }
                if (nDamageType == 3 && nDamage < 160) {
                    nDamageType = 0;
                }
                Actor.actKillSprite(nSource, pSprite, nDamageType, nDamage);
                return nDamage >> 4;
            }
        }
        return 0;
    }

    public static void actKillSprite(int nSource, SPRITE pSprite, int nDamageType, int nDamage) {
        int i;
        if (!Actor.IsDudeSprite(pSprite)) {
            Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        int dudeIndex = pSprite.lotag - 200;
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[dudeIndex];
        short nSprite = pSprite.xvel;
        short nXSprite = pSprite.extra;
        if (nXSprite <= 0) {
            Main.game.dassert("nXSprite > 0");
        }
        XSPRITE pXSprite = DB.xsprite[pSprite.extra];
        if (pSprite.lotag == 227) {
            SeqHandling.seqSpawn(pDudeInfo.seqStartID + 1, 3, nXSprite, null);
            return;
        }
        if ((pSprite.lotag == 201 || pSprite.lotag == 202) && nDamageType == 1) {
            if (pXSprite.palette == 0) {
                pSprite.lotag = (short)240;
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[40].startHealth, DudeInfo.dudeInfo[40].startHealth);
                if (!DEMO.IsOriginalDemo() && pXSprite.burnTime == 0) {
                    pXSprite.burnTime = 1200;
                }
                Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 360;
                return;
            }
            nDamageType = 0;
        }
        if (pSprite.lotag == 251 && nDamageType == 1 && pXSprite.palette == 0) {
            pSprite.lotag = (short)253;
            Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[5]);
            Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[53].startHealth, DudeInfo.dudeInfo[53].startHealth);
            if (!DEMO.IsOriginalDemo() && pXSprite.burnTime == 0) {
                pXSprite.burnTime = 1200;
            }
            Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 360;
            return;
        }
        if (pSprite.lotag == 245 && nDamageType == 1 && pXSprite.palette == 0) {
            pSprite.lotag = (short)239;
            Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[0]);
            Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[39].startHealth, DudeInfo.dudeInfo[39].startHealth);
            if (!DEMO.IsOriginalDemo() && pXSprite.burnTime == 0) {
                pXSprite.burnTime = 1200;
            }
            Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 360;
            return;
        }
        if (pSprite.lotag == 254) {
            AIUNICULT.removeDudeStuff(pSprite);
            XSPRITE pXIncarnation = EVENT.getNextIncarnation(pXSprite);
            if (pXIncarnation == null) {
                if (pXSprite.data1 >= 459 && pXSprite.data1 < 467 && Gameutils.Chance(16384) && nDamageType != 5 && nDamageType != 4) {
                    AIUNICULT.doExplosion(pSprite, pXSprite.data1 - 459);
                    if (Gameutils.Chance(36864)) {
                        nDamageType = 3;
                    }
                }
                if (nDamageType == 1) {
                    if ((BuildGdx.cache.contains(pXSprite.data2 + 15, "SEQ") || BuildGdx.cache.contains(pXSprite.data2 + 16, "SEQ")) && pXSprite.palette == 0) {
                        if (BuildGdx.cache.contains(pXSprite.data2 + 3, "SEQ")) {
                            pSprite.lotag = (short)255;
                            if (pXSprite.data2 == 11520) {
                                pSprite.pal = 0;
                            }
                            Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[6]);
                            Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[55].startHealth, DudeInfo.dudeInfo[55].startHealth);
                            if (pXSprite.burnTime <= 0) {
                                pXSprite.burnTime = 1200;
                            }
                            Ai.aiClock[pSprite.xvel] = Globals.gFrameClock + 360;
                            return;
                        }
                    } else {
                        pXSprite.burnTime = 0;
                        pXSprite.burnSource = -1;
                        nDamageType = 0;
                    }
                }
            } else {
                int seqId = pXSprite.data2 + 18;
                AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 10);
                if (!BuildGdx.cache.contains(seqId, "SEQ")) {
                    SeqHandling.seqKill(3, nXSprite);
                    SPRITE pEffect = Actor.actSpawnEffect(52, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, pSprite.ang);
                    if (pEffect != null) {
                        pEffect.cstat = 0;
                        pEffect.pal = (short)6;
                        pEffect.xrepeat = pSprite.xrepeat;
                        pEffect.yrepeat = pSprite.yrepeat;
                    }
                    for (int i2 = 0; i2 < 3; ++i2) {
                        if (Gameutils.Chance(12288)) {
                            Gib.actGenerateGibs(pSprite, 6, null, null);
                            continue;
                        }
                        if (Gameutils.Chance(8192)) {
                            Gib.actGenerateGibs(pSprite, 5, null, null);
                            continue;
                        }
                        Gib.actGenerateGibs(pSprite, 17, null, null);
                    }
                    return;
                }
                SeqHandling.seqSpawn(seqId, 3, nXSprite, null);
                return;
            }
        }
        short i3 = Mmulti.connecthead;
        while (i3 >= 0) {
            if (nSprite == Globals.gPlayer[i3].fraggerID && Globals.gPlayer[i3].deathTime > 0) {
                Globals.gPlayer[i3].fraggerID = -1;
            }
            i3 = Mmulti.connectpoint2[i3];
        }
        if (pSprite.lotag != 249) {
            Trigger.trTriggerSprite(nSprite, pXSprite, 0);
        }
        pSprite.hitag = (short)(pSprite.hitag | 7);
        if (Gameutils.IsPlayerSprite(Engine.sprite[nSource]) && Globals.pGameInfo.nGameType == 1) {
            PLAYER pPlayer = Globals.gPlayer[Engine.sprite[nSource].lotag - 231];
            ++pPlayer.fragCount;
        }
        if (pXSprite.key > 0) {
            Actor.DropPickupObject(pSprite, 100 + pXSprite.key - 1);
        }
        if (pXSprite.dropMsg != 0) {
            Actor.DropPickupObject(pSprite, pXSprite.dropMsg);
            if (!DEMO.IsOriginalDemo()) {
                pXSprite.dropMsg = 0;
            }
        }
        if (pSprite.lotag == 201) {
            int nDropCheck = Gameutils.Random(100);
            if (nDropCheck >= 10) {
                if (nDropCheck < 50) {
                    Actor.DropPickupObject(pSprite, 69);
                }
            } else {
                Actor.DropPickupObject(pSprite, 42);
            }
        } else if (pSprite.lotag == 202) {
            int nDropCheck = Gameutils.Random(100);
            if (nDropCheck > 10) {
                if (nDropCheck <= 50) {
                    Actor.DropPickupObject(pSprite, 67);
                }
            } else {
                Actor.DropPickupObject(pSprite, 41);
            }
        }
        int deathType = 0;
        block0 : switch (nDamageType) {
            case 1: {
                deathType = 3;
                SOUND.sfxStart3DSound(pSprite, 351, -1, 0);
                break;
            }
            case 3: {
                deathType = 2;
                switch (pSprite.lotag) {
                    case 254: 
                    case 255: {
                        AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 4);
                        break;
                    }
                    case 201: 
                    case 202: 
                    case 230: 
                    case 239: 
                    case 240: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: {
                        SOUND.sfxStart3DSound(pSprite, 717, -1, 0);
                    }
                }
                break;
            }
            case 5: {
                switch (pSprite.lotag) {
                    case 203: 
                    case 205: {
                        deathType = 14;
                        break block0;
                    }
                    case 204: {
                        deathType = 11;
                        break block0;
                    }
                }
                deathType = 1;
                break;
            }
            default: {
                deathType = 1;
            }
        }
        if (!BuildGdx.cache.contains(pDudeInfo.seqStartID + deathType, "SEQ")) {
            System.out.println("sprite missing death sequence: deleted ");
            LEVELS.levelAddKills(pSprite);
            if (pSprite.owner != -1 && pSprite.owner != 32666) {
                int owner = Actor.actGetOwner(pSprite);
                switch (Engine.sprite[owner].lotag) {
                    case 254: {
                        int n = owner;
                        Ai.aiThinkTime[n] = Ai.aiThinkTime[n] - 1;
                        break;
                    }
                }
            }
            SeqHandling.seqKill(3, nXSprite);
            Actor.actPostSprite(nSprite, 1024);
            return;
        }
        switch (pSprite.lotag) {
            case 203: {
                SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1107, -1, 0);
                if (deathType == 2) {
                    SeqHandling.seqSpawn(pDudeInfo.seqStartID + 2, 3, nXSprite, SeqHandling.callbacks[10]);
                    Gameutils.GetSpriteExtents(pSprite);
                    Gib.startPos.set(pSprite.x, pSprite.y, Gameutils.extents_zTop);
                    Gib.startVel.set(sprXVel[pSprite.xvel] >> 1, sprYVel[pSprite.xvel] >> 1, -838860.0f);
                    Gib.actGenerateGibs(pSprite, 27, Gib.startPos, Gib.startVel);
                    break;
                }
                if (deathType != 1 || !Gameutils.Chance(8192)) {
                    if (deathType == 14) {
                        SeqHandling.seqSpawn(pDudeInfo.seqStartID + 14, 3, nXSprite, null);
                        break;
                    }
                    if (deathType == 3) {
                        SeqHandling.seqSpawn(pDudeInfo.seqStartID + 13, 3, nXSprite, SeqHandling.callbacks[11]);
                        break;
                    }
                    SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
                    break;
                }
                SeqHandling.seqSpawn(pDudeInfo.seqStartID + 7, 3, nXSprite, SeqHandling.callbacks[10]);
                EVENT.evPostCallback(pSprite.xvel, 3, 0L, 5);
                pXSprite.data1 = (short)35;
                pXSprite.data2 = (short)5;
                Gameutils.GetSpriteExtents(pSprite);
                Gib.startPos.set(pSprite.x, pSprite.y, Gameutils.extents_zTop);
                Gib.startVel.set(sprXVel[pSprite.xvel] >> 1, sprYVel[pSprite.xvel] >> 1, -1118481.0f);
                Gib.actGenerateGibs(pSprite, 27, Gib.startPos, Gib.startVel);
                SOUND.sfxStart3DSound(pSprite, 362, -1, 0);
                break;
            }
            case 201: 
            case 202: 
            case 247: 
            case 248: {
                SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1018, -1, 0);
                if (deathType == 3) {
                    SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[11]);
                    break;
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
                break;
            }
            case 240: {
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 718, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1018, -1, 0);
                }
                nDamageType = 3;
                if (Gameutils.Chance(16384)) {
                    for (i = 0; i < 3; ++i) {
                        Gib.actGenerateGibs(pSprite, 7, null, null);
                    }
                    if (VERSION.GAMEVER == 0) {
                        SeqHandling.seqSpawn(802 + Gameutils.Random(1), 3, nXSprite, SeqHandling.callbacks[10]);
                        break;
                    }
                    SeqHandling.seqSpawn(16 + pDudeInfo.seqStartID - Gameutils.Random(1), 3, nXSprite, SeqHandling.callbacks[10]);
                    break;
                }
                SeqHandling.seqSpawn(15 + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[11]);
                break;
            }
            case 254: {
                AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 2);
                if (deathType == 3) {
                    boolean seq15 = BuildGdx.cache.contains(pXSprite.data2 + 15, "SEQ");
                    boolean seq16 = BuildGdx.cache.contains(pXSprite.data2 + 16, "SEQ");
                    if (seq15 && seq16) {
                        SeqHandling.seqSpawn(15 + Gameutils.Random(2) + pXSprite.data2, 3, nXSprite, SeqHandling.callbacks[11]);
                    } else if (seq16) {
                        SeqHandling.seqSpawn(16 + pXSprite.data2, 3, nXSprite, SeqHandling.callbacks[11]);
                    } else if (seq15) {
                        SeqHandling.seqSpawn(15 + pXSprite.data2, 3, nXSprite, SeqHandling.callbacks[11]);
                    } else if (BuildGdx.cache.contains(pXSprite.data2 + deathType, "SEQ")) {
                        SeqHandling.seqSpawn(deathType + pXSprite.data2, 3, nXSprite, SeqHandling.callbacks[11]);
                    } else {
                        SeqHandling.seqKill(3, nXSprite);
                    }
                } else {
                    SeqHandling.seqSpawn(deathType + pXSprite.data2, 3, nXSprite, SeqHandling.callbacks[10]);
                }
                pXSprite.txID = 0;
                break;
            }
            case 255: {
                AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 4);
                nDamageType = 3;
                if (Gameutils.Chance(16384)) {
                    for (i = 0; i < 3; ++i) {
                        Gib.actGenerateGibs(pSprite, 7, null, null);
                    }
                }
                int seqId = pXSprite.data2;
                boolean seq15 = BuildGdx.cache.contains(pXSprite.data2 + 15, "SEQ");
                boolean seq16 = BuildGdx.cache.contains(pXSprite.data2 + 16, "SEQ");
                seqId = seq15 && seq16 ? (seqId += 15 + Gameutils.Random(2)) : (seq16 ? (seqId += 16) : (seqId += 15));
                SeqHandling.seqSpawn(seqId, 3, nXSprite, SeqHandling.callbacks[10]);
                break;
            }
            case 241: {
                if (Gameutils.Chance(16384) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 1109, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1107, -1, 0);
                }
                nDamageType = 3;
                if (Gameutils.Chance(16384)) {
                    SeqHandling.seqSpawn(13 + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
                    Gameutils.GetSpriteExtents(pSprite);
                    Gib.startPos.set(pSprite.x, pSprite.y, Gameutils.extents_zTop);
                    Gib.startVel.set(sprXVel[pSprite.xvel] >> 1, sprYVel[pSprite.xvel] >> 1, -838860.0f);
                    Gib.actGenerateGibs(pSprite, 27, Gib.startPos, Gib.startVel);
                    break;
                }
                SeqHandling.seqSpawn(13 + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[11]);
                break;
            }
            case 242: {
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 1206, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1204, -1, 0);
                }
                SeqHandling.seqSpawn(10 + DudeInfo.dudeInfo[4].seqStartID, 3, nXSprite, null);
                break;
            }
            case 239: {
                nDamageType = 3;
                SeqHandling.seqSpawn(7 + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
                break;
            }
            case 204: {
                if (deathType == 14) {
                    SOUND.sfxStart3DSound(pSprite, 1206, -1, 0);
                    SeqHandling.seqSpawn(11 + pDudeInfo.seqStartID, 3, nXSprite, null);
                    break;
                }
                SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1204, -1, 0);
                if (deathType != 3) {
                    SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                    break;
                }
                SeqHandling.seqSpawn(10 + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 206: {
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 1405, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1403, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 207: {
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 1455, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1453, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 210: {
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 1605, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1603, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 211: {
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 1305, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1303, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 212: {
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 1905, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1903, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 213: 
            case 214: 
            case 215: {
                if (pSprite.owner != -1) {
                    short s = Engine.sprite[Actor.actGetOwner((SPRITE)pSprite)].xvel;
                    Ai.aiThinkTime[s] = Ai.aiThinkTime[s] - 1;
                }
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 1805, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1803, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 216: {
                SOUND.sfxStart3DSound(pSprite, 1850, -1, 0);
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 217: {
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 1705, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1703, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 218: {
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 1505, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 1503, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 219: {
                if (Gameutils.Chance(8192) && deathType == 3) {
                    SOUND.sfxStart3DSound(pSprite, 2005, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 2003, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 220: {
                if (!Gameutils.Chance(8192) || deathType != 3) {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 2103, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, 2105, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 221: 
            case 225: 
            case 226: {
                if (!Gameutils.Chance(8192) || deathType != 3) {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 2203, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, 2205, -1, 0);
                }
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFF7);
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFB);
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 222: {
                if (nDamage == 5) {
                    SOUND.sfxStart3DSound(pSprite, 2171, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, 2172, -1, 0);
                }
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFF7);
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFB);
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 223: {
                if (nDamage == 5) {
                    SOUND.sfxStart3DSound(pSprite, 2151, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, 2152, -1, 0);
                }
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFF7);
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFB);
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 224: {
                SOUND.sfxStart3DSound(pSprite, 2501, -1, 0);
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFF7);
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFB);
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 227: 
            case 228: {
                if (!Gameutils.Chance(8192) || deathType != 3) {
                    SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 2305, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(pSprite, 2305, -1, 0);
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            default: {
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 229: {
                SOUND.sfxStart3DSound(pSprite, 2380, -1, 0);
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, null);
                break;
            }
            case 252: {
                nDamageType = 3;
                SeqHandling.seqSpawn(11 + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
                break;
            }
            case 251: {
                SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 9000, -1, 0);
                if (deathType == 3) {
                    SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[11]);
                    break;
                }
                SeqHandling.seqSpawn(deathType + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
                break;
            }
            case 253: {
                nDamageType = 3;
                SeqHandling.seqSpawn(12 + pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
            }
        }
        if (pSprite.owner != -1 && pSprite.owner != 32666) {
            int owner = Actor.actGetOwner(pSprite);
            switch (Engine.sprite[owner].lotag) {
                case 254: 
                case 255: {
                    int n = owner;
                    Ai.aiThinkTime[n] = Ai.aiThinkTime[n] - 1;
                    break;
                }
            }
        }
        if (nDamageType == 3) {
            for (i = 0; i < 3; ++i) {
                int nGibType = pDudeInfo.nGibType[i];
                if (nGibType <= -1) continue;
                Gib.actGenerateGibs(pSprite, nGibType, null, null);
            }
            for (int j = 0; j < 4; ++j) {
                Actor.actSpawnBlood(pSprite);
            }
        }
        LEVELS.levelAddKills(pSprite);
        Actor.actCheckRespawn(pSprite);
        if (nXSprite > 0 && !DEMO.IsOriginalDemo() && DB.xsprite[nXSprite].Proximity) {
            DB.xsprite[nXSprite].Proximity = false;
        }
        pSprite.lotag = (short)426;
        Actor.actPostSprite(nSprite, 4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void MoveDude(int nSprite) {
        int warp;
        int floorhit;
        int floorz;
        int ceilhit;
        int ceilz;
        short nSector;
        int clipDist;
        int floorDist;
        int zBot;
        int zTop;
        PLAYER pPlayer;
        XSPRITE pXSprite;
        SPRITE pSprite;
        block106: {
            int G;
            block108: {
                block109: {
                    boolean underwater;
                    block107: {
                        block105: {
                            block104: {
                                pSprite = Engine.sprite[nSprite];
                                short nXSprite = pSprite.extra;
                                pXSprite = DB.xsprite[nXSprite];
                                pPlayer = null;
                                if (Gameutils.IsPlayerSprite(pSprite)) {
                                    pPlayer = Globals.gPlayer[pSprite.lotag - 231];
                                }
                                if (pSprite.lotag < 200 || pSprite.lotag >= 256) {
                                    Main.game.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
                                }
                                DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
                                Gameutils.GetSpriteExtents(pSprite);
                                zTop = Gameutils.extents_zTop;
                                zBot = Gameutils.extents_zBot;
                                floorDist = (zBot - pSprite.z) / 4;
                                int ceilDist = (pSprite.z - zTop) / 4;
                                clipDist = pSprite.clipdist << 2;
                                nSector = pSprite.sectnum;
                                if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                                    Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                                }
                                if (sprXVel[pSprite.xvel] == 0L && sprYVel[pSprite.xvel] == 0L) break block104;
                                if (pPlayer != null && Globals.gNoClip) {
                                    pSprite.x = (int)((long)pSprite.x + (sprXVel[pSprite.xvel] >> 12));
                                    pSprite.y = (int)((long)pSprite.y + (sprYVel[pSprite.xvel] >> 12));
                                    if ((nSector = Main.engine.updatesector(pSprite.x, pSprite.y, nSector)) == -1) {
                                        nSector = pSprite.sectnum;
                                    }
                                } else {
                                    short oldcstat = pSprite.cstat;
                                    pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFF);
                                    Actor.gSpriteHit[nXSprite].moveHit = Gameutils.ClipMove(pSprite.x, pSprite.y, pSprite.z, nSector, sprXVel[pSprite.xvel] >> 12, sprYVel[pSprite.xvel] >> 12, clipDist, ceilDist, floorDist, 77825);
                                    pSprite.cstat = oldcstat;
                                    pSprite.x = Gameutils.clipm_px;
                                    pSprite.y = Gameutils.clipm_py;
                                    pSprite.z = Gameutils.clipm_pz;
                                    nSector = (short)Gameutils.clipm_pnsectnum;
                                    if (nSector == -1) {
                                        nSector = pSprite.sectnum;
                                        if (pSprite.statnum == 6 || pSprite.statnum == 4) {
                                            Actor.actDamageSprite(nSprite, pSprite, 0, 16000);
                                        }
                                    }
                                    if (Engine.sector[nSector].lotag >= 612 && Engine.sector[nSector].lotag <= 617) {
                                        int push = Main.engine.pushmove(pSprite.x, pSprite.y, pSprite.z, nSector, clipDist, ceilDist, floorDist, 65537);
                                        pSprite.x = Engine.pushmove_x;
                                        pSprite.y = Engine.pushmove_y;
                                        pSprite.z = Engine.pushmove_z;
                                        if (push == -1) {
                                            Actor.actDamageSprite(nSprite, pSprite, 0, 16000);
                                        }
                                        if (Engine.pushmove_sectnum != -1) {
                                            nSector = Engine.pushmove_sectnum;
                                        }
                                    }
                                    if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                                        Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                                    }
                                }
                                switch (Actor.gSpriteHit[nXSprite].moveHit & 0xE000) {
                                    case 32768: {
                                        XWALL pXWall;
                                        int nWall = Actor.gSpriteHit[nXSprite].moveHit & 0x1FFF;
                                        WALL pWall = Engine.wall[nWall];
                                        if (pWall.extra > 0 && (pXWall = DB.xwall[pWall.extra]) != null && pDudeInfo.lockOut && pXWall.triggerPush && pPlayer == null && pXWall.key == 0 && !pXWall.dudeLockout && pXWall.state == 0 && pXWall.busy == 0) {
                                            Trigger.trTriggerWall(nWall, pXWall, 50);
                                        }
                                        if (pWall.nextsector != -1) {
                                            SECTOR pSector = Engine.sector[pWall.nextsector];
                                            if (pSector.extra > 0) {
                                                XSECTOR pXSector = DB.xsector[pSector.extra];
                                                if (pDudeInfo.lockOut && pXSector.Wallpush && pXSector.Key == 0 && !pXSector.dudelockout && pXSector.state == 0 && pXSector.busy == 0 && pPlayer == null) {
                                                    Trigger.trTriggerSector(pWall.nextsector, pXSector, 40);
                                                }
                                            }
                                        }
                                        Actor.ReflectVector(sprXVel[pSprite.xvel], sprYVel[pSprite.xvel], nWall, 0);
                                        Actor.sprXVel[pSprite.xvel] = refl_x;
                                        Actor.sprYVel[pSprite.xvel] = refl_y;
                                        break;
                                    }
                                    case 49152: {
                                        int nHSprite = Actor.gSpriteHit[nXSprite].moveHit & 0x1FFF;
                                        SPRITE pHSprite = Engine.sprite[nHSprite];
                                        if (pHSprite.statnum == 5 && (pHSprite.hitag & 0x20) == 0 && Actor.actGetOwner(pHSprite) != pSprite.xvel) {
                                            short oldHitSect = Engine.pHitInfo.hitsect;
                                            short oldHitSprite = Engine.pHitInfo.hitsprite;
                                            int oldHitX = Engine.pHitInfo.hitx;
                                            int oldHitY = Engine.pHitInfo.hity;
                                            int oldHitZ = Engine.pHitInfo.hitz;
                                            Engine.pHitInfo.hitsprite = pSprite.xvel;
                                            Actor.actImpactMissile(pHSprite, 3);
                                            Engine.pHitInfo.hitsect = oldHitSect;
                                            Engine.pHitInfo.hitsprite = oldHitSprite;
                                            Engine.pHitInfo.hitx = oldHitX;
                                            Engine.pHitInfo.hity = oldHitY;
                                            Engine.pHitInfo.hitz = oldHitZ;
                                        }
                                        if (pHSprite.extra > 0) {
                                            XSPRITE pXHSprite = DB.xsprite[pHSprite.extra];
                                            if (pXHSprite == null) break;
                                            if (pXHSprite.Touch && !pXHSprite.isTriggered && (!pXHSprite.DudeLockout || Gameutils.IsPlayerSprite(pSprite))) {
                                                Trigger.trTriggerSprite(nHSprite, pXHSprite, 33);
                                            }
                                            if (!pDudeInfo.lockOut || !pXHSprite.Push || pXHSprite.key != 0 || pXHSprite.DudeLockout || pXHSprite.state != 0 || pXHSprite.busy != 0 || pPlayer != null) break;
                                            Trigger.trTriggerSprite(nHSprite, pXHSprite, 30);
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break block105;
                            }
                            if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                                Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                            }
                            Gameutils.FindSector(pSprite.x, pSprite.y, pSprite.z, nSector);
                            nSector = Gameutils.foundSector;
                        }
                        if (pSprite.sectnum != nSector) {
                            short nXSector;
                            if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                                Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                            }
                            if ((nXSector = Engine.sector[pSprite.sectnum].extra) > 0 && DB.xsector[nXSector].Exit && (pPlayer != null || !DB.xsector[nXSector].dudelockout)) {
                                Trigger.trTriggerSector(pSprite.sectnum, DB.xsector[nXSector], 43);
                            }
                            DB.changespritesect(pSprite.xvel, nSector);
                            nXSector = Engine.sector[nSector].extra;
                            if (nXSector > 0 && DB.xsector[nXSector].Enter && (pPlayer != null || !DB.xsector[nXSector].dudelockout)) {
                                if (Engine.sector[nSector].lotag == 604) {
                                    DB.xsector[nXSector].data = pPlayer != null ? (int)pSprite.xvel : -1;
                                }
                                Trigger.trTriggerSector(nSector, DB.xsector[nXSector], 42);
                            }
                            nSector = pSprite.sectnum;
                        }
                        underwater = false;
                        boolean depth = false;
                        if (Engine.sector[nSector].extra > 0) {
                            if (DB.xsector[Engine.sector[nSector].extra].Underwater) {
                                underwater = true;
                            }
                            if (DB.xsector[Engine.sector[nSector].extra].Depth != 0) {
                                depth = true;
                            }
                        }
                        int nUpper = Warp.gUpperLink[nSector];
                        int nLower = Warp.gLowerLink[nSector];
                        if (nUpper >= 0 && (Engine.sprite[nUpper].lotag == 9 || Engine.sprite[nUpper].lotag == 13)) {
                            depth = true;
                        }
                        if (nLower >= 0 && (Engine.sprite[nLower].lotag == 10 || Engine.sprite[nLower].lotag == 14)) {
                            depth = true;
                        }
                        if (pPlayer != null) {
                            clipDist += 16;
                        }
                        if (sprZVel[pSprite.xvel] != 0L) {
                            pSprite.z = (int)((long)pSprite.z + (sprZVel[pSprite.xvel] >> 8));
                        }
                        Gameutils.GetZRange(pSprite, clipDist, 77825);
                        ceilz = Gameutils.gz_ceilZ;
                        ceilhit = Gameutils.gz_ceilHit;
                        floorz = Gameutils.gz_floorZ;
                        floorhit = Gameutils.gz_floorHit;
                        Gameutils.GetSpriteExtents(pSprite);
                        zTop = Gameutils.extents_zTop;
                        zBot = Gameutils.extents_zBot;
                        if ((pSprite.hitag & 2) == 0) break block106;
                        G = 58254;
                        if (depth) break block107;
                        if (underwater || zBot >= floorz) {
                            G = 0;
                        }
                        break block108;
                    }
                    if (!underwater) break block109;
                    int ceilzofslope = Main.engine.getceilzofslope(nSector, pSprite.x, pSprite.y);
                    if (ceilzofslope > zTop) {
                        if (zBot != zTop) {
                            G += -80099 * (zBot - ceilzofslope) / (zBot - zTop);
                        }
                        break block108;
                    } else {
                        G = 0;
                    }
                    break block108;
                }
                int florzofslope = Main.engine.getflorzofslope(nSector, pSprite.x, pSprite.y);
                if (florzofslope < zBot && zBot != zTop) {
                    G += -80099 * (zBot - florzofslope) / (zBot - zTop);
                }
            }
            if (G != 0) {
                pSprite.z += 2 * G >> 8;
                short s = pSprite.xvel;
                sprZVel[s] = sprZVel[s] + (long)G;
            }
        }
        if (pPlayer != null && sprZVel[pSprite.xvel] > 0x155555L && !pPlayer.fScreamed && pXSprite.height != 0) {
            pPlayer.fScreamed = true;
            SOUND.sfxStart3DSound(pSprite, 719, 0, 0);
        }
        if ((warp = Warp.checkWarping(pSprite)) != 0) {
            Gameutils.GetZRange(pSprite, clipDist, 77825);
            ceilz = Gameutils.gz_ceilZ;
            ceilhit = Gameutils.gz_ceilHit;
            floorz = Gameutils.gz_floorZ;
            floorhit = Gameutils.gz_floorHit;
            if (pPlayer != null) {
                View.viewUpdatePlayerLoc(pPlayer);
                SOUND.sfxResetListener();
            }
            switch (warp) {
                case 12: {
                    if (pPlayer == null || pPlayer.nPlayer != View.gViewIndex) break;
                    Main.engine.setgotpic(Engine.sector[pSprite.sectnum].floorpicnum);
                    break;
                }
                case 11: {
                    if (pPlayer == null || pPlayer.nPlayer != View.gViewIndex) break;
                    Main.engine.setgotpic(Engine.sector[pSprite.sectnum].ceilingpicnum);
                    break;
                }
                case 10: 
                case 14: {
                    pXSprite.palette = 0;
                    if (pPlayer != null) {
                        pPlayer.moveState = 0;
                        pPlayer.bubbleTime = 0;
                        if (!pPlayer.pJump && pPlayer.pInput.Jump) {
                            Actor.sprZVel[pSprite.xvel] = -436906L;
                            pPlayer.pJump = true;
                        }
                        SOUND.sfxStart3DSound(pSprite, 721, -1, 0);
                        break;
                    }
                    switch (pSprite.lotag) {
                        case 201: 
                        case 202: 
                        case 247: 
                        case 248: 
                        case 249: {
                            Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistGoto[0]);
                            break;
                        }
                        case 217: {
                            Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastGoto[0]);
                            pSprite.hitag = (short)(pSprite.hitag | 6);
                            break;
                        }
                        case 218: {
                            Actor.actKillSprite(pSprite.xvel, pSprite, 0, 16000);
                            break;
                        }
                    }
                    break;
                }
                case 9: 
                case 13: {
                    int gViewPal = 0;
                    SPRITE pUpper = Engine.sprite[Warp.gUpperLink[nSector]];
                    if (pUpper.extra >= 0) {
                        gViewPal = DB.xsprite[pUpper.extra].data2;
                    }
                    if (gViewPal <= 0) {
                        pXSprite.palette = warp == 9 ? 1 : (pPlayer != null ? 3 : 2);
                    } else if (pPlayer != null) {
                        pXSprite.palette = gViewPal;
                    } else if (gViewPal > 2) {
                        pXSprite.palette = 2;
                    }
                    if (pPlayer != null) {
                        pPlayer.moveState = 1;
                        pPlayer.pXsprite.burnTime = 0;
                        int zvel = (int)Pragmas.klabs(sprZVel[pSprite.xvel]);
                        pPlayer.bubbleTime = zvel >> 12;
                        EVENT.evPostCallback(pSprite.xvel, 3, 0L, 10);
                        if (pPlayer.fScreamed) {
                            SOUND.sfxKill3DSound(pSprite, -1, 719);
                        }
                        SOUND.sfxStart3DSound(pSprite, 720, -1, 0);
                        break;
                    }
                    switch (pSprite.lotag) {
                        case 201: 
                        case 202: 
                        case 247: 
                        case 248: 
                        case 249: {
                            pXSprite.burnTime = 0;
                            EVENT.evPostCallback(pSprite.xvel, 3, 0L, 11);
                            SOUND.sfxStart3DSound(pSprite, 720, -1, 0);
                            Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistGoto[1]);
                            break;
                        }
                        case 203: {
                            pXSprite.burnTime = 0;
                            EVENT.evPostCallback(pSprite.xvel, 3, 0L, 11);
                            SOUND.sfxStart3DSound(pSprite, 720, -1, 0);
                            Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieAGoto);
                            break;
                        }
                        case 217: {
                            pXSprite.burnTime = 0;
                            EVENT.evPostCallback(pSprite.xvel, 3, 0L, 11);
                            SOUND.sfxStart3DSound(pSprite, 720, -1, 0);
                            Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastGoto[1]);
                            pSprite.hitag = (short)(pSprite.hitag & 0xFFFFFFF9);
                            break;
                        }
                        case 206: 
                        case 211: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 219: 
                        case 220: 
                        case 239: {
                            Actor.actKillSprite(pSprite.xvel, pSprite, 0, 16000);
                            break;
                        }
                        case 240: {
                            pSprite.lotag = Gameutils.Chance(warp == 13 ? 512 : 2560) ? (short)201 : (short)202;
                            pXSprite.burnTime = 0;
                            EVENT.evPostCallback(pSprite.xvel, 3, 0L, 11);
                            SOUND.sfxStart3DSound(pSprite, 720, -1, 0);
                            Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistGoto[1]);
                            break;
                        }
                        case 204: {
                            pXSprite.burnTime = 0;
                            EVENT.evPostCallback(pSprite.xvel, 3, 0L, 11);
                            SOUND.sfxStart3DSound(pSprite, 720, -1, 0);
                            Ai.aiNewState(pSprite, pXSprite, AIZOMBF.zombieFGoto);
                            break;
                        }
                        case 254: {
                            EVENT.evPostCallback(pSprite.xvel, 3, 0L, 11);
                            if (AIUNICULT.canSwim(pSprite)) break;
                            Actor.actKillSprite(pSprite.xvel, pSprite, 0, 16000);
                        }
                    }
                    break;
                }
            }
        }
        Gameutils.GetSpriteExtents(pSprite);
        zTop = Gameutils.extents_zTop;
        zBot = Gameutils.extents_zBot;
        if (pPlayer != null && zBot >= floorz) {
            int ofloorz = floorz;
            int ofloorhit = floorhit;
            Gameutils.GetZRange(pSprite, pSprite.clipdist << 2, 77825);
            ceilz = Gameutils.gz_ceilZ;
            ceilhit = Gameutils.gz_ceilHit;
            floorz = Gameutils.gz_floorZ;
            floorhit = Gameutils.gz_floorHit;
            if (zBot <= floorz && pSprite.z - ofloorz < floorDist) {
                floorz = ofloorz;
                floorhit = ofloorhit;
            }
        }
        if (floorz > zBot) {
            Actor.gSpriteHit[nXSprite].floorHit = 0;
            if ((pSprite.hitag & 2) != 0) {
                pSprite.hitag = (short)(pSprite.hitag | 4);
            }
        } else {
            Actor.gSpriteHit[nXSprite].floorHit = floorhit;
            pSprite.z += floorz - zBot;
            int dZvel = (int)(sprZVel[pSprite.xvel] - floorVel[pSprite.sectnum]);
            if (dZvel <= 0) {
                if (sprZVel[pSprite.xvel] == 0L) {
                    pSprite.hitag = (short)(pSprite.hitag & 0xFFFFFFFB);
                }
            } else {
                long gravity = Actor.GravityVector(sprXVel[pSprite.xvel], sprYVel[pSprite.xvel], dZvel, pSprite.sectnum, 0);
                int fallDamage = Pragmas.mulscale(gravity, gravity, 30);
                Actor.sprXVel[pSprite.xvel] = refl_x;
                Actor.sprYVel[pSprite.xvel] = refl_y;
                dZvel = (int)refl_z;
                if (pPlayer != null) {
                    pPlayer.fScreamed = false;
                    if (fallDamage > 240 && (pSprite.hitag & 4) != 0) {
                        Actor.playSurfSound(pPlayer);
                    }
                    if (fallDamage > 480) {
                        SOUND.sfxStart3DSound(pSprite, 701, 0, 0);
                    }
                }
                if ((fallDamage -= 1600) > 0) {
                    Actor.actDamageSprite(pSprite.xvel, pSprite, 0, fallDamage);
                }
                Actor.sprZVel[pSprite.xvel] = dZvel;
                if (Pragmas.klabs(dZvel) >= 65536) {
                    pSprite.hitag = (short)(pSprite.hitag | 4);
                } else {
                    Actor.sprZVel[pSprite.xvel] = floorVel[pSprite.sectnum];
                    pSprite.hitag = (short)(pSprite.hitag & 0xFFFFFFFB);
                }
                switch (Main.game.getCurrentDef().GetSurfType(floorhit)) {
                    case 5: {
                        Actor.actSpawnEffect(9, pSprite.sectnum, pSprite.x, pSprite.y, floorz, 0);
                        break;
                    }
                    case 14: {
                        SPRITE pSpawn = Actor.actSpawnEffect(10, pSprite.sectnum, pSprite.x, pSprite.y, floorz, 0);
                        if (pSpawn == null) break;
                        for (int i = 0; i < 7; ++i) {
                            SPRITE pSpawn2 = Actor.actSpawnEffect(14, pSpawn.sectnum, pSpawn.x, pSpawn.y, pSpawn.z, 0);
                            if (pSpawn2 == null) continue;
                            Actor.sprXVel[pSpawn2.xvel] = Gameutils.BiRandom(436906);
                            Actor.sprYVel[pSpawn2.xvel] = Gameutils.BiRandom(436906);
                            Actor.sprZVel[pSpawn2.xvel] = -Gameutils.Random(873813);
                        }
                        break;
                    }
                }
            }
        }
        if (ceilz < zTop) {
            Actor.gSpriteHit[nXSprite].ceilHit = 0;
        } else {
            Actor.gSpriteHit[nXSprite].ceilHit = ceilhit;
            if (ceilz - zTop > 0) {
                pSprite.z += ceilz - zTop;
            }
            if (sprZVel[pSprite.xvel] <= 0L && (pSprite.hitag & 4) != 0) {
                Actor.sprZVel[pSprite.xvel] = -sprZVel[pSprite.xvel] / 8L;
            }
        }
        Gameutils.GetSpriteExtents(pSprite);
        zTop = Gameutils.extents_zTop;
        zBot = Gameutils.extents_zBot;
        pXSprite.height = floorz - zBot > 0 ? floorz - zBot >> 8 : 0;
        if (sprXVel[pSprite.xvel] != 0L || sprYVel[pSprite.xvel] != 0L) {
            if ((floorhit & 0xE000) == 49152) {
                int nUnderSprite = floorhit & 0x1FFF;
                if ((Engine.sprite[nUnderSprite].cstat & 0x30) == 0) {
                    short s = pSprite.xvel;
                    sprXVel[s] = sprXVel[s] + (long)Pragmas.mulscale(Globals.kFrameTicks, pSprite.x - Engine.sprite[nUnderSprite].x, 2);
                    short s2 = pSprite.xvel;
                    sprYVel[s2] = sprYVel[s2] + (long)Pragmas.mulscale(Globals.kFrameTicks, pSprite.y - Engine.sprite[nUnderSprite].y, 2);
                    return;
                }
            }
            nSector = pSprite.sectnum;
            if (!(Engine.sector[nSector].extra > 0 && DB.xsector[Engine.sector[nSector].extra].Underwater || pXSprite.height >= 256)) {
                int kv = 10752;
                if (pXSprite.height != 0) {
                    kv -= Pragmas.mulscale(pXSprite.height, kv, 8);
                }
                short s = pSprite.xvel;
                sprXVel[s] = sprXVel[s] - (long)Pragmas.dmulscale(kv, (int)sprXVel[pSprite.xvel], 32768L, 1L, 16);
                short s3 = pSprite.xvel;
                sprYVel[s3] = sprYVel[s3] - (long)Pragmas.dmulscale(kv, (int)sprYVel[pSprite.xvel], 32768L, 1L, 16);
                if (Main.engine.qdist(sprXVel[pSprite.xvel], sprYVel[pSprite.xvel]) < 4096L) {
                    Actor.sprYVel[pSprite.xvel] = 0L;
                    Actor.sprXVel[pSprite.xvel] = 0L;
                }
            }
        }
    }

    public static void ConcussSprite(int nSource, SPRITE pSprite, int x, int y, int z, int damage) {
        if (pSprite == null) {
            Main.game.dassert("pSprite != null");
        }
        int dx = pSprite.x - x;
        int dy = pSprite.y - y;
        int dz = pSprite.z - z >> 4;
        int dist2 = dx * dx + dy * dy + dz * dz + 262144;
        BloodTile pic = Main.engine.getTile(pSprite.picnum);
        int area = pic.getWidth() * pSprite.xrepeat * pic.getHeight() * pSprite.yrepeat >> 1;
        long force = Pragmas.divscale(damage, dist2, 18);
        if ((pSprite.hitag & 1) != 0) {
            int mass = 0;
            if (Actor.IsDudeSprite(pSprite)) {
                mass = DudeInfo.dudeInfo[pSprite.lotag - 200].mass;
                switch (pSprite.lotag) {
                    case 254: 
                    case 255: {
                        mass = Actor.getDudeMassBySpriteSize(pSprite);
                    }
                }
            } else if (pSprite.lotag >= 400 && pSprite.lotag < 436) {
                mass = Actor.thingInfo[pSprite.lotag - 400].mass;
            } else {
                Console.Println("Unexpected type encountered in ConcussSprite()");
            }
            if (mass == 0) {
                Main.game.dassert("mass != 0, type: " + pSprite.lotag + " picnum: " + pSprite.picnum);
            }
            int impulse = Pragmas.muldiv(force, area, Pragmas.klabs(mass));
            dx = Pragmas.mulscale(impulse, dx, 16);
            dy = Pragmas.mulscale(impulse, dy, 16);
            dz = Pragmas.mulscale(impulse, dz, 16);
            short xvel = pSprite.xvel;
            if (xvel < 0 || xvel >= Globals.kMaxSprites) {
                Main.game.dassert("xvel >= 0 && xvel < kMaxSprites ");
            }
            short s = xvel;
            sprXVel[s] = sprXVel[s] + (long)dx;
            short s2 = xvel;
            sprYVel[s2] = sprYVel[s2] + (long)dy;
            short s3 = xvel;
            sprZVel[s3] = sprZVel[s3] + (long)dz;
        }
        Actor.actDamageSprite(nSource, pSprite, 3, (int)force);
    }

    public static void ReflectVector(long dx, long dy, int nWall, int nFraction) {
        refl_x = dx;
        refl_y = dy;
        Gameutils.GetWallNormal(nWall);
        long nx = (long)Gameutils.normal.x;
        long ny = (long)Gameutils.normal.y;
        long dotProduct = Pragmas.dmulscale(dx, nx, dy, ny, 16);
        long sd = Pragmas.dmulscale(nFraction + 65536, dotProduct, 32768L, 1L, 16);
        refl_x -= (long)Pragmas.mulscale(nx, sd, 16);
        refl_y -= (long)Pragmas.mulscale(ny, sd, 16);
    }

    public static long GravityVector(long dx, long dy, long dz, int nSector, int nFraction) {
        long result = 0L;
        if (Engine.sector[nSector].floorheinum != 0) {
            WALL pWall = Engine.wall[Engine.sector[nSector].wallptr];
            int nAngle = Main.engine.getangle(Engine.wall[pWall.point2].x - pWall.x, Engine.wall[pWall.point2].y - pWall.y) + 512;
            int nSlope = Engine.sector[nSector].floorheinum << 4;
            long dist = Main.engine.qdist(nSlope, 65536L);
            long mp = Pragmas.divscale(nSlope, dist, 16);
            long mg = Pragmas.divscale(-65536L, dist, 16);
            int cx = Pragmas.mulscale(Trig.Cos(nAngle), mp, 30);
            int cy = Pragmas.mulscale(Trig.Sin(nAngle), mp, 30);
            long avel = (long)cx * dx + (long)cy * dy + mg * dz >> 16;
            long svel = Pragmas.mulscale(avel, nFraction + 65536, 16);
            dx -= (long)Pragmas.mulscale(svel, cx, 16);
            dy -= (long)Pragmas.mulscale(svel, cy, 16);
            dz -= (long)Pragmas.mulscale(svel, mg, 16);
            result = Pragmas.mulscale(65536 - nFraction, avel, 16);
        } else {
            result = Pragmas.mulscale(65536 - nFraction, dz, 16);
            dz = result - dz;
        }
        refl_x = dx;
        refl_y = dy;
        refl_z = dz;
        return result;
    }

    public static void playSurfSound(PLAYER pPlayer) {
        SPRITE pSprite = pPlayer.pSprite;
        if (pPlayer.pSprite == null) {
            return;
        }
        SPRITEHIT pSpriteHit = gSpriteHit[pSprite.extra];
        if (pSpriteHit.floorHit != 0) {
            byte surfType = Main.game.getCurrentDef().GetSurfType(pSpriteHit.floorHit);
            int nHitObject = pSpriteHit.floorHit & 0x1FFF;
            boolean IsDudeSprite = false;
            if ((pSpriteHit.floorHit & 0xE000) == 49152) {
                IsDudeSprite = Actor.IsDudeSprite(Engine.sprite[nHitObject]);
            }
            if (surfType != 0 && !IsDudeSprite) {
                SOUND.sfxStart3DSound(pSprite, Tile.surfSfxLand[surfType], -1, 0);
            }
        }
    }

    public static void actKickObject(SPRITE pSprite, SPRITE pObject) {
        int moveDist = Gameutils.ClipLow((int)(2L * Main.engine.qdist(sprXVel[pSprite.xvel], sprYVel[pSprite.xvel])), 699050);
        Actor.sprXVel[pObject.xvel] = Pragmas.mulscale(Trig.Cos(pSprite.ang + Gameutils.BiRandom(85)), moveDist, 30);
        Actor.sprYVel[pObject.xvel] = Pragmas.mulscale(Trig.Sin(pSprite.ang + Gameutils.BiRandom(85)), moveDist, 30);
        Actor.sprZVel[pObject.xvel] = Pragmas.mulscale(-8192L, moveDist, 14);
        pObject.hitag = (short)7;
    }

    public static void ProcessTouchObjects(int nSprite, int nXSprite) {
        SPRITE pHitObject;
        XSPRITE pXHit;
        SPRITE pSprite = Engine.sprite[nSprite];
        XSPRITE pXSprite = DB.xsprite[nXSprite];
        SPRITEHIT pSpriteHit = gSpriteHit[nXSprite];
        int nHitObject = pSpriteHit.ceilHit & 0x1FFF;
        switch (pSpriteHit.ceilHit & 0xE000) {
            case 49152: {
                if (Engine.sprite[nHitObject].extra <= 0) break;
                SPRITE pHit = Engine.sprite[nHitObject];
                pXHit = DB.xsprite[pHit.extra];
                if (!(pHit.statnum != 4 && pHit.statnum != 6 || sprXVel[pSprite.xvel] == 0L && sprYVel[pSprite.xvel] == 0L && sprZVel[pSprite.xvel] == 0L)) {
                    if (pHit.statnum == 4) {
                        THINGINFO pThingInfo = thingInfo[pHit.lotag - 400];
                        if ((pThingInfo.flags & 1) != 0) {
                            pHit.hitag = (short)(pHit.hitag | 1);
                        }
                        if ((pThingInfo.flags & 2) != 0) {
                            pHit.hitag = (short)(pHit.hitag | 4);
                        }
                        short s = pHit.xvel;
                        sprXVel[s] = sprXVel[s] + (long)Pragmas.mulscale(4L, pHit.x - pSprite.x, 2);
                        short s2 = pHit.xvel;
                        sprYVel[s2] = sprYVel[s2] + (long)Pragmas.mulscale(4L, pHit.y - pSprite.y, 2);
                    } else {
                        pHit.hitag = (short)(pHit.hitag | 5);
                        short s = pHit.xvel;
                        sprXVel[s] = sprXVel[s] + (long)Pragmas.mulscale(4L, pHit.x - pSprite.x, 2);
                        short s3 = pHit.xvel;
                        sprYVel[s3] = sprYVel[s3] + (long)Pragmas.mulscale(4L, pHit.y - pSprite.y, 2);
                        if (!(pHit.lotag != 229 || Gameutils.IsPlayerSprite(pSprite) && Globals.gPlayer[pSprite.lotag - 231].godMode)) {
                            Actor.actDamageSprite(pHit.xvel, pSprite, 3, 4 * pXSprite.health);
                        }
                    }
                }
                switch (pHit.lotag) {
                    case 454: {
                        if (pXHit.state != 0) {
                            pXHit.data1 = 1;
                            pXHit.data2 = (short)Gameutils.ClipHigh(pXHit.data2 + 2 * Globals.kFrameTicks, 600);
                            Actor.actDamageSprite(nSprite, pSprite, 2, 16);
                            break;
                        }
                        Actor.actDamageSprite(nSprite, pSprite, 2, 1);
                    }
                }
                break;
            }
        }
        nHitObject = pSpriteHit.moveHit & 0x1FFF;
        switch (pSpriteHit.moveHit & 0xE000) {
            case 49152: {
                pHitObject = Engine.sprite[nHitObject];
                if (pHitObject.extra <= 0) break;
                switch (pHitObject.lotag) {
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 252: 
                    case 253: {
                        pXSprite.burnTime = Gameutils.ClipLow(pXSprite.burnTime - Globals.kFrameTicks, 0);
                        Actor.actDamageSprite(Actor.actGetBurnSource(pXSprite.burnSource), pSprite, 1, 2 * Globals.kFrameTicks);
                        break;
                    }
                    case 415: 
                    case 427: {
                        Actor.actKickObject(pSprite, pHitObject);
                        if (pHitObject.lotag != 427) break;
                        SOUND.sfxCreate3DSound(pSprite.x, pSprite.y, pSprite.z, 357, pSprite.sectnum);
                        Actor.actDamageSprite(-1, pHitObject, 0, 80);
                    }
                }
                break;
            }
        }
        nHitObject = pSpriteHit.floorHit & 0x1FFF;
        switch (pSpriteHit.floorHit & 0xE000) {
            case 49152: {
                if (Engine.sprite[nHitObject].extra <= 0) break;
                pHitObject = Engine.sprite[nHitObject];
                pXHit = DB.xsprite[pHitObject.extra];
                if (Actor.IsDudeSprite(pHitObject) && pHitObject.lotag <= 238 && pHitObject.lotag != 208 && pHitObject.lotag != 209 && pHitObject.lotag != 216 && pHitObject.lotag != 218 && pHitObject.lotag != 230 && Gameutils.IsPlayerSprite(pSprite)) {
                    Actor.actDamageSprite(nSprite, pHitObject, 2, 8);
                    return;
                }
                switch (pHitObject.lotag) {
                    case 454: {
                        if (pXHit.state != 0) {
                            pXHit.data1 = 1;
                            pXHit.data2 = (short)Gameutils.ClipHigh(pXHit.data2 + 2 * Globals.kFrameTicks, 600);
                            Actor.actDamageSprite(nSprite, pSprite, 2, 16);
                            break;
                        }
                        Actor.actDamageSprite(nSprite, pSprite, 2, 1);
                        break;
                    }
                    case 415: 
                    case 427: {
                        if (Gameutils.IsPlayerSprite(pSprite)) {
                            PLAYER pPlayer = Globals.gPlayer[pSprite.lotag - 231];
                            if (Globals.gFrameClock < pPlayer.kickTime) {
                                return;
                            }
                            pPlayer.kickTime = Globals.gFrameClock + 60;
                        }
                        SOUND.sfxCreate3DSound(pSprite.x, pSprite.y, pSprite.z, 357, pSprite.sectnum);
                        Actor.actKickObject(pSprite, pHitObject);
                        if (pHitObject.lotag == 427) {
                            Actor.actDamageSprite(-1, pHitObject, 0, 80);
                            break;
                        }
                        SOUND.sfxStart3DSound(pSprite, 374, 0, 0);
                    }
                }
                break;
            }
            case 32768: {
                break;
            }
            case 16384: {
                Actor.processTouchFloor(pSprite, nHitObject);
            }
        }
    }

    public static void processTouchFloor(SPRITE pSprite, int nSector) {
        byte surfType;
        XSECTOR pXSector;
        if (pSprite == null) {
            Main.game.dassert("pSprite != null");
        }
        if (nSector < 0 || nSector >= Globals.kMaxSectors) {
            Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
        }
        SECTOR pSector = Engine.sector[nSector];
        XSECTOR xSECTOR = pXSector = pSector.extra > 0 ? DB.xsector[pSector.extra] : null;
        if (pXSector != null && (pSector.lotag == 618 || pXSector.damageType != 0)) {
            int nDamageType = pXSector.damageType;
            nDamageType = pSector.lotag == 618 ? Gameutils.ClipRange(nDamageType, 0, 6) : Gameutils.ClipRange(nDamageType - 1, 0, 6);
            int nDamage = 1000;
            if (pXSector.data != 0) {
                nDamage = Gameutils.ClipLow(pXSector.data, 0);
            }
            Actor.actDamageSprite(pSprite.xvel, pSprite, nDamageType, Globals.kFrameTicks * nDamage / 120 << 4);
        }
        if ((surfType = Main.game.getCurrentDef().GetSurfType(nSector + 16384)) == 14) {
            Actor.actDamageSprite(pSprite.xvel, pSprite, 1, 16);
            SOUND.sfxStart3DSound(pSprite, 352, 5, 2);
        }
    }

    public static void actPostSprite(int nSprite, int nStatus) {
        int n;
        if (gPostCount >= Globals.kMaxSprites) {
            Main.game.dassert("gPostCount < kMaxSprites");
        }
        if (nSprite >= Globals.kMaxSprites || Engine.sprite[nSprite].statnum >= 1024) {
            Main.game.dassert("nSprite < kMaxSprites && sprite[nSprite].statnum < kMaxStatus");
        }
        if (nStatus < 0 || nStatus > 1024) {
            Main.game.dassert("nStatus >= 0 && nStatus <= kStatFree ");
        }
        if ((Engine.sprite[nSprite].hitag & 0x20) != 0) {
            for (n = 0; n < gPostCount && Actor.gPost[n].nSprite != nSprite; ++n) {
            }
            if (n >= gPostCount) {
                Main.game.dassert("n < gPostCount");
            }
        } else {
            n = gPostCount++;
            Engine.sprite[nSprite].hitag = (short)(Engine.sprite[nSprite].hitag | 0x20);
        }
        Actor.gPost[n].nSprite = (short)nSprite;
        Actor.gPost[n].nStatus = (short)nStatus;
    }

    public static void actPostProcess() {
        if (gPostCount != 0) {
            for (int i = 0; i < gPostCount; ++i) {
                POSTPONE pPost = gPost[i];
                short nSprite = pPost.nSprite;
                Engine.sprite[nSprite].hitag = (short)(Engine.sprite[nSprite].hitag & 0xFFFFFFDF);
                if (pPost.nStatus == 1024) {
                    EVENT.checkEventList(nSprite, 3);
                    if (Engine.sprite[nSprite].extra > 0) {
                        SeqHandling.seqKill(3, Engine.sprite[nSprite].extra);
                    }
                    DB.deletesprite(pPost.nSprite);
                    continue;
                }
                DB.changespritestat(pPost.nSprite, pPost.nStatus);
            }
            gPostCount = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void actProcessEffects() {
        nSprite = Engine.headspritestat[1];
        while (nSprite >= 0) {
            block14: {
                block17: {
                    block16: {
                        block15: {
                            block13: {
                                pSprite = Engine.sprite[nSprite];
                                View.viewBackupSpriteLoc(nSprite, pSprite);
                                nSector = pSprite.sectnum;
                                if (nSector >= 0 && nSector < Globals.kMaxSectors) break block13;
                                Actor.actDeleteEffect2(nSprite);
                                break block14;
                            }
                            if (pSprite.lotag < 57) break block15;
                            Actor.actDeleteEffect2(nSprite);
                            break block14;
                        }
                        pFXData = Actor.gEffectInfo[pSprite.lotag];
                        Actor.AirDrag(nSprite, pFXData.velocity);
                        if (Actor.sprXVel[nSprite] != 0L) {
                            pSprite.x = (int)((long)pSprite.x + (Actor.sprXVel[pSprite.xvel] >> 12));
                        }
                        if (Actor.sprYVel[nSprite] != 0L) {
                            pSprite.y = (int)((long)pSprite.y + (Actor.sprYVel[pSprite.xvel] >> 12));
                        }
                        if (Actor.sprZVel[nSprite] != 0L) {
                            pSprite.z = (int)((long)pSprite.z + (Actor.sprZVel[pSprite.xvel] >> 8));
                        }
                        if (Actor.sprXVel[nSprite] != 0L || Actor.sprYVel[nSprite] != 0L || Actor.sprZVel[nSprite] != 0L) break block16;
                        v0 = nSprite;
                        Actor.sprZVel[v0] = Actor.sprZVel[v0] + (long)pFXData.gravity;
                        break block14;
                    }
                    v1 = gravity = Actor.sprXVel[nSprite] == 0L && (Actor.sprYVel[nSprite] == 0L || pSprite.z < Engine.sector[nSector].floorz);
                    if (gravity || (nSector = Main.engine.updatesector(pSprite.x, pSprite.y, nSector)) != -1) break block17;
                    Actor.actDeleteEffect2(nSprite);
                    break block14;
                }
                if (!gravity && pSprite.z >= Main.engine.getflorzofslope(pSprite.sectnum, pSprite.x, pSprite.y)) ** GOTO lbl-1000
                if (pSprite.sectnum != nSector) {
                    if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                        Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                    }
                    DB.changespritesect(nSprite, nSector);
                }
                Main.engine.getzsofslope(nSector, pSprite.x, pSprite.y, Globals.zofslope);
                if (Globals.zofslope[0] > pSprite.z && (Engine.sector[nSector].ceilingstat & 1) == 0) {
                    Actor.actDeleteEffect2(nSprite);
                } else if (Globals.zofslope[1] >= pSprite.z) {
                    v2 = nSprite;
                    Actor.sprZVel[v2] = Actor.sprZVel[v2] + (long)pFXData.gravity;
                } else if ((funcID = pFXData.funcID) > -1 && funcID <= 22) {
                    if (EVENT.gCallback[pFXData.funcID] == null) {
                        Main.game.dassert("gCallback[pFXData.funcID] != NULL");
                    }
                    EVENT.gCallback[pFXData.funcID].run(nSprite);
                } else {
                    Actor.actDeleteEffect2(nSprite);
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
    }

    public static void rebuildGlobalArray(int arrayId) {
        int curCount = -1;
        short newCount = 0;
        short[] array = new short[128];
        switch (arrayId) {
            case 1: {
                curCount = DB.gProxySpritesCount;
                array = DB.gProxySpritesList;
                break;
            }
            case 2: {
                curCount = DB.gSightSpritesCount;
                array = DB.gSightSpritesList;
                break;
            }
            default: {
                return;
            }
        }
        if (curCount > 0) {
            for (int i = 0; i < curCount; ++i) {
                if (array[i] < 0 || Engine.sprite[array[i]].extra < 0 || Engine.sprite[array[i]].statnum == 1024) continue;
                XSPRITE pXSprite = DB.xsprite[Engine.sprite[array[i]].extra];
                if (pXSprite.isTriggered || arrayId == 1 && !pXSprite.Proximity || arrayId == 2 && !pXSprite.Sight || pXSprite.rxID <= 0 && pXSprite.state != pXSprite.restState && pXSprite.waitTime <= 0 && !pXSprite.Interrutable) continue;
                short s = newCount;
                newCount = (short)(newCount + 1);
                array[s] = array[i];
            }
        }
        switch (arrayId) {
            case 1: {
                DB.gProxySpritesList = array;
                DB.gProxySpritesCount = newCount;
                DB.gMaxBadProxySprites = (byte)(DB.gProxySpritesCount >> 2);
                if (DB.gMaxBadProxySprites <= 0) {
                    DB.gMaxBadProxySprites = 1;
                }
                return;
            }
            case 2: {
                DB.gSightSpritesList = array;
                DB.gSightSpritesCount = newCount;
                DB.gMaxBadSightSprites = (byte)(DB.gSightSpritesCount >> 2);
                if (DB.gMaxBadSightSprites <= 0) {
                    DB.gMaxBadSightSprites = 1;
                }
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void actProcessSprites() {
        int z;
        SPRITE pSprite;
        short nXSprite;
        SPRITE pThink;
        gTNTCount = 0;
        short nSprite = Engine.headspritestat[4];
        while (true) {
            block145: {
                short nextAffected;
                short nAffected;
                boolean isOriginal;
                XSPRITE pXThink;
                block147: {
                    block144: {
                        block146: {
                            if (nSprite < 0) break block144;
                            pThink = Engine.sprite[nSprite];
                            if ((pThink.hitag & 0x20) != 0) break block145;
                            if (DEMO.IsOriginalDemo() || pThink.lotag != 402 && pThink.lotag != 401 && pThink.lotag != 433 || ++gTNTCount <= 512) break block146;
                            Actor.actPostSprite(nSprite, 1024);
                            break block145;
                        }
                        short nXThink = pThink.extra;
                        if (nXThink <= 0) break block145;
                        short type = pThink.lotag;
                        pXThink = DB.xsprite[nXThink];
                        if ((type == 425 || type == 426 || type == 427) && pXThink.Locked != 0 && Globals.gFrameClock >= pXThink.targetX) {
                            pXThink.Locked = 0;
                        }
                        if (Actor.actGetBurnTime(pXThink) > 0) {
                            pXThink.burnTime = Gameutils.ClipLow(pXThink.burnTime - Globals.kFrameTicks, 0);
                            Actor.actDamageSprite(Actor.actGetBurnSource(pXThink.burnSource), Engine.sprite[nSprite], 1, 2 * Globals.kFrameTicks);
                        }
                        if (!pXThink.Proximity || !(isOriginal = DEMO.IsOriginalDemo()) && (pXThink.Locked == 1 || pXThink.isTriggered)) break block145;
                        if (pThink.lotag == 431) {
                            pXThink.target = -1;
                        }
                        nAffected = Engine.headspritestat[6];
                        nextAffected = Engine.nextspritestat[nAffected];
                        break block147;
                    }
                    nSprite = Engine.headspritestat[4];
                    break;
                }
                while (nAffected >= 0) {
                    block148: {
                        int proxyDist;
                        SPRITE pDude;
                        block150: {
                            block149: {
                                nextAffected = Engine.nextspritestat[nAffected];
                                pDude = Engine.sprite[nAffected];
                                if ((pDude.hitag & 0x20) != 0 || DB.xsprite[pDude.extra].health == 0 || !isOriginal && pThink.lotag != 431 && pXThink.DudeLockout && !Gameutils.IsPlayerSprite(pDude)) break block148;
                                proxyDist = 96;
                                if (pThink.lotag != 435) break block149;
                                proxyDist = 512;
                                break block150;
                            }
                            if (pThink.lotag != 431 || pXThink.target != -1) break block150;
                            int nOwner = Actor.actGetBurnSource(pThink.owner);
                            if (nAffected == nOwner || nOwner == -1) break block148;
                            PLAYER pOwner = null;
                            if (Gameutils.IsPlayerSprite(Engine.sprite[nOwner])) {
                                pOwner = Globals.gPlayer[Engine.sprite[nOwner].lotag - 231];
                            }
                            PLAYER pTarget = null;
                            if (Gameutils.IsPlayerSprite(pDude)) {
                                pTarget = Globals.gPlayer[pDude.lotag - 231];
                            }
                            if (pDude.lotag == 205 || pDude.lotag == 220 || pDude.lotag == 219 || Globals.pGameInfo.nGameType == 3 && pTarget != null && (pOwner == null || pTarget.teamID == pOwner.teamID) || Globals.pGameInfo.nGameType == 1 && pTarget != null) break block148;
                            proxyDist = 512;
                        }
                        if (!Gameutils.CheckProximity(pDude, pThink.x, pThink.y, pThink.z, pThink.sectnum, proxyDist)) break block148;
                        switch (pThink.lotag) {
                            case 433: {
                                if (isOriginal || Gameutils.IsPlayerSprite(pDude)) {
                                    pThink.pal = 0;
                                    break;
                                }
                                break block148;
                            }
                            case 431: {
                                if ((Gameutils.Chance(8192) || Engine.nextspritestat[nAffected] < 0) && (pDude.cstat & 0x10001) != 0) {
                                    pXThink.target = pDude.xvel;
                                    break;
                                }
                                break block148;
                            }
                            case 435: {
                                if (!isOriginal && pXThink.target != pDude.xvel) break block148;
                            }
                        }
                        if (pThink.owner == -1) {
                            Actor.actSetOwner(pThink, pDude);
                        }
                        Trigger.trTriggerSprite(nSprite, pXThink, 35);
                    }
                    nAffected = nextAffected;
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        while (nSprite >= 0) {
            pThink = Engine.sprite[nSprite];
            if ((pThink.hitag & 0x20) == 0) {
                nXSprite = pThink.extra;
                if (nXSprite <= 0 || nXSprite >= 2048) {
                    Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
                }
                short nSector = pThink.sectnum;
                short nXSector = Engine.sector[nSector].extra;
                XSECTOR pXSector = null;
                if (nXSector > 0) {
                    if (nXSector <= 0 || nXSector >= 512) {
                        Main.game.dassert("nXSector > 0 && nXSector < kMaxXSectors");
                    }
                    if (DB.xsector[nXSector].reference != nSector) {
                        Main.game.dassert("xsector[nXSector].reference == nSector");
                    }
                    pXSector = DB.xsector[nXSector];
                }
                if (pXSector != null && pXSector.panVel != 0 && (pXSector.panAlways || pXSector.busy != 0 || pXSector.state != 0)) {
                    THINGINFO pThinkInfo = thingInfo[pThink.lotag - 400];
                    if ((pThinkInfo.flags & 1) != 0) {
                        pThink.hitag = (short)(pThink.hitag | 1);
                    }
                    if ((pThinkInfo.flags & 2) != 0) {
                        pThink.hitag = (short)(pThink.hitag | 4);
                    }
                }
                if ((pThink.hitag & 3) != 0) {
                    View.viewBackupSpriteLoc(nSprite, pThink);
                    if (pXSector != null && pXSector.panVel != 0) {
                        Gameutils.GetSpriteExtents(pThink);
                        if (Main.engine.getflorzofslope(pThink.sectnum, pThink.x, pThink.y) <= Gameutils.extents_zBot) {
                            int panVel = 0;
                            int panAngle = pXSector.panAngle;
                            if (pXSector.panAlways || pXSector.state != 0 || pXSector.busy != 0) {
                                panVel = (pXSector.panVel & 0xFF) << 9;
                                if (!pXSector.panAlways && pXSector.busy != 0) {
                                    panVel = Pragmas.mulscale(panVel, pXSector.busy, 16);
                                }
                            }
                            if ((Engine.sector[nSector].floorstat & 0x40) != 0) {
                                panAngle += Gameutils.GetWallAngle(Engine.sector[nSector].wallptr) + 512;
                                panAngle &= 0x7FF;
                            }
                            int pushX = Pragmas.mulscale(panVel, Trig.Cos(panAngle), 30);
                            int pushY = Pragmas.mulscale(panVel, Trig.Sin(panAngle), 30);
                            short s = nSprite;
                            sprXVel[s] = sprXVel[s] + (long)pushX;
                            short s2 = nSprite;
                            sprYVel[s2] = sprYVel[s2] + (long)pushY;
                        }
                    }
                    Actor.AirDrag(nSprite, 128);
                    if ((Globals.gFrame & 0xF) == pThink.xvel >> 8 && (pThink.hitag & 2) != 0) {
                        pThink.hitag = (short)(pThink.hitag | 4);
                    }
                    if ((pThink.hitag & 4) != 0 || sprXVel[nSprite] != 0L || sprYVel[nSprite] != 0L || sprZVel[nSprite] != 0L || floorVel[pThink.sectnum] != 0L || ceilingVel[pThink.sectnum] != 0L) {
                        Actor.MoveThing(nSprite);
                    }
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        nSprite = Engine.headspritestat[5];
        while (true) {
            block142: {
                if (nSprite < 0) break;
                pSprite = Engine.sprite[nSprite];
                if ((pSprite.hitag & 0x20) == 0) {
                    int z2;
                    int y;
                    int x;
                    int zvel;
                    short nSector;
                    int hitInfo;
                    SPRITE pOwner;
                    short oldcstat;
                    block143: {
                        View.viewBackupSpriteLoc(nSprite, pSprite);
                        nXSprite = pSprite.extra;
                        XSPRITE pXSprite = DB.xsprite[nXSprite];
                        oldcstat = 0;
                        pOwner = null;
                        if (pSprite.owner >= 0) {
                            pOwner = Engine.sprite[Actor.actGetOwner(pSprite)];
                            if (Actor.IsDudeSprite(pOwner)) {
                                oldcstat = pOwner.cstat;
                                pOwner.cstat = (short)(pOwner.cstat & 0xFEFE);
                            } else {
                                pOwner = null;
                            }
                        }
                        Engine.pHitInfo.hitsect = (short)-1;
                        Engine.pHitInfo.hitwall = (short)-1;
                        Engine.pHitInfo.hitsprite = (short)-1;
                        if (pSprite.lotag == 304) {
                            Actor.AirDrag(nSprite, 4096);
                        }
                        if (pXSprite.target != -1 && (sprXVel[pSprite.xvel] != 0L || sprYVel[pSprite.xvel] != 0L || sprZVel[pSprite.xvel] != 0L)) {
                            XSPRITE pXTarget;
                            int nTarget = pXSprite.target;
                            SPRITE pTarget = Engine.sprite[nTarget];
                            short nXTarget = pTarget.extra;
                            XSPRITE xSPRITE = pXTarget = nXTarget <= 0 ? null : DB.xsprite[nXTarget];
                            if (pTarget.statnum == 6 && pXTarget != null && pXTarget.health != 0) {
                                short nAngle = Main.engine.getangle(-(pTarget.y - pSprite.y), pTarget.x - pSprite.x);
                                int x2 = Actor.gMissileData[pSprite.lotag - 300].velocity;
                                int y2 = 0;
                                Engine.Point out = Gameutils.RotatePoint(x2, y2, nAngle + 1536 & 0x7FF, 0, 0);
                                Actor.sprXVel[pSprite.xvel] = out.getX();
                                Actor.sprYVel[pSprite.xvel] = out.getY();
                                int dz = pTarget.z - pSprite.z;
                                int zvel2 = dz / 10;
                                if (pSprite.z > pTarget.z) {
                                    zvel2 = dz / -10;
                                }
                                short s = pSprite.xvel;
                                sprZVel[s] = sprZVel[s] + (long)zvel2;
                            }
                        }
                        hitInfo = -1;
                        int nImpact = 1;
                        nSector = pSprite.sectnum;
                        int xvel = (int)(sprXVel[pSprite.xvel] >> 12);
                        int yvel = (int)(sprYVel[pSprite.xvel] >> 12);
                        zvel = (int)(sprZVel[pSprite.xvel] >> 8);
                        do {
                            short nXWall;
                            x = pSprite.x;
                            y = pSprite.y;
                            z2 = pSprite.z;
                            nSector = pSprite.sectnum;
                            Gameutils.GetSpriteExtents(pSprite);
                            Engine.clipmoveboxtracenum = 1;
                            int moveHit = 0;
                            if (!DEMO.IsOriginalDemo()) {
                                moveHit = Main.engine.clipmove(x, y, z2, nSector, xvel << 14, yvel << 14, pSprite.clipdist << 2, (pSprite.z - Gameutils.extents_zTop) / 4, (Gameutils.extents_zBot - pSprite.z) / 4, 65537);
                                x = Engine.clipmove_x;
                                y = Engine.clipmove_y;
                                z2 = Engine.clipmove_z;
                                nSector = Engine.clipmove_sectnum;
                            } else {
                                moveHit = Gameutils.ClipMove(x, y, z2, nSector, xvel, yvel, pSprite.clipdist << 2, (pSprite.z - Gameutils.extents_zTop) / 4, (Gameutils.extents_zBot - pSprite.z) / 4, 65537);
                                x = Gameutils.clipm_px;
                                y = Gameutils.clipm_py;
                                z2 = Gameutils.clipm_pz;
                                nSector = (short)Gameutils.clipm_pnsectnum;
                            }
                            Engine.clipmoveboxtracenum = 3;
                            if (nSector == -1) {
                                hitInfo = -1;
                                if (pOwner != null) {
                                    pOwner.cstat = oldcstat;
                                }
                                if (!DEMO.IsOriginalDemo() && (hitInfo = Gameutils.HitScan(pSprite, z2, xvel, yvel, zvel, Engine.pHitInfo, 65537, 0)) != -1) {
                                    if (pOwner != null) {
                                        pOwner.cstat = oldcstat;
                                    }
                                    Actor.actImpactMissile(pSprite, hitInfo);
                                }
                                break block142;
                            }
                            if (moveHit != 0) {
                                int nHitType = moveHit & 0xE000;
                                if (nHitType == 49152) {
                                    Engine.pHitInfo.hitsprite = (short)(moveHit & 0x1FFF);
                                    hitInfo = 3;
                                }
                                if (nHitType == 32768) {
                                    Engine.pHitInfo.hitwall = (short)(moveHit & 0x1FFF);
                                    if (Engine.wall[Engine.pHitInfo.hitwall].nextsector == -1) {
                                        hitInfo = 0;
                                    } else {
                                        Main.engine.getzsofslope(Engine.wall[Engine.pHitInfo.hitwall].nextsector, pSprite.x, pSprite.y, Globals.zofslope);
                                        hitInfo = pSprite.z > Globals.zofslope[0] && pSprite.z < Globals.zofslope[1] ? 4 : 0;
                                    }
                                }
                            }
                            if (hitInfo != 4 || (nXWall = Engine.wall[Engine.pHitInfo.hitwall].extra) <= 0) break block143;
                            XWALL pXWall = DB.xwall[nXWall];
                            if (!pXWall.triggerVector) break block143;
                            Trigger.trTriggerWall(Engine.pHitInfo.hitwall, pXWall, 51);
                            if ((Engine.wall[Engine.pHitInfo.hitwall].cstat & 0x40) != 0) break block143;
                            hitInfo = -1;
                        } while (nImpact-- > 0);
                        hitInfo = 0;
                        if (pOwner != null) {
                            pOwner.cstat = oldcstat;
                        }
                        Actor.actImpactMissile(pSprite, hitInfo);
                        break block142;
                    }
                    if (hitInfo != -1 && hitInfo != 3) {
                        short nAngle = Main.engine.getangle((int)sprXVel[pSprite.xvel], (int)sprYVel[pSprite.xvel]);
                        int moveDist = (int)Main.engine.qdist(sprXVel[pSprite.xvel], sprYVel[pSprite.xvel]);
                        zvel = (int)((long)zvel - (sprZVel[pSprite.xvel] << 8) / (long)moveDist);
                        nSector = Main.engine.updatesector(x -= Pragmas.mulscale(Trig.Cos(nAngle), 16L, 30), y -= Pragmas.mulscale(Trig.Sin(nAngle), 16L, 30), nSector);
                    }
                    Gameutils.GetZRange(x, y, z2, nSector, pSprite.clipdist << 2, 65537);
                    int ceilz = Gameutils.gz_ceilZ;
                    int ceilhit = Gameutils.gz_ceilHit;
                    int floorz = Gameutils.gz_floorZ;
                    int floorhit = Gameutils.gz_floorHit;
                    Gameutils.GetSpriteExtents(pSprite);
                    Gameutils.extents_zTop += zvel;
                    if ((Gameutils.extents_zBot += zvel) >= floorz) {
                        Actor.gSpriteHit[pSprite.extra].floorHit = floorhit;
                        hitInfo = 2;
                        zvel += floorz - Gameutils.extents_zBot;
                    }
                    if (Gameutils.extents_zTop <= ceilz) {
                        Actor.gSpriteHit[pSprite.extra].ceilHit = ceilhit;
                        hitInfo = 1;
                        if (ceilz - Gameutils.extents_zTop > 0) {
                            zvel += ceilz - Gameutils.extents_zTop;
                        }
                    }
                    pSprite.x = x;
                    pSprite.y = y;
                    pSprite.z = zvel + z2;
                    short uSector = Main.engine.updatesector(x, y, nSector);
                    if (uSector >= 0 && nSector != pSprite.sectnum) {
                        if (uSector >= Globals.kMaxSectors) {
                            Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                        }
                        DB.changespritesect(pSprite.xvel, uSector);
                    }
                    Warp.checkWarping(pSprite);
                    Engine.pHitInfo.hitsect = pSprite.sectnum;
                    Engine.pHitInfo.hitx = pSprite.x;
                    Engine.pHitInfo.hity = pSprite.y;
                    Engine.pHitInfo.hitz = pSprite.z;
                    if (pOwner != null) {
                        pOwner.cstat = oldcstat;
                    }
                    if (hitInfo != -1) {
                        Actor.actImpactMissile(pSprite, hitInfo);
                    }
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        nSprite = Engine.headspritestat[2];
        while (true) {
            block152: {
                int nWall;
                int radius;
                short nSector;
                int y;
                int x;
                EXPLODE pExpl;
                XSPRITE pXSprite;
                short nXSprite2;
                int nOwner;
                block153: {
                    block151: {
                        if (nSprite < 0) break block151;
                        pSprite = Engine.sprite[nSprite];
                        if ((pSprite.hitag & 0x20) != 0) break block152;
                        nOwner = Actor.actGetOwner(pSprite);
                        short nType = pSprite.lotag;
                        if (nType < 0 || nType >= 8) {
                            Main.game.dassert("nType >= 0 && nType < kExplodeMax: " + nType);
                        }
                        if ((nXSprite2 = pSprite.extra) <= 0 || nXSprite2 >= 2048) {
                            Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites: " + nXSprite2);
                        }
                        pXSprite = DB.xsprite[nXSprite2];
                        pExpl = gExplodeData[nType];
                        x = pSprite.x;
                        y = pSprite.y;
                        z = pSprite.z;
                        nSector = pSprite.sectnum;
                        radius = pXSprite.data4;
                        if (pXSprite.data4 <= 0) {
                            radius = pExpl.radius;
                        }
                        Actor.gSectorExp[0] = -1;
                        Actor.gWallExp[0] = -1;
                        Gameutils.NearSectors(nSector, x, y, radius, gSectorExp, gSpriteExp, gWallExp);
                        nWall = -1;
                        break block153;
                    }
                    nSprite = Engine.headspritestat[11];
                    break;
                }
                for (int n = 0; n < 512 && (nWall = gWallExp[n]) != -1; ++n) {
                    Trigger.trTriggerWall(gWallExp[n], DB.xwall[Engine.wall[nWall].extra], 51);
                }
                short nAffected = Engine.headspritestat[6];
                while (nAffected >= 0) {
                    SPRITE pDude = Engine.sprite[nAffected];
                    if ((pDude.hitag & 0x20) == 0 && (gSpriteExp[pDude.sectnum >> 3] & 1 << (pDude.sectnum & 7)) != 0 && pXSprite.data1 != 0 && Gameutils.CheckProximity(pDude, x, y, z, nSector, radius)) {
                        if (pExpl.used1 != 0 && pXSprite.target == 0) {
                            pXSprite.target |= 1;
                            Actor.actDamageSprite(nOwner, pDude, 0, Gameutils.Random(pExpl.used2) + pExpl.used1 << 4);
                        }
                        if (pExpl.damageType != 0) {
                            Actor.ConcussSprite(nOwner, pDude, x, y, z, pExpl.damageType);
                        }
                        if (pExpl.burnCount != 0) {
                            if (pDude.extra <= 0 || pDude.extra >= 2048) {
                                Main.game.dassert("pDude.extra > 0 && pDude.extra < kMaxXSprites");
                            }
                            XSPRITE pXDude = DB.xsprite[pDude.extra];
                            if (pXDude.burnTime == 0) {
                                EVENT.evPostCallback(nAffected, 3, 0L, 0);
                            }
                            pXDude.burnSource = pSprite.owner;
                            pXDude.burnTime = Gameutils.ClipHigh(pXDude.burnTime + 4 * pExpl.burnCount, 2400);
                        }
                    }
                    nAffected = Engine.nextspritestat[nAffected];
                }
                nAffected = Engine.headspritestat[4];
                while (nAffected >= 0) {
                    SPRITE pThing = Engine.sprite[nAffected];
                    if ((pThing.hitag & 0x20) == 0 && (gSpriteExp[pThing.sectnum >> 3] & 1 << (pThing.sectnum & 7)) != 0 && pXSprite.data1 != 0 && DB.xsprite[pThing.extra].Locked == 0 && Gameutils.CheckProximity(pThing, x, y, z, nSector, radius)) {
                        if (pExpl.damageType != 0) {
                            Actor.ConcussSprite(nOwner, pThing, x, y, z, pExpl.damageType);
                        }
                        if (pExpl.burnCount != 0) {
                            if (pThing.extra <= 0 || pThing.extra >= 2048) {
                                Main.game.dassert("pThing.extra > 0 && pThing.extra < kMaxXSprites");
                            }
                            XSPRITE pXThing = DB.xsprite[pThing.extra];
                            if (pThing.lotag == 400 && pXThing.burnTime == 0) {
                                EVENT.evPostCallback(nAffected, 3, 0L, 0);
                            }
                            pXThing.burnSource = pSprite.owner;
                            pXThing.burnTime = Gameutils.ClipHigh(pXThing.burnTime + 4 * pExpl.burnCount, 1200);
                        }
                    }
                    nAffected = Engine.nextspritestat[nAffected];
                }
                nAffected = Mmulti.connecthead;
                while (nAffected >= 0) {
                    SPRITE pPlayer = Globals.gPlayer[nAffected].pSprite;
                    int dx = pSprite.x - pPlayer.x >> 4;
                    int dy = pSprite.y - pPlayer.y >> 4;
                    int dz = pSprite.z - pPlayer.z >> 8;
                    int dist2 = dx * dx + dy * dy + dz * dz + 262144;
                    int force = pXSprite.data2 << 16;
                    Globals.gPlayer[nAffected].explosion += force / dist2;
                    nAffected = Mmulti.connectpoint2[nAffected];
                }
                if (pSprite.hitag != 1) {
                    pXSprite.data1 = (short)Gameutils.ClipLow(pXSprite.data1 - Globals.kFrameTicks, 0);
                    pXSprite.data2 = (short)Gameutils.ClipLow(pXSprite.data2 - Globals.kFrameTicks, 0);
                    pXSprite.data3 = (short)Gameutils.ClipLow(pXSprite.data3 - Globals.kFrameTicks, 0);
                }
                if (pXSprite.data1 == 0 && pXSprite.data2 == 0 && pXSprite.data3 == 0 && SeqHandling.seqFrame(3, nXSprite2) < 0) {
                    Actor.actPostSprite(nSprite, 1024);
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        while (nSprite >= 0) {
            SPRITE pTrap = Engine.sprite[nSprite];
            if ((pTrap.hitag & 0x20) == 0) {
                nXSprite = pTrap.extra;
                XSPRITE pXSprite = null;
                if (nXSprite > 0) {
                    if (nXSprite >= 2048) {
                        Main.game.dassert("nXSprite < kMaxXSprites");
                    }
                    pXSprite = DB.xsprite[nXSprite];
                    switch (pTrap.lotag) {
                        case 452: {
                            if (pXSprite.state == 0 || SeqHandling.seqFrame(3, nXSprite) >= 0) break;
                            int x = pTrap.x;
                            int y = pTrap.y;
                            int z3 = pTrap.z;
                            int dx = Pragmas.mulscale(Trig.Cos(pTrap.ang), (pXSprite.data1 << 23) / 120, 30);
                            int dy = Pragmas.mulscale(Trig.Sin(pTrap.ang), (pXSprite.data1 << 23) / 120, 30);
                            for (int i = 0; i < 2; x += dx / 2 >> 12, y += dy / 2 >> 12, ++i) {
                                SPRITE pSpawn = Actor.actSpawnEffect(32, pTrap.sectnum, x, y, z3, 0);
                                if (pSpawn == null) continue;
                                Actor.sprXVel[pSpawn.xvel] = dx + Gameutils.BiRandom(34952);
                                Actor.sprYVel[pSpawn.xvel] = dy + Gameutils.BiRandom(34952);
                                Actor.sprZVel[pSpawn.xvel] = Gameutils.BiRandom(34952);
                            }
                            Actor.gVectorData[20].maxDist = pXSprite.data1 << 9;
                            Actor.actFireVector(pTrap, 0, 0, Trig.Cos(pTrap.ang) >> 16, Trig.Sin(pTrap.ang) >> 16, Gameutils.BiRandom(34952), 20);
                            break;
                        }
                        case 454: {
                            pXSprite.data2 = (short)Gameutils.ClipLow(pXSprite.data2 - Globals.kFrameTicks, 0);
                            break;
                        }
                    }
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        nSprite = Engine.headspritestat[6];
        while (nSprite >= 0) {
            pSprite = Engine.sprite[nSprite];
            nXSprite = pSprite.extra;
            if (Actor.IsDudeSprite(pSprite) && (pSprite.hitag & 0x20) == 0 && nXSprite > 0) {
                XSPRITE pXIncarnation;
                XSPRITE pXSprite = DB.xsprite[nXSprite];
                if (Actor.actGetBurnTime(pXSprite) > 0) {
                    if ((pSprite.lotag < 239 || pSprite.lotag > 242) && pSprite.lotag != 252 && pSprite.lotag != 253) {
                        pXSprite.burnTime = Gameutils.ClipLow(pXSprite.burnTime - Globals.kFrameTicks, 0);
                    }
                    Actor.actDamageSprite(Actor.actGetBurnSource(pXSprite.burnSource), Engine.sprite[nSprite], 1, 2 * Globals.kFrameTicks);
                }
                if (pSprite.lotag == 254 && pXSprite.health <= 0 && SeqHandling.seqFrame(3, nXSprite) < 0 && (pXIncarnation = EVENT.getNextIncarnation(pXSprite)) != null) {
                    long hp;
                    SPRITE pIncarnation = Engine.sprite[pXIncarnation.reference];
                    pSprite.lotag = pIncarnation.lotag;
                    pSprite.pal = pIncarnation.pal;
                    pSprite.shade = pIncarnation.shade;
                    pSprite.clipdist = pIncarnation.clipdist;
                    pSprite.xrepeat = pIncarnation.xrepeat;
                    pSprite.yrepeat = pIncarnation.yrepeat;
                    pXSprite.txID = pXIncarnation.txID;
                    pXSprite.command = pXIncarnation.command;
                    pXSprite.triggerOn = pXIncarnation.triggerOn;
                    pXSprite.triggerOff = pXIncarnation.triggerOff;
                    pXSprite.burnTime = 0;
                    pXSprite.burnSource = -1;
                    pXSprite.data1 = pXIncarnation.data1;
                    pXSprite.data2 = pXIncarnation.data2;
                    pXSprite.data3 = pXIncarnation.data3;
                    pXSprite.data4 = pXIncarnation.data4;
                    pXSprite.dudeGuard = pXIncarnation.dudeGuard;
                    pXSprite.dudeDeaf = pXIncarnation.dudeDeaf;
                    pXSprite.dudeAmbush = pXIncarnation.dudeAmbush;
                    pXSprite.dudeFlag4 = pXIncarnation.dudeFlag4;
                    pXSprite.busyTime = pXIncarnation.busyTime;
                    switch (pSprite.lotag) {
                        case 254: 
                        case 255: {
                            SeqHandling.seqSpawn(AIUNICULT.getSeqStartId(pXSprite), 3, nXSprite, null);
                            break;
                        }
                        default: {
                            SeqHandling.seqSpawn(DudeInfo.dudeInfo[pSprite.lotag - 200].seqStartID, 3, nXSprite, null);
                        }
                    }
                    pXSprite.health = pXSprite.data4 <= 0 ? DudeInfo.dudeInfo[pSprite.lotag - 200].startHealth << 4 & 0xFFF : (int)((hp = (long)(pXSprite.data4 << 4 & 0xFFF)) > 0L ? (hp <= 65535L ? hp : 65535L) : 1L);
                    Ai.aiInit(pSprite, false);
                    if (pXSprite.target == -1) {
                        Ai.aiSetTarget(pXSprite, 0, 0, 0);
                    } else {
                        Ai.aiSetTarget(pXSprite, pXSprite.target);
                    }
                    Ai.aiActivateDude(pSprite, pXSprite);
                }
                if (pSprite.lotag == 227 && pXSprite.health == 0 && SeqHandling.seqFrame(3, nXSprite) < 0) {
                    pXSprite.health = DudeInfo.dudeInfo[28].startHealth << 4;
                    pSprite.lotag = (short)228;
                    if (pXSprite.target == -1) {
                        Ai.aiSetTarget(pXSprite, 0, 0, 0);
                    } else {
                        Ai.aiSetTarget(pXSprite, pXSprite.target);
                    }
                    Ai.aiActivateDude(pSprite, pXSprite);
                }
                if (pXSprite.Proximity && !pXSprite.isTriggered) {
                    short nrSprite = Engine.headspritestat[6];
                    while (nrSprite >= 0) {
                        SPRITE prSprite = Engine.sprite[nrSprite];
                        if ((prSprite.hitag & 0x20) == 0 && prSprite.extra > 0 && DB.xsprite[prSprite.extra].health != 0 && Gameutils.IsPlayerSprite(prSprite) && Gameutils.CheckProximity(prSprite, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, 128)) {
                            Trigger.trTriggerSprite(nSprite, pXSprite, 35);
                        }
                        nrSprite = Engine.nextspritestat[nrSprite];
                    }
                }
                if (Gameutils.IsPlayerSprite(pSprite)) {
                    int nPlayer = pSprite.lotag - 231;
                    PLAYER pPlayer = Globals.gPlayer[nPlayer];
                    if (pPlayer.handDamage && Gameutils.Chance(16384)) {
                        Actor.actDamageSprite(pSprite.xvel, pSprite, 4, 12);
                    }
                    if (pPlayer.Underwater) {
                        boolean haveDivingSuit = PLAYER.inventoryCheck(pPlayer, 1);
                        pPlayer.airTime = haveDivingSuit || pPlayer.godMode ? 1200 : Gameutils.ClipLow(pPlayer.airTime - Globals.kFrameTicks, 0);
                        if (pPlayer.airTime < 1080 && PLAYER.getInventoryAmount(pPlayer, 1) != 0 && !haveDivingSuit) {
                            PLAYER.processInventory(pPlayer, 1);
                        }
                        if (pPlayer.airTime != 0) {
                            pPlayer.drownEffect = 0;
                        } else {
                            if (pPlayer.pXsprite.health > 0) {
                                pPlayer.drownEffect += Globals.kFrameTicks;
                            }
                            if (Gameutils.bRandom() < pPlayer.drownEffect >> 1) {
                                Actor.actDamageSprite(pSprite.xvel, pSprite, 4, 48);
                            }
                        }
                        if (sprXVel[pSprite.xvel] != 0L || sprYVel[pSprite.xvel] != 0L) {
                            SOUND.sfxStart3DSound(pSprite, 709, 100, 2);
                        }
                        pPlayer.bubbleTime = Gameutils.ClipLow(pPlayer.bubbleTime - Globals.kFrameTicks, 0);
                    } else if (Globals.pGameInfo.nGameType == 0 && pPlayer.pXsprite != null && pPlayer.pXsprite.health != 0 && pPlayer.stayTime >= 1200 && Gameutils.Chance(256)) {
                        pPlayer.stayTime = -1;
                        SOUND.sfxStart3DSound(pSprite, Gameutils.Random(11) + 3100, 0, 2);
                    }
                }
                Actor.ProcessTouchObjects(nSprite, nXSprite);
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        nSprite = Engine.headspritestat[6];
        while (nSprite >= 0) {
            SPRITE pSprite2 = Engine.sprite[nSprite];
            short nSector = pSprite2.sectnum;
            if ((pSprite2.hitag & 0x20) == 0 && Actor.IsDudeSprite(pSprite2)) {
                short nXSprite3;
                if (!DEMO.IsOriginalDemo() && Globals.pGameInfo.nGameType == 0 && Mmulti.numplayers < 2 && gNoEnemies == 2) {
                    pSprite2.cstat = (short)(pSprite2.cstat | 0x8000);
                    pSprite2.cstat = (short)(pSprite2.cstat & 0xFFFFEEFE);
                }
                if ((nXSprite3 = pSprite2.extra) <= 0 || nXSprite3 >= 2048) {
                    Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
                }
                View.viewBackupSpriteLoc(nSprite, pSprite2);
                int vel = 128;
                if (Engine.sector[nSector].extra > 0) {
                    XSECTOR pXSector;
                    short nXSector = Engine.sector[nSector].extra;
                    if (nXSector <= 0 || nXSector >= 512) {
                        Main.game.dassert("nXSector > 0 && nXSector < kMaxXSectors");
                    }
                    if (DB.xsector[nXSector].reference != nSector) {
                        Main.game.dassert("xsector[nXSector].reference == nSector");
                    }
                    if ((pXSector = DB.xsector[nXSector]) != null) {
                        Gameutils.GetSpriteExtents(pSprite2);
                        int zBot = Gameutils.extents_zBot;
                        if (Main.engine.getflorzofslope(nSector, pSprite2.x, pSprite2.y) <= zBot) {
                            int panVel = 0;
                            int panAngle = pXSector.panAngle;
                            if (pXSector.panAlways || pXSector.state != 0 || pXSector.busy != 0) {
                                panVel = (pXSector.panVel & 0xFF) << 9;
                                if (!pXSector.panAlways && pXSector.busy != 0) {
                                    panVel = Pragmas.mulscale(panVel, pXSector.busy, 16);
                                }
                            }
                            if ((Engine.sector[nSector].floorstat & 0x40) != 0) {
                                panAngle = Gameutils.GetWallAngle(Engine.sector[nSector].wallptr) + panAngle + 512 & 0x7FF;
                            }
                            int pushX = Pragmas.mulscale(panVel, Trig.Cos(panAngle), 30);
                            int pushY = Pragmas.mulscale(panVel, Trig.Sin(panAngle), 30);
                            short s = nSprite;
                            sprXVel[s] = sprXVel[s] + (long)pushX;
                            short s3 = nSprite;
                            sprYVel[s3] = sprYVel[s3] + (long)pushY;
                        }
                        if (pXSector != null && pXSector.Underwater) {
                            vel = 5376;
                        }
                    }
                }
                Actor.AirDrag(nSprite, vel);
                if ((pSprite2.hitag & 4) != 0 || sprXVel[nSprite] != 0L || sprYVel[nSprite] != 0L || sprZVel[nSprite] != 0L || floorVel[pSprite2.sectnum] != 0L || ceilingVel[pSprite2.sectnum] != 0L) {
                    Actor.MoveDude(nSprite);
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        nSprite = Engine.headspritestat[14];
        while (nSprite >= 0) {
            SPRITE pFlare = Engine.sprite[nSprite];
            if ((pFlare.hitag & 0x20) == 0) {
                short nXSprite4 = pFlare.extra;
                if (nXSprite4 <= 0 || nXSprite4 >= 2048) {
                    Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
                }
                XSPRITE pXSprite = DB.xsprite[nXSprite4];
                int nTarget = pXSprite.target;
                if (nTarget < 0) {
                    Main.game.dassert("nTarget >= 0");
                }
                View.viewBackupSpriteLoc(nSprite, pFlare);
                if (nTarget >= Globals.kMaxSprites) {
                    Main.game.dassert("nTarget < kMaxSprites");
                }
                SPRITE pTarget = Engine.sprite[nTarget];
                if (pTarget.statnum == 1024) {
                    Gib.actGenerateGibs(pFlare, 17, null, null);
                    Actor.actPostSprite(pFlare.xvel, 1024);
                }
                if (pTarget.extra > 0 && DB.xsprite[pTarget.extra].health != 0) {
                    int nAngle = pTarget.ang + pXSprite.goalAng;
                    int x = pTarget.x + Pragmas.mulscaler(Trig.Cos(nAngle), pTarget.clipdist << 1, 30);
                    int y = pTarget.y + Pragmas.mulscaler(Trig.Sin(nAngle), pTarget.clipdist << 1, 30);
                    z = pTarget.z + pXSprite.targetZ;
                    DB.setSprite(nSprite, x, y, z);
                    Actor.sprXVel[nSprite] = sprXVel[nTarget];
                    Actor.sprYVel[nSprite] = sprYVel[nTarget];
                    Actor.sprZVel[nSprite] = sprZVel[nTarget];
                } else {
                    Gib.actGenerateGibs(pFlare, 17, null, null);
                    Actor.actPostSprite(pFlare.xvel, 1024);
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        if (gNoEnemies == 0) {
            Ai.aiProcessDudes();
        }
        Actor.actProcessEffects();
    }

    public static void actDistanceDamage(int nSprite, int x, int y, int z, int sectnum, int Distance, int minHit, int damageType, int damageHit, int flags, int BurnTime) {
        int damage;
        int dist;
        short nXTarget;
        SPRITE pTarget;
        short i;
        Actor.gSectorExp[0] = -1;
        Actor.gWallExp[0] = -1;
        Gameutils.NearSectors(sectnum, x, y, Distance, gSectorExp, gSpriteExp, gWallExp);
        int mDist = Distance << 4;
        if ((flags & 2) != 0) {
            i = Engine.headspritestat[6];
            while (i >= 0) {
                if (i != nSprite || (flags & 1) != 0) {
                    int dz;
                    int dy;
                    int dx;
                    pTarget = Engine.sprite[i];
                    nXTarget = pTarget.extra;
                    if (nXTarget > 0 && nXTarget < 2048 && (pTarget.hitag & 0x20) == 0 && (gSpriteExp[pTarget.sectnum >> 3] & 1 << (pTarget.sectnum & 7)) != 0 && Gameutils.CheckProximity(pTarget, x, y, z, sectnum, mDist) && (dist = Main.engine.ksqrt((dx = Pragmas.klabs(x - pTarget.x)) * dx + (dy = Pragmas.klabs(y - pTarget.y)) * dy + (dz = Pragmas.klabs(z - pTarget.z) >> 4) * dz)) <= mDist) {
                        damage = dist != 0 ? damageHit * (mDist - dist) / mDist + minHit : damageHit + minHit;
                        Actor.actDamageSprite(nSprite, pTarget, damageType, damage << 4);
                        if (BurnTime != 0) {
                            XSPRITE pXTarget = DB.xsprite[nXTarget];
                            pXTarget.burnTime = Gameutils.ClipHigh(pXTarget.burnTime + BurnTime, 2400);
                            pXTarget.burnSource = Actor.actSetBurnSource(nSprite);
                        }
                    }
                }
                i = Engine.nextspritestat[i];
            }
        }
        if ((flags & 4) != 0) {
            i = Engine.headspritestat[4];
            while (i >= 0) {
                pTarget = Engine.sprite[i];
                nXTarget = pTarget.extra;
                if (nXTarget > 0 && nXTarget < 2048 && (pTarget.hitag & 0x20) == 0 && (gSpriteExp[pTarget.sectnum >> 3] & 1 << (pTarget.sectnum & 7)) != 0 && Gameutils.CheckProximity(pTarget, x, y, z, sectnum, mDist)) {
                    int dy;
                    int dx;
                    XSPRITE pXTarget = DB.xsprite[nXTarget];
                    if (pXTarget.Locked == 0 && (dist = Main.engine.ksqrt((dx = Pragmas.klabs(x - pTarget.x)) * dx + (dy = Pragmas.klabs(y - pTarget.y)) * dy)) <= mDist) {
                        damage = dist != 0 ? minHit + damageHit * (mDist - dist) / mDist : damageHit + minHit;
                        Actor.actDamageSprite(nSprite, pTarget, damageType, damage << 4);
                        if (BurnTime != 0) {
                            pXTarget.burnTime = Gameutils.ClipHigh(pXTarget.burnTime + BurnTime, 1200);
                            pXTarget.burnSource = Actor.actSetBurnSource(nSprite);
                        }
                    }
                }
                i = Engine.nextspritestat[i];
            }
        }
    }

    public static int actCheckSpawnType(int nType) {
        if (nType > 3 && nType < 13 || nType > 36) {
            return nType;
        }
        return -1;
    }

    public static void actSpawnBlood(SPRITE pSprite) {
        short nSector = pSprite.sectnum;
        if (nSector >= 0 && nSector <= Engine.numsectors) {
            SPRITE pSpawn;
            boolean find = Gameutils.FindSector(pSprite.x, pSprite.y, pSprite.z, nSector);
            nSector = Gameutils.foundSector;
            if (find && (!Main.cfg.gParentalLock || Globals.pGameInfo.nGameType > 0) && (pSpawn = Actor.actSpawnEffect(27, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0)) != null) {
                pSpawn.ang = (short)1024;
                Actor.sprXVel[pSpawn.xvel] = Gameutils.BiRandom(436906);
                Actor.sprYVel[pSpawn.xvel] = Gameutils.BiRandom(436906);
                Actor.sprZVel[pSpawn.xvel] = -Gameutils.Random(0x10AAAA) - 100;
                EVENT.evPostCallback(pSpawn.xvel, 3, 8L, 6);
            }
        }
    }

    public static void actSpawnTentacleBlood(SPRITE pSprite) {
        short nSector = pSprite.sectnum;
        if (nSector >= 0 && nSector <= Engine.numsectors) {
            boolean find = Gameutils.FindSector(pSprite.x, pSprite.y, pSprite.z, nSector);
            nSector = Gameutils.foundSector;
            if (find && (!Main.cfg.gParentalLock || Globals.pGameInfo.nGameType > 0)) {
                SPRITE pSpawn;
                int nType = 54;
                if (pSprite.lotag == 221) {
                    nType = 53;
                }
                if ((pSpawn = Actor.actSpawnEffect(nType, pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0)) != null) {
                    pSpawn.ang = (short)1024;
                    Actor.sprXVel[pSpawn.xvel] = Gameutils.BiRandom(436906);
                    Actor.sprYVel[pSpawn.xvel] = Gameutils.BiRandom(436906);
                    Actor.sprZVel[pSpawn.xvel] = -Gameutils.Random(0x10AAAA) - 100;
                    EVENT.evPostCallback(pSpawn.xvel, 3, 8L, 18);
                }
            }
        }
    }

    public static void actSpawnSSheels(SPRITE pSprite, int z, int offset, int vel) {
        int x = Pragmas.mulscale(Trig.Cos(pSprite.ang + 512), offset, 30) + Pragmas.mulscale(Trig.Sin(pSprite.ang + 512), pSprite.clipdist - 4 << 2, 30) + pSprite.x;
        int y = Pragmas.mulscale(Trig.Cos(pSprite.ang), offset, 30) + Pragmas.mulscale(Trig.Sin(pSprite.ang), pSprite.clipdist - 4 << 2, 30) + pSprite.y;
        SPRITE pSpawn = Actor.actSpawnEffect(40 + Gameutils.Random(3), pSprite.sectnum, x, y, z, 0);
        if (pSpawn != null) {
            int velocity = (vel << 18) / 120 + Gameutils.BiRandom((vel / 4 << 18) / 120);
            int nAngle = pSprite.ang + Gameutils.BiRandom(56) + 512;
            Actor.sprXVel[pSpawn.xvel] = Pragmas.mulscale(Trig.Cos(nAngle), velocity, 30);
            Actor.sprYVel[pSpawn.xvel] = Pragmas.mulscale(Trig.Sin(nAngle), velocity, 30);
            Actor.sprZVel[pSpawn.xvel] = sprZVel[pSprite.xvel] - 131072L - (long)((Gameutils.BiRandom(20) << 18) / 120);
        }
    }

    public static void actSpawnTSheels(SPRITE pSprite, int z, int offset, int vel) {
        int x = Pragmas.mulscale(Trig.Cos(pSprite.ang + 512), offset, 30) + Pragmas.mulscale(Trig.Sin(pSprite.ang + 512), pSprite.clipdist - 4 << 2, 30) + pSprite.x;
        int y = Pragmas.mulscale(Trig.Cos(pSprite.ang), offset, 30) + Pragmas.mulscale(Trig.Sin(pSprite.ang), pSprite.clipdist - 4 << 2, 30) + pSprite.y;
        SPRITE pSpawn = Actor.actSpawnEffect(37 + Gameutils.Random(3), pSprite.sectnum, x, y, z, 0);
        if (pSpawn != null) {
            int velocity = (vel << 18) / 120 + Gameutils.BiRandom((vel / 4 << 18) / 120);
            int nAngle = pSprite.ang + Gameutils.BiRandom(56) + 512;
            Actor.sprXVel[pSpawn.xvel] = Pragmas.mulscale(Trig.Cos(nAngle), velocity, 30);
            Actor.sprYVel[pSpawn.xvel] = Pragmas.mulscale(Trig.Sin(nAngle), velocity, 30);
            Actor.sprZVel[pSpawn.xvel] = sprZVel[pSprite.xvel] - 131072L - (long)((Gameutils.BiRandom(40) << 18) / 120);
        }
    }

    public static void actDeleteEffect(int nSprite) {
        if (nSprite >= 0 && nSprite < Globals.kMaxSprites) {
            EVENT.checkEventList(nSprite, 3);
            if (Engine.sprite[nSprite].extra > 0) {
                SeqHandling.seqKill(3, Engine.sprite[nSprite].extra);
            }
            DB.deletesprite((short)nSprite);
        }
    }

    public static void actDeleteEffect2(int nSprite) {
        if (nSprite >= 0 && nSprite < Globals.kMaxSprites) {
            short nXSprite = Engine.sprite[nSprite].extra;
            if (nXSprite > 0) {
                SeqHandling.seqKill(3, nXSprite);
            }
            if (Engine.sprite[nSprite].statnum != 1024) {
                Actor.actPostSprite(nSprite, 1024);
            }
        }
    }

    public static SPRITE actSpawnEffect(int nType, short nSector, int x, int y, int z, int nBusy) {
        if (nSector < 0 || nSector > Engine.numsectors) {
            return null;
        }
        if (!Gameutils.FindSector(x, y, z, nSector)) {
            return null;
        }
        if (!DEMO.IsOriginalDemo() && EVENT.eventQ.getSize() >= 768) {
            return null;
        }
        if (Main.cfg.gParentalLock && Globals.pGameInfo.nGameType <= 0 && Actor.actCheckSpawnType(nType) == -1) {
            return null;
        }
        if ((nType & 0x80) == 0 && nType < 57) {
            EFFECT nEffect = gEffectInfo[nType];
            if (DB.nStatSize[1] == 512) {
                short nSprite = Engine.headspritestat[1];
                while ((Engine.sprite[nSprite].hitag & 0x20) != 0 && nSprite != -1) {
                    nSprite = Engine.nextspritestat[nSprite];
                }
                if (nSprite == -1) {
                    return null;
                }
                Actor.actDeleteEffect(nSprite);
            }
            int nSpawn = Actor.actSpawnSprite(nSector, x, y, z, 1, false);
            SPRITE pSpawn = Engine.sprite[nSpawn];
            pSpawn.lotag = (short)nType;
            pSpawn.picnum = (short)nEffect.picnum;
            pSpawn.cstat = (short)(pSpawn.cstat | nEffect.cstat);
            pSpawn.shade = (byte)nEffect.shade;
            pSpawn.pal = (byte)nEffect.pal;
            pSpawn.detail = (byte)nEffect.detail;
            if (nEffect.xrepeat > 0) {
                pSpawn.xrepeat = (short)nEffect.xrepeat;
            }
            if (nEffect.yrepeat > 0) {
                pSpawn.yrepeat = (short)nEffect.yrepeat;
            }
            if ((nEffect.flags & 1) != 0 && Gameutils.Chance(16384)) {
                pSpawn.cstat = (short)(pSpawn.cstat ^ 4);
            }
            if ((nEffect.flags & 2) != 0 && Gameutils.Chance(16384)) {
                pSpawn.cstat = (short)(pSpawn.cstat ^ 8);
            }
            if (nEffect.seqId != 0) {
                SeqHandling.seqSpawn(nEffect.seqId, 3, DB.dbInsertXSprite(pSpawn.xvel), null);
            }
            if (nBusy == 0) {
                nBusy = nEffect.count;
            }
            if (nBusy != 0) {
                EVENT.evPostCallback(pSpawn.xvel, 3, Gameutils.BiRandom(nBusy >> 1) + nBusy, 1);
            }
            return pSpawn;
        }
        return null;
    }

    public static int GetDataVal(SPRITE pSprite, int data) {
        if (pSprite.extra < 0) {
            return -1;
        }
        XSPRITE pXSprite = DB.xsprite[pSprite.extra];
        int[] rData = new int[4];
        rData[0] = pXSprite.data1;
        rData[2] = pXSprite.data3;
        rData[1] = pXSprite.data2;
        rData[3] = pXSprite.data4;
        return rData[data];
    }

    public static int GetRandDataVal(int[] rData, SPRITE pSprite) {
        if (rData != null && pSprite != null) {
            return -1;
        }
        if (pSprite != null) {
            if (pSprite.extra < 0) {
                return -1;
            }
            rData = new int[4];
            XSPRITE pXSprite = DB.xsprite[pSprite.extra];
            rData[0] = pXSprite.data1;
            rData[2] = pXSprite.data3;
            rData[1] = pXSprite.data2;
            rData[3] = pXSprite.data4;
        } else if (rData == null) {
            return -1;
        }
        int random = 0;
        int a = 1;
        int b = -1;
        for (int i = 0; i <= 3; ++i) {
            if (rData[i] == 0) {
                if (a++ <= 2) continue;
                return -1;
            }
            if (b != -1) continue;
            ++b;
        }
        for (int maxRetries = 10; maxRetries > 0; --maxRetries) {
            random = Globals.pGameInfo.nGameType == 0 && Mmulti.numplayers < 2 ? (int)(4.0 * Math.random()) : Gameutils.Random(3);
            if (rData[random] <= 0) continue;
            return rData[random];
        }
        return rData[b];
    }

    public static SPRITE DropRandomPickupObject(SPRITE pSprite, short prevItem) {
        SPRITE pSprite2 = null;
        int[] rData = new int[4];
        short selected = -1;
        rData[0] = DB.xsprite[pSprite.extra].data1;
        rData[2] = DB.xsprite[pSprite.extra].data3;
        rData[1] = DB.xsprite[pSprite.extra].data2;
        rData[3] = DB.xsprite[pSprite.extra].data4;
        for (int i = 0; i <= 3; ++i) {
            if (rData[i] >= 40 && rData[i] < 149) continue;
            rData[i] = 0;
        }
        int maxRetries = 9;
        while ((selected = Actor.GetRandDataVal(rData, null)) == prevItem && maxRetries-- > 0) {
        }
        if (selected > 0) {
            SPRITE pSource = pSprite;
            XSPRITE pXSource = DB.xsprite[pSource.extra];
            pSprite2 = Actor.DropPickupObject(pSprite, selected);
            if (pSprite2 != null) {
                pSprite2.x = pSource.x;
                pSprite2.y = pSource.y;
                pSprite2.z = pSource.z;
                pXSource.dropMsg = pSprite2.lotag;
                Tile.tileLoadVoxel(pSprite2.picnum);
                if ((pSource.hitag & 1) != 0 && DB.dbInsertXSprite(pSprite2.xvel) > 0) {
                    XSPRITE pXSprite2 = DB.xsprite[pSprite2.extra];
                    pXSprite2.txID = pXSource.txID;
                    pXSprite2.command = pXSource.command;
                    pXSprite2.triggerOn = pXSource.triggerOn;
                    pXSprite2.triggerOff = pXSource.triggerOff;
                    pXSprite2.Pickup = true;
                }
            }
        }
        return pSprite2;
    }

    public static SPRITE spawnRandomDude(SPRITE pSprite) {
        SPRITE pSprite2 = null;
        if (pSprite.extra >= 0) {
            int[] rData = new int[4];
            int selected = -1;
            rData[0] = DB.xsprite[pSprite.extra].data1;
            rData[2] = DB.xsprite[pSprite.extra].data3;
            rData[1] = DB.xsprite[pSprite.extra].data2;
            rData[3] = DB.xsprite[pSprite.extra].data4;
            for (int i = 0; i <= 3; ++i) {
                if (rData[i] >= 200 && rData[i] < 256) continue;
                rData[i] = 0;
            }
            selected = Actor.GetRandDataVal(rData, null);
            if (selected > 0) {
                pSprite2 = Actor.actSpawnDude(pSprite, selected, -1);
            }
        }
        return pSprite2;
    }

    public static void actInitStruct() {
        int i;
        for (i = 0; i < 2048; ++i) {
            if (gSpriteHit[i] == null) {
                Actor.gSpriteHit[i] = new SPRITEHIT();
                continue;
            }
            gSpriteHit[i].clear();
        }
        for (i = 0; i < Globals.kMaxSprites; ++i) {
            if (gPost[i] == null) {
                Actor.gPost[i] = new POSTPONE();
                continue;
            }
            gPost[i].clear();
        }
    }

    public static void actInit(boolean loadgame, boolean isOriginal) {
        XSPRITE pXSprite;
        short nXSprite;
        SPRITE pSprite;
        Actor.actInitStruct();
        short nSprite = Engine.headspritestat[3];
        while (nSprite >= 0) {
            pSprite = Engine.sprite[nSprite];
            if (pSprite.lotag == 44) {
                pSprite.lotag = (short)70;
            }
            switch (pSprite.lotag) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    if (pSprite.extra <= 0) break;
                    DB.xsprite[pSprite.extra].respawn = 0;
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        nSprite = Engine.headspritestat[11];
        while (nSprite >= 0) {
            pSprite = Engine.sprite[nSprite];
            nXSprite = pSprite.extra;
            pXSprite = null;
            if (nXSprite > 0 && nXSprite < 2048) {
                pXSprite = DB.xsprite[nXSprite];
            }
            if (pSprite.lotag == 452 && pSprite.picnum == 2183 && pXSprite != null && pXSprite.state == 0) {
                SeqHandling.seqSpawn(VERSION.getSeq(5), 3, pSprite.extra, null);
            }
            if (pSprite.lotag == 459) {
                pXSprite.state = 0;
                if (pXSprite.waitTime < 1) {
                    pXSprite.waitTime = 1;
                }
                pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFFFE);
                pSprite.cstat = (short)(pSprite.cstat | 0x8000);
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        nSprite = Engine.headspritestat[4];
        while (nSprite >= 0) {
            pSprite = Engine.sprite[nSprite];
            nXSprite = pSprite.extra;
            if (nXSprite <= 0 || nXSprite >= 2048) {
                Main.game.GameMessage("nXSprite > 0 && nXSprite < kMaxXSprites");
                return;
            }
            pXSprite = DB.xsprite[nXSprite];
            THINGINFO pThinkInfo = thingInfo[pSprite.lotag - 400];
            pXSprite.health = pThinkInfo.startHealth << 4;
            pSprite.clipdist = pThinkInfo.clipdist;
            pSprite.hitag = (short)pThinkInfo.flags;
            if ((pSprite.hitag & 2) != 0) {
                pSprite.hitag = (short)(pSprite.hitag | 4);
            }
            Actor.sprXVel[nSprite] = 0L;
            Actor.sprYVel[nSprite] = 0L;
            Actor.sprZVel[nSprite] = 0L;
            switch (pSprite.lotag) {
                case 401: 
                case 413: 
                case 433: {
                    pXSprite.state = 0;
                    break;
                }
                default: {
                    if (pSprite.lotag == 426) break;
                    pXSprite.state = 1;
                }
            }
            SeqInst pInst = SeqHandling.GetInstance(3, nXSprite);
            if (pInst != null && pInst.isPlaying() && BuildGdx.cache.contains(pInst.getSeqIndex(), "SEQ")) {
                SeqHandling.seqSpawn(pInst.getSeqIndex(), 3, nXSprite, null);
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        if (Globals.pGameInfo.nMonsterSettings != 0) {
            LEVELS.levelCalcKills();
            for (int i = 0; i < DudeInfo.dudeInfo.length; ++i) {
                for (int j = 0; j < 7; ++j) {
                    DudeInfo.dudeInfo[i].damageShift[j] = Pragmas.mulscale(DudeInfo.dudeInfo[i].startDamage[j], pSkillShift[Globals.pGameInfo.nEnemyDamage], 8);
                }
            }
            nSprite = Engine.headspritestat[6];
            while (nSprite >= 0) {
                SPRITE pSprite2 = Engine.sprite[nSprite];
                nXSprite = pSprite2.extra;
                if (nXSprite <= 0 || nXSprite >= 2048) {
                    Main.game.GameMessage("nXSprite > 0 && nXSprite < kMaxXSprites");
                    return;
                }
                pXSprite = DB.xsprite[nXSprite];
                int dudeIndex = pSprite2.lotag - 200;
                if (!Gameutils.IsPlayerSprite(pSprite2)) {
                    if (!isOriginal) {
                        if ((pSprite2.cstat & 0x30) != 0) {
                            pSprite2.cstat = (short)(pSprite2.cstat & ~(pSprite2.cstat & 0x30));
                        }
                        pSprite2.yoffset = 0;
                        pSprite2.xoffset = 0;
                    }
                    switch (pSprite2.lotag) {
                        case 225: {
                            break;
                        }
                        case 254: 
                        case 255: {
                            pSprite2.cstat = (short)(pSprite2.cstat | 0x1101);
                            break;
                        }
                        default: {
                            pSprite2.cstat = (short)(pSprite2.cstat | 0x1101);
                            pSprite2.clipdist = DudeInfo.dudeInfo[dudeIndex].clipdist;
                        }
                    }
                    Actor.sprXVel[nSprite] = 0L;
                    Actor.sprYVel[nSprite] = 0L;
                    Actor.sprZVel[nSprite] = 0L;
                    if (!loadgame) {
                        long hp;
                        pXSprite.health = pXSprite.data4 <= 0 || DEMO.IsOriginalDemo() ? DudeInfo.dudeInfo[dudeIndex].startHealth << 4 & 0xFFF : (int)((hp = (long)(pXSprite.data4 << 4 & 0xFFF)) > 0L ? (hp <= 65535L ? hp : 65535L) : 1L);
                    }
                }
                switch (pSprite2.lotag) {
                    case 254: 
                    case 255: {
                        SeqHandling.seqSpawn(AIUNICULT.getSeqStartId(pXSprite), 3, nXSprite, null);
                        break;
                    }
                    default: {
                        int seqStartId = DudeInfo.dudeInfo[dudeIndex].seqStartID + 0;
                        if (!BuildGdx.cache.contains(seqStartId, "SEQ")) break;
                        SeqHandling.seqSpawn(seqStartId, 3, nXSprite, null);
                    }
                }
                nSprite = Engine.nextspritestat[nSprite];
            }
            Ai.aiInit(isOriginal);
        } else {
            while (Engine.headspritestat[6] >= 0) {
                SPRITE pSprite3 = Engine.sprite[Engine.headspritestat[6]];
                if (DB.xsprite[pSprite3.extra].key > 0) {
                    Actor.DropPickupObject(pSprite3, 100 + DB.xsprite[pSprite3.extra].key - 1);
                }
                DB.deletesprite(Engine.headspritestat[6]);
            }
        }
    }

    public static int actGetRespawnTime(SPRITE pSprite) {
        if (pSprite.extra > 0) {
            XSPRITE pXSprite = DB.xsprite[pSprite.extra];
            if (Actor.IsDudeSprite(pSprite) && !Gameutils.IsPlayerSprite(pSprite) && (pXSprite.respawn == 2 || pXSprite.respawn != 1 && Globals.pGameInfo.nMonsterSettings == 2)) {
                return Globals.pGameInfo.nMonsterRespawnTime;
            }
            if (Actor.IsWeaponSprite(pSprite)) {
                if (pXSprite.respawn == 3 || Globals.pGameInfo.nWeaponSettings == 1) {
                    return 0;
                }
                if (pXSprite.respawn != 1 && Globals.pGameInfo.nWeaponSettings != 0) {
                    return Globals.pGameInfo.nWeaponRespawnTime;
                }
            }
            if (Actor.IsAmmoSprite(pSprite) && (pXSprite.respawn == 2 || pXSprite.respawn != 1 && Globals.pGameInfo.nWeaponSettings != 0)) {
                return Globals.pGameInfo.nWeaponRespawnTime;
            }
            if (Actor.IsItemSprite(pSprite)) {
                if (pXSprite.respawn == 3 && Globals.pGameInfo.nGameType == 1) {
                    return 0;
                }
                if (pXSprite.respawn == 2 || pXSprite.respawn != 1 && Globals.pGameInfo.nItemSettings != 0) {
                    switch (pSprite.lotag) {
                        case 113: 
                        case 117: 
                        case 124: {
                            return Globals.pGameInfo.nSpecialRespawnTime;
                        }
                        case 114: {
                            return 2 * Globals.pGameInfo.nSpecialRespawnTime;
                        }
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: {
                            return 200;
                        }
                    }
                    return Globals.pGameInfo.nItemRespawnTime;
                }
            }
        }
        return -1;
    }

    public static boolean actCheckRespawn(SPRITE pSprite) {
        short nSprite = pSprite.xvel;
        if (pSprite.extra > 0) {
            XSPRITE pXSprite = DB.xsprite[pSprite.extra];
            int respawnTime = Actor.actGetRespawnTime(pSprite);
            if (respawnTime < 0) {
                return false;
            }
            pXSprite.respawnPending = 1;
            if (pSprite.lotag >= 400 && pSprite.lotag < 436) {
                pXSprite.respawnPending = 3;
                if (pSprite.lotag == 400) {
                    pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                }
            }
            if (respawnTime > 0) {
                if (pXSprite.respawnPending == 1) {
                    respawnTime = Pragmas.mulscale(respawnTime, 40960L, 16);
                }
                pSprite.owner = pSprite.statnum;
                Actor.actPostSprite(nSprite, 8);
                pSprite.hitag = (short)(pSprite.hitag | 0x10);
                if (!Actor.IsDudeSprite(pSprite)) {
                    pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                    pSprite.x = (int)Trigger.ksprite[nSprite].x;
                    pSprite.y = (int)Trigger.ksprite[nSprite].y;
                    pSprite.z = (int)Trigger.ksprite[nSprite].z;
                }
                EVENT.evPostCallback(nSprite, 3, respawnTime, 9);
            }
            return true;
        }
        return false;
    }

    public static void actGibObject(SPRITE pSprite, XSPRITE pXSprite) {
        int gib1 = Gameutils.ClipRange(pXSprite.data1, 0, 31);
        int gib2 = Gameutils.ClipRange(pXSprite.data2, 0, 31);
        int gib3 = Gameutils.ClipRange(pXSprite.data3, 0, 31);
        int sndId = pXSprite.data4;
        short drop = pXSprite.dropMsg;
        if (gib1 > 0) {
            Gib.actGenerateGibs(pSprite, gib1 - 1, null, null);
        }
        if (gib2 > 0) {
            Gib.actGenerateGibs(pSprite, gib2 - 1, null, null);
        }
        if (gib3 > 0 && pXSprite.burnTime != 0) {
            Gib.actGenerateGibs(pSprite, gib3 - 1, null, null);
        }
        if (sndId > 0) {
            SOUND.sfxCreate3DSound(pSprite.x, pSprite.y, pSprite.z, sndId, pSprite.sectnum);
        }
        if (drop > 0) {
            Actor.DropPickupObject(pSprite, drop);
        }
        if ((pSprite.cstat & 0x8000) == 0 && (pSprite.hitag & 0x10) == 0) {
            Actor.actPostSprite(pSprite.xvel, 1024);
        }
    }

    public static SPRITE actCloneSprite(SPRITE pSourceSprite, int nStatus) {
        short nSprite = DB.insertsprite(pSourceSprite.sectnum, (short)nStatus);
        if (nSprite < 0) {
            nSprite = Engine.headspritestat[9];
            if (nSprite < 0) {
                Main.game.dassert("nSprite >= 0");
            }
            DB.changespritesect(nSprite, pSourceSprite.sectnum);
            Actor.actPostSprite(nSprite, nStatus);
        }
        SPRITE pSprite = Engine.sprite[nSprite];
        pSprite.x = pSourceSprite.x;
        pSprite.y = pSourceSprite.y;
        pSprite.z = pSourceSprite.z;
        Actor.sprXVel[nSprite] = sprXVel[pSourceSprite.xvel];
        Actor.sprYVel[nSprite] = sprYVel[pSourceSprite.xvel];
        Actor.sprZVel[nSprite] = sprZVel[pSourceSprite.xvel];
        pSprite.hitag = 0;
        int nXSprite = DB.dbInsertXSprite(nSprite);
        if (nXSprite <= 0) {
            return null;
        }
        Actor.gSpriteHit[nXSprite].floorHit = 0;
        Actor.gSpriteHit[nXSprite].ceilHit = 0;
        return pSprite;
    }

    public static SPRITE actSpawnDude(SPRITE pSprite, int nType, int nDist) {
        int y;
        int x;
        SPRITE pSource = pSprite;
        XSPRITE pXSource = DB.xsprite[pSource.extra];
        SPRITE pDude = Actor.actCloneSprite(pSprite, 6);
        XSPRITE pXDude = DB.xsprite[pDude.extra];
        int z = pSprite.z;
        short nAngle = pSprite.ang;
        if (nDist > 0) {
            x = pSprite.x + Pragmas.mulscaler(nDist, Trig.Cos(nAngle), 30);
            y = pSprite.y + Pragmas.mulscaler(nDist, Trig.Sin(nAngle), 30);
        } else {
            x = pSprite.x;
            y = pSprite.y;
        }
        pDude.lotag = (short)nType;
        pDude.ang = nAngle;
        DB.setSprite(pDude.xvel, x, y, z);
        pDude.cstat = (short)(pDude.cstat | 0x1101);
        pDude.clipdist = DudeInfo.dudeInfo[nType - 200].clipdist;
        pXDude.health = DudeInfo.dudeInfo[nType - 200].startHealth << 4;
        pXDude.respawn = 1;
        if (BuildGdx.cache.contains(DudeInfo.dudeInfo[nType - 200].seqStartID + 0, "SEQ")) {
            SeqHandling.seqSpawn(DudeInfo.dudeInfo[nType - 200].seqStartID + 0, 3, pDude.extra, null);
        }
        if ((pSource.hitag & 1) != 0 && pSource.lotag == 18) {
            if (pDude.pal <= 0) {
                pDude.pal = pSource.pal;
            }
            pXDude.txID = pXSource.txID;
            pXDude.command = pXSource.command;
            pXDude.triggerOn = pXSource.triggerOn;
            pXDude.triggerOff = pXSource.triggerOff;
            pXDude.dropMsg = pXSource.dropMsg;
            pXDude.dudeDeaf = pXSource.dudeDeaf;
            pXDude.dudeGuard = pXSource.dudeGuard;
            pXDude.dudeAmbush = pXSource.dudeAmbush;
            pXDude.dudeFlag4 = pXSource.dudeFlag4;
        }
        Ai.aiInit(pDude, DEMO.IsOriginalDemo());
        return pDude;
    }

    public static SPRITE actSpawnCustomDude(SPRITE pSprite, int nDist) {
        long hp;
        int y;
        int x;
        SPRITE pSource = pSprite;
        XSPRITE pXSource = DB.xsprite[pSource.extra];
        SPRITE pDude = Actor.actCloneSprite(pSprite, 6);
        XSPRITE pXDude = DB.xsprite[pDude.extra];
        int z = pSprite.z;
        short nAngle = pSprite.ang;
        int nType = 254;
        if (nDist > 0) {
            x = pSprite.x + Pragmas.mulscaler(nDist, Trig.Cos(nAngle), 30);
            y = pSprite.y + Pragmas.mulscaler(nDist, Trig.Sin(nAngle), 30);
        } else {
            x = pSprite.x;
            y = pSprite.y;
        }
        pDude.lotag = (short)nType;
        pDude.ang = nAngle;
        DB.setSprite(pDude.xvel, x, y, z);
        pDude.cstat = (short)(pDude.cstat | 0x1101);
        pDude.clipdist = DudeInfo.dudeInfo[nType - 200].clipdist;
        pXDude.data1 = pXSource.data1;
        pXDude.data2 = pXSource.data2;
        pXDude.data3 = pXSource.data3;
        SeqHandling.seqSpawn(AIUNICULT.getSeqStartId(pXDude), 3, pDude.extra, null);
        pXDude.health = pXSource.data4 <= 0 ? DudeInfo.dudeInfo[nType - 200].startHealth << 4 & 0xFFF : (int)((hp = (long)(pXSource.data4 << 4 & 0xFFF)) > 0L ? (hp <= 65535L ? hp : 65535L) : 1L);
        pXDude.busyTime = pXSource.busyTime;
        if ((pSource.hitag & 1) != 0) {
            if (pDude.pal <= 0) {
                pDude.pal = pSource.pal;
            }
            if (pSource.clipdist > 0) {
                pDude.clipdist = pSource.clipdist;
            }
            pXDude.txID = pXSource.txID;
            pXDude.command = pXSource.command;
            pXDude.triggerOn = pXSource.triggerOn;
            pXDude.triggerOff = pXSource.triggerOff;
            pXDude.dropMsg = pXSource.dropMsg;
            pXDude.key = pXSource.key;
            pXDude.dudeDeaf = pXSource.dudeDeaf;
            pXDude.dudeGuard = pXSource.dudeGuard;
            pXDude.dudeAmbush = pXSource.dudeAmbush;
            pXDude.dudeFlag4 = pXSource.dudeFlag4;
        }
        Ai.aiInit(pDude, false);
        return pDude;
    }

    public static SPRITE actSpawnThing(int nSector, int x, int y, int z, int nThingType) {
        if (nThingType < 400 || nThingType >= 436) {
            Main.game.dassert("nThingType >= kThingBase && nThingType < kThingMax");
        }
        int nThing = Actor.actSpawnSprite((short)nSector, x, y, z, 4, true);
        SPRITE pThing = Engine.sprite[nThing];
        pThing.lotag = (short)nThingType;
        short nXThing = pThing.extra;
        if (nXThing <= 0 || nXThing >= 2048) {
            Main.game.dassert("nXThing > 0 && nXThing < kMaxXSprites");
        }
        XSPRITE pXThing = DB.xsprite[nXThing];
        THINGINFO pThinkInfo = thingInfo[nThingType - 400];
        pXThing.health = pThinkInfo.startHealth << 4;
        pThing.cstat = (short)(pThing.cstat | pThinkInfo.cstat);
        pThing.clipdist = pThinkInfo.clipdist;
        pThing.hitag = (short)pThinkInfo.flags;
        if ((pThing.hitag & 2) != 0) {
            pThing.hitag = (short)(pThing.hitag | 4);
        }
        pThing.picnum = (short)pThinkInfo.picnum;
        pThing.shade = (byte)pThinkInfo.shade;
        pThing.pal = (byte)pThinkInfo.pal;
        if (pThinkInfo.xrepeat != 0) {
            pThing.xrepeat = (short)pThinkInfo.xrepeat;
        }
        if (pThinkInfo.yrepeat != 0) {
            pThing.yrepeat = (short)pThinkInfo.yrepeat;
        }
        int n = pThing.xvel >> 3;
        Engine.show2dsprite[n] = (byte)(Engine.show2dsprite[n] | 1 << (pThing.xvel & 7));
        switch (nThingType) {
            case 432: {
                pXThing.data1 = 0;
                pXThing.data3 = 0;
                pXThing.data4 = 0;
                pXThing.state = 1;
                pXThing.isTriggered = false;
                pXThing.triggerOnce = true;
                break;
            }
            case 431: 
            case 435: {
                pXThing.data1 = 0;
                pXThing.data3 = 0;
                pXThing.data4 = 0;
                pXThing.state = 1;
                pXThing.isTriggered = false;
                pXThing.triggerOnce = false;
                break;
            }
            case 427: {
                pXThing.data1 = (short)8;
                pXThing.data4 = 318;
                pXThing.targetX |= Globals.gFrameClock + 180;
                pXThing.state = 1;
                pXThing.Locked = 1;
                pXThing.isTriggered = false;
                pXThing.triggerOnce = false;
                break;
            }
            case 425: 
            case 426: {
                if (nThingType == 425) {
                    pXThing.data1 = (short)19;
                } else if (nThingType == 426) {
                    pXThing.data1 = (short)8;
                }
                pXThing.data2 = 0;
                pXThing.data3 = 0;
                pXThing.data4 = 319;
                pXThing.targetX |= Globals.gFrameClock + 180;
                pXThing.state = 1;
                pXThing.Locked = 1;
                pXThing.isTriggered = false;
                pXThing.triggerOnce = false;
                break;
            }
            case 418: 
            case 419: {
                EVENT.evPostCallback(pThing.xvel, 3, 0L, 8);
                SOUND.sfxStart3DSound(pThing, 450, 0, 0);
                break;
            }
            case 420: {
                EVENT.evPostCallback(pThing.xvel, 3, 0L, 8);
            }
        }
        return pThing;
    }

    public static int actSpawnSprite(short nSector, long x, long y, long z, int nStatus, boolean bAddXSprite) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(nSector)) {
            return -1;
        }
        short nSprite = DB.insertsprite(nSector, (short)nStatus);
        if (nSprite >= 0) {
            Engine.sprite[nSprite].extra = (short)-1;
        } else {
            nSprite = Engine.headspritestat[9];
            if (nSprite < 0) {
                Main.game.dassert("nSprite >= 0");
            }
            if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
            }
            DB.changespritesect(nSprite, nSector);
            Actor.actPostSprite(nSprite, nStatus);
        }
        DB.setSprite(nSprite, x, y, z);
        SPRITE pSprite = Engine.sprite[nSprite];
        pSprite.lotag = 0;
        if (bAddXSprite && pSprite.extra == -1) {
            int nXSprite = DB.dbInsertXSprite(nSprite);
            if (nXSprite == -1) {
                return -1;
            }
            Actor.gSpriteHit[nXSprite].floorHit = 0;
            Actor.gSpriteHit[nXSprite].ceilHit = 0;
        }
        return nSprite;
    }

    public static SPRITE DropPickupObject(SPRITE pActor, int nObject) {
        int floorz;
        int nSprite;
        if (pActor.statnum >= 1024) {
            return null;
        }
        if (!(nObject >= 100 && nObject < 149 || nObject >= 60 && nObject < 81 || nObject >= 40 && nObject < 51)) {
            return null;
        }
        short nSector = Main.engine.updatesector(pActor.x, pActor.y, pActor.sectnum);
        if (!DEMO.IsOriginalDemo() && !ru.m210projects.Build.Gameutils.isValidSector(nSector)) {
            if (ru.m210projects.Build.Gameutils.isValidSector(pActor.sectnum)) {
                nSector = pActor.sectnum;
            } else {
                return null;
            }
        }
        if ((nSprite = Actor.actSpawnSprite(nSector, pActor.x, pActor.y, floorz = Main.engine.getflorzofslope(nSector, pActor.x, pActor.y), 3, false)) != -1) {
            SPRITE pSprite = Engine.sprite[nSprite];
            pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
            if (nObject >= 100 && nObject < 149) {
                int nItemIndex = nObject - 100;
                pSprite.lotag = (short)nObject;
                pSprite.picnum = (short)Actor.gItemInfo[nItemIndex].picnum;
                pSprite.shade = (byte)Actor.gItemInfo[nItemIndex].shade;
                pSprite.xrepeat = (short)Actor.gItemInfo[nItemIndex].xrepeat;
                pSprite.yrepeat = (short)Actor.gItemInfo[nItemIndex].yrepeat;
                if (nObject >= 100 && nObject <= 106 && Globals.pGameInfo.nGameType == 1) {
                    if (pSprite.extra == -1) {
                        DB.dbInsertXSprite(nSprite);
                    }
                    if (pSprite.extra != -1) {
                        XSPRITE pXSprite = DB.xsprite[pSprite.extra];
                        pXSprite.respawn = 3;
                        Actor.gSpriteHit[pSprite.extra].floorHit = 0;
                        Actor.gSpriteHit[pSprite.extra].ceilHit = 0;
                    }
                }
                if ((nObject == 147 || nObject == 148) && Globals.pGameInfo.nGameType == 3) {
                    EVENT.evPostCallback(pSprite.xvel, 3, 1800L, 17);
                }
            } else if (nObject >= 60 && nObject < 81) {
                int nAmmoIndex = nObject - 60;
                pSprite.lotag = (short)nObject;
                pSprite.picnum = (short)Actor.gAmmoItemData[nAmmoIndex].picnum;
                pSprite.shade = (byte)Actor.gAmmoItemData[nAmmoIndex].shade;
                pSprite.xrepeat = (short)Actor.gAmmoItemData[nAmmoIndex].xrepeat;
                pSprite.yrepeat = (short)Actor.gAmmoItemData[nAmmoIndex].yrepeat;
            } else if (nObject >= 40 && nObject < 51) {
                int nWeaponIndex = nObject - 40;
                pSprite.lotag = (short)nObject;
                pSprite.picnum = (short)Actor.gWeaponItemData[nWeaponIndex].picnum;
                pSprite.shade = (byte)Actor.gWeaponItemData[nWeaponIndex].shade;
                pSprite.xrepeat = (short)Actor.gWeaponItemData[nWeaponIndex].xrepeat;
                pSprite.yrepeat = (short)Actor.gWeaponItemData[nWeaponIndex].yrepeat;
            }
            Gameutils.GetSpriteExtents(pSprite);
            if (Gameutils.extents_zBot >= floorz) {
                pSprite.z -= Gameutils.extents_zBot - floorz;
            }
            return pSprite;
        }
        return null;
    }

    public static boolean actHealDude(XSPRITE pXDude, int healValue, int maxHealthClip) {
        if (pXDude == null) {
            Main.game.dassert("pXDude != null");
        }
        healValue <<= 4;
        if (pXDude.health < (maxHealthClip <<= 4)) {
            SPRITE pSprite = Engine.sprite[pXDude.reference];
            if (Gameutils.IsPlayerSprite(pSprite)) {
                SOUND.sfxCreate3DSound(pSprite.x, pSprite.y, pSprite.z, 780, pSprite.sectnum);
            }
            pXDude.health = Gameutils.ClipHigh(pXDude.health + healValue, maxHealthClip);
            return true;
        }
        return false;
    }

    public static void actExplodeSprite(int nSprite) {
        int nType;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nXSprite = pSprite.extra;
        if (nXSprite <= 0 || nXSprite >= 2048) {
            Main.game.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
        }
        if (pSprite.statnum == 2) {
            return;
        }
        SOUND.sfxKill3DSound(pSprite, -1, -1);
        EVENT.checkEventList(nSprite, 3);
        switch (pSprite.lotag) {
            case 312: {
                nType = 7;
                SeqHandling.seqSpawn(4, 3, nXSprite, null);
                if (Gameutils.Chance(16384)) {
                    pSprite.cstat = (short)(pSprite.cstat | 4);
                }
                SOUND.sfxStart3DSound(pSprite, 303, -1, 0);
                Gib.actGenerateGibs(pSprite, 5, null, null);
                break;
            }
            case 303: {
                nType = 3;
                SeqHandling.seqSpawn(9, 3, nXSprite, null);
                if (Gameutils.Chance(16384)) {
                    pSprite.cstat = (short)(pSprite.cstat | 4);
                }
                SOUND.sfxStart3DSound(pSprite, 306, (pSprite.xvel & 3) + 24, 0);
                Gib.actGenerateGibs(pSprite, 5, null, null);
                break;
            }
            case 313: 
            case 314: {
                SeqHandling.seqSpawn(5, 3, nXSprite, null);
                SOUND.sfxStart3DSound(pSprite, 304, -1, 0);
                nType = 3;
                Gib.actGenerateGibs(pSprite, 5, null, null);
                break;
            }
            case 400: {
                int nEffect = Actor.actSpawnSprite(pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0, true);
                Engine.sprite[nEffect].owner = pSprite.owner;
                if (Actor.actCheckRespawn(pSprite)) {
                    XSPRITE pXSprite = DB.xsprite[nXSprite];
                    pXSprite.state = 0;
                    pXSprite.health = Actor.thingInfo[0].startHealth << 4;
                } else {
                    Actor.actPostSprite(nSprite, 1024);
                }
                nType = 2;
                nSprite = nEffect;
                pSprite = Engine.sprite[nEffect];
                nXSprite = pSprite.extra;
                SeqHandling.seqSpawn(4, 3, nXSprite, null);
                SOUND.sfxStart3DSound(pSprite, 305, -1, 0);
                Gib.actGenerateGibs(pSprite, 14, null, null);
                break;
            }
            case 429: {
                nType = 3;
                SeqHandling.seqSpawn(9, 3, nXSprite, null);
                SOUND.sfxStart3DSound(pSprite, 307, -1, 0);
                Gib.actGenerateGibs(pSprite, 5, null, null);
                Actor.actSpawnTentacleBlood(pSprite);
                break;
            }
            case 418: {
                nType = 0;
                if (Actor.gSpriteHit[nXSprite].floorHit != 0) {
                    SeqHandling.seqSpawn(3, 3, nXSprite, null);
                } else {
                    SeqHandling.seqSpawn(4, 3, nXSprite, null);
                }
                SOUND.sfxStart3DSound(pSprite, 303, -1, 0);
                Gib.actGenerateGibs(pSprite, 5, null, null);
                break;
            }
            case 401: 
            case 402: 
            case 419: 
            case 433: {
                nType = 1;
                if (Actor.gSpriteHit[nXSprite].floorHit != 0) {
                    SeqHandling.seqSpawn(3, 3, nXSprite, null);
                } else {
                    SeqHandling.seqSpawn(4, 3, nXSprite, null);
                }
                SOUND.sfxStart3DSound(pSprite, 304, -1, 0);
                Gib.actGenerateGibs(pSprite, 5, null, null);
                break;
            }
            case 420: {
                nType = 4;
                SeqHandling.seqSpawn(5, 3, nXSprite, null);
                SOUND.sfxStart3DSound(pSprite, 307, -1, 0);
                Gib.actGenerateGibs(pSprite, 5, null, null);
                break;
            }
            case 459: {
                nType = 1;
                int nSnd = 304;
                int nSeq = 4;
                short tSnd = 0;
                short tSeq = 0;
                XSPRITE pXSPrite = DB.xsprite[nXSprite];
                nType = pXSPrite.data1;
                tSeq = pXSPrite.data2;
                tSnd = pXSPrite.data3;
                if (nType <= 1 || nType > 9) {
                    nType = 1;
                } else if (nType == 2) {
                    nSnd = 305;
                } else if (nType == 3) {
                    nSeq = 9;
                    nSnd = 307;
                } else if (nType == 4) {
                    nSeq = 5;
                    nSnd = 307;
                } else if (nType <= 6) {
                    nSnd = 303;
                } else if (nType == 7) {
                    nSnd = 303;
                } else if (nType == 8) {
                    nType = 0;
                    nSeq = 3;
                    nSnd = 303;
                }
                if (tSeq > 0) {
                    nSeq = tSeq;
                }
                if (tSnd > 0) {
                    nSnd = tSnd;
                }
                if (BuildGdx.cache.contains(pXSPrite.data2, "SEQ")) {
                    SeqHandling.seqSpawn(nSeq, 3, nXSprite, null);
                }
                SOUND.sfxStart3DSound(pSprite, nSnd, -1, 0);
                break;
            }
            default: {
                nType = 1;
                SeqHandling.seqSpawn(4, 3, nXSprite, null);
                if (Gameutils.Chance(16384)) {
                    pSprite.cstat = (short)(pSprite.cstat | 4);
                }
                SOUND.sfxStart3DSound(pSprite, 303, -1, 0);
                Gib.actGenerateGibs(pSprite, 5, null, null);
            }
        }
        Actor.sprZVel[nSprite] = 0L;
        Actor.sprYVel[nSprite] = 0L;
        Actor.sprXVel[nSprite] = 0L;
        Actor.actPostSprite(nSprite, 2);
        pSprite.hitag = (short)(pSprite.hitag & 0xFFFFFFFC);
        EXPLODE pExpl = gExplodeData[nType];
        pSprite.yrepeat = pExpl.size;
        pSprite.xrepeat = pExpl.size;
        pSprite.lotag = (short)nType;
        DB.xsprite[nXSprite].target = 0;
        DB.xsprite[nXSprite].data1 = (short)pExpl.liveCount;
        DB.xsprite[nXSprite].data2 = (short)pExpl.quake;
        DB.xsprite[nXSprite].data3 = (short)pExpl.used3;
    }

    public static boolean IsItemSprite(SPRITE pSprite) {
        return pSprite.lotag >= 100 && pSprite.lotag < 149;
    }

    public static boolean IsDudeSprite(SPRITE pSprite) {
        return pSprite.lotag >= 200 && pSprite.lotag < 256;
    }

    public static boolean IsBurningDude(SPRITE pSprite) {
        if (pSprite == null) {
            return false;
        }
        switch (pSprite.lotag) {
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 252: 
            case 253: 
            case 255: {
                return true;
            }
        }
        return false;
    }

    public static boolean IsKillableDude(SPRITE pSprite) {
        switch (pSprite.lotag) {
            case 208: 
            case 209: {
                return false;
            }
        }
        return Actor.IsDudeSprite(pSprite) && DB.xsprite[pSprite.extra].Locked != 1;
    }

    public static boolean IsAmmoSprite(SPRITE pSprite) {
        return pSprite.lotag >= 60 && pSprite.lotag < 81;
    }

    public static boolean IsWeaponSprite(SPRITE pSprite) {
        return pSprite.lotag >= 40 && pSprite.lotag < 51;
    }

    public static boolean IsUnderwaterSector(int sectnum) {
        short nXSector = Engine.sector[sectnum].extra;
        return nXSector > 0 && DB.xsector[nXSector].Underwater;
    }

    public static int actGetBurnTime(XSPRITE pXActor) {
        return pXActor.burnTime;
    }

    public static int actGetBurnSource(int nSource) {
        if (nSource != -1) {
            nSource = (nSource & 0x1000) != 0 ? (int)Globals.gPlayer[nSource & 0xFFF].pSprite.xvel : (nSource &= 0xFFF);
        }
        return nSource;
    }

    public static int actSetBurnSource(int nSource) {
        if (nSource != -1) {
            SPRITE pSprite;
            if (nSource < 0 || nSource >= Globals.kMaxSprites) {
                Main.game.dassert("nSprite >= 0 && nSprite < kMaxSprites");
            }
            if (Gameutils.IsPlayerSprite(pSprite = Engine.sprite[nSource])) {
                nSource = pSprite.lotag - 231;
                nSource |= 0x1000;
            }
        }
        return nSource;
    }

    public static void TchernobogCallback1(int nXIndex) {
        int nSprite = DB.xsprite[nXIndex].reference;
        SPRITE pSpawn = Actor.actSpawnEffect(32, Engine.sprite[nSprite].sectnum, Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z, 0);
        if (pSpawn != null) {
            Actor.sprXVel[pSpawn.xvel] = sprXVel[nSprite];
            Actor.sprYVel[pSpawn.xvel] = sprYVel[nSprite];
            Actor.sprZVel[pSpawn.xvel] = sprZVel[nSprite];
        }
    }

    public static void TchernobogCallback2(int nXIndex) {
        int nSprite = DB.xsprite[nXIndex].reference;
        SPRITE pSpawn = Actor.actSpawnEffect(33, Engine.sprite[nSprite].sectnum, Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z, 0);
        if (pSpawn != null) {
            Actor.sprXVel[pSpawn.xvel] = sprXVel[nSprite];
            Actor.sprYVel[pSpawn.xvel] = sprYVel[nSprite];
            Actor.sprZVel[pSpawn.xvel] = sprZVel[nSprite];
        }
    }

    public static void FireballCallback(int nXIndex) {
        int nSprite = DB.xsprite[nXIndex].reference;
        SPRITE pSpawn = Actor.actSpawnEffect(11, Engine.sprite[nSprite].sectnum, Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z, 0);
        if (pSpawn != null) {
            Actor.sprXVel[pSpawn.xvel] = sprXVel[nSprite];
            Actor.sprYVel[pSpawn.xvel] = sprYVel[nSprite];
            Actor.sprZVel[pSpawn.xvel] = sprZVel[nSprite];
        }
    }

    public static void SmokeCallback(int nXIndex) {
        int nSprite = DB.xsprite[nXIndex].reference;
        SPRITE pSpawn = Actor.actSpawnEffect(12, Engine.sprite[nSprite].sectnum, Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z, 0);
        if (pSpawn != null) {
            Actor.sprXVel[pSpawn.xvel] = sprXVel[nSprite];
            Actor.sprYVel[pSpawn.xvel] = sprYVel[nSprite];
            Actor.sprZVel[pSpawn.xvel] = sprZVel[nSprite];
        }
    }

    public static void DamageTreeCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        SPRITE pSprite = Engine.sprite[pXSprite.reference];
        pSprite.lotag = (short)417;
        pXSprite.state = 1;
        pXSprite.data1 = (short)15;
        pXSprite.data3 = 0;
        pXSprite.data4 = 312;
        pXSprite.health = Actor.thingInfo[17].startHealth;
        pSprite.cstat = (short)(pSprite.cstat | 0x101);
    }

    public static void actNapalm2Explode(SPRITE pSprite, XSPRITE pXSprite) {
        Actor.actPostSprite(pSprite.xvel, 0);
        SeqHandling.seqSpawn(9, 3, pSprite.extra, null);
        if (Gameutils.Chance(16384)) {
            pSprite.cstat = (short)(pSprite.cstat | 4);
        }
        SOUND.sfxStart3DSound(pSprite, 303, (pSprite.xvel & 3) + 24, 0);
        Actor.actDistanceDamage(Actor.actGetBurnSource(pSprite.owner), pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, 128, 0, 3, 60, 15, 120);
        if (pXSprite.data4 > 4) {
            Gib.actGenerateGibs(pSprite, 5, null, null);
            short nAngle = pSprite.ang;
            Actor.sprXVel[pSprite.xvel] = 0L;
            Actor.sprYVel[pSprite.xvel] = 0L;
            Actor.sprZVel[pSprite.xvel] = 0L;
            Actor.NapalmAmmo[0] = pXSprite.data4 >> 3;
            Actor.NapalmAmmo[1] = (pXSprite.data4 >> 2) - NapalmAmmo[0];
            for (int i = 0; i < 2; ++i) {
                int velocity = 209715 + Gameutils.Random(209715);
                pSprite.ang = (short)(nAngle + Gameutils.BiRandom(113) & 0x7FF);
                SPRITE pThing = Actor.actFireThing(pSprite.xvel, 0, 0, -37840, 428, velocity);
                XSPRITE pXThing = DB.xsprite[pThing.extra];
                pThing.owner = pSprite.owner;
                SeqHandling.seqSpawn(VERSION.getSeq(6), 3, pThing.extra, SeqHandling.callbacks[6]);
                pXThing.data4 = 4 * (NapalmAmmo[i] & 0xFFFF);
            }
        }
    }

    public static void DamageDude(int nXIndex, int count) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        SPRITE pSprite = Engine.sprite[pXSprite.reference];
        pSprite.lotag = (short)426;
        pXSprite.state = 1;
        pXSprite.data1 = (short)count;
        pXSprite.data2 = 0;
        pXSprite.data3 = 0;
        pXSprite.data4 = 319;
        pXSprite.targetX = Globals.gFrameClock;
        pXSprite.isTriggered = false;
        pXSprite.triggerOnce = false;
        pXSprite.Locked = 0;
        pXSprite.health = Actor.thingInfo[26].startHealth;
    }

    public static int getDudeMassBySpriteSize(SPRITE pSprite) {
        int mass = 0;
        int minMass = 5;
        if (!Actor.IsDudeSprite(pSprite)) {
            return minMass;
        }
        int seqStartId = DudeInfo.dudeInfo[pSprite.lotag - 200].seqStartID;
        switch (pSprite.lotag) {
            case 254: 
            case 255: {
                seqStartId = DB.xsprite[pSprite.extra].data2;
            }
        }
        if (gSpriteMass[pSprite.xvel] == null) {
            Actor.gSpriteMass[pSprite.xvel] = new SPRITEMASS();
        }
        SPRITEMASS cachedMass = gSpriteMass[pSprite.xvel];
        if (seqStartId == cachedMass.seqId && pSprite.xrepeat == cachedMass.xrepeat && pSprite.yrepeat == cachedMass.yrepeat && pSprite.clipdist == cachedMass.clipdist) {
            return cachedMass.mass;
        }
        SeqType pSeq = SeqType.getInstance(seqStartId);
        int picnum = pSeq != null ? pSeq.getFrame((int)0).nTile : pSprite.picnum;
        int clipDist = pSprite.clipdist <= 0 ? DudeInfo.dudeInfo[pSprite.lotag - 200].clipdist : pSprite.clipdist;
        BloodTile pic = Main.engine.getTile(picnum);
        short xrepeat = pSprite.xrepeat;
        int x = pic.getWidth();
        if (xrepeat > 64) {
            x += (xrepeat - 64) * 2;
        } else if (xrepeat < 64) {
            x -= (64 - xrepeat) * 2;
        }
        short yrepeat = pSprite.yrepeat;
        int y = pic.getHeight();
        if (yrepeat > 64) {
            y += (yrepeat - 64) * 2;
        } else if (yrepeat < 64) {
            y -= (64 - yrepeat) * 2;
        }
        mass = (x + y) * clipDist / 25;
        cachedMass.seqId = seqStartId;
        cachedMass.xrepeat = xrepeat;
        cachedMass.yrepeat = yrepeat;
        cachedMass.mass = Gameutils.ClipRange(mass, minMass, 65535);
        cachedMass.clipdist = clipDist;
        return cachedMass.mass;
    }

    static {
        gNoEnemies = 0;
        gSpriteHit = new SPRITEHIT[2048];
        gWallExp = new int[Globals.kMaxWalls];
        gSectorExp = new int[Globals.kMaxSectors];
        gSpriteExp = new byte[Globals.kMaxSectors + 7 >> 3];
        sprXVel = new long[Globals.kMaxSprites];
        sprYVel = new long[Globals.kMaxSprites];
        sprZVel = new long[Globals.kMaxSprites];
        floorVel = new long[Globals.kMaxSectors];
        ceilingVel = new long[Globals.kMaxSectors];
        pSkillShift = new int[]{512, 384, 256, 208, 160};
        pPlayerShift = new int[]{144, 208, 256, 304, 368};
        gPostCount = 0;
        gPost = new POSTPONE[Globals.kMaxSprites];
        gSpriteMass = new SPRITEMASS[Globals.kMaxSprites];
        gVectorData = new VECTORDATA[]{new VECTORDATA(2, 17, 174762, 1152, 10240, 0, 1, 20480, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(43, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(43, 6, -1, 502), new SURFACE(43, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, 7, 502), new SURFACE(43, 6, 7, 502), new SURFACE(-1, -1, -1, 503), new SURFACE(43, -1, -1, -1), new SURFACE(-1, 6, -1, 503), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1)}, new int[]{1207, 1207}), new VECTORDATA(2, 4, 65536, 0, 8192, 0, 1, 12288, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(43, 5, -1, -1), new SURFACE(-1, 5, -1, 501), new SURFACE(43, 6, -1, -1), new SURFACE(43, 0, -1, -1), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(43, 6, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(43, -1, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1)}, new int[]{1001, 1001}), new VECTORDATA(2, 7, 21845, 0, 32768, 0, 1, 12288, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(43, 5, 7, 510), new SURFACE(-1, 5, 7, 511), new SURFACE(43, 6, -1, 512), new SURFACE(43, 0, -1, 513), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, 7, 512), new SURFACE(43, 6, 7, 512), new SURFACE(-1, -1, -1, 513), new SURFACE(43, -1, -1, 513), new SURFACE(-1, 6, -1, 513), new SURFACE(-1, 6, -1, 513), new SURFACE(-1, 6, -1, 513), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1)}, new int[]{4001, 4002}), new VECTORDATA(2, 20, 65536, 0, 16384, 0, 1, 20480, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(43, 5, 7, 510), new SURFACE(-1, 5, 7, 511), new SURFACE(43, 6, -1, 512), new SURFACE(43, 0, -1, 513), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, 7, 512), new SURFACE(43, 6, 7, 512), new SURFACE(-1, -1, -1, 513), new SURFACE(43, -1, -1, 513), new SURFACE(-1, 6, -1, 513), new SURFACE(-1, 6, -1, 513), new SURFACE(-1, 6, -1, 513), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1)}, new int[]{431, 431}), new VECTORDATA(2, 6, 87381, 0, 12288, 0, 1, 6144, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(43, 5, -1, -1), new SURFACE(-1, 5, -1, 501), new SURFACE(43, 6, -1, -1), new SURFACE(43, 0, -1, -1), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(43, 6, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(43, -1, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1)}, new int[]{1002, 1002}), new VECTORDATA(2, 12, 65536, 0, 16384, 0, 1, 12288, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(43, 5, 7, 510), new SURFACE(-1, 5, 7, 511), new SURFACE(43, 6, -1, 512), new SURFACE(43, 0, -1, 513), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, 7, 512), new SURFACE(43, 6, 7, 512), new SURFACE(-1, -1, -1, 513), new SURFACE(43, -1, -1, 513), new SURFACE(-1, 6, -1, 513), new SURFACE(-1, 6, -1, 513), new SURFACE(-1, 6, -1, 513), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1)}, new int[]{359, 359}), new VECTORDATA(2, 4, 0, 921, 0, 0, 1, 4096, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1), new SURFACE(-1, 5, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{521, 521}), new VECTORDATA(2, 12, 0, 1177, 0, 0, 0, 0, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{513, 513}), new VECTORDATA(2, 9, 0, 1177, 0, 0, 0, 0, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{499, 499}), new VECTORDATA(3, 50, 43690, 1024, 8192, 0, 4, 32768, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{9012, 9014}), new VECTORDATA(2, 18, 436906, 1024, 16384, 0, 2, 20480, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1)}, new int[]{1101, 1101}), new VECTORDATA(2, 9, 218453, 1024, 0, 0, 1, 24576, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1)}, new int[]{1207, 1207}), new VECTORDATA(2, 20, 436906, 1024, 16384, 0, 3, 24576, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1)}, new int[]{499, 495}), new VECTORDATA(2, 16, 218453, 1024, 8192, 0, 4, 20480, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1)}, new int[]{495, 496}), new VECTORDATA(2, 19, 218453, 614, 8192, 0, 2, 24576, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{9013, 499}), new VECTORDATA(2, 10, 218453, 614, 8192, 0, 2, 24576, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{1307, 1308}), new VECTORDATA(2, 4, 0, 921, 0, 0, 1, 24576, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, -1), new SURFACE(-1, 5, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{499, 499}), new VECTORDATA(2, 8, 0, 614, 0, 0, 1, 24576, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{499, 499}), new VECTORDATA(2, 9, 0, 512, 0, 0, 0, 0, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 5, -1, 500), new SURFACE(-1, 5, -1, 501), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 0, -1, 503), new SURFACE(-1, 4, -1, -1), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, 6, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, 502), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{499, 499}), new VECTORDATA(-1, 0, 0, 2560, 0, 0, 0, 0, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 34, 35, -1), new SURFACE(-1, 34, 35, -1), new SURFACE(-1, 34, 35, -1), new SURFACE(-1, 34, 35, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, 34, 35, -1), new SURFACE(-1, 34, 35, -1), new SURFACE(-1, 34, 35, -1), new SURFACE(-1, 34, 35, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{0, 0}), new VECTORDATA(1, 2, 0, 0, 0, 15, 0, 0, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{351, 351}), new VECTORDATA(5, 25, 0, 0, 0, 0, 0, 0, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, -1)}, new int[]{0, 0}), new VECTORDATA(0, 37, 874762, 620, 0, 0, 0, 0, new SURFACE[]{new SURFACE(-1, -1, -1, -1), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357), new SURFACE(-1, -1, -1, 357)}, new int[]{357, 499})};
        gExplodeData = new EXPLODE[]{new EXPLODE(40, 10, 10, 75, 450, 0, 60, 80, 40), new EXPLODE(80, 20, 10, 150, 900, 0, 60, 160, 60), new EXPLODE(120, 40, 15, 225, 1350, 0, 60, 240, 80), new EXPLODE(80, 5, 10, 120, 20, 10, 60, 0, 40), new EXPLODE(120, 10, 10, 180, 40, 10, 60, 0, 80), new EXPLODE(160, 15, 10, 240, 60, 10, 60, 0, 120), new EXPLODE(40, 20, 10, 120, 0, 10, 30, 60, 40), new EXPLODE(80, 20, 10, 150, 800, 5, 60, 160, 60)};
        gMissileData = new MissileType[]{new MissileType(2138, 978670, 512, 40, 40, 240, 16, new int[]{1207, 1207}), new MissileType(2424, 0x300000, 0, 32, 32, 128, 32, new int[]{420, 420}), new MissileType(3056, 0x2AAAAA, 0, 32, 32, 128, 32, new int[]{471, 471}), new MissileType(2424, 0x255555, 0, 32, 32, 128, 4, new int[]{421, 421}), new MissileType(0, 0x111111, 0, 24, 24, 128, 16, new int[]{1309, 351}), new MissileType(0, 0x111111, 0, 32, 32, 128, 32, new int[]{480, 480}), new MissileType(2130, 0x2AAAAA, 0, 32, 32, 128, 16, new int[]{470, 470}), new MissileType(870, 699050, 0, 32, 32, 232, 32, new int[]{489, 490}), new MissileType(0, 0x111111, 0, 24, 24, 128, 16, new int[]{462, 351}), new MissileType(0, 838860, 0, 16, 16, 240, 16, new int[]{1203, 172}), new MissileType(0, 838860, 0, 8, 8, 0, 16, new int[]{0, 0}), new MissileType(3056, 0x200000, 0, 32, 32, 128, 16, new int[]{1457, 249}), new MissileType(0, 0x255555, 0, 30, 30, 128, 24, new int[]{480, 489}), new MissileType(0, 0x255555, 0, 30, 30, 128, 24, new int[]{489, 480}), new MissileType(0, 0x155555, 0, 24, 24, 128, 16, new int[]{480, 489}), new MissileType(2446, 0x2AAAAA, 0, 32, 32, 128, 16, new int[]{491, 491}), new MissileType(3056, 0x255555, 0, 16, 16, 128, 16, new int[]{520, 520}), new MissileType(3056, 0x1AAAAA, 0, 32, 32, 128, 16, new int[]{520, 250})};
        gEffectInfo = new EFFECT[]{new EFFECT(-1, 0, 4107, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 0, 4108, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 0, 4109, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 0, 4110, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 0, 7, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 0, 4102, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 0, 4103, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 0, 4104, 1, -128, 8192, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 2, 6, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 2, 4099, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 2, 4100, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 1, 4106, 3, -256, 8192, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 1, 4118, 3, -256, 8192, 0, 0, 0, 0, 0, 0, 0), new EFFECT(14, 2, 0, 1, 46603, 2048, 480, 2154, 40, 40, 0, 244, 0), new EFFECT(-1, 2, 0, 3, 46603, 5120, 480, 2269, 24, 24, 0, 128, 0), new EFFECT(-1, 2, 0, 3, 46603, 5120, 480, 1720, 24, 24, 0, 128, 0), new EFFECT(-1, 1, 0, 1, 58254, 3072, 480, 2280, 48, 48, 0, 128, 0), new EFFECT(-1, 1, 0, 1, 58254, 3072, 480, 3135, 48, 48, 0, 128, 0), new EFFECT(-1, 0, 0, 3, 58254, 1024, 480, 3261, 32, 32, 0, 0, 0), new EFFECT(-1, 1, 0, 3, 58254, 1024, 480, 3265, 32, 32, 0, 0, 0), new EFFECT(-1, 1, 0, 3, 58254, 1024, 480, 3269, 32, 32, 0, 0, 0), new EFFECT(-1, 1, 0, 3, 58254, 1024, 480, 3273, 32, 32, 0, 0, 0), new EFFECT(-1, 1, 0, 3, 58254, 1024, 480, 3277, 32, 32, 0, 0, 0), new EFFECT(-1, 2, 0, 1, -27962, 8192, 600, 1128, 16, 16, 514, 240, 0), new EFFECT(-1, 2, 0, 1, -18641, 8192, 600, 1128, 12, 12, 514, 240, 0), new EFFECT(-1, 2, 0, 1, -9320, 8192, 600, 1128, 8, 8, 514, 240, 0), new EFFECT(-1, 2, 0, 1, -18641, 8192, 600, 1131, 32, 32, 514, 240, 0), new EFFECT(14, 2, 0, 3, 27962, 4096, 480, 733, 32, 32, 0, 240, 0), new EFFECT(-1, 1, 0, 3, 18641, 4096, 120, 2261, 12, 12, 0, 128, 0), new EFFECT(-1, 0, 4105, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 1, 0, 3, 58254, 3328, 480, 2185, 48, 48, 0, 0, 0), new EFFECT(-1, 0, 0, 3, 58254, 1024, 480, 2620, 48, 48, 0, 0, 0), new EFFECT(-1, 1, 4113, 1, -13981, 5120, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 1, 4114, 1, -13981, 5120, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 1, 4115, 1, 0, 2048, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 1, 4116, 1, 0, 2048, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 2, 0, 0, 0, 0, 960, 956, 32, 32, 610, 0, 0), new EFFECT(16, 2, 4120, 0, 46603, 1024, 0, 0, 0, 0, 0, 0, 0), new EFFECT(16, 2, 4121, 0, 46603, 1024, 0, 0, 0, 0, 0, 0, 0), new EFFECT(16, 2, 4122, 0, 46603, 1024, 0, 0, 0, 0, 0, 0, 0), new EFFECT(16, 2, 4123, 0, 46603, 1024, 0, 0, 0, 0, 0, 0, 0), new EFFECT(16, 2, 4124, 0, 46603, 1024, 0, 0, 0, 0, 0, 0, 0), new EFFECT(16, 2, 4125, 0, 46603, 1024, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 1, 0, 3, 0, 0, 0, 838, 16, 16, 80, 248, 0), new EFFECT(-1, 0, 0, 3, 34952, 8192, 0, 2078, 64, 64, 0, 248, 0), new EFFECT(-1, 0, 0, 3, 34952, 8192, 0, 1106, 64, 64, 0, 248, 0), new EFFECT(-1, 0, 0, 3, 58254, 3328, 480, 2406, 48, 48, 0, 0, 0), new EFFECT(-1, 1, 0, 3, 46603, 4096, 480, 3511, 64, 64, 0, 128, 0), new EFFECT(-1, 0, 8, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 2, 11, 3, -256, 8192, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 2, 11, 3, 0, 8192, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0), new EFFECT(-1, 1, 30, 3, 0, 0, 0, 0, 40, 40, 80, 248, 0), new EFFECT(19, 2, 0, 3, 27962, 4096, 480, 4023, 32, 32, 0, 240, 0), new EFFECT(19, 2, 0, 3, 27962, 4096, 480, 4028, 32, 32, 0, 240, 0), new EFFECT(-1, 2, 0, 0, 0, 0, 480, 926, 32, 32, 610, 244, 0), new EFFECT(-1, 1, 4113, 1, -13981, 5120, 0, 0, 0, 0, 0, 0, 0)};
        thingInfo = new THINGINFO[]{new THINGINFO(25, 250, 32, 11, 4096, 80, 384, 907, 0, 0, 0, 0, new int[]{256, 256, 128, 64, 0, 0, 128}, 1), new THINGINFO(5, 5, 16, 3, 24576, 1600, 256, 3444, 240, 0, 32, 32, new int[]{256, 256, 256, 64, 0, 0, 512}, 1), new THINGINFO(5, 5, 16, 3, 24576, 1600, 256, 3457, 240, 0, 32, 32, new int[]{256, 256, 256, 64, 0, 0, 512}, 1), new THINGINFO(1, 20, 32, 3, 32768, 80, 0, 739, 0, 0, 0, 0, new int[]{256, 0, 256, 128, 0, 0, 0}, 0), new THINGINFO(1, 150, 32, 3, 32768, 80, 0, 642, 0, 0, 0, 0, new int[]{256, 256, 256, 128, 0, 0, 0}, 0), new THINGINFO(10, 0, 0, 0, 0, 0, 0, 462, 0, 0, 0, 0, new int[]{0, 0, 0, 256, 0, 0, 0}, 0), new THINGINFO(1, 0, 0, 0, 0, 0, 0, 266, 0, 0, 0, 0, new int[]{256, 0, 256, 256, 0, 0, 0}, 0), new THINGINFO(1, 0, 0, 0, 0, 0, 0, 796, 0, 0, 0, 0, new int[]{256, 0, 256, 256, 0, 0, 512}, 0), new THINGINFO(50, 0, 0, 0, 0, 0, 0, 1127, 0, 0, 0, 0, new int[]{0, 0, 0, 256, 0, 0, 0}, 0), new THINGINFO(8, 0, 0, 0, 0, 0, 0, 1142, 0, 0, 0, 0, new int[]{256, 0, 256, 128, 0, 0, 0}, 0), new THINGINFO(4, 0, 0, 0, 0, 0, 0, 1069, 0, 0, 0, 0, new int[]{256, 256, 64, 256, 0, 0, 128}, 0), new THINGINFO(40, 0, 0, 0, 0, 0, 0, 483, 0, 0, 0, 0, new int[]{64, 0, 128, 256, 0, 0, 0}, 0), new THINGINFO(1, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, new int[]{0, 256, 0, 256, 0, 0, 128}, 0), new THINGINFO(1000, 0, 0, 8, 0, 0, 0, -1, 0, 0, 0, 0, new int[]{0, 0, 128, 256, 0, 0, 512}, 0), new THINGINFO(0, 15, 8, 3, 32768, 0, 0, -1, 0, 0, 0, 0, new int[]{0, 0, 0, 0, 0, 0, 0}, 0), new THINGINFO(0, 8, 48, 3, 49152, 0, 0, 3540, 0, 0, 0, 0, new int[]{0, 0, 0, 0, 0, 0, 0}, 1), new THINGINFO(10, 2, 0, 0, 32768, 0, 0, -1, 0, 0, 0, 0, new int[]{256, 0, 256, 256, 0, 0, 128}, 0), new THINGINFO(20, 2, 0, 0, 32768, 0, 0, -1, 0, 0, 0, 0, new int[]{0, 0, 0, 256, 0, 0, 128}, 0), new THINGINFO(5, 14, 16, 3, 24576, 1600, 256, 3422, 224, 0, 32, 32, new int[]{64, 256, 128, 64, 0, 0, 256}, 1), new THINGINFO(5, 14, 16, 3, 24576, 1600, 256, 3433, 224, 0, 32, 32, new int[]{64, 256, 128, 64, 0, 0, 256}, 1), new THINGINFO(5, 14, 16, 3, 32768, 1600, 256, 3467, 128, 0, 32, 32, new int[]{64, 256, 128, 64, 0, 0, 256}, 1), new THINGINFO(5, 6, 16, 3, 32768, 1600, 256, 1462, 0, 0, 32, 32, new int[]{0, 0, 0, 0, 0, 0, 0}, 1), new THINGINFO(8, 3, 16, 11, 32768, 1600, 256, -1, 0, 0, 0, 0, new int[]{256, 0, 256, 256, 0, 0, 0}, 0), new THINGINFO(0, 1, 1, 2, 0, 0, 0, 1147, 0, 10, 0, 0, new int[]{0, 0, 0, 0, 0, 0, 0}, 0), new THINGINFO(0, 1, 1, 2, 0, 0, 0, 1160, 0, 2, 0, 0, new int[]{0, 0, 0, 0, 0, 0, 0}, 0), new THINGINFO(15, 4, 4, 3, 24576, 0, 257, -1, 0, 0, 0, 0, new int[]{128, 64, 256, 256, 0, 0, 256}, 0), new THINGINFO(30, 30, 8, 3, 8192, 0, 257, -1, 0, 0, 0, 0, new int[]{128, 64, 256, 256, 0, 0, 64}, 0), new THINGINFO(60, 5, 32, 3, 40960, 1280, 257, 3405, 0, 0, 40, 40, new int[]{128, 64, 256, 256, 0, 0, 64}, 1), new THINGINFO(80, 30, 32, 3, 57344, 1600, 256, 3281, 128, 0, 32, 32, new int[]{0, 0, 0, 0, 0, 0, 0}, 1), new THINGINFO(80, 30, 32, 3, 57344, 1600, 256, 2020, 128, 0, 32, 32, new int[]{256, 0, 256, 256, 0, 0, 0}, 1), new THINGINFO(80, 30, 32, 3, 57344, 1600, 256, 1860, 128, 0, 32, 32, new int[]{256, 0, 256, 256, 0, 0, 0}, 1), new THINGINFO(150, 30, 48, 3, 32768, 1600, 257, 800, 128, 0, 48, 48, new int[]{64, 64, 112, 64, 0, 96, 96}, 1), new THINGINFO(1, 30, 48, 3, 0, 32768, 1600, 0, 2443, 128, 16, 16, new int[]{0, 0, 0, 0, 0, 0, 0}, 0), new THINGINFO(5, 5, 16, 3, 24576, 1600, 256, 3444, 240, 7, 32, 32, new int[]{256, 256, 256, 64, 0, 0, 512}, 1), new THINGINFO(5, 6, 16, 3, 32768, 1600, 256, 1462, 0, 0, 32, 32, new int[]{0, 0, 0, 0, 0, 0, 0}, 1), new THINGINFO(150, 30, 48, 3, 32768, 1600, 257, 800, 128, 0, 48, 48, new int[]{64, 64, 112, 64, 0, 96, 96}, 1)};
        gAmmoItemData = new AMMOITEMDATA[]{new AMMOITEMDATA(0, 618, -8, 0, 48, 48, 480, 6, 7), new AMMOITEMDATA(0, 589, -8, 0, 48, 48, 1, 5, 6), new AMMOITEMDATA(0, 589, -8, 0, 48, 48, 1, 5, 6), new AMMOITEMDATA(0, 809, -8, 0, 48, 48, 5, 5, 6), new AMMOITEMDATA(0, 811, -8, 0, 48, 48, 1, 10, 11), new AMMOITEMDATA(0, 810, -8, 0, 48, 48, 1, 11, 12), new AMMOITEMDATA(0, 820, -8, 0, 24, 24, 10, 8, 0), new AMMOITEMDATA(0, 619, -8, 0, 48, 48, 4, 2, 0), new AMMOITEMDATA(0, 812, -8, 0, 48, 48, 15, 2, 0), new AMMOITEMDATA(0, 813, -8, 0, 48, 48, 15, 3, 0), new AMMOITEMDATA(0, 525, -8, 0, 48, 48, 100, 9, 10), new AMMOITEMDATA(0, 814, -8, 0, 48, 48, 15, 255, 0), new AMMOITEMDATA(0, 817, -8, 0, 48, 48, 100, 3, 0), new AMMOITEMDATA(0, 548, -8, 0, 24, 24, 32, 7, 0), new AMMOITEMDATA(0, 0, -8, 0, 48, 48, 6, 255, 0), new AMMOITEMDATA(0, 0, -8, 0, 48, 48, 6, 255, 0), new AMMOITEMDATA(0, 816, -8, 0, 48, 48, 8, 1, 0), new AMMOITEMDATA(0, 818, -8, 0, 48, 48, 8, 255, 0), new AMMOITEMDATA(0, 819, -8, 0, 48, 48, 8, 255, 0), new AMMOITEMDATA(0, 801, -8, 0, 48, 48, 6, 4, 0), new AMMOITEMDATA(0, 0, 0, 0, 0, 0, 0, 0, 0)};
        gWeaponItemData = new WEAPONITEMDATA[]{new WEAPONITEMDATA(0, 4096, 0, 0, 0, 0, 0, -1, 0), new WEAPONITEMDATA(0, 559, -8, 0, 48, 48, 3, 2, 8), new WEAPONITEMDATA(0, 558, -8, 0, 48, 48, 4, 3, 50), new WEAPONITEMDATA(0, 524, -8, 0, 48, 48, 2, 1, 9), new WEAPONITEMDATA(0, 525, -8, 0, 48, 48, 10, 9, 100), new WEAPONITEMDATA(0, 539, -8, 0, 48, 48, 8, 7, 64), new WEAPONITEMDATA(0, 526, -8, 0, 48, 48, 5, 4, 6), new WEAPONITEMDATA(0, 4096, 0, 0, 0, 0, 1, -1, 0), new WEAPONITEMDATA(0, 618, -8, 0, 48, 48, 7, 6, 480), new WEAPONITEMDATA(0, 589, -8, 0, 48, 48, 6, 5, 1), new WEAPONITEMDATA(0, 800, -8, 0, 48, 48, 9, 8, 35)};
        gArmorItemData = new ARMORITEMDATA[]{new ARMORITEMDATA(new int[]{800, 800, 800}, new int[]{1600, 1600, 1600}), new ARMORITEMDATA(new int[]{1600, 0, 0}, new int[]{1600, 1600, 1600}), new ARMORITEMDATA(new int[]{0, 1600, 0}, new int[]{1600, 1600, 1600}), new ARMORITEMDATA(new int[]{0, 0, 1600}, new int[]{1600, 1600, 1600}), new ARMORITEMDATA(new int[]{3200, 3200, 3200}, new int[]{3200, 3200, 3200})};
        gPowerUpInfo = new POWERUPINFO[]{new POWERUPINFO(-1, true, 1, 1), new POWERUPINFO(-1, true, 1, 1), new POWERUPINFO(-1, true, 1, 1), new POWERUPINFO(-1, true, 1, 1), new POWERUPINFO(-1, true, 1, 1), new POWERUPINFO(-1, true, 1, 1), new POWERUPINFO(-1, true, 1, 1), new POWERUPINFO(-1, false, 100, 100), new POWERUPINFO(-1, false, 50, 100), new POWERUPINFO(-1, false, 20, 100), new POWERUPINFO(-1, false, 100, 200), new POWERUPINFO(-1, false, 2, 200), new POWERUPINFO(783, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, true, 3600, 432000), new POWERUPINFO(827, false, 3600, 432000), new POWERUPINFO(828, false, 3600, 432000), new POWERUPINFO(829, false, 3600, 1728000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(851, false, 3600, 432000), new POWERUPINFO(2428, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 900, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, false, 3600, 432000), new POWERUPINFO(-1, true, 3600, 432000), new POWERUPINFO(-1, false, 1, 432000), new POWERUPINFO(-1, false, 1, 432000), new POWERUPINFO(-1, false, 1, 432000), new POWERUPINFO(-1, false, 1, 432000), new POWERUPINFO(-1, false, 1, 432000), new POWERUPINFO(0, false, 0, 0), new POWERUPINFO(0, false, 0, 0), new POWERUPINFO(0, false, 0, 0), new POWERUPINFO(0, false, 0, 0), new POWERUPINFO(-1, false, 1, 432000)};
        gItemInfo = new ITEMDATA[]{new ITEMDATA(-1, 2552, -8, 0, 32, 32), new ITEMDATA(-1, 2553, -8, 0, 32, 32), new ITEMDATA(-1, 2554, -8, 0, 32, 32), new ITEMDATA(-1, 2555, -8, 0, 32, 32), new ITEMDATA(-1, 2556, -8, 0, 32, 32), new ITEMDATA(-1, 2557, -8, 0, 32, 32), new ITEMDATA(-1, 0, -8, 0, 0, 0), new ITEMDATA(0, 519, -8, 0, 48, 48), new ITEMDATA(-1, 822, -8, 0, 40, 40), new ITEMDATA(-1, 2169, -8, 0, 40, 40), new ITEMDATA(-1, 2433, -8, 0, 40, 40), new ITEMDATA(-1, 517, -8, 0, 40, 40), new ITEMDATA(-1, 783, -8, 0, 40, 40), new ITEMDATA(-1, 896, -8, 0, 40, 40), new ITEMDATA(-1, 825, -8, 0, 40, 40), new ITEMDATA(4, 827, -8, 0, 40, 40), new ITEMDATA(-1, 828, -8, 0, 40, 40), new ITEMDATA(6, 829, -8, 0, 40, 40), new ITEMDATA(1, 830, -8, 0, 80, 64), new ITEMDATA(-1, 831, -8, 0, 40, 40), new ITEMDATA(-1, 863, -8, 0, 40, 40), new ITEMDATA(2, 760, -8, 0, 40, 40), new ITEMDATA(-1, 836, -8, 0, 40, 40), new ITEMDATA(-1, 851, -8, 0, 40, 40), new ITEMDATA(-1, 2428, -8, 0, 40, 40), new ITEMDATA(3, 839, -8, 0, 40, 40), new ITEMDATA(-1, 768, -8, 0, 64, 64), new ITEMDATA(-1, 840, -8, 0, 48, 48), new ITEMDATA(-1, 841, -8, 0, 48, 48), new ITEMDATA(-1, 842, -8, 0, 48, 48), new ITEMDATA(-1, 843, -8, 0, 48, 48), new ITEMDATA(-1, 683, -8, 0, 40, 40), new ITEMDATA(-1, 521, -8, 0, 40, 40), new ITEMDATA(-1, 604, -8, 0, 40, 40), new ITEMDATA(-1, 520, -8, 0, 40, 40), new ITEMDATA(-1, 803, -8, 0, 40, 40), new ITEMDATA(-1, 518, -8, 0, 40, 40), new ITEMDATA(-1, 522, -8, 0, 40, 40), new ITEMDATA(-1, 523, -8, 0, 40, 40), new ITEMDATA(-1, 837, -8, 0, 80, 64), new ITEMDATA(-1, 2628, -8, 0, 64, 64), new ITEMDATA(-1, 2586, -8, 0, 64, 64), new ITEMDATA(-1, 2578, -8, 0, 64, 64), new ITEMDATA(-1, 2602, -8, 0, 64, 64), new ITEMDATA(-1, 2594, -8, 0, 64, 64), new ITEMDATA(-1, 753, -8, 0, 64, 64), new ITEMDATA(-1, 753, -8, 7, 64, 64), new ITEMDATA(-1, 3558, 128, 0, 64, 64), new ITEMDATA(-1, 3558, 128, 7, 64, 64)};
        info_nSprite = -1;
        info_pSprite = null;
        info_pXSprite = null;
        info_nWall = -1;
        info_pWall = null;
        info_pXWall = null;
        info_nSector = -1;
        info_pSector = null;
        info_pXSector = null;
        NapalmAmmo = new int[2];
    }
}

