/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Menus;

import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.QAV;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;

public class MenuQav
extends MenuItem {
    public String qFileName;
    public int qFileId;
    public QAV pQAV;
    public int duration;
    public int qGameClock;
    public boolean clearScreen;

    public MenuQav(int x, int y, int qFileId) {
        super(null, null);
        this.flags = 1;
        this.m_pMenu = null;
        this.width = 0;
        this.x = x;
        this.y = y;
        this.qFileId = qFileId;
        this.qFileName = null;
        this.clearScreen = false;
    }

    public MenuQav(int x, int y, String qFileName) {
        super(null, null);
        this.flags = 1;
        this.m_pMenu = null;
        this.width = 0;
        this.x = x;
        this.y = y;
        this.qFileName = qFileName;
        this.qFileId = -1;
        this.clearScreen = false;
    }

    @Override
    public void draw(MenuHandler handler) {
        if (this.pQAV != null) {
            if (this.clearScreen) {
                Main.engine.getrender().clearview(0);
            }
            int oldFrameClock = Globals.gFrameClock;
            Globals.gFrameClock = Engine.totalclock;
            int ticks = Engine.totalclock - this.qGameClock;
            this.qGameClock = Engine.totalclock;
            this.duration -= ticks;
            if (this.duration <= 0 || this.duration > this.pQAV.duration) {
                this.duration = this.pQAV.duration;
            }
            int t = this.pQAV.duration - this.duration;
            this.pQAV.Play(t - ticks, t, -1, null);
            int oldwx1 = Engine.windowx1;
            int oldwy1 = Engine.windowy1;
            int oldwx2 = Engine.windowx2;
            int oldwy2 = Engine.windowy2;
            Engine.windowx1 = 0;
            Engine.windowy1 = 0;
            Engine.windowx2 = Engine.xdim - 1;
            Engine.windowy2 = Engine.ydim - 1;
            this.pQAV.Draw(t, 0, 10, 0, 65536);
            Engine.windowx1 = oldwx1;
            Engine.windowy1 = oldwy1;
            Engine.windowx2 = oldwx2;
            Engine.windowy2 = oldwy2;
            Globals.gFrameClock = oldFrameClock;
        }
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case LEFT: 
            case BSPACE: {
                this.m_pMenu.mNavUp();
                return false;
            }
            case RIGHT: 
            case ENTER: 
            case SPACE: {
                this.m_pMenu.mNavDown();
                return false;
            }
            case UP: 
            case DW: 
            case ESC: {
                return this.m_pMenu.mNavigation(opt);
            }
        }
        return false;
    }

    @Override
    public void open() {
        if (this.qFileName == null && this.qFileId == -1) {
            return;
        }
        if (this.pQAV != null) {
            this.duration = this.pQAV.duration;
            this.qGameClock = Engine.totalclock;
            return;
        }
        Resource hQAV = null;
        hQAV = this.qFileName != null ? BuildGdx.cache.open(this.qFileName, 0) : BuildGdx.cache.open(this.qFileId, "qav");
        if (hQAV == null) {
            System.err.println("Could not load QAV " + this.qFileName);
            return;
        }
        this.pQAV = new QAV(hQAV);
        this.pQAV.origin.x = this.x;
        this.pQAV.origin.y = this.y;
        this.duration = this.pQAV.duration;
        this.qGameClock = Engine.totalclock;
        this.pQAV.Preload();
        hQAV.close();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean mouseAction(int x, int y) {
        return false;
    }
}

