/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class Mirror {
    public static final int MIRROR = 504;
    public static final int MIRRORLABEL = 4080;
    public static final int MAXMIRRORS = 16;
    public static int mirrorcnt;
    public static boolean display_mirror;
    public static int[] MirrorType;
    public static int[] MirrorX;
    public static int[] MirrorY;
    public static int[] MirrorZ;
    public static int[] MirrorLower;
    public static int[] MirrorUpper;
    public static int MirrorSector;
    public static int[] MirrorWall;

    public static void InitMirrors() {
        int i;
        mirrorcnt = 0;
        Mirror.InitMirrorTiles();
        for (i = Engine.numwalls - 1; i >= 0 && mirrorcnt != 16; --i) {
            if (mirrorcnt == 16) {
                Console.Println("Maximum mirror count reached.", Console.OSDTEXT_YELLOW);
                break;
            }
            if (Engine.wall[i].overpicnum == 504) {
                if (Engine.wall[i].extra <= 0 || Engine.wall[i].lotag != 501) continue;
                Console.Println("Initializing wall overpicnum mirror for", 0);
                Engine.wall[i].cstat = (short)(Engine.wall[i].cstat | 0x20);
                Engine.wall[i].overpicnum = (short)(mirrorcnt + 4080);
                Mirror.MirrorType[Mirror.mirrorcnt] = 0;
                short nXWall = Engine.wall[i].extra;
                Mirror.MirrorUpper[Mirror.mirrorcnt] = i;
                int data = DB.xwall[nXWall].data;
                int nWall = Engine.numwalls;
                while (--nWall >= 0) {
                    short nXWall2;
                    if (nWall == i || (nXWall2 = Engine.wall[nWall].extra) <= 0 || Engine.wall[nWall].lotag != 501 || DB.xwall[nXWall2].data != data) continue;
                    Engine.wall[i].hitag = (short)nWall;
                    Engine.wall[nWall].hitag = (short)i;
                    Mirror.MirrorLower[Mirror.mirrorcnt] = nWall;
                    break;
                }
                if (nWall < 0) {
                    Main.game.dassert("wall[" + i + "] has no matching wall link! (data=" + DB.xwall[nXWall].data + ")");
                }
                ++mirrorcnt;
                continue;
            }
            if (Engine.wall[i].picnum != 504) continue;
            Engine.wall[i].cstat = (short)(Engine.wall[i].cstat | 0x20);
            Engine.wall[i].picnum = (short)(mirrorcnt + 4080);
            Mirror.MirrorType[Mirror.mirrorcnt] = 0;
            Mirror.MirrorLower[Mirror.mirrorcnt] = i;
            Mirror.MirrorUpper[Mirror.mirrorcnt] = i;
            ++mirrorcnt;
        }
        for (i = Engine.numsectors - 1; i >= 0 && mirrorcnt < 15; --i) {
            short nLower;
            int nUpper;
            if (mirrorcnt == 16) {
                Console.Println("Maximum mirror count reached.", Console.OSDTEXT_YELLOW);
                break;
            }
            if (Engine.sector[i].floorpicnum != 504 || (nUpper = Warp.gUpperLink[i]) < 0 || (nLower = Engine.sprite[nUpper].owner) == -1) continue;
            if (Engine.sector[Engine.sprite[nLower].sectnum].ceilingpicnum != 504) {
                Console.Println("Lower link sector " + i + " doesn't have mirror picnum!", Console.OSDTEXT_RED);
            }
            Mirror.MirrorType[Mirror.mirrorcnt] = 2;
            Mirror.MirrorX[Mirror.mirrorcnt] = Engine.sprite[nLower].x - Engine.sprite[nUpper].x;
            Mirror.MirrorY[Mirror.mirrorcnt] = Engine.sprite[nLower].y - Engine.sprite[nUpper].y;
            Mirror.MirrorZ[Mirror.mirrorcnt] = Engine.sprite[nLower].z - Engine.sprite[nUpper].z;
            Mirror.MirrorLower[Mirror.mirrorcnt] = Engine.sprite[nLower].sectnum;
            Mirror.MirrorUpper[Mirror.mirrorcnt] = i;
            Engine.sector[i].floorpicnum = (short)(4080 + mirrorcnt++);
            Mirror.MirrorType[Mirror.mirrorcnt] = 1;
            Mirror.MirrorX[Mirror.mirrorcnt] = Engine.sprite[nUpper].x - Engine.sprite[nLower].x;
            Mirror.MirrorY[Mirror.mirrorcnt] = Engine.sprite[nUpper].y - Engine.sprite[nLower].y;
            Mirror.MirrorZ[Mirror.mirrorcnt] = Engine.sprite[nUpper].z - Engine.sprite[nLower].z;
            Mirror.MirrorLower[Mirror.mirrorcnt] = i;
            Mirror.MirrorUpper[Mirror.mirrorcnt] = Engine.sprite[nLower].sectnum;
            Engine.sector[Engine.sprite[nLower].sectnum].ceilingpicnum = (short)(4080 + mirrorcnt++);
        }
        Mirror.initMirrorWall();
    }

    public static void initMirrorWall() {
        if (Engine.numsectors >= Globals.kMaxSectors) {
            return;
        }
        MirrorSector = Engine.numsectors;
        for (int i = 0; i < 4; ++i) {
            int nWall;
            Mirror.MirrorWall[i] = nWall = Engine.numwalls + i;
            WALL pWall = new WALL();
            pWall.picnum = (short)504;
            pWall.overpicnum = (short)504;
            pWall.cstat = 0;
            pWall.nextsector = (short)-1;
            pWall.nextwall = (short)-1;
            pWall.point2 = (short)(nWall + 1);
            Engine.wall[nWall] = pWall;
        }
        Engine.wall[Mirror.MirrorWall[3]].point2 = (short)MirrorWall[0];
        SECTOR pSector = new SECTOR();
        pSector.ceilingpicnum = (short)504;
        pSector.floorpicnum = (short)504;
        pSector.wallnum = (short)4;
        pSector.wallptr = (short)MirrorWall[0];
        Engine.sector[Mirror.MirrorSector] = pSector;
    }

    public static void InitMirrorTiles() {
        Main.engine.getTile(504).clear();
        for (int i = 0; i < 16; ++i) {
            Main.engine.getTile(i + 4080).clear();
        }
    }

    public static void processMirror(long nViewX, long nViewY) {
        int i;
        for (i = Engine.spritesortcnt - 1; i >= 0; --i) {
            Engine.tsprite[i].yrepeat = 0;
            Engine.tsprite[i].xrepeat = 0;
        }
        for (i = mirrorcnt - 1; i >= 0; --i) {
            int type;
            int nMirror = i + 4080;
            if ((Engine.gotpic[nMirror >> 3] & Engine.pow2char[nMirror & 7]) == 0 || (type = MirrorType[i]) != 1 && type != 2) continue;
            short j = Engine.headspritesect[MirrorLower[i]];
            while (j >= 0) {
                SPRITE pSprite = Engine.sprite[j];
                if (pSprite != Globals.gPlayer[View.gViewIndex].pSprite) {
                    Gameutils.GetSpriteExtents(pSprite);
                    Main.engine.getzsofslope((short)MirrorLower[i], pSprite.x, pSprite.y, Globals.zofslope);
                    if (pSprite.lotag == 6 && (Gameutils.extents_zTop < Globals.zofslope[0] || Gameutils.extents_zBot > Globals.zofslope[1])) {
                        int cnt = type == 2 ? i + 1 : i - 1;
                        int mirX = MirrorX[cnt];
                        int mirY = MirrorY[cnt];
                        int mirZ = MirrorZ[cnt];
                        SPRITE tSprite = View.viewInsertTSprite(MirrorUpper[i], 0, null);
                        tSprite.reset((byte)0);
                        tSprite.lotag = pSprite.lotag;
                        tSprite.xvel = pSprite.xvel;
                        tSprite.sectnum = (short)MirrorUpper[i];
                        tSprite.x = mirX + pSprite.x;
                        tSprite.y = mirY + pSprite.y;
                        tSprite.z = mirZ + pSprite.z;
                        tSprite.ang = pSprite.ang;
                        tSprite.picnum = pSprite.picnum;
                        tSprite.shade = pSprite.shade;
                        tSprite.pal = pSprite.pal;
                        tSprite.xrepeat = pSprite.xrepeat;
                        tSprite.yrepeat = pSprite.yrepeat;
                        tSprite.xoffset = pSprite.xoffset;
                        tSprite.yoffset = pSprite.yoffset;
                        tSprite.statnum = 0;
                        tSprite.cstat = pSprite.cstat;
                        tSprite.owner = pSprite.xvel;
                        tSprite.extra = pSprite.extra;
                        tSprite.hitag = (short)(pSprite.hitag | 2);
                        View.viewBackupSpriteLoc(pSprite.xvel, pSprite);
                    }
                }
                j = Engine.nextspritesect[j];
            }
        }
        for (int nTSprite = Engine.spritesortcnt - 1; nTSprite >= 0; --nTSprite) {
            SPRITE pTSprite = Engine.tsprite[nTSprite];
            int nFrames = 0;
            BloodTile pic = Main.engine.getTile(pTSprite.picnum);
            switch (pic.getView()) {
                case kSpriteView5Full: {
                    int dx = (int)(nViewX - (long)pTSprite.x);
                    int dy = (int)(nViewY - (long)pTSprite.y);
                    Trig.RotateVector(dx, dy, -pTSprite.ang + 128);
                    nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    if (nFrames > 4) {
                        nFrames = 8 - nFrames;
                        pTSprite.cstat = (short)(pTSprite.cstat | 4);
                        break;
                    }
                    pTSprite.cstat = (short)(pTSprite.cstat & 0xFFFFFFFB);
                    break;
                }
                case kSpriteView8Full: {
                    int dx = (int)(nViewX - (long)pTSprite.x);
                    int dy = (int)(nViewY - (long)pTSprite.y);
                    Trig.RotateVector(dx, dy, -pTSprite.ang + 128);
                    nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    break;
                }
            }
            while (nFrames > 0) {
                --nFrames;
                pTSprite.picnum = (short)(pTSprite.picnum + (pic.getFrames() + 1));
            }
        }
    }

    public static void setMirrorParalax(boolean mirror) {
        for (int i = mirrorcnt - 1; i >= 0; --i) {
            int nMirror = i + 4080;
            if ((Engine.gotpic[nMirror >> 3] & Engine.pow2char[nMirror & 7]) == 0) continue;
            int type = MirrorType[i];
            int nSector = MirrorUpper[i];
            if (type == 1) {
                if (mirror) {
                    Engine.sector[nSector].ceilingstat = (short)(Engine.sector[nSector].ceilingstat | 1);
                    continue;
                }
                Engine.sector[nSector].ceilingstat = (short)(Engine.sector[nSector].ceilingstat & 0xFFFFFFFE);
                continue;
            }
            if (type != 2) continue;
            Engine.sector[nSector].floorstat = mirror ? (short)(Engine.sector[nSector].floorstat | 1) : (short)(Engine.sector[nSector].floorstat & 0xFFFFFFFE);
        }
    }

    public static void DrawMirrors(long x, long y, long z, float ang, float horiz) {
        for (int i = mirrorcnt - 1; i >= 0; --i) {
            int nMirror = i + 4080;
            if ((Engine.gotpic[nMirror >> 3] & Engine.pow2char[nMirror & 7]) == 0) continue;
            int type = MirrorType[i];
            if (type == 0) {
                int nWall = MirrorLower[i];
                WALL pWall = Engine.wall[nWall];
                short nSector = Main.engine.sectorofwall((short)nWall);
                short oldNextwall = pWall.nextwall;
                short oldNextsector = pWall.nextsector;
                pWall.nextwall = (short)MirrorWall[0];
                pWall.nextsector = (short)MirrorSector;
                Engine.wall[Mirror.MirrorWall[0]].nextwall = (short)nWall;
                Engine.wall[Mirror.MirrorWall[0]].nextsector = nSector;
                Engine.wall[Mirror.MirrorWall[0]].x = Engine.wall[pWall.point2].x;
                Engine.wall[Mirror.MirrorWall[0]].y = Engine.wall[pWall.point2].y;
                Engine.wall[Mirror.MirrorWall[1]].x = pWall.x;
                Engine.wall[Mirror.MirrorWall[1]].y = pWall.y;
                Engine.wall[Mirror.MirrorWall[2]].x = 16 * (Engine.wall[Mirror.MirrorWall[1]].x - Engine.wall[Mirror.MirrorWall[0]].x) + Engine.wall[Mirror.MirrorWall[1]].x;
                Engine.wall[Mirror.MirrorWall[2]].y = 16 * (Engine.wall[Mirror.MirrorWall[1]].y - Engine.wall[Mirror.MirrorWall[0]].y) + Engine.wall[Mirror.MirrorWall[1]].y;
                Engine.wall[Mirror.MirrorWall[3]].x = 16 * (Engine.wall[Mirror.MirrorWall[0]].x - Engine.wall[Mirror.MirrorWall[1]].x) + Engine.wall[Mirror.MirrorWall[0]].x;
                Engine.wall[Mirror.MirrorWall[3]].y = 16 * (Engine.wall[Mirror.MirrorWall[0]].y - Engine.wall[Mirror.MirrorWall[1]].y) + Engine.wall[Mirror.MirrorWall[0]].y;
                Engine.sector[Mirror.MirrorSector].floorz = Engine.sector[nSector].floorz;
                Engine.sector[Mirror.MirrorSector].ceilingz = Engine.sector[nSector].ceilingz;
                int mirX = 0;
                int mirY = 0;
                float mirAng = 0.0f;
                if (pWall.lotag == 501) {
                    mirX = (int)(x - (long)(Engine.wall[pWall.hitag].x - Engine.wall[pWall.point2].x));
                    mirY = (int)(y - (long)(Engine.wall[pWall.hitag].y - Engine.wall[pWall.point2].y));
                    mirAng = ang;
                } else {
                    Main.engine.preparemirror((int)x, (int)y, (int)z, ang, horiz, nWall, MirrorSector);
                    mirX = Engine.mirrorx;
                    mirY = Engine.mirrory;
                    mirAng = Engine.mirrorang;
                }
                Main.engine.drawrooms(mirX, mirY, z, mirAng, horiz, (short)(MirrorSector | Engine.MAXSECTORS));
                display_mirror = true;
                View.viewProcessSprites(mirX, mirY, z);
                display_mirror = false;
                Main.engine.drawmasks();
                if (pWall.lotag != 501) {
                    Main.engine.completemirror();
                }
                pWall.nextwall = oldNextwall;
                pWall.nextsector = oldNextsector;
            } else if (type == 1) {
                int nSector = MirrorLower[i];
                Main.engine.drawrooms(x + (long)MirrorX[i], (long)MirrorY[i] + y, z + (long)MirrorZ[i], ang, horiz, (short)(nSector | Engine.MAXSECTORS));
                View.viewProcessSprites(x + (long)MirrorX[i], (long)MirrorY[i] + y, z + (long)MirrorZ[i]);
                short oldstat = Engine.sector[nSector].floorstat;
                Engine.sector[nSector].floorstat = (short)(Engine.sector[nSector].floorstat | 1);
                Main.engine.drawmasks();
                Engine.sector[nSector].floorstat = oldstat;
            } else if (type == 2) {
                int nSector = MirrorLower[i];
                Main.engine.drawrooms(x + (long)MirrorX[i], (long)MirrorY[i] + y, z + (long)MirrorZ[i], ang, horiz, (short)(nSector | Engine.MAXSECTORS));
                View.viewProcessSprites(x + (long)MirrorX[i], (long)MirrorY[i] + y, z + (long)MirrorZ[i]);
                short oldstat = Engine.sector[nSector].ceilingstat;
                Engine.sector[nSector].ceilingstat = (short)(Engine.sector[nSector].ceilingstat | 1);
                Main.engine.drawmasks();
                Engine.sector[nSector].ceilingstat = oldstat;
            }
            int n = nMirror >> 3;
            Engine.gotpic[n] = (byte)(Engine.gotpic[n] & ~Engine.pow2char[nMirror & 7]);
            return;
        }
    }

    static {
        MirrorType = new int[16];
        MirrorX = new int[16];
        MirrorY = new int[16];
        MirrorZ = new int[16];
        MirrorLower = new int[16];
        MirrorUpper = new int[16];
        MirrorWall = new int[4];
    }
}

