/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector3;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Gib;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LOADSAVE;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.QAV;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.AMMOINFO;
import ru.m210projects.Blood.Types.AMMOITEMDATA;
import ru.m210projects.Blood.Types.ARMORITEMDATA;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DAMAGEINFO;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.FragInfo;
import ru.m210projects.Blood.Types.INPUT;
import ru.m210projects.Blood.Types.INVITEM;
import ru.m210projects.Blood.Types.PLOCATION;
import ru.m210projects.Blood.Types.POSTURE;
import ru.m210projects.Blood.Types.QUOTE;
import ru.m210projects.Blood.Types.ScreenEffect;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.WEAPONITEMDATA;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.Types.ZONE;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class PLAYER {
    public static PLOCATION[] gPrevView = new PLOCATION[8];
    public static String PlayerName;
    public static final String deathMessage = "Press \"USE\" to load last saved game or press \"ENTER\" to restart level";
    public static final int kInventoryDoctorBag = 0;
    public static final int kInventoryDivingSuit = 1;
    public static final int kInventoryCrystalBall = 2;
    public static final int kInventoryBeastVision = 3;
    public static final int kInventoryJumpBoots = 4;
    public static final int kInventoryJetpack = 5;
    public static final int BLUEARMOR = 0;
    public static final int REDARMOR = 1;
    public static final int GREENARMOR = 2;
    public static final int kOrderMax = 2;
    public static final int kWeaponNone = 0;
    public static final int kWeaponPitchfork = 1;
    public static final int kWeaponFlare = 2;
    public static final int kWeaponShotgun = 3;
    public static final int kWeaponTommy = 4;
    public static final int kWeaponNapalm = 5;
    public static final int kWeaponTNT = 6;
    public static final int kWeaponSprayCan = 7;
    public static final int kWeaponTesla = 8;
    public static final int kWeaponVoodoo = 10;
    public static final int kWeaponLifeLeach = 9;
    public static final int kWeaponProxyTNT = 11;
    public static final int kWeaponRemoteTNT = 12;
    public static final int kWeaponBeast = 13;
    public static final int kWeaponMax = 14;
    public static final int kAmmoNone = -1;
    public static final int kLookMax = 60;
    public static final int kHorizUpMax = 120;
    public static final int kHorizDownMax = 180;
    public static final int kHorizDefault = 90;
    public static boolean newHoriz;
    public static final int newHorizDefault = 100;
    public static final int kMoveWalk = 0;
    public static final int kMoveSwim = 1;
    public static final int kMoveCrouch = 2;
    public static final int kMoveFly = 3;
    public static final int kModeHuman = 0;
    public static final int kModeBeast = 1;
    public static final int kModeHumanShrink = 2;
    public static final int kModeHumanGrown = 3;
    public static final int kTouchXYDist = 48;
    public static final int kTouchZDist = 32;
    public static final int kPushXYDist = 64;
    public static final int[] gLaughs;
    public static QAV[] weaponQAVs;
    public static AMMOINFO[] gAmmoInfo;
    public static DAMAGEINFO[] gDamageInfo;
    public SPRITE pSprite;
    public XSPRITE pXsprite;
    public DudeInfo pDudeInfo;
    public INPUT pInput;
    public int NPSTART;
    public int pWeaponQAV;
    public int weaponCallback;
    public boolean Run;
    public int moveState;
    public int moveDist;
    public int bobPhase;
    public int bobAmp;
    public int bobHeight;
    public int bobWidth;
    public int swayPhase;
    public int swayAmp;
    public int swayHeight;
    public int swayWidth;
    public int nPlayer;
    public int nSprite;
    public int nLifeMode;
    public int bloodlust;
    public int weapOffdZ;
    public int viewOffdZ;
    public int weaponAboveZ;
    public int viewOffZ;
    public float look;
    public float horiz;
    public int slope;
    public float horizOff;
    public boolean Underwater;
    public boolean[] hasKey = new boolean[8];
    public int hasFlag;
    public short nBlueTeam;
    public short nRedTeam;
    public int[] damageShift = new int[7];
    public int CrouchMode;
    public int LastWeapon;
    public int currentWeapon;
    public int updateWeapon;
    public int weaponTimer;
    public int weaponState;
    public int weaponAmmo;
    public boolean[] hasWeapon = new boolean[14];
    public int[] weaponMode = new int[14];
    public int[][] weaponOrder = new int[2][14];
    public int[] ammoCount = new int[12];
    public boolean fLoopQAV;
    public int fuseTime;
    public int fireClock;
    public int throwTime;
    public Vector3 aim;
    public Vector3 relAim;
    public int nAimSprite;
    public int aimCount;
    public int[] aimSprites = new int[16];
    public int deathTime;
    public int[] powerUpTimer = new int[49];
    public int fragCount;
    public int[] fragInfo = new int[8];
    public int teamID;
    public int fraggerID;
    public int airTime;
    public int bloodTime;
    public int gooTime;
    public int wetTime;
    public int bubbleTime;
    public int kickTime;
    public int stayTime;
    public int pLaughsCount;
    public int TurnAround;
    public boolean godMode;
    public boolean fScreamed;
    public boolean pJump;
    public int showInventory;
    public int choosedInven;
    public static final int kInventoryMax = 6;
    public INVITEM[] Inventory = new INVITEM[6];
    public int[] ArmorAmount = new int[3];
    int voodooTarget;
    int voodooCount;
    int voodooAng;
    int voodooUnk;
    public int explosion;
    public int tilt;
    public int visibility;
    public int fireEffect;
    public int hitEffect;
    public int blindEffect;
    public int drownEffect;
    public int handCount;
    public boolean handDamage;
    public int pickupEffect;
    public int quakeTime;
    public int lookang;
    public int rotscrnang;
    public float ang;
    public static int Action_nIndex;
    public static int Action_nXIndex;
    public static final int kWaneTime = 512;
    public static int timer;
    private static final boolean gInventorySwap = true;
    public static final FragInfo[] deathAphorisms1;
    public static final FragInfo[] deathAphorisms2;
    private ByteBuffer PlayerBuffer;

    public PLAYER() {
        this.aim = new Vector3();
        this.relAim = new Vector3();
        this.pInput = new INPUT();
        for (int i = 0; i < 6; ++i) {
            this.Inventory[i] = new INVITEM();
        }
    }

    public void copy(PLAYER pPlayer) {
        int i;
        this.pSprite = pPlayer.pSprite;
        this.pXsprite = pPlayer.pXsprite;
        this.pDudeInfo = pPlayer.pDudeInfo;
        this.pInput = pPlayer.pInput;
        this.ang = pPlayer.ang;
        this.pWeaponQAV = pPlayer.pWeaponQAV;
        this.weaponCallback = pPlayer.weaponCallback;
        this.Run = pPlayer.Run;
        this.moveState = pPlayer.moveState;
        this.bobPhase = pPlayer.bobPhase;
        this.bobAmp = pPlayer.bobAmp;
        this.bobHeight = pPlayer.bobHeight;
        this.bobWidth = pPlayer.bobWidth;
        this.swayPhase = pPlayer.swayPhase;
        this.swayAmp = pPlayer.swayAmp;
        this.swayHeight = pPlayer.swayHeight;
        this.swayWidth = pPlayer.swayWidth;
        this.nPlayer = pPlayer.nPlayer;
        this.nSprite = pPlayer.nSprite;
        this.nLifeMode = pPlayer.nLifeMode;
        this.bloodlust = pPlayer.bloodlust;
        this.weapOffdZ = pPlayer.weapOffdZ;
        this.viewOffdZ = pPlayer.viewOffdZ;
        this.weaponAboveZ = pPlayer.weaponAboveZ;
        this.viewOffZ = pPlayer.viewOffZ;
        this.look = pPlayer.look;
        this.horiz = pPlayer.horiz;
        this.slope = pPlayer.slope;
        this.horizOff = pPlayer.horizOff;
        this.Underwater = pPlayer.Underwater;
        this.hasFlag = pPlayer.hasFlag;
        this.nBlueTeam = pPlayer.nBlueTeam;
        this.nRedTeam = pPlayer.nRedTeam;
        System.arraycopy(pPlayer.hasKey, 0, this.hasKey, 0, 8);
        System.arraycopy(pPlayer.damageShift, 0, this.damageShift, 0, 7);
        this.CrouchMode = pPlayer.CrouchMode;
        this.LastWeapon = pPlayer.LastWeapon;
        this.currentWeapon = pPlayer.currentWeapon;
        this.updateWeapon = pPlayer.updateWeapon;
        this.weaponTimer = pPlayer.weaponTimer;
        this.weaponState = pPlayer.weaponState;
        this.weaponAmmo = pPlayer.weaponAmmo;
        for (i = 0; i < 14; ++i) {
            this.weaponMode[i] = pPlayer.weaponMode[i];
            this.hasWeapon[i] = pPlayer.hasWeapon[i];
            this.weaponOrder[0][i] = pPlayer.weaponOrder[0][i];
            this.weaponOrder[1][i] = pPlayer.weaponOrder[1][i];
        }
        System.arraycopy(pPlayer.ammoCount, 0, this.ammoCount, 0, 12);
        this.fLoopQAV = pPlayer.fLoopQAV;
        this.fuseTime = pPlayer.fuseTime;
        this.fireClock = pPlayer.fireClock;
        this.throwTime = pPlayer.throwTime;
        this.aim = pPlayer.aim;
        this.relAim = pPlayer.relAim;
        this.nAimSprite = pPlayer.nAimSprite;
        this.aimCount = pPlayer.aimCount;
        System.arraycopy(pPlayer.aimSprites, 0, this.aimSprites, 0, 16);
        this.deathTime = pPlayer.deathTime;
        System.arraycopy(pPlayer.powerUpTimer, 0, this.powerUpTimer, 0, 49);
        this.fragCount = pPlayer.fragCount;
        System.arraycopy(pPlayer.fragInfo, 0, this.fragInfo, 0, 8);
        this.teamID = pPlayer.teamID;
        this.fraggerID = pPlayer.fraggerID;
        this.airTime = pPlayer.airTime;
        this.bloodTime = pPlayer.bloodTime;
        this.gooTime = pPlayer.gooTime;
        this.wetTime = pPlayer.wetTime;
        this.bubbleTime = pPlayer.bubbleTime;
        this.stayTime = pPlayer.stayTime;
        this.kickTime = pPlayer.kickTime;
        this.pLaughsCount = pPlayer.pLaughsCount;
        this.TurnAround = pPlayer.TurnAround;
        this.godMode = pPlayer.godMode;
        this.fScreamed = pPlayer.fScreamed;
        this.pJump = pPlayer.pJump;
        this.showInventory = pPlayer.showInventory;
        this.choosedInven = pPlayer.choosedInven;
        for (i = 0; i < 6; ++i) {
            this.Inventory[i].activated = pPlayer.Inventory[i].activated;
            this.Inventory[i].amount = pPlayer.Inventory[i].amount;
        }
        System.arraycopy(pPlayer.ArmorAmount, 0, this.ArmorAmount, 0, 3);
        this.voodooTarget = pPlayer.voodooTarget;
        this.voodooCount = pPlayer.voodooCount;
        this.voodooAng = pPlayer.voodooAng;
        this.voodooUnk = pPlayer.voodooUnk;
        this.explosion = pPlayer.explosion;
        this.tilt = pPlayer.tilt;
        this.visibility = pPlayer.visibility;
        this.fireEffect = pPlayer.fireEffect;
        this.hitEffect = pPlayer.hitEffect;
        this.blindEffect = pPlayer.blindEffect;
        this.drownEffect = pPlayer.drownEffect;
        this.handCount = pPlayer.handCount;
        this.handDamage = pPlayer.handDamage;
        this.pickupEffect = pPlayer.pickupEffect;
        this.quakeTime = pPlayer.quakeTime;
        this.lookang = pPlayer.lookang;
        this.rotscrnang = pPlayer.rotscrnang;
    }

    public void reset() {
        int i;
        this.pSprite = null;
        this.pXsprite = null;
        this.pDudeInfo = null;
        this.pInput.Reset();
        this.ang = 0.0f;
        this.pWeaponQAV = 0;
        this.weaponCallback = 0;
        this.Run = false;
        this.moveState = 0;
        this.bobPhase = 0;
        this.bobAmp = 0;
        this.bobHeight = 0;
        this.bobWidth = 0;
        this.swayPhase = 0;
        this.swayAmp = 0;
        this.swayHeight = 0;
        this.swayWidth = 0;
        this.nPlayer = 0;
        this.nSprite = 0;
        this.nLifeMode = 0;
        this.bloodlust = 0;
        this.weapOffdZ = 0;
        this.viewOffdZ = 0;
        this.weaponAboveZ = 0;
        this.viewOffZ = 0;
        this.look = 0.0f;
        this.horiz = 0.0f;
        this.slope = 0;
        this.horizOff = 0.0f;
        this.Underwater = false;
        for (i = 0; i < 8; ++i) {
            this.hasKey[i] = false;
        }
        for (i = 0; i < 7; ++i) {
            this.damageShift[i] = 0;
        }
        this.CrouchMode = 0;
        this.LastWeapon = 0;
        this.currentWeapon = 0;
        this.updateWeapon = 0;
        this.weaponTimer = 0;
        this.weaponState = 0;
        this.weaponAmmo = 0;
        for (i = 0; i < 14; ++i) {
            this.weaponMode[i] = 0;
            this.hasWeapon[i] = false;
            this.weaponOrder[0][i] = 0;
            this.weaponOrder[1][i] = 0;
        }
        for (i = 0; i < 12; ++i) {
            this.ammoCount[i] = 0;
        }
        this.fLoopQAV = false;
        this.fuseTime = 0;
        this.fireClock = 0;
        this.throwTime = 0;
        this.aim.set(0.0f, 0.0f, 0.0f);
        this.relAim.set(0.0f, 0.0f, 0.0f);
        this.nAimSprite = 0;
        this.aimCount = 0;
        for (i = 0; i < 16; ++i) {
            this.aimSprites[i] = 0;
        }
        this.deathTime = 0;
        for (i = 0; i < 49; ++i) {
            this.powerUpTimer[i] = 0;
        }
        this.fragCount = 0;
        for (i = 0; i < 8; ++i) {
            this.fragInfo[i] = 0;
        }
        this.teamID = 0;
        this.fraggerID = 0;
        this.airTime = 0;
        this.bloodTime = 0;
        this.gooTime = 0;
        this.wetTime = 0;
        this.bubbleTime = 0;
        this.kickTime = 0;
        this.stayTime = 0;
        this.pLaughsCount = 0;
        this.TurnAround = 0;
        this.godMode = false;
        this.fScreamed = false;
        this.pJump = false;
        this.showInventory = 0;
        this.choosedInven = 0;
        for (i = 0; i < 6; ++i) {
            this.Inventory[i].activated = false;
            this.Inventory[i].amount = 0;
        }
        for (i = 0; i < 3; ++i) {
            this.ArmorAmount[i] = 0;
        }
        this.voodooTarget = 0;
        this.voodooCount = 0;
        this.voodooAng = 0;
        this.voodooUnk = 0;
        this.explosion = 0;
        this.tilt = 0;
        this.visibility = 0;
        this.fireEffect = 0;
        this.hitEffect = 0;
        this.blindEffect = 0;
        this.drownEffect = 0;
        this.handCount = 0;
        this.handDamage = false;
        this.pickupEffect = 0;
        this.quakeTime = 0;
        this.lookang = 0;
        this.rotscrnang = 0;
    }

    public static boolean checkPlayerSeq(PLAYER pPlayer, int nSeqID) {
        SeqInst pInst = SeqHandling.GetInstance(3, pPlayer.pSprite.extra);
        return pInst.getSeqIndex() == pPlayer.pDudeInfo.seqStartID + nSeqID && SeqHandling.seqFrame(3, pPlayer.pSprite.extra) >= 0;
    }

    public static void resetInventory(PLAYER pPlayer) {
        int i;
        if (pPlayer == null) {
            Main.game.dassert("pPlayer != NULL");
        }
        for (i = 0; i < 14; ++i) {
            pPlayer.hasWeapon[i] = Globals.gInfiniteAmmo;
            pPlayer.weaponMode[i] = 0;
        }
        pPlayer.hasWeapon[1] = true;
        pPlayer.LastWeapon = 0;
        pPlayer.currentWeapon = 0;
        pPlayer.weaponCallback = -1;
        pPlayer.pInput.newWeapon = 1;
        for (i = 0; i < 14; ++i) {
            pPlayer.weaponOrder[0][i] = Weapon.defaultOrder[i];
            pPlayer.weaponOrder[1][i] = Weapon.defaultOrder[i];
        }
        for (i = 0; i < 12; ++i) {
            pPlayer.ammoCount[i] = Globals.gInfiniteAmmo ? PLAYER.gAmmoInfo[i].max : 0;
        }
        for (i = 0; i < 3; ++i) {
            pPlayer.ArmorAmount[i] = 0;
        }
        pPlayer.weaponTimer = 0;
        pPlayer.weaponState = 0;
        pPlayer.pWeaponQAV = -1;
        pPlayer.fLoopQAV = false;
        pPlayer.choosedInven = -1;
        for (i = 0; i < 6; ++i) {
            pPlayer.Inventory[i].activated = false;
            pPlayer.Inventory[i].amount = 0;
        }
        Globals.gInfiniteAmmo = false;
    }

    public static void playerInit(int nPlayer, boolean nInited) {
        PLAYER pPlayer = Globals.gPlayer[nPlayer];
        if (!nInited) {
            System.out.println("Initializing player " + nPlayer);
            pPlayer.reset();
        }
        pPlayer.nPlayer = nPlayer;
        pPlayer.teamID = nPlayer;
        pPlayer.CrouchMode = 0;
        if (Globals.pGameInfo.nGameType == 3) {
            pPlayer.teamID = Main.game.net.gProfile[nPlayer].team == 0 ? nPlayer & 1 : Main.game.net.gProfile[nPlayer].team - 1;
        }
        pPlayer.fragCount = 0;
        Arrays.fill(Globals.nTeamCount, 0);
        Arrays.fill(Globals.nTeamClock, 0);
        Arrays.fill(pPlayer.fragInfo, 0);
        if (!nInited) {
            PLAYER.resetInventory(pPlayer);
        }
    }

    public static void playerGodMode(PLAYER pPlayer, int mode) {
        if (mode == 1) {
            int i = 0;
            while (i < 7) {
                int n = i++;
                pPlayer.damageShift[n] = pPlayer.damageShift[n] + 1;
            }
        } else {
            int i = 0;
            while (i < 7) {
                int n = i++;
                pPlayer.damageShift[n] = pPlayer.damageShift[n] - 1;
            }
        }
        pPlayer.godMode = mode == 1;
    }

    public static void playerReset(int nPlayer) {
        int i;
        PLAYER pPlayer = Globals.gPlayer[nPlayer];
        ZONE pZone = null;
        if (Globals.pGameInfo.nGameType == 0 || Globals.pGameInfo.nGameType == 1) {
            pZone = Warp.gStartZone[nPlayer];
        } else if (Globals.pGameInfo.nGameType == 3 && Warp.gTeamsSpawnUsed) {
            int maxRetries = 5;
            while (maxRetries-- > 0) {
                pZone = pPlayer.teamID == 0 ? Warp.gStartZoneTeam1[Gameutils.Random(4)] : Warp.gStartZoneTeam2[Gameutils.Random(4)];
                if (maxRetries != 0) {
                    short i2 = Engine.headspritesect[pZone.sector];
                    while (i2 >= 0) {
                        SPRITE pSprite = Engine.sprite[i2];
                        if (pZone.x == (long)pSprite.x && pZone.y == (long)pSprite.y && Gameutils.IsPlayerSprite(pSprite)) {
                            pZone = null;
                            break;
                        }
                        i2 = Engine.nextspritesect[i2];
                    }
                }
                if (pZone == null) continue;
                break;
            }
        } else {
            pZone = Warp.gStartZone[Gameutils.Random(8)];
        }
        if (pZone.sector == -1) {
            Main.game.GameMessage("The player should be inside a map sector");
            return;
        }
        int nSprite = Actor.actSpawnSprite(pZone.sector, pZone.x, pZone.y, pZone.z, 6, true);
        SPRITE pSprite = Engine.sprite[nSprite];
        if (pSprite.extra <= 0 || pSprite.extra >= 2048) {
            Main.game.dassert("pSprite.extra > 0 && pSprite.extra < kMaxXSprites");
        }
        XSPRITE pXSprite = DB.xsprite[pSprite.extra];
        pPlayer.pSprite = pSprite;
        pPlayer.pXsprite = pXSprite;
        pPlayer.nSprite = nSprite;
        pPlayer.pDudeInfo = DudeInfo.dudeInfo[nPlayer + 31];
        PLAYER.playerSetRace(pPlayer, 0);
        SeqHandling.seqSpawn(pPlayer.pDudeInfo.seqStartID + 0, 3, pSprite.extra, null);
        if (pPlayer == Globals.gMe) {
            int n = pSprite.xvel >> 3;
            Engine.show2dsprite[n] = (byte)(Engine.show2dsprite[n] | 1 << (pSprite.xvel & 7));
        }
        Gameutils.GetSpriteExtents(pSprite);
        pPlayer.CrouchMode = 0;
        pPlayer.LastWeapon = 0;
        if (Globals.pGameInfo.nGameType == 3) {
            pPlayer.teamID = Main.game.net.gProfile[nPlayer].team == 0 ? nPlayer & 1 : Main.game.net.gProfile[nPlayer].team - 1;
        }
        pPlayer.pXsprite.data1 = 0;
        pSprite.z -= Gameutils.extents_zBot - pSprite.z;
        pSprite.pal = (byte)((pPlayer.teamID & 3) + 11);
        pSprite.ang = (short)(pZone.angle & 0x7FF);
        pPlayer.ang = pSprite.ang;
        pSprite.lotag = (short)(nPlayer + 231);
        pSprite.clipdist = pPlayer.pDudeInfo.clipdist;
        pSprite.hitag = (short)15;
        pXSprite.burnTime = 0;
        pXSprite.burnSource = -1;
        pXSprite.health = pPlayer.pDudeInfo.startHealth << 4;
        pPlayer.pSprite.cstat = (short)(pPlayer.pSprite.cstat & Short.MAX_VALUE);
        pPlayer.bloodlust = 0;
        pPlayer.horiz = 0.0f;
        pPlayer.slope = 0;
        pPlayer.look = 0.0f;
        pPlayer.horizOff = 0.0f;
        pPlayer.fraggerID = -1;
        pPlayer.airTime = 1200;
        pPlayer.bloodTime = 0;
        pPlayer.gooTime = 0;
        pPlayer.wetTime = 0;
        pPlayer.bubbleTime = 0;
        pPlayer.stayTime = 0;
        pPlayer.kickTime = 0;
        pPlayer.pLaughsCount = 0;
        pPlayer.TurnAround = 0;
        pPlayer.moveState = 0;
        pPlayer.voodooTarget = -1;
        pPlayer.voodooCount = 0;
        pPlayer.voodooAng = 0;
        pPlayer.voodooUnk = 0;
        View.viewUpdatePlayerLoc(pPlayer);
        pPlayer.weapOffdZ = 0;
        pPlayer.relAim.x = 16384.0f;
        pPlayer.relAim.y = 0.0f;
        pPlayer.relAim.z = 0.0f;
        pPlayer.nAimSprite = -1;
        pPlayer.viewOffdZ = pPlayer.weapOffdZ;
        if (Globals.pGameInfo.nGameType != 1) {
            for (i = 0; i < 8; ++i) {
                pPlayer.hasKey[i] = Globals.pGameInfo.nGameType >= 2;
            }
        }
        pPlayer.hasFlag = 0;
        pPlayer.nBlueTeam = 0;
        pPlayer.nRedTeam = 0;
        for (i = 0; i < 7; ++i) {
            pPlayer.damageShift[i] = 0;
        }
        if (pPlayer.godMode) {
            PLAYER.playerGodMode(pPlayer, 1);
        }
        for (i = 0; i < 6; ++i) {
            pPlayer.Inventory[i].activated = false;
        }
        Globals.gFullMap = false;
        pPlayer.throwTime = 0;
        pPlayer.deathTime = 0;
        pPlayer.updateWeapon = 0;
        Actor.sprXVel[pSprite.xvel] = 0L;
        Actor.sprYVel[pSprite.xvel] = 0L;
        Actor.sprZVel[pSprite.xvel] = 0L;
        pPlayer.pInput.Turn = 0.0f;
        pPlayer.pInput.Jump = false;
        pPlayer.pInput.Crouch = false;
        pPlayer.pInput.Shoot = false;
        pPlayer.pInput.AltShoot = false;
        pPlayer.pInput.Lookup = false;
        pPlayer.pInput.Lookdown = false;
        pPlayer.pInput.TurnAround = false;
        pPlayer.pInput.Use = false;
        pPlayer.pInput.InventoryLeft = false;
        pPlayer.pInput.InventoryRight = false;
        pPlayer.pInput.InventoryUse = false;
        pPlayer.pInput.PrevWeapon = false;
        pPlayer.pInput.NextWeapon = false;
        pPlayer.pInput.HolsterWeapon = false;
        pPlayer.pInput.LookCenter = false;
        pPlayer.pInput.Pause = false;
        pPlayer.pInput.Quit = false;
        pPlayer.pInput.Restart = false;
        pPlayer.pInput.Forward = 0;
        pPlayer.pInput.Strafe = 0;
        pPlayer.pInput.mlook = 0.0f;
        pPlayer.explosion = 0;
        pPlayer.quakeTime = 0;
        pPlayer.tilt = 0;
        pPlayer.visibility = 0;
        pPlayer.hitEffect = 0;
        pPlayer.blindEffect = 0;
        pPlayer.drownEffect = 0;
        pPlayer.handCount = 0;
        pPlayer.weaponTimer = 0;
        pPlayer.weaponState = 0;
        pPlayer.pWeaponQAV = -1;
        pPlayer.handDamage = false;
        ScreenEffect.resetEffects();
        pPlayer.lookang = 0;
        pPlayer.rotscrnang = 0;
        for (i = 0; i < 49; ++i) {
            pPlayer.powerUpTimer[i] = 0;
        }
        PLAYER.resetPlayerSize(pPlayer);
        if (pPlayer == Globals.gMe) {
            ((BloodNetwork)Main.game.pNet).PredictReset();
        }
        if (Actor.IsUnderwaterSector(pSprite.sectnum)) {
            pPlayer.moveState = 1;
            pPlayer.pXsprite.palette = 1;
        }
    }

    public static void playerSetRace(PLAYER pPlayer, int nLifeMode) {
        if (nLifeMode < 0 || nLifeMode > 3) {
            Main.game.dassert("nLifeMode >= kModeHuman && nLifeMode <= kModeHumanGrown");
        }
        pPlayer.nLifeMode = nLifeMode;
        pPlayer.pDudeInfo.copy(DudeInfo.gPlayerTemplate[nLifeMode]);
        for (int i = 0; i < 7; ++i) {
            pPlayer.pDudeInfo.damageShift[i] = Pragmas.mulscale(pPlayer.pDudeInfo.startDamage[i], Actor.pPlayerShift[Globals.pGameInfo.nDifficulty], 8);
        }
    }

    public static boolean PickupLeech(PLAYER pPlayer, SPRITE pSprite) {
        short nSprite = Engine.headspritestat[4];
        while (nSprite >= 0) {
            if (pSprite == null || pSprite.xvel != nSprite) {
                SPRITE pThing = Engine.sprite[nSprite];
                if (pThing.lotag == 431 && Actor.actGetBurnSource(pThing.owner) == pPlayer.nSprite) {
                    return true;
                }
            }
            nSprite = Engine.nextspritestat[nSprite];
        }
        return false;
    }

    public static int ActionScan(PLAYER pPlayer) {
        SPRITE pSprite = pPlayer.pSprite;
        Action_nIndex = 0;
        Action_nXIndex = 0;
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        int dz = (int)pPlayer.horizOff;
        int hitType = Gameutils.HitScan(pSprite, pPlayer.viewOffZ, dx, dy, dz, Engine.pHitInfo, 0x10000040, 128);
        int hitDist = (int)(Main.engine.qdist(pSprite.x - Engine.pHitInfo.hitx, pSprite.y - Engine.pHitInfo.hity) >> 4);
        if (hitDist < 64) {
            switch (hitType) {
                case 3: {
                    Action_nIndex = Engine.pHitInfo.hitsprite;
                    Action_nXIndex = Engine.sprite[PLAYER.Action_nIndex].extra;
                    if (Action_nXIndex > 0 && Engine.sprite[PLAYER.Action_nIndex].statnum == 4 && Engine.sprite[PLAYER.Action_nIndex].lotag == 431) {
                        if (Globals.pGameInfo.nGameType > 1 && PLAYER.PickupLeech(pPlayer, Engine.sprite[Action_nIndex])) {
                            return -1;
                        }
                        XSPRITE pXThing = DB.xsprite[Action_nXIndex];
                        pXThing.data4 = pPlayer.nPlayer;
                        pXThing.isTriggered = false;
                    }
                    if (Action_nXIndex > 0 && DB.xsprite[PLAYER.Action_nXIndex].Push) {
                        return 3;
                    }
                    if (Engine.sprite[PLAYER.Action_nIndex].statnum != 6) break;
                    if (Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1 && Gameutils.IsPlayerSprite(Engine.sprite[Action_nIndex])) {
                        PLAYER pReviving = Globals.gPlayer[Engine.sprite[PLAYER.Action_nIndex].lotag - 231];
                        if (pReviving.deathTime > 0) {
                            SeqHandling.seqSpawn(pReviving.pDudeInfo.seqStartID + VERSION.getPlayerSeq(9), 3, pReviving.pSprite.extra, SeqHandling.callbacks[1]);
                            break;
                        }
                    }
                    XSPRITE pXDude = DB.xsprite[Action_nXIndex];
                    int mass = DudeInfo.dudeInfo[Engine.sprite[PLAYER.Action_nIndex].lotag - 200].mass;
                    if (mass > 0) {
                        int impulse = 0xCCCCC00 / mass;
                        int n = Action_nIndex;
                        Actor.sprXVel[n] = Actor.sprXVel[n] + (long)Pragmas.mulscale(impulse, dx, 16);
                        int n2 = Action_nIndex;
                        Actor.sprYVel[n2] = Actor.sprYVel[n2] + (long)Pragmas.mulscale(impulse, dy, 16);
                        int n3 = Action_nIndex;
                        Actor.sprZVel[n3] = Actor.sprZVel[n3] + (long)Pragmas.mulscale(impulse, dz, 16);
                    }
                    if (!DB.xsprite[PLAYER.Action_nXIndex].Push || DB.xsprite[PLAYER.Action_nXIndex].state != 0 || DB.xsprite[PLAYER.Action_nXIndex].isTriggered) break;
                    Trigger.trTriggerSprite(Action_nIndex, pXDude, 30);
                    break;
                }
                case 0: 
                case 4: {
                    Action_nIndex = Engine.pHitInfo.hitwall;
                    Action_nXIndex = Engine.wall[PLAYER.Action_nIndex].extra;
                    if (Action_nXIndex > 0 && DB.xwall[PLAYER.Action_nXIndex].triggerPush) {
                        return 0;
                    }
                    if (Engine.wall[PLAYER.Action_nIndex].nextsector < 0) break;
                    Action_nIndex = Engine.wall[PLAYER.Action_nIndex].nextsector;
                    Action_nXIndex = Engine.sector[PLAYER.Action_nIndex].extra;
                    if (Action_nXIndex <= 0 || !DB.xsector[PLAYER.Action_nXIndex].Wallpush) break;
                    return 6;
                }
                case 1: 
                case 2: {
                    Action_nIndex = Engine.pHitInfo.hitsect;
                    Action_nXIndex = Engine.sector[PLAYER.Action_nIndex].extra;
                    if (Action_nXIndex <= 0 || !DB.xsector[PLAYER.Action_nXIndex].Push) break;
                    return 6;
                }
            }
        }
        Action_nIndex = pSprite.sectnum;
        Action_nXIndex = Engine.sector[PLAYER.Action_nIndex].extra;
        if (Action_nXIndex > 0 && DB.xsector[PLAYER.Action_nXIndex].Push) {
            return 6;
        }
        return -1;
    }

    public static void ProcessInput(PLAYER pPlayer) {
        SPRITE pSprite = pPlayer.pSprite;
        POSTURE cp = Globals.gPosture[pPlayer.nLifeMode][pPlayer.moveState];
        int nSprite = pPlayer.nSprite;
        if (pSprite.extra == -1) {
            return;
        }
        XSPRITE pXSprite = pPlayer.pXsprite;
        pPlayer.Run = pPlayer.pInput.Run;
        if (!Globals.gNoClip && !DEMO.IsOriginalDemo()) {
            short nSector = pSprite.sectnum;
            Gameutils.GetSpriteExtents(pSprite);
            int floorDist = (Gameutils.extents_zBot - pSprite.z) / 4;
            int ceilDist = (pSprite.z - Gameutils.extents_zTop) / 4;
            int clipDist = pSprite.clipdist << 2;
            int push = Main.engine.pushmove(pSprite.x, pSprite.y, pSprite.z, nSector, clipDist, ceilDist, floorDist, 65537);
            pSprite.x = Engine.pushmove_x;
            pSprite.y = Engine.pushmove_y;
            pSprite.z = Engine.pushmove_z;
            nSector = Engine.pushmove_sectnum;
            if (push == -1) {
                Actor.actDamageSprite(pPlayer.nSprite, pSprite, 0, 8000);
            }
            if (nSector != pSprite.sectnum) {
                if (nSector == -1) {
                    nSector = pSprite.sectnum;
                    Actor.actDamageSprite(pSprite.xvel, pSprite, 0, 8000);
                }
                if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                    Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                }
                DB.changespritesect((short)pPlayer.nSprite, nSector);
            }
        }
        if (pPlayer.pInput.Forward != 0 || pPlayer.pInput.Turn != 0.0f || pPlayer.pInput.Strafe != 0 || pPlayer.pInput.Jump || pPlayer.pInput.Crouch || pPlayer.pInput.Lookup || pPlayer.pInput.Lookdown || pPlayer.pInput.AltShoot || pPlayer.pInput.Shoot) {
            pPlayer.stayTime = 0;
        } else if (pPlayer.stayTime >= 0) {
            pPlayer.stayTime += Globals.kFrameTicks;
        }
        Weapon.WeaponProcess(pPlayer);
        if (pXSprite.health == 0) {
            boolean noLastLoad = false;
            if (Globals.pGameInfo.nGameType == 0 && Main.game.isCurrentScreen(Main.gGameScreen) && LOADSAVE.lastload != null && !LOADSAVE.lastload.isEmpty() && BuildGdx.compat.checkFile(LOADSAVE.lastload, Compat.Path.User) != null) {
                if (pPlayer.deathTime == 0) {
                    QUOTE quote = View.viewSetMessage(deathMessage, -1, 7);
                    quote.messageTime = 0x780000 + Globals.gFrameClock;
                } else if (View.numQuotes == 0) {
                    QUOTE quote = View.viewSetMessage(deathMessage, -1, 7);
                    quote.messageTime = 0x780000 + Globals.gFrameClock;
                }
                if (pPlayer.pInput.Use) {
                    Main.game.changeScreen(Main.gLoadingScreen.setTitle(LOADSAVE.lastload));
                    Main.gLoadingScreen.init(new Runnable(){

                        @Override
                        public void run() {
                            if (!LOADSAVE.loadgame(LOADSAVE.lastload)) {
                                Main.game.GameMessage("Can't load game!");
                            }
                        }
                    });
                    pPlayer.pInput.Use = false;
                    return;
                }
                if (Engine.getInput().keyPressed(66)) {
                    noLastLoad = true;
                }
            }
            boolean deathType = PLAYER.checkPlayerSeq(pPlayer, VERSION.getPlayerSeq(12));
            if (pPlayer.fraggerID != -1 && pPlayer.fraggerID != pPlayer.nSprite) {
                pSprite.ang = Main.engine.getangle(Engine.sprite[pPlayer.fraggerID].x - pSprite.x, Engine.sprite[pPlayer.fraggerID].y - pSprite.y);
                pPlayer.ang = pSprite.ang;
            }
            pPlayer.deathTime += Globals.kFrameTicks;
            if (!(deathType || Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode)) {
                pPlayer.horiz = Pragmas.mulscale(32768 - (Trig.Cos(Gameutils.ClipHigh(pPlayer.deathTime << 3, 1024)) >> 15), 120L, 16);
            }
            BuildGdx.audio.getSound().setReverb(false, 0.0f);
            pPlayer.LastWeapon = 0;
            pPlayer.CrouchMode = 0;
            if (pPlayer.currentWeapon != 0) {
                pPlayer.pInput.newWeapon = pPlayer.currentWeapon;
            }
            if (pPlayer.pInput.Use || noLastLoad) {
                if (deathType && Globals.pGameInfo.nGameType != 1 && pPlayer.deathTime > 360) {
                    SeqHandling.seqSpawn(pPlayer.pDudeInfo.seqStartID + VERSION.getPlayerSeq(9), 3, pPlayer.pSprite.extra, SeqHandling.callbacks[1]);
                    pPlayer.pInput.Use = false;
                    return;
                }
                if (!Main.game.isCurrentScreen(Main.gDemoScreen) && (SeqHandling.seqFrame(3, pPlayer.pSprite.extra) < 0 || Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode && pPlayer.deathTime > 100)) {
                    SOUND.sfxKillAll3DSounds();
                    if (pPlayer.pSprite != null) {
                        pPlayer.pSprite.lotag = (short)426;
                    }
                    Actor.actPostSprite(pPlayer.nSprite, 4);
                    SeqHandling.seqSpawn(pPlayer.pDudeInfo.seqStartID + VERSION.getPlayerSeq(10), 3, pPlayer.pSprite.extra, null);
                    PLAYER.resetInventory(pPlayer);
                    if (Globals.pGameInfo.nGameType == 0 && Mmulti.numplayers == 1) {
                        pPlayer.pInput.Restart = true;
                        pPlayer.pInput.Use = false;
                        pPlayer.hitEffect = 0;
                        return;
                    }
                    PLAYER.playerReset(pPlayer.nPlayer);
                }
                pPlayer.pInput.Use = false;
            }
            return;
        }
        if (pPlayer.moveState == 1) {
            if (pPlayer.pInput.Forward != 0) {
                int n = nSprite;
                Actor.sprXVel[n] = Actor.sprXVel[n] + (long)Pragmas.mulscale(Trig.Cos(pSprite.ang), pPlayer.pInput.Forward * cp.frontAccel, 30);
                int n2 = nSprite;
                Actor.sprYVel[n2] = Actor.sprYVel[n2] + (long)Pragmas.mulscale(Trig.Sin(pSprite.ang), pPlayer.pInput.Forward * cp.frontAccel, 30);
            }
            if (pPlayer.pInput.Strafe != 0) {
                int n = nSprite;
                Actor.sprXVel[n] = Actor.sprXVel[n] + (long)Pragmas.mulscale(Trig.Sin(pSprite.ang), pPlayer.pInput.Strafe * cp.sideAccel, 30);
                int n3 = nSprite;
                Actor.sprYVel[n3] = Actor.sprYVel[n3] - (long)Pragmas.mulscale(Trig.Cos(pSprite.ang), pPlayer.pInput.Strafe * cp.sideAccel, 30);
            }
        } else if (pXSprite.height < 256) {
            long vel;
            int zvel = 65536;
            if (pXSprite.height != 0) {
                zvel -= (pXSprite.height << 16) / 256;
            }
            if (pPlayer.pInput.Forward != 0) {
                vel = pPlayer.pInput.Forward > 0 ? (long)(pPlayer.pInput.Forward * cp.frontAccel) : (long)(pPlayer.pInput.Forward * cp.backAccel);
                if (pXSprite.height != 0) {
                    vel = Pragmas.mulscale(zvel, vel, 16);
                }
                int n = nSprite;
                Actor.sprXVel[n] = Actor.sprXVel[n] + (long)Pragmas.mulscale(Trig.Cos(pSprite.ang), vel, 30);
                int n4 = nSprite;
                Actor.sprYVel[n4] = Actor.sprYVel[n4] + (long)Pragmas.mulscale(Trig.Sin(pSprite.ang), vel, 30);
            }
            if (pPlayer.pInput.Strafe != 0) {
                vel = pPlayer.pInput.Strafe * cp.sideAccel;
                if (pXSprite.height != 0) {
                    vel = Pragmas.mulscale(zvel, vel, 16);
                }
                int n = nSprite;
                Actor.sprXVel[n] = Actor.sprXVel[n] + (long)Pragmas.mulscale(Trig.Sin(pSprite.ang), vel, 30);
                int n5 = nSprite;
                Actor.sprYVel[n5] = Actor.sprYVel[n5] - (long)Pragmas.mulscale(Trig.Cos(pSprite.ang), vel, 30);
            }
        }
        if (DEMO.IsOriginalDemo()) {
            if (pPlayer.pInput.Turn != 0.0f) {
                pSprite.ang = (short)(pSprite.ang + (Globals.kFrameTicks * (int)pPlayer.pInput.Turn >> 4) & 0x7FF);
                pPlayer.ang = pSprite.ang;
            }
        } else {
            if (pPlayer.pInput.Turn != 0.0f) {
                pPlayer.ang = ru.m210projects.Build.Gameutils.BClampAngle(pPlayer.ang + (float)Globals.kFrameTicks * pPlayer.pInput.Turn / 16.0f);
            }
            pSprite.ang = (short)pPlayer.ang;
        }
        if (pPlayer.pInput.TurnAround) {
            if (pPlayer.TurnAround == 0) {
                pPlayer.TurnAround = -1024;
            }
            pPlayer.pInput.TurnAround = false;
        }
        if (pPlayer.TurnAround < 0) {
            int angSpeed = pPlayer.moveState == 1 ? 64 : 128;
            pPlayer.TurnAround = Gameutils.ClipHigh(pPlayer.TurnAround + angSpeed, 0);
            pPlayer.ang = ru.m210projects.Build.Gameutils.BClampAngle(pPlayer.ang + (float)angSpeed);
            if (DEMO.IsOriginalDemo()) {
                pSprite.ang = (short)pPlayer.ang;
            }
        }
        pPlayer.lookang -= pPlayer.lookang >> 2;
        if (pPlayer.lookang != 0 && pPlayer.lookang >> 2 == 0) {
            pPlayer.lookang -= Pragmas.ksgn(pPlayer.lookang);
        }
        if (pPlayer.pInput.LookLeft) {
            pPlayer.lookang -= 152;
        }
        if (pPlayer.pInput.LookRight) {
            pPlayer.lookang += 152;
        }
        if (!pPlayer.pInput.Jump) {
            pPlayer.pJump = false;
        } else {
            pPlayer.CrouchMode = 0;
        }
        if (pPlayer.pInput.Crouch) {
            pPlayer.CrouchMode = 0;
        }
        if (pPlayer.moveState == 1) {
            pPlayer.CrouchMode = pPlayer.pInput.CrouchMode ? 1 : 0;
        } else if (pPlayer.pInput.CrouchMode) {
            pPlayer.CrouchMode ^= 1;
        }
        if (pPlayer.CrouchMode == 1) {
            pPlayer.pInput.Crouch = true;
        }
        if (pPlayer.pInput.LastWeapon) {
            pPlayer.pInput.newWeapon = pPlayer.LastWeapon;
        }
        switch (pPlayer.moveState) {
            case 0: {
                if (!pPlayer.pJump && pPlayer.pInput.Jump && pXSprite.height == 0) {
                    SOUND.sfxStart3DSound(pPlayer.pSprite, 700, -1, 0);
                    Actor.sprZVel[nSprite] = PLAYER.inventoryCheck(pPlayer, 4) ? -1529173L : -764586L;
                    pPlayer.pJump = true;
                }
                if (!pPlayer.pInput.Crouch) break;
                pPlayer.moveState = 2;
                break;
            }
            case 1: {
                if (pPlayer.pInput.Jump) {
                    int n = nSprite;
                    Actor.sprZVel[n] = Actor.sprZVel[n] - 23301L;
                }
                if (!pPlayer.pInput.Crouch) break;
                int n = nSprite;
                Actor.sprZVel[n] = Actor.sprZVel[n] + 23301L;
                break;
            }
            case 3: {
                if (pPlayer.pInput.Jump) {
                    Actor.sprZVel[nSprite] = -400000L;
                    break;
                }
                if (pPlayer.pInput.Crouch) {
                    Actor.sprZVel[nSprite] = 400000L;
                    break;
                }
                Actor.sprZVel[nSprite] = 0L;
                break;
            }
            case 2: {
                if (pPlayer.pInput.Crouch) break;
                pPlayer.moveState = 0;
            }
        }
        if (pPlayer.pInput.Use) {
            switch (PLAYER.ActionScan(pPlayer)) {
                case 6: {
                    XSECTOR pXSector = DB.xsector[Action_nXIndex];
                    int keyId = pXSector.Key;
                    if (pXSector.locked != 0 && pPlayer == Globals.gMe) {
                        View.viewSetMessage("It's locked", pPlayer.nPlayer, 8);
                        SOUND.sndStartSample(3062, -1, 1, false);
                    }
                    if (keyId == 0 || pPlayer.hasKey[keyId]) {
                        Trigger.trTriggerSector(Action_nIndex, pXSector, 30);
                        break;
                    }
                    if (pPlayer != Globals.gMe) break;
                    View.viewSetMessage("That requires a key.", pPlayer.nPlayer, 8);
                    SOUND.sndStartSample(3063, -1, 1, false);
                    break;
                }
                case 0: {
                    XWALL pXWall = DB.xwall[Action_nXIndex];
                    int keyId = pXWall.key;
                    if (pXWall.locked != 0 && pPlayer == Globals.gMe) {
                        View.viewSetMessage("It's locked", pPlayer.nPlayer, 8);
                        SOUND.sndStartSample(3062, -1, 1, false);
                    }
                    if (keyId == 0 || pPlayer.hasKey[keyId]) {
                        Trigger.trTriggerWall(Action_nIndex, pXWall, 50);
                        break;
                    }
                    if (pPlayer != Globals.gMe) break;
                    View.viewSetMessage("That requires a key.", pPlayer.nPlayer, 8);
                    SOUND.sndStartSample(3063, -1, 1, false);
                    break;
                }
                case 3: {
                    XSPRITE pXSpr = DB.xsprite[Action_nXIndex];
                    int keyId = pXSpr.key;
                    if (pXSpr.Locked != 0 && pPlayer == Globals.gMe && pXSpr.lockMsg != 0) {
                        Trigger.trTextOver(pXSpr.lockMsg);
                    }
                    if (keyId != 0 && !pPlayer.hasKey[keyId]) {
                        if (pPlayer != Globals.gMe) break;
                        View.viewSetMessage("That requires a key.", pPlayer.nPlayer, 8);
                        SOUND.sndStartSample(3063, -1, 1, false);
                        break;
                    }
                    Trigger.trTriggerSprite(Action_nIndex, pXSpr, 30);
                    break;
                }
            }
            if (pPlayer.handCount > 0) {
                pPlayer.handCount = DEMO.IsOriginalDemo() ? Gameutils.ClipLow(pPlayer.handCount - Globals.kFrameTicks * (6 - Globals.pGameInfo.nDifficulty), 0) : Gameutils.ClipLow(pPlayer.handCount - Globals.kFrameTicks * (7 - Globals.pGameInfo.nDifficulty), 0);
            }
            if (pPlayer.handDamage && pPlayer.handCount == 0) {
                SPRITE pHand = Actor.actSpawnDude(pSprite, 212, pSprite.clipdist << 1);
                pHand.ang = (short)(pSprite.ang + 1024 & 0x7FF);
                Actor.sprXVel[pHand.xvel] = Actor.sprXVel[nSprite] + (long)Pragmas.mulscale(Trig.Cos(pSprite.ang) >> 16, 0x155555L, 14);
                Actor.sprYVel[pHand.xvel] = Actor.sprYVel[nSprite] + (long)Pragmas.mulscale(Trig.Sin(pSprite.ang) >> 16, 0x155555L, 14);
                Actor.sprZVel[pHand.xvel] = Actor.sprZVel[nSprite];
                pPlayer.handDamage = false;
            }
            pPlayer.pInput.Use = false;
        }
        pPlayer.look = ru.m210projects.Build.Gameutils.BClipRange(pPlayer.look + pPlayer.pInput.mlook, -60.0f, 60.0f);
        if (pPlayer.pInput.InventoryLeft) {
            PLAYER.InventoryLeft(pPlayer);
            pPlayer.pInput.InventoryLeft = false;
        }
        if (pPlayer.pInput.InventoryRight) {
            PLAYER.InventoryRight(pPlayer);
            pPlayer.pInput.InventoryRight = false;
        }
        if (pPlayer.pInput.InventoryUse) {
            if (pPlayer.choosedInven != -1 && pPlayer.Inventory[pPlayer.choosedInven].amount > 0) {
                PLAYER.processInventory(pPlayer, pPlayer.choosedInven);
            }
            pPlayer.pInput.InventoryUse = false;
        }
        if (pPlayer.pInput.UseBeastVision) {
            if (pPlayer.Inventory[3].amount > 0) {
                PLAYER.processInventory(pPlayer, 3);
            }
            pPlayer.pInput.UseBeastVision = false;
        }
        if (pPlayer.pInput.UseCrystalBall) {
            if (pPlayer.Inventory[2].amount > 0) {
                PLAYER.processInventory(pPlayer, 2);
            }
            pPlayer.pInput.UseCrystalBall = false;
        }
        if (pPlayer.pInput.UseJumpBoots) {
            if (pPlayer.Inventory[4].amount > 0) {
                PLAYER.processInventory(pPlayer, 4);
            }
            pPlayer.pInput.UseJumpBoots = false;
        }
        if (pPlayer.pInput.UseMedKit) {
            if (pPlayer.Inventory[0].amount > 0) {
                PLAYER.processInventory(pPlayer, 0);
            }
            pPlayer.pInput.UseMedKit = false;
        }
        if (pPlayer.pInput.HolsterWeapon) {
            pPlayer.pInput.HolsterWeapon = false;
            if (pPlayer.currentWeapon != 0) {
                pPlayer.LastWeapon = pPlayer.currentWeapon;
                Weapon.WeaponLower(pPlayer);
                View.viewSetMessage("Holstering weapon", pPlayer.nPlayer, 10);
            }
        }
        if (pPlayer.pInput.LookCenter && !pPlayer.pInput.Lookup && !pPlayer.pInput.Lookdown) {
            if (pPlayer.look < 0.0f) {
                pPlayer.look = Gameutils.ClipHigh(pPlayer.look + (float)Globals.kFrameTicks, 0);
            }
            if (pPlayer.look > 0.0f) {
                pPlayer.look = Gameutils.ClipLow(pPlayer.look - (float)Globals.kFrameTicks, 0);
            }
            if (pPlayer.look == 0.0f) {
                pPlayer.pInput.LookCenter = false;
            }
        } else {
            if (pPlayer.pInput.Lookup) {
                pPlayer.look = Gameutils.ClipHigh(pPlayer.look + (float)Globals.kFrameTicks, 60);
            }
            if (pPlayer.pInput.Lookdown) {
                pPlayer.look = Gameutils.ClipLow(pPlayer.look - (float)Globals.kFrameTicks, -60);
            }
        }
        pPlayer.horiz = DEMO.IsOriginalDemo() ? (pPlayer.look > 0.0f ? (float)Pragmas.mulscale(120L, Trig.Sin((int)(pPlayer.look * 8.0f)), 30) : (pPlayer.look < 0.0f ? (float)Pragmas.mulscale(180L, Trig.Sin((int)(pPlayer.look * 8.0f)), 30) : 0.0f)) : (pPlayer.look > 0.0f ? (float)(ru.m210projects.Build.Gameutils.BSinAngle(pPlayer.look * 8.0f) * 120.0 / 16384.0) : (pPlayer.look < 0.0f ? (float)(ru.m210projects.Build.Gameutils.BSinAngle(pPlayer.look * 8.0f) * 180.0 / 16384.0) : 0.0f));
        int floorhit = Actor.gSpriteHit[pSprite.extra].floorHit & 0xE000;
        if (pXSprite.height < 16 && (floorhit == 16384 || floorhit == 0) && (Engine.sector[pSprite.sectnum].floorstat & 2) != 0) {
            int dy;
            int oldslope = Main.engine.getflorzofslope(pSprite.sectnum, pSprite.x, pSprite.y);
            int dx = Pragmas.mulscale(64L, Trig.Cos(pSprite.ang), 30) + pSprite.x;
            short nSector = Main.engine.updatesector(dx, dy = Pragmas.mulscale(64L, Trig.Sin(pSprite.ang), 30) + pSprite.y, pSprite.sectnum);
            if (nSector == pSprite.sectnum) {
                int newslope = Main.engine.getflorzofslope(nSector, dx, dy);
                int slope = (oldslope - newslope >> 3) - pPlayer.slope << 14;
                pPlayer.slope += slope >> 16;
            }
        } else {
            int slope = pPlayer.slope;
            int newslope = -slope << 14;
            pPlayer.slope = newslope = slope + (newslope >> 16);
            if (newslope < 0) {
                newslope = -(slope + (-slope << 14 >> 16));
            }
            if (newslope < 4) {
                pPlayer.slope = 0;
            }
        }
        pPlayer.horizOff = -128.0f * pPlayer.horiz;
        PLAYER.PickUp(pPlayer);
    }

    public static int CheckTouchSprite(SPRITE pSprite) {
        short i = Engine.headspritestat[3];
        while (i >= 0) {
            int dy;
            int dx;
            short next = Engine.nextspritestat[i];
            if ((Engine.sprite[i].hitag & 0x20) == 0 && (dx = Pragmas.klabs(pSprite.x - Engine.sprite[i].x) >> 4) < 48 && (dy = Pragmas.klabs(pSprite.y - Engine.sprite[i].y) >> 4) < 48) {
                Gameutils.GetSpriteExtents(pSprite);
                int dz = 0;
                if (Engine.sprite[i].z < Gameutils.extents_zTop) {
                    dz = Gameutils.extents_zTop - Engine.sprite[i].z >> 8;
                } else if (Engine.sprite[i].z > Gameutils.extents_zBot) {
                    dz = Engine.sprite[i].z - Gameutils.extents_zBot >> 8;
                }
                if (dz < 32 && Main.engine.qdist(dx, dy) < 48L) {
                    Gameutils.GetSpriteExtents(Engine.sprite[i]);
                    if (Main.engine.cansee(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, Engine.sprite[i].x, Engine.sprite[i].y, Engine.sprite[i].z, Engine.sprite[i].sectnum) || Main.engine.cansee(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, Engine.sprite[i].x, Engine.sprite[i].y, Gameutils.extents_zTop, Engine.sprite[i].sectnum) || Main.engine.cansee(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, Engine.sprite[i].x, Engine.sprite[i].y, Gameutils.extents_zBot, Engine.sprite[i].sectnum)) {
                        return i;
                    }
                }
            }
            i = next;
        }
        return -1;
    }

    public static void PickUp(PLAYER pPlayer) {
        SPRITE pSprite = pPlayer.pSprite;
        String buffer = "";
        short i = Engine.headspritestat[3];
        while (i >= 0) {
            int dy;
            int dx;
            short next = Engine.nextspritestat[i];
            if ((Engine.sprite[i].hitag & 0x20) == 0 && (dx = Pragmas.klabs(pSprite.x - Engine.sprite[i].x) >> 4) <= 48 && (dy = Pragmas.klabs(pSprite.y - Engine.sprite[i].y) >> 4) <= 48) {
                Gameutils.GetSpriteExtents(pSprite);
                int dz = 0;
                if (Engine.sprite[i].z < Gameutils.extents_zTop) {
                    dz = Gameutils.extents_zTop - Engine.sprite[i].z >> 8;
                } else if (Engine.sprite[i].z > Gameutils.extents_zBot) {
                    dz = Engine.sprite[i].z - Gameutils.extents_zBot >> 8;
                }
                if (dz < 32 && Main.engine.qdist(dx, dy) <= 48L) {
                    Gameutils.GetSpriteExtents(Engine.sprite[i]);
                    if (Main.engine.cansee(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, Engine.sprite[i].x, Engine.sprite[i].y, Engine.sprite[i].z, Engine.sprite[i].sectnum) || Main.engine.cansee(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, Engine.sprite[i].x, Engine.sprite[i].y, Gameutils.extents_zTop, Engine.sprite[i].sectnum) || Main.engine.cansee(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, Engine.sprite[i].x, Engine.sprite[i].y, Gameutils.extents_zBot, Engine.sprite[i].sectnum)) {
                        boolean bPickedUp = false;
                        int customMsg = -1;
                        short nType = Engine.sprite[i].lotag;
                        if (nType != 80 && nType != 40) {
                            XSPRITE pXSprite;
                            XSPRITE xSPRITE = pXSprite = Engine.sprite[i].extra >= 0 ? DB.xsprite[Engine.sprite[i].extra] : null;
                            if (pXSprite != null && pXSprite.txID != 3 && pXSprite.lockMsg > 0) {
                                customMsg = pXSprite.lockMsg;
                            }
                            if (nType >= 100 && nType <= 149) {
                                bPickedUp = PLAYER.PickupItem(pPlayer, i, nType);
                                if (bPickedUp && customMsg == -1) {
                                    buffer = "Picked up " + DB.gItemText[nType - 100];
                                }
                            } else if (nType >= 60 && nType < 81) {
                                bPickedUp = PLAYER.PickupAmmo(pPlayer, i, nType);
                                if (bPickedUp && customMsg == -1) {
                                    buffer = "Picked up " + DB.gAmmoText[nType - 60];
                                }
                            } else if (nType >= 40 && nType < 51 && (bPickedUp = PLAYER.PickupWeapon(pPlayer, i, nType)) && customMsg == -1) {
                                buffer = "Picked up " + DB.gWeaponText[nType - 40];
                            }
                        }
                        if (bPickedUp) {
                            if (Engine.sprite[i].extra > 0) {
                                XSPRITE pXItem = DB.xsprite[Engine.sprite[i].extra];
                                if (pXItem.Pickup) {
                                    Trigger.trTriggerSprite(i, pXItem, 32);
                                }
                            }
                            if (!Actor.actCheckRespawn(Engine.sprite[i])) {
                                Actor.actPostSprite(i, 1024);
                            }
                            pPlayer.pickupEffect = 30;
                            if (pPlayer == Globals.gMe) {
                                if (customMsg > 0) {
                                    Trigger.trTextOver(customMsg - 1);
                                } else {
                                    View.viewSetMessage(buffer, pPlayer.nPlayer);
                                }
                            }
                        }
                    }
                }
            }
            i = next;
        }
    }

    public static void PlayerWaterBubblesCallback(int nSprite) {
        SPRITE pSprite = Engine.sprite[nSprite];
        if (Gameutils.IsPlayerSprite(pSprite)) {
            PLAYER pPlayer = Globals.gPlayer[pSprite.lotag - 231];
            if (pPlayer == null) {
                Main.game.dassert("pPlayer != NULL");
            }
            if (pPlayer.bubbleTime != 0) {
                Gameutils.GetSpriteExtents(pSprite);
                for (int i = 0; i < pPlayer.bubbleTime >> 6; ++i) {
                    BloodTile pic = Main.engine.getTile(pSprite.picnum);
                    int radius = pSprite.xrepeat * (pic.getWidth() / 2) >> 2;
                    int nAngle = Gameutils.Random(2048);
                    int dx = pSprite.x + Pragmas.mulscale(Trig.Cos(nAngle), radius, 30);
                    int dy = pSprite.y + Pragmas.mulscale(Trig.Sin(nAngle), radius, 30);
                    int range = Gameutils.extents_zBot - Gameutils.Random(Gameutils.extents_zBot - Gameutils.extents_zTop);
                    SPRITE pEffect = Actor.actSpawnEffect(Gameutils.Random(3) + 23, pSprite.sectnum, dx, dy, range, 0);
                    if (pEffect == null) continue;
                    Actor.sprXVel[pEffect.xvel] = (long)Gameutils.BiRandom(109226) + Actor.sprXVel[nSprite];
                    Actor.sprYVel[pEffect.xvel] = (long)Gameutils.BiRandom(109226) + Actor.sprYVel[nSprite];
                    Actor.sprZVel[pEffect.xvel] = (long)Gameutils.BiRandom(109226) + Actor.sprZVel[nSprite];
                }
                EVENT.evPostCallback(nSprite, 3, 4L, 10);
            }
        }
    }

    public static boolean PickupItem(PLAYER pPlayer, int nSprite, int nItemType) {
        int soundId = 775;
        SPRITE pSprite = pPlayer.pSprite;
        XSPRITE pXSprite = pPlayer.pXsprite;
        int nPowerUp = nItemType - 100;
        switch (nItemType) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                if (pPlayer.hasKey[nItemType - 100 + 1]) {
                    return false;
                }
                pPlayer.hasKey[nItemType - 100 + 1] = true;
                soundId = 781;
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                int addPower = Actor.gPowerUpInfo[nPowerUp].addPower;
                if (Engine.sprite[nSprite].extra >= 0 && DB.xsprite[Engine.sprite[nSprite].extra].data1 > 0 && !DEMO.IsOriginalDemo()) {
                    addPower = DB.xsprite[Engine.sprite[nSprite].extra].data1;
                }
                return Actor.actHealDude(pXSprite, addPower, Actor.gPowerUpInfo[nPowerUp].maxPower);
            }
            case 121: {
                if (Globals.pGameInfo.nGameType != 0 && PLAYER.PickupInventryItem(pPlayer, Actor.gItemInfo[nPowerUp].nInventory)) break;
                return false;
            }
            case 107: 
            case 115: 
            case 118: 
            case 125: {
                if (PLAYER.PickupInventryItem(pPlayer, Actor.gItemInfo[nPowerUp].nInventory)) break;
                return false;
            }
            case 117: {
                if (PLAYER.powerupActivate(pPlayer, nPowerUp)) break;
                return false;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                boolean ret = false;
                ARMORITEMDATA pArmorData = Actor.gArmorItemData[nItemType - 140];
                if (pPlayer.ArmorAmount[0] < pArmorData.max[0]) {
                    pPlayer.ArmorAmount[0] = Gameutils.ClipHigh(pPlayer.ArmorAmount[0] + pArmorData.count[0], pArmorData.max[0]);
                    ret = true;
                }
                if (pPlayer.ArmorAmount[1] < pArmorData.max[1]) {
                    pPlayer.ArmorAmount[1] = Gameutils.ClipHigh(pPlayer.ArmorAmount[1] + pArmorData.count[1], pArmorData.max[1]);
                    ret = true;
                }
                if (pPlayer.ArmorAmount[2] < pArmorData.max[2]) {
                    pPlayer.ArmorAmount[2] = Gameutils.ClipHigh(pPlayer.ArmorAmount[2] + pArmorData.count[2], pArmorData.max[2]);
                    ret = true;
                }
                if (ret) {
                    SOUND.sfxCreate3DSound(pSprite.x, pSprite.y, pSprite.z, 779, pSprite.sectnum);
                }
                return ret;
            }
            case 145: 
            case 146: {
                if (Globals.pGameInfo.nGameType != 3) {
                    return false;
                }
                if (Engine.sprite[nSprite].extra > 0) {
                    XSPRITE pXBase = DB.xsprite[Engine.sprite[nSprite].extra];
                    if (nItemType == 145) {
                        if (pPlayer.teamID == 1) {
                            if ((pPlayer.hasFlag & 1) == 0 && pXBase.state != 0) {
                                pPlayer.hasFlag |= 1;
                                pPlayer.nBlueTeam = Engine.sprite[nSprite].xvel;
                                Trigger.trTriggerSprite(pSprite.xvel, pXBase, 0);
                                SOUND.sndStartSample(8007, 255, 2, false);
                                View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " stole Blue Flag", -1, 10);
                            }
                        } else {
                            if ((pPlayer.hasFlag & 1) != 0 && pXBase.state == 0) {
                                pPlayer.nBlueTeam = (short)-1;
                                pPlayer.hasFlag &= 0xFFFFFFFE;
                                Trigger.trTriggerSprite(pSprite.xvel, pXBase, 1);
                                SOUND.sndStartSample(8003, 255, 2, false);
                                View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " returned Blue Flag", -1, 10);
                            }
                            if ((pPlayer.hasFlag & 2) != 0 && pXBase.state != 0) {
                                pPlayer.nRedTeam = (short)-1;
                                pPlayer.hasFlag &= 0xFFFFFFFD;
                                int n = pPlayer.teamID;
                                Globals.nTeamCount[n] = Globals.nTeamCount[n] + 10;
                                int n2 = pPlayer.teamID;
                                Globals.nTeamClock[n2] = Globals.nTeamClock[n2] + 240;
                                PLAYER.checkFragLimit();
                                EVENT.evSend(0, 0, 81, 1);
                                SOUND.sndStartSample(8001, 255, 2, false);
                                View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " captured Red Flag!", -1, 7);
                            }
                        }
                    } else if (pPlayer.teamID == 0) {
                        if ((pPlayer.hasFlag & 2) == 0 && pXBase.state != 0) {
                            pPlayer.hasFlag |= 2;
                            pPlayer.nRedTeam = Engine.sprite[nSprite].xvel;
                            Trigger.trTriggerSprite(pSprite.xvel, pXBase, 0);
                            SOUND.sndStartSample(8006, 255, 2, false);
                            View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " stole Red Flag", -1, 7);
                        }
                    } else {
                        if ((pPlayer.hasFlag & 2) != 0 && pXBase.state == 0) {
                            pPlayer.nRedTeam = (short)-1;
                            pPlayer.hasFlag &= 0xFFFFFFFD;
                            Trigger.trTriggerSprite(pSprite.xvel, pXBase, 1);
                            SOUND.sndStartSample(8002, 255, 2, false);
                            View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " returned Red Flag", -1, 7);
                        }
                        if ((pPlayer.hasFlag & 1) != 0 && pXBase.state != 0) {
                            pPlayer.nBlueTeam = (short)-1;
                            pPlayer.hasFlag &= 0xFFFFFFFE;
                            int n = pPlayer.teamID;
                            Globals.nTeamCount[n] = Globals.nTeamCount[n] + 10;
                            int n3 = pPlayer.teamID;
                            Globals.nTeamClock[n3] = Globals.nTeamClock[n3] + 240;
                            PLAYER.checkFragLimit();
                            EVENT.evSend(0, 0, 80, 1);
                            SOUND.sndStartSample(8000, 255, 2, false);
                            View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " captured Blue Flag!", -1, 10);
                        }
                    }
                    return false;
                }
                return false;
            }
            case 147: {
                if (Globals.pGameInfo.nGameType != 3) {
                    return false;
                }
                pPlayer.hasFlag |= 1;
                pPlayer.nBlueTeam = Engine.sprite[nSprite].owner;
                EVENT.checkEventList(pSprite.xvel, 3, 17);
                break;
            }
            case 148: {
                if (Globals.pGameInfo.nGameType != 3) {
                    return false;
                }
                pPlayer.hasFlag |= 2;
                pPlayer.nRedTeam = Engine.sprite[nSprite].owner;
                EVENT.checkEventList(pSprite.xvel, 3, 17);
                break;
            }
            default: {
                if (PLAYER.powerupActivate(pPlayer, nPowerUp)) break;
                return false;
            }
        }
        if (nItemType != 117) {
            SOUND.sfxCreate3DSound(pSprite.x, pSprite.y, pSprite.z, soundId, pSprite.sectnum);
        }
        return true;
    }

    public static void DeliriumProcess() {
        int nDelirium = PLAYER.powerupCheck(Globals.gPlayer[View.gViewIndex], 28);
        if (nDelirium != 0) {
            timer += Globals.kFrameTicks;
            int maxTilt = 170;
            int maxTurn = 170;
            int maxPitch = 20;
            if (nDelirium < 512) {
                int scale = (nDelirium << 16) / 512;
                maxTilt = Pragmas.mulscale(maxTilt, scale, 16);
                maxTurn = Pragmas.mulscale(maxTurn, scale, 16);
                maxPitch = Pragmas.mulscale(maxPitch, scale, 16);
            }
            View.deliriumTilt = Pragmas.mulscale(Trig.Sin(timer * 2) / 2 + Trig.Sin(timer * 3) / 2, maxTilt, 30);
            View.deliriumTurn = Pragmas.mulscale(Trig.Sin(timer * 3) / 2 + Trig.Sin(timer * 4) / 2, maxTurn, 30);
            View.deliriumPitch = Pragmas.mulscale(Trig.Sin(timer * 4) / 2 + Trig.Sin(timer * 5) / 2, maxPitch, 30);
        } else {
            View.deliriumTilt = 0;
            View.deliriumTurn = 0;
            View.deliriumPitch = 0;
        }
    }

    public static boolean shrinkPlayerSize(PLAYER pPlayer, int divider) {
        pPlayer.pXsprite.data1 = (short)(-divider);
        PLAYER.playerSetRace(pPlayer, 2);
        return true;
    }

    public static boolean growPlayerSize(PLAYER pPlayer, int multiplier) {
        pPlayer.pXsprite.data1 = (short)multiplier;
        PLAYER.playerSetRace(pPlayer, 3);
        return true;
    }

    public static boolean resetPlayerSize(PLAYER pPlayer) {
        PLAYER.playerSetRace(pPlayer, 0);
        pPlayer.pXsprite.data1 = 0;
        return true;
    }

    public static boolean powerupActivate(PLAYER pPlayer, int nPowerUp) {
        if (PLAYER.powerupCheck(pPlayer, nPowerUp) > 0 && Actor.gPowerUpInfo[nPowerUp].isUnique) {
            return false;
        }
        int nInventory = PLAYER.getInventoryNum(nPowerUp + 100);
        if (nInventory >= 0) {
            pPlayer.Inventory[nInventory].activated = true;
        }
        if (!DEMO.IsOriginalDemo() && nInventory == -1 || pPlayer.powerUpTimer[nPowerUp] == 0) {
            pPlayer.powerUpTimer[nPowerUp] = Actor.gPowerUpInfo[nPowerUp].addPower;
        }
        switch (nPowerUp + 100) {
            case 117: {
                if (!DEMO.IsOriginalDemo() && pPlayer.currentWeapon != 2 && pPlayer.currentWeapon != 3 && pPlayer.currentWeapon != 4 && pPlayer.currentWeapon != 5 && pPlayer.currentWeapon != 8) break;
                pPlayer.pInput.newWeapon = pPlayer.currentWeapon;
                Weapon.WeaponRaise(pPlayer);
                break;
            }
            case 118: {
                if (!pPlayer.godMode) {
                    pPlayer.damageShift[4] = pPlayer.damageShift[4] + 1;
                }
                if (pPlayer != Globals.gMe) break;
                BuildGdx.audio.getSound().setReverb(true, 0.2f);
                break;
            }
            case 119: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[4] = pPlayer.damageShift[4] + 1;
                break;
            }
            case 124: {
                if (pPlayer != Globals.gMe) break;
                BuildGdx.audio.getSound().setReverb(true, 0.4f);
                break;
            }
            case 139: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[1] = pPlayer.damageShift[1] + 1;
                break;
            }
            case 114: {
                if (pPlayer.godMode) break;
                int i = 0;
                while (i < 7) {
                    int n = i++;
                    pPlayer.damageShift[n] = pPlayer.damageShift[n] + 1;
                }
                break;
            }
            case 112: 
            case 115: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[0] = pPlayer.damageShift[0] + 1;
                break;
            }
            case 149: {
                pPlayer.moveState = 3;
                pPlayer.pSprite.hitag = (short)(pPlayer.pSprite.hitag & 0xFFFFFFFD);
                break;
            }
        }
        SOUND.sfxStart3DSound(pPlayer.pSprite, 776, -1, 0);
        return true;
    }

    public static void powerupDeactivate(PLAYER pPlayer, int nPowerUp) {
        int nInventory = PLAYER.getInventoryNum(nPowerUp + 100);
        if (nInventory >= 0) {
            pPlayer.Inventory[nInventory].activated = false;
        }
        switch (nPowerUp + 100) {
            case 117: {
                if (!DEMO.IsOriginalDemo() && pPlayer.currentWeapon != 2 && pPlayer.currentWeapon != 3 && pPlayer.currentWeapon != 4 && pPlayer.currentWeapon != 5 && pPlayer.currentWeapon != 8) break;
                pPlayer.pInput.newWeapon = pPlayer.currentWeapon;
                Weapon.WeaponRaise(pPlayer);
                break;
            }
            case 118: {
                if (!pPlayer.godMode) {
                    pPlayer.damageShift[4] = pPlayer.damageShift[4] - 1;
                }
                if (pPlayer != Globals.gMe) break;
                BuildGdx.audio.getSound().setReverb(false, 0.0f);
                break;
            }
            case 119: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[4] = pPlayer.damageShift[4] - 1;
                break;
            }
            case 124: {
                if (pPlayer != Globals.gMe) break;
                BuildGdx.audio.getSound().setReverb(false, 0.0f);
                break;
            }
            case 139: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[1] = pPlayer.damageShift[1] - 1;
                break;
            }
            case 114: {
                if (pPlayer.godMode) break;
                int i = 0;
                while (i < 7) {
                    int n = i++;
                    pPlayer.damageShift[n] = pPlayer.damageShift[n] - 1;
                }
                break;
            }
            case 112: 
            case 115: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[0] = pPlayer.damageShift[0] - 1;
                break;
            }
            case 149: {
                pPlayer.moveState = 0;
                pPlayer.pSprite.hitag = (short)(pPlayer.pSprite.hitag | 2);
                Actor.sprZVel[pPlayer.pSprite.xvel] = 58254L;
            }
        }
    }

    public static void powerupProcess(PLAYER pPlayer) {
        pPlayer.showInventory = Gameutils.ClipLow(pPlayer.showInventory - Globals.kFrameTicks, 0);
        for (int i = 48; i >= 0; --i) {
            int nInventory = PLAYER.getInventoryNum(i + 100);
            if (nInventory < 0) {
                if (pPlayer.powerUpTimer[i] <= 0) continue;
                pPlayer.powerUpTimer[i] = Gameutils.ClipLow(pPlayer.powerUpTimer[i] - Globals.kFrameTicks, 0);
                if (pPlayer.powerUpTimer[i] != 0) continue;
                PLAYER.powerupDeactivate(pPlayer, i);
                continue;
            }
            if (!pPlayer.Inventory[nInventory].activated) continue;
            pPlayer.powerUpTimer[i] = Gameutils.ClipLow(pPlayer.powerUpTimer[i] - Globals.kFrameTicks, 0);
            if (i == 47) continue;
            if (pPlayer.powerUpTimer[i] > 0) {
                pPlayer.Inventory[nInventory].amount = 100 * pPlayer.powerUpTimer[i] / Actor.gPowerUpInfo[i].addPower;
                continue;
            }
            PLAYER.powerupDeactivate(pPlayer, i);
            if (nInventory != pPlayer.choosedInven) continue;
            pPlayer.choosedInven = 0;
        }
        PLAYER.DeliriumProcess();
    }

    public static void powerupClear(PLAYER pPlayer) {
        for (int i = 0; i < 49; ++i) {
            pPlayer.powerUpTimer[i] = 0;
        }
    }

    public static boolean PickupInventryItem(PLAYER pPlayer, int nInventory) {
        if (nInventory >= 6) {
            System.err.println("Unhandled pack item " + nInventory);
            System.exit(1);
        }
        if (pPlayer.Inventory[nInventory].amount >= 100) {
            return false;
        }
        pPlayer.Inventory[nInventory].amount = 100;
        int type = -1;
        switch (nInventory) {
            case 1: {
                type = 118;
                break;
            }
            case 2: {
                type = 121;
                break;
            }
            case 3: {
                type = 125;
                break;
            }
            case 4: {
                type = 115;
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                type = 149;
                break;
            }
            default: {
                System.err.println("Unhandled pack item " + nInventory);
                System.exit(1);
            }
        }
        if ((type -= 100) == 17) {
            PLAYER.powerupActivate(pPlayer, type);
        }
        if (type >= 0) {
            pPlayer.powerUpTimer[type] = Actor.gPowerUpInfo[type].addPower;
        }
        if (pPlayer.choosedInven == -1) {
            pPlayer.choosedInven = nInventory;
        }
        if (pPlayer.Inventory[pPlayer.choosedInven].amount == 0) {
            pPlayer.choosedInven = nInventory;
        }
        return true;
    }

    public static int powerupCheck(PLAYER pPlayer, int nPowerUp) {
        int nInventory;
        if (pPlayer == null) {
            Main.game.dassert("pPlayer != null");
        }
        if (nPowerUp < 0 || nPowerUp >= 49) {
            Main.game.dassert("nPowerUp >= 0 && nPowerUp < kMaxPowerUps");
        }
        if ((nInventory = PLAYER.getInventoryNum(nPowerUp + 100)) < 0 || PLAYER.inventoryCheck(pPlayer, nInventory)) {
            return pPlayer.powerUpTimer[nPowerUp];
        }
        return 0;
    }

    public static void processInventory(PLAYER pPlayer, int nInventory) {
        int nPowerUp = -1;
        boolean activated = false;
        if (pPlayer.Inventory[nInventory].amount > 0) {
            switch (nInventory) {
                case 0: {
                    int healValue;
                    XSPRITE pXDude = pPlayer.pXsprite;
                    int health = pXDude.health >> 4;
                    if (health >= 100) break;
                    if (100 - health >= pPlayer.Inventory[0].amount) {
                        healValue = pPlayer.Inventory[0].amount;
                        Actor.actHealDude(pXDude, healValue, 100);
                    } else {
                        healValue = 100 - health;
                        Actor.actHealDude(pXDude, 100 - health, 100);
                    }
                    pPlayer.Inventory[0].amount -= healValue;
                    break;
                }
                case 1: {
                    nPowerUp = 118;
                    activated = true;
                    break;
                }
                case 2: {
                    nPowerUp = 121;
                    activated = true;
                    break;
                }
                case 3: {
                    nPowerUp = 125;
                    activated = true;
                    break;
                }
                case 4: {
                    nPowerUp = 115;
                    activated = true;
                    break;
                }
                case 5: {
                    nPowerUp = 149;
                    activated = true;
                    break;
                }
                default: {
                    System.err.println("Unhandled pack item " + nInventory);
                    System.exit(1);
                }
            }
        }
        nPowerUp -= 100;
        pPlayer.showInventory = 0;
        if (activated) {
            if (pPlayer.Inventory[nInventory].activated) {
                PLAYER.powerupDeactivate(pPlayer, nPowerUp);
            } else {
                PLAYER.powerupActivate(pPlayer, nPowerUp);
            }
        }
    }

    public static int getInventoryNum(int item) {
        switch (item) {
            case 118: {
                return 1;
            }
            case 121: {
                return 2;
            }
            case 125: {
                return 3;
            }
            case 115: {
                return 4;
            }
            case 149: {
                return 5;
            }
        }
        return -1;
    }

    public static boolean inventoryCheck(PLAYER pPlayer, int nInventory) {
        return pPlayer.Inventory[nInventory].activated;
    }

    public static int getInventoryAmount(PLAYER pPlayer, int nInventory) {
        return pPlayer.Inventory[nInventory].amount;
    }

    public static void InventoryRight(PLAYER pPlayer) {
        if (pPlayer.showInventory > 0) {
            int nextInv = pPlayer.choosedInven + 1;
            int i = 0;
            while (i < 6) {
                if (nextInv == 6) {
                    nextInv = 0;
                }
                if (pPlayer.Inventory[nextInv].amount != 0) {
                    pPlayer.choosedInven = nextInv;
                    break;
                }
                ++i;
                ++nextInv;
            }
        }
        pPlayer.showInventory = 600;
    }

    public static void InventoryLeft(PLAYER pPlayer) {
        if (pPlayer.showInventory > 0) {
            int prevInv = pPlayer.choosedInven - 1;
            int i = 6;
            while (i >= 0) {
                if (prevInv <= -1) {
                    prevInv = 5;
                }
                if (pPlayer.Inventory[prevInv].amount != 0) {
                    pPlayer.choosedInven = prevInv;
                    break;
                }
                --i;
                --prevInv;
            }
        }
        pPlayer.showInventory = 600;
    }

    public static boolean PickupAmmo(PLAYER pPlayer, int nSprite, int nAmmoItemType) {
        AMMOITEMDATA pAmmoData = Actor.gAmmoItemData[nAmmoItemType - 60];
        SPRITE pSprite = Engine.sprite[nSprite];
        int nAmmoType = pAmmoData.ammoType;
        if (nAmmoType == 255) {
            return true;
        }
        if (pPlayer.ammoCount[nAmmoType] >= PLAYER.gAmmoInfo[nAmmoType].max && !Globals.gInfiniteAmmo) {
            return false;
        }
        pPlayer.ammoCount[nAmmoType] = pSprite.extra < 0 || DB.xsprite[pSprite.extra].data1 <= 0 ? Gameutils.ClipHigh(pPlayer.ammoCount[nAmmoType] + pAmmoData.count, PLAYER.gAmmoInfo[nAmmoType].max) : Gameutils.ClipHigh(pPlayer.ammoCount[nAmmoType] + DB.xsprite[pSprite.extra].data1, PLAYER.gAmmoInfo[nAmmoType].max);
        if (pAmmoData.weaponType != 0) {
            pPlayer.hasWeapon[pAmmoData.weaponType] = true;
        }
        SOUND.sfxStart3DSound(pPlayer.pSprite, 782, -1, 0);
        return true;
    }

    public static boolean PickupWeapon(PLAYER pPlayer, int nSprite, int nWeaponItem) {
        WEAPONITEMDATA pWeaponData = Actor.gWeaponItemData[nWeaponItem - 40];
        int nWeapon = pWeaponData.weaponType;
        int nAmmo = pWeaponData.ammoType;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (pPlayer.hasWeapon[nWeapon] && Globals.pGameInfo.nWeaponSettings != 2 && Globals.pGameInfo.nWeaponSettings != 3) {
            if (Actor.actGetRespawnTime(Engine.sprite[nSprite]) != 0) {
                if (nAmmo == -1 || !Globals.gInfiniteAmmo && pPlayer.ammoCount[nAmmo] >= PLAYER.gAmmoInfo[nAmmo].max) {
                    return false;
                }
                pPlayer.ammoCount[nAmmo] = pSprite.extra < 0 || DB.xsprite[pSprite.extra].data1 <= 0 ? Gameutils.ClipHigh(pPlayer.ammoCount[nAmmo] + pWeaponData.count, PLAYER.gAmmoInfo[nAmmo].max) : Gameutils.ClipHigh(pPlayer.ammoCount[nAmmo] + DB.xsprite[pSprite.extra].data1, PLAYER.gAmmoInfo[nAmmo].max);
                SOUND.sfxStart3DSound(pPlayer.pSprite, 777, -1, 0);
                return true;
            }
            return false;
        }
        if (Engine.sprite[nSprite].lotag != 50 || Globals.pGameInfo.nGameType <= 1 || !PLAYER.PickupLeech(pPlayer, null)) {
            int weap;
            pPlayer.hasWeapon[nWeapon] = true;
            if (nAmmo != -1) {
                pPlayer.ammoCount[nAmmo] = pSprite.extra < 0 || DB.xsprite[pSprite.extra].data1 <= 0 ? Gameutils.ClipHigh(pPlayer.ammoCount[nAmmo] + pWeaponData.count, PLAYER.gAmmoInfo[nAmmo].max) : Gameutils.ClipHigh(pPlayer.ammoCount[nAmmo] + DB.xsprite[pSprite.extra].data1, PLAYER.gAmmoInfo[nAmmo].max);
            }
            if ((weap = Weapon.WeaponUpgrade(pPlayer, nWeapon)) != pPlayer.currentWeapon) {
                pPlayer.weaponState = 0;
                pPlayer.updateWeapon = weap;
            }
            SOUND.sfxStart3DSound(pPlayer.pSprite, 777, -1, 0);
            return true;
        }
        return false;
    }

    public static void HandEffectProcess(PLAYER gPlayer) {
        if (gPlayer.pSprite.statnum == 6 && gPlayer.handDamage && Pragmas.mulscale(4L, Gameutils.vRandom(), 15) != 0) {
            gPlayer.handCount = Gameutils.ClipHigh(gPlayer.handCount + Globals.kFrameTicks, 64);
            gPlayer.blindEffect = Gameutils.ClipHigh(gPlayer.blindEffect + 2 * Globals.kFrameTicks, 128);
        }
    }

    public static void playerMove(PLAYER pPlayer) {
        int nSprite = pPlayer.nSprite;
        SPRITE pSprite = pPlayer.pSprite;
        XSPRITE pXSprite = pPlayer.pXsprite;
        POSTURE cp = Globals.gPosture[pPlayer.nLifeMode][pPlayer.moveState];
        PLAYER.powerupProcess(pPlayer);
        PLAYER.HandEffectProcess(pPlayer);
        Gameutils.GetSpriteExtents(pSprite);
        int clipDist = pSprite.clipdist << 2;
        int floorDist = (Gameutils.extents_zBot - pSprite.z) / 4;
        int ceilDist = (pSprite.z - Gameutils.extents_zTop) / 4;
        if (!Globals.gNoClip) {
            short nSector = pSprite.sectnum;
            int push = Main.engine.pushmove(pSprite.x, pSprite.y, pSprite.z, nSector, clipDist, ceilDist, floorDist, 65537);
            pSprite.x = Engine.pushmove_x;
            pSprite.y = Engine.pushmove_y;
            pSprite.z = Engine.pushmove_z;
            nSector = Engine.pushmove_sectnum;
            if (push == -1) {
                Actor.actDamageSprite(nSprite, pSprite, 0, 8000);
            }
            if (nSector != pSprite.sectnum) {
                if (nSector == -1) {
                    nSector = pSprite.sectnum;
                    Actor.actDamageSprite(pSprite.xvel, pSprite, 0, 8000);
                }
                if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                    Main.game.dassert("nSector >= 0 && nSector < kMaxSectors");
                }
                DB.changespritesect((short)nSprite, nSector);
            }
        }
        PLAYER.ProcessInput(pPlayer);
        int moveDist = (int)(Main.engine.qdist(Actor.sprXVel[nSprite], Actor.sprYVel[nSprite]) >> 16);
        pPlayer.viewOffdZ += Pragmas.mulscale(28672L, Actor.sprZVel[nSprite] - (long)pPlayer.viewOffdZ, 16);
        int dZv = pSprite.z - cp.viewSpeed - pPlayer.viewOffZ;
        pPlayer.viewOffdZ = dZv > 0 ? (pPlayer.viewOffdZ += Pragmas.mulscale(40960L, dZv << 8, 16)) : (pPlayer.viewOffdZ += Pragmas.mulscale(6144L, dZv << 8, 16));
        pPlayer.viewOffZ += pPlayer.viewOffdZ >> 8;
        pPlayer.weapOffdZ += Pragmas.mulscale(20480L, Actor.sprZVel[nSprite] - (long)pPlayer.weapOffdZ, 16);
        int dZw = pSprite.z - cp.weapSpeed - pPlayer.weaponAboveZ;
        pPlayer.weapOffdZ = dZw > 0 ? (pPlayer.weapOffdZ += Pragmas.mulscale(32768L, dZw << 8, 16)) : (pPlayer.weapOffdZ += Pragmas.mulscale(3072L, dZw << 8, 16));
        pPlayer.weaponAboveZ += pPlayer.weapOffdZ >> 8;
        pPlayer.bobAmp = Gameutils.ClipLow(pPlayer.bobAmp - Globals.kFrameTicks, 0);
        if (pPlayer.moveState == 1) {
            pPlayer.bobPhase = pPlayer.bobPhase + Globals.kFrameTicks * 2048 / 120 / 4 & 0x7FF;
            pPlayer.swayPhase = pPlayer.swayPhase + Globals.kFrameTicks * 2048 / 120 / 4 & 0x7FF;
            pPlayer.bobHeight = Pragmas.mulscale(cp.bobV * 10, Trig.Sin(pPlayer.bobPhase * 2), 30);
            pPlayer.bobWidth = Pragmas.mulscale(cp.bobH * pPlayer.bobAmp, Trig.Sin(pPlayer.bobPhase - 256), 30);
            pPlayer.swayHeight = Pragmas.mulscale(cp.swayV * pPlayer.bobAmp, Trig.Sin(pPlayer.swayPhase * 2), 30);
            pPlayer.swayWidth = Pragmas.mulscale(cp.swayH * pPlayer.bobAmp, Trig.Sin(pPlayer.swayPhase - 341), 30);
        } else if (pXSprite.height < 256) {
            boolean Run = false;
            pPlayer.bobPhase = pPlayer.bobPhase + Globals.kFrameTicks * cp.pace[Run ? 1 : 0] & 0x7FF;
            pPlayer.swayPhase = pPlayer.swayPhase + Globals.kFrameTicks * cp.pace[Run ? 1 : 0] / 2 & 0x7FF;
            if (Run) {
                if (pPlayer.bobAmp < 60) {
                    pPlayer.bobAmp = Gameutils.ClipHigh(pPlayer.bobAmp + moveDist, 60);
                }
            } else if (pPlayer.bobAmp < 30) {
                pPlayer.bobAmp = Gameutils.ClipHigh(pPlayer.bobAmp + moveDist, 30);
            }
            pPlayer.bobHeight = Pragmas.mulscale(cp.bobV * pPlayer.bobAmp, Trig.Sin(pPlayer.bobPhase * 2), 30);
            pPlayer.bobWidth = Pragmas.mulscale(cp.bobH * pPlayer.bobAmp, Trig.Sin(pPlayer.bobPhase - 256), 30);
            pPlayer.swayHeight = Pragmas.mulscale(cp.swayV * pPlayer.bobAmp, Trig.Sin(pPlayer.swayPhase * 2), 30);
            pPlayer.swayWidth = Pragmas.mulscale(cp.swayH * pPlayer.bobAmp, Trig.Sin(pPlayer.swayPhase - 341), 30);
        }
        pPlayer.explosion = 0;
        pPlayer.quakeTime = Gameutils.ClipLow(pPlayer.quakeTime - Globals.kFrameTicks, 0);
        pPlayer.tilt = Gameutils.ClipLow(pPlayer.tilt - Globals.kFrameTicks, 0);
        pPlayer.visibility = Gameutils.ClipLow(pPlayer.visibility - Globals.kFrameTicks, 0);
        pPlayer.hitEffect = Gameutils.ClipLow(pPlayer.hitEffect - Globals.kFrameTicks, 0);
        pPlayer.blindEffect = Gameutils.ClipLow(pPlayer.blindEffect - Globals.kFrameTicks, 0);
        pPlayer.pickupEffect = Gameutils.ClipLow(pPlayer.pickupEffect - Globals.kFrameTicks, 0);
        if (pXSprite.health == 0) {
            if (pPlayer == Globals.gMe) {
                Globals.gMe.handDamage = false;
            }
            return;
        }
        pPlayer.Underwater = false;
        if (pPlayer.moveState == 1) {
            short type;
            pPlayer.Underwater = true;
            if (Warp.gLowerLink[pSprite.sectnum] > 0 && ((type = Engine.sprite[Warp.gLowerLink[pSprite.sectnum]].lotag) == 14 || type == 10) && Main.engine.getceilzofslope(pSprite.sectnum, pSprite.x, pSprite.y) > pPlayer.viewOffZ) {
                pPlayer.Underwater = false;
            }
        }
        if (!pPlayer.Underwater) {
            pPlayer.airTime = 1200;
            pPlayer.drownEffect = 0;
            if (PLAYER.inventoryCheck(pPlayer, 1)) {
                PLAYER.processInventory(pPlayer, 1);
            }
        }
        int dudeIndex = 31;
        short nXSprite = pSprite.extra;
        if (nXSprite == -1) {
            return;
        }
        switch (pPlayer.moveState) {
            case 0: {
                if (moveDist == 0) {
                    SeqHandling.seqSpawn(DudeInfo.dudeInfo[dudeIndex].seqStartID + VERSION.getPlayerSeq(0), 3, nXSprite, null);
                    break;
                }
                SeqHandling.seqSpawn(DudeInfo.dudeInfo[dudeIndex].seqStartID + VERSION.getPlayerSeq(6), 3, nXSprite, null);
                break;
            }
            case 1: {
                SeqHandling.seqSpawn(DudeInfo.dudeInfo[dudeIndex].seqStartID + VERSION.getPlayerSeq(7), 3, nXSprite, null);
                break;
            }
            case 2: 
            case 3: {
                SeqHandling.seqSpawn(DudeInfo.dudeInfo[dudeIndex].seqStartID + VERSION.getPlayerSeq(8), 3, nXSprite, null);
            }
        }
    }

    public static SPRITE playerFireThing(PLAYER pPlayer, int xoffset, int relSlope, int thingType, int velocity) {
        if (thingType < 400 || thingType >= 436) {
            Main.game.dassert("thingType >= kThingBase && thingType < kThingMax");
        }
        int z = pPlayer.weaponAboveZ - pPlayer.pSprite.z;
        if (newHoriz && !DEMO.IsOriginalDemo()) {
            z = (int)((float)z + 10.0f * pPlayer.horiz);
        }
        return Actor.actFireThing(pPlayer.nSprite, xoffset, z, (int)pPlayer.horizOff + relSlope, thingType, velocity);
    }

    public static SPRITE playerFireMissile(PLAYER pPlayer, int xoffset, int dx, int dy, int dz, int missileType) {
        int z = pPlayer.weaponAboveZ - pPlayer.pSprite.z;
        if (newHoriz && !DEMO.IsOriginalDemo()) {
            z = (int)((float)z - 20.0f * pPlayer.horiz);
        }
        return Actor.actFireMissile(pPlayer.pSprite, xoffset, z, dx, dy, dz, missileType);
    }

    public static int playerCalcDamage(PLAYER pPlayer, int nDamageType, int nDamage) {
        int nArmorType = PLAYER.gDamageInfo[nDamageType].nArmorType;
        if (nArmorType >= 0 && pPlayer.ArmorAmount[nArmorType] != 0) {
            int tmp = nDamage / 4;
            int damage = tmp + Pragmas.muldiv(pPlayer.ArmorAmount[nArmorType], 7 * nDamage / 8 - tmp, 3200L);
            nDamage -= damage;
            pPlayer.ArmorAmount[nArmorType] = Gameutils.ClipLow(pPlayer.ArmorAmount[nArmorType] - damage, 0);
        }
        return nDamage;
    }

    public static void playerDamageSprite(PLAYER pPlayer, int nSource, int nDamageType, int nDamage) {
        if (nSource >= Globals.kMaxSprites) {
            Main.game.dassert("nSource < kMaxSprites");
        }
        if (pPlayer == null) {
            Main.game.dassert("pPlayer != NULL");
        }
        if (nDamageType < 0 || nDamageType >= 7) {
            Main.game.dassert("nDamageType >= 0 && nDamageType < kDamageMax");
        }
        if (pPlayer.damageShift[nDamageType] == 0) {
            int nDeathSeqID = -1;
            nDamage = PLAYER.playerCalcDamage(pPlayer, nDamageType, nDamage);
            pPlayer.hitEffect = Gameutils.ClipHigh(pPlayer.hitEffect + (nDamage >> 3), 600);
            SPRITE pSprite = pPlayer.pSprite;
            XSPRITE pXSprite = pPlayer.pXsprite;
            if (pSprite == null || !Actor.IsDudeSprite(pSprite)) {
                return;
            }
            DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
            CALLPROC nCallback = null;
            if (pXSprite.health == 0) {
                if (PLAYER.checkPlayerSeq(pPlayer, VERSION.getPlayerSeq(12))) {
                    if (Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode) {
                        return;
                    }
                    switch (nDamageType) {
                        case 3: {
                            Gib.actGenerateGibs(pSprite, 7, null, null);
                            Gib.actGenerateGibs(pSprite, 15, null, null);
                            pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                            nDeathSeqID = VERSION.getPlayerSeq(13);
                            break;
                        }
                        case 5: {
                            nDeathSeqID = VERSION.getPlayerSeq(14);
                            SOUND.sfxStart3DSound(pSprite, 716, 0, 0);
                            break;
                        }
                        default: {
                            Gameutils.GetSpriteExtents(pSprite);
                            Gib.startPos.set(pSprite.x, pSprite.y, Gameutils.extents_zTop);
                            Gib.startVel.set(Actor.sprXVel[pSprite.xvel] >> 1, Actor.sprYVel[pSprite.xvel] >> 1, -838860.0f);
                            Gib.actGenerateGibs(pSprite, 27, Gib.startPos, Gib.startVel);
                            Gib.actGenerateGibs(pSprite, 7, null, null);
                            Actor.actSpawnBlood(pSprite);
                            Actor.actSpawnBlood(pSprite);
                            nDeathSeqID = VERSION.getPlayerSeq(13);
                            break;
                        }
                    }
                }
            } else {
                int dHealth = pXSprite.health - nDamage;
                pXSprite.health = Gameutils.ClipLow(dHealth, 0);
                if (pXSprite.health != 0 && pXSprite.health < 16) {
                    pXSprite.health = 0;
                    dHealth = -25;
                    nDamageType = 2;
                }
                if (pXSprite.health == 0) {
                    if (Globals.pGameInfo.nGameType == 3 && pPlayer.hasFlag != 0) {
                        SPRITE nFlag;
                        if ((pPlayer.hasFlag & 1) != 0) {
                            pPlayer.hasFlag &= 0xFFFFFFFE;
                            nFlag = Actor.DropPickupObject(pPlayer.pSprite, 147);
                            if (nFlag != null) {
                                nFlag.owner = pPlayer.nBlueTeam;
                            }
                            SOUND.sndStartSample(8005, 255, 2, false);
                            View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " dropped Blue Flag", -1, 10);
                        }
                        if ((pPlayer.hasFlag & 2) != 0) {
                            pPlayer.hasFlag &= 0xFFFFFFFD;
                            nFlag = Actor.DropPickupObject(pPlayer.pSprite, 148);
                            if (nFlag != null) {
                                nFlag.owner = pPlayer.nRedTeam;
                            }
                            SOUND.sndStartSample(8004, 255, 2, false);
                            View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " dropped Red Flag", -1, 7);
                        }
                    }
                    SOUND.sfxKill3DSound(pPlayer.pSprite, -1, 441);
                    pPlayer.deathTime = 0;
                    if (Globals.pGameInfo.nGameType == 0 || pPlayer.currentWeapon != 6 && pPlayer.currentWeapon != 7 || pPlayer.weaponTimer == 0) {
                        pPlayer.fLoopQAV = false;
                        pPlayer.currentWeapon = 0;
                        pPlayer.LastWeapon = 0;
                    }
                    pPlayer.CrouchMode = 0;
                    pPlayer.fraggerID = nSource;
                    pPlayer.voodooCount = 0;
                    if (nDamageType == 3 && nDamage < 144) {
                        nDamageType = 0;
                    }
                    if (Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode) {
                        SOUND.sfxStart3DSound(pSprite, PLAYER.gDamageInfo[nDamageType].nSoundID[3], 0, 2);
                        nDeathSeqID = VERSION.getPlayerSeq(12);
                        pXSprite.target = nSource;
                    } else {
                        switch (nDamageType) {
                            case 1: {
                                SOUND.sfxStart3DSound(pSprite, 718, 0, 0);
                                nDeathSeqID = VERSION.getPlayerSeq(3);
                                break;
                            }
                            case 3: {
                                SOUND.sfxStart3DSound(pSprite, 717, 0, 0);
                                Gib.actGenerateGibs(pSprite, 7, null, null);
                                Gib.actGenerateGibs(pSprite, 15, null, null);
                                nDeathSeqID = VERSION.getPlayerSeq(2);
                                pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                                break;
                            }
                            case 4: {
                                nDeathSeqID = VERSION.getPlayerSeq(1);
                                break;
                            }
                            default: {
                                if (dHealth < -20 && Globals.pGameInfo.nGameType >= 2 && Gameutils.Chance(8192)) {
                                    nCallback = SeqHandling.callbacks[12];
                                    SOUND.sfxStart3DSound(pSprite, PLAYER.gDamageInfo[nDamageType].nSoundID[3], 0, 2);
                                    nDeathSeqID = VERSION.getPlayerSeq(12);
                                    PLAYER.powerupActivate(pPlayer, 28);
                                    pXSprite.target = nSource;
                                    EVENT.evPostCallback(pSprite.xvel, 3, 15L, 13);
                                    break;
                                }
                                SOUND.sfxStart3DSound(pSprite, 716, 0, 0);
                                nDeathSeqID = VERSION.getPlayerSeq(1);
                                break;
                            }
                        }
                    }
                } else {
                    DAMAGEINFO pDamageInfo = gDamageInfo[nDamageType];
                    int nSoundID = nDamage < 160 ? pDamageInfo.nSoundID[Gameutils.Random(3)] : pDamageInfo.nSoundID[0];
                    if (nDamageType == 4 && Globals.gPlayer[View.gViewIndex].pXsprite.palette == 1 && !pPlayer.handDamage) {
                        nSoundID = 714;
                    }
                    SOUND.sfxStart3DSound(pSprite, nSoundID, 0, 6);
                    return;
                }
            }
            if (nDeathSeqID >= 0) {
                if (nDeathSeqID != VERSION.getPlayerSeq(12) || Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1) {
                    short nXSector = Engine.sector[pSprite.sectnum].extra;
                    PLAYER.powerupClear(pPlayer);
                    if (nXSector > 0 && DB.xsector[nXSector].Exit) {
                        Trigger.trTriggerSector(pSprite.sectnum, DB.xsector[nXSector], 43);
                    }
                    pSprite.hitag = (short)(pSprite.hitag | 7);
                    short i = Mmulti.connecthead;
                    while (i >= 0) {
                        if (pSprite.xvel == Globals.gPlayer[i].fraggerID && Globals.gPlayer[i].deathTime > 0) {
                            Globals.gPlayer[i].fraggerID = -1;
                        }
                        i = Mmulti.connectpoint2[i];
                    }
                    PLAYER.playerFrag(pPlayer, nSource);
                    Trigger.trTriggerSprite(pSprite.xvel, pXSprite, 0);
                }
                if (!BuildGdx.cache.contains(pDudeInfo.seqStartID + nDeathSeqID, "SEQ")) {
                    Main.game.dassert("gSysRes.Lookup(pDudeInfo.seqStartID + nDeathSeqID, \"SEQ\") != null");
                }
                SeqHandling.seqSpawn(pDudeInfo.seqStartID + nDeathSeqID, 3, pSprite.extra, nCallback);
            }
        }
    }

    public static void playerFrag(PLAYER pKiller, PLAYER pVictim) {
        int nVictim;
        int nKiller;
        if (pKiller == null) {
            Main.game.dassert("pKiller != NULL");
        }
        if (pVictim == null) {
            Main.game.dassert("pVictim != NULL");
        }
        if ((nKiller = pKiller.pSprite.lotag - 231) < 0 || nKiller >= 8) {
            Main.game.dassert("nKiller >= 0 && nKiller < kMaxPlayers");
        }
        if ((nVictim = pVictim.pSprite.lotag - 231) < 0 || nVictim >= 8) {
            Main.game.dassert("nVictim >= 0 && nVictim < kMaxPlayers");
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead) {
            // empty if block
        }
        if (nKiller == nVictim) {
            pVictim.fraggerID = -1;
            --pVictim.fragCount;
            int n = nKiller;
            pVictim.fragInfo[n] = pVictim.fragInfo[n] - 1;
            if (Globals.pGameInfo.nGameType == 3) {
                int n2 = pVictim.teamID;
                Globals.nTeamCount[n2] = Globals.nTeamCount[n2] - 1;
            }
            int n3 = Gameutils.Random(deathAphorisms1.length);
            if (pVictim.handCount <= 0) {
                String message;
                if (pVictim != Globals.gMe && Globals.pGameInfo.nGameType > 0 && PLAYER.deathAphorisms1[n3].nSound >= 0) {
                    if (Globals.pGameInfo.nGameType != 1) {
                        SOUND.sndStartSample(PLAYER.deathAphorisms1[n3].nSound, 255, 2, false);
                    }
                    message = Main.game.net.gProfile[nVictim].name + PLAYER.deathAphorisms1[n3].text;
                } else {
                    message = "You killed yourself!";
                }
                View.viewSetMessage(message, -1, 7);
            }
        } else {
            ++pKiller.fragCount;
            int n = nVictim;
            pKiller.fragInfo[n] = pKiller.fragInfo[n] + 1;
            if (Globals.pGameInfo.nGameType == 3) {
                if (pKiller.teamID == pVictim.teamID) {
                    int n4 = pKiller.teamID;
                    Globals.nTeamCount[n4] = Globals.nTeamCount[n4] - 1;
                } else {
                    int n5 = pKiller.teamID;
                    Globals.nTeamCount[n5] = Globals.nTeamCount[n5] + 1;
                    int n6 = pKiller.teamID;
                    Globals.nTeamClock[n6] = Globals.nTeamClock[n6] + 120;
                }
            }
            if (Globals.pGameInfo.nGameType > 0) {
                int n7 = Gameutils.Random(deathAphorisms2.length);
                if (Globals.pGameInfo.nGameType > 0 && pKiller == Globals.gMe && PLAYER.deathAphorisms2[n7].nSound >= 0 && Globals.pGameInfo.nGameType != 1) {
                    SOUND.sndStartSample(PLAYER.deathAphorisms2[n7].nSound, 255, 2, false);
                }
                String message = Main.game.net.gProfile[nKiller].name + PLAYER.deathAphorisms2[n7].text + Main.game.net.gProfile[nVictim].name;
                if (PLAYER.deathAphorisms2[n7].text2 != null) {
                    message = message + PLAYER.deathAphorisms2[n7].text2;
                }
                View.viewSetMessage(message, -1, 7);
            }
        }
    }

    public static void playerFrag(PLAYER pVictim, int nKiller) {
        SPRITE pKiller;
        if (nKiller >= 0 && Actor.IsDudeSprite(pKiller = Engine.sprite[nKiller])) {
            if (Gameutils.IsPlayerSprite(pKiller)) {
                PLAYER.playerFrag(Globals.gPlayer[pKiller.lotag - 231], pVictim);
                int nVictimTeam = pVictim.teamID & 1;
                int nKillerTeam = Globals.gPlayer[pKiller.lotag - 231].teamID & 1;
                if (nKillerTeam == 0 && nVictimTeam == 0) {
                    EVENT.evSend(0, 0, 15, 3);
                } else {
                    EVENT.evSend(0, 0, 16, 3);
                }
            } else if (Globals.pGameInfo.nGameType > 0) {
                int n = Gameutils.Random(deathAphorisms2.length);
                String message = DB.kDudeName[pKiller.lotag - 200] + PLAYER.deathAphorisms2[n].text + Main.game.net.gProfile[pVictim.nPlayer].name;
                if (PLAYER.deathAphorisms2[n].text2 != null) {
                    message = message + PLAYER.deathAphorisms2[n].text2;
                }
                View.viewSetMessage(message, -1, 7);
            }
        }
        PLAYER.checkFragLimit();
    }

    public static void checkFragLimit() {
        if (Globals.pGameInfo.nFragLimit != 0) {
            int i;
            int nFrags;
            if (Globals.pGameInfo.nGameType == 2) {
                nFrags = 0;
                i = Mmulti.connecthead;
                while (i >= 0) {
                    nFrags = Math.max(nFrags, Globals.gPlayer[i].fragCount);
                    i = Mmulti.connectpoint2[i];
                }
                if (nFrags >= Globals.pGameInfo.nFragLimit) {
                    EVENT.evPostCallback(Globals.gMe.nSprite, 3, 300L, 22);
                }
            }
            if (Globals.pGameInfo.nGameType == 3) {
                nFrags = 0;
                for (i = 0; i < 2; ++i) {
                    nFrags = Math.max(nFrags, Globals.nTeamCount[i]);
                }
                if (nFrags >= Globals.pGameInfo.nFragLimit) {
                    EVENT.evPostCallback(Globals.gMe.nSprite, 3, 300L, 22);
                }
            }
        }
    }

    public static void FReviveCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        SPRITE pSprite = Engine.sprite[pXSprite.reference];
        if (Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1) {
            Actor.actHealDude(pXSprite, 30, 30);
        } else {
            Actor.actHealDude(pXSprite, 1, 2);
        }
        if (Globals.pGameInfo.nGameType > 0 && Mmulti.numplayers > 1) {
            SOUND.sfxStart3DSound(pSprite, 3009, 0, 0);
            if (Gameutils.IsPlayerSprite(pSprite)) {
                PLAYER pPlayer = Globals.gPlayer[pSprite.lotag - 231];
                String message = pPlayer == Globals.gMe ? "I LIVE...AGAIN!!" : Main.game.net.gProfile[pPlayer.nPlayer].name + " lives again!";
                View.viewSetMessage(message, -1, 10);
                pPlayer.pInput.newWeapon = 1;
            }
        }
    }

    public static void FatalityDeadCallback(int nXIndex) {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            if (DB.xsprite[nXIndex] == Globals.gPlayer[i].pXsprite) {
                PLAYER.playerDamageSprite(Globals.gPlayer[i], Globals.gPlayer[i].fraggerID, 5, 8000);
                break;
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    public byte[] getBytes(int nVersion) {
        int j;
        if (this.PlayerBuffer == null) {
            this.PlayerBuffer = ByteBuffer.allocate(865);
        } else {
            this.PlayerBuffer.clear();
        }
        this.PlayerBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.PlayerBuffer.putInt(this.NPSTART);
        this.PlayerBuffer.putInt(this.pWeaponQAV);
        this.PlayerBuffer.putInt(this.weaponCallback);
        this.PlayerBuffer.put(this.Run ? (byte)1 : 0);
        this.PlayerBuffer.putInt(this.moveState);
        this.PlayerBuffer.putInt(this.moveDist);
        this.PlayerBuffer.putInt(this.bobAmp);
        this.PlayerBuffer.putInt(this.bobPhase);
        this.PlayerBuffer.putInt(this.bobHeight);
        this.PlayerBuffer.putInt(this.bobWidth);
        this.PlayerBuffer.putInt(this.swayAmp);
        this.PlayerBuffer.putInt(this.swayPhase);
        this.PlayerBuffer.putInt(this.swayHeight);
        this.PlayerBuffer.putInt(this.swayWidth);
        this.PlayerBuffer.putInt(this.nPlayer);
        this.PlayerBuffer.putInt(this.nSprite);
        this.PlayerBuffer.putInt(this.nLifeMode);
        this.PlayerBuffer.putInt(this.bloodlust);
        this.PlayerBuffer.putInt(this.viewOffZ);
        this.PlayerBuffer.putInt(this.viewOffdZ);
        this.PlayerBuffer.putInt(this.weaponAboveZ);
        this.PlayerBuffer.putInt(this.weapOffdZ);
        if (nVersion < 300) {
            this.PlayerBuffer.putInt((int)this.look);
            this.PlayerBuffer.putInt((int)this.horiz);
        } else {
            this.PlayerBuffer.putFloat(this.look);
            this.PlayerBuffer.putFloat(this.horiz);
        }
        this.PlayerBuffer.putInt(this.slope);
        if (nVersion < 300) {
            this.PlayerBuffer.putInt((int)this.horizOff);
        } else {
            this.PlayerBuffer.putFloat(this.horizOff);
        }
        this.PlayerBuffer.put(this.Underwater ? (byte)1 : 0);
        for (j = 0; j < 8; ++j) {
            this.PlayerBuffer.put(this.hasKey[j] ? (byte)1 : 0);
        }
        this.PlayerBuffer.put((byte)this.hasFlag);
        if (nVersion >= 277) {
            this.PlayerBuffer.putShort(this.nBlueTeam);
            this.PlayerBuffer.putShort(this.nRedTeam);
            for (j = 0; j < 12; ++j) {
                this.PlayerBuffer.put((byte)0);
            }
        }
        for (j = 0; j < 7; ++j) {
            this.PlayerBuffer.putInt(this.damageShift[j]);
        }
        this.PlayerBuffer.put((byte)this.currentWeapon);
        this.PlayerBuffer.put((byte)this.updateWeapon);
        this.PlayerBuffer.putInt(this.weaponTimer);
        this.PlayerBuffer.putInt(this.weaponState);
        this.PlayerBuffer.putInt(this.weaponAmmo);
        for (j = 0; j < 14; ++j) {
            this.PlayerBuffer.put(this.hasWeapon[j] ? (byte)1 : 0);
        }
        for (j = 0; j < 14; ++j) {
            this.PlayerBuffer.putInt(this.weaponMode[j]);
        }
        for (j = 0; j < 14; ++j) {
            this.PlayerBuffer.putInt(this.weaponOrder[0][j]);
        }
        for (j = 0; j < 14; ++j) {
            this.PlayerBuffer.putInt(this.weaponOrder[1][j]);
        }
        for (j = 0; j < 12; ++j) {
            this.PlayerBuffer.putInt(this.ammoCount[j]);
        }
        this.PlayerBuffer.put(this.fLoopQAV ? (byte)1 : 0);
        this.PlayerBuffer.putInt(this.fuseTime);
        this.PlayerBuffer.putInt(this.fireClock);
        this.PlayerBuffer.putInt(this.throwTime);
        this.PlayerBuffer.putInt((int)this.aim.x);
        this.PlayerBuffer.putInt((int)this.aim.y);
        this.PlayerBuffer.putInt((int)this.aim.z);
        this.PlayerBuffer.putInt((int)this.relAim.x);
        this.PlayerBuffer.putInt((int)this.relAim.y);
        this.PlayerBuffer.putInt((int)this.relAim.z);
        this.PlayerBuffer.putInt(this.nAimSprite);
        this.PlayerBuffer.putInt(this.aimCount);
        for (j = 0; j < 16; ++j) {
            this.PlayerBuffer.putShort((short)this.aimSprites[j]);
        }
        this.PlayerBuffer.putInt(this.deathTime);
        for (j = 0; j < 49; ++j) {
            this.PlayerBuffer.putInt(this.powerUpTimer[j]);
        }
        this.PlayerBuffer.putInt(this.fragCount);
        for (j = 0; j < 8; ++j) {
            this.PlayerBuffer.putInt(this.fragInfo[j]);
        }
        this.PlayerBuffer.putInt(this.teamID);
        this.PlayerBuffer.putInt(this.fraggerID);
        this.PlayerBuffer.putInt(this.airTime);
        this.PlayerBuffer.putInt(this.bloodTime);
        this.PlayerBuffer.putInt(this.gooTime);
        this.PlayerBuffer.putInt(this.wetTime);
        this.PlayerBuffer.putInt(this.bubbleTime);
        this.PlayerBuffer.putInt(0);
        this.PlayerBuffer.putInt(this.stayTime);
        this.PlayerBuffer.putInt(this.kickTime);
        this.PlayerBuffer.putInt(this.pLaughsCount);
        this.PlayerBuffer.putInt(this.TurnAround);
        this.PlayerBuffer.put(this.godMode ? (byte)1 : 0);
        this.PlayerBuffer.put(this.fScreamed ? (byte)1 : 0);
        this.PlayerBuffer.put(this.pJump ? (byte)1 : 0);
        this.PlayerBuffer.putInt(this.showInventory);
        this.PlayerBuffer.putInt(this.choosedInven);
        for (j = 0; j < 5; ++j) {
            this.PlayerBuffer.put(this.Inventory[j].activated ? (byte)1 : 0);
            this.PlayerBuffer.putInt(this.Inventory[j].amount);
        }
        for (j = 0; j < 3; ++j) {
            this.PlayerBuffer.putInt(this.ArmorAmount[j]);
        }
        this.PlayerBuffer.putInt(this.voodooTarget);
        this.PlayerBuffer.putInt(this.voodooCount);
        this.PlayerBuffer.putInt(this.voodooAng);
        this.PlayerBuffer.putInt(this.voodooUnk);
        this.PlayerBuffer.putInt(this.explosion);
        this.PlayerBuffer.putInt(this.tilt);
        this.PlayerBuffer.putInt(this.visibility);
        this.PlayerBuffer.putInt(this.hitEffect);
        this.PlayerBuffer.putInt(this.blindEffect);
        this.PlayerBuffer.putInt(this.drownEffect);
        this.PlayerBuffer.putInt(this.handCount);
        this.PlayerBuffer.put(this.handDamage ? (byte)1 : 0);
        this.PlayerBuffer.putInt(this.pickupEffect);
        this.PlayerBuffer.putInt(this.fireEffect);
        this.PlayerBuffer.putInt(this.quakeTime);
        return this.PlayerBuffer.array();
    }

    public void set(Resource bb, int nVersion) {
        int j;
        this.NPSTART = bb.readInt();
        this.pWeaponQAV = bb.readInt();
        this.weaponCallback = bb.readInt();
        this.Run = bb.readBoolean();
        this.moveState = bb.readInt();
        this.moveDist = bb.readInt();
        this.bobAmp = bb.readInt();
        this.bobPhase = bb.readInt();
        this.bobHeight = bb.readInt();
        this.bobWidth = bb.readInt();
        this.swayAmp = bb.readInt();
        this.swayPhase = bb.readInt();
        this.swayHeight = bb.readInt();
        this.swayWidth = bb.readInt();
        this.nPlayer = bb.readInt();
        this.nSprite = bb.readInt();
        this.nLifeMode = bb.readInt();
        this.bloodlust = bb.readInt();
        this.viewOffZ = bb.readInt();
        this.viewOffdZ = bb.readInt();
        this.weaponAboveZ = bb.readInt();
        this.weapOffdZ = bb.readInt();
        if (nVersion < 300) {
            this.look = bb.readInt().intValue();
            this.horiz = bb.readInt().intValue();
        } else {
            this.look = bb.readFloat().floatValue();
            this.horiz = bb.readFloat().floatValue();
        }
        this.slope = bb.readInt();
        this.horizOff = nVersion < 300 ? (float)bb.readInt().intValue() : bb.readFloat().floatValue();
        this.Underwater = bb.readBoolean();
        for (j = 0; j < 8; ++j) {
            this.hasKey[j] = bb.readBoolean();
        }
        this.hasFlag = bb.readByte().byteValue();
        if (nVersion >= 277) {
            this.nBlueTeam = bb.readShort();
            this.nRedTeam = bb.readShort();
            for (j = 0; j < 12; ++j) {
                bb.readByte();
            }
        }
        for (j = 0; j < 7; ++j) {
            this.damageShift[j] = bb.readInt();
        }
        this.currentWeapon = bb.readByte().byteValue();
        this.updateWeapon = bb.readByte().byteValue();
        this.weaponTimer = bb.readInt();
        this.weaponState = bb.readInt();
        this.weaponAmmo = bb.readInt();
        for (j = 0; j < 14; ++j) {
            this.hasWeapon[j] = bb.readBoolean();
        }
        for (j = 0; j < 14; ++j) {
            this.weaponMode[j] = bb.readInt();
        }
        for (j = 0; j < 14; ++j) {
            this.weaponOrder[0][j] = bb.readInt();
        }
        for (j = 0; j < 14; ++j) {
            this.weaponOrder[1][j] = bb.readInt();
        }
        for (j = 0; j < 12; ++j) {
            this.ammoCount[j] = bb.readInt();
        }
        this.fLoopQAV = bb.readBoolean();
        this.fuseTime = bb.readInt();
        this.fireClock = bb.readInt();
        this.throwTime = bb.readInt();
        this.aim.set(bb.readInt().intValue(), bb.readInt().intValue(), bb.readInt().intValue());
        this.relAim.set(bb.readInt().intValue(), bb.readInt().intValue(), bb.readInt().intValue());
        this.nAimSprite = bb.readInt();
        this.aimCount = bb.readInt();
        for (j = 0; j < 16; ++j) {
            this.aimSprites[j] = bb.readShort().shortValue();
        }
        this.deathTime = bb.readInt();
        for (j = 0; j < 49; ++j) {
            this.powerUpTimer[j] = bb.readInt();
        }
        this.fragCount = bb.readInt();
        for (j = 0; j < 8; ++j) {
            this.fragInfo[j] = bb.readInt();
        }
        this.teamID = bb.readInt();
        this.fraggerID = bb.readInt();
        this.airTime = bb.readInt();
        this.bloodTime = bb.readInt();
        this.gooTime = bb.readInt();
        this.wetTime = bb.readInt();
        this.bubbleTime = bb.readInt();
        bb.readInt();
        this.stayTime = bb.readInt();
        this.kickTime = bb.readInt();
        this.pLaughsCount = bb.readInt();
        this.TurnAround = bb.readInt();
        this.godMode = bb.readBoolean();
        this.fScreamed = bb.readBoolean();
        this.pJump = bb.readBoolean();
        this.showInventory = bb.readInt();
        this.choosedInven = bb.readInt();
        for (j = 0; j < 5; ++j) {
            this.Inventory[j].activated = bb.readBoolean();
            this.Inventory[j].amount = bb.readInt();
        }
        for (j = 0; j < 3; ++j) {
            this.ArmorAmount[j] = bb.readInt();
        }
        this.voodooTarget = bb.readInt();
        this.voodooCount = bb.readInt();
        this.voodooAng = bb.readInt();
        this.voodooUnk = bb.readInt();
        this.explosion = bb.readInt();
        this.tilt = bb.readInt();
        this.visibility = bb.readInt();
        this.hitEffect = bb.readInt();
        this.blindEffect = bb.readInt();
        this.drownEffect = bb.readInt();
        this.handCount = bb.readInt();
        this.handDamage = bb.readBoolean();
        this.pickupEffect = bb.readInt();
        this.fireEffect = bb.readInt();
        this.quakeTime = bb.readInt();
    }

    public String toString() {
        int j;
        StringBuilder out = new StringBuilder("NPSTART " + this.NPSTART + " \r\n");
        out.append("pWeaponQAV ").append(this.pWeaponQAV).append(" \r\n");
        out.append("weaponCallback ").append(this.weaponCallback).append(" \r\n");
        out.append("Run ").append(this.Run).append(" \r\n");
        out.append("moveState ").append(this.moveState).append(" \r\n");
        out.append("moveDist ").append(this.moveDist).append(" \r\n");
        out.append("bobAmp ").append(this.bobAmp).append(" \r\n");
        out.append("bobPhase ").append(this.bobPhase).append(" \r\n");
        out.append("bobHeight ").append(this.bobHeight).append(" \r\n");
        out.append("bobWidth ").append(this.bobWidth).append(" \r\n");
        out.append("swayAmp ").append(this.swayAmp).append(" \r\n");
        out.append("swayPhase ").append(this.swayPhase).append(" \r\n");
        out.append("swayHeight ").append(this.swayHeight).append(" \r\n");
        out.append("swayWidth ").append(this.swayWidth).append(" \r\n");
        out.append("nPlayer ").append(this.nPlayer).append(" \r\n");
        out.append("nSprite ").append(this.nSprite).append(" \r\n");
        out.append("nLifeMode ").append(this.nLifeMode).append(" \r\n");
        out.append("bloodlust ").append(this.bloodlust).append(" \r\n");
        out.append("viewOffZ ").append(this.viewOffZ).append(" \r\n");
        out.append("viewOffdZ ").append(this.viewOffdZ).append(" \r\n");
        out.append("weaponAboveZ ").append(this.weaponAboveZ).append(" \r\n");
        out.append("weapOffdZ ").append(this.weapOffdZ).append(" \r\n");
        out.append("look ").append(this.look).append(" \r\n");
        out.append("horiz ").append(this.horiz).append(" \r\n");
        out.append("slope ").append(this.slope).append(" \r\n");
        out.append("horizOff ").append(this.horizOff).append(" \r\n");
        out.append("Underwater ").append(this.Underwater).append(" \r\n");
        for (j = 0; j < 8; ++j) {
            out.append("hasKey[").append(j).append("] ").append(this.hasKey[j]).append(" \r\n");
        }
        out.append("hasFlag ").append(this.hasFlag).append(" \r\n");
        out.append("nBlueTeam ").append(this.nBlueTeam).append(" \r\n");
        out.append("nRedTeam ").append(this.nRedTeam).append(" \r\n");
        for (j = 0; j < 7; ++j) {
            out.append("damageShift[").append(j).append("] ").append(this.damageShift[j]).append(" \r\n");
        }
        out.append("currentWeapon ").append(this.currentWeapon).append(" \r\n");
        out.append("updateWeapon ").append(this.updateWeapon).append(" \r\n");
        out.append("weaponTimer ").append(this.weaponTimer).append(" \r\n");
        out.append("weaponState ").append(this.weaponState).append(" \r\n");
        out.append("weaponAmmo ").append(this.weaponAmmo).append(" \r\n");
        for (j = 0; j < 14; ++j) {
            out.append("hasWeapon[").append(j).append("] ").append(this.hasWeapon[j]).append(" \r\n");
        }
        for (j = 0; j < 14; ++j) {
            out.append("weaponMode[").append(j).append("] ").append(this.weaponMode[j]).append(" \r\n");
        }
        for (j = 0; j < 14; ++j) {
            out.append("weaponOrder[0][").append(j).append("] ").append(this.weaponOrder[0][j]).append(" \r\n");
        }
        for (j = 0; j < 14; ++j) {
            out.append("weaponOrder[1][").append(j).append("] ").append(this.weaponOrder[1][j]).append(" \r\n");
        }
        for (j = 0; j < 12; ++j) {
            out.append("ammoCount[").append(j).append("] ").append(this.ammoCount[j]).append(" \r\n");
        }
        out.append("fLoopQAV ").append(this.fLoopQAV).append(" \r\n");
        out.append("fuseTime ").append(this.fuseTime).append(" \r\n");
        out.append("fireClock ").append(this.fireClock).append(" \r\n");
        out.append("throwTime ").append(this.throwTime).append(" \r\n");
        out.append("aim[").append(this.aim.x).append(", ").append(this.aim.y).append(", ").append(this.aim.z).append("] \r\n");
        out.append("relAim[").append(this.relAim.x).append(", ").append(this.relAim.y).append(", ").append(this.relAim.z).append("] \r\n");
        out.append("nAimSprite ").append(this.nAimSprite).append(" \r\n");
        out.append("aimCount ").append(this.aimCount).append(" \r\n");
        for (j = 0; j < 16; ++j) {
            out.append("aimSprites[").append(j).append("] ").append(this.aimSprites[j]).append(" \r\n");
        }
        out.append("deathTime ").append(this.deathTime).append(" \r\n");
        for (j = 0; j < 49; ++j) {
            out.append("powerUpTimer[").append(j).append("] ").append(this.powerUpTimer[j]).append(" \r\n");
        }
        out.append("fragCount ").append(this.fragCount).append(" \r\n");
        for (j = 0; j < 8; ++j) {
            out.append("fragInfo[").append(j).append("] ").append(this.fragInfo[j]).append(" \r\n");
        }
        out.append("teamID ").append(this.teamID).append(" \r\n");
        out.append("fraggerID ").append(this.fraggerID).append(" \r\n");
        out.append("airTime ").append(this.airTime).append(" \r\n");
        out.append("bloodTime ").append(this.bloodTime).append(" \r\n");
        out.append("gooTime ").append(this.gooTime).append(" \r\n");
        out.append("wetTime ").append(this.wetTime).append(" \r\n");
        out.append("bubbleTime ").append(this.bubbleTime).append(" \r\n");
        out.append("stayTime ").append(this.stayTime).append(" \r\n");
        out.append("kickTime ").append(this.kickTime).append(" \r\n");
        out.append("pLaughsCount ").append(this.pLaughsCount).append(" \r\n");
        out.append("TurnAround ").append(this.TurnAround).append(" \r\n");
        out.append("godMode ").append(this.godMode).append(" \r\n");
        out.append("fScreamed ").append(this.fScreamed).append(" \r\n");
        out.append("pJump ").append(this.pJump).append(" \r\n");
        out.append("showInventory ").append(this.showInventory).append(" \r\n");
        out.append("choosedInven ").append(this.choosedInven).append(" \r\n");
        for (j = 0; j < 5; ++j) {
            out.append("Inventory[").append(j).append("].activated ").append(this.Inventory[j].activated).append(" \r\n");
            out.append("Inventory[").append(j).append("].amount ").append(this.Inventory[j].amount).append(" \r\n");
        }
        for (j = 0; j < 3; ++j) {
            out.append("ArmorAmount[").append(j).append("] ").append(this.ArmorAmount[j]).append(" \r\n");
        }
        out.append("voodooTarget ").append(this.voodooTarget).append(" \r\n");
        out.append("voodooCount ").append(this.voodooCount).append(" \r\n");
        out.append("voodooAng ").append(this.voodooAng).append(" \r\n");
        out.append("voodooUnk ").append(this.voodooUnk).append(" \r\n");
        out.append("explosion ").append(this.explosion).append(" \r\n");
        out.append("tilt ").append(this.tilt).append(" \r\n");
        out.append("visibility ").append(this.visibility).append(" \r\n");
        out.append("hitEffect ").append(this.hitEffect).append(" \r\n");
        out.append("blindEffect ").append(this.blindEffect).append(" \r\n");
        out.append("drownEffect ").append(this.drownEffect).append(" \r\n");
        out.append("handCount ").append(this.handCount).append(" \r\n");
        out.append("handDamage ").append(this.handDamage).append(" \r\n");
        out.append("pickupEffect ").append(this.pickupEffect).append(" \r\n");
        out.append("fireEffect ").append(this.fireEffect).append(" \r\n");
        out.append("quakeTime ").append(this.quakeTime).append(" \r\n");
        return out.toString();
    }

    static {
        newHoriz = true;
        gLaughs = new int[]{734, 735, 736, 737, 738, 739, 740, 741, 3038, 3049};
        weaponQAVs = new QAV[126];
        gAmmoInfo = new AMMOINFO[]{new AMMOINFO(0, 0, 255), new AMMOINFO(100, 0, 255), new AMMOINFO(100, 0, 4), new AMMOINFO(500, 0, 5), new AMMOINFO(100, 0, 255), new AMMOINFO(50, 0, 255), new AMMOINFO(2880, 0, 255), new AMMOINFO(250, 0, 255), new AMMOINFO(100, 0, 255), new AMMOINFO(100, 0, 255), new AMMOINFO(50, 0, 255), new AMMOINFO(50, 0, 255)};
        gDamageInfo = new DAMAGEINFO[]{new DAMAGEINFO(-1, new int[]{731, 732, 733, 710, 710, 710}), new DAMAGEINFO(1, new int[]{742, 743, 744, 711, 711, 711}), new DAMAGEINFO(0, new int[]{731, 732, 733, 712, 712, 712}), new DAMAGEINFO(1, new int[]{731, 732, 733, 713, 713, 713}), new DAMAGEINFO(-1, new int[]{724, 724, 724, 714, 714, 714}), new DAMAGEINFO(2, new int[]{731, 732, 733, 715, 715, 715}), new DAMAGEINFO(0, new int[]{0, 0, 0, 0, 0, 0})};
        Action_nIndex = 0;
        Action_nXIndex = 0;
        timer = 0;
        deathAphorisms1 = new FragInfo[]{new FragInfo(4202, " is excrement", null), new FragInfo(4203, " is hamburger", null), new FragInfo(4204, " suffered scrotum separation", null), new FragInfo(4206, " volunteered for population control", null), new FragInfo(4207, " has suicided", null)};
        deathAphorisms2 = new FragInfo[]{new FragInfo(4100, " boned ", " like a fish"), new FragInfo(4101, " castrated ", null), new FragInfo(4102, " creamed ", null), new FragInfo(4103, " destroyed ", null), new FragInfo(4104, " diced ", null), new FragInfo(4105, " disemboweled ", null), new FragInfo(4106, " flattened ", null), new FragInfo(4107, " gave ", " Anal Justice"), new FragInfo(4108, " gave AnAl MaDnEsS to ", null), new FragInfo(4109, " hurt ", " real bad"), new FragInfo(4110, " killed ", null), new FragInfo(4111, " made mincemeat out of ", null), new FragInfo(4112, " massacred ", null), new FragInfo(4113, " mutilated ", null), new FragInfo(4114, " reamed ", null), new FragInfo(4115, " ripped ", " a new orifice"), new FragInfo(4116, " slaughtered ", null), new FragInfo(4117, " sliced ", null), new FragInfo(4118, " smashed ", null), new FragInfo(4119, " sodomized ", null), new FragInfo(4120, " splattered ", null), new FragInfo(4121, " squashed ", null), new FragInfo(4122, " throttled ", null), new FragInfo(4123, " wasted ", null), new FragInfo(4124, " body bagged ", null)};
    }
}

