/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.util.Arrays;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.ModelHandle.VoxelInfo;
import ru.m210projects.Build.Types.Tile;

public class Tile {
    public static int kSurfNone = 0;
    public static int kSurfStone = 1;
    public static int kSurfMetal = 2;
    public static int kSurfWood = 3;
    public static int kSurfFlesh = 4;
    public static int kSurfWater = 5;
    public static int kSurfDirt = 6;
    public static int kSurfClay = 7;
    public static int kSurfSnow = 8;
    public static int kSurfIce = 9;
    public static int kSurfLeaves = 10;
    public static int kSurfCloth = 11;
    public static int kSurfPlant = 12;
    public static int kSurfGoo = 13;
    public static int kSurfLava = 14;
    public static int kSurfMax = 15;
    public static int[] surfSfxLand = new int[]{-1, 600, 601, 602, 603, 604, 605, 605, 605, 600, 605, 605, 605, 604, 603};
    public static int[][] surfSfxMove = new int[][]{{-1, -1}, {802, 803}, {804, 805}, {806, 807}, {808, 809}, {810, 811}, {812, 813}, {814, 815}, {816, 817}, {818, 819}, {820, 821}, {822, 823}, {824, 825}, {826, 827}, {828, 829}};
    public static short[] gVoxelData = new short[Globals.kMaxTiles];
    public static byte[] shadeTable = new byte[Globals.kMaxTiles];

    public static void tileInit() {
        Tile.voxelsInit("VOXEL.DAT");
        Tile.shadeInit("SHADE.DAT");
    }

    public static void voxelsInit(String name) {
        Arrays.fill(gVoxelData, (short)-1);
        Resource bb = BuildGdx.cache.open(name, 0);
        if (bb != null) {
            for (int i = 0; i < bb.size() / 2; ++i) {
                Tile.gVoxelData[i] = bb.readShort();
            }
            bb.close();
        }
    }

    public static void tileLoadVoxel(int nTile) {
        Resource buffer;
        BloodTile pic;
        if (nTile < 0 || (pic = Main.engine.getTile(nTile)).getView() != BloodTile.ViewType.kSpriteViewVoxel && pic.getView() != BloodTile.ViewType.kSpriteViewSpinVoxel) {
            return;
        }
        short nVoxel = gVoxelData[nTile];
        if (Main.game.currentDef.mdInfo.getVoxelInfo(nTile) == null && nVoxel >= 0 && nVoxel < 512 && (buffer = BuildGdx.cache.open(nVoxel, "KVX")) != null) {
            try {
                VoxelData vox = new VoxelData(buffer);
                for (int i = 0; i < vox.zpiv.length; ++i) {
                    int n = i;
                    vox.zpiv[n] = vox.zpiv[n] + (pic.getOffsetY() << 8) / (1 << i);
                }
                Main.game.currentDef.mdInfo.addVoxelInfo(new VoxelInfo(vox), nTile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            buffer.close();
        }
    }

    public static void shadeInit(String name) {
        Resource data = BuildGdx.cache.open(name, 0);
        if (data == null) {
            return;
        }
        int pos = 0;
        while (data.hasRemaining()) {
            data.read(shadeTable, pos, Math.min(shadeTable.length, data.remaining()));
            pos += shadeTable.length;
        }
        data.close();
    }

    public static void tilePreloadTile(int nTile) {
        if (nTile < 0 || nTile >= Globals.kMaxTiles) {
            return;
        }
        int view = 0;
        switch (Main.engine.getTile(nTile).getView()) {
            case kSpriteViewSingle: {
                view = 1;
                break;
            }
            case kSpriteView5Full: {
                view = 5;
                break;
            }
            case kSpriteView8Full: {
                view = 8;
                break;
            }
            case kSpriteView5Half: {
                view = 2;
                break;
            }
            case kSpriteViewVoxel: 
            case kSpriteViewSpinVoxel: {
                Tile.tileLoadVoxel(nTile);
                view = 1;
                break;
            }
        }
        while (view > 0) {
            BloodTile pic = Main.engine.getTile(nTile);
            if (pic.getType() != Tile.AnimType.None) {
                for (int i = pic.getFrames(); i >= 0; --i) {
                    if (pic.getType() == Tile.AnimType.Backward) {
                        Main.gPrecacheScreen.addTile(nTile - i);
                        continue;
                    }
                    Main.gPrecacheScreen.addTile(nTile + i);
                }
            } else {
                Main.gPrecacheScreen.addTile(nTile);
            }
            nTile += pic.getFrames() + 1;
            --view;
        }
    }
}

