/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Hud;

import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.Types.BloodTile;
import ru.m210projects.Blood.Types.Hud.HudRenderer;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;

public abstract class HudScaledRenderer
extends HudRenderer {
    protected int nScale = 65536;

    public void setScale(int nScale) {
        this.nScale = Pragmas.scale(Engine.ydim, nScale, 240L);
    }

    @Override
    public abstract void draw(PLAYER var1, int var2, int var3);

    protected float convertX(float x, int scale, Gameutils.ConvertType type) {
        if (type == Gameutils.ConvertType.AlignLeft) {
            return x * (float)scale / 65536.0f;
        }
        if (type == Gameutils.ConvertType.AlignRight) {
            return (float)Engine.xdim - (320.0f - x) * (float)scale / 65536.0f;
        }
        if (type == Gameutils.ConvertType.Normal) {
            return (float)(Engine.xdim / 2) - (160.0f - x) * (float)scale / 65536.0f;
        }
        return x;
    }

    protected float convertY(float y, int nScale) {
        return (float)Engine.ydim - (200.0f - y) * (float)nScale / 65536.0f;
    }

    protected Gameutils.ConvertType getType(int nFlags) {
        Gameutils.ConvertType type = Gameutils.ConvertType.Normal;
        if ((nFlags & 0x100) != 0) {
            type = Gameutils.ConvertType.AlignLeft;
        }
        if ((nFlags & 0x200) != 0) {
            type = Gameutils.ConvertType.AlignRight;
        }
        if ((nFlags & 0x400) != 0) {
            type = Gameutils.ConvertType.Stretch;
        }
        return type;
    }

    @Override
    public void showInventoryItems(PLAYER pPlayer, int sx, int sy, int fx, int fy, int nFlags) {
        if (pPlayer.choosedInven >= 0) {
            this.DrawStatSprite(viewInventoryTile[pPlayer.choosedInven], sx, sy, 0, 0, nFlags, this.nScale);
            this.DrawStatNumber(3, pPlayer.Inventory[pPlayer.choosedInven].amount, 2250, fx, fy, 4, 0, nFlags, this.nScale);
        }
    }

    @Override
    public void DrawStatNumber(int slen, int n, int nTile, int x, int y, int nShade, int nPLU, int nFlags, int nScale) {
        Strhandler.Bsprintf(number_buffer, slen, n, 1);
        Gameutils.ConvertType type = this.getType(nFlags);
        y = (int)(this.convertY(y, nScale) * 65536.0f);
        BloodTile pic = Main.engine.getTile(nTile);
        for (int i = 0; i < slen; ++i) {
            if (number_buffer[i] != ' ') {
                Main.engine.rotatesprite((int)(this.convertX(x, nScale, type) * 65536.0f), y, nScale, 0, nTile + number_buffer[i] - 48, nShade, nPLU, nFlags | 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            x += pic.getWidth() + 1;
        }
    }

    @Override
    public void DrawStatMaskedSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlags) {
        int nAngle = 0;
        if ((nFlags & 0x800) != 0) {
            nAngle = nAngle + 1024 & 0x7FF;
            nFlags ^= 4;
        }
        Main.engine.rotatesprite((int)(this.convertX(x, this.nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, this.nScale) * 65536.0f), this.nScale, nAngle, (short)nTile, nShade, nPLU, nFlags | 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void DrawStatMaskedSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlags, float cx1, float cy1, float cx2, float cy2) {
        int nAngle = 0;
        if ((nFlags & 0x800) != 0) {
            nAngle = nAngle + 1024 & 0x7FF;
            nFlags ^= 4;
        }
        Main.engine.rotatesprite((int)(this.convertX(x, this.nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, this.nScale) * 65536.0f), this.nScale / 2, nAngle, (short)nTile, nShade, nPLU, nFlags | 8, (int)this.convertX(cx1, this.nScale / 2, this.getType(nFlags)), (int)this.convertY(cy1, this.nScale / 2), (int)this.convertX(cx2, this.nScale / 2, this.getType(nFlags)), (int)this.convertY(cy2, this.nScale / 2));
    }

    @Override
    public void DrawStatSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlags, int nScale) {
        Main.engine.rotatesprite((int)(this.convertX(x, nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, nScale) * 65536.0f), nScale, 0, nTile, nShade, nPLU, nFlags | 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void TileHGauge(int nTile, int x, int y, int n, int total, int nFlags) {
        int nGauge = n * Main.engine.getTile(nTile).getWidth() / total;
        Main.engine.rotatesprite((int)(this.convertX(x, this.nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, this.nScale) * 65536.0f), this.nScale, 0, nTile, 0, 0, 0x18 | nFlags, 0, 0, (int)this.convertX(x + nGauge + 1, this.nScale, this.getType(nFlags)), Engine.ydim - 1);
    }

    @Override
    protected void viewDrawStats(int yoffs) {
        this.viewDrawStats((int)this.convertX(5.0f, this.nScale, Gameutils.ConvertType.AlignLeft), (int)this.convertY(160 + yoffs, this.nScale), Main.cfg.gStatSize);
    }

    @Override
    protected void viewDrawStats(int x, int y, int zoom) {
        if (Main.cfg.gShowStat == 0 || Globals.pGameInfo.nGameType >= 2 || Main.cfg.gShowStat == 2 && View.gViewMode != 4) {
            return;
        }
        zoom = Pragmas.scale(Engine.ydim, zoom, 240L);
        float viewzoom = (float)zoom / 65536.0f;
        Strhandler.Bitoa(LEVELS.kills, number_buffer);
        int alignx = Main.game.getFont(3).getWidth(number_buffer);
        int yoffset = (int)((float)(2 * (Main.game.getFont(3).getHeight() - 1)) * viewzoom);
        int statx = x;
        int staty = y -= yoffset;
        Main.game.getFont(3).drawText(statx, staty, Strings.killsstat2, zoom, 32, 7, BuildFont.TextAlign.Left, 256, false);
        statx = (int)((float)statx + 9.0f * viewzoom);
        Main.game.getFont(3).drawText(statx, staty, number_buffer, zoom, 32, 0, BuildFont.TextAlign.Left, 256, false);
        statx = (int)((float)statx + (float)(alignx + 2) * viewzoom);
        Main.game.getFont(3).drawChar(statx, staty, '/', zoom, 32, 0, 256, false);
        Strhandler.Bitoa(LEVELS.totalKills, number_buffer);
        statx = (int)((float)statx + 8.0f * viewzoom);
        Main.game.getFont(3).drawText(statx, staty, number_buffer, zoom, 32, 0, BuildFont.TextAlign.Left, 256, false);
        statx = x;
        staty = y + (int)(8.0f * viewzoom);
        Strhandler.Bitoa(LEVELS.foundSecret, number_buffer);
        alignx = Main.game.getFont(3).getWidth(number_buffer);
        Main.game.getFont(3).drawText(statx, staty, Strings.secretsstat, zoom, 32, 7, BuildFont.TextAlign.Left, 256, false);
        statx = (int)((float)statx + 9.0f * viewzoom);
        Main.game.getFont(3).drawText(statx, staty, number_buffer, zoom, 32, 0, BuildFont.TextAlign.Left, 256, false);
        statx = (int)((float)statx + (float)(alignx + 2) * viewzoom);
        Main.game.getFont(3).drawChar(statx, staty, '/', zoom, 32, 0, 256, false);
        Strhandler.Bitoa(LEVELS.totalSecrets, number_buffer);
        statx = (int)((float)statx + 8.0f * viewzoom);
        Main.game.getFont(3).drawText(statx, staty, number_buffer, zoom, 32, 0, BuildFont.TextAlign.Left, 256, false);
    }
}

