/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.QAV;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.QAVCALLBACKFUNC;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.TeslaData;
import ru.m210projects.Blood.Types.WEAPONDATA;
import ru.m210projects.Blood.Types.WeaponAim;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class Weapon {
    public static final int kWeaponMax = 14;
    public static final int kFindWeapon = -1;
    public static final int kQAVEnd = 126;
    public static final int kQAVEnd100 = 118;
    public static final int kQAVSprayDown = 125;
    public static final int kQAVForkUp = 0;
    public static final int kQAVForkIdle = 1;
    public static final int kQAVForkStab = 2;
    public static final int kQAVForkDown = 3;
    public static final int kQAVFlareUp = 41;
    public static final int kQAVFlareIdle = 42;
    public static final int kQAVFlareFire = 43;
    public static final int kQAVFlareDown = 44;
    public static final int kQAV2FlareUp = 45;
    public static final int kQAV2FlareIdle = 46;
    public static final int kQAV2FlareFire1 = 47;
    public static final int kQAV2FlareFire2 = 48;
    public static final int kQAV2FlareDown = 49;
    public static final int kQAVShotgunUp = 50;
    public static final int kQAVShotgunIdle3 = 51;
    public static final int kQAVShotgunIdle2 = 52;
    public static final int kQAVShotgunIdle1 = 53;
    public static final int kQAVShotgunFire1 = 54;
    public static final int kQAVShotgunFire2 = 55;
    public static final int kQAVShotgunFire3 = 56;
    public static final int kQAVShotgunReload = 57;
    public static final int kQAVShotgunDown = 58;
    public static final int kQAV2ShotgunUp = 59;
    public static final int kQAV2ShotgunIdle = 60;
    public static final int kQAV2ShotgunFire2 = 61;
    public static final int kQAV2ShotgunFire1 = 62;
    public static final int kQAV2ShotgunDown = 63;
    public static final int kQAVTommygunUp = 64;
    public static final int kQAVTommygunIdle = 65;
    public static final int kQAVTommygunFire = 66;
    public static final int kQAVTommygunFire2 = 67;
    public static final int kQAVTommygunDown = 68;
    public static final int kQAV2TommygunUp = 69;
    public static final int kQAV2TommygunIdle = 70;
    public static final int kQAV2TommygunFire = 71;
    public static final int kQAV2TommygunDown = 72;
    public static final int kQAV2TommygunFire2 = 73;
    public static final WEAPONDATA[] gWeaponInfo = new WEAPONDATA[]{new WEAPONDATA(0, -1), new WEAPONDATA(1, -1), new WEAPONDATA(1, 1), new WEAPONDATA(1, 2), new WEAPONDATA(1, 3), new WEAPONDATA(1, 4), new WEAPONDATA(1, 5), new WEAPONDATA(1, 6), new WEAPONDATA(1, 7), new WEAPONDATA(1, 8), new WEAPONDATA(1, 9), new WEAPONDATA(1, 10), new WEAPONDATA(1, 11), new WEAPONDATA(0, -1)};
    public static final int[] gNextWeapon = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 1};
    public static final int[] gPrevWeapon = new int[]{12, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 1};
    public static final int[] defaultOrder = new int[]{3, 4, 2, 8, 9, 10, 7, 1, 1, 1, 1, 1, 1, 1};
    public static final boolean[][] pWeapUpgrade = new boolean[][]{{false, true, true, true, true, true, true, true, true, true, true, true, true}, {false, true, true, true, true, true, true, true, true, true, true, true, true}, {false, false, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, true, false, false, false, false, false, false, false}, {false, false, true, true, true, false, true, false, false, false, false, false, false}, {false, false, true, true, true, false, false, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false}, {false, false, false, true, true, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true}};
    public static final int kMaxClients = 64;
    public static final int kAimMaxDist = Gameutils.M2X(100.0);
    public static final int kAimMaxSlope = 9460;
    public static WeaponAim[] gWeaponAimData = new WeaponAim[]{new WeaponAim(0, 0, 0, 0, 0), new WeaponAim(24576, 24576, 113, 85, 0x111111), new WeaponAim(32768, 32768, 113, 85, 0x2AAAAA), new WeaponAim(65536, 65536, 56, 28, 0), new WeaponAim(24576, 32768, 56, 28, 0), new WeaponAim(24576, 24576, 56, 28, 0x2AAAAA), new WeaponAim(24576, 24576, 113, 85, 0), new WeaponAim(24576, 24576, 113, 56, 0), new WeaponAim(32768, 65536, 113, 85, 0x255555), new WeaponAim(65536, 65536, 113, 0, 0), new WeaponAim(65536, 65536, 170, 0, 0), new WeaponAim(24576, 24576, 113, 85, 0), new WeaponAim(24576, 24576, 113, 85, 0), new WeaponAim(24576, 24576, 113, 85, 0)};
    public static int[] gVoodooData = new int[]{40960, 49152, 57344, 65536};
    public static final TeslaData[] gTeslaData = new TeslaData[]{new TeslaData(0, 306, 1, 470, 20, 1), new TeslaData(-140, 306, 1, 470, 30, 1), new TeslaData(140, 306, 1, 470, 30, 1), new TeslaData(0, 302, 35, 471, 40, 1), new TeslaData(-140, 302, 35, 471, 50, 1), new TeslaData(140, 302, 35, 471, 50, 1)};
    public static QAVCALLBACKFUNC[] gWeaponCallback = new QAVCALLBACKFUNC[]{new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FirePitchfork(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireSpray(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.ThrowSpray(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.DropSpray(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.ExplodeSpray(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.ThrowBundle(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.DropBundle(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.ExplodeBundle(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.ThrowProxy(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.DropProxy(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.ThrowRemote(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.DropRemote(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireRemote(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireShotgun(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.ShotgunReload(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireTommy(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireTommy2(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireATommy2(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireFlare(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireFlare2(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireVoodoo(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireVoodoo2(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireTesla_100(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            if (VERSION.GAMEVER == 0) {
                Weapon.FireTesla2_100(triggerId, (PLAYER)data);
            } else {
                Weapon.FireTesla121(triggerId, (PLAYER)data);
            }
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireNapalm(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireNapalm2(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireLeech(triggerId, (PLAYER)data);
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            System.out.println("weaponCallback 27");
        }
    }, new QAVCALLBACKFUNC(){

        @Override
        public void run(int triggerId, Object data) {
            Weapon.FireBeast(triggerId, (PLAYER)data);
        }
    }};
    public static int FindLoaded = 0;
    public static final int kSlopeThrow = -9460;
    public static final int kMinThrowVel = 419430;
    public static final int kMaxThrowVel = 0x1DDDDD;
    public static final int kMaxShotgunBarrels = 4;
    public static final int kVectorsPerBarrel = 16;
    public static final int kMaxSpread = 14;
    public static final int kVoodooStabChest = 0;
    public static final int kVoodooStabShoulder = 1;
    public static final int kVoodooStabEye = 2;
    public static final int kVoodooStabGroin = 3;
    public static final int kVoodooStabSelf = 4;

    public static void InitSprayFix(int nSprayId) {
        Resource hQAV = BuildGdx.cache.open(nSprayId, "QAV");
        if (hQAV != null) {
            PLAYER.weaponQAVs[nSprayId] = new QAV(hQAV);
            hQAV.close();
        }
    }

    public static void WeaponInit() {
        for (int i = 0; i < 126; ++i) {
            if (VERSION.GAMEVER == 0 && i >= 118) {
                return;
            }
            Resource hQAV = BuildGdx.cache.open(i, "QAV");
            if (hQAV == null) {
                System.err.println("Could not load weapon " + i + ".QAV");
                continue;
            }
            PLAYER.weaponQAVs[i] = new QAV(hQAV);
            hQAV.close();
        }
        Weapon.InitSprayFix(125);
    }

    public static int WeaponUpgrade(PLAYER pPlayer, int nWeapon) {
        int out = pPlayer.currentWeapon;
        if (!Weapon.checkFired6or7(pPlayer) && pWeapUpgrade[pPlayer.currentWeapon][nWeapon]) {
            out = nWeapon;
        }
        return out;
    }

    public static boolean CheckNewWeapon(PLAYER pPlayer, int nWeapon, int nAmmo, int minAmmo) {
        if (Globals.gInfiniteAmmo) {
            return true;
        }
        if (nAmmo == -1) {
            return true;
        }
        if (nWeapon != 12 || pPlayer.weaponAmmo != 11 || pPlayer.weaponState != 11) {
            if (nWeapon == 9 && pPlayer.pXsprite.health != 0) {
                return true;
            }
            return pPlayer.ammoCount[nAmmo] >= minAmmo;
        }
        return true;
    }

    public static boolean CheckAmmo2(PLAYER pPlayer, int nAmmo, int minAmmo) {
        if (Globals.gInfiniteAmmo) {
            return true;
        }
        if (nAmmo == -1) {
            return true;
        }
        return pPlayer.ammoCount[nAmmo] >= minAmmo;
    }

    public static boolean CheckAmmo(PLAYER pPlayer, int nAmmo, int minAmmo) {
        if (Globals.gInfiniteAmmo) {
            return true;
        }
        if (nAmmo == -1) {
            return true;
        }
        if (pPlayer.currentWeapon != 12 || pPlayer.weaponAmmo != 11 || pPlayer.weaponState != 11) {
            if (pPlayer.currentWeapon == 9 && pPlayer.pXsprite.health != 0) {
                return true;
            }
            return pPlayer.ammoCount[nAmmo] >= minAmmo;
        }
        return true;
    }

    public static int ProxyProcess(PLAYER pPlayer) {
        if (pPlayer.weaponState == 9) {
            pPlayer.throwTime = Gameutils.ClipHigh(Pragmas.divscale(Globals.gFrameClock - pPlayer.fireClock, 240L, 16), 65536);
            if (!pPlayer.pInput.Shoot) {
                pPlayer.weaponState = 8;
                Weapon.StartQAV(pPlayer, 29, 8, false);
            }
            return 1;
        }
        return 0;
    }

    public static int RemoteProcess(PLAYER pPlayer) {
        if (pPlayer.weaponState == 13) {
            pPlayer.throwTime = Gameutils.ClipHigh(Pragmas.divscale(Globals.gFrameClock - pPlayer.fireClock, 240L, 16), 65536);
            if (!pPlayer.pInput.Shoot) {
                pPlayer.weaponState = 11;
                Weapon.StartQAV(pPlayer, 39, 10, false);
            }
            return 1;
        }
        return 0;
    }

    public static int TeslaProcess(PLAYER pPlayer) {
        if (pPlayer.weaponState < 5) {
            if (pPlayer.weaponState == 4) {
                pPlayer.weaponState = 5;
                if (VERSION.GAMEVER != 0) {
                    if (Weapon.CheckAmmo2(pPlayer, 7, 10) && PLAYER.powerupCheck(pPlayer, 17) != 0) {
                        Weapon.StartQAV(pPlayer, 84, 23, true);
                    } else {
                        Weapon.StartQAV(pPlayer, 77, 23, true);
                    }
                } else {
                    Weapon.StartQAV(pPlayer, 77, 22, true);
                }
                return 1;
            }
            return 0;
        }
        if (pPlayer.weaponState == 7 || !pPlayer.pInput.Shoot && pPlayer.weaponState == 5) {
            pPlayer.weaponState = 2;
            if (VERSION.GAMEVER != 0 && Weapon.CheckAmmo2(pPlayer, 7, 10) && PLAYER.powerupCheck(pPlayer, 17) != 0) {
                Weapon.StartQAV(pPlayer, 87, -1, false);
            } else {
                Weapon.StartQAV(pPlayer, 80, -1, false);
            }
            return 1;
        }
        return 0;
    }

    public static int LeachProcess(PLAYER pPlayer) {
        if (pPlayer.weaponState < 6) {
            if (pPlayer.weaponState == 4) {
                pPlayer.weaponState = 6;
                Weapon.StartQAV(pPlayer, VERSION.getQAV(16), 26, true);
                return 1;
            }
            return 0;
        }
        if (pPlayer.weaponState > 6) {
            if (pPlayer.weaponState != 8) {
                return 0;
            }
            pPlayer.weaponState = 2;
            Weapon.StartQAV(pPlayer, VERSION.getQAV(18), -1, false);
            return 1;
        }
        if (!pPlayer.pInput.AltShoot) {
            pPlayer.weaponState = 2;
            Weapon.StartQAV(pPlayer, VERSION.getQAV(18), -1, false);
            return 1;
        }
        return 0;
    }

    public static int TNTProcess(PLAYER pPlayer) {
        int nState = pPlayer.weaponState;
        if (nState < 5) {
            if (nState != 4) {
                return 0;
            }
            if (!pPlayer.pInput.AltShoot) {
                pPlayer.weaponState = 5;
            }
            return 1;
        }
        if (nState == 5) {
            if (pPlayer.pInput.AltShoot) {
                pPlayer.weaponState = 1;
                pPlayer.fuseTime = pPlayer.weaponTimer;
                Weapon.StartQAV(pPlayer, 22, 6, false);
            } else if (pPlayer.pInput.Shoot) {
                pPlayer.weaponState = 6;
                pPlayer.fuseTime = 0;
                pPlayer.fireClock = Globals.gFrameClock;
            }
            return 1;
        }
        if (nState != 6) {
            return 0;
        }
        pPlayer.throwTime = Gameutils.ClipHigh(Pragmas.divscale(Globals.gFrameClock - pPlayer.fireClock, 240L, 16), 65536);
        if (!pPlayer.pInput.Shoot) {
            if (pPlayer.fuseTime == 0) {
                pPlayer.fuseTime = pPlayer.weaponTimer;
            }
            pPlayer.weaponState = 1;
            Weapon.StartQAV(pPlayer, 23, 5, false);
        }
        return 1;
    }

    public static int SprayProcess(PLAYER pPlayer) {
        int nState = pPlayer.weaponState;
        if (nState < 6) {
            if (nState != 5) {
                return 0;
            }
            if (!pPlayer.pInput.AltShoot) {
                pPlayer.weaponState = 6;
            }
            return 1;
        }
        if (nState == 6) {
            if (pPlayer.pInput.AltShoot) {
                pPlayer.weaponState = 3;
                pPlayer.fuseTime = pPlayer.weaponTimer;
                Weapon.StartQAV(pPlayer, 13, 3, false);
            } else if (pPlayer.pInput.Shoot) {
                pPlayer.weaponState = 7;
                pPlayer.fuseTime = 0;
                pPlayer.fireClock = Globals.gFrameClock;
            }
            return 1;
        }
        if (nState != 7) {
            return 0;
        }
        pPlayer.throwTime = Gameutils.ClipHigh(Pragmas.divscale(Globals.gFrameClock - pPlayer.fireClock, 240L, 16), 65536);
        if (!pPlayer.pInput.Shoot) {
            if (pPlayer.fuseTime == 0) {
                pPlayer.fuseTime = pPlayer.weaponTimer;
            }
            pPlayer.weaponState = 1;
            Weapon.StartQAV(pPlayer, 14, 2, false);
        }
        return 1;
    }

    public static int WeaponChange(PLAYER pPlayer, boolean next) {
        int weap = pPlayer.currentWeapon;
        do {
            weap = next ? gNextWeapon[weap] : gPrevWeapon[weap];
            if (pPlayer.Underwater) {
                while (weap == 6 || weap == 7) {
                    if (next) {
                        weap = gNextWeapon[weap];
                        continue;
                    }
                    weap = gPrevWeapon[weap];
                }
            }
            if (Weapon.gWeaponInfo[weap].update == 0 || !pPlayer.hasWeapon[weap]) continue;
            int ammoType = Weapon.gWeaponInfo[weap].ammoType;
            if (weap != 10 ? Weapon.CheckAmmo2(pPlayer, ammoType, 1) : Weapon.CheckAmmo(pPlayer, ammoType, 1)) break;
        } while (pPlayer.currentWeapon != weap);
        if (!(pPlayer.currentWeapon != weap || Weapon.gWeaponInfo[weap].update != 0 && Weapon.CheckAmmo(pPlayer, Weapon.gWeaponInfo[weap].ammoType, 1))) {
            return 1;
        }
        return weap;
    }

    public static void UpdateAimVector(PLAYER pPlayer) {
        boolean autoAim;
        if (pPlayer == null) {
            Main.game.dassert("pPlayer != NULL");
        }
        SPRITE pSprite = pPlayer.pSprite;
        int x = pSprite.x;
        int y = pSprite.y;
        int z = pPlayer.weaponAboveZ;
        int ax = Trig.Cos(pSprite.ang) >> 16;
        int ay = Trig.Sin(pSprite.ang) >> 16;
        int az = (int)pPlayer.horizOff;
        WeaponAim pAimData = gWeaponAimData[pPlayer.currentWeapon];
        int nAimSprite = -1;
        pPlayer.aimCount = 0;
        boolean bl = autoAim = Main.game.net.gProfile[pPlayer.nPlayer].autoaim || pPlayer.currentWeapon == 10 || pPlayer.currentWeapon == 9 || DEMO.IsOriginalDemo();
        if (autoAim) {
            int dist2;
            short ang;
            int z2;
            int z1;
            int dy;
            int dx;
            int dist;
            int tz;
            int ty;
            int tx;
            SPRITE pTarget;
            int closest = Integer.MAX_VALUE;
            int nTarget = Engine.headspritestat[6];
            while (nTarget >= 0) {
                pTarget = Engine.sprite[nTarget];
                if (!(pTarget == pSprite || !DEMO.IsOriginalDemo() && Gameutils.IsPlayerSprite(pTarget) && Globals.pGameInfo.nFriendlyFire == 0 && (Globals.pGameInfo.nGameType == 1 || Globals.pGameInfo.nGameType == 3 && pPlayer.teamID == Globals.gPlayer[pTarget.lotag - 231].teamID) || (pTarget.hitag & 0x20) != 0 || (!DEMO.IsOriginalDemo() ? (pTarget.hitag & 8) == 0 && pTarget.lotag != 213 && pTarget.lotag != 214 && pTarget.lotag != 215 : (pTarget.hitag & 8) == 0))) {
                    tx = pTarget.x;
                    ty = pTarget.y;
                    tz = pTarget.z;
                    dist = (int)Main.engine.qdist(tx - x, ty - y);
                    if (dist != 0 && dist <= kAimMaxDist) {
                        if (pAimData.kSeeker != 0) {
                            int kSeek = (dist << 12) / pAimData.kSeeker;
                            tx = (int)((long)tx + ((long)kSeek * Actor.sprXVel[nTarget] >> 12));
                            ty = (int)((long)ty + ((long)kSeek * Actor.sprYVel[nTarget] >> 12));
                            tz = (int)((long)tz + ((long)kSeek * Actor.sprZVel[nTarget] >> 8));
                        }
                        dx = Pragmas.mulscale(dist, Trig.Cos(pSprite.ang), 30) + x;
                        dy = Pragmas.mulscale(dist, Trig.Sin(pSprite.ang), 30) + y;
                        z1 = Pragmas.mulscale(dist, (int)pPlayer.horizOff, 10) + z;
                        z2 = Pragmas.mulscale(9460L, dist, 10);
                        Gameutils.GetSpriteExtents(pTarget);
                        if (z1 - z2 <= Gameutils.extents_zBot && z1 + z2 >= Gameutils.extents_zTop && Pragmas.klabs(((ang = Main.engine.getangle(tx - x, ty - y)) - pSprite.ang + 1024 & 0x7FF) - 1024) <= pAimData.kDudeAngle) {
                            if (pPlayer.aimCount < 16 && Main.engine.cansee(x, y, z, pSprite.sectnum, tx, ty, tz, pTarget.sectnum)) {
                                pPlayer.aimSprites[pPlayer.aimCount++] = nTarget;
                            }
                            if ((dist2 = Main.engine.ksqrt((dx - tx >> 4) * (dx - tx >> 4) + (dy - ty >> 4) * (dy - ty >> 4) + (z1 - tz >> 8) * (z1 - tz >> 8))) < closest) {
                                int dz = tz - 4 * DudeInfo.dudeInfo[pTarget.lotag - 200].aimHeight * pTarget.yrepeat - z;
                                if (Main.engine.cansee(x, y, z, pSprite.sectnum, tx, ty, tz, pTarget.sectnum)) {
                                    closest = dist2;
                                    ax = Trig.Cos(ang) >> 16;
                                    ay = Trig.Sin(ang) >> 16;
                                    az = Pragmas.divscale(dz, dist, 10);
                                    nAimSprite = nTarget;
                                }
                            }
                        }
                    }
                }
                nTarget = Engine.nextspritestat[nTarget];
            }
            if (pAimData.kThingAngle > 0) {
                nTarget = Engine.headspritestat[4];
                while (nTarget >= 0) {
                    pTarget = Engine.sprite[nTarget];
                    if ((pTarget.hitag & 8) != 0) {
                        tx = pTarget.x;
                        ty = pTarget.y;
                        tz = pTarget.z;
                        dist = (int)Main.engine.qdist(tx - x, ty - y);
                        if (dist != 0 && dist <= kAimMaxDist) {
                            dx = Pragmas.mulscale(dist, Trig.Cos(pSprite.ang), 30) + x;
                            dy = Pragmas.mulscale(dist, Trig.Sin(pSprite.ang), 30) + y;
                            z1 = Pragmas.mulscale(dist, (int)pPlayer.horizOff, 10) + z;
                            z2 = Pragmas.mulscale(9460L, dist, 10);
                            Gameutils.GetSpriteExtents(pTarget);
                            if (z1 - z2 <= Gameutils.extents_zBot && z1 + z2 >= Gameutils.extents_zTop && Pragmas.klabs(((ang = Main.engine.getangle(tx - x, ty - y)) - pSprite.ang + 1024 & 0x7FF) - 1024) <= pAimData.kThingAngle) {
                                if (pPlayer.aimCount < 16 && Main.engine.cansee(x, y, z, pSprite.sectnum, tx, ty, tz, pTarget.sectnum)) {
                                    pPlayer.aimSprites[pPlayer.aimCount++] = nTarget;
                                }
                                if ((dist2 = Main.engine.ksqrt((dx - tx >> 4) * (dx - tx >> 4) + (dy - ty >> 4) * (dy - ty >> 4) + (z1 - tz >> 8) * (z1 - tz >> 8))) < closest && Main.engine.cansee(x, y, z, pSprite.sectnum, tx, ty, tz, pTarget.sectnum)) {
                                    closest = dist2;
                                    ax = Trig.Cos(ang) >> 16;
                                    ay = Trig.Sin(ang) >> 16;
                                    az = Pragmas.divscale(tz - z, dist, 10);
                                    nAimSprite = nTarget;
                                }
                            }
                        }
                    }
                    nTarget = Engine.nextspritestat[nTarget];
                }
            }
        }
        Trig.RotateVector(ax, ay, -pSprite.ang);
        ax = (int)Trig.rotated.x;
        ay = (int)Trig.rotated.y;
        az = (int)((float)az - pPlayer.horizOff);
        pPlayer.relAim.x += (float)Pragmas.mulscale((int)((float)ax - pPlayer.relAim.x), pAimData.kTrackXYRate, 16);
        pPlayer.relAim.y += (float)Pragmas.mulscale((int)((float)ay - pPlayer.relAim.y), pAimData.kTrackXYRate, 16);
        pPlayer.relAim.z += (float)Pragmas.mulscale((int)((float)az - pPlayer.relAim.z), pAimData.kTrackZRate, 16);
        pPlayer.aim.set(pPlayer.relAim);
        Trig.RotateVector((int)pPlayer.aim.x, (int)pPlayer.aim.y, pSprite.ang);
        pPlayer.aim.x = Trig.rotated.x;
        pPlayer.aim.y = Trig.rotated.y;
        pPlayer.aim.z += pPlayer.horizOff;
        if (PLAYER.newHoriz && !DEMO.IsOriginalDemo() && Main.game.net.gProfile[pPlayer.nPlayer].slopetilt && (!Main.game.net.gProfile[pPlayer.nPlayer].autoaim || nAimSprite < 0)) {
            pPlayer.aim.z -= (float)(120 * pPlayer.slope);
        }
        pPlayer.nAimSprite = nAimSprite;
    }

    public static boolean checkFired6or7(PLAYER pPlayer) {
        switch (pPlayer.currentWeapon) {
            case 6: {
                if (pPlayer.weaponState != 4 && pPlayer.weaponState != 5 && pPlayer.weaponState != 6) break;
                return true;
            }
            case 7: {
                if (pPlayer.weaponState != 5 && pPlayer.weaponState != 6) break;
                return true;
            }
        }
        return false;
    }

    public static void WeaponProcess(PLAYER pPlayer) {
        int wnum;
        if (!DEMO.IsOriginalDemo()) {
            if (!Weapon.weaponIdle(pPlayer)) {
                pPlayer.pInput.NextWeapon = false;
                pPlayer.pInput.PrevWeapon = false;
            }
            if (Actor.gTNTCount >= 512 && pPlayer.currentWeapon == 12 && pPlayer.weaponState == 10) {
                pPlayer.weaponState = 11;
                Weapon.StartQAV(pPlayer, 32, -1, false);
            }
        }
        if (pPlayer.fireEffect != 0) {
            --pPlayer.fireEffect;
        }
        if (pPlayer.pXsprite.health == 0) {
            pPlayer.fLoopQAV = false;
            SOUND.sfxKill3DSound(pPlayer.pSprite, 1, -1);
        }
        if (pPlayer.Underwater && (pPlayer.currentWeapon == 7 || pPlayer.currentWeapon == 6)) {
            if (Weapon.checkFired6or7(pPlayer)) {
                if (pPlayer.currentWeapon == 7) {
                    pPlayer.fuseTime = pPlayer.weaponTimer;
                    Weapon.DropSpray(1, pPlayer);
                    pPlayer.weaponState = 3;
                } else if (pPlayer.currentWeapon == 6) {
                    pPlayer.fuseTime = pPlayer.weaponTimer;
                    Weapon.DropBundle(1, pPlayer);
                    pPlayer.weaponState = 1;
                }
            }
            Weapon.WeaponLower(pPlayer);
            pPlayer.throwTime = 0;
        }
        Weapon.WeaponPlay(pPlayer);
        Weapon.UpdateAimVector(pPlayer);
        pPlayer.weaponTimer -= Globals.kFrameTicks;
        if (pPlayer.fLoopQAV && pPlayer.pXsprite.health != 0) {
            if (pPlayer.pInput.Shoot && Weapon.CheckAmmo(pPlayer, pPlayer.weaponAmmo, 1)) {
                while (pPlayer.weaponTimer <= 0) {
                    pPlayer.weaponTimer += PLAYER.weaponQAVs[pPlayer.pWeaponQAV].duration;
                }
            } else {
                pPlayer.weaponTimer = 0;
                pPlayer.fLoopQAV = false;
            }
            return;
        }
        pPlayer.weaponTimer = Gameutils.ClipLow(pPlayer.weaponTimer, 0);
        switch (pPlayer.currentWeapon) {
            case 7: {
                if (Weapon.SprayProcess(pPlayer) == 0) break;
                return;
            }
            case 6: {
                if (Weapon.TNTProcess(pPlayer) == 0) break;
                return;
            }
            case 11: {
                if (Weapon.ProxyProcess(pPlayer) == 0) break;
                return;
            }
            case 12: {
                if (Weapon.RemoteProcess(pPlayer) == 0) break;
                return;
            }
        }
        if (pPlayer.weaponTimer > 0) {
            return;
        }
        if (pPlayer.pXsprite.health == 0 || pPlayer.currentWeapon == 0) {
            pPlayer.pWeaponQAV = -1;
        }
        if (pPlayer.currentWeapon == 8 && Weapon.TeslaProcess(pPlayer) != 0) {
            return;
        }
        if (pPlayer.currentWeapon == 9 && Weapon.LeachProcess(pPlayer) != 0) {
            return;
        }
        if (pPlayer.updateWeapon != 0) {
            SOUND.sfxKill3DSound(pPlayer.pSprite, -1, 441);
            pPlayer.pInput.newWeapon = pPlayer.updateWeapon;
            pPlayer.weaponState = 0;
            pPlayer.updateWeapon = 0;
        }
        if (pPlayer.pInput.NextWeapon) {
            pPlayer.pInput.NextWeapon = false;
            pPlayer.weaponState = 0;
            pPlayer.updateWeapon = 0;
            wnum = Weapon.WeaponChange(pPlayer, true);
            pPlayer.weaponMode[wnum] = 0;
            if (pPlayer.currentWeapon != 0) {
                if (!(DEMO.IsOriginalDemo() || wnum != 6 && wnum != 7)) {
                    pPlayer.pInput.newWeapon = wnum;
                    Weapon.WeaponLower(pPlayer);
                } else {
                    Weapon.WeaponLower(pPlayer);
                    pPlayer.updateWeapon = wnum;
                }
                return;
            }
            pPlayer.pInput.newWeapon = wnum;
        }
        if (pPlayer.pInput.PrevWeapon) {
            pPlayer.pInput.PrevWeapon = false;
            pPlayer.weaponState = 0;
            pPlayer.updateWeapon = 0;
            wnum = Weapon.WeaponChange(pPlayer, false);
            pPlayer.weaponMode[wnum] = 0;
            if (pPlayer.currentWeapon != 0) {
                if (!(DEMO.IsOriginalDemo() || wnum != 6 && wnum != 7)) {
                    pPlayer.pInput.newWeapon = wnum;
                    Weapon.WeaponLower(pPlayer);
                } else {
                    Weapon.WeaponLower(pPlayer);
                    pPlayer.updateWeapon = wnum;
                }
                return;
            }
            pPlayer.pInput.newWeapon = wnum;
        }
        if (pPlayer.weaponState == -1) {
            pPlayer.weaponState = 0;
            int weap = Weapon.WeaponFindLoaded(pPlayer, true);
            pPlayer.weaponMode[weap] = FindLoaded;
            if (pPlayer.currentWeapon != 0) {
                Weapon.WeaponLower(pPlayer);
                pPlayer.updateWeapon = weap;
                return;
            }
            pPlayer.pInput.newWeapon = weap;
        }
        if (pPlayer.pInput.newWeapon != 0) {
            if (pPlayer.pInput.newWeapon == 6) {
                switch (pPlayer.currentWeapon) {
                    case 6: {
                        if (Weapon.CheckAmmo2(pPlayer, 10, 1)) {
                            pPlayer.pInput.newWeapon = 11;
                            break;
                        }
                        if (!Weapon.CheckAmmo2(pPlayer, 11, 1)) break;
                        pPlayer.pInput.newWeapon = 12;
                        break;
                    }
                    case 11: {
                        if (Weapon.CheckAmmo2(pPlayer, 11, 1)) {
                            pPlayer.pInput.newWeapon = 12;
                            break;
                        }
                        if (!Weapon.CheckAmmo2(pPlayer, 5, 1) || pPlayer.Underwater) break;
                        pPlayer.pInput.newWeapon = 6;
                        break;
                    }
                    case 12: {
                        if (Weapon.CheckAmmo2(pPlayer, 5, 1) && !pPlayer.Underwater) {
                            pPlayer.pInput.newWeapon = 6;
                            break;
                        }
                        if (!Weapon.CheckAmmo2(pPlayer, 10, 1)) break;
                        pPlayer.pInput.newWeapon = 11;
                        break;
                    }
                    default: {
                        if (Weapon.CheckAmmo2(pPlayer, 5, 1) && !pPlayer.Underwater) {
                            pPlayer.pInput.newWeapon = 6;
                            break;
                        }
                        if (Weapon.CheckAmmo2(pPlayer, 10, 1)) {
                            pPlayer.pInput.newWeapon = 11;
                            break;
                        }
                        if (!Weapon.CheckAmmo2(pPlayer, 11, 1)) break;
                        pPlayer.pInput.newWeapon = 12;
                    }
                }
            }
            if (pPlayer.pXsprite.health == 0 || !pPlayer.hasWeapon[pPlayer.pInput.newWeapon]) {
                pPlayer.pInput.newWeapon = 0;
                return;
            }
            if (pPlayer.Underwater && (pPlayer.pInput.newWeapon == 7 || pPlayer.pInput.newWeapon == 6) && !Weapon.checkFired6or7(pPlayer)) {
                pPlayer.pInput.newWeapon = 0;
                return;
            }
            if (pPlayer.currentWeapon != 0) {
                if (pPlayer.pInput.newWeapon != pPlayer.currentWeapon || Weapon.gWeaponInfo[pPlayer.pInput.newWeapon].update > 1) {
                    int i = 0;
                    if (pPlayer.pInput.newWeapon == pPlayer.currentWeapon) {
                        i = 1;
                    }
                    pPlayer.LastWeapon = pPlayer.currentWeapon;
                    while (i <= Weapon.gWeaponInfo[pPlayer.pInput.newWeapon].update) {
                        int upd = (i + pPlayer.weaponMode[pPlayer.pInput.newWeapon]) % Weapon.gWeaponInfo[pPlayer.pInput.newWeapon].update;
                        int nType = Weapon.gWeaponInfo[pPlayer.pInput.newWeapon].ammoType;
                        if (Weapon.CheckNewWeapon(pPlayer, pPlayer.pInput.newWeapon, nType, 1)) {
                            Weapon.WeaponLower(pPlayer);
                            pPlayer.weaponMode[pPlayer.pInput.newWeapon] = upd;
                            return;
                        }
                        ++i;
                    }
                }
            } else {
                int nAmmo = Weapon.gWeaponInfo[pPlayer.pInput.newWeapon].ammoType;
                if (Weapon.gWeaponInfo[pPlayer.pInput.newWeapon].update <= 1) {
                    if (Weapon.CheckNewWeapon(pPlayer, pPlayer.pInput.newWeapon, nAmmo, 1)) {
                        Weapon.WeaponRaise(pPlayer);
                    } else {
                        pPlayer.weaponState = 0;
                        int found = Weapon.WeaponFindLoaded(pPlayer, true);
                        pPlayer.weaponMode[found] = FindLoaded;
                        if (pPlayer.currentWeapon != 0) {
                            Weapon.WeaponLower(pPlayer);
                            pPlayer.updateWeapon = found;
                        } else {
                            pPlayer.pInput.newWeapon = found;
                        }
                    }
                    return;
                }
                if (Weapon.CheckAmmo(pPlayer, Weapon.gWeaponInfo[pPlayer.pInput.newWeapon].ammoType, 1) || nAmmo == 11) {
                    Weapon.WeaponRaise(pPlayer);
                }
            }
            pPlayer.pInput.newWeapon = 0;
            return;
        }
        if (pPlayer.currentWeapon != 0 && !Weapon.CheckAmmo(pPlayer, pPlayer.weaponAmmo, 1) && pPlayer.weaponAmmo != 11) {
            pPlayer.weaponState = -1;
            return;
        }
        if (pPlayer.pInput.Shoot) {
            switch (pPlayer.currentWeapon) {
                case 1: {
                    Weapon.StartQAV(pPlayer, 2, 0, false);
                    return;
                }
                case 2: {
                    if (PLAYER.powerupCheck(pPlayer, 17) != 0 && Weapon.CheckAmmo2(pPlayer, 1, 2)) {
                        Weapon.StartQAV(pPlayer, 48, 18, false);
                    } else {
                        Weapon.StartQAV(pPlayer, 43, 18, false);
                    }
                    return;
                }
                case 3: {
                    if (pPlayer.weaponState == 2) {
                        pPlayer.weaponState = 1;
                        Weapon.StartQAV(pPlayer, 55, 13, false);
                        return;
                    }
                    if (pPlayer.weaponState == 3) {
                        pPlayer.weaponState = 2;
                        Weapon.StartQAV(pPlayer, 54, 13, false);
                        return;
                    }
                    if (pPlayer.weaponState != 7) break;
                    pPlayer.weaponState = 6;
                    Weapon.StartQAV(pPlayer, 61, 13, false);
                    return;
                }
                case 6: {
                    if (pPlayer.weaponState != 3) break;
                    pPlayer.weaponState = 6;
                    pPlayer.fuseTime = -1;
                    pPlayer.fireClock = Globals.gFrameClock;
                    Weapon.StartQAV(pPlayer, 21, 7, false);
                    return;
                }
                case 7: {
                    if (pPlayer.weaponState != 3) break;
                    pPlayer.weaponState = 4;
                    Weapon.StartQAV(pPlayer, 10, 1, true);
                    return;
                }
                case 11: {
                    if (pPlayer.weaponState != 7) break;
                    pPlayer.pWeaponQAV = 27;
                    pPlayer.weaponState = 9;
                    pPlayer.fireClock = Globals.gFrameClock;
                    return;
                }
                case 12: {
                    if (pPlayer.weaponState == 10) {
                        pPlayer.pWeaponQAV = 36;
                        pPlayer.weaponState = 13;
                        pPlayer.fireClock = Globals.gFrameClock;
                        return;
                    }
                    if (pPlayer.weaponState != 11) break;
                    pPlayer.weaponState = 12;
                    Weapon.StartQAV(pPlayer, 40, 12, false);
                    return;
                }
                case 4: {
                    if (PLAYER.powerupCheck(pPlayer, 17) != 0 && Weapon.CheckAmmo2(pPlayer, 3, 2)) {
                        Weapon.StartQAV(pPlayer, 71, 15, true);
                    } else {
                        Weapon.StartQAV(pPlayer, 66, 15, true);
                    }
                    return;
                }
                case 10: {
                    int voodooChance = 2 * Gameutils.bRandom();
                    int nStabType = 0;
                    while (voodooChance > gVoodooData[nStabType]) {
                        ++nStabType;
                    }
                    pPlayer.voodooTarget = pPlayer.nAimSprite;
                    if (pPlayer.voodooTarget == -1 || Engine.sprite[pPlayer.voodooTarget].statnum != 6) {
                        nStabType = 4;
                    }
                    Weapon.StartQAV(pPlayer, nStabType + VERSION.getQAV(11), 20, false);
                    return;
                }
                case 8: {
                    if (VERSION.GAMEVER != 0) {
                        if (pPlayer.weaponState == 2) {
                            pPlayer.weaponState = 4;
                            if (Weapon.CheckAmmo2(pPlayer, 7, 10) && PLAYER.powerupCheck(pPlayer, 17) != 0) {
                                Weapon.StartQAV(pPlayer, 84, 23, false);
                            } else {
                                Weapon.StartQAV(pPlayer, 77, 23, false);
                            }
                            return;
                        }
                        if (pPlayer.weaponState != 5) break;
                        if (Weapon.CheckAmmo2(pPlayer, 7, 10) && PLAYER.powerupCheck(pPlayer, 17) != 0) {
                            Weapon.StartQAV(pPlayer, 84, 23, false);
                        } else {
                            Weapon.StartQAV(pPlayer, 77, 23, false);
                        }
                        return;
                    }
                    if (pPlayer.weaponState == 2) {
                        pPlayer.weaponState = 4;
                        Weapon.StartQAV(pPlayer, 77, 22, false);
                        return;
                    }
                    if (pPlayer.weaponState != 5) break;
                    Weapon.StartQAV(pPlayer, 77, 22, false);
                    return;
                }
                case 5: {
                    if (PLAYER.powerupCheck(pPlayer, 17) != 0 && (DEMO.IsOriginalDemo() || Weapon.CheckAmmo2(pPlayer, 4, 2))) {
                        Weapon.StartQAV(pPlayer, VERSION.getQAV(22), 24, false);
                    } else {
                        Weapon.StartQAV(pPlayer, VERSION.getQAV(2), 24, false);
                    }
                    return;
                }
                case 9: {
                    SOUND.sfxStart3DSound(pPlayer.pSprite, 494, 1, 0);
                    Weapon.StartQAV(pPlayer, VERSION.getQAV(17), 26, false);
                    return;
                }
                case 13: {
                    Weapon.StartQAV(pPlayer, VERSION.getQAV(6) + Gameutils.Random(4), 28, false);
                    return;
                }
            }
        }
        if (pPlayer.pInput.AltShoot) {
            switch (pPlayer.currentWeapon) {
                case 1: {
                    Weapon.StartQAV(pPlayer, 2, 0, false);
                    return;
                }
                case 9: {
                    if (VERSION.GAMEVER == 0) {
                        SOUND.sfxStart3DSound(pPlayer.pSprite, 494, 2, 0);
                        Weapon.StartQAV(pPlayer, VERSION.getQAV(17), 26, false);
                    } else {
                        if (Globals.pGameInfo.nGameType <= 1 && !Weapon.CheckAmmo2(pPlayer, 8, 1) && pPlayer.pXsprite.health < 400) {
                            SOUND.sfxStart3DSound(pPlayer.pSprite, 494, 2, 0);
                            Weapon.StartQAV(pPlayer, VERSION.getQAV(17), 26, false);
                            return;
                        }
                        Weapon.StartQAV(pPlayer, 119, -1, false);
                        Weapon.DropLeech(pPlayer);
                        pPlayer.weaponState = -1;
                    }
                    return;
                }
                case 7: {
                    if (pPlayer.weaponState != 3) break;
                    pPlayer.weaponState = 5;
                    Weapon.StartQAV(pPlayer, 12, 4, false);
                    return;
                }
                case 6: {
                    switch (pPlayer.weaponState) {
                        case 3: {
                            pPlayer.weaponState = 4;
                            Weapon.StartQAV(pPlayer, 21, 7, false);
                            break;
                        }
                        case 7: {
                            pPlayer.weaponState = 8;
                            Weapon.StartQAV(pPlayer, 28, 9, false);
                            break;
                        }
                        case 10: {
                            pPlayer.weaponState = 11;
                            Weapon.StartQAV(pPlayer, 38, 11, false);
                            break;
                        }
                        case 11: {
                            if (pPlayer.ammoCount[11] <= 0) break;
                            pPlayer.weaponState = 10;
                            Weapon.StartQAV(pPlayer, 30, -1, false);
                        }
                    }
                    break;
                }
                case 11: {
                    if (pPlayer.weaponState != 7) break;
                    pPlayer.weaponState = 8;
                    Weapon.StartQAV(pPlayer, 28, 9, false);
                    return;
                }
                case 12: {
                    if (pPlayer.weaponState == 10) {
                        pPlayer.weaponState = 11;
                        Weapon.StartQAV(pPlayer, 38, 11, false);
                        return;
                    }
                    if (Actor.gTNTCount >= 512 || pPlayer.ammoCount[11] <= 0) break;
                    pPlayer.weaponState = 10;
                    Weapon.StartQAV(pPlayer, 30, -1, false);
                    return;
                }
                case 3: {
                    if (pPlayer.weaponState == 2) {
                        pPlayer.weaponState = 1;
                        Weapon.StartQAV(pPlayer, 55, 13, false);
                        return;
                    }
                    if (pPlayer.weaponState == 3) {
                        pPlayer.weaponState = 1;
                        Weapon.StartQAV(pPlayer, 56, 13, false);
                        return;
                    }
                    if (pPlayer.weaponState != 7) break;
                    pPlayer.weaponState = 6;
                    Weapon.StartQAV(pPlayer, 62, 13, false);
                    return;
                }
                case 4: {
                    if (PLAYER.powerupCheck(pPlayer, 17) != 0 && Weapon.CheckAmmo2(pPlayer, 3, 2)) {
                        Weapon.StartQAV(pPlayer, 73, 16, false);
                    } else {
                        Weapon.StartQAV(pPlayer, 67, 16, false);
                    }
                    return;
                }
                case 10: {
                    SOUND.sfxStart3DSound(pPlayer.pSprite, 461, 2, 0);
                    Weapon.StartQAV(pPlayer, VERSION.getQAV(13), 21, false);
                    return;
                }
                case 8: {
                    if (VERSION.GAMEVER != 0) {
                        if (Weapon.CheckAmmo2(pPlayer, 7, 35)) {
                            if (Weapon.CheckAmmo2(pPlayer, 7, 70) && PLAYER.powerupCheck(pPlayer, 17) != 0) {
                                Weapon.StartQAV(pPlayer, 85, 23, false);
                            } else {
                                Weapon.StartQAV(pPlayer, 78, 23, false);
                            }
                            return;
                        }
                        if (Weapon.CheckAmmo2(pPlayer, 7, 10) && PLAYER.powerupCheck(pPlayer, 17) != 0) {
                            Weapon.StartQAV(pPlayer, 84, 23, false);
                            return;
                        }
                        Weapon.StartQAV(pPlayer, 77, 23, false);
                    } else if (Weapon.CheckAmmo2(pPlayer, 7, 35)) {
                        Weapon.StartQAV(pPlayer, 78, 23, false);
                    } else {
                        Weapon.StartQAV(pPlayer, 77, 22, false);
                    }
                    return;
                }
                case 5: {
                    if (PLAYER.powerupCheck(pPlayer, 17) != 0 && (DEMO.IsOriginalDemo() || Weapon.CheckAmmo2(pPlayer, 4, 13))) {
                        Weapon.StartQAV(pPlayer, VERSION.getQAV(22), 25, false);
                    } else {
                        Weapon.StartQAV(pPlayer, VERSION.getQAV(2), 25, false);
                    }
                    return;
                }
                case 2: {
                    if (Weapon.CheckAmmo(pPlayer, 1, 8)) {
                        if (PLAYER.powerupCheck(pPlayer, 17) != 0 && Weapon.CheckAmmo2(pPlayer, 1, 16)) {
                            Weapon.StartQAV(pPlayer, 48, 19, false);
                        } else {
                            Weapon.StartQAV(pPlayer, 43, 19, false);
                        }
                    } else if (PLAYER.powerupCheck(pPlayer, 17) != 0 && Weapon.CheckAmmo2(pPlayer, 1, 2)) {
                        Weapon.StartQAV(pPlayer, 48, 18, false);
                    } else {
                        Weapon.StartQAV(pPlayer, 43, 18, false);
                    }
                    return;
                }
            }
        }
        Weapon.WeaponUpdateState(pPlayer);
    }

    public static void WeaponLower(PLAYER pPlayer) {
        if (pPlayer == null) {
            Main.game.dassert("pPlayer != NULL");
        }
        int nWeapon = pPlayer.currentWeapon;
        int nState = pPlayer.weaponState;
        if (Weapon.checkFired6or7(pPlayer)) {
            return;
        }
        pPlayer.throwTime = 0;
        switch (nWeapon) {
            case 1: {
                Weapon.StartQAV(pPlayer, 3, -1, false);
                break;
            }
            case 2: {
                if (PLAYER.powerupCheck(pPlayer, 17) != 0 && nState == 3) {
                    Weapon.StartQAV(pPlayer, 49, -1, false);
                    break;
                }
                Weapon.StartQAV(pPlayer, 44, -1, false);
                break;
            }
            case 3: {
                if (PLAYER.powerupCheck(pPlayer, 17) != 0 && (DEMO.IsOriginalDemo() || Weapon.CheckAmmo2(pPlayer, 2, 4))) {
                    Weapon.StartQAV(pPlayer, 63, -1, false);
                    break;
                }
                Weapon.StartQAV(pPlayer, 58, -1, false);
                break;
            }
            case 4: {
                if (PLAYER.powerupCheck(pPlayer, 17) != 0 && nState == 1) {
                    Weapon.StartQAV(pPlayer, 72, -1, false);
                    break;
                }
                Weapon.StartQAV(pPlayer, 68, -1, false);
                break;
            }
            case 5: {
                if (PLAYER.powerupCheck(pPlayer, 17) != 0 && (DEMO.IsOriginalDemo() || Weapon.CheckAmmo2(pPlayer, 4, 2))) {
                    Weapon.StartQAV(pPlayer, VERSION.getQAV(24), -1, false);
                    break;
                }
                Weapon.StartQAV(pPlayer, VERSION.getQAV(3), -1, false);
                break;
            }
            case 6: {
                switch (nState) {
                    case 1: {
                        Weapon.StartQAV(pPlayer, 7, -1, false);
                        break;
                    }
                    case 2: {
                        Weapon.WeaponRaise(pPlayer);
                        break;
                    }
                    case 0: 
                    case 3: {
                        if (pPlayer.pInput.newWeapon == 7) {
                            pPlayer.weaponState = 2;
                            Weapon.StartQAV(pPlayer, 17, -1, false);
                            break;
                        }
                        Weapon.StartQAV(pPlayer, 19, -1, false);
                    }
                }
                break;
            }
            case 7: {
                SOUND.sfxKill3DSound(pPlayer.pSprite, -1, 441);
                switch (nState) {
                    case 1: {
                        Weapon.StartQAV(pPlayer, 7, -1, false);
                        break;
                    }
                    case 2: {
                        pPlayer.weaponState = 1;
                        Weapon.WeaponRaise(pPlayer);
                        return;
                    }
                    case 0: 
                    case 3: {
                        if (pPlayer.pInput.newWeapon == 6) {
                            pPlayer.weaponState = 2;
                            Weapon.StartQAV(pPlayer, 11, -1, false);
                            return;
                        }
                        if (pPlayer.pInput.newWeapon != 7) {
                            pPlayer.weaponState = 1;
                            Weapon.StartQAV(pPlayer, DEMO.IsOriginalDemo() || PLAYER.weaponQAVs[125] == null ? 11 : 125, -1, false);
                            pPlayer.currentWeapon = 0;
                            pPlayer.fLoopQAV = false;
                            return;
                        }
                        pPlayer.weaponState = 1;
                        Weapon.StartQAV(pPlayer, 11, -1, false);
                        pPlayer.pInput.newWeapon = 0;
                        break;
                    }
                    case 4: {
                        pPlayer.weaponState = 1;
                        Weapon.StartQAV(pPlayer, 11, -1, false);
                        pPlayer.pInput.newWeapon = 0;
                        Weapon.WeaponLower(pPlayer);
                    }
                }
                break;
            }
            case 8: {
                if (VERSION.GAMEVER != 0 && Weapon.CheckAmmo2(pPlayer, 7, 10) && PLAYER.powerupCheck(pPlayer, 17) != 0) {
                    Weapon.StartQAV(pPlayer, 88, -1, false);
                    break;
                }
                Weapon.StartQAV(pPlayer, 81, -1, false);
                break;
            }
            case 10: {
                Weapon.StartQAV(pPlayer, VERSION.getQAV(12), -1, false);
                break;
            }
            case 9: {
                Weapon.StartQAV(pPlayer, VERSION.getQAV(19), -1, false);
                break;
            }
            case 11: {
                if (nState != 7) break;
                Weapon.StartQAV(pPlayer, 26, -1, false);
                break;
            }
            case 12: {
                if (nState == 10) {
                    Weapon.StartQAV(pPlayer, 34, -1, false);
                    break;
                }
                if (nState != 11) break;
                Weapon.StartQAV(pPlayer, 35, -1, false);
                break;
            }
            case 13: {
                Weapon.StartQAV(pPlayer, VERSION.getQAV(7), -1, false);
            }
        }
        pPlayer.currentWeapon = 0;
        pPlayer.fLoopQAV = false;
        if (!DEMO.IsOriginalDemo() && nWeapon != 6) {
            pPlayer.weaponState = 0;
        }
    }

    public static void WeaponRaise(PLAYER pPlayer) {
        if (pPlayer == null) {
            Main.game.dassert("pPlayer != NULL");
        }
        int oldWeapon = pPlayer.currentWeapon;
        int nWeapon = pPlayer.currentWeapon = pPlayer.pInput.newWeapon;
        int nState = pPlayer.weaponState;
        pPlayer.pInput.newWeapon = 0;
        pPlayer.weaponAmmo = Weapon.gWeaponInfo[nWeapon].ammoType;
        switch (nWeapon) {
            case 1: {
                pPlayer.weaponState = 0;
                Weapon.StartQAV(pPlayer, 0, -1, false);
                break;
            }
            case 2: {
                if (PLAYER.powerupCheck(pPlayer, 17) != 0 && Weapon.CheckAmmo2(pPlayer, 1, 2)) {
                    Weapon.StartQAV(pPlayer, 45, -1, false);
                    pPlayer.weaponState = 3;
                    break;
                }
                Weapon.StartQAV(pPlayer, 41, -1, false);
                pPlayer.weaponState = 2;
                break;
            }
            case 3: {
                if (PLAYER.powerupCheck(pPlayer, 17) != 0) {
                    if (Globals.gInfiniteAmmo || pPlayer.ammoCount[2] >= 4) {
                        Weapon.StartQAV(pPlayer, 59, -1, false);
                        pPlayer.weaponState = 7;
                        break;
                    }
                    pPlayer.weaponState = pPlayer.ammoCount[2] > 1 ? 3 : (pPlayer.ammoCount[2] == 0 ? 1 : 2);
                    Weapon.StartQAV(pPlayer, 50, -1, false);
                    break;
                }
                pPlayer.weaponState = Globals.gInfiniteAmmo || pPlayer.ammoCount[2] > 1 ? 3 : (pPlayer.ammoCount[2] <= 0 ? 1 : 2);
                Weapon.StartQAV(pPlayer, 50, -1, false);
                break;
            }
            case 4: {
                pPlayer.weaponState = 0;
                if (PLAYER.powerupCheck(pPlayer, 17) != 0 && Weapon.CheckAmmo2(pPlayer, 3, 2)) {
                    Weapon.StartQAV(pPlayer, 69, -1, false);
                    pPlayer.weaponState = 1;
                    break;
                }
                Weapon.StartQAV(pPlayer, 64, -1, false);
                pPlayer.weaponState = 0;
                break;
            }
            case 5: {
                if (PLAYER.powerupCheck(pPlayer, 17) != 0 && (DEMO.IsOriginalDemo() || Weapon.CheckAmmo2(pPlayer, 4, 2))) {
                    Weapon.StartQAV(pPlayer, VERSION.getQAV(20), -1, false);
                    pPlayer.weaponState = 3;
                    break;
                }
                Weapon.StartQAV(pPlayer, VERSION.getQAV(0), -1, false);
                pPlayer.weaponState = 2;
                break;
            }
            case 6: {
                if (!Globals.gInfiniteAmmo && !Weapon.CheckAmmo2(pPlayer, 5, 1)) break;
                pPlayer.weaponState = 3;
                if (oldWeapon == 7) {
                    Weapon.StartQAV(pPlayer, 16, -1, false);
                    break;
                }
                Weapon.StartQAV(pPlayer, 18, -1, false);
                break;
            }
            case 7: {
                if (nState == 2) {
                    pPlayer.weaponState = 3;
                    Weapon.StartQAV(pPlayer, 8, -1, false);
                    break;
                }
                pPlayer.weaponState = 0;
                Weapon.StartQAV(pPlayer, 4, -1, false);
                break;
            }
            case 8: {
                if (VERSION.GAMEVER != 0) {
                    if (Weapon.CheckAmmo2(pPlayer, 7, 1)) {
                        pPlayer.weaponState = 2;
                        if (PLAYER.powerupCheck(pPlayer, 17) != 0) {
                            Weapon.StartQAV(pPlayer, 82, -1, false);
                            break;
                        }
                        Weapon.StartQAV(pPlayer, 74, -1, false);
                        break;
                    }
                    pPlayer.weaponState = 3;
                    Weapon.StartQAV(pPlayer, 74, -1, false);
                    break;
                }
                pPlayer.weaponState = pPlayer.ammoCount[7] <= 0 ? 1 : 2;
                Weapon.StartQAV(pPlayer, 74, -1, false);
                break;
            }
            case 10: {
                if (!Globals.gInfiniteAmmo && !Weapon.CheckAmmo2(pPlayer, 9, 1)) break;
                pPlayer.weaponState = 2;
                Weapon.StartQAV(pPlayer, VERSION.getQAV(8), -1, false);
                break;
            }
            case 9: {
                pPlayer.weaponState = 2;
                Weapon.StartQAV(pPlayer, VERSION.getQAV(14), -1, false);
                break;
            }
            case 11: {
                if (!Globals.gInfiniteAmmo && !Weapon.CheckAmmo2(pPlayer, 10, 1)) break;
                pPlayer.weaponState = 7;
                Weapon.StartQAV(pPlayer, 25, -1, false);
                break;
            }
            case 12: {
                if (Globals.gInfiniteAmmo || Weapon.CheckAmmo2(pPlayer, 11, 1)) {
                    pPlayer.weaponState = 10;
                    Weapon.StartQAV(pPlayer, 31, -1, false);
                    break;
                }
                pPlayer.weaponState = 11;
                Weapon.StartQAV(pPlayer, 32, -1, false);
                break;
            }
            case 13: {
                pPlayer.weaponState = 2;
                Weapon.StartQAV(pPlayer, VERSION.getQAV(4), -1, false);
            }
        }
    }

    public static int WeaponFindLoaded(PLAYER pPlayer, boolean out) {
        int ret = 1;
        if (Weapon.gWeaponInfo[pPlayer.currentWeapon].update > 1) {
            for (int i = 0; i < Weapon.gWeaponInfo[pPlayer.currentWeapon].update; ++i) {
                if (!Weapon.CheckAmmo(pPlayer, Weapon.gWeaponInfo[pPlayer.currentWeapon].ammoType, 1)) continue;
                ret = pPlayer.currentWeapon;
                break;
            }
        }
        if (ret == 1) {
            for (int j = 0; j < 14; ++j) {
                int newWeapon = pPlayer.weaponOrder[0][j];
                if (!pPlayer.hasWeapon[newWeapon]) continue;
                for (int k = 0; k < Weapon.gWeaponInfo[newWeapon].update; ++k) {
                    if (!Weapon.CheckNewWeapon(pPlayer, newWeapon, Weapon.gWeaponInfo[newWeapon].ammoType, 1)) continue;
                    ret = newWeapon;
                    if (out) {
                        FindLoaded = k;
                    }
                    return ret;
                }
            }
        }
        if (out) {
            FindLoaded = 0;
        }
        return ret;
    }

    public static void WeaponUpdateState(PLAYER pPlayer) {
        int nWeapon = pPlayer.currentWeapon;
        int nState = pPlayer.weaponState;
        switch (nWeapon) {
            case 1: {
                pPlayer.pWeaponQAV = 1;
                break;
            }
            case 2: {
                if (PLAYER.powerupCheck(pPlayer, 17) != 0) {
                    if (nState == 3 && Weapon.CheckAmmo2(pPlayer, 1, 2)) {
                        pPlayer.pWeaponQAV = 46;
                        break;
                    }
                    pPlayer.pWeaponQAV = 42;
                    pPlayer.weaponState = 2;
                    break;
                }
                pPlayer.pWeaponQAV = 42;
                break;
            }
            case 3: {
                switch (nState) {
                    case 1: {
                        if (Weapon.CheckAmmo(pPlayer, 2, 1)) {
                            SOUND.sfxStart3DSound(pPlayer.pSprite, 410, 2, 2);
                            Weapon.StartQAV(pPlayer, 57, 14, false);
                            if (Globals.gInfiniteAmmo || pPlayer.ammoCount[2] > 1) {
                                pPlayer.weaponState = 3;
                                break;
                            }
                            pPlayer.weaponState = 2;
                            break;
                        }
                        pPlayer.pWeaponQAV = 51;
                        break;
                    }
                    case 2: {
                        pPlayer.pWeaponQAV = 52;
                        break;
                    }
                    case 3: {
                        pPlayer.pWeaponQAV = 53;
                        break;
                    }
                    case 6: {
                        if (PLAYER.powerupCheck(pPlayer, 17) != 0 && (Globals.gInfiniteAmmo || Weapon.CheckAmmo(pPlayer, 2, 4))) {
                            pPlayer.weaponState = 7;
                            return;
                        }
                        pPlayer.weaponState = 1;
                        break;
                    }
                    case 7: {
                        pPlayer.pWeaponQAV = 60;
                    }
                }
                break;
            }
            case 4: {
                if (PLAYER.powerupCheck(pPlayer, 17) != 0 && Weapon.CheckAmmo2(pPlayer, 3, 2)) {
                    pPlayer.pWeaponQAV = 70;
                    pPlayer.weaponState = 1;
                    break;
                }
                pPlayer.pWeaponQAV = 65;
                pPlayer.weaponState = 0;
                break;
            }
            case 5: {
                if (nState == 2) {
                    pPlayer.pWeaponQAV = VERSION.getQAV(1);
                }
                if (nState != 3) break;
                if (PLAYER.powerupCheck(pPlayer, 17) != 0 && (Globals.gInfiniteAmmo || Weapon.CheckAmmo(pPlayer, 4, 2))) {
                    pPlayer.pWeaponQAV = VERSION.getQAV(21);
                    break;
                }
                pPlayer.pWeaponQAV = VERSION.getQAV(1);
                break;
            }
            case 6: {
                switch (nState) {
                    case 0: {
                        pPlayer.weaponState = 1;
                        Weapon.StartQAV(pPlayer, 5, -1, false);
                        break;
                    }
                    case 1: {
                        if (pPlayer.weaponAmmo != 5 || !Weapon.CheckAmmo(pPlayer, 5, 1)) break;
                        pPlayer.weaponState = 3;
                        Weapon.StartQAV(pPlayer, 16, -1, false);
                        break;
                    }
                    case 2: {
                        if (pPlayer.ammoCount[5] <= 0) {
                            pPlayer.pWeaponQAV = 6;
                            break;
                        }
                        pPlayer.weaponState = 3;
                        Weapon.StartQAV(pPlayer, 16, -1, false);
                        break;
                    }
                    case 3: {
                        pPlayer.pWeaponQAV = 20;
                    }
                }
                break;
            }
            case 7: {
                switch (nState) {
                    case 0: {
                        pPlayer.weaponState = 1;
                        Weapon.StartQAV(pPlayer, 5, -1, false);
                        break;
                    }
                    case 1: {
                        if (!Weapon.CheckAmmo(pPlayer, 6, 1)) {
                            pPlayer.pWeaponQAV = 6;
                        }
                        pPlayer.weaponState = 3;
                        Weapon.StartQAV(pPlayer, 8, -1, false);
                        break;
                    }
                    case 3: {
                        pPlayer.pWeaponQAV = 9;
                        break;
                    }
                    case 4: {
                        if (Weapon.CheckAmmo(pPlayer, 6, 1)) {
                            pPlayer.pWeaponQAV = 9;
                            pPlayer.weaponState = 3;
                        } else {
                            pPlayer.weaponState = 1;
                            Weapon.StartQAV(pPlayer, 11, -1, false);
                        }
                        SOUND.sfxKill3DSound(pPlayer.pSprite, 1, 441);
                    }
                }
                break;
            }
            case 8: {
                if (nState == 2) {
                    pPlayer.pWeaponQAV = VERSION.GAMEVER != 0 && Weapon.CheckAmmo2(pPlayer, 7, 10) && PLAYER.powerupCheck(pPlayer, 17) != 0 ? 83 : 75;
                }
                if (nState != 3) break;
                pPlayer.pWeaponQAV = 76;
                break;
            }
            case 10: {
                if (pPlayer.pXsprite.height >= 256) {
                    pPlayer.pWeaponQAV = VERSION.getQAV(9);
                }
                int sway = Pragmas.klabs(pPlayer.swayHeight);
                if (DEMO.IsOriginalDemo() && sway <= 768 || !DEMO.IsOriginalDemo() && sway <= 16) {
                    pPlayer.pWeaponQAV = VERSION.getQAV(9);
                    break;
                }
                pPlayer.pWeaponQAV = VERSION.getQAV(10);
                break;
            }
            case 9: {
                if (nState != 2) break;
                pPlayer.pWeaponQAV = VERSION.getQAV(15);
                break;
            }
            case 11: {
                if (nState == 7) {
                    pPlayer.pWeaponQAV = 27;
                }
                if (nState != 8) break;
                pPlayer.weaponState = 7;
                Weapon.StartQAV(pPlayer, 25, -1, false);
                break;
            }
            case 12: {
                if (nState == 10) {
                    pPlayer.pWeaponQAV = 36;
                }
                if (nState == 11) {
                    pPlayer.pWeaponQAV = 37;
                }
                if (nState != 12) break;
                if (pPlayer.ammoCount[11] <= 0) {
                    pPlayer.weaponState = -1;
                    break;
                }
                pPlayer.weaponState = 10;
                Weapon.StartQAV(pPlayer, 31, -1, false);
                break;
            }
            case 13: {
                pPlayer.pWeaponQAV = VERSION.getQAV(5);
            }
        }
    }

    public static void StartQAV(PLAYER pPlayer, int nWeaponQAV, int callback, boolean fLoop) {
        if (nWeaponQAV >= 126) {
            Main.game.dassert("nWeaponQAV < kQAVEnd");
        }
        pPlayer.pWeaponQAV = nWeaponQAV;
        pPlayer.weaponTimer = PLAYER.weaponQAVs[pPlayer.pWeaponQAV].duration;
        pPlayer.weaponCallback = callback;
        pPlayer.fLoopQAV = fLoop;
        PLAYER.weaponQAVs[pPlayer.pWeaponQAV].Preload();
        Weapon.WeaponPlay(pPlayer);
        pPlayer.weaponTimer -= Globals.kFrameTicks;
    }

    public static void WeaponPlay(PLAYER pPlayer) {
        if (pPlayer == null) {
            Main.game.dassert("pPlayer != NULL");
        }
        if (pPlayer.pWeaponQAV == -1) {
            return;
        }
        QAV pQAV = PLAYER.weaponQAVs[pPlayer.pWeaponQAV];
        if (pQAV == null) {
            return;
        }
        int t = pQAV.duration - pPlayer.weaponTimer;
        pQAV.sprite = pPlayer.pSprite;
        pQAV.Play(t - Globals.kFrameTicks, t, pPlayer.weaponCallback, pPlayer);
    }

    public static void WeaponDraw(PLAYER pPlayer, int nShade, int x, int y, int nPLU, int nScale) {
        int pQAVnum;
        if (pPlayer == null) {
            Main.game.dassert("pPlayer != NULL");
        }
        if ((pQAVnum = pPlayer.pWeaponQAV) == -1) {
            return;
        }
        QAV pQAV = PLAYER.weaponQAVs[pQAVnum];
        int t = pPlayer.weaponTimer == 0 ? (!DEMO.IsOriginalDemo() && (pPlayer.weaponState == -1 || pPlayer.currentWeapon == 3 && pPlayer.weaponState == 7) ? pQAV.duration - 1 : Engine.totalclock % pQAV.duration) : pQAV.duration - pPlayer.weaponTimer;
        pQAV.origin.x = x - (pPlayer.lookang >> 1);
        pQAV.origin.y = y + Pragmas.klabs(pPlayer.lookang) / 9;
        if (Main.cfg.gViewSize == 3 && !Main.game.menu.gShowMenu) {
            pQAV.origin.y -= 12.0f;
        }
        if (pQAV.mindisp < 0 && pQAV.origin.y - 199.0f < (float)pQAV.mindisp) {
            pQAV.origin.y += (float)pQAV.mindisp - (pQAV.origin.y - 199.0f);
        }
        int nPowerRemaining = PLAYER.powerupCheck(pPlayer, 13);
        int nFlags = 10;
        if (nPowerRemaining >= 960 || nPowerRemaining != 0 && (Engine.totalclock & 0x20) != 0) {
            nFlags |= 1;
            nShade = -128;
        }
        pQAV.Draw(t, nShade, nFlags, nPLU, nScale);
    }

    static void FireSpray(int nTrigger, PLAYER pPlayer) {
        PLAYER.playerFireMissile(pPlayer, 0, (int)pPlayer.aim.x, (int)pPlayer.aim.y, (int)pPlayer.aim.z, 304);
        Weapon.UseAmmo(pPlayer, 6, Globals.kFrameTicks);
        if (Weapon.CheckAmmo(pPlayer, 6, 1)) {
            SOUND.sfxStart3DSound(pPlayer.pSprite, 441, 1, 2);
        } else {
            SOUND.sfxKill3DSound(pPlayer.pSprite, 1, 441);
        }
    }

    public static void ThrowBundle(int nTrigger, PLAYER pPlayer) {
        SOUND.sfxKill3DSound(pPlayer.pSprite, 16, -1);
        int velocity = Pragmas.mulscale(0x177777L, pPlayer.throwTime, 16) + 419430;
        SOUND.sfxStart3DSound(pPlayer.pSprite, 455, 1, 0);
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, -9460, 419, velocity);
        if (pPlayer.fuseTime < 0) {
            DB.xsprite[pThing.extra].Impact = true;
        } else {
            EVENT.evPost(pThing.xvel, 3, pPlayer.fuseTime, 1);
        }
        Weapon.UseAmmo(pPlayer, 5, 1);
        pPlayer.throwTime = 0;
    }

    public static void ThrowSpray(int nTrigger, PLAYER pPlayer) {
        SOUND.sfxKill3DSound(pPlayer.pSprite, -1, 441);
        int velocity = Pragmas.mulscale(0x177777L, pPlayer.throwTime, 16) + 419430;
        SOUND.sfxStart3DSound(pPlayer.pSprite, 455, 1, 0);
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, -9460, 420, velocity);
        pThing.shade = (byte)-128;
        DB.xsprite[pThing.extra].Impact = true;
        EVENT.evPost(pThing.xvel, 3, pPlayer.fuseTime, 1);
        Weapon.UseAmmo(pPlayer, 6, Actor.gAmmoItemData[0].count);
        pPlayer.throwTime = 0;
    }

    public static void DropSpray(int nTrigger, PLAYER pPlayer) {
        SOUND.sfxKill3DSound(pPlayer.pSprite, -1, 441);
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, 0, 420, 0);
        if (pThing != null) {
            EVENT.evPost(pThing.xvel, 3, pPlayer.fuseTime, 1);
            Weapon.UseAmmo(pPlayer, 6, Actor.gAmmoItemData[0].count);
        }
    }

    public static void ExplodeSpray(int nTrigger, PLAYER pPlayer) {
        SOUND.sfxKill3DSound(pPlayer.pSprite, -1, 441);
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, 0, 420, 0);
        EVENT.evPost(pThing.xvel, 3, 0L, 1);
        Weapon.UseAmmo(pPlayer, 6, Actor.gAmmoItemData[0].count);
        Weapon.StartQAV(pPlayer, 15, -1, false);
        pPlayer.currentWeapon = 0;
        pPlayer.throwTime = 0;
    }

    public static void DropBundle(int nTrigger, PLAYER pPlayer) {
        SOUND.sfxKill3DSound(pPlayer.pSprite, 16, -1);
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, 0, 419, 0);
        EVENT.evPost(pThing.xvel, 3, pPlayer.fuseTime, 1);
        Weapon.UseAmmo(pPlayer, 5, 1);
    }

    public static void ExplodeBundle(int nTrigger, PLAYER pPlayer) {
        SOUND.sfxKill3DSound(pPlayer.pSprite, 16, -1);
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, 0, 419, 0);
        EVENT.evPost(pThing.xvel, 3, 0L, 1);
        Weapon.UseAmmo(pPlayer, 5, 1);
        Weapon.StartQAV(pPlayer, 24, -1, false);
        pPlayer.currentWeapon = 0;
        pPlayer.throwTime = 0;
    }

    public static void ThrowProxy(int nTrigger, PLAYER pPlayer) {
        int velocity = Pragmas.mulscale(0x177777L, pPlayer.throwTime, 16) + 419430;
        SOUND.sfxStart3DSound(pPlayer.pSprite, 455, 1, 0);
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, -9460, 401, velocity);
        EVENT.evPost(pThing.xvel, 3, 240L, 1);
        Weapon.UseAmmo(pPlayer, 10, 1);
        pPlayer.throwTime = 0;
    }

    static void DropProxy(int nTrigger, PLAYER pPlayer) {
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, 0, 401, 0);
        EVENT.evPost(pThing.xvel, 3, 240L, 1);
        Weapon.UseAmmo(pPlayer, 10, 1);
    }

    public static void ThrowRemote(int nTrigger, PLAYER pPlayer) {
        int velocity = Pragmas.mulscale(0x177777L, pPlayer.throwTime, 16) + 419430;
        SOUND.sfxStart3DSound(pPlayer.pSprite, 455, 1, 0);
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, -9460, 402, velocity);
        DB.xsprite[pThing.extra].rxID = (short)(pPlayer.pSprite.lotag - 141);
        Weapon.UseAmmo(pPlayer, 11, 1);
        pPlayer.throwTime = 0;
    }

    public static void DropRemote(int nTrigger, PLAYER pPlayer) {
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, 0, 402, 0);
        DB.xsprite[pThing.extra].rxID = (short)(pPlayer.pSprite.lotag - 141);
        Weapon.UseAmmo(pPlayer, 11, 1);
    }

    public static void FireRemote(int nTrigger, PLAYER pPlayer) {
        EVENT.evSend(0, 0, pPlayer.pSprite.lotag - 141, 1);
    }

    public static void FirePitchfork(int nTrigger, PLAYER pPlayer) {
        int dx = Gameutils.BiRandom(2000);
        int dy = Gameutils.BiRandom(2000);
        int dz = Gameutils.BiRandom(2000);
        int z = pPlayer.weaponAboveZ - pPlayer.pSprite.z;
        if (PLAYER.newHoriz && !DEMO.IsOriginalDemo()) {
            z = (int)((float)z + 10.0f * pPlayer.horiz);
        }
        for (int i = 0; i < 4; ++i) {
            int xOffset = 40 * (2 * i - 3);
            Actor.actFireVector(pPlayer.pSprite, xOffset, z, dx + (int)pPlayer.aim.x, dy + (int)pPlayer.aim.y, dz + (int)pPlayer.aim.z, 0);
        }
    }

    public static void FireShotgun(int nTrigger, PLAYER pPlayer) {
        if (nTrigger <= 0 || nTrigger > 4) {
            Main.game.dassert("nTrigger > 0 && nTrigger <= kMaxShotgunBarrels");
        }
        int nVectors = nTrigger * 16;
        SPRITE pSprite = pPlayer.pSprite;
        int z = pPlayer.weaponAboveZ - pSprite.z;
        if (PLAYER.newHoriz && !DEMO.IsOriginalDemo()) {
            z = (int)((float)z + 10.0f * pPlayer.horiz);
        }
        for (int i = 0; i < nVectors; ++i) {
            int vectorType;
            int ddz;
            int ddy;
            int ddx;
            if (nTrigger == 1) {
                ddx = Gameutils.BiRandom2(1500);
                ddy = Gameutils.BiRandom2(1500);
                ddz = Gameutils.BiRandom2(500);
                vectorType = 1;
            } else {
                ddx = Gameutils.BiRandom2(2500);
                ddy = Gameutils.BiRandom2(2500);
                ddz = Gameutils.BiRandom2(1500);
                vectorType = 4;
            }
            Actor.actFireVector(pPlayer.pSprite, 0, z, ddx + (int)pPlayer.aim.x, ddy + (int)pPlayer.aim.y, ddz + (int)pPlayer.aim.z, vectorType);
        }
        if (nTrigger == 1) {
            SOUND.sfxStart3DSound(pSprite, 411, 1, 0);
            pPlayer.tilt = 30;
            pPlayer.visibility = 20;
        } else {
            SOUND.sfxStart3DSound(pSprite, 412, 1, 0);
            pPlayer.tilt = 50;
            pPlayer.visibility = 40;
        }
        Weapon.UseAmmo(pPlayer, pPlayer.weaponAmmo, nTrigger);
        pPlayer.fireEffect = 1;
    }

    public static void ShotgunReload(int nTrigger, PLAYER pPlayer) {
        Weapon.SpawnSShells(pPlayer, 25, 35);
        Weapon.SpawnSShells(pPlayer, 48, 35);
    }

    public static void SpawnSShells(PLAYER pPlayer, int offset, int vel) {
        pPlayer.viewOffZ = pPlayer.pSprite.z - Globals.gPosture[pPlayer.nLifeMode][pPlayer.moveState].viewSpeed;
        int z = pPlayer.weaponAboveZ - pPlayer.viewOffZ;
        if (PLAYER.newHoriz && !DEMO.IsOriginalDemo()) {
            z = (int)((float)z + 10.0f * pPlayer.horiz);
        }
        Actor.actSpawnSSheels(pPlayer.pSprite, (z >> 2) + pPlayer.weaponAboveZ - z, offset, vel);
    }

    public static void SpawnTShells(PLAYER pPlayer, int offset, int vel) {
        pPlayer.viewOffZ = pPlayer.pSprite.z - Globals.gPosture[pPlayer.nLifeMode][pPlayer.moveState].viewSpeed;
        int z = pPlayer.weaponAboveZ - pPlayer.viewOffZ;
        if (PLAYER.newHoriz && !DEMO.IsOriginalDemo()) {
            z = (int)((float)z + 10.0f * pPlayer.horiz);
        }
        Actor.actSpawnTSheels(pPlayer.pSprite, pPlayer.weaponAboveZ - z / 2, offset, vel);
    }

    public static void FireTommy(int nTrigger, PLAYER pPlayer) {
        int ddx;
        int ddy;
        int ddz;
        SPRITE pSprite = pPlayer.pSprite;
        int z = pPlayer.weaponAboveZ - pSprite.z;
        if (PLAYER.newHoriz && !DEMO.IsOriginalDemo()) {
            z = (int)((float)z + 10.0f * pPlayer.horiz);
        }
        SOUND.sfxStart3DSound(pSprite, 431, -1, 0);
        if (nTrigger == 1) {
            ddz = Gameutils.BiRandom2(400);
            ddy = Gameutils.BiRandom2(1200);
            ddx = Gameutils.BiRandom2(1200);
            Actor.actFireVector(pPlayer.pSprite, 0, z, ddx + (int)pPlayer.aim.x, ddy + (int)pPlayer.aim.y, ddz + (int)pPlayer.aim.z, 5);
            Weapon.SpawnTShells(pPlayer, -15, -45);
            pPlayer.visibility = 20;
        }
        if (nTrigger == 2) {
            ddz = Gameutils.BiRandom2(400);
            ddy = Gameutils.BiRandom2(1200);
            ddx = Gameutils.BiRandom2(1200);
            Actor.actFireVector(pPlayer.pSprite, -120, z, ddx + (int)pPlayer.aim.x, ddy + (int)pPlayer.aim.y, ddz + (int)pPlayer.aim.z, 5);
            Weapon.SpawnTShells(pPlayer, -140, -45);
            ddz = Gameutils.BiRandom2(400);
            ddy = Gameutils.BiRandom2(1200);
            ddx = Gameutils.BiRandom2(1200);
            Actor.actFireVector(pPlayer.pSprite, 120, z, ddx + (int)pPlayer.aim.x, ddy + (int)pPlayer.aim.y, ddz + (int)pPlayer.aim.z, 5);
            Weapon.SpawnTShells(pPlayer, 140, 45);
            pPlayer.visibility = 30;
        }
        Weapon.UseAmmo(pPlayer, pPlayer.weaponAmmo, nTrigger);
        pPlayer.fireEffect = 1;
    }

    public static void FireTommy2(int nTrigger, PLAYER pPlayer) {
        if (nTrigger <= 0 || nTrigger > 14) {
            Main.game.dassert("nTrigger > 0 && nTrigger <= kMaxSpread");
        }
        SPRITE pSprite = pPlayer.pSprite;
        int z = pPlayer.weaponAboveZ - pSprite.z;
        if (PLAYER.newHoriz && !DEMO.IsOriginalDemo()) {
            z = (int)((float)z + 10.0f * pPlayer.horiz);
        }
        int nAngle = 112 * (nTrigger - 1) / 14 - 56 + Main.engine.getangle((int)pPlayer.aim.x, (int)pPlayer.aim.y);
        SOUND.sfxStart3DSound(pSprite, 431, -1, 0);
        int ax = Trig.Cos(nAngle) >> 16;
        int ay = Trig.Sin(nAngle) >> 16;
        int ammocount = 1;
        if (PLAYER.powerupCheck(pPlayer, 17) != 0 && Weapon.CheckAmmo2(pPlayer, 3, 2)) {
            int ddz = Gameutils.BiRandom2(300);
            int ddy = Gameutils.BiRandom2(600);
            int ddx = Gameutils.BiRandom2(600);
            Actor.actFireVector(pPlayer.pSprite, -120, z, ddx + ax, ddy + ay, ddz + (int)pPlayer.aim.z, 3);
            int vel = Gameutils.BiRandom(45);
            int offset = Gameutils.BiRandom(120);
            Weapon.SpawnTShells(pPlayer, offset, vel);
            ddz = Gameutils.BiRandom2(300);
            ddy = Gameutils.BiRandom2(600);
            ddx = Gameutils.BiRandom2(600);
            Actor.actFireVector(pPlayer.pSprite, 120, z, ddx + ax, ddy + ay, ddz + (int)pPlayer.aim.z, 3);
            vel = Gameutils.BiRandom(-45);
            offset = Gameutils.BiRandom(-120);
            Weapon.SpawnTShells(pPlayer, offset, vel);
            pPlayer.tilt = 30;
            pPlayer.visibility = 45;
            ammocount = 2;
        } else {
            int ddz = Gameutils.BiRandom2(300);
            int ddy = Gameutils.BiRandom2(600);
            int ddx = Gameutils.BiRandom2(600);
            Actor.actFireVector(pPlayer.pSprite, 0, z, ddx + ax, ddy + ay, ddz + (int)pPlayer.aim.z, 3);
            int vel = Gameutils.BiRandom(90);
            int offset = Gameutils.BiRandom(30);
            Weapon.SpawnTShells(pPlayer, offset, vel);
            pPlayer.visibility = 30;
            pPlayer.tilt = 20;
        }
        Weapon.UseAmmo(pPlayer, pPlayer.weaponAmmo, ammocount);
        pPlayer.fireEffect = 1;
        if (!Weapon.CheckAmmo2(pPlayer, 3, 1)) {
            Weapon.WeaponLower(pPlayer);
            pPlayer.weaponState = -1;
        }
    }

    public static void FireATommy2(int nTrigger, PLAYER pPlayer) {
        if (nTrigger <= 0 || nTrigger > 14) {
            Main.game.dassert("nTrigger > 0 && nTrigger <= kMaxSpread");
        }
        SPRITE pSprite = pPlayer.pSprite;
        int z = pPlayer.weaponAboveZ - pSprite.z;
        if (PLAYER.newHoriz && !DEMO.IsOriginalDemo()) {
            z = (int)((float)z + 10.0f * pPlayer.horiz);
        }
        int nAngle = 112 * (nTrigger - 1) / 14 - 56 + Main.engine.getangle((int)pPlayer.aim.x, (int)pPlayer.aim.y);
        int ax = Trig.Cos(nAngle) >> 16;
        int ay = Trig.Sin(nAngle) >> 16;
        int ddz = Gameutils.BiRandom2(300);
        int ddy = Gameutils.BiRandom2(600);
        int ddx = Gameutils.BiRandom2(600);
        Actor.actFireVector(pPlayer.pSprite, -120, z, ddx + ax, ddy + ay, ddz + (int)pPlayer.aim.z, 3);
        int vel = Gameutils.BiRandom(45);
        int offset = Gameutils.BiRandom(120);
        Weapon.SpawnTShells(pPlayer, offset, vel);
        ddz = Gameutils.BiRandom2(300);
        ddy = Gameutils.BiRandom2(600);
        ddx = Gameutils.BiRandom2(600);
        Actor.actFireVector(pPlayer.pSprite, 120, z, ddx + ax, ddy + ay, ddz + (int)pPlayer.aim.z, 3);
        vel = Gameutils.BiRandom(-45);
        offset = Gameutils.BiRandom(-120);
        Weapon.SpawnTShells(pPlayer, offset, vel);
        pPlayer.tilt = 20;
        pPlayer.visibility = 30;
        Weapon.UseAmmo(pPlayer, pPlayer.weaponAmmo, 2);
        pPlayer.fireEffect = 1;
        SOUND.sfxStart3DSound(pSprite, 431, -1, 0);
    }

    static void FireFlare(int nTrigger, PLAYER pPlayer) {
        SPRITE pSprite = pPlayer.pSprite;
        int xoffset = 0;
        if (nTrigger == 2) {
            xoffset = -120;
        }
        if (nTrigger == 3) {
            xoffset = 120;
        }
        PLAYER.playerFireMissile(pPlayer, xoffset, (int)pPlayer.aim.x, (int)pPlayer.aim.y, (int)pPlayer.aim.z, 301);
        Weapon.UseAmmo(pPlayer, 1, 1);
        pPlayer.visibility = 30;
        pPlayer.fireEffect = 1;
        SOUND.sfxStart3DSound(pSprite, 420, 1, 0);
    }

    static void FireFlare2(int nTrigger, PLAYER pPlayer) {
        SPRITE pSprite = pPlayer.pSprite;
        int xoffset = 0;
        if (nTrigger == 2) {
            xoffset = -120;
        }
        if (nTrigger == 3) {
            xoffset = 120;
        }
        PLAYER.playerFireMissile(pPlayer, xoffset, (int)pPlayer.aim.x, (int)pPlayer.aim.y, (int)pPlayer.aim.z, 303);
        Weapon.UseAmmo(pPlayer, 1, 8);
        pPlayer.visibility = 45;
        pPlayer.fireEffect = 1;
        SOUND.sfxStart3DSound(pSprite, 420, 1, 0);
    }

    public static int UseAmmo(PLAYER pPlayer, int nAmmo, int nCount) {
        if (Globals.gInfiniteAmmo) {
            return 9999;
        }
        if (nAmmo == -1) {
            return 9999;
        }
        pPlayer.ammoCount[nAmmo] = Gameutils.ClipLow(pPlayer.ammoCount[nAmmo] - nCount, 0);
        return pPlayer.ammoCount[nAmmo];
    }

    public static void FireVoodoo(int nStabType, PLAYER pPlayer) {
        SPRITE pSprite = pPlayer.pSprite;
        SPRITE pTarget = null;
        int nSelfSprite = pPlayer.nSprite;
        if (--nStabType == 4) {
            Actor.actDamageSprite(nSelfSprite, pPlayer.pSprite, 2, 16);
            return;
        }
        if (pPlayer.voodooTarget < 0) {
            Main.game.dassert("pPlayer.voodooTarget >= 0");
        }
        pTarget = Engine.sprite[pPlayer.voodooTarget];
        switch (nStabType) {
            case 0: {
                SOUND.sfxStart3DSound(pSprite, 460, 2, 0);
                Actor.actSpawnBlood(pTarget);
                int nDamage = Actor.actDamageSprite(nSelfSprite, pTarget, 5, 272);
                Weapon.UseAmmo(pPlayer, 9, nDamage / 4);
                break;
            }
            case 1: {
                SOUND.sfxStart3DSound(pSprite, 460, 2, 0);
                Actor.actSpawnBlood(pTarget);
                int nDamage = Actor.actDamageSprite(nSelfSprite, pTarget, 5, 144);
                if (pTarget.lotag >= 231 && pTarget.lotag <= 238) {
                    int nPlayerHit = pTarget.lotag - 231;
                    Weapon.WeaponLower(Globals.gPlayer[nPlayerHit]);
                }
                Weapon.UseAmmo(pPlayer, 9, nDamage / 4);
                break;
            }
            case 3: {
                SOUND.sfxStart3DSound(pSprite, 463, 2, 0);
                Actor.actSpawnBlood(pTarget);
                int nDamage = Actor.actDamageSprite(nSelfSprite, pTarget, 5, 784);
                Weapon.UseAmmo(pPlayer, 9, nDamage / 4);
                break;
            }
            case 2: {
                SOUND.sfxStart3DSound(pSprite, 460, 2, 0);
                Actor.actSpawnBlood(pTarget);
                int nDamage = Actor.actDamageSprite(nSelfSprite, pTarget, 5, 176);
                if (Gameutils.IsPlayerSprite(pTarget)) {
                    PLAYER pPlayerHit = Globals.gPlayer[pTarget.lotag - 231];
                    pPlayerHit.blindEffect = 128;
                }
                Weapon.UseAmmo(pPlayer, 9, nDamage / 4);
            }
        }
    }

    static void FireVoodoo2(int nStabType, PLAYER pPlayer) {
        if (nStabType == 2) {
            int ammo = pPlayer.ammoCount[9];
            if (pPlayer.ammoCount[9] >= pPlayer.aimCount) {
                ammo = pPlayer.aimCount;
            }
            if (ammo > 0) {
                for (int i = 0; i < pPlayer.aimCount; ++i) {
                    SPRITE pTarget = Engine.sprite[pPlayer.aimSprites[i]];
                    long dist = Main.engine.qdist(pTarget.x - pPlayer.pSprite.x, pTarget.y - pPlayer.pSprite.y);
                    if (dist <= 0L || dist >= 51200L) continue;
                    int nDamage = Actor.actDamageSprite(pPlayer.nSprite, pTarget, 5, 16 * (2 * pPlayer.ammoCount[9] + Gameutils.BiRandom(pPlayer.ammoCount[9] >> 3)) * (51200 - (int)dist + 1) / 51200);
                    Weapon.UseAmmo(pPlayer, 9, nDamage);
                    if (Gameutils.IsPlayerSprite(pTarget)) {
                        PLAYER pPlayerHit = Globals.gPlayer[pTarget.lotag - 231];
                        if (!pPlayerHit.godMode || PLAYER.powerupCheck(pPlayerHit, 14) == 0) {
                            PLAYER.powerupActivate(pPlayerHit, 28);
                        }
                    }
                    Actor.actSpawnBlood(pTarget);
                }
            }
            Weapon.UseAmmo(pPlayer, 9, pPlayer.ammoCount[9]);
            pPlayer.hasWeapon[10] = false;
            pPlayer.weaponState = -1;
        }
    }

    static void FireTesla121(int nStabType, PLAYER pPlayer) {
        if (nStabType > 0 && nStabType <= 6) {
            TeslaData data = gTeslaData[nStabType - 1];
            if (Weapon.CheckAmmo2(pPlayer, 7, data.nCount) || Weapon.CheckAmmo2(pPlayer, 7, Weapon.gTeslaData[0].nCount)) {
                PLAYER.playerFireMissile(pPlayer, data.xoffset, (int)pPlayer.aim.x, (int)pPlayer.aim.y, (int)pPlayer.aim.z, data.missileType);
                Weapon.UseAmmo(pPlayer, pPlayer.weaponAmmo, data.nCount);
                SOUND.sfxStart3DSound(pPlayer.pSprite, data.soundId, 1, 0);
                pPlayer.visibility = data.visibility;
                pPlayer.fireEffect = data.fireEffect;
            } else {
                pPlayer.weaponState = -1;
                pPlayer.pWeaponQAV = 76;
                pPlayer.fireEffect = 0;
            }
        }
    }

    static void FireTesla_100(int nStabType, PLAYER pPlayer) {
        if (Weapon.CheckAmmo2(pPlayer, 7, 1)) {
            PLAYER.playerFireMissile(pPlayer, 0, (int)pPlayer.aim.x, (int)pPlayer.aim.y, (int)pPlayer.aim.z, 306);
            Weapon.UseAmmo(pPlayer, pPlayer.weaponAmmo, 1);
            SOUND.sfxStart3DSound(pPlayer.pSprite, 470, 1, 0);
            pPlayer.visibility = 20;
            pPlayer.fireEffect = 1;
        } else {
            pPlayer.weaponState = -1;
            pPlayer.pWeaponQAV = 76;
            pPlayer.fireEffect = 0;
        }
    }

    static void FireTesla2_100(int nStabType, PLAYER pPlayer) {
        PLAYER.playerFireMissile(pPlayer, 0, (int)pPlayer.aim.x, (int)pPlayer.aim.y, (int)pPlayer.aim.z, 302);
        Weapon.UseAmmo(pPlayer, pPlayer.weaponAmmo, 35);
        SOUND.sfxStart3DSound(pPlayer.pSprite, 471, 1, 0);
        pPlayer.visibility = 50;
        pPlayer.fireEffect = 1;
    }

    static void FireNapalm(int nTrigger, PLAYER pPlayer) {
        SPRITE pSprite = pPlayer.pSprite;
        int xoffset = 0;
        if (nTrigger == 2) {
            xoffset = -50;
        }
        if (nTrigger == 3) {
            xoffset = 50;
        }
        PLAYER.playerFireMissile(pPlayer, xoffset, (int)pPlayer.aim.x, (int)pPlayer.aim.y, (int)pPlayer.aim.z, 312);
        Weapon.UseAmmo(pPlayer, 4, 1);
        pPlayer.visibility = 30;
        pPlayer.fireEffect = 1;
        SOUND.sfxStart3DSound(pSprite, 480, 1, 0);
    }

    static void FireNapalm2(int nTrigger, PLAYER pPlayer) {
        SPRITE pSprite = PLAYER.playerFireThing(pPlayer, 0, -4730, 428, 0x122221);
        if (pSprite != null) {
            XSPRITE pXSprite = DB.xsprite[pSprite.extra];
            pXSprite.data4 = 4 * Gameutils.ClipHigh(pPlayer.ammoCount[4], 12);
            Weapon.UseAmmo(pPlayer, 4, pXSprite.data4 / 4);
            SeqHandling.seqSpawn(22, 3, pSprite.extra, null);
            pXSprite.burnSource = Actor.actSetBurnSource(pPlayer.pSprite.xvel);
            pXSprite.burnTime = Gameutils.ClipHigh(pXSprite.burnTime + 600, 1200);
            EVENT.evPostCallback(pSprite.xvel, 3, 0L, 0);
            SOUND.sfxStart3DSound(pSprite, 480, 2, 0);
            pPlayer.visibility = 30;
            pPlayer.fireEffect = 1;
        }
    }

    static void FireLeech(int nTrigger, PLAYER pPlayer) {
        if (Weapon.CheckAmmo(pPlayer, 8, 1)) {
            int ddz;
            int ddy;
            int ddx = Gameutils.BiRandom(2000);
            SPRITE pMissile = PLAYER.playerFireMissile(pPlayer, 0, (int)pPlayer.aim.x + ddx, (int)pPlayer.aim.y + (ddy = Gameutils.BiRandom(2000)), (int)pPlayer.aim.z + (ddz = Gameutils.BiRandom(1000)), 315);
            if (pMissile != null) {
                DB.xsprite[pMissile.extra].target = pPlayer.nAimSprite;
                pMissile.ang = nTrigger == 2 ? (short)1024 : (short)0;
            }
            if (Weapon.CheckAmmo2(pPlayer, 8, 1)) {
                Weapon.UseAmmo(pPlayer, 8, 1);
            } else {
                Actor.actDamageSprite(pPlayer.nSprite, pPlayer.pSprite, 5, 16);
            }
            pPlayer.visibility = Gameutils.ClipHigh(pPlayer.visibility + 5, 50);
        }
    }

    static void LeechOperate(SPRITE pSprite, XSPRITE pXSprite, int evCommand) {
        switch (evCommand) {
            case 30: {
                if (pXSprite.data4 >= 0 && pXSprite.data4 < Mmulti.numplayers) {
                    PLAYER pPlayer = Globals.gPlayer[pXSprite.data4];
                    if (pPlayer.pXsprite.health != 0) {
                        pPlayer.ammoCount[8] = Gameutils.ClipHigh(pPlayer.ammoCount[8] + pXSprite.data3, 100);
                        pPlayer.hasWeapon[9] = true;
                        if (pPlayer.currentWeapon != 9) {
                            pPlayer.weaponState = 0;
                            pPlayer.updateWeapon = 9;
                        }
                        EVENT.checkEventList(pSprite.xvel, 3);
                    }
                }
                Actor.actPostSprite(pSprite.xvel, 1024);
                break;
            }
            case 35: {
                SPRITE pMissile;
                SPRITE pTarget;
                if (pXSprite.target < 0 || pXSprite.target >= Globals.kMaxSprites || pXSprite.stateTimer != 0 || !Actor.IsDudeSprite(pTarget = Engine.sprite[pXSprite.target]) || (pTarget.hitag & 0x20) != 0 || pTarget.extra <= 0 || pTarget.extra >= 2048) break;
                Gameutils.GetSpriteExtents(pSprite);
                DudeInfo pDudeInfo = DudeInfo.dudeInfo[pTarget.lotag - 200];
                int dz = Gameutils.extents_zTop - pSprite.z - 256;
                long dist = Main.engine.qdist(pTarget.x - pSprite.x, pTarget.y - pSprite.y);
                if (dist == 0L || !Main.engine.cansee(pSprite.x, pSprite.y, Gameutils.extents_zTop, pSprite.sectnum, pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum)) break;
                short oldang = pSprite.ang;
                long vel = Pragmas.divscale(dist, 0x1AAAAAL, 12);
                pSprite.ang = Main.engine.getangle(Pragmas.mulscale(vel, Actor.sprXVel[pTarget.xvel], 12) + pTarget.x - pSprite.x, Pragmas.mulscale(vel, Actor.sprYVel[pTarget.xvel], 12) + pTarget.y - pSprite.y);
                int eyeAboveZ = pTarget.z - (pDudeInfo.aimHeight * pTarget.yrepeat << 2) - Gameutils.extents_zTop - 256;
                int ax = Trig.Cos(pSprite.ang) >> 16;
                int ay = Trig.Sin(pSprite.ang) >> 16;
                int az = Pragmas.divscale(eyeAboveZ, dist, 10);
                int time = 12;
                int missileType = 316;
                if (pXSprite.data3 != 0) {
                    time = 36;
                    ++missileType;
                }
                if ((pMissile = Actor.actFireMissile(pSprite, 0, dz, ax, ay, az, missileType)) != null) {
                    pMissile.owner = pSprite.owner;
                    pXSprite.stateTimer = 1;
                    pXSprite.data3 = (short)Gameutils.ClipLow(pXSprite.data3 - 1, 0);
                    EVENT.evPostCallback(pSprite.xvel, 3, time, 20);
                }
                pSprite.ang = oldang;
                break;
            }
            default: {
                Actor.actPostSprite(pSprite.xvel, 1024);
            }
        }
    }

    static void DropLeech(PLAYER pPlayer) {
        SOUND.sfxStart3DSound(pPlayer.pSprite, 455, 2, 0);
        SPRITE pThing = PLAYER.playerFireThing(pPlayer, 0, -4730, 431, 104857);
        if (pThing != null) {
            XSPRITE pXThing = DB.xsprite[pThing.extra];
            pThing.cstat = (short)(pThing.cstat | 0x1000);
            pXThing.Push = true;
            pXThing.DudeLockout = true;
            pXThing.Proximity = true;
            pXThing.stateTimer = 1;
            EVENT.evPostCallback(pThing.xvel, 3, 120L, 20);
            if (Globals.pGameInfo.nGameType > 1) {
                pXThing.data3 = (short)pPlayer.ammoCount[8];
                pPlayer.ammoCount[8] = 0;
            } else {
                int ammo = pPlayer.ammoCount[8];
                if (ammo < 25 && pPlayer.pXsprite.health > 25 - ammo << 4) {
                    Actor.actDamageSprite(pPlayer.nSprite, pPlayer.pSprite, 5, 25 - ammo << 4);
                    ammo = 25;
                }
                pXThing.data3 = ammo;
                Weapon.UseAmmo(pPlayer, 8, ammo);
            }
            pPlayer.hasWeapon[9] = false;
            Tile.tileLoadVoxel(pThing.picnum);
        }
    }

    static void LeechCallback(int nIndex) {
        SPRITE pSprite = Engine.sprite[nIndex];
        if (pSprite.statnum == 4 && (pSprite.hitag & 0x20) == 0) {
            switch (pSprite.lotag) {
                case 431: 
                case 435: {
                    DB.xsprite[pSprite.extra].stateTimer = 0;
                }
            }
        }
    }

    static void FireBeast(int nTrigger, PLAYER pPlayer) {
        int ddx = Gameutils.BiRandom(2000);
        int ddy = Gameutils.BiRandom(2000);
        int ddz = Gameutils.BiRandom(2000);
        int z = pPlayer.weaponAboveZ - pPlayer.pSprite.z;
        if (PLAYER.newHoriz && !DEMO.IsOriginalDemo()) {
            z = (int)((float)z + 10.0f * pPlayer.horiz);
        }
        Actor.actFireVector(pPlayer.pSprite, 0, z, ddx + (int)pPlayer.aim.x, ddy + (int)pPlayer.aim.y, ddz + (int)pPlayer.aim.z, 9);
    }

    public static boolean weaponIdle(PLAYER pPlayer) {
        switch (pPlayer.currentWeapon) {
            case 0: {
                return pPlayer.updateWeapon == 0;
            }
            case 1: {
                if (pPlayer.pWeaponQAV == 1) break;
                return false;
            }
            case 2: {
                if (pPlayer.pWeaponQAV == 42 || pPlayer.pWeaponQAV == 46) break;
                return false;
            }
            case 3: {
                if (pPlayer.pWeaponQAV == 53 || pPlayer.pWeaponQAV == 52 || pPlayer.pWeaponQAV == 51 || pPlayer.pWeaponQAV == 60) break;
                return false;
            }
            case 4: {
                if (pPlayer.pWeaponQAV == 65 || pPlayer.pWeaponQAV == 70) break;
                return false;
            }
            case 5: {
                if (pPlayer.pWeaponQAV == VERSION.getQAV(1) || pPlayer.pWeaponQAV == VERSION.getQAV(21)) break;
                return false;
            }
            case 6: {
                if (pPlayer.pWeaponQAV == 20) break;
                return false;
            }
            case 7: {
                if (pPlayer.pWeaponQAV == 9) break;
                return false;
            }
            case 8: {
                if (pPlayer.pWeaponQAV == 75 || pPlayer.pWeaponQAV == 83) break;
                return false;
            }
            case 9: {
                if (pPlayer.pWeaponQAV == 112) break;
                return false;
            }
            case 10: {
                if (pPlayer.pWeaponQAV == 101 || pPlayer.pWeaponQAV == 102) break;
                return false;
            }
            case 11: {
                if (pPlayer.pWeaponQAV == 27) break;
                return false;
            }
            case 12: {
                if (pPlayer.pWeaponQAV == 36) break;
                return false;
            }
        }
        return true;
    }
}

