/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Architecture;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import java.awt.Toolkit;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Render.Types.GL10;

public abstract class BuildGraphics
implements Graphics {
    protected GL10 gl10;
    protected GL20 gl20;
    protected GL30 gl30;
    protected long frameId = -1L;
    protected float deltaTime = 0.0f;
    protected long frameStart = 0L;
    protected int frames = 0;
    protected int fps;
    protected long lastTime = System.nanoTime();
    protected boolean vsync = false;
    protected boolean resize = false;
    protected volatile boolean isContinuous = true;
    protected volatile boolean requestRendering = false;

    protected void updateTime() {
        long time = System.nanoTime();
        this.deltaTime = (float)(time - this.lastTime) / 1.0E9f;
        this.lastTime = time;
        if (time - this.frameStart >= 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = time;
        }
        ++this.frames;
    }

    @Override
    public void setContinuousRendering(boolean isContinuous) {
        this.isContinuous = isContinuous;
    }

    @Override
    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestRendering() {
        BuildGraphics buildGraphics = this;
        synchronized (buildGraphics) {
            this.requestRendering = true;
        }
    }

    @Override
    public long getFrameId() {
        return this.frameId;
    }

    @Override
    public float getDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    protected abstract int getRefreshRate();

    protected abstract boolean isDirty();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldRender() {
        BuildGraphics buildGraphics = this;
        synchronized (buildGraphics) {
            boolean rq = this.requestRendering;
            this.requestRendering = false;
            return rq || this.isContinuous || this.isDirty();
        }
    }

    protected abstract void sync(int var1);

    protected abstract void init() throws Exception;

    protected abstract void update();

    protected abstract void updateSize(int var1, int var2);

    protected abstract boolean wasResized();

    protected abstract int getX();

    protected abstract int getY();

    protected abstract boolean isCloseRequested();

    protected abstract void dispose();

    protected abstract boolean isActive();

    public boolean isGL10Available() {
        return this.gl10 != null;
    }

    public GL10 getGL10() {
        return this.gl10;
    }

    @Override
    public GL20 getGL20() {
        return this.gl20;
    }

    @Override
    public boolean isGL30Available() {
        return this.gl30 != null;
    }

    @Override
    public GL30 getGL30() {
        return this.gl30;
    }

    @Override
    public void setGL20(GL20 gl20) {
        this.gl20 = gl20;
        if (this.gl30 == null) {
            BuildGdx.gl20 = gl20;
        }
    }

    @Override
    public void setGL30(GL30 gl30) {
        this.gl30 = gl30;
        if (gl30 != null) {
            BuildGdx.gl20 = this.gl20 = gl30;
            BuildGdx.gl30 = gl30;
        }
    }

    @Override
    public abstract int getWidth();

    @Override
    public abstract int getHeight();

    @Override
    public int getFramesPerSecond() {
        return this.fps;
    }

    public abstract void setFramesPerSecond(int var1);

    public abstract BuildFrame.FrameType getFrameType();

    @Override
    public abstract GLVersion getGLVersion();

    @Override
    public abstract boolean supportsDisplayModeChange();

    @Override
    public abstract Graphics.Monitor getPrimaryMonitor();

    @Override
    public abstract Graphics.Monitor getMonitor();

    @Override
    public abstract Graphics.Monitor[] getMonitors();

    @Override
    public abstract Graphics.DisplayMode[] getDisplayModes();

    @Override
    public abstract Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor var1);

    @Override
    public abstract Graphics.DisplayMode getDisplayMode();

    public abstract Graphics.DisplayMode getDesktopDisplayMode();

    @Override
    public abstract Graphics.DisplayMode getDisplayMode(Graphics.Monitor var1);

    @Override
    public abstract boolean setFullscreenMode(Graphics.DisplayMode var1);

    @Override
    public abstract boolean setWindowedMode(int var1, int var2);

    @Override
    public abstract void setTitle(String var1);

    @Override
    public abstract void setUndecorated(boolean var1);

    @Override
    public abstract void setResizable(boolean var1);

    @Override
    public abstract void setVSync(boolean var1);

    @Override
    public abstract Graphics.BufferFormat getBufferFormat();

    @Override
    public abstract boolean supportsExtension(String var1);

    @Override
    public abstract boolean isFullscreen();

    @Override
    public abstract Cursor newCursor(Pixmap var1, int var2, int var3);

    @Override
    public abstract void setCursor(Cursor var1);

    @Override
    public abstract void setSystemCursor(Cursor.SystemCursor var1);

    public abstract Object extra(Option var1, Object ... var2);

    public int getLogicalWidth() {
        return this.getWidth();
    }

    public int getLogicalHeight() {
        return this.getHeight();
    }

    @Override
    public int getBackBufferWidth() {
        return this.getWidth();
    }

    @Override
    public int getBackBufferHeight() {
        return this.getHeight();
    }

    @Override
    public float getDensity() {
        return this.getPpiX() / 160.0f;
    }

    @Override
    public float getPpiX() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    @Override
    public float getPpiY() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    @Override
    public float getPpcX() {
        return (float)Toolkit.getDefaultToolkit().getScreenResolution() / 2.54f;
    }

    @Override
    public float getPpcY() {
        return (float)Toolkit.getDefaultToolkit().getScreenResolution() / 2.54f;
    }

    public static enum Option {
        SWChangePalette,
        SWGetFrame,
        GLSetConfiguration,
        GLDefConfiguration;

    }
}

