/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Audio;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Audio.DummyMusic;
import ru.m210projects.Build.Audio.DummySound;
import ru.m210projects.Build.Audio.Music;
import ru.m210projects.Build.Audio.MusicSource;
import ru.m210projects.Build.Audio.Sound;
import ru.m210projects.Build.Audio.SoundData;
import ru.m210projects.Build.Audio.Source;

public class BuildAudio {
    private Sound fx;
    private Music mx;
    private static boolean initDrivers;
    private static List<Sound> fxdrivers;
    private static List<Music> mxdrivers;

    private static void init() {
        if (initDrivers) {
            return;
        }
        if (fxdrivers == null) {
            fxdrivers = new ArrayList<Sound>();
            fxdrivers.add(new DummySound());
        }
        if (mxdrivers == null) {
            mxdrivers = new ArrayList<Music>();
            mxdrivers.add(new DummyMusic());
        }
        initDrivers = true;
    }

    public static void registerDriver(Driver type, Object drv) {
        BuildAudio.init();
        if (drv == null) {
            throw new NullPointerException();
        }
        if (type == Driver.Sound && drv instanceof Sound) {
            fxdrivers.add((Sound)drv);
        }
        if (type == Driver.Music && drv instanceof Music) {
            mxdrivers.add((Music)drv);
        }
    }

    public static List<String> getDeviceslList(Driver type, List<String> list) {
        if (type == Driver.Sound) {
            for (Sound s : fxdrivers) {
                list.add(s.getName());
            }
        }
        if (type == Driver.Music) {
            for (Music m : mxdrivers) {
                list.add(m.getName());
            }
        }
        return list;
    }

    public BuildAudio() {
        BuildAudio.init();
        this.fx = this.getSound(0);
        this.mx = this.getMusic(0);
    }

    public boolean IsInited(Driver type) {
        if (type == Driver.Sound) {
            return this.fx.isInited();
        }
        if (type == Driver.Music) {
            return this.mx.isInited();
        }
        return false;
    }

    private Sound getSound(int sndnum) {
        if (sndnum < 0 || sndnum >= fxdrivers.size()) {
            sndnum = 0;
        }
        return fxdrivers.get(sndnum);
    }

    public Sound getSound() {
        return this.fx;
    }

    private Music getMusic(int musnum) {
        if (musnum < 0 || musnum >= mxdrivers.size()) {
            musnum = 0;
        }
        return mxdrivers.get(musnum);
    }

    public Music getMusic() {
        return this.mx;
    }

    public int checkNum(Driver type, int drvnum) {
        if (type == Driver.Sound && (drvnum < 0 || drvnum >= fxdrivers.size())) {
            drvnum = 0;
        }
        if (type == Driver.Music && (drvnum < 0 || drvnum >= mxdrivers.size())) {
            drvnum = 0;
        }
        return drvnum;
    }

    public BuildAudio setDriver(Driver type, int drvnum) {
        if (type == Driver.Sound) {
            if (this.fx != null) {
                this.fx.stopAllSounds();
                this.fx.uninit();
            }
            this.fx = this.getSound(drvnum);
        }
        if (type == Driver.Music) {
            if (this.mx != null) {
                this.mx.dispose();
            }
            this.mx = this.getMusic(drvnum);
        }
        return this;
    }

    public int getDriver(Driver type) {
        int num;
        if (type == Driver.Sound) {
            for (num = 0; num < fxdrivers.size(); ++num) {
                if (fxdrivers.get(num) != this.fx) continue;
                return num;
            }
        }
        if (type == Driver.Music) {
            for (num = 0; num < mxdrivers.size(); ++num) {
                if (mxdrivers.get(num) != this.mx) continue;
                return num;
            }
        }
        return 0;
    }

    public void setVolume(Driver type, float volume) {
        switch (type) {
            case Sound: {
                if (!this.fx.isInited()) break;
                this.fx.setVolume(volume);
                break;
            }
            case Music: {
                if (this.fx.getDigitalMusic() != null && this.fx.getDigitalMusic().isInited()) {
                    this.fx.getDigitalMusic().setVolume(volume);
                }
                if (!this.mx.isInited()) break;
                this.mx.setVolume(volume);
            }
        }
    }

    public void dispose() {
        for (Sound sound : fxdrivers) {
            sound.dispose();
        }
        for (Music music : mxdrivers) {
            music.dispose();
        }
        fxdrivers.clear();
        mxdrivers.clear();
        this.fx = null;
        this.mx = null;
    }

    public void update() {
        if (this.fx != null && this.fx.isInited()) {
            this.fx.update();
        }
        if (this.mx != null && this.mx.isInited()) {
            this.mx.update();
        }
    }

    public String getName(Driver type) {
        switch (type) {
            case Sound: {
                return this.fx.getName();
            }
            case Music: {
                return this.mx.getName();
            }
        }
        return null;
    }

    public SoundData decodeSound(byte[] data) {
        return this.fx.decodeSound(data);
    }

    public Source newSound(ByteBuffer data, int rate, int bits, int priority) {
        if (priority == 0) {
            priority = 1;
        }
        return this.fx.newSound(data, rate, bits, 1, priority);
    }

    public Source newSound(ByteBuffer data, int rate, int bits, int channels, int priority) {
        if (priority == 0) {
            priority = 1;
        }
        return this.fx.newSound(data, rate, bits, channels, priority);
    }

    public MusicSource newMusic(MusicType type, String file) {
        if (type == MusicType.Midi && this.mx.isInited()) {
            return this.mx.newMusic(file);
        }
        if (type == MusicType.Digital && this.fx.getDigitalMusic() != null && this.fx.getDigitalMusic().isInited()) {
            return this.fx.getDigitalMusic().newMusic(file);
        }
        return null;
    }

    public MusicSource newMusic(MusicType type, byte[] data) {
        if (type == MusicType.Midi && this.mx.isInited()) {
            return this.mx.newMusic(data);
        }
        if (type == MusicType.Digital && this.fx.getDigitalMusic() != null && this.fx.getDigitalMusic().isInited()) {
            return this.fx.getDigitalMusic().newMusic(data);
        }
        return null;
    }

    public static enum Driver {
        Music,
        Sound;

    }

    public static enum MusicType {
        Midi,
        Digital;

    }
}

