/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Audio;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Audio.LoopInfo;
import ru.m210projects.Build.Audio.SourceCallback;

public abstract class Source
implements Comparable<Source> {
    public static final int Locked = 1;
    public int bufferId;
    public int sourceId;
    public int priority;
    public boolean free;
    public int flags;
    public int format;
    public int rate;
    public ByteBuffer data;
    public LoopInfo loopInfo;
    public SourceCallback<Object> callback;
    public Object channel;

    public Source(int bufferId, int sourceId, int priority) {
        this.bufferId = bufferId;
        this.sourceId = sourceId;
        this.priority = priority;
        this.free = true;
        this.loopInfo = new LoopInfo();
    }

    @Override
    public int compareTo(Source source) {
        if ((source.flags & 1) != 0) {
            return -1;
        }
        if (source.free) {
            return 1;
        }
        return this.priority - source.priority;
    }

    public abstract void play(float var1);

    public abstract void stop();

    public abstract void pause();

    public abstract void resume();

    public abstract int dispose();

    public abstract void setLooping(boolean var1, int var2, int var3);

    public abstract void setPosition(float var1, float var2, float var3);

    public abstract void setVolume(float var1);

    public abstract void setPitch(float var1);

    public abstract void setGlobal(int var1);

    public abstract void setPriority(int var1);

    public abstract float getVolume();

    public abstract float getPitch();

    public abstract boolean isActive();

    public abstract boolean isLooping();

    public abstract boolean isPlaying();

    public abstract boolean isGlobal();

    public abstract <T> void setCallback(SourceCallback<T> var1, T var2);
}

