/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Input.KeyInput;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.OnSceenDisplay.DEFOSDFUNC;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Render.GdxRender.GDXRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.Software.Software;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.FadeEffect;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Hitscan;
import ru.m210projects.Build.Types.InvalidVersionException;
import ru.m210projects.Build.Types.Neartag;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.SmallTextFont;
import ru.m210projects.Build.Types.TextFont;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Build.Types.TileFont;
import ru.m210projects.Build.Types.WALL;

public abstract class Engine {
    public static final String version = "21.113";
    public static final byte CEIL = 0;
    public static final byte FLOOR = 1;
    public String tilesPath = "tilesXXX.art";
    public int fpscol = 31;
    public Renderer render;
    public static Object lock = new Object();
    private static KeyInput input;
    public static TileFont pTextfont;
    public static TileFont pSmallTextfont;
    public static boolean offscreenrendering;
    public static float TRANSLUSCENT1;
    public static float TRANSLUSCENT2;
    public static float MAXDRUNKANGLE;
    public static int setviewcnt;
    public static int[] bakwindowx1;
    public static int[] bakwindowy1;
    public static int[] bakwindowx2;
    public static int[] bakwindowy2;
    public static int baktile;
    public static final int CLIPMASK0 = 65537;
    public static final int CLIPMASK1 = 0x1000040;
    public static final int MAXPSKYTILES = 256;
    public static final int MAXPALOOKUPS = 256;
    public static int USERTILES;
    public static int MAXTILES;
    public static final int MAXSTATUS = 1024;
    public static final int DETAILPAL = 255;
    public static final int GLOWPAL = 254;
    public static final int SPECULARPAL = 253;
    public static final int NORMALPAL = 252;
    public static final int RESERVEDPALS = 4;
    public static final int MAXSECTORSV8 = 4096;
    public static final int MAXWALLSV8 = 16384;
    public static final int MAXSPRITESV8 = 16384;
    public static final int MAXSECTORSV7 = 1024;
    public static final int MAXWALLSV7 = 8192;
    public static final int MAXSPRITESV7 = 4096;
    public static int MAXSECTORS;
    public static int MAXWALLS;
    public static int MAXSPRITES;
    public static final int MAXSPRITESONSCREEN = 1024;
    public static final int MAXVOXELS;
    public static final int MAXUNIQHUDID = 256;
    public static final int MAXPSKYMULTIS = 8;
    public static final int MAXPLAYERS = 16;
    public static final int MAXXDIM = 4096;
    public static final int MAXYDIM = 3072;
    public static short numshades;
    public static byte[] palette;
    public static short numsectors;
    public static short numwalls;
    public static short numsprites;
    public static int totalclock;
    public static short[] pskyoff;
    public static short[] zeropskyoff;
    public static short pskybits;
    public static byte parallaxtype;
    public static boolean showinvisibility;
    public static int visibility;
    public static int parallaxvisibility;
    public static int parallaxyoffs;
    public static int parallaxyscale;
    public static byte[][] palookup;
    public static byte[][] palookupfog;
    public static int timerticspersec;
    public static short[] sintable;
    public static byte automapping;
    public static int numtiles;
    public static byte[] show2dsector;
    public static byte[] show2dwall;
    public static byte[] show2dsprite;
    public static SECTOR[] sector;
    public static WALL[] wall;
    public static SPRITE[] sprite;
    public static SPRITE[] tsprite;
    protected Tile[] tiles;
    public static short[] headspritesect;
    public static short[] headspritestat;
    public static short[] prevspritesect;
    public static short[] prevspritestat;
    public static short[] nextspritesect;
    public static short[] nextspritestat;
    private final char[] fpsbuffer = new char[32];
    private long fpstime = 0L;
    private int fpsx;
    private int fpsy;
    public static byte[] gotpic;
    public static byte[] gotsector;
    public static int spritesortcnt;
    public static int windowx1;
    public static int windowy1;
    public static int windowx2;
    public static int windowy2;
    public static int xdim;
    public static int ydim;
    public static int yxaspect;
    public static int viewingrange;
    public static int mirrorx;
    public static int mirrory;
    public static float mirrorang;
    public static Point intersect;
    public static Point keep;
    public static Clip ray;
    protected static int[] zofslope;
    private float fovFactor = 1.0f;
    public static int rayx;
    public static int rayy;
    public static Hitscan pHitInfo;
    public static Neartag neartag;
    public static int paletteloaded;
    public static int tablesloaded;
    protected static byte[][] britable;
    public static int curbrightness;
    public static int[] picsiz;
    public static int xdimen;
    public static int halfxdimen;
    public static int xdimenscale;
    public static int xdimscale;
    public static int wx1;
    public static int wy1;
    public static int wx2;
    public static int wy2;
    public static int ydimen;
    public static final short[] pow2char;
    public static final int[] pow2long;
    public static Palette curpalette;
    public static FadeEffect palfadergb;
    public static int clipmoveboxtracenum;
    public static int hitscangoalx;
    public static int hitscangoaly;
    public static int globalposx;
    public static int globalposy;
    public static int globalposz;
    public static float globalhoriz;
    public static float globalang;
    public static float pitch;
    public static short globalcursectnum;
    public static int globalvisibility;
    public static int globalshade;
    public static int globalpal;
    public static int cosglobalang;
    public static int singlobalang;
    public static int cosviewingrangeglobalang;
    public static int sinviewingrangeglobalang;
    public static int beforedrawrooms;
    public static int xyaspect;
    public static int viewingrangerecip;
    public static boolean inpreparemirror;
    public static byte[] textfont;
    public static byte[] smalltextfont;
    private byte[] sectbitmap;
    protected int timerfreq;
    protected long timerlastsample;
    private final int newaspect_enable = 1;
    private int setaspect_new_use_dimen;
    private final char[] artfilename = new char[12];
    public int numtilefiles;
    public static Resource artfil;
    public int artfilnum;
    public int artfilplc;
    protected int[] tilefilenum;
    protected int[] tilefileoffs;
    protected int artversion;
    protected int mapversion;
    protected int totalclocklock;
    protected short[] sqrtable;
    protected short[] shlookup;
    private final int hitallsprites = 0;
    private final int MAXCLIPNUM = 1024;
    protected final int MAXCLIPDIST = 1024;
    protected short clipnum;
    protected int[] rxi;
    protected int[] ryi;
    protected short[] hitwalls;
    protected Line[] clipit;
    protected short[] clipsectorlist;
    protected short clipsectnum;
    protected int[] clipobjectval;
    private int[] rdist;
    private int[] gdist;
    private int[] bdist;
    private final int FASTPALGRIDSIZ = 8;
    private final byte[] shortbuf = new byte[2];
    private byte[] colhere;
    private byte[] colhead;
    private short[] colnext;
    private final byte[] coldist = new byte[]{0, 1, 2, 3, 4, 3, 2, 1};
    private int[] colscan;
    protected int randomseed;
    public static short[] radarang;
    public static byte[] transluc;
    protected Byte[] palcache = new Byte[262144];
    HashMap<String, FadeEffect> fades;
    protected static int SETSPRITEZ;
    public static int clipmove_x;
    public static int clipmove_y;
    public static int clipmove_z;
    public static short clipmove_sectnum;
    public static int pushmove_x;
    public static int pushmove_y;
    public static int pushmove_z;
    public static short pushmove_sectnum;
    protected Point rotatepoint = new Point();
    public static int zr_ceilz;
    public static int zr_ceilhit;
    public static int zr_florz;
    public static int zr_florhit;
    protected byte[] temppal = new byte[768];
    private DefScript defs;

    public int getpalookup(int davis, int dashade) {
        return Math.min(Math.max(dashade + (davis >> 8), 0), numshades - 1);
    }

    public int animateoffs(int tilenum, int nInfo) {
        int clock;
        int index = 0;
        int speed = this.getTile(tilenum).getSpeed();
        if ((nInfo & 0xC000) == 32768) {
            this.shortbuf[0] = (byte)(nInfo & 0xFF);
            this.shortbuf[1] = (byte)(nInfo >>> 8 & 0xFF);
            clock = (int)((long)this.totalclocklock + CRC32.getChecksum(this.shortbuf) >> speed);
        } else {
            clock = this.totalclocklock >> speed;
        }
        int frames = this.getTile(tilenum).getFrames();
        if (frames > 0) {
            switch (this.getTile(tilenum).getType()) {
                case Oscil: {
                    index = clock % (frames * 2);
                    if (index < frames) break;
                    index = frames * 2 - index;
                    break;
                }
                case Forward: {
                    index = clock % (frames + 1);
                    break;
                }
                case Backward: {
                    index = -(clock % (frames + 1));
                    break;
                }
            }
        }
        return index;
    }

    public void initksqrt() {
        this.sqrtable = new short[4096];
        this.shlookup = new short[4352];
        int j = 1;
        int k = 0;
        for (int i = 0; i < 4096; ++i) {
            if (i >= j) {
                j <<= 2;
                ++k;
            }
            this.sqrtable[i] = (short)((int)Math.sqrt((i << 18) + 131072) << 1);
            this.shlookup[i] = (short)((k << 1) + (10 - k << 8));
            if (i >= 256) continue;
            this.shlookup[i + 4096] = (short)((k + 6 << 1) + (10 - (k + 6) << 8));
        }
    }

    protected void calcbritable() {
        britable = new byte[16][256];
        for (int i = 0; i < 16; ++i) {
            float a = 8.0f / (float)(i + 8);
            float b = (float)(255.0 / Math.pow(255.0, a));
            for (int j = 0; j < 256; ++j) {
                Engine.britable[i][j] = (byte)(Math.pow(j, a) * (double)b);
            }
        }
    }

    public void loadtables() throws Exception {
        if (tablesloaded == 0) {
            this.initksqrt();
            sintable = new short[2048];
            textfont = new byte[2048];
            smalltextfont = new byte[2048];
            radarang = new short[1280];
            Resource res = BuildGdx.cache.open("tables.dat", 0);
            if (res != null) {
                byte[] buf = new byte[4096];
                res.read(buf);
                ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(sintable);
                buf = new byte[1280];
                res.read(buf);
                ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(radarang, 0, 640);
                for (int i = 0; i < 640; ++i) {
                    Engine.radarang[1279 - i] = -radarang[i];
                }
            } else {
                throw new Exception("ERROR: Failed to load TABLES.DAT!");
            }
            res.read(textfont, 0, 1024);
            res.read(smalltextfont, 0, 1024);
            pTextfont = new TextFont();
            pSmallTextfont = new SmallTextFont();
            this.calcbritable();
            res.close();
            tablesloaded = 1;
        }
    }

    public void initfastcolorlookup(int rscale, int gscale, int bscale) {
        int i;
        int j = 0;
        for (i = 64; i >= 0; --i) {
            int n = j * rscale;
            this.rdist[128 - i] = n;
            this.rdist[i] = n;
            int n2 = j * gscale;
            this.gdist[128 - i] = n2;
            this.gdist[i] = n2;
            int n3 = j * bscale;
            this.bdist[128 - i] = n3;
            this.bdist[i] = n3;
            j += 129 - (i << 1);
        }
        Arrays.fill(this.colhere, (byte)0);
        Arrays.fill(this.colhead, (byte)0);
        int pal1 = 765;
        i = 255;
        while (i >= 0) {
            int r = palette[pal1] & 0xFF;
            int g = palette[pal1 + 1] & 0xFF;
            int b = palette[pal1 + 2] & 0xFF;
            j = (r >> 3) * 8 * 8 + (g >> 3) * 8 + (b >> 3) + 64 + 8 + 1;
            this.colnext[i] = (this.colhere[j >> 3] & pow2char[j & 7]) != 0 ? (int)(this.colhead[j] & 0xFF) : -1;
            this.colhead[j] = (byte)i;
            int n = j >> 3;
            this.colhere[n] = (byte)(this.colhere[n] | pow2char[j & 7]);
            --i;
            pal1 -= 3;
        }
        i = 0;
        for (int x = -64; x <= 64; x += 64) {
            for (int y = -8; y <= 8; y += 8) {
                for (int z = -1; z <= 1; ++z) {
                    this.colscan[i++] = x + y + z;
                }
            }
        }
        i = this.colscan[13];
        this.colscan[13] = this.colscan[26];
        this.colscan[26] = i;
    }

    public void loadpalette() throws Exception {
        if (paletteloaded != 0) {
            return;
        }
        palette = new byte[768];
        curpalette = new Palette();
        palookup = new byte[256][];
        Console.Println("Loading palettes");
        Resource fil = BuildGdx.cache.open("palette.dat", 0);
        if (fil == null) {
            throw new Exception("Failed to load \"palette.dat\"!");
        }
        fil.read(palette);
        numshades = fil.readShort();
        if (palookup[0] == null) {
            Engine.palookup[0] = new byte[numshades << 8];
        }
        if (transluc == null) {
            transluc = new byte[65536];
        }
        globalpal = 0;
        Console.Println("Loading gamma correction tables");
        fil.read(palookup[globalpal], 0, numshades << 8);
        Console.Println("Loading translucency table");
        fil.read(transluc);
        fil.close();
        this.initfastcolorlookup(30, 59, 11);
        paletteloaded = 1;
    }

    public byte getclosestcol(byte[] palette, int r, int g, int b) {
        int pal1;
        int dist;
        int i;
        int j = (r >> 3) * 8 * 8 + (g >> 3) * 8 + (b >> 3) + 64 + 8 + 1;
        int rgb = r << 12 | g << 6 | b;
        int mindist = Math.min(this.rdist[(this.coldist[r & 7] & 0xFF) + 64 + 8], this.gdist[(this.coldist[g & 7] & 0xFF) + 64 + 8]);
        mindist = Math.min(mindist, this.bdist[(this.coldist[b & 7] & 0xFF) + 64 + 8]);
        ++mindist;
        Byte out = this.palcache[rgb & this.palcache.length - 1];
        if (out != null) {
            return out;
        }
        r = 64 - r;
        g = 64 - g;
        b = 64 - b;
        byte retcol = -1;
        for (int k = 26; k >= 0; --k) {
            i = this.colscan[k] + j;
            if ((this.colhere[i >> 3] & pow2char[i & 7]) == 0) continue;
            i = this.colhead[i] & 0xFF;
            do {
                if ((dist = this.gdist[(palette[(pal1 = i * 3) + 1] & 0xFF) + g]) >= mindist || (dist += this.rdist[(palette[pal1] & 0xFF) + r]) >= mindist || (dist += this.bdist[(palette[pal1 + 2] & 0xFF) + b]) >= mindist) continue;
                mindist = dist;
                retcol = (byte)i;
            } while ((i = this.colnext[i]) >= 0);
        }
        if (retcol >= 0) {
            this.palcache[rgb & this.palcache.length - 1] = retcol;
            return retcol;
        }
        mindist = Integer.MAX_VALUE;
        for (i = 255; i >= 0; --i) {
            pal1 = i * 3;
            dist = this.gdist[(palette[pal1 + 1] & 0xFF) + g];
            if (dist >= mindist || (dist += this.rdist[(palette[pal1] & 0xFF) + r]) >= mindist || (dist += this.bdist[(palette[pal1 + 2] & 0xFF) + b]) >= mindist) continue;
            mindist = dist;
            retcol = (byte)i;
        }
        this.palcache[rgb & this.palcache.length - 1] = retcol;
        return retcol;
    }

    public short insertspritesect(int sectnum) {
        if (sectnum >= MAXSECTORS || headspritesect[MAXSECTORS] == -1) {
            return -1;
        }
        short blanktouse = headspritesect[MAXSECTORS];
        Engine.headspritesect[Engine.MAXSECTORS] = nextspritesect[blanktouse];
        if (headspritesect[MAXSECTORS] >= 0) {
            Engine.prevspritesect[Engine.headspritesect[Engine.MAXSECTORS]] = -1;
        }
        Engine.prevspritesect[blanktouse] = -1;
        Engine.nextspritesect[blanktouse] = headspritesect[sectnum];
        if (headspritesect[sectnum] >= 0) {
            Engine.prevspritesect[Engine.headspritesect[sectnum]] = blanktouse;
        }
        Engine.headspritesect[sectnum] = blanktouse;
        Engine.sprite[blanktouse].sectnum = (short)sectnum;
        return blanktouse;
    }

    public short insertspritestat(int newstatnum) {
        if (newstatnum >= 1024 || headspritestat[1024] == -1) {
            return -1;
        }
        short blanktouse = headspritestat[1024];
        Engine.headspritestat[1024] = nextspritestat[blanktouse];
        if (headspritestat[1024] >= 0) {
            Engine.prevspritestat[Engine.headspritestat[1024]] = -1;
        }
        Engine.prevspritestat[blanktouse] = -1;
        Engine.nextspritestat[blanktouse] = headspritestat[newstatnum];
        if (headspritestat[newstatnum] >= 0) {
            Engine.prevspritestat[Engine.headspritestat[newstatnum]] = blanktouse;
        }
        Engine.headspritestat[newstatnum] = blanktouse;
        Engine.sprite[blanktouse].statnum = (short)newstatnum;
        return blanktouse;
    }

    public short insertsprite(int sectnum, int statnum) {
        this.insertspritestat(statnum);
        return this.insertspritesect(sectnum);
    }

    public short deletesprite(int spritenum) {
        GLRenderer gl = this.glrender();
        if (gl != null) {
            gl.removeSpriteCorr(spritenum);
        }
        this.deletespritestat(spritenum);
        return this.deletespritesect(spritenum);
    }

    public short changespritesect(int spritenum, int newsectnum) {
        if (newsectnum < 0 || newsectnum > MAXSECTORS) {
            return -1;
        }
        if (Engine.sprite[spritenum].sectnum == newsectnum) {
            return 0;
        }
        if (Engine.sprite[spritenum].sectnum == MAXSECTORS) {
            return -1;
        }
        if (this.deletespritesect((short)spritenum) < 0) {
            return -1;
        }
        this.insertspritesect(newsectnum);
        return 0;
    }

    public short changespritestat(int spritenum, int newstatnum) {
        if (newstatnum < 0 || newstatnum > 1024) {
            return -1;
        }
        if (Engine.sprite[spritenum].statnum == newstatnum) {
            return 0;
        }
        if (Engine.sprite[spritenum].statnum == 1024) {
            return -1;
        }
        if (this.deletespritestat((short)spritenum) < 0) {
            return -1;
        }
        this.insertspritestat(newstatnum);
        return 0;
    }

    public short deletespritesect(int spritenum) {
        if (Engine.sprite[spritenum].sectnum == MAXSECTORS) {
            return -1;
        }
        if (headspritesect[Engine.sprite[spritenum].sectnum] == spritenum) {
            Engine.headspritesect[Engine.sprite[spritenum].sectnum] = nextspritesect[spritenum];
        }
        if (prevspritesect[spritenum] >= 0) {
            Engine.nextspritesect[Engine.prevspritesect[spritenum]] = nextspritesect[spritenum];
        }
        if (nextspritesect[spritenum] >= 0) {
            Engine.prevspritesect[Engine.nextspritesect[spritenum]] = prevspritesect[spritenum];
        }
        if (headspritesect[MAXSECTORS] >= 0) {
            Engine.prevspritesect[Engine.headspritesect[Engine.MAXSECTORS]] = (short)spritenum;
        }
        Engine.prevspritesect[spritenum] = -1;
        Engine.nextspritesect[spritenum] = headspritesect[MAXSECTORS];
        Engine.headspritesect[Engine.MAXSECTORS] = (short)spritenum;
        Engine.sprite[spritenum].sectnum = (short)MAXSECTORS;
        return 0;
    }

    public short deletespritestat(int spritenum) {
        if (Engine.sprite[spritenum].statnum == 1024) {
            return -1;
        }
        if (headspritestat[Engine.sprite[spritenum].statnum] == spritenum) {
            Engine.headspritestat[Engine.sprite[spritenum].statnum] = nextspritestat[spritenum];
        }
        if (prevspritestat[spritenum] >= 0) {
            Engine.nextspritestat[Engine.prevspritestat[spritenum]] = nextspritestat[spritenum];
        }
        if (nextspritestat[spritenum] >= 0) {
            Engine.prevspritestat[Engine.nextspritestat[spritenum]] = prevspritestat[spritenum];
        }
        if (headspritestat[1024] >= 0) {
            Engine.prevspritestat[Engine.headspritestat[1024]] = (short)spritenum;
        }
        Engine.prevspritestat[spritenum] = -1;
        Engine.nextspritestat[spritenum] = headspritestat[1024];
        Engine.headspritestat[1024] = (short)spritenum;
        Engine.sprite[spritenum].statnum = (short)1024;
        return 0;
    }

    public Point lintersect(int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int x4, int y4) {
        int topu;
        int x21 = x2 - x1;
        int y34 = y3 - y4;
        int y21 = y2 - y1;
        int x34 = x3 - x4;
        int bot = x21 * y34 - y21 * x34;
        if (bot == 0) {
            return null;
        }
        int x31 = x3 - x1;
        int y31 = y3 - y1;
        int topt = x31 * y34 - y31 * x34;
        if (bot > 0) {
            if (topt < 0 || topt >= bot) {
                return null;
            }
            topu = x21 * y31 - y21 * x31;
            if (topu < 0 || topu >= bot) {
                return null;
            }
        } else {
            if (topt > 0 || topt <= bot) {
                return null;
            }
            topu = x21 * y31 - y21 * x31;
            if (topu > 0 || topu <= bot) {
                return null;
            }
        }
        long t = Pragmas.divscale(topt, bot, 24);
        intersect.x = x1 + Pragmas.mulscale(x21, t, 24);
        intersect.y = y1 + Pragmas.mulscale(y21, t, 24);
        intersect.z = z1 + Pragmas.mulscale(z2 - z1, t, 24);
        return intersect;
    }

    protected Point rintersect(int x1, int y1, int z1, int vx, int vy, int vz, int x3, int y3, int x4, int y4) {
        int topt;
        int y34 = y3 - y4;
        int x34 = x3 - x4;
        int bot = vx * y34 - vy * x34;
        if (bot == 0) {
            return null;
        }
        if (bot > 0) {
            int x31 = x3 - x1;
            int y31 = y3 - y1;
            topt = x31 * y34 - y31 * x34;
            if (topt < 0) {
                return null;
            }
            int topu = vx * y31 - vy * x31;
            if (topu < 0 || topu >= bot) {
                return null;
            }
        } else {
            int x31 = x3 - x1;
            int y31 = y3 - y1;
            topt = x31 * y34 - y31 * x34;
            if (topt > 0) {
                return null;
            }
            int topu = vx * y31 - vy * x31;
            if (topu > 0 || topu <= bot) {
                return null;
            }
        }
        long t = Pragmas.divscale(topt, bot, 16);
        intersect.x = x1 + Pragmas.mulscale(vx, t, 16);
        intersect.y = y1 + Pragmas.mulscale(vy, t, 16);
        intersect.z = z1 + Pragmas.mulscale(vz, t, 16);
        return intersect;
    }

    protected Point keepaway(int x, int y, int w) {
        boolean first;
        int x1 = this.clipit[w].x1;
        int dx = this.clipit[w].x2 - x1;
        int y1 = this.clipit[w].y1;
        int dy = this.clipit[w].y2 - y1;
        int ox = Pragmas.ksgn(-dy);
        int oy = Pragmas.ksgn(dx);
        boolean bl = first = Pragmas.klabs(dx) <= Pragmas.klabs(dy);
        while (dx * (y - y1) <= (x - x1) * dy) {
            if (!first) {
                x += ox;
            } else {
                y += oy;
            }
            first ^= true;
        }
        return keep.set(x, y, 0);
    }

    protected Clip raytrace(int x3, int y3, int x4, int y4) {
        int rayx = x4;
        int rayy = y4;
        short hitwall = -1;
        for (short z = (short)(this.clipnum - 1); z >= 0; z = (short)(z - 1)) {
            int nintx;
            int ninty;
            long bot;
            int y43;
            int x43;
            int x2 = this.clipit[z].x2;
            int x1 = this.clipit[z].x1;
            int x21 = x2 - x1;
            int y1 = this.clipit[z].y1;
            int y2 = this.clipit[z].y2;
            int y21 = y2 - y1;
            long topu = x21 * (y3 - y1) - (x3 - x1) * y21;
            if (topu <= 0L || x21 * (rayy - y1) > (rayx - x1) * y21 || (x43 = rayx - x3) * (y1 - y3) > (x1 - x3) * (y43 = rayy - y3) || x43 * (y2 - y3) <= (x2 - x3) * y43 || (bot = (long)(x43 * y21 - x21 * y43)) == 0L) continue;
            int cnt = 256;
            do {
                if (--cnt < 0) {
                    rayx = x3;
                    rayy = y3;
                    return ray.set(rayx, rayy, 0, z);
                }
                nintx = x3 + Pragmas.scale(x43, topu, bot);
                ninty = y3 + Pragmas.scale(y43, topu, bot);
                --topu;
            } while (x21 * (ninty - y1) <= (nintx - x1) * y21);
            if (Pragmas.klabs(x3 - nintx) + Pragmas.klabs(y3 - ninty) >= Pragmas.klabs(x3 - rayx) + Pragmas.klabs(y3 - rayy)) continue;
            rayx = nintx;
            rayy = ninty;
            hitwall = z;
            ray.set(rayx, rayy, 0, hitwall);
        }
        return ray.set(rayx, rayy, 0, hitwall);
    }

    public void InitArrays() {
        intersect = new Point();
        keep = new Point();
        ray = new Clip();
        zofslope = new int[2];
        this.sectbitmap = new byte[MAXSECTORS >> 3];
        palookupfog = new byte[256][3];
        pskyoff = new short[256];
        zeropskyoff = new short[256];
        this.tiles = new Tile[MAXTILES];
        show2dsector = new byte[MAXSECTORS + 7 >> 3];
        show2dwall = new byte[MAXWALLS + 7 >> 3];
        show2dsprite = new byte[MAXSPRITES + 7 >> 3];
        sector = new SECTOR[MAXSECTORS];
        wall = new WALL[MAXWALLS];
        sprite = new SPRITE[MAXSPRITES];
        tsprite = new SPRITE[1025];
        headspritesect = new short[MAXSECTORS + 1];
        headspritestat = new short[1025];
        prevspritesect = new short[MAXSPRITES];
        prevspritestat = new short[MAXSPRITES];
        nextspritesect = new short[MAXSPRITES];
        nextspritestat = new short[MAXSPRITES];
        gotpic = new byte[MAXTILES + 7 >> 3];
        gotsector = new byte[MAXSECTORS + 7 >> 3];
        pHitInfo = new Hitscan();
        neartag = new Neartag();
        picsiz = new int[MAXTILES];
        this.tilefilenum = new int[MAXTILES];
        this.tilefileoffs = new int[MAXTILES];
        this.rxi = new int[4];
        this.ryi = new int[4];
        this.hitwalls = new short[clipmoveboxtracenum + 1];
        this.clipit = new Line[1024];
        this.clipsectorlist = new short[1024];
        this.clipobjectval = new int[1024];
        this.rdist = new int[129];
        this.gdist = new int[129];
        this.bdist = new int[129];
        this.colhere = new byte[125];
        this.colhead = new byte[1000];
        this.colnext = new short[256];
        this.colscan = new int[27];
        Arrays.fill(show2dsector, (byte)0);
        Arrays.fill(show2dsprite, (byte)0);
        Arrays.fill(show2dwall, (byte)0);
        bakwindowx1 = new int[4];
        bakwindowy1 = new int[4];
        bakwindowx2 = new int[4];
        bakwindowy2 = new int[4];
        palfadergb = new FadeEffect(771, 771){

            @Override
            public void update(int intensive) {
            }
        };
    }

    public Engine() throws Exception {
        this.InitArrays();
        this.loadtables();
        parallaxtype = (byte)2;
        parallaxyoffs = 0;
        parallaxyscale = 65536;
        showinvisibility = false;
        pskybits = 0;
        paletteloaded = 0;
        automapping = 0;
        totalclock = 0;
        visibility = 512;
        parallaxvisibility = 512;
        this.loadpalette();
        this.initkeys();
        Console.setFunction(new DEFOSDFUNC(this));
        this.randomseed = 1;
    }

    public void uninit() {
        Iterator<TileFont> it;
        while ((it = TileFont.managedFont.iterator()).hasNext()) {
            TileFont font = it.next();
            font.dispose();
        }
        try {
            if (this.render != null && this.render.isInited()) {
                this.render.uninit();
            }
        }
        catch (Exception font) {
            // empty catch block
        }
        if (artfil != null) {
            artfil.close();
        }
        for (int i = 0; i < 256; ++i) {
            if (palookup[i] == null) continue;
            Engine.palookup[i] = null;
        }
        Mmulti.uninitmultiplayer();
        BuildGdx.audio.dispose();
        BuildGdx.message.dispose();
    }

    public void initspritelists() {
        int i;
        for (i = 0; i < MAXSECTORS; ++i) {
            Engine.headspritesect[i] = -1;
        }
        Engine.headspritesect[Engine.MAXSECTORS] = 0;
        for (i = 0; i < MAXSPRITES; ++i) {
            if (sprite[i] == null) {
                Engine.sprite[i] = new SPRITE();
            } else {
                sprite[i].reset();
            }
            Engine.prevspritesect[i] = (short)(i - 1);
            Engine.nextspritesect[i] = (short)(i + 1);
            Engine.sprite[i].sectnum = (short)MAXSECTORS;
        }
        Engine.prevspritesect[0] = -1;
        Engine.nextspritesect[Engine.MAXSPRITES - 1] = -1;
        for (i = 0; i < 1024; ++i) {
            Engine.headspritestat[i] = -1;
        }
        Engine.headspritestat[1024] = 0;
        for (i = 0; i < MAXSPRITES; ++i) {
            Engine.prevspritestat[i] = (short)(i - 1);
            Engine.nextspritestat[i] = (short)(i + 1);
            Engine.sprite[i].statnum = (short)1024;
        }
        Engine.prevspritestat[0] = -1;
        Engine.nextspritestat[Engine.MAXSPRITES - 1] = -1;
        for (i = 0; i < 1024; ++i) {
            if (tsprite[i] == null) {
                Engine.tsprite[i] = new SPRITE();
                continue;
            }
            tsprite[i].reset();
        }
    }

    public int drawrooms(float daposx, float daposy, float daposz, float daang, float dahoriz, short dacursectnum) {
        beforedrawrooms = 0;
        globalposx = (int)daposx;
        globalposy = (int)daposy;
        globalposz = (int)daposz;
        globalang = Gameutils.BClampAngle(daang);
        globalhoriz = dahoriz - 100.0f;
        pitch = (float)(-this.getangle(160, (int)(dahoriz - 100.0f))) / 5.688889f;
        globalcursectnum = dacursectnum;
        this.totalclocklock = totalclock;
        cosglobalang = (int)Gameutils.BCosAngle(globalang);
        singlobalang = (int)Gameutils.BSinAngle(globalang);
        cosviewingrangeglobalang = Pragmas.mulscale(cosglobalang, viewingrange, 16);
        sinviewingrangeglobalang = Pragmas.mulscale(singlobalang, viewingrange, 16);
        Arrays.fill(gotpic, (byte)0);
        Arrays.fill(gotsector, (byte)0);
        this.render.drawrooms();
        return 0;
    }

    public void drawmasks() {
        this.render.drawmasks();
    }

    public void drawmapview(int dax, int day, int zoome, int ang) {
        this.render.drawmapview(dax, day, zoome, ang);
    }

    public void drawoverheadmap(int cposx, int cposy, int czoom, short cang) {
        this.render.drawoverheadmap(cposx, cposy, czoom, cang);
    }

    public BuildPos loadboard(String filename) throws InvalidVersionException, FileNotFoundException, RuntimeException {
        int i;
        Resource fil = BuildGdx.cache.open(filename, 0);
        if (fil == null) {
            this.mapversion = 7;
            throw new FileNotFoundException("Map " + filename + " not found!");
        }
        this.mapversion = fil.readInt();
        switch (this.mapversion) {
            case 6: {
                return this.loadoldboard(fil);
            }
            case 7: {
                break;
            }
            case 8: {
                if (MAXSECTORS == 4096) break;
            }
            default: {
                fil.close();
                throw new InvalidVersionException(filename + ": invalid map version( v" + this.mapversion + " )!");
            }
        }
        BuildPos pos = new BuildPos();
        this.initspritelists();
        Arrays.fill(show2dsector, (byte)0);
        Arrays.fill(show2dsprite, (byte)0);
        Arrays.fill(show2dwall, (byte)0);
        pos.x = fil.readInt();
        pos.y = fil.readInt();
        pos.z = fil.readInt();
        pos.ang = fil.readShort();
        pos.sectnum = fil.readShort();
        numsectors = fil.readShort();
        for (i = 0; i < numsectors; ++i) {
            Engine.sector[i] = new SECTOR(fil);
        }
        numwalls = fil.readShort();
        for (int w = 0; w < numwalls; ++w) {
            Engine.wall[w] = new WALL(fil);
        }
        numsprites = fil.readShort();
        for (int s = 0; s < numsprites; ++s) {
            sprite[s].buildSprite(fil);
        }
        for (i = 0; i < numsprites; ++i) {
            this.insertsprite(Engine.sprite[i].sectnum, Engine.sprite[i].statnum);
        }
        pos.sectnum = this.updatesector(pos.x, pos.y, pos.sectnum);
        fil.close();
        if (this.inside(pos.x, pos.y, pos.sectnum) == -1) {
            throw new RuntimeException("Player should be in a sector!");
        }
        return pos;
    }

    public BuildPos loadoldboard(Resource fil) throws RuntimeException {
        int i;
        BuildPos pos = new BuildPos();
        this.initspritelists();
        Arrays.fill(show2dsector, (byte)0);
        Arrays.fill(show2dsprite, (byte)0);
        Arrays.fill(show2dwall, (byte)0);
        pos.x = fil.readInt();
        pos.y = fil.readInt();
        pos.z = fil.readInt();
        pos.ang = fil.readShort();
        pos.sectnum = fil.readShort();
        numsectors = fil.readShort();
        for (i = 0; i < numsectors; ++i) {
            SECTOR sec = new SECTOR();
            sec.wallptr = fil.readShort();
            sec.wallnum = fil.readShort();
            sec.ceilingpicnum = fil.readShort();
            sec.floorpicnum = fil.readShort();
            short ceilingheinum = fil.readShort();
            sec.ceilingheinum = (short)Math.max(Math.min(ceilingheinum << 5, Short.MAX_VALUE), Short.MIN_VALUE);
            short floorheinum = fil.readShort();
            sec.floorheinum = (short)Math.max(Math.min(floorheinum << 5, Short.MAX_VALUE), Short.MIN_VALUE);
            sec.ceilingz = fil.readInt();
            sec.floorz = fil.readInt();
            sec.ceilingshade = fil.readByte();
            sec.floorshade = fil.readByte();
            sec.ceilingxpanning = (short)(fil.readByte() & 0xFF);
            sec.floorxpanning = (short)(fil.readByte() & 0xFF);
            sec.ceilingypanning = (short)(fil.readByte() & 0xFF);
            sec.floorypanning = (short)(fil.readByte() & 0xFF);
            sec.ceilingstat = fil.readByte().byteValue();
            if ((sec.ceilingstat & 2) == 0) {
                sec.ceilingheinum = 0;
            }
            sec.floorstat = fil.readByte().byteValue();
            if ((sec.floorstat & 2) == 0) {
                sec.floorheinum = 0;
            }
            sec.ceilingpal = fil.readByte().byteValue();
            sec.floorpal = fil.readByte().byteValue();
            sec.visibility = fil.readByte().byteValue();
            sec.lotag = fil.readShort();
            sec.hitag = fil.readShort();
            sec.extra = fil.readShort();
            Engine.sector[i] = sec;
        }
        numwalls = fil.readShort();
        for (int w = 0; w < numwalls; ++w) {
            WALL wal = new WALL();
            wal.x = fil.readInt();
            wal.y = fil.readInt();
            wal.point2 = fil.readShort();
            wal.nextsector = fil.readShort();
            wal.nextwall = fil.readShort();
            wal.picnum = fil.readShort();
            wal.overpicnum = fil.readShort();
            wal.shade = fil.readByte();
            wal.pal = (short)(fil.readByte() & 0xFF);
            wal.cstat = fil.readShort();
            wal.xrepeat = (short)(fil.readByte() & 0xFF);
            wal.yrepeat = (short)(fil.readByte() & 0xFF);
            wal.xpanning = (short)(fil.readByte() & 0xFF);
            wal.ypanning = (short)(fil.readByte() & 0xFF);
            wal.lotag = fil.readShort();
            wal.hitag = fil.readShort();
            wal.extra = fil.readShort();
            Engine.wall[w] = wal;
        }
        numsprites = fil.readShort();
        for (int s = 0; s < numsprites; ++s) {
            SPRITE spr = sprite[s];
            spr.x = fil.readInt();
            spr.y = fil.readInt();
            spr.z = fil.readInt();
            spr.cstat = fil.readShort();
            spr.shade = fil.readByte();
            spr.pal = fil.readByte().byteValue();
            spr.clipdist = fil.readByte().byteValue();
            spr.xrepeat = (short)(fil.readByte() & 0xFF);
            spr.yrepeat = (short)(fil.readByte() & 0xFF);
            spr.xoffset = (short)(fil.readByte() & 0xFF);
            spr.yoffset = (short)(fil.readByte() & 0xFF);
            spr.picnum = fil.readShort();
            spr.ang = fil.readShort();
            spr.xvel = fil.readShort();
            spr.yvel = fil.readShort();
            spr.zvel = fil.readShort();
            spr.owner = fil.readShort();
            spr.sectnum = fil.readShort();
            spr.statnum = fil.readShort();
            spr.lotag = fil.readShort();
            spr.hitag = fil.readShort();
            spr.extra = fil.readShort();
        }
        for (i = 0; i < numsprites; ++i) {
            this.insertsprite(Engine.sprite[i].sectnum, Engine.sprite[i].statnum);
        }
        pos.sectnum = this.updatesector(pos.x, pos.y, pos.sectnum);
        fil.close();
        if (this.inside(pos.x, pos.y, pos.sectnum) == -1) {
            throw new RuntimeException("Player should be in a sector!");
        }
        return pos;
    }

    public void saveboard(FileResource fil, int daposx, int daposy, int daposz, int daang, int dacursectnum) {
        int s;
        fil.writeInt(7);
        fil.writeInt(daposx);
        fil.writeInt(daposy);
        fil.writeInt(daposz);
        fil.writeShort(daang);
        fil.writeShort(dacursectnum);
        fil.writeShort(numsectors);
        for (s = 0; s < numsectors; ++s) {
            fil.writeBytes(sector[s].getBytes());
        }
        fil.writeShort(numwalls);
        for (s = 0; s < numwalls; ++s) {
            fil.writeBytes(wall[s].getBytes());
        }
        fil.writeShort(numsprites);
        for (s = 0; s < numsprites; ++s) {
            fil.writeBytes(sprite[s].getBytes());
        }
    }

    public boolean setgamemode(int davidoption, int daxdim, int daydim) {
        if (BuildGdx.app.getType() == Application.ApplicationType.Android) {
            daxdim = BuildGdx.graphics.getWidth();
            daydim = BuildGdx.graphics.getHeight();
            davidoption = 0;
        }
        daxdim = Math.max(320, daxdim);
        daydim = Math.max(200, daydim);
        if (this.render.isInited() && davidoption == (BuildGdx.graphics.isFullscreen() ? 1 : 0) && BuildGdx.graphics.getWidth() == daxdim && BuildGdx.graphics.getHeight() == daydim && xdim == daxdim && ydim == daydim) {
            return true;
        }
        xdim = daxdim;
        ydim = daydim;
        this.setview(0, 0, xdim - 1, ydim - 1);
        this.setbrightness(curbrightness, palette, GLRenderer.GLInvalidateFlag.All);
        Console.ResizeDisplay(daxdim, daydim);
        if (this.render instanceof Software) {
            if (this.render.isInited()) {
                this.render.uninit();
            }
            this.render.init();
        }
        if (davidoption == 1) {
            Graphics.DisplayMode m = null;
            for (Graphics.DisplayMode mode : BuildGdx.graphics.getDisplayModes()) {
                if (mode.width != daxdim || mode.height != daydim || m != null && m.refreshRate >= mode.refreshRate) continue;
                m = mode;
            }
            if (m == null) {
                Console.Println("Warning: " + daxdim + "x" + daydim + " fullscreen not supported", Console.OSDTEXT_YELLOW);
                BuildGdx.graphics.setWindowedMode(daxdim, daydim);
                return false;
            }
            BuildGdx.graphics.setFullscreenMode(m);
        } else {
            BuildGdx.graphics.setWindowedMode(daxdim, daydim);
        }
        return true;
    }

    public void inittimer(int tickspersecond) {
        if (this.timerfreq != 0) {
            return;
        }
        this.timerfreq = 1000;
        timerticspersec = tickspersecond;
        this.timerlastsample = System.nanoTime() * (long)timerticspersec / ((long)this.timerfreq * 1000000L);
    }

    public void sampletimer() {
        if (this.timerfreq == 0) {
            return;
        }
        long n = System.nanoTime() * (long)timerticspersec / (long)(this.timerfreq * 1000000) - this.timerlastsample;
        if (n > 0L) {
            totalclock = (int)((long)totalclock + n);
            this.timerlastsample += n;
        }
    }

    public long getticks() {
        return System.currentTimeMillis();
    }

    public void registerFade(String fadename, FadeEffect effect) {
        if (this.fades == null) {
            this.fades = new HashMap();
        }
        this.fades.put(fadename, effect);
    }

    public void updateFade(String fadename, int intensive) {
        FadeEffect effect = this.fades.get(fadename);
        if (effect != null) {
            effect.update(intensive);
        }
    }

    public void showfade() {
        GLRenderer gl = this.glrender();
        if (gl != null) {
            gl.palfade(this.fades);
        }
    }

    public synchronized void loadpic(String filename) {
        Resource fil = BuildGdx.cache.open(filename, 0);
        if (fil != null) {
            int i;
            this.artversion = fil.readInt();
            if (this.artversion != 1) {
                return;
            }
            numtiles = fil.readInt();
            int localtilestart = fil.readInt();
            int localtileend = fil.readInt();
            for (i = localtilestart; i <= localtileend; ++i) {
                this.getTile(i).setWidth(fil.readShort().shortValue());
            }
            for (i = localtilestart; i <= localtileend; ++i) {
                this.getTile(i).setHeight(fil.readShort().shortValue());
            }
            for (i = localtilestart; i <= localtileend; ++i) {
                this.getTile((int)i).anm = fil.readInt();
            }
            for (i = localtilestart; i <= localtileend; ++i) {
                int dasiz = this.getTile(i).getSize();
                if (dasiz > 0) {
                    Tile pic = this.getTile(i);
                    pic.data = new byte[dasiz];
                    fil.read(pic.data);
                }
                this.setpicsiz(i);
            }
            fil.close();
        }
    }

    public void setpicsiz(int tilenum) {
        int j;
        Tile pic = this.getTile(tilenum);
        for (j = 15; j > 1 && pow2long[j] > pic.getWidth(); --j) {
        }
        Engine.picsiz[tilenum] = j;
        for (j = 15; j > 1 && pow2long[j] > pic.getHeight(); --j) {
        }
        int n = tilenum;
        picsiz[n] = picsiz[n] + (j << 4);
    }

    public synchronized int loadpics() {
        int i;
        int k;
        Strhandler.buildString(this.artfilename, 0, this.tilesPath);
        this.numtilefiles = 0;
        do {
            k = this.numtilefiles;
            this.artfilename[7] = (char)(k % 10 + 48);
            this.artfilename[6] = (char)(k / 10 % 10 + 48);
            this.artfilename[5] = (char)(k / 100 % 10 + 48);
            String name = String.copyValueOf(this.artfilename);
            Resource fil = BuildGdx.cache.open(name, 0);
            if (fil == null) continue;
            this.artversion = fil.readInt();
            if (this.artversion != 1) {
                return -1;
            }
            numtiles = fil.readInt();
            int localtilestart = fil.readInt();
            int localtileend = fil.readInt();
            for (i = localtilestart; i <= localtileend; ++i) {
                this.getTile(i).setWidth(fil.readShort().shortValue());
            }
            for (i = localtilestart; i <= localtileend; ++i) {
                this.getTile(i).setHeight(fil.readShort().shortValue());
            }
            for (i = localtilestart; i <= localtileend; ++i) {
                this.getTile((int)i).anm = fil.readInt();
            }
            int offscount = 16 + (localtileend - localtilestart + 1 << 3);
            for (i = localtilestart; i <= localtileend; ++i) {
                this.tilefilenum[i] = k;
                this.tilefileoffs[i] = offscount;
                int dasiz = this.getTile(i).getSize();
                offscount += dasiz;
            }
            ++this.numtilefiles;
            fil.close();
        } while (k != this.numtilefiles);
        for (i = 0; i < MAXTILES; ++i) {
            this.setpicsiz(i);
        }
        if (artfil != null) {
            artfil.close();
        }
        artfil = null;
        this.artfilnum = -1;
        this.artfilplc = 0;
        return this.numtilefiles;
    }

    public synchronized byte[] loadtile(int tilenume) {
        if (tilenume >= MAXTILES) {
            return null;
        }
        Tile pic = this.getTile(tilenume);
        int dasiz = pic.getSize();
        if (dasiz <= 0) {
            return null;
        }
        int i = this.tilefilenum[tilenume];
        if (i != this.artfilnum) {
            if (artfil != null) {
                artfil.close();
            }
            this.artfilnum = i;
            this.artfilplc = 0;
            this.artfilename[7] = (char)(i % 10 + 48);
            this.artfilename[6] = (char)(i / 10 % 10 + 48);
            this.artfilename[5] = (char)(i / 100 % 10 + 48);
            artfil = BuildGdx.cache.open(new String(this.artfilename), 0);
            this.faketimerhandler();
        }
        if (artfil == null) {
            return null;
        }
        if (pic.data == null) {
            pic.data = new byte[dasiz];
        }
        if (this.artfilplc != this.tilefileoffs[tilenume]) {
            artfil.seek(this.tilefileoffs[tilenume] - this.artfilplc, Resource.Whence.Current);
            this.faketimerhandler();
        }
        if (artfil.read(pic.data) == -1) {
            return null;
        }
        this.faketimerhandler();
        this.artfilplc = this.tilefileoffs[tilenume] + dasiz;
        return pic.data;
    }

    public byte[] allocatepermanenttile(int tilenume, int xsiz, int ysiz) {
        if (xsiz <= 0 || ysiz <= 0 || tilenume >= MAXTILES) {
            return null;
        }
        Tile pic = this.getTile(tilenume);
        pic.allocate(xsiz, ysiz);
        this.setpicsiz(tilenume);
        return pic.data;
    }

    public int clipinsidebox(int x, int y, int wallnum, int walldist) {
        int r = walldist << 1;
        if (Gameutils.isCorruptWall(wallnum)) {
            return 0;
        }
        WALL wal = wall[wallnum];
        int x1 = wal.x + walldist - x;
        int y1 = wal.y + walldist - y;
        wal = wall[wal.point2];
        int x2 = wal.x + walldist - x;
        int y2 = wal.y + walldist - y;
        if (x1 < 0 && x2 < 0) {
            return 0;
        }
        if (y1 < 0 && y2 < 0) {
            return 0;
        }
        if (x1 >= r && x2 >= r) {
            return 0;
        }
        if (y1 >= r && y2 >= r) {
            return 0;
        }
        if ((x2 -= x1) * (walldist - y1) >= (y2 -= y1) * (walldist - x1)) {
            x2 = x2 > 0 ? (x2 *= 0 - y1) : (x2 *= r - y1);
            y2 = y2 > 0 ? (y2 *= r - x1) : (y2 *= 0 - x1);
            return x2 < y2 ? 1 : 0;
        }
        x2 = x2 > 0 ? (x2 *= r - y1) : (x2 *= 0 - y1);
        y2 = y2 > 0 ? (y2 *= 0 - x1) : (y2 *= r - x1);
        return (x2 >= y2 ? 1 : 0) << 1;
    }

    public int clipinsideboxline(int x, int y, int x1, int y1, int x2, int y2, int walldist) {
        int r = walldist << 1;
        if ((x1 += walldist - x) < 0 && (x2 += walldist - x) < 0 || x1 >= r && x2 >= r) {
            return 0;
        }
        if ((y1 += walldist - y) < 0 && (y2 += walldist - y) < 0 || y1 >= r && y2 >= r) {
            return 0;
        }
        if ((x2 -= x1) * (walldist - y1) >= (y2 -= y1) * (walldist - x1)) {
            return (x2 *= x2 > 0 ? 0 - y1 : r - y1) < (y2 *= y2 > 0 ? r - x1 : 0 - x1) ? 1 : 0;
        }
        return ((x2 *= x2 > 0 ? r - y1 : 0 - y1) >= (y2 *= y2 > 0 ? 0 - x1 : r - x1) ? 1 : 0) << 1;
    }

    public int inside(int x, int y, int sectnum) {
        if (!Gameutils.isValidSector(sectnum)) {
            return -1;
        }
        int cnt = 0;
        short wallid = Engine.sector[sectnum].wallptr;
        int i = Engine.sector[sectnum].wallnum;
        if (wallid < 0) {
            return -1;
        }
        do {
            if (Gameutils.isCorruptWall(wallid)) {
                return -1;
            }
            WALL wal = wall[wallid];
            int y1 = wal.y - y;
            int y2 = Engine.wall[wal.point2].y - y;
            if ((y1 ^ y2) < 0) {
                int x1 = wal.x - x;
                int x2 = Engine.wall[wal.point2].x - x;
                cnt = (x1 ^ x2) >= 0 ? (cnt ^= x1) : (cnt ^= x1 * y2 - x2 * y1 ^ y2);
            }
            wallid = (short)(wallid + 1);
        } while (--i != 0);
        return cnt >>> 31;
    }

    public short getangle(int xvect, int yvect) {
        if ((xvect | yvect) == 0) {
            return 0;
        }
        if (xvect == 0) {
            return (short)(512 + ((yvect < 0 ? 1 : 0) << 10));
        }
        if (yvect == 0) {
            return (short)((xvect < 0 ? 1 : 0) << 10);
        }
        if (xvect == yvect) {
            return (short)(256 + ((xvect < 0 ? 1 : 0) << 10));
        }
        if (xvect == -yvect) {
            return (short)(768 + ((xvect > 0 ? 1 : 0) << 10));
        }
        if (Math.abs((long)xvect) > Math.abs((long)yvect)) {
            return (short)((radarang[640 + Pragmas.scale(160L, yvect, xvect)] >> 6) + ((xvect < 0 ? 1 : 0) << 10) & 0x7FF);
        }
        return (short)((radarang[640 - Pragmas.scale(160L, xvect, yvect)] >> 6) + 512 + ((yvect < 0 ? 1 : 0) << 10) & 0x7FF);
    }

    public int ksqrt(int a) {
        long out = (long)a & 0xFFFFFFFFL;
        int value = (out & 0xFFFFFFFFFF000000L) != 0L ? this.shlookup[(int)((out >> 24) + 4096L)] & 0xFFFF : this.shlookup[(int)(out >> 12)] & 0xFFFF;
        out >>= value & 0xFF;
        out = out & 0xFFFFFFFFFFFF0000L | (long)(this.sqrtable[(int)out] & 0xFFFF);
        return (int)(out >>= (value & 0xFF00) >> 8);
    }

    public short setsprite(int spritenum, int newx, int newy, int newz) {
        Engine.sprite[spritenum].x = newx;
        Engine.sprite[spritenum].y = newy;
        Engine.sprite[spritenum].z = newz;
        short tempsectnum = Engine.sprite[spritenum].sectnum;
        tempsectnum = SETSPRITEZ == 1 ? this.updatesectorz(newx, newy, newz, tempsectnum) : this.updatesector(newx, newy, tempsectnum);
        if (tempsectnum < 0) {
            return -1;
        }
        if (tempsectnum != Engine.sprite[spritenum].sectnum) {
            this.changespritesect((short)spritenum, tempsectnum);
        }
        return 0;
    }

    public int nextsectorneighborz(int sectnum, int thez, int topbottom, int direction) {
        int nextz = Integer.MIN_VALUE;
        if (direction == 1) {
            nextz = Integer.MAX_VALUE;
        }
        int sectortouse = -1;
        short wallid = Engine.sector[sectnum].wallptr;
        int i = Engine.sector[sectnum].wallnum;
        do {
            WALL wal = wall[wallid];
            if (wal.nextsector >= 0) {
                int testz = topbottom == 1 ? Engine.sector[wal.nextsector].floorz : Engine.sector[wal.nextsector].ceilingz;
                if (direction == 1) {
                    if (testz > thez && testz < nextz) {
                        nextz = testz;
                        sectortouse = wal.nextsector;
                    }
                } else if (testz < thez && testz > nextz) {
                    nextz = testz;
                    sectortouse = wal.nextsector;
                }
            }
            wallid = (short)(wallid + 1);
        } while (--i != 0);
        return sectortouse;
    }

    public boolean cansee(int x1, int y1, int z1, int sect1, int x2, int y2, int z2, int sect2) {
        Arrays.fill(this.sectbitmap, (byte)0);
        if (!Gameutils.isValidSector(sect1)) {
            return false;
        }
        if (!Gameutils.isValidSector(sect2)) {
            return false;
        }
        if (x1 == x2 && y1 == y2) {
            return sect1 == sect2;
        }
        int x21 = x2 - x1;
        int y21 = y2 - y1;
        int z21 = z2 - z1;
        int n = sect1 >> 3;
        this.sectbitmap[n] = (byte)(this.sectbitmap[n] | 1 << (sect1 & 7));
        this.clipsectorlist[0] = (short)sect1;
        int danum = 1;
        for (int dacnt = 0; dacnt < danum; ++dacnt) {
            short dasectnum = this.clipsectorlist[dacnt];
            if (!Gameutils.isValidSector(dasectnum)) continue;
            SECTOR sec = sector[dasectnum];
            int startwall = sec.wallptr;
            int endwall = startwall + sec.wallnum - 1;
            if (startwall < 0 || endwall < 0) continue;
            for (int w = startwall; w <= endwall; ++w) {
                long t;
                if (Gameutils.isCorruptWall(w)) continue;
                WALL wal = wall[w];
                WALL wal2 = wall[wal.point2];
                int x31 = wal.x - x1;
                int x34 = wal.x - wal2.x;
                int y31 = wal.y - y1;
                int y34 = wal.y - wal2.y;
                int bot = y21 * x34 - x21 * y34;
                if (bot <= 0 || ((t = (long)(y21 * x31 - x21 * y31)) & 0xFFFFFFFFL) >= ((long)bot & 0xFFFFFFFFL) || ((t = (long)(y31 * x34 - x31 * y34)) & 0xFFFFFFFFL) >= ((long)bot & 0xFFFFFFFFL)) continue;
                short nexts = wal.nextsector;
                if (nexts < 0 || (wal.cstat & 0x20) != 0) {
                    return false;
                }
                t = Pragmas.divscale(t, bot, 24);
                int x = x1 + Pragmas.mulscale(x21, t, 24);
                int y = y1 + Pragmas.mulscale(y21, t, 24);
                int z = z1 + Pragmas.mulscale(z21, t, 24);
                this.getzsofslope(dasectnum, x, y, zofslope);
                if (z <= zofslope[0] || z >= zofslope[1]) {
                    return false;
                }
                this.getzsofslope(nexts, x, y, zofslope);
                if (z <= zofslope[0] || z >= zofslope[1]) {
                    return false;
                }
                if ((this.sectbitmap[nexts >> 3] & 1 << (nexts & 7)) != 0) continue;
                int n2 = nexts >> 3;
                this.sectbitmap[n2] = (byte)(this.sectbitmap[n2] | 1 << (nexts & 7));
                this.clipsectorlist[danum++] = nexts;
            }
        }
        return (this.sectbitmap[sect2 >> 3] & 1 << (sect2 & 7)) != 0;
    }

    public int hitscan(int xs, int ys, int zs, int sectnum, int vx, int vy, int vz, Hitscan hit, int cliptype) {
        int y1 = 0;
        int z1 = 0;
        hit.hitsect = (short)-1;
        hit.hitwall = (short)-1;
        hit.hitsprite = (short)-1;
        if (sectnum < 0 || sectnum >= MAXSECTORS) {
            return -1;
        }
        hit.hitx = hitscangoalx;
        hit.hity = hitscangoaly;
        int dawalclipmask = cliptype & 0xFFFF;
        int dasprclipmask = cliptype >> 16;
        this.clipsectorlist[0] = (short)sectnum;
        int tempshortcnt = 0;
        int tempshortnum = 1;
        do {
            int intz;
            int inty;
            int intx;
            Point out;
            int x2;
            int y2;
            short z;
            int j;
            int i;
            int day;
            int dax;
            WALL wal2;
            WALL wal;
            short dasector;
            if ((dasector = this.clipsectorlist[tempshortcnt]) < 0) {
                tempshortcnt = (short)(tempshortcnt + 1);
                continue;
            }
            SECTOR sec = sector[dasector];
            if (sec == null) {
                tempshortcnt = (short)(tempshortcnt + 1);
                continue;
            }
            int x1 = Integer.MAX_VALUE;
            if ((sec.ceilingstat & 2) != 0) {
                wal = wall[sec.wallptr];
                wal2 = wall[wal.point2];
                dax = wal2.x - wal.x;
                day = wal2.y - wal.y;
                i = this.ksqrt(dax * dax + day * day);
                if (i == 0) continue;
                j = (vz << 8) - Pragmas.dmulscale(dax *= (i = Pragmas.divscale(sec.ceilingheinum, i, 15)), vy, -(day *= i), vx, 15);
                if (j != 0 && ((i = (sec.ceilingz - zs << 8) + Pragmas.dmulscale(dax, ys - wal.y, -day, xs - wal.x, 15)) ^ j) >= 0 && Pragmas.klabs(i) >> 1 < Pragmas.klabs(j)) {
                    i = Pragmas.divscale(i, j, 30);
                    x1 = xs + Pragmas.mulscale(vx, i, 30);
                    y1 = ys + Pragmas.mulscale(vy, i, 30);
                    z1 = zs + Pragmas.mulscale(vz, i, 30);
                }
            } else if (vz < 0 && zs >= sec.ceilingz && Pragmas.klabs(i = (z1 = sec.ceilingz) - zs) >> 1 < -vz) {
                i = Pragmas.divscale(i, vz, 30);
                x1 = xs + Pragmas.mulscale(vx, i, 30);
                y1 = ys + Pragmas.mulscale(vy, i, 30);
            }
            if (x1 != Integer.MAX_VALUE && Pragmas.klabs(x1 - xs) + Pragmas.klabs(y1 - ys) < Pragmas.klabs(hit.hitx - xs) + Pragmas.klabs(hit.hity - ys) && this.inside(x1, y1, dasector) != 0) {
                hit.hitsect = dasector;
                hit.hitwall = (short)-1;
                hit.hitsprite = (short)-1;
                hit.hitx = x1;
                hit.hity = y1;
                hit.hitz = z1;
            }
            x1 = Integer.MAX_VALUE;
            if ((sec.floorstat & 2) != 0) {
                wal = wall[sec.wallptr];
                wal2 = wall[wal.point2];
                dax = wal2.x - wal.x;
                day = wal2.y - wal.y;
                i = this.ksqrt(dax * dax + day * day);
                if (i == 0) continue;
                j = (vz << 8) - Pragmas.dmulscale(dax *= (i = Pragmas.divscale(sec.floorheinum, i, 15)), vy, -(day *= i), vx, 15);
                if (j != 0 && ((i = (sec.floorz - zs << 8) + Pragmas.dmulscale(dax, ys - wal.y, -day, xs - wal.x, 15)) ^ j) >= 0 && Pragmas.klabs(i) >> 1 < Pragmas.klabs(j)) {
                    i = Pragmas.divscale(i, j, 30);
                    x1 = xs + Pragmas.mulscale(vx, i, 30);
                    y1 = ys + Pragmas.mulscale(vy, i, 30);
                    z1 = zs + Pragmas.mulscale(vz, i, 30);
                }
            } else if (vz > 0 && zs <= sec.floorz && Pragmas.klabs(i = (z1 = sec.floorz) - zs) >> 1 < vz) {
                i = Pragmas.divscale(i, vz, 30);
                x1 = xs + Pragmas.mulscale(vx, i, 30);
                y1 = ys + Pragmas.mulscale(vy, i, 30);
            }
            if (x1 != Integer.MAX_VALUE && Pragmas.klabs(x1 - xs) + Pragmas.klabs(y1 - ys) < Pragmas.klabs(hit.hitx - xs) + Pragmas.klabs(hit.hity - ys) && this.inside(x1, y1, dasector) != 0) {
                hit.hitsect = dasector;
                hit.hitwall = (short)-1;
                hit.hitsprite = (short)-1;
                hit.hitx = x1;
                hit.hity = y1;
                hit.hitz = z1;
            }
            short startwall = sec.wallptr;
            int endwall = startwall + sec.wallnum;
            if (startwall < 0 || endwall < 0) {
                tempshortcnt = (short)(tempshortcnt + 1);
                continue;
            }
            for (z = startwall; z < endwall; z = (short)(z + 1)) {
                int zz;
                if (Gameutils.isCorruptWall(z)) continue;
                WALL wal3 = wall[z];
                WALL wal22 = wall[wal3.point2];
                x1 = wal3.x;
                y2 = wal22.y;
                x2 = wal22.x;
                y1 = wal3.y;
                if ((x1 - xs) * (y2 - ys) < (x2 - xs) * (y1 - ys) || (out = this.rintersect(xs, ys, zs, vx, vy, vz, x1, y1, x2, y2)) == null) continue;
                intx = out.getX();
                inty = out.getY();
                intz = out.getZ();
                if (Pragmas.klabs(intx - xs) + Pragmas.klabs(inty - ys) >= Pragmas.klabs(hit.hitx - xs) + Pragmas.klabs(hit.hity - ys)) continue;
                short nextsector = wal3.nextsector;
                if (nextsector < 0 || (wal3.cstat & dawalclipmask) != 0) {
                    hit.hitsect = dasector;
                    hit.hitwall = z;
                    hit.hitsprite = (short)-1;
                    hit.hitx = intx;
                    hit.hity = inty;
                    hit.hitz = intz;
                    continue;
                }
                this.getzsofslope(nextsector, intx, inty, zofslope);
                if (intz <= zofslope[0] || intz >= zofslope[1]) {
                    hit.hitsect = dasector;
                    hit.hitwall = z;
                    hit.hitsprite = (short)-1;
                    hit.hitx = intx;
                    hit.hity = inty;
                    hit.hitz = intz;
                    continue;
                }
                for (zz = tempshortnum - 1; zz >= 0 && this.clipsectorlist[zz] != nextsector; --zz) {
                }
                if (zz >= 0) continue;
                int n = tempshortnum;
                tempshortnum = (short)(tempshortnum + 1);
                this.clipsectorlist[n] = nextsector;
            }
            z = headspritesect[dasector];
            while (z >= 0) {
                SPRITE spr = sprite[z];
                short cstat = spr.cstat;
                if ((cstat & dasprclipmask) != 0) {
                    x1 = spr.x;
                    y1 = spr.y;
                    z1 = spr.z;
                    Tile pic = this.getTile(spr.picnum);
                    switch (cstat & 0x30) {
                        case 0: {
                            int bot;
                            int topt = vx * (x1 - xs) + vy * (y1 - ys);
                            if (topt <= 0 || (bot = vx * vx + vy * vy) == 0) break;
                            intz = zs + Pragmas.scale(vz, topt, bot);
                            i = pic.getHeight() * spr.yrepeat << 2;
                            if ((cstat & 0x80) != 0) {
                                z1 += i >> 1;
                            }
                            if ((pic.anm & 0xFF0000) != 0) {
                                z1 -= pic.getOffsetY() * spr.yrepeat << 2;
                            }
                            if (intz > z1 || intz < z1 - i) break;
                            int topu = vx * (y1 - ys) - vy * (x1 - xs);
                            int offx = Pragmas.scale(vx, topu, bot);
                            int offy = Pragmas.scale(vy, topu, bot);
                            int dist = offx * offx + offy * offy;
                            i = pic.getWidth() * spr.xrepeat;
                            if (dist > (i *= i) >> 7) break;
                            intx = xs + Pragmas.scale(vx, topt, bot);
                            inty = ys + Pragmas.scale(vy, topt, bot);
                            if (Pragmas.klabs(intx - xs) + Pragmas.klabs(inty - ys) > Pragmas.klabs(hit.hitx - xs) + Pragmas.klabs(hit.hity - ys)) break;
                            hit.hitsect = dasector;
                            hit.hitwall = (short)-1;
                            hit.hitsprite = z;
                            hit.hitx = intx;
                            hit.hity = inty;
                            hit.hitz = intz;
                            break;
                        }
                        case 16: {
                            byte xoff = (byte)(pic.getOffsetX() + spr.xoffset);
                            if ((cstat & 4) > 0) {
                                xoff = -xoff;
                            }
                            int k = spr.ang;
                            int l = spr.xrepeat;
                            dax = sintable[k & 0x7FF] * l;
                            day = sintable[k + 1536 & 0x7FF] * l;
                            l = pic.getWidth();
                            k = (l >> 1) + xoff;
                            x2 = (x1 -= Pragmas.mulscale(dax, k, 16)) + Pragmas.mulscale(dax, l, 16);
                            y2 = (y1 -= Pragmas.mulscale(day, k, 16)) + Pragmas.mulscale(day, l, 16);
                            if ((cstat & 0x40) != 0 && (x1 - xs) * (y2 - ys) < (x2 - xs) * (y1 - ys) || (out = this.rintersect(xs, ys, zs, vx, vy, vz, x1, y1, x2, y2)) == null) break;
                            intx = out.getX();
                            inty = out.getY();
                            intz = out.getZ();
                            if (Pragmas.klabs(intx - xs) + Pragmas.klabs(inty - ys) > Pragmas.klabs(hit.hitx - xs) + Pragmas.klabs(hit.hity - ys)) break;
                            k = pic.getHeight() * spr.yrepeat << 2;
                            Engine.zofslope[0] = (cstat & 0x80) != 0 ? spr.z + (k >> 1) : spr.z;
                            if ((pic.anm & 0xFF0000) != 0) {
                                zofslope[0] = zofslope[0] - (pic.getOffsetY() * spr.yrepeat << 2);
                            }
                            if (intz >= zofslope[0] || intz <= zofslope[0] - k) break;
                            hit.hitsect = dasector;
                            hit.hitwall = (short)-1;
                            hit.hitsprite = z;
                            hit.hitx = intx;
                            hit.hity = inty;
                            hit.hitz = intz;
                            break;
                        }
                        case 32: {
                            if (vz == 0 || ((intz = z1) - zs ^ vz) < 0 || (cstat & 0x40) != 0 && zs > intz == ((cstat & 8) == 0)) break;
                            intx = xs + Pragmas.scale(intz - zs, vx, vz);
                            inty = ys + Pragmas.scale(intz - zs, vy, vz);
                            if (Pragmas.klabs(intx - xs) + Pragmas.klabs(inty - ys) > Pragmas.klabs(hit.hitx - xs) + Pragmas.klabs(hit.hity - ys)) break;
                            byte xoff = (byte)(pic.getOffsetX() + spr.xoffset);
                            byte yoff = (byte)(pic.getOffsetY() + spr.yoffset);
                            if ((cstat & 4) > 0) {
                                xoff = -xoff;
                            }
                            if ((cstat & 8) > 0) {
                                yoff = -yoff;
                            }
                            short ang = spr.ang;
                            short cosang = sintable[ang + 512 & 0x7FF];
                            short sinang = sintable[ang & 0x7FF];
                            int xspan = pic.getWidth();
                            short xrepeat = spr.xrepeat;
                            int yspan = pic.getHeight();
                            short yrepeat = spr.yrepeat;
                            dax = ((xspan >> 1) + xoff) * xrepeat;
                            day = ((yspan >> 1) + yoff) * yrepeat;
                            int l = xspan * xrepeat;
                            x2 = (x1 += Pragmas.dmulscale(sinang, dax, cosang, day, 16) - intx) - Pragmas.mulscale(sinang, l, 16);
                            y2 = (y1 += Pragmas.dmulscale(sinang, day, -cosang, dax, 16) - inty) + Pragmas.mulscale(cosang, l, 16);
                            l = yspan * yrepeat;
                            int k = -Pragmas.mulscale(cosang, l, 16);
                            int x3 = x2 + k;
                            int x4 = x1 + k;
                            k = -Pragmas.mulscale(sinang, l, 16);
                            int y3 = y2 + k;
                            int y4 = y1 + k;
                            boolean clipyou = false;
                            if ((y1 ^ y2) < 0) {
                                if ((x1 ^ x2) < 0) {
                                    clipyou ^= x1 * y2 < x2 * y1 ^ y1 < y2;
                                } else if (x1 >= 0) {
                                    clipyou ^= true;
                                }
                            }
                            if ((y2 ^ y3) < 0) {
                                if ((x2 ^ x3) < 0) {
                                    clipyou ^= x2 * y3 < x3 * y2 ^ y2 < y3;
                                } else if (x2 >= 0) {
                                    clipyou ^= true;
                                }
                            }
                            if ((y3 ^ y4) < 0) {
                                if ((x3 ^ x4) < 0) {
                                    clipyou ^= x3 * y4 < x4 * y3 ^ y3 < y4;
                                } else if (x3 >= 0) {
                                    clipyou ^= true;
                                }
                            }
                            if ((y4 ^ y1) < 0) {
                                if ((x4 ^ x1) < 0) {
                                    clipyou ^= x4 * y1 < x1 * y4 ^ y4 < y1;
                                } else if (x4 >= 0) {
                                    clipyou ^= true;
                                }
                            }
                            if (!clipyou) break;
                            hit.hitsect = dasector;
                            hit.hitwall = (short)-1;
                            hit.hitsprite = z;
                            hit.hitx = intx;
                            hit.hity = inty;
                            hit.hitz = intz;
                        }
                    }
                }
                z = nextspritesect[z];
            }
            tempshortcnt = (short)(tempshortcnt + 1);
        } while (tempshortcnt < tempshortnum);
        return 0;
    }

    public void nextpage() {
        this.faketimerhandler();
        Console.draw();
        this.render.nextpage();
        BuildGdx.audio.update();
        this.totalclocklock = totalclock;
    }

    public int neartag(int xs, int ys, int zs, int sectnum, int ange, Neartag near, int neartagrange, int tagsearch) {
        near.tagsector = (short)-1;
        near.tagwall = (short)-1;
        near.tagsprite = (short)-1;
        near.taghitdist = 0;
        if (sectnum < 0 || sectnum >= MAXSECTORS || (tagsearch & 3) == 0) {
            return 0;
        }
        int vx = Pragmas.mulscale(sintable[ange + 2560 & 0x7FF], neartagrange, 14);
        int xe = xs + vx;
        int vy = Pragmas.mulscale(sintable[ange + 2048 & 0x7FF], neartagrange, 14);
        int ye = ys + vy;
        int vz = 0;
        int ze = 0;
        this.clipsectorlist[0] = (short)sectnum;
        int tempshortcnt = 0;
        int tempshortnum = 1;
        do {
            short good;
            int y1;
            int x1;
            short z;
            short dasector;
            if ((dasector = this.clipsectorlist[tempshortcnt]) < 0) {
                tempshortcnt = (short)(tempshortcnt + 1);
                continue;
            }
            short startwall = Engine.sector[dasector].wallptr;
            int endwall = startwall + Engine.sector[dasector].wallnum - 1;
            if (startwall < 0 || endwall < 0) {
                tempshortcnt = (short)(tempshortcnt + 1);
                continue;
            }
            for (z = startwall; z <= endwall; z = (short)(z + 1)) {
                int zz;
                Point out;
                WALL wal = wall[z];
                WALL wal2 = wall[wal.point2];
                x1 = wal.x;
                y1 = wal.y;
                int x2 = wal2.x;
                int y2 = wal2.y;
                short nextsector = wal.nextsector;
                good = 0;
                if (nextsector >= 0) {
                    if ((tagsearch & 1) != 0 && Engine.sector[nextsector].lotag != 0) {
                        good = (short)(good | 1);
                    }
                    if ((tagsearch & 2) != 0 && Engine.sector[nextsector].hitag != 0) {
                        good = (short)(good | 1);
                    }
                }
                if ((tagsearch & 1) != 0 && wal.lotag != 0) {
                    good = (short)(good | 2);
                }
                if ((tagsearch & 2) != 0 && wal.hitag != 0) {
                    good = (short)(good | 2);
                }
                if (good == 0 && nextsector < 0 || (x1 - xs) * (y2 - ys) < (x2 - xs) * (y1 - ys) || (out = this.lintersect(xs, ys, zs, xe, ye, ze, x1, y1, x2, y2)) == null) continue;
                if (good != 0) {
                    if ((good & 1) != 0) {
                        near.tagsector = nextsector;
                    }
                    if ((good & 2) != 0) {
                        near.tagwall = z;
                    }
                    near.taghitdist = Pragmas.dmulscale(out.getX() - xs, sintable[ange + 2560 & 0x7FF], out.getY() - ys, sintable[ange + 2048 & 0x7FF], 14);
                    xe = out.getX();
                    ye = out.getY();
                    ze = out.getZ();
                }
                if (nextsector < 0) continue;
                for (zz = tempshortnum - 1; zz >= 0 && this.clipsectorlist[zz] != nextsector; --zz) {
                }
                if (zz >= 0) continue;
                int n = tempshortnum;
                tempshortnum = (short)(tempshortnum + 1);
                this.clipsectorlist[n] = nextsector;
            }
            z = headspritesect[dasector];
            while (z >= 0) {
                SPRITE spr = sprite[z];
                good = 0;
                if ((tagsearch & 1) != 0 && spr.lotag != 0) {
                    good = (short)(good | 1);
                }
                if ((tagsearch & 2) != 0 && spr.hitag != 0) {
                    good = (short)(good | 1);
                }
                if (good != 0) {
                    int bot;
                    x1 = spr.x;
                    y1 = spr.y;
                    int z1 = spr.z;
                    int topt = vx * (x1 - xs) + vy * (y1 - ys);
                    if (topt > 0 && (bot = vx * vx + vy * vy) != 0) {
                        int intz = zs + Pragmas.scale(vz, topt, bot);
                        Tile pic = this.getTile(spr.picnum);
                        int i = pic.getHeight() * spr.yrepeat;
                        if ((spr.cstat & 0x80) != 0) {
                            z1 += i << 1;
                        }
                        if ((pic.anm & 0xFF0000) != 0) {
                            z1 -= pic.getOffsetY() * spr.yrepeat << 2;
                        }
                        if (intz <= z1 && intz >= z1 - (i << 2)) {
                            int topu = vx * (y1 - ys) - vy * (x1 - xs);
                            int offx = Pragmas.scale(vx, topu, bot);
                            int offy = Pragmas.scale(vy, topu, bot);
                            int dist = offx * offx + offy * offy;
                            i = pic.getWidth() * spr.xrepeat;
                            if (dist <= (i *= i) >> 7) {
                                int intx = xs + Pragmas.scale(vx, topt, bot);
                                int inty = ys + Pragmas.scale(vy, topt, bot);
                                if (Pragmas.klabs(intx - xs) + Pragmas.klabs(inty - ys) < Pragmas.klabs(xe - xs) + Pragmas.klabs(ye - ys)) {
                                    near.tagsprite = z;
                                    near.taghitdist = Pragmas.dmulscale(intx - xs, sintable[ange + 2560 & 0x7FF], inty - ys, sintable[ange + 2048 & 0x7FF], 14);
                                    xe = intx;
                                    ye = inty;
                                    ze = intz;
                                }
                            }
                        }
                    }
                }
                z = nextspritesect[z];
            }
            tempshortcnt = (short)(tempshortcnt + 1);
        } while (tempshortcnt < tempshortnum);
        return 0;
    }

    public long qdist(long dx, long dy) {
        if ((dx = Math.abs(dx)) > (dy = Math.abs(dy))) {
            dy = 3L * dy >> 3;
        } else {
            dx = 3L * dx >> 3;
        }
        return dx + dy;
    }

    public void dragpoint(int pointhighlight, int dax, int day) {
        Engine.wall[pointhighlight].x = dax;
        Engine.wall[pointhighlight].y = day;
        int cnt = MAXWALLS;
        int tempshort = pointhighlight;
        block0: do {
            if (Engine.wall[tempshort].nextwall >= 0) {
                tempshort = Engine.wall[Engine.wall[tempshort].nextwall].point2;
                Engine.wall[tempshort].x = dax;
                Engine.wall[tempshort].y = day;
                continue;
            }
            tempshort = pointhighlight;
            while (Engine.wall[this.lastwall((int)tempshort)].nextwall >= 0) {
                tempshort = Engine.wall[this.lastwall((int)tempshort)].nextwall;
                Engine.wall[tempshort].x = dax;
                Engine.wall[tempshort].y = day;
                if (tempshort != pointhighlight && --cnt > 0) continue;
                break block0;
            }
            break;
        } while (tempshort != pointhighlight && --cnt > 0);
    }

    public int lastwall(int point) {
        if (point > 0 && Engine.wall[point - 1].point2 == point) {
            return point - 1;
        }
        int i = point;
        int cnt = MAXWALLS;
        do {
            short j;
            if ((j = Engine.wall[i].point2) == point) {
                return i;
            }
            i = j;
        } while (--cnt > 0);
        return point;
    }

    protected void addclipline(int dax1, int day1, int dax2, int day2, int daoval) {
        if (this.clipnum < 1024) {
            if (this.clipit[this.clipnum] == null) {
                this.clipit[this.clipnum] = new Line();
            }
            this.clipit[this.clipnum].x1 = dax1;
            this.clipit[this.clipnum].y1 = day1;
            this.clipit[this.clipnum].x2 = dax2;
            this.clipit[this.clipnum].y2 = day2;
            this.clipobjectval[this.clipnum] = daoval;
            this.clipnum = (short)(this.clipnum + 1);
        }
    }

    public int clipmove(int x, int y, int z, int sectnum, long xvect, long yvect, int walldist, int ceildist, int flordist, int cliptype) {
        int templong1;
        int templong2;
        short hitwall;
        int i;
        Object out;
        short j;
        clipmove_x = x;
        clipmove_y = y;
        clipmove_z = z;
        clipmove_sectnum = (short)sectnum;
        if ((xvect | yvect) == 0L || clipmove_sectnum < 0 || clipmove_sectnum >= MAXSECTORS) {
            return 0;
        }
        int retval = 0;
        long oxvect = xvect;
        long oyvect = yvect;
        int goalx = clipmove_x + (int)(xvect >> 14);
        int goaly = clipmove_y + (int)(yvect >> 14);
        this.clipnum = 0;
        int cx = clipmove_x + goalx >> 1;
        int cy = clipmove_y + goaly >> 1;
        int gx = goalx - clipmove_x;
        int gy = goaly - clipmove_y;
        int rad = this.ksqrt(gx * gx + gy * gy) + 1024 + walldist + 8;
        int xmin = cx - rad;
        int ymin = cy - rad;
        int xmax = cx + rad;
        int ymax = cy + rad;
        int dawalclipmask = cliptype & 0xFFFF;
        int dasprclipmask = cliptype >> 16;
        this.clipsectorlist[0] = clipmove_sectnum;
        short clipsectcnt = 0;
        this.clipsectnum = 1;
        do {
            int bsz;
            int daz2;
            int daz;
            int day;
            int dax;
            int y2;
            int y1;
            int x1;
            int x2;
            short dasect;
            if (!Gameutils.isValidSector(dasect = this.clipsectorlist[clipsectcnt++])) continue;
            SECTOR sec = sector[dasect];
            short startwall = sec.wallptr;
            int endwall = startwall + sec.wallnum;
            if (startwall < 0 || endwall < 0) continue;
            for (j = startwall; j < endwall; j = (short)(j + 1)) {
                int dy;
                int dx;
                if (Gameutils.isCorruptWall(j)) continue;
                WALL wal = wall[j];
                WALL wal2 = wall[wal.point2];
                if (wal.x < xmin && wal2.x < xmin || wal.x > xmax && wal2.x > xmax || wal.y < ymin && wal2.y < ymin || wal.y > ymax && wal2.y > ymax || (dx = (x2 = wal2.x) - (x1 = wal.x)) * (clipmove_y - (y1 = wal.y)) < (clipmove_x - x1) * (dy = (y2 = wal2.y) - y1) || (dax = dx > 0 ? dx * (ymin - y1) : dx * (ymax - y1)) >= (day = dy > 0 ? dy * (xmax - x1) : dy * (xmin - x1))) continue;
                boolean clipyou = false;
                if (wal.nextsector < 0 || (wal.cstat & dawalclipmask) != 0) {
                    clipyou = true;
                } else {
                    out = this.rintersect(clipmove_x, clipmove_y, 0, gx, gy, 0, x1, y1, x2, y2);
                    if (out == null) {
                        dax = clipmove_x;
                        day = clipmove_y;
                    } else {
                        dax = ((Point)out).getX();
                        day = ((Point)out).getY();
                    }
                    daz = this.getflorzofslope(dasect, dax, day);
                    daz2 = this.getflorzofslope(wal.nextsector, dax, day);
                    SECTOR sec2 = sector[wal.nextsector];
                    if (sec2 == null) continue;
                    if (daz2 < daz - 256 && (sec2.floorstat & 1) == 0 && clipmove_z >= daz2 - (flordist - 1)) {
                        clipyou = true;
                    }
                    if (!clipyou) {
                        daz = this.getceilzofslope(dasect, dax, day);
                        daz2 = this.getceilzofslope(wal.nextsector, dax, day);
                        if (daz2 > daz + 256 && (sec2.ceilingstat & 1) == 0 && clipmove_z <= daz2 + (ceildist - 1)) {
                            clipyou = true;
                        }
                    }
                }
                if (clipyou) {
                    bsz = walldist;
                    if (gx < 0) {
                        bsz = -bsz;
                    }
                    this.addclipline(x1 - bsz, y1 - bsz, x1 - bsz, y1 + bsz, j + 32768);
                    this.addclipline(x2 - bsz, y2 - bsz, x2 - bsz, y2 + bsz, j + 32768);
                    bsz = walldist;
                    if (gy < 0) {
                        bsz = -bsz;
                    }
                    this.addclipline(x1 + bsz, y1 - bsz, x1 - bsz, y1 - bsz, j + 32768);
                    this.addclipline(x2 + bsz, y2 - bsz, x2 - bsz, y2 - bsz, j + 32768);
                    dax = walldist;
                    if (dy > 0) {
                        dax = -dax;
                    }
                    day = walldist;
                    if (dx < 0) {
                        day = -day;
                    }
                    this.addclipline(x1 + dax, y1 + day, x2 + dax, y2 + day, j + 32768);
                    continue;
                }
                for (i = this.clipsectnum - 1; i >= 0 && wal.nextsector != this.clipsectorlist[i]; --i) {
                }
                if (i >= 0) continue;
                short s = this.clipsectnum;
                this.clipsectnum = (short)(s + 1);
                this.clipsectorlist[s] = wal.nextsector;
            }
            j = headspritesect[dasect];
            while (j >= 0) {
                SPRITE spr = sprite[j];
                short cstat = spr.cstat;
                if ((cstat & dasprclipmask) != 0) {
                    Tile pic = this.getTile(spr.picnum);
                    x1 = spr.x;
                    y1 = spr.y;
                    switch (cstat & 0x30) {
                        case 0: {
                            if (x1 < xmin || x1 > xmax || y1 < ymin || y1 > ymax) break;
                            int k = pic.getHeight() * spr.yrepeat << 2;
                            daz = (cstat & 0x80) != 0 ? spr.z + (k >> 1) : spr.z;
                            if ((pic.anm & 0xFF0000) != 0) {
                                daz -= pic.getOffsetY() * spr.yrepeat << 2;
                            }
                            if (clipmove_z >= daz + ceildist || clipmove_z <= daz - k - flordist) break;
                            bsz = (spr.clipdist << 2) + walldist;
                            if (gx < 0) {
                                bsz = -bsz;
                            }
                            this.addclipline(x1 - bsz, y1 - bsz, x1 - bsz, y1 + bsz, j + 49152);
                            bsz = (spr.clipdist << 2) + walldist;
                            if (gy < 0) {
                                bsz = -bsz;
                            }
                            this.addclipline(x1 + bsz, y1 - bsz, x1 - bsz, y1 - bsz, j + 49152);
                            break;
                        }
                        case 16: {
                            int k = pic.getHeight() * spr.yrepeat << 2;
                            daz = (cstat & 0x80) != 0 ? spr.z + (k >> 1) : spr.z;
                            if ((pic.anm & 0xFF0000) != 0) {
                                daz -= pic.getOffsetY() * spr.yrepeat << 2;
                            }
                            daz2 = daz - k;
                            if (clipmove_z >= (daz += ceildist) || clipmove_z <= (daz2 -= flordist)) break;
                            byte xoff = (byte)(pic.getOffsetX() + spr.xoffset);
                            if ((cstat & 4) > 0) {
                                xoff = -xoff;
                            }
                            k = spr.ang;
                            int l = spr.xrepeat;
                            dax = sintable[k & 0x7FF] * l;
                            day = sintable[k + 1536 & 0x7FF] * l;
                            l = pic.getWidth();
                            k = (l >> 1) + xoff;
                            x2 = (x1 -= Pragmas.mulscale(dax, k, 16)) + Pragmas.mulscale(dax, l, 16);
                            if (this.clipinsideboxline(cx, cy, x1, y1 -= Pragmas.mulscale(day, k, 16), x2, y2 = y1 + Pragmas.mulscale(day, l, 16), rad) == 0) break;
                            dax = Pragmas.mulscale(sintable[spr.ang + 256 + 512 & 0x7FF], walldist, 14);
                            day = Pragmas.mulscale(sintable[spr.ang + 256 & 0x7FF], walldist, 14);
                            if ((x1 - clipmove_x) * (y2 - clipmove_y) >= (x2 - clipmove_x) * (y1 - clipmove_y)) {
                                this.addclipline(x1 + dax, y1 + day, x2 + day, y2 - dax, j + 49152);
                            } else {
                                if ((cstat & 0x40) != 0) break;
                                this.addclipline(x2 - dax, y2 - day, x1 - day, y1 + dax, j + 49152);
                            }
                            if ((x2 - x1) * (clipmove_x - x1) + (y2 - y1) * (clipmove_y - y1) < 0) {
                                this.addclipline(x1 - day, y1 + dax, x1 + dax, y1 + day, j + 49152);
                                break;
                            }
                            if ((x1 - x2) * (clipmove_x - x2) + (y1 - y2) * (clipmove_y - y2) >= 0) break;
                            this.addclipline(x2 + day, y2 - dax, x2 - dax, y2 - day, j + 49152);
                            break;
                        }
                        case 32: {
                            daz = spr.z + ceildist;
                            daz2 = spr.z - flordist;
                            if (clipmove_z >= daz || clipmove_z <= daz2 || (cstat & 0x40) != 0 && clipmove_z > spr.z == ((cstat & 8) == 0)) break;
                            byte xoff = (byte)(pic.getOffsetX() + spr.xoffset);
                            byte yoff = (byte)(pic.getOffsetY() + spr.yoffset);
                            if ((cstat & 4) > 0) {
                                xoff = -xoff;
                            }
                            if ((cstat & 8) > 0) {
                                yoff = -yoff;
                            }
                            int k = spr.ang;
                            short cosang = sintable[k + 512 & 0x7FF];
                            short sinang = sintable[k & 0x7FF];
                            int xspan = pic.getWidth();
                            short xrepeat = spr.xrepeat;
                            int yspan = pic.getHeight();
                            short yrepeat = spr.yrepeat;
                            dax = ((xspan >> 1) + xoff) * xrepeat;
                            day = ((yspan >> 1) + yoff) * yrepeat;
                            this.rxi[0] = x1 + Pragmas.dmulscale(sinang, dax, cosang, day, 16);
                            this.ryi[0] = y1 + Pragmas.dmulscale(sinang, day, -cosang, dax, 16);
                            int l = xspan * xrepeat;
                            this.rxi[1] = this.rxi[0] - Pragmas.mulscale(sinang, l, 16);
                            this.ryi[1] = this.ryi[0] + Pragmas.mulscale(cosang, l, 16);
                            l = yspan * yrepeat;
                            k = -Pragmas.mulscale(cosang, l, 16);
                            this.rxi[2] = this.rxi[1] + k;
                            this.rxi[3] = this.rxi[0] + k;
                            k = -Pragmas.mulscale(sinang, l, 16);
                            this.ryi[2] = this.ryi[1] + k;
                            this.ryi[3] = this.ryi[0] + k;
                            dax = Pragmas.mulscale(sintable[spr.ang - 256 + 512 & 0x7FF], walldist, 14);
                            day = Pragmas.mulscale(sintable[spr.ang - 256 & 0x7FF], walldist, 14);
                            if ((this.rxi[0] - clipmove_x) * (this.ryi[1] - clipmove_y) < (this.rxi[1] - clipmove_x) * (this.ryi[0] - clipmove_y)) {
                                if (this.clipinsideboxline(cx, cy, this.rxi[1], this.ryi[1], this.rxi[0], this.ryi[0], rad) != 0) {
                                    this.addclipline(this.rxi[1] - day, this.ryi[1] + dax, this.rxi[0] + dax, this.ryi[0] + day, j + 49152);
                                }
                            } else if ((this.rxi[2] - clipmove_x) * (this.ryi[3] - clipmove_y) < (this.rxi[3] - clipmove_x) * (this.ryi[2] - clipmove_y) && this.clipinsideboxline(cx, cy, this.rxi[3], this.ryi[3], this.rxi[2], this.ryi[2], rad) != 0) {
                                this.addclipline(this.rxi[3] + day, this.ryi[3] - dax, this.rxi[2] - dax, this.ryi[2] - day, j + 49152);
                            }
                            if ((this.rxi[1] - clipmove_x) * (this.ryi[2] - clipmove_y) < (this.rxi[2] - clipmove_x) * (this.ryi[1] - clipmove_y)) {
                                if (this.clipinsideboxline(cx, cy, this.rxi[2], this.ryi[2], this.rxi[1], this.ryi[1], rad) == 0) break;
                                this.addclipline(this.rxi[2] - dax, this.ryi[2] - day, this.rxi[1] - day, this.ryi[1] + dax, j + 49152);
                                break;
                            }
                            if ((this.rxi[3] - clipmove_x) * (this.ryi[0] - clipmove_y) >= (this.rxi[0] - clipmove_x) * (this.ryi[3] - clipmove_y) || this.clipinsideboxline(cx, cy, this.rxi[0], this.ryi[0], this.rxi[3], this.ryi[3], rad) == 0) break;
                            this.addclipline(this.rxi[0] + dax, this.ryi[0] + day, this.rxi[3] + day, this.ryi[3] - dax, j + 49152);
                        }
                    }
                }
                j = nextspritesect[j];
            }
        } while (clipsectcnt < this.clipsectnum);
        int cnt = clipmoveboxtracenum;
        do {
            out = this.raytrace(clipmove_x, clipmove_y, goalx, goaly);
            int intx = ((Clip)out).getX();
            int inty = ((Clip)out).getY();
            hitwall = ((Clip)out).getNum();
            if (hitwall >= 0) {
                int lx = this.clipit[hitwall].x2 - this.clipit[hitwall].x1;
                int ly = this.clipit[hitwall].y2 - this.clipit[hitwall].y1;
                templong2 = lx * lx + ly * ly;
                if (templong2 > 0) {
                    templong1 = (goalx - intx) * lx + (goaly - inty) * ly;
                    i = Pragmas.klabs(templong1) >> 11 < templong2 ? Pragmas.divscale(templong1, templong2, 20) : 0;
                    goalx = Pragmas.mulscale(lx, i, 20) + intx;
                    goaly = Pragmas.mulscale(ly, i, 20) + inty;
                }
                templong1 = Pragmas.dmulscale(lx, oxvect, ly, oyvect, 6);
                for (i = cnt + 1; i <= clipmoveboxtracenum; ++i) {
                    j = this.hitwalls[i];
                    templong2 = Pragmas.dmulscale(this.clipit[j].x2 - this.clipit[j].x1, oxvect, this.clipit[j].y2 - this.clipit[j].y1, oyvect, 6);
                    if ((templong1 ^ templong2) >= 0) continue;
                    clipmove_sectnum = this.updatesector(clipmove_x, clipmove_y, clipmove_sectnum);
                    return retval;
                }
                Point goal = this.keepaway(goalx, goaly, hitwall);
                goalx = goal.getX();
                goaly = goal.getY();
                xvect = goalx - intx << 14;
                yvect = goaly - inty << 14;
                if (cnt == clipmoveboxtracenum) {
                    retval = this.clipobjectval[hitwall];
                }
                this.hitwalls[cnt] = hitwall;
            }
            clipmove_x = intx;
            clipmove_y = inty;
        } while ((xvect | yvect) != 0L && hitwall >= 0 && --cnt > 0);
        for (j = 0; j < this.clipsectnum; j = (short)(j + 1)) {
            if (this.inside(clipmove_x, clipmove_y, this.clipsectorlist[j]) != 1) continue;
            clipmove_sectnum = this.clipsectorlist[j];
            return retval;
        }
        clipmove_sectnum = (short)-1;
        templong1 = Integer.MAX_VALUE;
        for (j = (short)(numsectors - 1); j >= 0; j = (short)(j - 1)) {
            if (this.inside(clipmove_x, clipmove_y, j) != 1) continue;
            templong2 = (Engine.sector[j].ceilingstat & 2) != 0 ? this.getceilzofslope(j, clipmove_x, clipmove_y) - clipmove_z : Engine.sector[j].ceilingz - clipmove_z;
            if (templong2 <= 0 && (templong2 = (Engine.sector[j].floorstat & 2) != 0 ? clipmove_z - this.getflorzofslope(j, clipmove_x, clipmove_y) : clipmove_z - Engine.sector[j].floorz) <= 0) {
                clipmove_sectnum = j;
                return retval;
            }
            if (templong2 >= templong1) continue;
            clipmove_sectnum = j;
            templong1 = templong2;
        }
        return retval;
    }

    public int pushmove(int x, int y, int z, int sectnum, int walldist, int ceildist, int flordist, int cliptype) {
        int bad;
        pushmove_x = x;
        pushmove_y = y;
        pushmove_z = z;
        pushmove_sectnum = (short)sectnum;
        if (pushmove_sectnum < 0 || pushmove_sectnum >= MAXSECTORS) {
            return -1;
        }
        int dawalclipmask = cliptype & 0xFFFF;
        int k = 32;
        int dir = 1;
        do {
            bad = 0;
            this.clipsectorlist[0] = pushmove_sectnum;
            short clipsectcnt = 0;
            this.clipsectnum = 1;
            do {
                short endwall;
                int startwall;
                if (this.clipsectorlist[clipsectcnt] == -1) {
                    clipsectcnt = (short)(clipsectcnt + 1);
                    continue;
                }
                SECTOR sec = sector[this.clipsectorlist[clipsectcnt]];
                if (dir > 0) {
                    startwall = sec.wallptr;
                    endwall = (short)(startwall + sec.wallnum);
                } else {
                    endwall = sec.wallptr;
                    startwall = (short)(endwall + sec.wallnum);
                }
                if (startwall < 0 || endwall < 0) {
                    clipsectcnt = (short)(clipsectcnt + 1);
                    continue;
                }
                for (int i = startwall; i != endwall && i < MAXWALLS; i += dir) {
                    WALL wal = wall[i];
                    if (this.clipinsidebox(pushmove_x, pushmove_y, (short)i, walldist - 4) != 1) continue;
                    int j = 0;
                    if (wal.nextsector < 0) {
                        j = 1;
                    }
                    if ((wal.cstat & dawalclipmask) != 0) {
                        j = 1;
                    }
                    if (j == 0) {
                        int daz2;
                        SECTOR sec2 = sector[wal.nextsector];
                        int dax = Engine.wall[wal.point2].x - wal.x;
                        int day = Engine.wall[wal.point2].y - wal.y;
                        int daz = dax * (pushmove_x - wal.x) + day * (pushmove_y - wal.y);
                        int t = daz <= 0 ? 0 : (daz >= (daz2 = dax * dax + day * day) ? 0x40000000 : Pragmas.divscale(daz, daz2, 30));
                        dax = wal.x + Pragmas.mulscale(dax, t, 30);
                        day = wal.y + Pragmas.mulscale(day, t, 30);
                        daz = this.getflorzofslope(this.clipsectorlist[clipsectcnt], dax, day);
                        daz2 = this.getflorzofslope(wal.nextsector, dax, day);
                        if (sec2 == null) continue;
                        if (daz2 < daz - 256 && (sec2.floorstat & 1) == 0 && pushmove_z >= daz2 - (flordist - 1)) {
                            j = 1;
                        }
                        daz = this.getceilzofslope(this.clipsectorlist[clipsectcnt], dax, day);
                        daz2 = this.getceilzofslope(wal.nextsector, dax, day);
                        if (daz2 > daz + 256 && (sec2.ceilingstat & 1) == 0 && pushmove_z <= daz2 + (ceildist - 1)) {
                            j = 1;
                        }
                    }
                    if (j != 0) {
                        j = this.getangle(Engine.wall[wal.point2].x - wal.x, Engine.wall[wal.point2].y - wal.y);
                        int dx = sintable[j + 1024 & 0x7FF] >> 11;
                        int dy = sintable[j + 512 & 0x7FF] >> 11;
                        int bad2 = 16;
                        while (--bad2 != 0 && this.clipinsidebox(pushmove_x += dx, pushmove_y += dy, (short)i, walldist - 4) != 0) {
                        }
                        bad = -1;
                        if (--k <= 0) {
                            return bad;
                        }
                        if ((pushmove_sectnum = this.updatesector(pushmove_x, pushmove_y, pushmove_sectnum)) >= 0) continue;
                        return -1;
                    }
                    for (j = this.clipsectnum - 1; j >= 0 && wal.nextsector != this.clipsectorlist[j]; --j) {
                    }
                    if (j >= 0) continue;
                    short s = this.clipsectnum;
                    this.clipsectnum = (short)(s + 1);
                    this.clipsectorlist[s] = wal.nextsector;
                }
                clipsectcnt = (short)(clipsectcnt + 1);
            } while (clipsectcnt < this.clipsectnum);
            dir = -dir;
        } while (bad != 0);
        return bad;
    }

    public short updatesector(int x, int y, int sectnum) {
        short i;
        if (this.inside(x, y, sectnum) == 1) {
            return (short)sectnum;
        }
        if (Gameutils.isValidSector(sectnum)) {
            short wallid = Engine.sector[sectnum].wallptr;
            int j = Engine.sector[sectnum].wallnum;
            while (Gameutils.isValidWall(wallid)) {
                WALL wal = wall[wallid];
                i = wal.nextsector;
                if (i >= 0 && this.inside(x, y, i) == 1) {
                    return i;
                }
                wallid = (short)(wallid + 1);
                if (--j != 0) continue;
            }
        }
        for (i = (short)(numsectors - 1); i >= 0; i = (short)(i - 1)) {
            if (this.inside(x, y, i) != 1) continue;
            return i;
        }
        return -1;
    }

    public short updatesectorz(int x, int y, int z, int sectnum) {
        short i;
        this.getzsofslope(sectnum, x, y, zofslope);
        if (z >= zofslope[0] && z <= zofslope[1] && this.inside(x, y, sectnum) != 0) {
            return (short)sectnum;
        }
        if (Gameutils.isValidSector(sectnum)) {
            short wallid = Engine.sector[sectnum].wallptr;
            int j = Engine.sector[sectnum].wallnum;
            while (Gameutils.isValidWall(wallid)) {
                WALL wal = wall[wallid];
                i = wal.nextsector;
                if (i >= 0) {
                    this.getzsofslope(i, x, y, zofslope);
                    if (z >= zofslope[0] && z <= zofslope[1] && this.inside(x, y, i) == 1) {
                        return i;
                    }
                }
                wallid = (short)(wallid + 1);
                if (--j != 0) continue;
            }
        }
        for (i = (short)(numsectors - 1); i >= 0; i = (short)(i - 1)) {
            this.getzsofslope(i, x, y, zofslope);
            if (z < zofslope[0] || z > zofslope[1] || this.inside(x, y, i) != 1) continue;
            return i;
        }
        return -1;
    }

    public Point rotatepoint(int xpivot, int ypivot, int x, int y, int daang) {
        short dacos = sintable[daang + 2560 & 0x7FF];
        short dasin = sintable[daang + 2048 & 0x7FF];
        this.rotatepoint.x = Pragmas.dmulscale(x -= xpivot, dacos, -(y -= ypivot), dasin, 14) + xpivot;
        this.rotatepoint.y = Pragmas.dmulscale(y, dacos, x, dasin, 14) + ypivot;
        return this.rotatepoint;
    }

    public void srand(int seed) {
        this.randomseed = seed;
    }

    public int getrand() {
        return this.randomseed;
    }

    public int krand() {
        this.randomseed = this.randomseed * 27584621 + 1;
        return (int)(((long)this.randomseed & 0xFFFFFFFFL) >> 16);
    }

    public int rand() {
        return (int)(Math.random() * 32767.0);
    }

    /*
     * Unable to fully structure code
     */
    public void getzrange(int x, int y, int z, int sectnum, int walldist, int cliptype) {
        if (!Gameutils.isValidSector(sectnum)) {
            Engine.zr_ceilz = -2147483648;
            Engine.zr_ceilhit = -1;
            Engine.zr_florz = 0x7FFFFFFF;
            Engine.zr_florhit = -1;
            return;
        }
        i = walldist + 1024 + 1;
        xmin = x - i;
        ymin = y - i;
        xmax = x + i;
        ymax = y + i;
        this.getzsofslope(sectnum, x, y, Engine.zofslope);
        Engine.zr_ceilz = Engine.zofslope[0];
        Engine.zr_florz = Engine.zofslope[1];
        Engine.zr_ceilhit = sectnum + 16384;
        Engine.zr_florhit = sectnum + 16384;
        dawalclipmask = cliptype & 65535;
        dasprclipmask = cliptype >> 16;
        this.clipsectorlist[0] = (short)sectnum;
        clipsectcnt = 0;
        this.clipsectnum = 1;
        do {
            if (this.clipsectorlist[clipsectcnt] < 0) {
                ++clipsectcnt;
                continue;
            }
            sec = Engine.sector[this.clipsectorlist[clipsectcnt]];
            startwall = sec.wallptr;
            endwall = startwall + sec.wallnum;
            if (startwall < 0 || endwall < 0) {
                ++clipsectcnt;
                continue;
            }
            for (j = startwall; j < endwall; ++j) {
                if (Gameutils.isCorruptWall(j)) continue;
                wal = Engine.wall[j];
                k = wal.nextsector;
                if (k < 0) continue;
                wal2 = Engine.wall[wal.point2];
                x1 = wal.x;
                x2 = wal2.x;
                if (x1 < xmin && x2 < xmin || x1 > xmax && x2 > xmax) continue;
                y1 = wal.y;
                y2 = wal2.y;
                if (y1 < ymin && y2 < ymin || y1 > ymax && y2 > ymax || (dx = x2 - x1) * (y - y1) < (x - x1) * (dy = y2 - y1) || (dax = dx > 0 ? dx * (ymin - y1) : dx * (ymax - y1)) >= (day = dy > 0 ? dy * (xmax - x1) : dy * (xmin - x1)) || (wal.cstat & dawalclipmask) != 0 || (sec = Engine.sector[k]) == null || (sec.ceilingstat & 1) == 0 && z <= sec.ceilingz + 768 || (sec.floorstat & 1) == 0 && z >= sec.floorz - 768) continue;
                for (i = this.clipsectnum - 1; i >= 0 && this.clipsectorlist[i] != k; --i) {
                }
                if (i < 0) {
                    v0 = this.clipsectnum;
                    this.clipsectnum = (short)(v0 + 1);
                    this.clipsectorlist[v0] = (short)k;
                }
                if (x1 < xmin + 1024 && x2 < xmin + 1024 || x1 > xmax - 1024 && x2 > xmax - 1024 || y1 < ymin + 1024 && y2 < ymin + 1024 || y1 > ymax - 1024 && y2 > ymax - 1024) continue;
                dax = dx > 0 ? (dax += dx * 1024) : (dax -= dx * 1024);
                day = dy > 0 ? (day -= dy * 1024) : (day += dy * 1024);
                if (dax >= day) continue;
                this.getzsofslope((short)k, x, y, Engine.zofslope);
                if (Engine.zofslope[0] > Engine.zr_ceilz) {
                    Engine.zr_ceilz = Engine.zofslope[0];
                    Engine.zr_ceilhit = k + 16384;
                }
                if (Engine.zofslope[1] >= Engine.zr_florz) continue;
                Engine.zr_florz = Engine.zofslope[1];
                Engine.zr_florhit = k + 16384;
            }
            ++clipsectcnt;
        } while (clipsectcnt < this.clipsectnum);
        for (i = 0; i < this.clipsectnum; ++i) {
            j = Engine.headspritesect[this.clipsectorlist[i]];
            while (j >= 0) {
                block38: {
                    spr = Engine.sprite[j];
                    cstat = spr.cstat;
                    if ((cstat & dasprclipmask) == 0) break block38;
                    pic = this.getTile(spr.picnum);
                    x1 = spr.x;
                    y1 = spr.y;
                    clipyou = false;
                    switch (cstat & 48) {
                        case 0: {
                            k = walldist + (spr.clipdist << 2) + 1;
                            if (Pragmas.klabs(x1 - x) <= k && Pragmas.klabs(y1 - y) <= k) {
                                Engine.zofslope[0] = spr.z;
                                k = pic.getHeight() * spr.yrepeat << 1;
                                if ((cstat & 128) != 0) {
                                    Engine.zofslope[0] = Engine.zofslope[0] + k;
                                }
                                if ((pic.anm & 0xFF0000) != 0) {
                                    Engine.zofslope[0] = Engine.zofslope[0] - (pic.getOffsetY() * spr.yrepeat << 2);
                                }
                                Engine.zofslope[1] = Engine.zofslope[0] - (k << 1);
                                clipyou = true;
                            }
                            ** GOTO lbl169
                        }
                        case 16: {
                            xoff = (byte)(pic.getOffsetX() + spr.xoffset);
                            if ((cstat & 4) > 0) {
                                xoff = -xoff;
                            }
                            k = spr.ang;
                            l = spr.xrepeat;
                            dax = Engine.sintable[k & 2047] * l;
                            day = Engine.sintable[k + 1536 & 2047] * l;
                            l = pic.getWidth();
                            k = (l >> 1) + xoff;
                            x2 = (x1 -= Pragmas.mulscale(dax, k, 16)) + Pragmas.mulscale(dax, l, 16);
                            if (this.clipinsideboxline(x, y, x1, y1 -= Pragmas.mulscale(day, k, 16), x2, y2 = y1 + Pragmas.mulscale(day, l, 16), walldist + 1) != 0) {
                                Engine.zofslope[0] = spr.z;
                                k = pic.getHeight() * spr.yrepeat << 1;
                                if ((cstat & 128) != 0) {
                                    Engine.zofslope[0] = Engine.zofslope[0] + k;
                                }
                                if ((pic.anm & 0xFF0000) != 0) {
                                    Engine.zofslope[0] = Engine.zofslope[0] - (pic.getOffsetY() * spr.yrepeat << 2);
                                }
                                Engine.zofslope[1] = Engine.zofslope[0] - (k << 1);
                                clipyou = true;
                            }
                            ** GOTO lbl169
                        }
                        case 32: {
                            Engine.zofslope[0] = spr.z;
                            Engine.zofslope[1] = Engine.zofslope[0];
                            if ((cstat & 64) != 0 && z > Engine.zofslope[0] == ((cstat & 8) == 0)) break;
                            xoff = (byte)(pic.getOffsetX() + spr.xoffset);
                            yoff = (byte)(pic.getOffsetY() + spr.yoffset);
                            if ((cstat & 4) > 0) {
                                xoff = -xoff;
                            }
                            if ((cstat & 8) > 0) {
                                yoff = -yoff;
                            }
                            ang = spr.ang;
                            cosang = Engine.sintable[ang + 512 & 2047];
                            sinang = Engine.sintable[ang & 2047];
                            xspan = pic.getWidth();
                            xrepeat = spr.xrepeat;
                            yspan = pic.getHeight();
                            yrepeat = spr.yrepeat;
                            dax = ((xspan >> 1) + xoff) * xrepeat;
                            day = ((yspan >> 1) + yoff) * yrepeat;
                            l = xspan * xrepeat;
                            x2 = (x1 += Pragmas.dmulscale(sinang, dax, cosang, day, 16) - x) - Pragmas.mulscale(sinang, l, 16);
                            y2 = (y1 += Pragmas.dmulscale(sinang, day, -cosang, dax, 16) - y) + Pragmas.mulscale(cosang, l, 16);
                            l = yspan * yrepeat;
                            k = -Pragmas.mulscale(cosang, l, 16);
                            x3 = x2 + k;
                            x4 = x1 + k;
                            k = -Pragmas.mulscale(sinang, l, 16);
                            y3 = y2 + k;
                            y4 = y1 + k;
                            dax = Pragmas.mulscale(Engine.sintable[spr.ang - 256 + 512 & 2047], walldist + 4, 14);
                            day = Pragmas.mulscale(Engine.sintable[spr.ang - 256 & 2047], walldist + 4, 14);
                            x1 += dax;
                            x2 -= day;
                            x3 -= dax;
                            x4 += day;
                            y3 -= day;
                            y4 -= dax;
                            if (((y1 += day) ^ (y2 += dax)) < 0) {
                                if ((x1 ^ x2) < 0) {
                                    clipyou ^= x1 * y2 < x2 * y1 ^ y1 < y2;
                                } else if (x1 >= 0) {
                                    clipyou ^= true;
                                }
                            }
                            if ((y2 ^ y3) < 0) {
                                if ((x2 ^ x3) < 0) {
                                    clipyou ^= x2 * y3 < x3 * y2 ^ y2 < y3;
                                } else if (x2 >= 0) {
                                    clipyou ^= true;
                                }
                            }
                            if ((y3 ^ y4) < 0) {
                                if ((x3 ^ x4) < 0) {
                                    clipyou ^= x3 * y4 < x4 * y3 ^ y3 < y4;
                                } else if (x3 >= 0) {
                                    clipyou ^= true;
                                }
                            }
                            if ((y4 ^ y1) >= 0) ** GOTO lbl169
                            if ((x4 ^ x1) >= 0) ** GOTO lbl167
                            clipyou ^= x4 * y1 < x1 * y4 ^ y4 < y1;
                            ** GOTO lbl169
lbl167:
                            // 1 sources

                            if (x4 >= 0) {
                                clipyou ^= true;
                            }
                        }
lbl169:
                        // 8 sources

                        default: {
                            if (!clipyou) break;
                            if (z > Engine.zofslope[0] && Engine.zofslope[0] > Engine.zr_ceilz) {
                                Engine.zr_ceilz = Engine.zofslope[0];
                                Engine.zr_ceilhit = j + 49152;
                            }
                            if (z >= Engine.zofslope[1] || Engine.zofslope[1] >= Engine.zr_florz) break;
                            Engine.zr_florz = Engine.zofslope[1];
                            Engine.zr_florhit = j + 49152;
                        }
                    }
                }
                j = Engine.nextspritesect[j];
            }
        }
    }

    public void setaspect_new() {
        if (BuildSettings.usenewaspect.get().booleanValue() && 4 * xdim / 5 != ydim) {
            int yx = 81664;
            int xd = this.setaspect_new_use_dimen != 0 ? xdimen : xdim;
            int yd = this.setaspect_new_use_dimen != 0 ? ydimen : ydim;
            int vr = Pragmas.divscale(xd * 3, yd * 4, 16);
            this.setaspect(vr, yx);
        } else {
            this.setaspect(65536, Pragmas.divscale(ydim * 320, xdim * 200, 16));
        }
    }

    public void setview(int x1, int y1, int x2, int y2) {
        windowx1 = x1;
        wx1 = x1 << 12;
        windowy1 = y1;
        wy1 = y1 << 12;
        windowx2 = x2;
        wx2 = x2 + 1 << 12;
        windowy2 = y2;
        wy2 = y2 + 1 << 12;
        xdimen = x2 - x1 + 1;
        halfxdimen = xdimen >> 1;
        ydimen = y2 - y1 + 1;
        this.setaspect_new();
        this.render.setview(x1, y1, x2, y2);
    }

    public void setaspect(int daxrange, int daaspect) {
        viewingrange = offscreenrendering ? daxrange : (int)((float)daxrange * this.fovFactor);
        viewingrangerecip = Pragmas.divscale(1L, viewingrange, 32);
        yxaspect = daaspect;
        xyaspect = Pragmas.divscale(1L, yxaspect, 32);
        xdimenscale = Pragmas.scale(xdimen, yxaspect, 320L);
        xdimscale = Pragmas.scale(320L, xyaspect, xdimen);
        if (this.render.getType() == Renderer.RenderType.PolyGDX) {
            int w = 320;
            if (4 * xdim / 5 == ydim) {
                w = 300;
            }
            float k = (float)daxrange / (float)Pragmas.divscale(xdim * 240, ydim * w, 16);
            ((GDXRenderer)this.render).setFieldOfView(offscreenrendering ? 110.0f : (float)Math.toDegrees(2.0 * Math.atan(k * this.fovFactor)));
        }
    }

    public void setFov(int fov) {
        this.fovFactor = (float)Math.tan((double)fov * Math.PI / 360.0);
        this.setaspect_new();
    }

    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        this.render.rotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2);
    }

    public void makepalookup(final int palnum, byte[] remapbuf, int r, int g, int b, int dastat) {
        if (paletteloaded == 0) {
            return;
        }
        if (palookup[palnum] == null) {
            Engine.palookup[palnum] = new byte[numshades << 8];
        }
        if (dastat == 0) {
            return;
        }
        if ((r | g | b | 0x3F) != 63) {
            return;
        }
        if ((r | g | b) == 0) {
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < numshades; ++j) {
                    Engine.palookup[palnum][i + j * 256] = palookup[0][(remapbuf[i] & 0xFF) + j * 256];
                }
            }
            Engine.palookupfog[palnum][0] = 0;
            Engine.palookupfog[palnum][1] = 0;
            Engine.palookupfog[palnum][2] = 0;
        } else {
            byte[] pal = new byte[768];
            System.arraycopy(curpalette.getBytes(), 0, pal, 0, 768);
            for (int j = 0; j < 768; ++j) {
                pal[j] = (byte)((pal[j] & 0xFF) >> 2);
            }
            for (int i = 0; i < numshades; ++i) {
                long palscale = Pragmas.divscale(i, numshades, 16);
                for (int j = 0; j < 256; ++j) {
                    int rptr = pal[3 * (remapbuf[j] & 0xFF)] & 0xFF;
                    int gptr = pal[3 * (remapbuf[j] & 0xFF) + 1] & 0xFF;
                    int bptr = pal[3 * (remapbuf[j] & 0xFF) + 2] & 0xFF;
                    Engine.palookup[palnum][j + i * 256] = this.getclosestcol(pal, rptr + Pragmas.mulscale(r - rptr, palscale, 16), gptr + Pragmas.mulscale(g - gptr, palscale, 16), bptr + Pragmas.mulscale(b - bptr, palscale, 16));
                }
            }
            Engine.palookupfog[palnum][0] = (byte)r;
            Engine.palookupfog[palnum][1] = (byte)g;
            Engine.palookupfog[palnum][2] = (byte)b;
        }
        BuildGdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                GLRenderer gl = Engine.this.glrender();
                if (gl != null) {
                    gl.getTextureManager().invalidatepalookup(palnum);
                }
            }
        });
    }

    public void setbrightness(int dabrightness, byte[] dapal, GLRenderer.GLInvalidateFlag flags) {
        GLRenderer gl = this.glrender();
        curbrightness = Gameutils.BClipRange(dabrightness, 0, 15);
        if ((gl == null || gl.getType().getFrameType() != BuildFrame.FrameType.GL) && curbrightness != 0) {
            for (int i = 0; i < dapal.length; ++i) {
                this.temppal[i] = britable[curbrightness][(dapal[i] & 0xFF) << 2];
            }
        } else {
            System.arraycopy(dapal, 0, this.temppal, 0, dapal.length);
            int i = 0;
            while (i < dapal.length) {
                int n = i++;
                this.temppal[n] = (byte)(this.temppal[n] << 2);
            }
        }
        if (this.changepalette(this.temppal)) {
            if (gl != null) {
                gl.gltexinvalidateall(flags);
            }
            Engine.palfadergb.b = 0;
            Engine.palfadergb.g = 0;
            Engine.palfadergb.r = 0;
            Engine.palfadergb.a = 0;
        }
    }

    public boolean changepalette(final byte[] palette) {
        if (this.render.getType() != Renderer.RenderType.Software && CRC32.getChecksum(palette) == curpalette.getCrc32()) {
            return false;
        }
        curpalette.update(palette);
        Arrays.fill((Object[])this.palcache, null);
        BuildGdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                Engine.this.render.changepalette(palette);
            }
        });
        return true;
    }

    public void setpalettefade(int r, int g, int b, int offset) {
        Engine.palfadergb.r = Math.min(63, r) << 2;
        Engine.palfadergb.g = Math.min(63, g) << 2;
        Engine.palfadergb.b = Math.min(63, b) << 2;
        Engine.palfadergb.a = Math.min(63, offset) << 2;
        if (this.glrender() == null) {
            int k = 0;
            for (int i = 0; i < 256; ++i) {
                this.temppal[k++] = (byte)(curpalette.getRed(i) + ((Engine.palfadergb.r - curpalette.getRed(i)) * offset >> 6));
                this.temppal[k++] = (byte)(curpalette.getGreen(i) + ((Engine.palfadergb.g - curpalette.getGreen(i)) * offset >> 6));
                this.temppal[k++] = (byte)(curpalette.getBlue(i) + ((Engine.palfadergb.b - curpalette.getBlue(i)) * offset >> 6));
            }
            this.render.changepalette(this.temppal);
        }
    }

    public void clearview(int dacol) {
        this.render.clearview(dacol);
    }

    public void setviewtotile(int tilenume, int xsiz, int ysiz) {
        Tile pic = this.getTile(tilenume);
        if (this.render.getType() == Renderer.RenderType.Software) {
            ((Software)this.render).setviewtotile(tilenume, pic.getWidth(), pic.getHeight());
            return;
        }
        pic.setWidth(xsiz);
        pic.setHeight(ysiz);
        Engine.bakwindowx1[Engine.setviewcnt] = windowx1;
        Engine.bakwindowy1[Engine.setviewcnt] = windowy1;
        Engine.bakwindowx2[Engine.setviewcnt] = windowx2;
        Engine.bakwindowy2[Engine.setviewcnt] = windowy2;
        if (setviewcnt == 0) {
            baktile = tilenume;
        }
        offscreenrendering = true;
        ++setviewcnt;
        this.setview(0, 0, ysiz - 1, xsiz - 1);
        this.setaspect(65536, 65536);
    }

    public void setviewback() {
        if (setviewcnt <= 0) {
            return;
        }
        boolean bl = offscreenrendering = --setviewcnt > 0;
        if (setviewcnt == 0 && this.render.getType() != Renderer.RenderType.Software) {
            this.getTile((int)Engine.baktile).data = this.setviewbuf();
            this.render.invalidatetile(baktile, -1, -1);
        }
        this.setview(bakwindowx1[setviewcnt], bakwindowy1[setviewcnt], bakwindowx2[setviewcnt], bakwindowy2[setviewcnt]);
        if (this.render.getType() == Renderer.RenderType.Software) {
            ((Software)this.render).setviewback();
        }
    }

    public void squarerotatetile(int tilenume) {
        int ysiz;
        Tile pic = this.getTile(tilenume);
        int xsiz = pic.getWidth();
        if (xsiz == (ysiz = pic.getHeight())) {
            int k = xsiz << 1;
            for (int i = xsiz - 1; i >= 0; --i) {
                int ptr1 = i * (xsiz + 1);
                int ptr2 = ptr1--;
                if ((i & 1) != 0) {
                    this.squarerotatetileswap(tilenume, ptr1, ptr2 -= xsiz);
                }
                for (int j = (i >> 1) - 1; j >= 0; --j) {
                    this.squarerotatetileswap(tilenume, ptr1 -= 2, ptr2 -= k);
                    this.squarerotatetileswap(tilenume, ptr1 + 1, ptr2 + xsiz);
                }
            }
        }
    }

    private void squarerotatetileswap(int tilenume, int p1, int p2) {
        Tile pic = this.getTile(tilenume);
        byte tmp = pic.data[p1];
        pic.data[p1] = pic.data[p2];
        pic.data[p2] = tmp;
    }

    public void preparemirror(int dax, int day, int daz, float daang, float dahoriz, int dawall, int dasector) {
        int x = Engine.wall[dawall].x;
        int dx = Engine.wall[Engine.wall[dawall].point2].x - x;
        int y = Engine.wall[dawall].y;
        int dy = Engine.wall[Engine.wall[dawall].point2].y - y;
        int j = dx * dx + dy * dy;
        if (j == 0) {
            return;
        }
        int i = (dax - x) * dx + (day - y) * dy << 1;
        mirrorx = (x << 1) + Pragmas.scale(dx, i, j) - dax;
        mirrory = (y << 1) + Pragmas.scale(dy, i, j) - day;
        mirrorang = Gameutils.BClampAngle((float)(this.getangle(dx, dy) << 1) - daang);
        inpreparemirror = true;
    }

    public void completemirror() {
        this.render.completemirror();
    }

    public short sectorofwall(int theline) {
        int gap;
        if (theline < 0 || theline >= numwalls) {
            return -1;
        }
        short i = Engine.wall[theline].nextwall;
        if (i >= 0) {
            return Engine.wall[i].nextsector;
        }
        i = (short)gap;
        for (gap = numsectors >> 1; gap > 1; gap >>= 1) {
            if (Engine.sector[i].wallptr < theline) {
                i = (short)(i + gap);
                continue;
            }
            i = (short)(i - gap);
        }
        while (Engine.sector[i].wallptr > theline) {
            i = (short)(i - 1);
        }
        while (Engine.sector[i].wallptr + Engine.sector[i].wallnum <= theline) {
            i = (short)(i + 1);
        }
        return i;
    }

    public int getceilzofslope(int sectnum, int dax, int day) {
        if (sectnum < 0 || sectnum >= MAXSECTORS || sector[sectnum] == null) {
            return 0;
        }
        if ((Engine.sector[sectnum].ceilingstat & 2) == 0) {
            return Engine.sector[sectnum].ceilingz;
        }
        WALL wal = wall[Engine.sector[sectnum].wallptr];
        int dx = Engine.wall[wal.point2].x - wal.x;
        int dy = Engine.wall[wal.point2].y - wal.y;
        int i = this.ksqrt(dx * dx + dy * dy) << 5;
        if (i == 0) {
            return Engine.sector[sectnum].ceilingz;
        }
        long j = Pragmas.dmulscale(dx, day - wal.y, -dy, dax - wal.x, 3);
        return Engine.sector[sectnum].ceilingz + Pragmas.scale(Engine.sector[sectnum].ceilingheinum, j, i);
    }

    public int getflorzofslope(int sectnum, int dax, int day) {
        if (sectnum < 0 || sectnum >= MAXSECTORS || sector[sectnum] == null) {
            return 0;
        }
        if ((Engine.sector[sectnum].floorstat & 2) == 0) {
            return Engine.sector[sectnum].floorz;
        }
        WALL wal = wall[Engine.sector[sectnum].wallptr];
        int dx = Engine.wall[wal.point2].x - wal.x;
        int dy = Engine.wall[wal.point2].y - wal.y;
        int i = this.ksqrt(dx * dx + dy * dy) << 5;
        if (i == 0) {
            return Engine.sector[sectnum].floorz;
        }
        long j = Pragmas.dmulscale(dx, day - wal.y, -dy, dax - wal.x, 3);
        return Engine.sector[sectnum].floorz + Pragmas.scale(Engine.sector[sectnum].floorheinum, j, i);
    }

    public void getzsofslope(int sectnum, int dax, int day, int[] outz) {
        if (sectnum < 0 || sectnum >= MAXSECTORS || sector[sectnum] == null) {
            return;
        }
        SECTOR sec = sector[sectnum];
        if (sec == null) {
            return;
        }
        outz[0] = sec.ceilingz;
        outz[1] = sec.floorz;
        if (((sec.ceilingstat | sec.floorstat) & 2) != 0) {
            WALL wal = wall[sec.wallptr];
            WALL wal2 = wall[wal.point2];
            int dx = wal2.x - wal.x;
            int dy = wal2.y - wal.y;
            int i = this.ksqrt(dx * dx + dy * dy) << 5;
            if (i == 0) {
                return;
            }
            long j = Pragmas.dmulscale(dx, day - wal.y, -dy, dax - wal.x, 3);
            if ((sec.ceilingstat & 2) != 0) {
                outz[0] = outz[0] + Pragmas.scale(sec.ceilingheinum, j, i);
            }
            if ((sec.floorstat & 2) != 0) {
                outz[1] = outz[1] + Pragmas.scale(sec.floorheinum, j, i);
            }
        }
    }

    public void alignceilslope(int dasect, int x, int y, int z) {
        WALL wal = wall[Engine.sector[dasect].wallptr];
        int dax = Engine.wall[wal.point2].x - wal.x;
        int day = Engine.wall[wal.point2].y - wal.y;
        int i = (y - wal.y) * dax - (x - wal.x) * day;
        if (i == 0) {
            return;
        }
        Engine.sector[dasect].ceilingheinum = (short)Pragmas.scale(z - Engine.sector[dasect].ceilingz << 8, this.ksqrt(dax * dax + day * day), i);
        Engine.sector[dasect].ceilingstat = Engine.sector[dasect].ceilingheinum == 0 ? (short)(Engine.sector[dasect].ceilingstat & 0xFFFFFFFD) : (short)(Engine.sector[dasect].ceilingstat | 2);
    }

    public void alignflorslope(int dasect, int x, int y, int z) {
        WALL wal = wall[Engine.sector[dasect].wallptr];
        int dax = Engine.wall[wal.point2].x - wal.x;
        int day = Engine.wall[wal.point2].y - wal.y;
        int i = (y - wal.y) * dax - (x - wal.x) * day;
        if (i == 0) {
            return;
        }
        Engine.sector[dasect].floorheinum = (short)Pragmas.scale(z - Engine.sector[dasect].floorz << 8, this.ksqrt(dax * dax + day * day), i);
        Engine.sector[dasect].floorstat = Engine.sector[dasect].floorheinum == 0 ? (short)(Engine.sector[dasect].floorstat & 0xFFFFFFFD) : (short)(Engine.sector[dasect].floorstat | 2);
    }

    public int loopnumofsector(int sectnum, int wallnum) {
        int numloops = 0;
        int startwall = Engine.sector[sectnum].wallptr;
        int endwall = startwall + Engine.sector[sectnum].wallnum;
        for (int i = startwall; i < endwall; ++i) {
            if (i == wallnum) {
                return numloops;
            }
            if (Engine.wall[i].point2 >= i) continue;
            ++numloops;
        }
        return -1;
    }

    public void printext256(int xpos, int ypos, int col, int backcol, char[] name, int fontsize, float scale) {
        this.render.printext(xpos, ypos, col, backcol, name, fontsize, scale);
    }

    public String screencapture(String fn) {
        int d;
        int c;
        int b;
        int a;
        fn = fn.replaceAll("[^a-zA-Z0-9_. \\[\\]-]", "");
        fn = fn.substring(0, fn.lastIndexOf(46) - 4);
        DirectoryEntry userdir = BuildGdx.compat.getDirectory(Compat.Path.User);
        int capturecount = 0;
        while (true) {
            if (capturecount > 9999) {
                return null;
            }
            a = capturecount / 1000 % 10;
            b = capturecount / 100 % 10;
            c = capturecount / 10 % 10;
            d = capturecount % 10;
            if (userdir.checkFile(fn + a + b + c + d + ".png") == null) break;
            ++capturecount;
        }
        int w = xdim;
        int h = ydim;
        Pixmap capture = null;
        try {
            capture = new Pixmap(w, h, Pixmap.Format.RGB888);
            ByteBuffer pixels = capture.getPixels();
            pixels.put(this.render.getFrame(TileData.PixelFormat.Rgb, xdim, -ydim));
            File pci = new File(userdir.getAbsolutePath() + fn + a + b + c + d + ".png");
            PixmapIO.writePNG(new FileHandle(pci), capture);
            userdir.addFile(pci);
            capture.dispose();
            return fn + a + b + c + d + ".png";
        }
        catch (Throwable e) {
            if (capture != null) {
                capture.dispose();
            }
            return null;
        }
    }

    protected byte[] setviewbuf() {
        Tile pic = this.getTile(baktile);
        int width = pic.getWidth();
        int heigth = pic.getHeight();
        byte[] data = pic.data;
        if (data == null || data.length < width * heigth) {
            data = new byte[width * heigth];
        }
        ByteBuffer frame = this.render.getFrame(TileData.PixelFormat.Pal8, width, heigth);
        int sptr = 0;
        for (int i = width - 1; i >= 0; --i) {
            int dptr = i;
            for (int j = 0; j < heigth; ++j) {
                data[dptr] = frame.get(sptr++);
                dptr += width;
            }
        }
        return data;
    }

    public boolean setrendermode(Renderer render) {
        this.render = render;
        render.setDefs(this.getDefs());
        render.init();
        return render.isInited();
    }

    public Renderer getrender() {
        return this.render;
    }

    public GLRenderer glrender() {
        if (this.render != null && this.getrender().getType().getFrameType() == BuildFrame.FrameType.GL) {
            return (GLRenderer)this.render;
        }
        return null;
    }

    public void copytilepiece(int tilenume1, int sx1, int sy1, int xsiz, int ysiz, int tilenume2, int sx2, int sy2) {
        Tile pic1 = this.getTile(tilenume1);
        Tile pic2 = this.getTile(tilenume2);
        int xsiz1 = pic1.getWidth();
        int ysiz1 = pic1.getHeight();
        int xsiz2 = pic2.getWidth();
        int ysiz2 = pic2.getHeight();
        if (xsiz1 > 0 && ysiz1 > 0 && xsiz2 > 0 && ysiz2 > 0) {
            if (pic1.data == null) {
                this.loadtile(tilenume1);
            }
            if (pic2.data == null) {
                this.loadtile(tilenume2);
            }
            int x1 = sx1;
            for (int i = 0; i < xsiz; ++i) {
                int y1 = sy1;
                for (int j = 0; j < ysiz; ++j) {
                    byte ptr;
                    int x2 = sx2 + i;
                    int y2 = sy2 + j;
                    if (x2 >= 0 && y2 >= 0 && x2 < xsiz2 && y2 < ysiz2 && (ptr = pic1.data[x1 * ysiz1 + y1]) != 255) {
                        pic2.data[x2 * ysiz2 + y2] = ptr;
                    }
                    if (++y1 < ysiz1) continue;
                    y1 = 0;
                }
                if (++x1 < xsiz1) continue;
                x1 = 0;
            }
        }
    }

    public abstract void faketimerhandler();

    public void setgotpic(int tilenume) {
        int n = tilenume >> 3;
        gotpic[n] = (byte)(gotpic[n] | pow2char[tilenume & 7]);
    }

    public Clockdir clockdir(int wallstart) {
        int minx = Integer.MAX_VALUE;
        int themin = -1;
        int i = wallstart - 1;
        while (Gameutils.isValidWall(++i)) {
            if (Engine.wall[Engine.wall[i].point2].x < minx) {
                minx = Engine.wall[Engine.wall[i].point2].x;
                themin = i;
            }
            if (Engine.wall[i].point2 != wallstart) continue;
        }
        int x0 = Engine.wall[themin].x;
        int y0 = Engine.wall[themin].y;
        int x1 = Engine.wall[Engine.wall[themin].point2].x;
        int y1 = Engine.wall[Engine.wall[themin].point2].y;
        int x2 = Engine.wall[Engine.wall[Engine.wall[themin].point2].point2].x;
        int y2 = Engine.wall[Engine.wall[Engine.wall[themin].point2].point2].y;
        if (y1 >= y2 && y1 <= y0) {
            return Clockdir.CW;
        }
        if (y1 >= y0 && y1 <= y2) {
            return Clockdir.CCW;
        }
        int templong = (x0 - x1) * (y2 - y1) - (x2 - x1) * (y0 - y1);
        if (templong < 0) {
            return Clockdir.CW;
        }
        return Clockdir.CCW;
    }

    public int loopinside(int x, int y, int startwall) {
        int cnt = this.clockdir(startwall).getValue();
        int i = startwall;
        do {
            int x1 = Engine.wall[i].x;
            int x2 = Engine.wall[Engine.wall[i].point2].x;
            if (x1 < x && x2 < x) continue;
            int y1 = Engine.wall[i].y;
            int y2 = Engine.wall[Engine.wall[i].point2].y;
            if (y1 > y2) {
                int templong = x1;
                x1 = x2;
                x2 = templong;
                templong = y1;
                y1 = y2;
                y2 = templong;
            }
            if (y1 > y || y2 <= y || x1 * (y - y2) + x2 * (y1 - y) > x * (y1 - y2)) continue;
            cnt ^= 1;
        } while ((i = (int)Engine.wall[i].point2) != startwall);
        return cnt;
    }

    public void flipwalls(int numwalls, int newnumwalls) {
        int nume = newnumwalls - numwalls;
        for (int i = numwalls; i < numwalls + (nume >> 1); ++i) {
            int j = numwalls + newnumwalls - i - 1;
            int tempint = Engine.wall[i].x;
            Engine.wall[i].x = Engine.wall[j].x;
            Engine.wall[j].x = tempint;
            tempint = Engine.wall[i].y;
            Engine.wall[i].y = Engine.wall[j].y;
            Engine.wall[j].y = tempint;
        }
    }

    public static KeyInput getInput() {
        return input;
    }

    public void handleevents() {
        input.handleevents();
        Console.HandleScanCode();
        this.sampletimer();
    }

    public void initkeys() {
        input = new KeyInput();
    }

    public void printfps(float scale) {
        if (System.currentTimeMillis() - this.fpstime >= 1000L) {
            int fps = BuildGdx.graphics.getFramesPerSecond();
            float rate = BuildGdx.graphics.getDeltaTime() * 1000.0f;
            if (fps <= 9999 && rate <= 9999.0f) {
                int chars = Strhandler.buildString(this.fpsbuffer, 0, Double.toString((double)Math.round(rate * 100.0f) / 100.0));
                chars = Strhandler.buildString(this.fpsbuffer, chars, "ms ", fps);
                chars = Strhandler.buildString(this.fpsbuffer, chars, "fps");
                this.fpsx = windowx2 - (int)((float)(chars << 3) * scale);
                this.fpsy = windowy1 + 1;
            }
            this.fpstime = System.currentTimeMillis();
        }
        this.render.printext(this.fpsx, this.fpsy, this.fpscol, -1, this.fpsbuffer, 0, scale);
    }

    public Tile getTile(int tilenum) {
        if (this.tiles[tilenum] == null) {
            this.tiles[tilenum] = new Tile();
        }
        return this.tiles[tilenum];
    }

    public void setDefs(DefScript defs) {
        this.defs = defs;
        if (this.getrender() == null) {
            throw new NullPointerException("Renderer is not initialized!");
        }
        this.getrender().setDefs(defs);
    }

    public DefScript getDefs() {
        return this.defs;
    }

    static {
        TRANSLUSCENT1 = 0.66f;
        TRANSLUSCENT2 = 0.33f;
        MAXDRUNKANGLE = 2.5f;
        setviewcnt = 0;
        USERTILES = 256;
        MAXTILES = 9216 + USERTILES;
        MAXSECTORS = 1024;
        MAXWALLS = 8192;
        MAXVOXELS = MAXSPRITES = 4096;
        rayx = 0;
        rayy = 0;
        paletteloaded = 0;
        tablesloaded = 0;
        curbrightness = 0;
        xdimen = -1;
        pow2char = new short[]{1, 2, 4, 8, 16, 32, 64, 128};
        pow2long = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MAX_VALUE};
        clipmoveboxtracenum = 3;
        hitscangoalx = 0x1FFFFFFF;
        hitscangoaly = 0x1FFFFFFF;
        beforedrawrooms = 1;
        inpreparemirror = false;
        artfil = null;
        SETSPRITEZ = 0;
    }

    public static class Point {
        private int x;
        private int y;
        private int z;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public Point set(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Point set(int x, int y) {
            this.x = x;
            this.y = y;
            this.z = 0;
            return this;
        }

        public boolean equals(int x, int y) {
            return this.x == x && this.y == y;
        }

        public boolean equals(int x, int y, int z) {
            return this.x == x && this.y == y && this.z == z;
        }
    }

    protected class Line {
        public int x1;
        public int y1;
        public int x2;
        public int y2;

        protected Line() {
        }
    }

    protected class Clip {
        private int x;
        private int y;
        private int z;
        private short num;

        protected Clip() {
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public short getNum() {
            return this.num;
        }

        public Clip set(int x, int y, int z, short num) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.num = num;
            return this;
        }
    }

    public static enum Clockdir {
        CW(0),
        CCW(1);

        private final int value;

        private Clockdir(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }
}

