/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;

public class DataResource
extends GroupResource {
    private static final byte[] tmp = new byte[1024];

    public DataResource(byte[] data) {
        super(null);
        this.initBuffer(data);
    }

    public DataResource(Group parent, String filename, int fileid, byte[] data) {
        super(parent);
        this.handleName(filename);
        this.fileid = fileid;
        this.initBuffer(data);
    }

    private void initBuffer(byte[] data) {
        if (data != null) {
            this.buffer = ByteBuffer.allocateDirect(data.length);
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.buffer.put(data).rewind();
            this.size = data.length;
        }
    }

    @Override
    public void toMemory() {
        this.buffer.rewind();
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            this.buffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int seek(long offset, Resource.Whence whence) {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            switch (whence) {
                case Set: {
                    this.buffer.position((int)offset);
                    break;
                }
                case Current: {
                    this.buffer.position(this.buffer.position() + (int)offset);
                    break;
                }
                case End: {
                    this.buffer.position(this.size + (int)offset);
                }
            }
            return this.position();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buf, int offset, int len) {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            if (this.position() >= this.size) {
                return -1;
            }
            len = Math.min(len, this.size - this.position());
            this.buffer.get(buf, offset, len);
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buf) {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            return this.read(buf, 0, buf.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer bb, int offset, int len) {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            if (this.position() >= this.size) {
                return -1;
            }
            bb.position(offset);
            int p = 0;
            while (len > 0) {
                int var = this.read(tmp, 0, Math.min(len, tmp.length));
                if (var == -1) {
                    return p;
                }
                bb.put(tmp, 0, var);
                len -= var;
                p += var;
            }
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Byte readByte() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            return this.buffer.get();
        }
    }

    @Override
    public Boolean readBoolean() {
        Byte var = this.readByte();
        if (var != null) {
            return var == 1;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short readShort() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            return this.buffer.getShort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer readInt() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            return this.buffer.getInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long readLong() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            return this.buffer.getLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float readFloat() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            return Float.valueOf(this.buffer.getFloat());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString(int len) {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            byte[] data = new byte[len];
            if (this.read(data) != len) {
                return null;
            }
            return new String(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int position() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            return this.buffer.position();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            byte[] data = new byte[this.buffer.capacity()];
            this.buffer.rewind();
            this.buffer.get(data);
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            return this.buffer == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remaining() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            return this.buffer.remaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRemaining() {
        Object object = this.parent != null ? this.parent : this;
        synchronized (object) {
            return this.buffer.hasRemaining();
        }
    }
}

