/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.Resource;

public class FEntryResource
implements Resource {
    protected FileEntry file;
    protected Resource res;

    public FEntryResource(FileEntry file) {
        this.file = file;
        this.res = null;
    }

    public boolean open() {
        if (this.res == null) {
            this.res = BuildGdx.cache.open(this.file.getPath(), 0);
        }
        return this.res != null;
    }

    @Override
    public String getExtension() {
        return this.file.getExtension();
    }

    @Override
    public Group getParent() {
        return null;
    }

    @Override
    public void close() {
        if (this.res != null) {
            this.res.close();
        }
        this.res = null;
    }

    @Override
    public boolean isClosed() {
        return this.res == null;
    }

    @Override
    public int seek(long offset, Resource.Whence whence) {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.seek(offset, whence);
    }

    @Override
    public int read(byte[] buf, int offset, int len) {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.read(buf, offset, len);
    }

    @Override
    public int read(byte[] buf) {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.read(buf);
    }

    @Override
    public int read(ByteBuffer bb, int offset, int len) {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.read(bb, offset, len);
    }

    @Override
    public String readString(int len) {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.readString(len);
    }

    @Override
    public Integer readInt() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.readInt();
    }

    @Override
    public Short readShort() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.readShort();
    }

    @Override
    public Byte readByte() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.readByte();
    }

    @Override
    public Boolean readBoolean() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.readBoolean();
    }

    @Override
    public Long readLong() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.readLong();
    }

    @Override
    public Float readFloat() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.readFloat();
    }

    @Override
    public int size() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.size();
    }

    @Override
    public int position() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.position();
    }

    @Override
    public int remaining() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.remaining();
    }

    @Override
    public boolean hasRemaining() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.hasRemaining();
    }

    @Override
    public void toMemory() {
        if (this.isClosed()) {
            this.open();
        }
        this.res.toMemory();
    }

    @Override
    public byte[] getBytes() {
        if (this.isClosed()) {
            this.open();
        }
        return this.res.getBytes();
    }

    @Override
    public String getFullName() {
        return this.file.getName();
    }
}

