/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.io.File;

public class FileUtils {
    public static boolean isExtension(String filename, String ext) {
        return filename.endsWith("." + ext);
    }

    public static String getExtension(String filename) {
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        return filename.substring(filename.lastIndexOf(46) + 1);
    }

    public static String getNameWithoutExtension(String filename) {
        return filename.substring(0, filename.lastIndexOf(46));
    }

    public static String getFullName(String path) {
        int index;
        if (path != null && ((index = path.lastIndexOf(File.separator)) != -1 || (index = path.lastIndexOf("\\")) != -1 || (index = path.lastIndexOf("/")) != -1)) {
            path = path.substring(index + 1);
        }
        return path;
    }

    public static String getCorrectPath(String path) {
        if (path != null) {
            String[] separators;
            for (String separator : separators = new String[]{"/", "\\"}) {
                if (separator.equals(File.separator) || !path.contains(separator)) continue;
                path = path.replace(separator, File.separator);
            }
            path = path.replaceAll("(\\\\){2,}", "$1");
        }
        return path;
    }
}

