/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ru.m210projects.Build.FileHandle.Cache1D;
import ru.m210projects.Build.FileHandle.DataResource;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Strhandler;

public class PackedZipGroup
extends Group {
    private final Resource file;

    public PackedZipGroup(Resource file) throws IOException {
        ZipEntry entry;
        this.file = file;
        this.type = Cache1D.PackageType.PackedZip;
        file.seek(0L, Resource.Whence.Set);
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(file.getBytes()));
        while ((entry = zis.getNextEntry()) != null) {
            ZipResource res = new ZipResource(entry);
            if (res.size > 0) {
                this.add(res);
                ++this.numfiles;
            }
            zis.closeEntry();
        }
        zis.close();
    }

    private boolean findEntry(ZipResource res) {
        if (res != null) {
            try {
                ZipEntry entry;
                this.file.seek(0L, Resource.Whence.Set);
                ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(this.file.getBytes()));
                while ((entry = zis.getNextEntry()) != null) {
                    if (this.handleName(entry.getName()).equals(res.filenamext)) {
                        int len;
                        byte[] data = new byte[512];
                        res.buffer = ByteBuffer.allocateDirect(res.size);
                        res.buffer.order(ByteOrder.LITTLE_ENDIAN);
                        while ((len = zis.read(data)) != -1) {
                            res.buffer.put(data, 0, len);
                        }
                        res.buffer.rewind();
                        return true;
                    }
                    zis.closeEntry();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected String handleName(String fullname) {
        String filenamext = Strhandler.toLowerCase(fullname).replaceAll("[^a-zA-Z0-9_. /-]", "");
        if (filenamext.contains("/")) {
            filenamext = filenamext.replace("/", File.separator);
        }
        return filenamext;
    }

    public void removeFolders() {
        List<GroupResource> list = this.getList();
        this.filelist.clear();
        this.lookup.clear();
        for (GroupResource res : list) {
            int point;
            int index = res.filenamext.lastIndexOf(File.separator);
            if (index != -1) {
                res.filenamext = res.filenamext.substring(index + 1);
            }
            res.filename = (point = res.filenamext.lastIndexOf(46)) != -1 ? res.filenamext.substring(0, point) : res.filenamext;
            this.add(res);
        }
    }

    @Override
    protected boolean open(GroupResource res) {
        ZipResource available = (ZipResource)res;
        return this.findEntry(available);
    }

    @Override
    public int position() {
        return 0;
    }

    private class ZipResource
    extends DataResource {
        public ZipResource(ZipEntry entry) {
            super(PackedZipGroup.this, entry.getName(), 0, null);
            String fileid = entry.getComment();
            if (fileid != null && !fileid.isEmpty()) {
                fileid = fileid.replaceAll("[^0-9]", "");
                this.fileid = Integer.parseInt(fileid);
            }
            this.size = (int)entry.getSize();
            if (PackedZipGroup.this.debug && this.size > 0) {
                System.out.println("\t" + this.filenamext + ", size: " + this.size);
            }
        }

        @Override
        protected void handleName(String fullname) {
            this.filenamext = PackedZipGroup.this.handleName(fullname);
            int point = this.filenamext.lastIndexOf(46);
            if (point != -1) {
                this.fileformat = this.filenamext.substring(point + 1);
                this.filename = this.filenamext.substring(0, point);
            } else {
                this.fileformat = "";
                this.filename = this.filenamext;
            }
        }

        @Override
        public void flush() {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Group group = this.parent;
            synchronized (group) {
                this.buffer.clear();
                this.buffer = null;
            }
        }
    }
}

