/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.FileHandle.Cache1D;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Types.LittleEndian;

public class RffGroup
extends Group {
    private static final byte[] readbuf = new byte[1024];
    private Resource file = null;
    private final boolean crypted;

    public RffGroup(Resource groupFile, Cache1D.PackageType type) throws Exception {
        int revision;
        this.file = groupFile;
        this.type = type;
        if (type == Cache1D.PackageType.PackedRff) {
            this.file.toMemory();
        }
        if (this.file.position() != 4) {
            this.file.seek(0L, Resource.Whence.Set);
            this.file.read(readbuf, 0, 4);
            if ((char)readbuf[0] != 'R' || (char)readbuf[1] != 'F' || (char)readbuf[2] != 'F' || readbuf[3] != 26) {
                throw new Exception("RFF header corrupted");
            }
        }
        if (((revision = this.file.readInt().intValue()) & 0xFFF00000) == 0 && (revision & 0xFF00) == 768) {
            this.crypted = true;
        } else if ((revision & 0xFFF00000) == 0 && (revision & 0xFF00) == 512) {
            this.crypted = false;
        } else {
            if (revision == 378470704) {
                throw new Exception("RFF alpha version is not supported!");
            }
            throw new Exception("Unknown RFF version: " + Integer.toHexString(revision));
        }
        int offFat = this.file.readInt();
        this.numfiles = this.file.readInt();
        if (this.numfiles != 0) {
            byte[] buffer = new byte[this.numfiles * 48];
            if (this.file.seek(offFat, Resource.Whence.Set) == -1) {
                throw new Exception("r == -1");
            }
            if (this.file.read(buffer) == -1) {
                throw new Exception("RFF dictionary corrupted");
            }
            if (this.crypted) {
                if (revision == 768) {
                    this.encrypt(buffer, 0, buffer.length, offFat);
                } else if (revision == 769) {
                    this.encrypt(buffer, 0, buffer.length, offFat + offFat * (revision & 0xFF));
                }
            }
            byte[] buf = new byte[48];
            for (int i = 0; i < this.numfiles; ++i) {
                System.arraycopy(buffer, 48 * i, buf, 0, 48);
                RffResource res = new RffResource(buf);
                if (res.size > 0) {
                    this.add(res);
                    continue;
                }
                Console.Println("Error: negative file size! " + res.filename + " size: " + res.size, Console.OSDTEXT_RED);
            }
        }
        this.numfiles = this.filelist.size();
        for (GroupResource gres : this.filelist) {
            RffResource res = (RffResource)gres;
            if ((res.flags & 4) != 0) {
                res.toMemory();
            }
            if ((res.flags & 8) == 0) continue;
            res.toMemory();
        }
    }

    private void encrypt(byte[] buffer, int offset, int size, int offFat) {
        int i = 0;
        while (i < size) {
            int key = offFat++ >> 1;
            byte data = buffer[i++];
            buffer[offset + i - 1] = (byte)(data ^ key);
        }
    }

    @Override
    protected boolean open(GroupResource res) {
        if (this.file == null) {
            return false;
        }
        RffResource rres = (RffResource)res;
        if (rres != null) {
            rres.pos = 0;
            return true;
        }
        return false;
    }

    @Override
    public int position() {
        if (this.file != null) {
            return this.file.position();
        }
        return -1;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.file != null && !this.file.isClosed()) {
            this.file.close();
        }
        this.file = null;
    }

    private class RffResource
    extends GroupResource {
        public int offset;
        public byte flags;
        public int pos;

        public RffResource(byte[] data) {
            super(RffGroup.this);
            this.offset = LittleEndian.getInt(data, 16);
            this.size = LittleEndian.getInt(data, 20);
            this.flags = data[32];
            String fmt = new String(data, 33, 3);
            String name = new String(data, 36, 8);
            this.handleName(name + "." + fmt);
            this.fileid = LittleEndian.getInt(data, 44);
            if (RffGroup.this.debug && this.size > 0) {
                System.out.println("\t" + this.filenamext + ", fileid: " + this.fileid + ", size: " + this.size);
            }
        }

        @Override
        public void flush() {
            super.flush();
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Group group = this.parent;
            synchronized (group) {
                this.pos = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int seek(long offset, Resource.Whence whence) {
            Group group = this.parent;
            synchronized (group) {
                switch (whence) {
                    case Set: {
                        this.pos = (int)offset;
                        break;
                    }
                    case Current: {
                        this.pos = (int)((long)this.pos + offset);
                        break;
                    }
                    case End: {
                        this.pos = this.size + (int)offset;
                    }
                }
                RffGroup.this.file.seek(offset + (long)this.pos, Resource.Whence.Set);
                return this.pos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf, int offs, int len) {
            Group group = this.parent;
            synchronized (group) {
                if (this.pos >= this.size) {
                    return -1;
                }
                len = Math.min(len, this.size - this.pos);
                int i = this.offset + this.pos;
                int groupfilpos = RffGroup.this.file.position();
                if (i != groupfilpos) {
                    RffGroup.this.file.seek(i, Resource.Whence.Set);
                }
                len = RffGroup.this.file.read(buf, offs, len);
                if ((this.flags & 0x10) != 0 && this.pos < 256) {
                    RffGroup.this.encrypt(buf, offs, Math.min(256 - this.pos, len), this.pos);
                }
                this.pos += len;
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf) {
            Group group = this.parent;
            synchronized (group) {
                return this.read(buf, 0, buf.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer bb, int offset, int len) {
            Group group = this.parent;
            synchronized (group) {
                int var = -1;
                bb.position(offset);
                int p = 0;
                while (len > 0) {
                    var = this.read(readbuf, 0, Math.min(len, readbuf.length));
                    if (var == -1) {
                        return p;
                    }
                    bb.put(readbuf, 0, var);
                    len -= var;
                    p += var;
                }
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Byte readByte() {
            Group group = this.parent;
            synchronized (group) {
                int len = 1;
                if (len > this.size - this.pos) {
                    return null;
                }
                int i = this.offset + this.pos;
                int groupfilpos = RffGroup.this.file.position();
                if (i != groupfilpos) {
                    RffGroup.this.file.seek(i, Resource.Whence.Set);
                }
                if (RffGroup.this.file.read(readbuf, 0, len) != len) {
                    return null;
                }
                if ((this.flags & 0x10) != 0 && this.pos < 256) {
                    RffGroup.this.encrypt(readbuf, 0, Math.min(256 - this.pos, len), this.pos);
                }
                this.pos += len;
                return readbuf[0];
            }
        }

        @Override
        public Boolean readBoolean() {
            Byte var = this.readByte();
            if (var != null) {
                return var == 1;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Short readShort() {
            Group group = this.parent;
            synchronized (group) {
                int len = 2;
                if (len > this.size - this.pos) {
                    return null;
                }
                int i = this.offset + this.pos;
                int groupfilpos = RffGroup.this.file.position();
                if (i != groupfilpos) {
                    RffGroup.this.file.seek(i, Resource.Whence.Set);
                }
                if (RffGroup.this.file.read(readbuf, 0, len) != len) {
                    return null;
                }
                if ((this.flags & 0x10) != 0 && this.pos < 256) {
                    RffGroup.this.encrypt(readbuf, 0, Math.min(256 - this.pos, len), this.pos);
                }
                this.pos += len;
                return (short)(((readbuf[1] & 0xFF) << 8) + (readbuf[0] & 0xFF));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer readInt() {
            Group group = this.parent;
            synchronized (group) {
                int len = 4;
                if (len > this.size - this.pos) {
                    return null;
                }
                int i = this.offset + this.pos;
                int groupfilpos = RffGroup.this.file.position();
                if (i != groupfilpos) {
                    RffGroup.this.file.seek(i, Resource.Whence.Set);
                }
                if (RffGroup.this.file.read(readbuf, 0, len) != len) {
                    return null;
                }
                if ((this.flags & 0x10) != 0 && this.pos < 256) {
                    RffGroup.this.encrypt(readbuf, 0, Math.min(256 - this.pos, len), this.pos);
                }
                this.pos += len;
                return ((readbuf[3] & 0xFF) << 24) + ((readbuf[2] & 0xFF) << 16) + ((readbuf[1] & 0xFF) << 8) + (readbuf[0] & 0xFF);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long readLong() {
            Group group = this.parent;
            synchronized (group) {
                int len = 8;
                if (len > this.size - this.pos) {
                    return null;
                }
                int i = this.offset + this.pos;
                int groupfilpos = RffGroup.this.file.position();
                if (i != groupfilpos) {
                    RffGroup.this.file.seek(i, Resource.Whence.Set);
                }
                if (RffGroup.this.file.read(readbuf, 0, len) != len) {
                    return null;
                }
                if ((this.flags & 0x10) != 0 && this.pos < 256) {
                    RffGroup.this.encrypt(readbuf, 0, Math.min(256 - this.pos, len), this.pos);
                }
                this.pos += len;
                return (((long)readbuf[7] & 0xFFL) << 56) + (((long)readbuf[6] & 0xFFL) << 48) + (((long)readbuf[5] & 0xFFL) << 40) + (((long)readbuf[4] & 0xFFL) << 32) + (((long)readbuf[3] & 0xFFL) << 24) + (((long)readbuf[2] & 0xFFL) << 16) + (((long)readbuf[1] & 0xFFL) << 8) + ((long)readbuf[0] & 0xFFL);
            }
        }

        @Override
        public Float readFloat() {
            Integer i = this.readInt();
            if (i != null) {
                return Float.valueOf(Float.intBitsToFloat(i));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String readString(int len) {
            Group group = this.parent;
            synchronized (group) {
                byte[] data = len < readbuf.length ? readbuf : new byte[len];
                if (this.read(data, 0, len) != len) {
                    return null;
                }
                return new String(data, 0, len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int position() {
            Group group = this.parent;
            synchronized (group) {
                return this.pos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toMemory() {
            Group group = this.parent;
            synchronized (group) {
                if (this.buffer == null) {
                    if (RffGroup.this.file.seek(this.offset, Resource.Whence.Set) == -1) {
                        Console.Println("Error seeking to resource!");
                        return;
                    }
                    this.buffer = ByteBuffer.allocateDirect(this.size);
                    this.buffer.order(ByteOrder.LITTLE_ENDIAN);
                    byte[] data = this.getBytes();
                    if ((this.flags & 0x10) != 0) {
                        RffGroup.this.encrypt(data, 0, Math.min(256, this.size), 0);
                    }
                    this.buffer.put(data);
                }
                this.buffer.rewind();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getBytes() {
            Group group = this.parent;
            synchronized (group) {
                int size = this.size();
                if (size > 0) {
                    if (RffGroup.this.file.seek(this.offset, Resource.Whence.Set) == -1) {
                        Console.Println("Error seeking to resource!");
                        return null;
                    }
                    byte[] data = new byte[size];
                    if (RffGroup.this.file.read(data) == -1) {
                        Console.Println("Error loading resource!");
                        return null;
                    }
                    if ((this.flags & 0x10) != 0) {
                        RffGroup.this.encrypt(data, 0, Math.min(256, size), 0);
                    }
                    return data;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isClosed() {
            Group group = this.parent;
            synchronized (group) {
                if (RffGroup.this.file != null) {
                    return RffGroup.this.file.isClosed();
                }
                return true;
            }
        }

        @Override
        public int remaining() {
            return this.size() - this.position();
        }

        @Override
        public boolean hasRemaining() {
            return this.position() < this.size();
        }
    }
}

