/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Input;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildController;
import ru.m210projects.Build.OnSceenDisplay.Console;

public abstract class BuildControllers {
    public static final int MAXBUTTONS = 64;
    public static final int MAXPOV = 4;
    public static final int MAXAXIS = 12;
    private List<BuildController> gamepads;
    private float deadZone = 0.01f;
    private final boolean TestGamepad = false;

    public BuildControllers init() {
        this.gamepads = new ArrayList<BuildController>();
        this.getControllers(this.gamepads);
        if (this.gamepads.size() == 0) {
            Console.Println("No gamepads found.", Console.OSDTEXT_YELLOW);
        } else {
            for (int i = 0; i < this.gamepads.size(); ++i) {
                BuildController c = this.gamepads.get(i);
                Console.Println("Found controller: \"" + c.getName() + "\" [buttons: " + c.getButtonCount() + " axises: " + c.getAxisCount() + " povs: " + c.getPovCount() + "]", Console.OSDTEXT_YELLOW);
            }
        }
        return this;
    }

    protected abstract void getControllers(List<BuildController> var1);

    public int getControllers() {
        return this.gamepads.size();
    }

    public boolean isValidDevice(int deviceIndex) {
        return this.gamepads.size() > 0 && deviceIndex >= 0 && deviceIndex < this.gamepads.size();
    }

    public String getControllerName(int num) {
        return this.gamepads.get(num).getName();
    }

    public void setDeadZone(float value) {
        this.deadZone = value;
    }

    public boolean buttonPressed() {
        for (int i = 0; i < this.gamepads.size(); ++i) {
            if (!this.gamepads.get(i).buttonPressed()) continue;
            return true;
        }
        return false;
    }

    public int getButtonCount(int num) {
        int size = this.getControllers();
        if (size > 0 && size > num) {
            return this.gamepads.get(num).getButtonCount();
        }
        return 0;
    }

    public void handler() {
        for (int i = 0; i < this.gamepads.size(); ++i) {
            this.gamepads.get(i).update();
        }
    }

    public void resetButtonStatus() {
        for (int i = 0; i < this.gamepads.size(); ++i) {
            this.gamepads.get(i).resetButtonStatus();
        }
    }

    public boolean buttonStatusOnce(int deviceIndex, int buttonCode) {
        return this.gamepads.get(deviceIndex).buttonStatusOnce(buttonCode);
    }

    public boolean buttonPressed(int deviceIndex, int buttonCode) {
        return this.gamepads.get(deviceIndex).buttonPressed(buttonCode);
    }

    public boolean buttonStatus(int deviceIndex, int buttonCode) {
        return this.gamepads.get(deviceIndex).buttonStatus(buttonCode);
    }

    public Vector2 getStickValue(int deviceIndex, int aCode1, int aCode2) {
        return this.gamepads.get(deviceIndex).getStickValue(aCode1, aCode2, this.deadZone);
    }
}

