/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Input;

import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Input.InputCallback;
import ru.m210projects.Build.Strhandler;

public class KeyInput {
    public static final int KEYFIFOSIZ = 64;
    public byte[] keystatus = new byte[257];
    public byte[] keyfifo = new byte[64];
    public byte keyfifoplc;
    public byte keyfifoend;
    public int locmessagelen;
    public static final char[] lockeybuf = new char[40];
    public boolean[] hitkey = new boolean[256];
    public static char[] gdxscantoasc = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ',', '.', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '`', '-', '=', '[', ']', '\\', ';', '\'', '/', '\u0000', '\u0000', '\u0000', '\u0000', '+', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static char[] gdxscantoascwithshift = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ')', '!', '@', '#', '$', '%', '^', '&', '*', '(', '*', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '<', '>', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '~', '_', '+', '{', '}', '|', ':', '\"', '?', '\u0000', '\u0000', '\u0000', '\u0000', '+', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};

    public int getKey(int key) {
        return this.keystatus[key];
    }

    public void setKey(int key, int state) {
        this.keystatus[key] = (byte)state;
        if (state != 0) {
            this.keyfifo[this.keyfifoend] = (byte)key;
            this.keyfifo[this.keyfifoend + 1 & 0x3F] = (byte)state;
            this.keyfifoend = (byte)(this.keyfifoend + 2 & 0x3F);
        }
    }

    public void resetKeyStatus() {
        Arrays.fill(this.keystatus, (byte)0);
    }

    public int handleevents() {
        int kb;
        BuildGdx.input.processMessages();
        BuildGdx.input.cursorHandler();
        int rv = 0;
        boolean keyPressed = false;
        if (BuildGdx.input.isKeyPressed(-1)) {
            for (kb = 1; kb < 256; ++kb) {
                if (kb == 224) {
                    kb = 237;
                }
                if (BuildGdx.input.isKeyPressed(kb)) {
                    keyPressed = true;
                    if (this.hitkey[kb]) continue;
                    this.keystatus[256] = 1;
                    this.setKey(kb, 1);
                    this.hitkey[kb] = true;
                    continue;
                }
                this.setKey(kb, 0);
                this.hitkey[kb] = false;
            }
        } else {
            for (kb = 1; kb < 256; ++kb) {
                if (kb == 224) {
                    kb = 237;
                }
                this.keystatus[kb] = 0;
                this.hitkey[kb] = false;
            }
        }
        for (kb = 0; kb < 10; ++kb) {
            int index = 226 + kb;
            if (BuildGdx.input.isButtonPressed(kb)) {
                keyPressed = true;
                if (this.hitkey[index]) continue;
                this.keystatus[256] = 1;
                this.setKey(index, 1);
                this.hitkey[index] = true;
                continue;
            }
            this.setKey(index, 0);
            this.hitkey[index] = false;
        }
        int wheel = BuildGdx.input.getDWheel();
        if (wheel > 0) {
            keyPressed = true;
            if (!this.hitkey[224]) {
                this.keystatus[256] = 1;
                this.setKey(224, 1);
                this.hitkey[224] = true;
            }
        } else if (wheel < 0) {
            keyPressed = true;
            if (!this.hitkey[225]) {
                this.keystatus[256] = 1;
                this.setKey(225, 1);
                this.hitkey[225] = true;
            }
        } else {
            this.setKey(224, 0);
            this.hitkey[224] = false;
            this.setKey(225, 0);
            this.hitkey[225] = false;
        }
        if (!keyPressed) {
            this.keystatus[256] = 0;
        }
        return rv;
    }

    public boolean keyStatusOnce(int keyId) {
        if (keyId > 0 && this.getKey(keyId) == 1) {
            this.setKey(keyId, 0);
            return true;
        }
        return false;
    }

    public boolean keyStatus(int keyId) {
        return keyId > 0 && this.getKey(keyId) == 1;
    }

    public boolean keyPressed(int kb) {
        return this.hitkey[kb];
    }

    public void keyPressed(int kb, boolean press) {
        this.hitkey[kb] = press;
    }

    public void initMessageInput(String text) {
        this.keyfifoend = 0;
        this.keyfifoplc = 0;
        if (text == null) {
            this.locmessagelen = 0;
            KeyInput.lockeybuf[this.locmessagelen] = '\u0000';
        } else if (!text.isEmpty() && !text.equals("Empty")) {
            int len = 0;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == '\u0000') continue;
                KeyInput.lockeybuf[len++] = text.charAt(i);
            }
            this.locmessagelen = len;
        }
    }

    public char[] getMessageBuffer() {
        return lockeybuf;
    }

    public int getMessageLength() {
        return this.locmessagelen;
    }

    public int putMessage(int maxsize, boolean cursor, boolean overtype, boolean specialSymbols) {
        while (this.keyfifoplc != this.keyfifoend) {
            int ch = this.keyfifo[this.keyfifoplc] & 0xFF;
            byte keystate = this.keyfifo[this.keyfifoplc + 1 & 0x3F];
            this.keyfifoplc = (byte)(this.keyfifoplc + 2 & 0x3F);
            if (keystate == 0) continue;
            if (ch == 131) {
                this.keystatus[131] = 0;
                this.locmessagelen = 0;
                return -1;
            }
            if (ch == 67) {
                this.keystatus[67] = 0;
                if (this.locmessagelen == 0) break;
                --this.locmessagelen;
                KeyInput.lockeybuf[this.locmessagelen] = '\u0000';
            }
            if (ch == 66) {
                this.keystatus[66] = 0;
                return 1;
            }
            if (this.locmessagelen >= maxsize - 1 || ch >= 128 || (ch = specialSymbols && BuildGdx.input.isKeyPressed(59) || BuildGdx.input.isKeyPressed(60) ? gdxscantoascwithshift[ch] : gdxscantoasc[ch]) == 0 || !specialSymbols && (specialSymbols || !Strhandler.isalpha((char)ch) && !Strhandler.isdigit((char)ch) && ch != 32)) continue;
            KeyInput.lockeybuf[this.locmessagelen++] = (char)ch;
        }
        if (cursor) {
            KeyInput.lockeybuf[this.locmessagelen] = (Engine.totalclock & 0x20) != 0 ? 95 : 0;
        }
        return 0;
    }

    public int putMessage(InputCallback callback, boolean cursor) {
        while (this.keyfifoplc != this.keyfifoend) {
            int ch = this.keyfifo[this.keyfifoplc] & 0xFF;
            byte keystate = this.keyfifo[this.keyfifoplc + 1 & 0x3F];
            this.keyfifoplc = (byte)(this.keyfifoplc + 2 & 0x3F);
            if (keystate == 0) continue;
            return callback.run(ch);
        }
        if (cursor) {
            KeyInput.lockeybuf[this.locmessagelen] = (Engine.totalclock & 0x20) != 0 ? 95 : 0;
        }
        return 0;
    }
}

