/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern;

import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.LittleEndian;

public abstract class BuildNet {
    public BuildGame game;
    public static final byte kPacketMasterFrame = 0;
    public static final byte kPacketSlaveFrame = 1;
    public static final byte kPacketDisconnect = 7;
    public static final byte kPacketSlaveProfile = -6;
    public static final byte kPacketMasterStart = -5;
    public static final byte kPacketLevelStart = -4;
    public static final byte kPacketEmpty = -2;
    public static final byte kPacketLogout = -1;
    public static final int kNetFifoSize = 256;
    public static final int kFifoMask = 255;
    public boolean ready2send;
    public int ototalclock = 0;
    public int gNetFifoTail;
    public int[] gNetFifoHead = new int[16];
    public int gPredictTail;
    public int gNetFifoMasterTail;
    public NetInput gInput;
    public NetInput[][] gFifoInput = new NetInput[256][16];
    public int MovesPerPacket = 1;
    public int[] myMinLag = new int[16];
    public int otherMinLag;
    public int myMaxLag;
    public int bufferJitter = 0;
    public byte[] playerReady = new byte[16];
    public byte[] packbuf = new byte[256];
    public int[] gChecksum = new int[4];
    public final int CheckSize = 16;
    public byte[] tempCheck = new byte[16];
    public byte[][] gCheckFifo = new byte[16][4096];
    public int[] gCheckHead = new int[16];
    public int gSendCheckTail;
    public int gCheckTail;
    public boolean bOutOfSync = false;
    public int bOutOfSyncByte = 0;
    public int nConnected = 0;

    public BuildNet(BuildGame game) {
        this.game = game;
        this.gInput = this.newInstance();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 256; ++j) {
                this.gFifoInput[j][i] = this.newInstance();
            }
        }
    }

    public abstract NetInput newInstance();

    public abstract int GetPackets(byte[] var1, int var2, int var3, int var4);

    public abstract void ComputerInput(int var1);

    public void WaitForSend() {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            if (i != Mmulti.myconnectindex) {
                while (!Mmulti.canSend(i)) {
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    public int GetPackets() {
        int packbufleng;
        block7: while ((packbufleng = Mmulti.getpacket(this.packbuf)) > 0) {
            int ptr = 0;
            int nPlayer = Mmulti.otherpacket;
            byte[] p = this.packbuf;
            switch (p[ptr]) {
                case 0: {
                    ptr = this.GetMasterPacket(p, ptr + 1, packbufleng);
                    continue block7;
                }
                case 1: {
                    ptr = this.GetSlavePacket(p, ptr + 1, packbufleng, nPlayer);
                    continue block7;
                }
                case -2: {
                    continue block7;
                }
                case -6: {
                    int n = nPlayer;
                    this.playerReady[n] = (byte)(this.playerReady[n] + 1);
                    continue block7;
                }
                case -84: {
                    this.nConnected = p[++ptr] & 0xFF;
                    Mmulti.inet.message = "Waiting for other players [" + this.nConnected + " / " + Mmulti.numplayers + "]";
                    return 2;
                }
            }
            ptr = this.GetPackets(p, ptr, packbufleng, nPlayer);
        }
        return 1;
    }

    public abstract void UpdatePrediction(NetInput var1);

    public abstract void CorrectPrediction();

    public abstract void CalcChecksum();

    protected int GetMasterPacket(byte[] p, int ptr, int len) {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            if (i != Mmulti.myconnectindex) {
                this.gFifoInput[this.gNetFifoHead[i] & 0xFF][i].Reset();
                ptr = this.gFifoInput[this.gNetFifoHead[i] & 0xFF][i].GetInput(p, ptr, this.gFifoInput[this.gNetFifoHead[i] - 1 & 0xFF][i]);
                short s = i;
                this.gNetFifoHead[s] = this.gNetFifoHead[s] + 1;
            } else {
                ptr = this.gFifoInput[this.gNetFifoHead[i] & 0xFF][i].GetInput(p, ptr, this.gFifoInput[this.gNetFifoHead[i] - 1 & 0xFF][i]);
            }
            i = Mmulti.connectpoint2[i];
        }
        if ((this.gNetFifoHead[Mmulti.connecthead] - 1 & 0xF) == 0) {
            i = Mmulti.connectpoint2[Mmulti.connecthead];
            while (i >= 0) {
                int lag = p[ptr++];
                if (i == Mmulti.myconnectindex) {
                    this.otherMinLag = lag;
                }
                i = Mmulti.connectpoint2[i];
            }
        }
        while (ptr < len) {
            ptr = this.GetPacket(p, ptr, this.tempCheck, 0, 16);
            i = Mmulti.connecthead;
            while (i >= 0) {
                if (i != Mmulti.myconnectindex) {
                    System.arraycopy(this.tempCheck, 0, this.gCheckFifo[i], 16 * (this.gCheckHead[i] & 0xFF), 16);
                    short s = i;
                    this.gCheckHead[s] = this.gCheckHead[s] + 1;
                }
                i = Mmulti.connectpoint2[i];
            }
        }
        return ptr;
    }

    protected int GetSlavePacket(byte[] p, int ptr, int len, int nPlayer) {
        this.gFifoInput[this.gNetFifoHead[nPlayer] & 0xFF][nPlayer].Reset();
        ptr = this.gFifoInput[this.gNetFifoHead[nPlayer] & 0xFF][nPlayer].GetInput(p, ptr, this.gFifoInput[this.gNetFifoHead[nPlayer] - 1 & 0xFF][nPlayer]);
        int n = nPlayer;
        this.gNetFifoHead[n] = this.gNetFifoHead[n] + 1;
        while (ptr < len) {
            ptr = this.GetPacket(p, ptr, this.gCheckFifo[nPlayer], 16 * (this.gCheckHead[nPlayer] & 0xFF), 16);
            int n2 = nPlayer;
            this.gCheckHead[n2] = this.gCheckHead[n2] + 1;
        }
        return ptr;
    }

    public int GetDisconnectPacket(byte[] p, int ptr, int len, int nPlayer, DisconnectCallback deletePlayerSprite) {
        this.retransmit(nPlayer, this.packbuf, len);
        nPlayer = LittleEndian.getInt(p, ptr);
        if (nPlayer == Mmulti.myconnectindex) {
            this.game.ThrowError("nPlayer != myconnectindex");
        }
        this.WaitForAllPlayers(1000);
        if (deletePlayerSprite != null && this.game.nNetMode != BuildGame.NetMode.Single) {
            deletePlayerSprite.invoke(nPlayer);
        }
        if (nPlayer == Mmulti.connecthead) {
            Mmulti.connecthead = Mmulti.connectpoint2[Mmulti.connecthead];
            BuildGdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    BuildNet.this.NetDisconnect(Mmulti.myconnectindex);
                }
            });
            return 1;
        }
        short j = Mmulti.connecthead;
        while (j >= 0) {
            if (Mmulti.connectpoint2[j] == nPlayer) {
                Mmulti.connectpoint2[j] = Mmulti.connectpoint2[nPlayer];
                break;
            }
            j = Mmulti.connectpoint2[j];
        }
        if (Mmulti.numplayers > 1) {
            Mmulti.numplayers = (short)(Mmulti.numplayers - 1);
        }
        if (Mmulti.numplayers < 2) {
            this.game.nNetMode = BuildGame.NetMode.Single;
        }
        if (!this.WaitForAllPlayers(0)) {
            return -1;
        }
        return 1;
    }

    public int GetPacket(byte[] p, int pptr, byte[] v, int vptr, int size) {
        if (pptr + size >= p.length) {
            this.game.ThrowError("ptr + size < packbuf.length");
        }
        System.arraycopy(p, pptr, v, vptr, size);
        return pptr + size;
    }

    public int PutPacketByte(byte[] p, int ptr, int value) {
        p[ptr] = (byte)value;
        return ptr + 1;
    }

    public int PutPacket(byte[] p, int ptr, Object v, int vptr, int size) {
        if (ptr + size > p.length) {
            this.game.ThrowError("ptr + size < packbuf.length");
        }
        if (v instanceof byte[]) {
            byte[] array = (byte[])v;
            System.arraycopy(array, vptr, p, ptr, size);
            return ptr + size;
        }
        if (v instanceof int[]) {
            int[] array = (int[])v;
            for (int i = 0; i < size / 4; ++i) {
                LittleEndian.putInt(p, ptr, array[vptr + i]);
                ptr += 4;
            }
        }
        return -1;
    }

    public void sendtoall(byte[] bufptr, int messleng) {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            if (i != Mmulti.myconnectindex) {
                Mmulti.sendpacket(i, bufptr, messleng);
            }
            if (Mmulti.myconnectindex != Mmulti.connecthead) break;
            i = Mmulti.connectpoint2[i];
        }
    }

    public void retransmit(int nPlayer, byte[] bufptr, int messleng) {
        if (Mmulti.myconnectindex == Mmulti.connecthead) {
            short i = Mmulti.connectpoint2[Mmulti.connecthead];
            while (i >= 0) {
                if (i != nPlayer) {
                    Mmulti.sendpacket(i, bufptr, messleng);
                }
                i = Mmulti.connectpoint2[i];
            }
        }
    }

    public void GetNetworkInput() {
        int ptr;
        int i;
        if (Mmulti.numplayers < 2) {
            return;
        }
        short nPlayer = Mmulti.connecthead;
        while (nPlayer >= 0) {
            int n = this.gNetFifoHead[Mmulti.myconnectindex] - 1 - this.gNetFifoHead[nPlayer];
            this.myMinLag[nPlayer] = Math.min(this.myMinLag[nPlayer], n);
            this.myMaxLag = Math.max(this.myMaxLag, n);
            nPlayer = Mmulti.connectpoint2[nPlayer];
        }
        if ((this.gNetFifoHead[Mmulti.myconnectindex] & 0xF) == 0) {
            i = this.myMaxLag - this.bufferJitter;
            this.myMaxLag = 0;
            if (i > 0) {
                this.bufferJitter += 2 + i >> 2;
            } else if (i < 0) {
                this.bufferJitter -= 2 - i >> 2;
            }
        }
        if (Mmulti.myconnectindex != Mmulti.connecthead) {
            ptr = this.PutPacketByte(this.packbuf, 0, 1);
            if ((ptr = this.gFifoInput[this.gNetFifoHead[Mmulti.myconnectindex] - 1 & 0xFF][Mmulti.myconnectindex].PutInput(this.packbuf, ptr, this.gFifoInput[this.gNetFifoHead[Mmulti.myconnectindex] - 2 & 0xFF][Mmulti.myconnectindex])) == 0) {
                System.err.println("Error! Input.PutInput not implemented!");
                ptr = 1;
            }
            if ((this.gNetFifoHead[Mmulti.myconnectindex] & 0xF) == 0) {
                int i2 = this.myMinLag[Mmulti.connecthead] - this.otherMinLag;
                i2 = Pragmas.klabs(i2) > 8 ? (i2 >>= 1) : (Pragmas.klabs(i2) > 2 ? Pragmas.ksgn(i2) : 0);
                Engine.totalclock -= this.game.pEngine.ticks * i2;
                this.otherMinLag += i2;
                short nPlayer2 = Mmulti.connecthead;
                while (nPlayer2 >= 0) {
                    this.myMinLag[nPlayer2] = Integer.MAX_VALUE;
                    nPlayer2 = Mmulti.connectpoint2[nPlayer2];
                }
            }
            while (this.gSendCheckTail < this.gCheckHead[Mmulti.myconnectindex]) {
                ptr = this.PutPacket(this.packbuf, ptr, this.gCheckFifo[Mmulti.myconnectindex], 16 * (this.gSendCheckTail & 0xFF), 16);
                ++this.gSendCheckTail;
            }
            Mmulti.sendpacket(Mmulti.connecthead, this.packbuf, ptr);
            return;
        }
        i = Mmulti.connecthead;
        while (i >= 0) {
            if (this.gNetFifoHead[i] <= this.gNetFifoMasterTail) {
                this.PutPacketByte(this.packbuf, 0, -2);
                i = Mmulti.connectpoint2[Mmulti.connecthead];
                while (i >= 0) {
                    Mmulti.sendpacket(i, this.packbuf, 1);
                    i = Mmulti.connectpoint2[i];
                }
                return;
            }
            i = Mmulti.connectpoint2[i];
        }
        while (true) {
            i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.gNetFifoHead[i] <= this.gNetFifoMasterTail) {
                    return;
                }
                i = Mmulti.connectpoint2[i];
            }
            ptr = this.PutPacketByte(this.packbuf, 0, 0);
            short nPlayer3 = Mmulti.connecthead;
            while (nPlayer3 >= 0) {
                ptr = this.gFifoInput[this.gNetFifoMasterTail & 0xFF][nPlayer3].PutInput(this.packbuf, ptr, this.gFifoInput[this.gNetFifoMasterTail - 1 & 0xFF][nPlayer3]);
                nPlayer3 = Mmulti.connectpoint2[nPlayer3];
            }
            if ((this.gNetFifoMasterTail & 0xF) == 0) {
                nPlayer3 = Mmulti.connectpoint2[Mmulti.connecthead];
                while (nPlayer3 >= 0) {
                    ptr = this.PutPacketByte(this.packbuf, ptr, Gameutils.BClipRange(this.myMinLag[nPlayer3], -128, 127));
                    nPlayer3 = Mmulti.connectpoint2[nPlayer3];
                }
                nPlayer3 = Mmulti.connecthead;
                while (nPlayer3 >= 0) {
                    this.myMinLag[nPlayer3] = Integer.MAX_VALUE;
                    nPlayer3 = Mmulti.connectpoint2[nPlayer3];
                }
            }
            while (this.gSendCheckTail < this.gCheckHead[Mmulti.myconnectindex]) {
                ptr = this.PutPacket(this.packbuf, ptr, this.gCheckFifo[Mmulti.myconnectindex], 16 * (this.gSendCheckTail & 0xFF), 16);
                ++this.gSendCheckTail;
            }
            nPlayer3 = Mmulti.connectpoint2[Mmulti.connecthead];
            while (nPlayer3 >= 0) {
                Mmulti.sendpacket(nPlayer3, this.packbuf, ptr);
                nPlayer3 = Mmulti.connectpoint2[nPlayer3];
            }
            ++this.gNetFifoMasterTail;
        }
    }

    public void NetDisconnect(int nPlayer) {
        Console.Println("Disconnected!", Console.OSDTEXT_YELLOW);
        if (Mmulti.numplayers > 1) {
            this.packbuf[0] = 7;
            LittleEndian.putInt(this.packbuf, 1, nPlayer);
            this.sendtoall(this.packbuf, 5);
            this.WaitForAllPlayers(1000);
        }
        this.ResetNetwork();
        this.game.nNetMode = BuildGame.NetMode.Single;
        this.ready2send = false;
    }

    public void ResetNetwork() {
        Mmulti.uninitmultiplayer();
        Arrays.fill(this.playerReady, (byte)0);
        Arrays.fill(this.packbuf, (byte)0);
        Arrays.fill(this.gChecksum, 0);
        Arrays.fill(this.gCheckHead, 0);
        Arrays.fill(this.tempCheck, (byte)0);
        for (int i = 0; i < 16; ++i) {
            Arrays.fill(this.gCheckFifo[i], (byte)0);
        }
        this.ready2send = false;
    }

    public void ResetTimers() {
        this.game.pEngine.sampletimer();
        Engine.totalclock = 0;
        this.ototalclock = 0;
        this.gNetFifoMasterTail = 0;
        this.gPredictTail = 0;
        this.gNetFifoTail = 0;
        this.gInput.Reset();
        Arrays.fill(this.gNetFifoHead, 0);
        for (int i = 0; i < 16; ++i) {
            Arrays.fill(this.gCheckFifo[i], (byte)0);
            for (int j = 0; j < 256; ++j) {
                this.gFifoInput[j][i].Reset();
            }
        }
        Arrays.fill(this.gCheckHead, 0);
        this.gCheckTail = 0;
        this.gSendCheckTail = 0;
        Arrays.fill(this.myMinLag, 0);
        this.otherMinLag = 0;
        this.myMaxLag = 0;
        this.bufferJitter = 0;
        this.bOutOfSync = false;
        this.bOutOfSyncByte = 0;
    }

    public boolean WaitForAllPlayers(int timeout) {
        int i;
        if (Mmulti.numplayers < 2) {
            return true;
        }
        short i2 = Mmulti.connecthead;
        while (i2 >= 0) {
            if (i2 != Mmulti.myconnectindex) {
                while (!Mmulti.canSend(i2)) {
                }
            }
            i2 = Mmulti.connectpoint2[i2];
        }
        this.packbuf[0] = -6;
        this.sendtoall(this.packbuf, 1);
        short s = Mmulti.myconnectindex;
        this.playerReady[s] = (byte)(this.playerReady[s] + 1);
        long starttime = System.currentTimeMillis();
        block7: do {
            this.game.pEngine.handleevents();
            long time = System.currentTimeMillis() - starttime;
            if (timeout != 0 && time > (long)timeout) {
                Console.Println("Connection timed out!", Console.OSDTEXT_YELLOW);
                return false;
            }
            switch (this.GetPackets()) {
                case 0: {
                    return false;
                }
                case 1: {
                    break;
                }
                case 2: {
                    starttime = System.currentTimeMillis();
                }
            }
            i = Mmulti.connecthead;
            while (i >= 0 && this.playerReady[i] >= this.playerReady[Mmulti.myconnectindex]) {
                if (Mmulti.myconnectindex != Mmulti.connecthead) {
                    i = -1;
                    continue block7;
                }
                i = Mmulti.connectpoint2[i];
            }
        } while (i >= 0);
        Arrays.fill(this.playerReady, (byte)0);
        return true;
    }

    public long Checksum(byte[] p, int length) {
        int ptr = 0;
        length >>= 2;
        long sum = 0L;
        while (--length != -1) {
            sum += (long)LittleEndian.getInt(p, ptr);
            ptr += 4;
        }
        return sum;
    }

    public void CheckSync() {
        if (Mmulti.numplayers == 1) {
            return;
        }
        while (true) {
            short nPlayer = Mmulti.connecthead;
            while (nPlayer >= 0) {
                if (this.gCheckHead[nPlayer] <= this.gCheckTail) {
                    return;
                }
                nPlayer = Mmulti.connectpoint2[nPlayer];
            }
            this.bOutOfSync = false;
            nPlayer = Mmulti.connectpoint2[Mmulti.connecthead];
            while (nPlayer >= 0) {
                for (int i = 0; i < 16; ++i) {
                    if (this.gCheckFifo[nPlayer][16 * (this.gCheckTail & 0xFF) + i] == this.gCheckFifo[Mmulti.connecthead][16 * (this.gCheckTail & 0xFF) + i]) continue;
                    this.bOutOfSyncByte = i;
                    this.bOutOfSync = true;
                }
                nPlayer = Mmulti.connectpoint2[nPlayer];
            }
            ++this.gCheckTail;
        }
    }

    public void StartWaiting(final int timeout) {
        Mmulti.inet.waitThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!BuildNet.this.WaitForAllPlayers(timeout)) {
                    BuildNet.this.game.pNet.NetDisconnect(Mmulti.myconnectindex);
                }
            }
        });
        Mmulti.inet.waitThread.start();
    }

    public static interface NetInput {
        public int GetInput(byte[] var1, int var2, NetInput var3);

        public int PutInput(byte[] var1, int var2, NetInput var3);

        public void Reset();

        public NetInput Copy(NetInput var1);
    }

    public static interface DisconnectCallback {
        public void invoke(int var1);
    }
}

