/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import java.util.Arrays;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTextField;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;

public abstract class MenuCreate
extends BuildMenu {
    protected int mPlayers = 2;
    protected boolean mUseFakeMultiplayer = false;
    public MenuSlider mPlayerNum;
    public MenuTextField mPortnum;
    public MenuTextField mPlayer;
    public MenuSwitch mMenuFakeMM;
    public MenuButton mCreate;

    public MenuCreate(final BuildGame app, int posx, int posy, int menuHeight, int width, BuildFont style, int kMaxPlayers) {
        this.addItem(this.getTitle(app, "Multiplayer"), false);
        this.mPlayerNum = new MenuSlider(app.pSlider, "Number of players", style, posx, posy += menuHeight, width, this.mPlayers, 1, kMaxPlayers, 1, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                MenuCreate.this.mPlayers = slider.value;
            }
        }, true);
        this.mPortnum = new MenuTextField("Network socket number", "" + app.pCfg.mPort, style, posx, posy += menuHeight, width, 2, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuTextField item = (MenuTextField)pItem;
                if (item.typed.length() < 8) {
                    app.pCfg.mPort = Integer.parseInt(item.typed);
                } else {
                    System.arraycopy(item.otypingBuf, 0, item.typingBuf, 0, 16);
                    item.inputlen = item.oinputlen;
                }
            }
        });
        this.mPlayer = new MenuTextField("Player name", app.pCfg.pName, style, posx, posy += menuHeight, width, 3, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuTextField item = (MenuTextField)pItem;
                app.pCfg.pName = item.typed;
            }
        }){

            @Override
            public void open() {
                Arrays.fill(this.typingBuf, '\u0000');
                this.inputlen = app.pCfg.pName.length();
                System.arraycopy(app.pCfg.pName.toCharArray(), 0, this.typingBuf, 0, this.inputlen);
            }
        };
        this.mMenuFakeMM = new MenuSwitch("Use fake multiplayer", style, posx, posy += menuHeight, width, false, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                MenuCreate.this.mUseFakeMultiplayer = sw.value;
            }
        }, "Yes", "No"){

            @Override
            public void open() {
                this.value = MenuCreate.this.mUseFakeMultiplayer;
            }
        };
        this.mCreate = new MenuButton("Create", style, 0, posy + 2 * menuHeight, 320, 1, 0, null, -1, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                String[] param = new String[]{"-n0" + (MenuCreate.this.mPlayers != 2 ? ":" + MenuCreate.this.mPlayers : ""), app.pCfg.mPort != 23513 ? "-p " + app.pCfg.mPort : null};
                MenuCreate.this.createGame(MenuCreate.this.mPlayers, MenuCreate.this.mUseFakeMultiplayer, param);
            }
        }, 0);
        this.addItem(this.mPlayerNum, true);
        this.addItem(this.mPortnum, false);
        this.addItem(this.mPlayer, false);
        this.addItem(this.mMenuFakeMM, false);
        this.addItem(this.mCreate, false);
    }

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public abstract void createGame(int var1, boolean var2, String[] var3);
}

