/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import java.util.Arrays;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuTextField;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;

public abstract class MenuJoin
extends BuildMenu {
    public MenuTextField mPortnum;
    public MenuTextField mPlayer;
    public MenuTextField mIPAddress;
    public MenuButton mConnect;

    public MenuJoin(final BuildGame app, int posx, int posy, int menuHeight, int width, BuildFont style) {
        this.addItem(this.getTitle(app, "Join a game"), false);
        this.mPortnum = new MenuTextField("Network socket number", "" + app.pCfg.mPort, style, posx, posy += menuHeight, width, 2, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuTextField item = (MenuTextField)pItem;
                if (item.typed.length() < 8) {
                    app.pCfg.mPort = Integer.parseInt(item.typed);
                } else {
                    System.arraycopy(item.otypingBuf, 0, item.typingBuf, 0, 16);
                    item.inputlen = item.oinputlen;
                }
            }
        });
        this.mPlayer = new MenuTextField("Player name", app.pCfg.pName, style, posx, posy += menuHeight, width, 3, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuTextField item = (MenuTextField)pItem;
                app.pCfg.pName = item.typed;
            }
        }){

            @Override
            public void open() {
                Arrays.fill(this.typingBuf, '\u0000');
                this.inputlen = app.pCfg.pName.length();
                System.arraycopy(app.pCfg.pName.toCharArray(), 0, this.typingBuf, 0, this.inputlen);
            }
        };
        this.mIPAddress = new MenuTextField("IP Address", app.pCfg.mAddress, style, posx, posy += menuHeight, width, 11, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuTextField item = (MenuTextField)pItem;
                app.pCfg.mAddress = item.typed;
            }
        }){

            @Override
            public void open() {
                Arrays.fill(this.typingBuf, '\u0000');
                this.inputlen = app.pCfg.mAddress.length();
                System.arraycopy(app.pCfg.mAddress.toCharArray(), 0, this.typingBuf, 0, this.inputlen);
            }
        };
        this.mConnect = new MenuButton("Connect", style, 0, posy + 2 * menuHeight, 320, 1, 0, null, -1, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                if (app.pCfg.mAddress.isEmpty()) {
                    return;
                }
                String[] param = new String[]{"-n0", app.pCfg.mAddress, app.pCfg.mPort != 23513 ? "-p " + app.pCfg.mPort : null};
                MenuJoin.this.joinGame(param);
            }
        }, 0);
        this.addItem(this.mPortnum, true);
        this.addItem(this.mPlayer, false);
        this.addItem(this.mIPAddress, false);
        this.addItem(this.mConnect, false);
    }

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public abstract void joinGame(String[] var1);
}

