/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import java.io.File;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuPicnum;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuScroller;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlotList;
import ru.m210projects.Build.Pattern.MenuItems.MenuText;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Pattern.Tools.SaveManager;

public abstract class MenuLoadSave
extends BuildMenu {
    public MenuPicnum picnum;
    public MenuSlotList list;
    public MenuScroller slider;
    public MenuText mInfo;

    public MenuLoadSave(BuildGame app, BuildFont style, int posx, int posy, int posyHelp, int width, int nItems, int listPal, int specPal, int nBackground, MenuProc confirm, boolean saveMenu) {
        this.addItem(this.getTitle(app, saveMenu ? "Save game" : "Load game"), false);
        this.picnum = this.getPicnum(app.pEngine, posx, posy);
        MenuProc updateCallback = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlotList pSlot = (MenuSlotList)pItem;
                MenuLoadSave.this.picnum.nTile = MenuLoadSave.this.loadData(pSlot.FileName()) ? SaveManager.Screenshot : MenuLoadSave.this.picnum.defTile;
            }
        };
        this.list = new MenuSlotList(app.pEngine, app.pSavemgr, style, posx, posy, posyHelp, width, nItems, updateCallback, confirm, listPal, specPal, nBackground, saveMenu){

            @Override
            public boolean checkFile(String filename) {
                return MenuLoadSave.this.checkFile(filename);
            }
        };
        this.slider = new MenuScroller(app.pSlider, this.list, width + posx - app.pSlider.getScrollerWidth());
        this.mInfo = this.getInfo(app, posx, posy);
        this.addItem(this.picnum, false);
        this.addItem(this.mInfo, false);
        this.addItem(this.list, true);
        this.addItem(this.slider, false);
    }

    public boolean checkFile(String filename) {
        File file = new File(Compat.Path.User.getPath() + filename);
        return file.exists();
    }

    public abstract boolean loadData(String var1);

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public abstract MenuPicnum getPicnum(Engine var1, int var2, int var3);

    public abstract MenuText getInfo(BuildGame var1, int var2, int var3);
}

