/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.MenuScroller;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Settings.BuildConfig;

public abstract class MenuHandler {
    public int mCount = 0;
    public BuildMenu[] mMenuHistory = new BuildMenu[10];
    public boolean gShowMenu;
    protected boolean mUseMouse;
    private float keycount = 0.0f;
    private final float hitTime = 0.5f;
    private final float changeTime = 0.05f;

    public abstract int getShade(MenuItem var1);

    public abstract int getPal(BuildFont var1, MenuItem var2);

    public abstract void mPostDraw(MenuItem var1);

    public abstract void mDrawMouse(int var1, int var2);

    public abstract void mDrawBackButton();

    public abstract boolean mCheckBackButton(int var1, int var2);

    public abstract void mSound(MenuItem var1, MenuOpt var2);

    public MenuOpt mUpdateMouse(BuildControls input) {
        short focus;
        if (BuildGdx.input.getDeltaX() != 0 || BuildGdx.input.getDeltaY() != 0) {
            this.mUseMouse = true;
        }
        if (!this.mUseMouse) {
            return null;
        }
        int mx = Gameutils.BClipRange(BuildGdx.input.getX(), 0, Engine.xdim);
        int my = Gameutils.BClipRange(BuildGdx.input.getY(), 0, Engine.ydim);
        if (!input.ctrlMenuMouse()) {
            return null;
        }
        BuildMenu pMenu = this.mMenuHistory[0];
        if (this.mCount > 1 && this.mCheckBackButton(mx, my) && input.ctrlKeyStatusOnce(226)) {
            this.mMenuBack();
            return null;
        }
        MenuOpt opt = null;
        if (pMenu.m_nFocus != -1 && pMenu.mCheckMouseFlag(pMenu.m_nFocus)) {
            if (pMenu.m_pItems[pMenu.m_nFocus] instanceof MenuSlider || pMenu.m_pItems[pMenu.m_nFocus] instanceof MenuScroller || pMenu.m_pItems[pMenu.m_nFocus] instanceof MenuFileBrowser || pMenu.m_pItems[pMenu.m_nFocus] instanceof MenuKeyboardList && ((MenuKeyboardList)pMenu.m_pItems[pMenu.m_nFocus]).l_set == 0) {
                if (input.ctrlKeyStatus(226)) {
                    opt = MenuOpt.LMB;
                }
            } else if (input.ctrlKeyStatusOnce(226)) {
                opt = MenuOpt.LMB;
            }
        }
        if (input.ctrlKeyStatusOnce(227)) {
            opt = MenuOpt.RMB;
        }
        if (input.ctrlKeyStatusOnce(224)) {
            opt = MenuOpt.MWUP;
        }
        if (input.ctrlKeyStatusOnce(225)) {
            opt = MenuOpt.MWDW;
        }
        if ((focus = this.mCheckButton(pMenu, input, mx, my)) != -1 && pMenu.mCheckItemsFlags(focus) && this.mUseMouse) {
            if (pMenu.m_nFocus != focus) {
                opt = MenuOpt.MCHANGE;
            }
            pMenu.m_nFocus = focus;
        }
        return opt;
    }

    private short mCheckButton(BuildMenu pMenu, BuildControls input, int x, int y) {
        int oxdim = Engine.xdim;
        int xdim = 4 * Engine.ydim / 3;
        int normxofs = x - oxdim / 2;
        int touchX = Pragmas.scale(normxofs, 320L, xdim) + 160;
        int touchY = Pragmas.mulscale(y, Pragmas.divscale(200L, Engine.ydim, 16), 16);
        for (short i = 0; i < pMenu.m_pItems.length; i = (short)((short)(i + 1))) {
            if (!pMenu.mCheckMouseFlag(i) || !pMenu.m_pItems[i].mouseAction(touchX, touchY) || input.ctrlKeyStatus(226)) continue;
            return i;
        }
        return -1;
    }

    public void mKeyHandler(BuildControls input, float delta) {
        BuildMenu pMenu = this.mMenuHistory[0];
        if (pMenu != null) {
            MenuOpt mopt;
            MenuOpt opt = MenuOpt.ANY;
            if (input.ctrlPadStatusOnce(BuildConfig.GameKeys.Menu_Toggle)) {
                this.mClose();
                return;
            }
            if (input.ctrlKeyStatusOnce(19) || input.ctrlPadStatusOnce(BuildConfig.MenuKeys.Menu_Up)) {
                opt = MenuOpt.UP;
            }
            if (input.ctrlKeyStatusOnce(20) || input.ctrlPadStatusOnce(BuildConfig.MenuKeys.Menu_Down)) {
                opt = MenuOpt.DW;
            }
            if (input.ctrlKeyStatusOnce(21) || input.ctrlPadStatusOnce(BuildConfig.MenuKeys.Menu_Left)) {
                opt = MenuOpt.LEFT;
            }
            if (input.ctrlKeyStatusOnce(22) || input.ctrlPadStatusOnce(BuildConfig.MenuKeys.Menu_Right)) {
                opt = MenuOpt.RIGHT;
            }
            if (input.ctrlKeyStatusOnce(66) || input.ctrlPadStatusOnce(BuildConfig.MenuKeys.Menu_Enter)) {
                opt = MenuOpt.ENTER;
            }
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true) || input.ctrlPadStatusOnce(BuildConfig.MenuKeys.Menu_Cancel)) {
                opt = MenuOpt.ESC;
            }
            if (input.ctrlKeyStatusOnce(62)) {
                opt = MenuOpt.SPACE;
            }
            if (input.ctrlKeyStatusOnce(67)) {
                opt = MenuOpt.BSPACE;
            }
            if (input.ctrlKeyStatusOnce(112)) {
                opt = MenuOpt.DELETE;
            }
            if (input.ctrlKeyStatusOnce(92)) {
                opt = MenuOpt.PGUP;
            }
            if (input.ctrlKeyStatusOnce(93)) {
                opt = MenuOpt.PGDW;
            }
            if (input.ctrlKeyStatusOnce(3)) {
                opt = MenuOpt.HOME;
            }
            if (input.ctrlKeyStatusOnce(132)) {
                opt = MenuOpt.END;
            }
            if (opt != MenuOpt.ANY) {
                this.mUseMouse = false;
            }
            if ((mopt = this.mUpdateMouse(input)) != null) {
                opt = mopt;
            }
            if (pMenu.mLoadRes(this, opt)) {
                this.mMenuBack();
            }
            if (!BuildGdx.input.isTouched() && input.ctrlKeyStatus(256) && opt != MenuOpt.ENTER && opt != MenuOpt.ESC) {
                this.keycount += delta;
                if (this.keycount >= 0.5f && this.keycount >= 0.55f) {
                    input.ctrlResetInput();
                    this.keycount = 0.5f;
                }
            } else {
                this.keycount = 0.0f;
            }
        }
    }

    public void mOpen(BuildMenu pMenu, int nItem) {
        if (pMenu == null || this.mCount == 8) {
            return;
        }
        this.mMenuHistory[0] = pMenu;
        this.mMenuHistory[++this.mCount] = pMenu;
        pMenu.open(this, nItem);
        this.gShowMenu = true;
        BuildGdx.input.setCursorCatched(false);
    }

    public void mClose() {
        Arrays.fill(this.mMenuHistory, null);
        this.mCount = 0;
        this.gShowMenu = false;
        if (!BuildGdx.app.isActive()) {
            return;
        }
        BuildGdx.input.setCursorCatched(true);
        BuildGdx.input.setCursorPosition(Engine.xdim / 2, Engine.ydim / 2);
    }

    public void mMenuBack() {
        if (this.mCount > 0) {
            if (this.mMenuHistory[0] != null) {
                this.mMenuHistory[0].mLoadRes(this, MenuOpt.Close);
            }
            this.mCount = Gameutils.BClipLow(this.mCount - 1, 0);
            if (this.mCount > 0) {
                this.mMenuHistory[0] = this.mMenuHistory[this.mCount];
            } else {
                this.mClose();
            }
        }
    }

    public void mMenuBack(MenuOpt opt) {
        if (this.mCount > 0) {
            if (this.mMenuHistory[0] != null) {
                this.mMenuHistory[0].mLoadRes(this, MenuOpt.Close);
            }
            this.mCount = Gameutils.BClipLow(this.mCount - 1, 0);
            if (this.mCount > 0) {
                this.mMenuHistory[0] = this.mMenuHistory[this.mCount];
                this.mMenuHistory[0].mLoadRes(this, opt);
            } else {
                this.mClose();
            }
        }
    }

    public BuildMenu getCurrentMenu() {
        return this.mMenuHistory[0];
    }

    public BuildMenu getLastMenu() {
        if (this.mCount > 0) {
            return this.mMenuHistory[this.mCount - 1];
        }
        return this.getCurrentMenu();
    }

    public boolean isOpened(BuildMenu pMenu) {
        return pMenu != null && this.getCurrentMenu() == pMenu;
    }

    public void mDrawMenu() {
        if (this.mMenuHistory[0] != null) {
            this.mMenuHistory[0].mDraw(this);
        }
        this.mDrawBackButton();
        if (this.mUseMouse) {
            this.mDrawMouse(BuildGdx.input.getX(), BuildGdx.input.getY());
        }
    }

    public static enum MenuOpt {
        NONE,
        ANY,
        UP,
        DW,
        LEFT,
        RIGHT,
        ENTER,
        ESC,
        SPACE,
        BSPACE,
        DELETE,
        LMB,
        PGUP,
        PGDW,
        HOME,
        END,
        MWUP,
        MWDW,
        RMB,
        MCHANGE,
        Open,
        Close;

    }
}

